/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.ui.analysis;

import com.nvidia.viper.analysis.AnalysisResult;
import com.nvidia.viper.analysis.AnalysisResultKernelBounds;
import com.nvidia.viper.chart.ui.ChartCanvas;
import com.nvidia.viper.chart.ui.IViperChart;
import com.nvidia.viper.model.Session;
import com.nvidia.viper.ui.analysis.AnalysisResultControl;
import com.nvidia.viper.ui.chart.KernelBoundsAnalysisChart;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public final class KernelBoundsControl
extends AnalysisResultControl {
    public KernelBoundsControl(Composite parent, AnalysisResult result, Session session) {
        super(parent, result, session, true);
    }

    @Override
    protected boolean allowsSelection() {
        return false;
    }

    @Override
    protected boolean hasExtension() {
        return true;
    }

    @Override
    protected void createExtension(Composite parent) {
        Control charts = this.createCharts(parent);
        charts.setLayoutData((Object)new GridData(0x1000000, 128, true, false));
    }

    private Control createCharts(Composite parent) {
        ChartCanvas canvas = new ChartCanvas(parent, 0);
        AnalysisResultKernelBounds boundsResult = this.getResult();
        if (boundsResult.isIssueSlotBound()) {
            canvas.setChart((IViperChart)new KernelBoundsAnalysisChart(boundsResult.getMemoryUtilization(), boundsResult.getMemoryBound(), boundsResult.getArithUtilization(), boundsResult.getControlFlowUtilization(), boundsResult.getLoadStoreUtilization()));
        } else {
            canvas.setChart((IViperChart)new KernelBoundsAnalysisChart(boundsResult.getMemoryUtilization(), boundsResult.getMemoryBound(), boundsResult.getFunctionUnitUtilization(), boundsResult.getFunctionUnitBound()));
        }
        return canvas;
    }

    private AnalysisResultKernelBounds getResult() {
        return (AnalysisResultKernelBounds)this.result;
    }

    @Override
    public boolean grabsVerticalSpace() {
        return false;
    }
}

