/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.ui.analysis;

import com.nvidia.cuda.ide.util.ColumnsDragSupport;
import com.nvidia.viper.ViperExceptionHandler;
import com.nvidia.viper.ViperMessages;
import com.nvidia.viper.activity.CuptiActivitySourceLocator;
import com.nvidia.viper.activity.ICuptiActivitySourceLevelResult;
import com.nvidia.viper.analysis.AnalysisResult;
import com.nvidia.viper.analysis.AnalysisResultSourceLevel;
import com.nvidia.viper.editor.SourceSassEditorInput;
import com.nvidia.viper.model.Session;
import com.nvidia.viper.model.SourceSassModel;
import com.nvidia.viper.ui.ViperMessageDialog;
import com.nvidia.viper.ui.analysis.AnalysisResultControl;
import com.nvidia.viper.ui.analysis.SourceLevelLocatedResult;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public class SourceLevelResultControl
extends AnalysisResultControl {
    private static final String noSourceInfoString = "NA";

    public SourceLevelResultControl(Composite parent, AnalysisResult result, Session session) {
        super(parent, result, session);
    }

    @Override
    protected boolean allowsSelection() {
        return false;
    }

    @Override
    protected boolean hasExtension() {
        return true;
    }

    @Override
    protected void createExtension(Composite parent) {
        TreeViewer locTreeViewer = new TreeViewer(parent, 65536);
        locTreeViewer.getTree().setLayoutData((Object)new GridData(4, 4, true, true));
        locTreeViewer.setContentProvider((IContentProvider)new SourceLocationContentProvider());
        locTreeViewer.setLabelProvider((IBaseLabelProvider)new SourceLocationLabelProvider());
        locTreeViewer.getTree().setHeaderVisible(false);
        locTreeViewer.getTree().setLinesVisible(true);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)locTreeViewer);
        locTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object el;
                ISelection sel = event.getSelection();
                if (sel instanceof IStructuredSelection && (el = ((IStructuredSelection)sel).getFirstElement()) instanceof SourceLevelLocatedResult) {
                    SourceLevelResultControl.this.handleLocationSelection((SourceLevelLocatedResult)el);
                }
            }
        });
        TreeColumn locColumn = new TreeColumn(locTreeViewer.getTree(), 131072);
        locColumn.setText("Location");
        locColumn.setWidth(50);
        locColumn.setResizable(true);
        TreeColumn descColumn = new TreeColumn(locTreeViewer.getTree(), 16384);
        descColumn.setText("Description");
        descColumn.setResizable(true);
        locTreeViewer.setInput((Object)this.getSourceLevelResult());
        locTreeViewer.expandAll();
        new ColumnsDragSupport(locTreeViewer.getTree());
        locColumn.pack();
        descColumn.pack();
    }

    private AnalysisResultSourceLevel getSourceLevelResult() {
        return (AnalysisResultSourceLevel)this.result;
    }

    private void handleLocationSelection(SourceLevelLocatedResult location) {
        try {
            IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            SourceSassModel model = new SourceSassModel(this.activeSession, this.getSourceLevelResult(), location.fileName.toString(), location.lineNumber);
            activePage.openEditor((IEditorInput)new SourceSassEditorInput(model), "com.nvidia.viper.sourcesasseditor");
        }
        catch (CoreException e) {
            ViperMessageDialog.openWarning(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), ViperMessages.AnalysisSource_Fail_Title, ViperMessages.AnalysisSource_Fail_Message);
            ViperExceptionHandler.logError("unable to open analysis source", e);
        }
    }

    @Override
    public boolean grabsVerticalSpace() {
        return false;
    }

    private class SourceLocationContentProvider
    implements ITreeContentProvider {
        private final Object[] EMPTY_ARRAY = new Object[0];
        private Map<URI, Set<SourceLevelLocatedResult>> locations;

        private SourceLocationContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (newInput instanceof AnalysisResultSourceLevel) {
                AnalysisResultSourceLevel input = (AnalysisResultSourceLevel)newInput;
                this.locations = new HashMap<URI, Set<SourceLevelLocatedResult>>();
                for (ICuptiActivitySourceLevelResult result : input.getMarkerSourceLevelResults()) {
                    int lineNumber;
                    URI uri;
                    CuptiActivitySourceLocator locator = SourceLevelResultControl.this.activeSession.getSourceLocator().getLocation(result.getSourceLocatorId());
                    if (locator == null) {
                        ViperExceptionHandler.logError("unable to get source location " + result.getSourceLocatorId());
                        try {
                            uri = new URI(SourceLevelResultControl.noSourceInfoString);
                        }
                        catch (URISyntaxException uRISyntaxException) {
                            uri = new File(SourceLevelResultControl.noSourceInfoString).toURI();
                        }
                        lineNumber = 0;
                    } else {
                        uri = locator.getFileUri();
                        lineNumber = locator.lineNumber;
                    }
                    Set<SourceLevelLocatedResult> results = this.locations.get(uri);
                    if (results == null) {
                        results = new HashSet<SourceLevelLocatedResult>();
                        this.locations.put(uri, results);
                    }
                    results.add(new SourceLevelLocatedResult(uri, lineNumber, result));
                }
            }
        }

        public Object[] getElements(Object inputElement) {
            if (this.locations != null) {
                Object[] filenames = this.locations.keySet().toArray(new URI[0]);
                Arrays.sort(filenames);
                return filenames;
            }
            return this.EMPTY_ARRAY;
        }

        public Object getParent(Object element) {
            if (element instanceof SourceLevelLocatedResult) {
                return ((SourceLevelLocatedResult)element).fileName;
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return element instanceof URI;
        }

        public Object[] getChildren(Object parentElement) {
            Set<SourceLevelLocatedResult> results;
            if (parentElement instanceof URI && (results = this.locations.get(parentElement)) != null) {
                Object[] resultsArray = results.toArray(new SourceLevelLocatedResult[0]);
                Arrays.sort(resultsArray, new Comparator<SourceLevelLocatedResult>(){

                    @Override
                    public int compare(SourceLevelLocatedResult o1, SourceLevelLocatedResult o2) {
                        return o1.lineNumber - o2.lineNumber;
                    }
                });
                return resultsArray;
            }
            return this.EMPTY_ARRAY;
        }

        public void dispose() {
            this.locations = null;
        }
    }

    private class SourceLocationLabelProvider
    extends StyledCellLabelProvider {
        private SourceLocationLabelProvider() {
        }

        public boolean useNativeToolTip(Object object) {
            return true;
        }

        public String getToolTipText(Object element) {
            if (element instanceof URI) {
                return ((URI)element).getPath();
            }
            return null;
        }

        public void update(ViewerCell cell) {
            Object[] newStyleRanges;
            Object element = cell.getElement();
            StyledString styledString = this.getStyledText(element, cell.getColumnIndex());
            String newText = styledString.toString();
            Object[] oldStyleRanges = cell.getStyleRanges();
            Object[] objectArray = newStyleRanges = this.isOwnerDrawEnabled() ? styledString.getStyleRanges() : null;
            if (!Arrays.equals(oldStyleRanges, newStyleRanges)) {
                cell.setStyleRanges((StyleRange[])newStyleRanges);
                if (cell.getText().equals(newText)) {
                    cell.setText("");
                }
            }
            cell.setText(newText);
        }

        private StyledString getStyledText(Object element, int columnIndex) {
            String text = null;
            if (columnIndex == 0) {
                if (element instanceof URI) {
                    Path path = new Path(((URI)element).getPath());
                    text = path.isEmpty() ? path.toOSString() : "Line / File";
                } else if (element instanceof SourceLevelLocatedResult) {
                    int lineNumber = ((SourceLevelLocatedResult)element).lineNumber;
                    text = lineNumber == 0 ? SourceLevelResultControl.noSourceInfoString : String.valueOf(lineNumber);
                }
            } else if (columnIndex == 1) {
                if (element instanceof SourceLevelLocatedResult) {
                    text = SourceLevelResultControl.this.getSourceLevelResult().getResultDescription(((SourceLevelLocatedResult)element).result);
                } else {
                    Path path = new Path(((URI)element).getPath());
                    if (path.isEmpty()) {
                        text = "";
                    } else if (path.toString().equals(SourceLevelResultControl.noSourceInfoString)) {
                        text = SourceLevelResultControl.noSourceInfoString;
                    } else {
                        StyledString p = new StyledString();
                        p.append(path.lastSegment());
                        p.append(" - ", StyledString.DECORATIONS_STYLER);
                        p.append(path.removeLastSegments(1).toOSString(), StyledString.DECORATIONS_STYLER);
                        return p;
                    }
                }
            }
            return new StyledString(text);
        }
    }
}

