/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.codan.core.cxx.internal.externaltool;

import java.io.File;
import org.eclipse.cdt.codan.core.cxx.externaltool.ArgsSeparator;
import org.eclipse.cdt.codan.core.cxx.externaltool.ConfigurationSettings;
import org.eclipse.cdt.codan.core.cxx.externaltool.InvocationParameters;
import org.eclipse.cdt.codan.core.cxx.internal.externaltool.Command;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

class CommandBuilder {
    CommandBuilder() {
    }

    Command buildCommand(InvocationParameters parameters, ConfigurationSettings settings, ArgsSeparator argsSeparator) {
        IPath executablePath = this.executablePath(settings);
        String[] args = this.argsToPass(parameters, settings, argsSeparator);
        return new Command(executablePath, args);
    }

    private IPath executablePath(ConfigurationSettings configurationSettings) {
        File executablePath = configurationSettings.getPath().getValue();
        return new Path(executablePath.toString());
    }

    private String[] argsToPass(InvocationParameters parameters, ConfigurationSettings configurationSettings, ArgsSeparator argsSeparator) {
        String actualFilePath = parameters.getActualFilePath();
        String[] args = this.configuredArgs(configurationSettings, argsSeparator);
        return this.addFilePathToArgs(actualFilePath, args);
    }

    private String[] configuredArgs(ConfigurationSettings settings, ArgsSeparator argsSeparator) {
        String args = settings.getArgs().getValue();
        return argsSeparator.splitArguments(args);
    }

    private String[] addFilePathToArgs(String actualFilePath, String[] configuredArgs) {
        int argCount = configuredArgs.length;
        String[] allArgs = new String[argCount + 1];
        allArgs[0] = actualFilePath;
        System.arraycopy(configuredArgs, 0, allArgs, 1, argCount);
        return allArgs;
    }
}

