/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.codan.core.cxx.internal.externaltool;

import java.io.OutputStream;
import org.eclipse.cdt.codan.core.cxx.externaltool.ArgsSeparator;
import org.eclipse.cdt.codan.core.cxx.externaltool.ConfigurationSettings;
import org.eclipse.cdt.codan.core.cxx.externaltool.InvocationFailure;
import org.eclipse.cdt.codan.core.cxx.externaltool.InvocationParameters;
import org.eclipse.cdt.codan.core.cxx.internal.externaltool.Command;
import org.eclipse.cdt.codan.core.cxx.internal.externaltool.CommandBuilder;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.CommandLauncher;
import org.eclipse.cdt.core.ICommandLauncher;
import org.eclipse.cdt.core.IConsoleParser;
import org.eclipse.cdt.core.resources.IConsole;
import org.eclipse.cdt.internal.core.ConsoleOutputSniffer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class ExternalToolInvoker {
    private static final String DEFAULT_CONTEXT_MENU_ID = "org.eclipse.cdt.ui.CDTBuildConsole";
    private static final String[] ENV = new String[0];
    private static final NullProgressMonitor NULL_PROGRESS_MONITOR = new NullProgressMonitor();
    private final CommandBuilder commandBuilder = new CommandBuilder();

    public void invoke(InvocationParameters parameters, ConfigurationSettings settings, ArgsSeparator argsSeparator, IConsoleParser[] parsers) throws InvocationFailure, Throwable {
        Command command = this.commandBuilder.buildCommand(parameters, settings, argsSeparator);
        try {
            this.launchCommand(command, parsers, parameters, settings);
        }
        finally {
            this.shutDown(parsers);
        }
    }

    private void launchCommand(Command command, IConsoleParser[] parsers, InvocationParameters parameters, ConfigurationSettings settings) throws InvocationFailure, CoreException {
        IProject project = parameters.getActualFile().getProject();
        IConsole c = this.startConsole(project, settings.getExternalToolName());
        ConsoleOutputSniffer sniffer = new ConsoleOutputSniffer((OutputStream)c.getOutputStream(), (OutputStream)c.getErrorStream(), parsers);
        ICommandLauncher launcher = this.commandLauncher(project);
        Process p = launcher.execute(command.getPath(), command.getArgs(), ENV, parameters.getWorkingDirectory(), (IProgressMonitor)NULL_PROGRESS_MONITOR);
        if (p == null) {
            String format = "Unable to launch external tool '%s'. Cause unknown.";
            throw new InvocationFailure(String.format(format, settings.getExternalToolName()));
        }
        try {
            p.getOutputStream().close();
        }
        catch (Throwable throwable) {}
        try {
            launcher.waitAndRead(sniffer.getOutputStream(), sniffer.getErrorStream(), (IProgressMonitor)NULL_PROGRESS_MONITOR);
        }
        finally {
            p.destroy();
        }
    }

    private IConsole startConsole(IProject project, String externalToolName) {
        IConsole console = CCorePlugin.getDefault().getConsole(null, DEFAULT_CONTEXT_MENU_ID, externalToolName, null);
        console.start(project);
        return console;
    }

    private ICommandLauncher commandLauncher(IProject project) {
        CommandLauncher launcher = new CommandLauncher();
        launcher.showCommand(true);
        launcher.setProject(project);
        return launcher;
    }

    private void shutDown(IConsoleParser[] parsers) {
        IConsoleParser[] iConsoleParserArray = parsers;
        int n = parsers.length;
        int n2 = 0;
        while (n2 < n) {
            IConsoleParser parser = iConsoleParserArray[n2];
            parser.shutdown();
            ++n2;
        }
    }
}

