/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.css.engine.value.css;

import org.eclipse.birt.report.engine.css.engine.CSSEngine;
import org.eclipse.birt.report.engine.css.engine.value.AbstractValueManager;
import org.eclipse.birt.report.engine.css.engine.value.FloatValue;
import org.eclipse.birt.report.engine.css.engine.value.Value;
import org.eclipse.birt.report.engine.css.engine.value.css.CSSValueConstants;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.dom.DOMException;

public class IntegerManager
extends AbstractValueManager {
    String propertyName;
    boolean inherit;
    int defaultValue;

    public IntegerManager(String propertyName, boolean inherit, int defaultValue) {
        this.propertyName = propertyName;
        this.inherit = inherit;
        this.defaultValue = defaultValue;
    }

    @Override
    public String getPropertyName() {
        return this.propertyName;
    }

    @Override
    public boolean isInheritedProperty() {
        return this.inherit;
    }

    @Override
    public Value getDefaultValue() {
        return new FloatValue(1, this.defaultValue);
    }

    @Override
    public Value createValue(LexicalUnit lu, CSSEngine engine) throws DOMException {
        switch (lu.getLexicalUnitType()) {
            case 12: {
                return CSSValueConstants.INHERIT_VALUE;
            }
            case 13: {
                return new FloatValue(1, lu.getIntegerValue());
            }
        }
        throw this.createInvalidLexicalUnitDOMException(lu.getLexicalUnitType());
    }
}

