/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.debug.model;

import com.nvidia.cuda.ide.debug.model.CudaCoord;
import com.nvidia.cuda.ide.debug.model.CudaDim;
import java.io.Serializable;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class CudaRange
implements Comparable<CudaRange>,
Serializable {
    private static final long serialVersionUID = 3076121783781159809L;
    private final CudaCoord start;
    private final CudaCoord end;

    public CudaRange(CudaCoord start, CudaCoord end) {
        assert (start.compareTo(end) <= 0);
        this.start = start;
        this.end = end;
    }

    public CudaCoord getStart() {
        return this.start;
    }

    public CudaCoord getEnd() {
        return this.end;
    }

    public boolean contains(CudaCoord coord, CudaDim dim) {
        long s = dim.getOrdinal(this.start);
        long e = dim.getOrdinal(this.end);
        long v = dim.getOrdinal(coord);
        return v >= s && v <= e;
    }

    public int hashCode() {
        return this.start.hashCode() >> 5 ^ this.end.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CudaRange other = (CudaRange)obj;
        if (this.end == null ? other.end != null : !this.end.equals(other.end)) {
            return false;
        }
        return !(this.start == null ? other.start != null : !this.start.equals(other.start));
    }

    public String toString() {
        return String.format("%s-%s", this.start, this.end);
    }

    @Override
    public int compareTo(CudaRange o) {
        int starts = this.start.compareTo(o.getStart());
        if (starts == 0) {
            return this.end.compareTo(o.getEnd());
        }
        return starts;
    }

    public static CudaRange parse(String from, String to) {
        return new CudaRange(CudaCoord.parse(from), CudaCoord.parse(to));
    }

    public Iterable<CudaCoord> getCoords(final CudaDim range) {
        return new Iterable<CudaCoord>(){

            @Override
            public Iterator<CudaCoord> iterator() {
                return new CoordIterator(range);
            }
        };
    }

    public boolean isSingleEntry() {
        return this.start.equals(this.end);
    }

    private final class CoordIterator
    implements Iterator<CudaCoord> {
        private final CudaDim dim;
        private long i = 0L;
        private final long rangeEnd;

        public CoordIterator(CudaDim dim) {
            this.dim = dim;
            this.i = dim.getOrdinal(CudaRange.this.getStart());
            this.rangeEnd = dim.getOrdinal(CudaRange.this.getEnd());
        }

        @Override
        public boolean hasNext() {
            return this.i <= this.rangeEnd;
        }

        @Override
        public CudaCoord next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.dim.getCoord(this.i++);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

