/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.debug.model.query;

import com.nvidia.cuda.ide.debug.core.Activator;
import com.nvidia.cuda.ide.debug.model.Block;
import com.nvidia.cuda.ide.debug.model.CudaCoord;
import com.nvidia.cuda.ide.debug.model.CudaException;
import com.nvidia.cuda.ide.debug.model.CudaRange;
import com.nvidia.cuda.ide.debug.model.Device;
import com.nvidia.cuda.ide.debug.model.DeviceThread;
import com.nvidia.cuda.ide.debug.model.ElementType;
import com.nvidia.cuda.ide.debug.model.ICudaRuntimeObject;
import com.nvidia.cuda.ide.debug.model.Kernel;
import com.nvidia.cuda.ide.debug.model.StreamingMultiprocessor;
import com.nvidia.cuda.ide.debug.model.Warp;
import com.nvidia.cuda.ide.debug.model.query.IFilterCondition;
import java.util.ArrayList;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;

public final class LogicalVerticalCondition
implements IFilterCondition {
    private final long kernelId;
    private final CudaCoord blockIdx;
    private final CudaRange threadRange;

    public LogicalVerticalCondition(long kernel, CudaCoord blockIdx, CudaRange threads) {
        this.kernelId = kernel;
        this.blockIdx = blockIdx;
        this.threadRange = threads;
    }

    public LogicalVerticalCondition(long kernel, CudaCoord blockIdx, CudaCoord threadIdx) {
        this(kernel, blockIdx, threadIdx != null ? new CudaRange(threadIdx, threadIdx) : null);
    }

    @Override
    public boolean isAllElements() {
        return this.kernelId < 0L && this.blockIdx == null && this.threadRange == null;
    }

    @Override
    public boolean matches(ICudaRuntimeObject o) {
        switch (o.getType()) {
            case thread: {
                DeviceThread thread = (DeviceThread)o;
                return (this.threadRange == null || this.threadRange.contains(thread.getThreadIdx(), ((Kernel)DMContexts.getAncestorOfType((IDMContext)thread, Kernel.class)).getBlockDim())) && this.matches((ICudaRuntimeObject)DMContexts.getAncestorOfType((IDMContext)thread, Block.class));
            }
            case block: {
                Block block = (Block)o;
                return (this.blockIdx == null || this.blockIdx.equals(block.getBlockIdx())) && this.matches((ICudaRuntimeObject)DMContexts.getAncestorOfType((IDMContext)block, Kernel.class));
            }
            case kernel: {
                return this.matchKernel((Kernel)o);
            }
        }
        return false;
    }

    private boolean matchKernel(Kernel kernel) {
        try {
            CudaCoord[] blocks;
            if (!(this.kernelId >= 0L && this.kernelId != kernel.getId() || (blocks = this.filterBlocks(kernel)) != null && blocks.length == 0)) {
                CudaCoord[] threads = this.filterThreads(kernel.getBlock(CudaCoord.ZERO));
                return threads == null || threads.length > 0;
            }
        }
        catch (CudaException e) {
            Activator.log(e);
        }
        return false;
    }

    @Override
    public boolean isHardware() {
        return false;
    }

    @Override
    public CudaCoord[] filterBlocks(Kernel kernel) {
        if (this.blockIdx == null) {
            return null;
        }
        return new CudaCoord[]{this.blockIdx};
    }

    @Override
    public CudaCoord[] filterThreads(Block block) {
        if (this.threadRange == null) {
            return null;
        }
        ArrayList<CudaCoord> res = new ArrayList<CudaCoord>();
        Iterable<CudaCoord> coords = this.threadRange.getCoords(((Kernel)DMContexts.getAncestorOfType((IDMContext)block, Kernel.class)).getBlockDim());
        for (CudaCoord cudaCoord : coords) {
            res.add(cudaCoord);
        }
        return res.toArray(new CudaCoord[res.size()]);
    }

    @Override
    public long getEnabledLanes(Warp warp) {
        return Long.MIN_VALUE;
    }

    @Override
    public long getEnabledSMs(Device device) {
        return Long.MIN_VALUE;
    }

    @Override
    public long getEnabledWarps(StreamingMultiprocessor sm) {
        return Long.MIN_VALUE;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.kernelId >= 0L) {
            builder.append("kernel ").append(this.kernelId);
        }
        if (this.blockIdx != null) {
            builder.append(" block ").append(this.blockIdx);
        }
        if (this.threadRange != null) {
            builder.append(" threads ").append(this.threadRange);
        }
        return "(" + builder.toString().trim() + ")";
    }

    @Override
    public ElementType getElementType() {
        if (this.threadRange != null) {
            return ElementType.thread;
        }
        if (this.blockIdx != null) {
            return ElementType.block;
        }
        if (this.kernelId >= 0L) {
            return ElementType.kernel;
        }
        return ElementType.application;
    }
}

