/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.debug.util;

import com.nvidia.cuda.ide.debug.model.IFocusDMContext;
import com.nvidia.cuda.ide.debug.ui.viewmodel.IColumnsVMContext;
import com.nvidia.cuda.ide.debug.util.ThreadsColumnPresentation;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.ui.concurrent.DisplayDsfExecutor;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.TreeModelViewer;
import org.eclipse.debug.internal.ui.views.variables.VariablesView;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.contexts.DebugContextEvent;
import org.eclipse.debug.ui.contexts.IDebugContextListener;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;

public final class ThreadColumnsManager
implements IDebugContextListener {
    private static final String CONTEXT_PROPERTY = ThreadColumnsManager.class.getName();
    private String[] columnIds = null;
    private final Map<String, IFocusDMContext> columns = new ConcurrentHashMap<String, IFocusDMContext>();
    private final IPresentationContext context;
    private final String[] defaultColumns;
    private final IWorkbenchPartSite site;
    private Object viewerInput;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ThreadColumnsManager getColumnsManager(IPresentationContext context, String ... columnIds) {
        if (context != null) {
            IPresentationContext iPresentationContext = context;
            synchronized (iPresentationContext) {
                ThreadColumnsManager manager = (ThreadColumnsManager)context.getProperty(CONTEXT_PROPERTY);
                if (manager == null) {
                    manager = new ThreadColumnsManager(context, columnIds);
                    context.setProperty(CONTEXT_PROPERTY, (Object)manager);
                }
                return manager;
            }
        }
        return null;
    }

    private ThreadColumnsManager(IPresentationContext context, String ... defaultColumns) {
        this.context = context;
        this.defaultColumns = defaultColumns;
        IWorkbenchPartSite iWorkbenchPartSite = this.site = context.getPart() != null ? context.getPart().getSite() : null;
        if (this.site != null) {
            DebugUITools.addPartDebugContextListener((IWorkbenchPartSite)this.site, (IDebugContextListener)this);
        }
    }

    public void debugContextChanged(DebugContextEvent event) {
        this.refresh();
    }

    public void dispose() {
        if (this.site != null) {
            DebugUITools.removePartDebugContextListener((IWorkbenchPartSite)this.site, (IDebugContextListener)this);
        }
    }

    public IFocusDMContext getColumnFocus(String columnId) {
        return this.columns.get(columnId);
    }

    private String[] getColumnIds(IDMContext[] idmContexts) {
        if (idmContexts != null) {
            String[] staticColumns = this.getStaticColumns();
            int staticColumnCount = staticColumns.length;
            String[] columnIds = new String[idmContexts.length + staticColumnCount];
            System.arraycopy(staticColumns, 0, columnIds, 0, staticColumnCount);
            int i = 0;
            while (i < idmContexts.length) {
                columnIds[i + staticColumnCount] = ThreadsColumnPresentation.createColumnId(i, idmContexts[i]);
                this.columns.put(columnIds[i + staticColumnCount], (IFocusDMContext)idmContexts[i]);
                ++i;
            }
            return columnIds;
        }
        return null;
    }

    public String[] getCurrentColumns() {
        return this.columnIds;
    }

    private String[] getStaticColumns() {
        boolean hasTypeColumn = false;
        String[] stringArray = this.defaultColumns;
        int n = this.defaultColumns.length;
        int n2 = 0;
        while (n2 < n) {
            String columnId = stringArray[n2];
            if ("org.eclipse.cdt.dsf.ui.COLUMN_ID__TYPE".equals(columnId)) {
                hasTypeColumn = true;
                break;
            }
            ++n2;
        }
        if (hasTypeColumn) {
            return new String[]{this.defaultColumns[0], "org.eclipse.cdt.dsf.ui.COLUMN_ID__TYPE"};
        }
        return new String[]{this.defaultColumns[0]};
    }

    public void refresh() {
        this.showColumns(this.viewerInput);
    }

    private void setColumns(IColumnsVMContext threadsContainer) {
        IWorkbenchWindow window = this.context.getWindow();
        if (window != null) {
            DisplayDsfExecutor executor = DisplayDsfExecutor.getDisplayDsfExecutor((Display)this.context.getWindow().getShell().getDisplay());
            threadsContainer.getColumnContexts(new DataRequestMonitor<IDMContext[]>((Executor)executor, null){

                protected void handleSuccess() {
                    ThreadColumnsManager.this.columns.clear();
                    ThreadColumnsManager.this.setViewerColumns(ThreadColumnsManager.this.getColumnIds((IDMContext[])this.getData()));
                }
            });
        }
    }

    private void setDefaultColumns() {
        this.setViewerColumns(this.defaultColumns);
    }

    private void setViewerColumns(String ... columnIds) {
        this.columnIds = columnIds;
        if (columnIds == null) {
            this.setDefaultColumns();
        } else {
            TreeModelViewer modelViewer;
            Viewer viewer;
            IWorkbenchPart part = this.context.getPart();
            if (part instanceof VariablesView && (viewer = ((VariablesView)part).getViewer()) instanceof TreeModelViewer && (modelViewer = (TreeModelViewer)viewer).getColumnPresentation() instanceof ThreadsColumnPresentation) {
                modelViewer.resetColumnSizes(columnIds);
                modelViewer.setVisibleColumns(columnIds);
            }
        }
    }

    public void showColumns(Object viewerInput) {
        this.viewerInput = viewerInput;
        if (viewerInput instanceof IColumnsVMContext) {
            this.setColumns((IColumnsVMContext)viewerInput);
        } else {
            this.setDefaultColumns();
        }
    }
}

