/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core;

import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.model.ICDITarget;
import org.eclipse.cdt.debug.mi.core.GDBCDIDebugger2;
import org.eclipse.cdt.debug.mi.core.IGDBServerMILaunchConfigurationConstants;
import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.mi.core.MIPlugin;
import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.cdi.CdiResources;
import org.eclipse.cdt.debug.mi.core.cdi.Session;
import org.eclipse.cdt.debug.mi.core.cdi.model.Target;
import org.eclipse.cdt.debug.mi.core.command.CommandFactory;
import org.eclipse.cdt.debug.mi.core.command.MIGDBSet;
import org.eclipse.cdt.debug.mi.core.command.MITargetSelect;
import org.eclipse.cdt.debug.mi.core.output.MIInfo;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;

public class GDBServerCDIDebugger2
extends GDBCDIDebugger2 {
    @Override
    protected void doStartSession(ILaunch launch, Session session, IProgressMonitor monitor) throws CoreException {
        ILaunchConfiguration config = launch.getLaunchConfiguration();
        this.setAsyncMode(config, session);
        this.initializeLibraries(config, session);
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        String debugMode = config.getAttribute("org.eclipse.cdt.launch.DEBUGGER_START_MODE", "run");
        if ("run".equals(debugMode)) {
            this.startGDBServerSession(config, session, monitor);
        }
        if ("attach".equals(debugMode)) {
            String msg = MIPlugin.getResourceString("src.GDBServerDebugger.GDBServer_attaching_unsupported");
            throw this.newCoreException(msg, null);
        }
        if ("core".equals(debugMode)) {
            String msg = MIPlugin.getResourceString("src.GDBServerDebugger.GDBServer_corefiles_unsupported");
            throw this.newCoreException(msg, null);
        }
    }

    protected void startGDBServerSession(ILaunchConfiguration config, Session session, IProgressMonitor monitor) throws CoreException {
        MIException ex;
        MIInfo info;
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        ICDITarget[] targets = session.getTargets();
        int launchTimeout = MIPlugin.getLaunchTimeout();
        boolean tcpConnection = config.getAttribute(IGDBServerMILaunchConfigurationConstants.ATTR_REMOTE_TCP, false);
        if (!tcpConnection) {
            String remoteBaud = config.getAttribute(IGDBServerMILaunchConfigurationConstants.ATTR_DEV_SPEED, "invalid");
            int i = 0;
            while (i < targets.length) {
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                Target target = (Target)targets[i];
                MISession miSession = target.getMISession();
                CommandFactory factory = miSession.getCommandFactory();
                MIGDBSet setRemoteBaud = factory.createMIGDBSet(new String[]{"remotebaud", remoteBaud});
                info = null;
                ex = null;
                try {
                    miSession.postCommand(setRemoteBaud, launchTimeout);
                    info = setRemoteBaud.getMIInfo();
                }
                catch (MIException e) {
                    ex = e;
                }
                if (info == null) {
                    throw this.newCoreException(MIPlugin.getResourceString("src.GDBServerDebugger.Can_not_set_Baud"), ex);
                }
                ++i;
            }
        }
        int i = 0;
        while (i < targets.length) {
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            Target target = (Target)targets[i];
            MISession miSession = target.getMISession();
            CommandFactory factory = miSession.getCommandFactory();
            String[] targetParams = this.getTargetParams(config, tcpConnection);
            MITargetSelect select = factory.createMITargetSelect(targetParams);
            info = null;
            ex = null;
            try {
                miSession.postCommand(select, launchTimeout);
                info = select.getMIInfo();
            }
            catch (MIException e) {
                ex = e;
            }
            if (info == null) {
                throw this.newCoreException(MIPlugin.getResourceString("src.GDBServerCDIDebugger.target_selection_failed"), ex);
            }
            miSession.getMIInferior().setSuspended();
            miSession.getMIInferior().update();
            miSession.getMIInferior().setIsRemoteInferior(true);
            ++i;
        }
    }

    protected String[] getTargetParams(ILaunchConfiguration config, boolean tcpConnection) throws CoreException {
        String remote = null;
        if (tcpConnection) {
            remote = config.getAttribute(IGDBServerMILaunchConfigurationConstants.ATTR_HOST, "invalid");
            remote = String.valueOf(remote) + ":";
            remote = String.valueOf(remote) + config.getAttribute(IGDBServerMILaunchConfigurationConstants.ATTR_PORT, "invalid");
        } else {
            remote = config.getAttribute(IGDBServerMILaunchConfigurationConstants.ATTR_DEV, "invalid");
        }
        return new String[]{"remote", remote};
    }

    @Override
    protected boolean usePty(ILaunchConfiguration config) throws CoreException {
        return false;
    }

    private void setAsyncMode(ILaunchConfiguration config, Session session) throws CoreException {
        ICDITarget[] dtargets = session.getTargets();
        int i = 0;
        while (i < dtargets.length) {
            MISession miSession = ((Target)dtargets[i]).getMISession();
            try {
                MIGDBSet setAsyncMode = miSession.getCommandFactory().createMIGDBSet(new String[]{"target-async", "0"});
                miSession.postCommand(setAsyncMode);
                MIInfo info = setAsyncMode.getMIInfo();
                if (info == null) {
                    throw this.newCoreException(new CDIException(CdiResources.getString("cdi.Common.No_answer")));
                }
            }
            catch (MIException mIException) {}
            ++i;
        }
    }
}

