/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.ui.properties;

import java.util.ArrayList;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICFileDescription;
import org.eclipse.cdt.core.settings.model.ICMultiItemsHolder;
import org.eclipse.cdt.core.settings.model.ICMultiResourceDescription;
import org.eclipse.cdt.core.settings.model.ICResourceDescription;
import org.eclipse.cdt.managedbuilder.core.IAdditionalInput;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IFileInfo;
import org.eclipse.cdt.managedbuilder.core.IInputType;
import org.eclipse.cdt.managedbuilder.core.IOutputType;
import org.eclipse.cdt.managedbuilder.core.IResourceInfo;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.ui.Messages;
import org.eclipse.cdt.managedbuilder.ui.properties.AbstractCBuildPropertyTab;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class BuildStepsTab
extends AbstractCBuildPropertyTab {
    private Combo combo;
    private Combo preCmd;
    private Combo preDes;
    private Combo postCmd;
    private Combo postDes;
    private ITool tool;
    private IConfiguration config;
    private ICResourceDescription cfgdescr;
    private IFileInfo rcfg;
    private boolean canModify = true;
    private static final String label1 = Messages.BuildStepsTab_0;
    private static final String label2 = Messages.BuildStepsTab_1;
    private static final String PATH_SEPERATOR = ";";
    private static final String rcbsToolId = new String("org.eclipse.cdt.managedbuilder.ui.rcbs");
    private static final String rcbsToolName = new String("Resource Custom Build Step");
    private static final String rcbsToolInputTypeId = new String("org.eclipse.cdt.managedbuilder.ui.rcbs.inputtype");
    private static final String rcbsToolInputTypeName = new String("Resource Custom Build Step Input Type");
    private static final String rcbsToolOutputTypeId = new String("org.eclipse.cdt.managedbuilder.ui.rcbs.outputtype");
    private static final String rcbsToolOutputTypeName = new String("Resource Custom Build Step Output Type");
    private Set<String> set1 = new TreeSet<String>();
    private Set<String> set2 = new TreeSet<String>();
    private Set<String> set3 = new TreeSet<String>();
    private Set<String> set4 = new TreeSet<String>();
    private static final String[] rcbsApplicabilityRules = new String[]{new String(Messages.ResourceCustomBuildStepBlock_label_applicability_rule_override), new String(Messages.ResourceCustomBuildStepBlock_label_applicability_rule_disable)};

    public void createControls(Composite parent) {
        super.createControls(parent);
        this.usercomp.setLayout((Layout)new GridLayout(1, false));
        if (this.page.isForProject()) {
            this.createForProject();
        } else {
            this.createForFile();
        }
    }

    private void createForProject() {
        Group g1 = this.setupGroup(this.usercomp, Messages.BuildStepsTab_2, 1, 768);
        this.setupLabel((Composite)g1, label1, 1, 1);
        this.preCmd = this.setCombo((Composite)g1, FIELD.PRECMD, this.set1);
        this.preCmd.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (BuildStepsTab.this.canModify && !BuildStepsTab.this.preCmd.getText().equals(BuildStepsTab.this.getCfg().getPrebuildStep())) {
                    BuildStepsTab.this.getCfg().setPrebuildStep(BuildStepsTab.this.preCmd.getText());
                }
            }
        });
        this.setupLabel((Composite)g1, label2, 1, 1);
        this.preDes = this.setCombo((Composite)g1, FIELD.PREANN, this.set2);
        this.preDes.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (BuildStepsTab.this.canModify && !BuildStepsTab.this.preDes.getText().equals(BuildStepsTab.this.getCfg().getPreannouncebuildStep())) {
                    BuildStepsTab.this.getCfg().setPreannouncebuildStep(BuildStepsTab.this.preDes.getText());
                }
            }
        });
        Group g2 = this.setupGroup(this.usercomp, Messages.BuildStepsTab_3, 1, 768);
        this.setupLabel((Composite)g2, label1, 1, 1);
        this.postCmd = this.setCombo((Composite)g2, FIELD.PSTCMD, this.set3);
        this.postCmd.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (BuildStepsTab.this.canModify && !BuildStepsTab.this.postCmd.getText().equals(BuildStepsTab.this.getCfg().getPostbuildStep())) {
                    BuildStepsTab.this.getCfg().setPostbuildStep(BuildStepsTab.this.postCmd.getText());
                }
            }
        });
        this.setupLabel((Composite)g2, label2, 1, 1);
        this.postDes = this.setCombo((Composite)g2, FIELD.PSTANN, this.set4);
        this.postDes.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (BuildStepsTab.this.canModify && !BuildStepsTab.this.postDes.getText().equals(BuildStepsTab.this.getCfg().getPostannouncebuildStep())) {
                    BuildStepsTab.this.getCfg().setPostannouncebuildStep(BuildStepsTab.this.postDes.getText());
                }
            }
        });
    }

    private void createForFile() {
        Group g1 = this.setupGroup(this.usercomp, Messages.BuildStepsTab_4, 1, 768);
        this.setupLabel((Composite)g1, Messages.ResourceCustomBuildStepBlock_label_applicability, 1, 1);
        this.combo = new Combo((Composite)g1, 2060);
        this.combo.setItems(rcbsApplicabilityRules);
        this.combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BuildStepsTab.this.rcfg.setRcbsApplicability(BuildStepsTab.this.sel2app(BuildStepsTab.this.combo.getSelectionIndex()));
            }
        });
        this.setupLabel((Composite)g1, Messages.BuildStepsTab_5, 1, 1);
        this.preCmd = this.setCombo((Composite)g1, FIELD.PRECMD, this.set1);
        this.preCmd.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                IAdditionalInput[] add;
                IInputType[] ein;
                if (BuildStepsTab.this.canModify && BuildStepsTab.this.tool != null && (ein = BuildStepsTab.this.tool.getInputTypes()) != null && ein.length > 0 && (add = ein[0].getAdditionalInputs()) != null && add.length > 0) {
                    add[0].setPaths(BuildStepsTab.this.preCmd.getText());
                }
            }
        });
        this.setupLabel((Composite)g1, Messages.BuildStepsTab_6, 1, 1);
        this.preDes = this.setCombo((Composite)g1, FIELD.PREANN, this.set2);
        this.preDes.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Object[] out;
                if (BuildStepsTab.this.canModify && BuildStepsTab.this.tool != null && BuildStepsTab.this.valid(out = BuildStepsTab.this.tool.getOutputTypes())) {
                    out[0].setOutputNames(BuildStepsTab.this.preDes.getText());
                }
            }
        });
        this.setupLabel((Composite)g1, label1, 1, 1);
        this.postCmd = this.setCombo((Composite)g1, FIELD.PSTCMD, this.set3);
        this.postCmd.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (BuildStepsTab.this.canModify && BuildStepsTab.this.tool != null) {
                    BuildStepsTab.this.tool.setToolCommand(BuildStepsTab.this.postCmd.getText());
                }
            }
        });
        this.setupLabel((Composite)g1, label2, 1, 1);
        this.postDes = this.setCombo((Composite)g1, FIELD.PSTANN, this.set4);
        this.postDes.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (BuildStepsTab.this.canModify && BuildStepsTab.this.tool != null) {
                    BuildStepsTab.this.tool.setAnnouncement(BuildStepsTab.this.postDes.getText());
                }
            }
        });
    }

    public void updateData(ICResourceDescription cfgd) {
        if (cfgd == null) {
            return;
        }
        this.config = BuildStepsTab.getCfg(cfgd.getConfiguration());
        this.cfgdescr = cfgd;
        this.update();
    }

    private void update() {
        this.canModify = false;
        this.updateCombo(this.preCmd);
        this.updateCombo(this.preDes);
        this.updateCombo(this.postCmd);
        this.updateCombo(this.postDes);
        if (this.page.isForProject()) {
            this.preCmd.setText(this.config.getPrebuildStep());
            this.preDes.setText(this.config.getPreannouncebuildStep());
            this.postCmd.setText(this.config.getPostbuildStep());
            this.postDes.setText(this.config.getPostannouncebuildStep());
        } else {
            this.rcfg = (IFileInfo)this.getResCfg(this.cfgdescr);
            this.combo.select(this.app2sel(this.rcfg.getRcbsApplicability()));
            this.tool = this.getRcbsTool(this.rcfg);
            if (this.tool != null) {
                this.preCmd.setText(this.getInputTypes(this.tool));
                this.preDes.setText(this.getOutputNames(this.tool));
                this.postCmd.setText(this.tool.getToolCommand());
                this.postDes.setText(this.tool.getAnnouncement());
            } else {
                this.preCmd.setText("");
                this.preDes.setText("");
                this.postCmd.setText("");
                this.postDes.setText("");
            }
        }
        this.canModify = true;
    }

    private String getInputTypes(ITool t) {
        IAdditionalInput[] add;
        String s = "";
        IInputType[] tmp = t.getInputTypes();
        if (tmp != null && tmp.length > 0 && (add = tmp[0].getAdditionalInputs()) != null && add.length > 0) {
            s = this.createList(add[0].getPaths());
        }
        return s;
    }

    private String getOutputNames(ITool t) {
        String s = "";
        IOutputType[] tmp2 = t.getOutputTypes();
        if (tmp2 != null && tmp2.length > 0) {
            s = this.createList(tmp2[0].getOutputNames());
        }
        return s;
    }

    private ITool getRcbsTool(IFileInfo rcConfig) {
        ITool[] rcbsTools = this.getRcbsTools((IResourceInfo)rcConfig);
        ITool rcbsTool = null;
        if (rcbsTools != null) {
            rcbsTool = rcbsTools[0];
        } else {
            rcbsTool = rcConfig.createTool(null, String.valueOf(rcbsToolId) + "." + ManagedBuildManager.getRandomNumber(), rcbsToolName, false);
            rcbsTool.setCustomBuildStep(true);
            IInputType rcbsToolInputType = rcbsTool.createInputType(null, String.valueOf(rcbsToolInputTypeId) + "." + ManagedBuildManager.getRandomNumber(), rcbsToolInputTypeName, false);
            IAdditionalInput rcbsToolInputTypeAdditionalInput = rcbsToolInputType.createAdditionalInput(new String());
            rcbsToolInputTypeAdditionalInput.setKind(3);
            rcbsTool.createOutputType(null, String.valueOf(rcbsToolOutputTypeId) + "." + ManagedBuildManager.getRandomNumber(), rcbsToolOutputTypeName, false);
        }
        return rcbsTool;
    }

    private ITool[] getRcbsTools(IResourceInfo rcConfig) {
        ArrayList<ITool> list = new ArrayList<ITool>();
        ITool[] tools = rcConfig.getTools();
        int i = 0;
        while (i < tools.length) {
            ITool tool = tools[i];
            if (tool.getCustomBuildStep() && !tool.isExtensionElement()) {
                list.add(tool);
            }
            ++i;
        }
        if (list.size() != 0) {
            return list.toArray(new ITool[list.size()]);
        }
        return null;
    }

    private String createList(String[] items) {
        if (items == null) {
            return new String();
        }
        StringBuffer path = new StringBuffer("");
        int i = 0;
        while (i < items.length) {
            path.append(items[i]);
            if (i < items.length - 1) {
                path.append(PATH_SEPERATOR);
            }
            ++i;
        }
        return path.toString();
    }

    public void performApply(ICResourceDescription src, ICResourceDescription dst) {
        if (this.page.isForProject()) {
            IConfiguration cfg1 = BuildStepsTab.getCfg(src.getConfiguration());
            IConfiguration cfg2 = BuildStepsTab.getCfg(dst.getConfiguration());
            cfg2.setPrebuildStep(cfg1.getPrebuildStep());
            cfg2.setPreannouncebuildStep(cfg1.getPreannouncebuildStep());
            cfg2.setPostbuildStep(cfg1.getPostbuildStep());
            cfg2.setPostannouncebuildStep(cfg1.getPostannouncebuildStep());
        } else if (this.page.isMultiCfg()) {
            ICResourceDescription[] ris1 = (ICResourceDescription[])((ICMultiResourceDescription)src).getItems();
            ICResourceDescription[] ris2 = (ICResourceDescription[])((ICMultiResourceDescription)dst).getItems();
            int i = 0;
            while (i < ris1.length) {
                this.applyToFile(ris1[i], ris2[i]);
                ++i;
            }
        } else {
            this.applyToFile(src, dst);
        }
    }

    private void applyToFile(ICResourceDescription src, ICResourceDescription dst) {
        IFileInfo rcfg1 = (IFileInfo)this.getResCfg(src);
        IFileInfo rcfg2 = (IFileInfo)this.getResCfg(dst);
        rcfg2.setRcbsApplicability(rcfg1.getRcbsApplicability());
        ITool tool1 = this.getRcbsTool(rcfg1);
        ITool tool2 = this.getRcbsTool(rcfg2);
        Object[] ein1 = tool1.getInputTypes();
        Object[] ein2 = tool2.getInputTypes();
        if (this.valid(ein1) && this.valid(ein2)) {
            Object[] add1 = ein1[0].getAdditionalInputs();
            Object[] add2 = ein2[0].getAdditionalInputs();
            if (this.valid(add1) && this.valid(add2)) {
                add2[0].setPaths(this.createList(add1[0].getPaths()));
            }
        }
        Object[] tmp1 = tool1.getOutputTypes();
        Object[] tmp2 = tool2.getOutputTypes();
        if (this.valid(tmp1) && this.valid(tmp2)) {
            tmp2[0].setOutputNames(this.createList(tmp1[0].getOutputNames()));
        }
        tool2.setToolCommand(tool1.getToolCommand());
        tool2.setAnnouncement(tool1.getAnnouncement());
    }

    private int sel2app(int index) {
        String sel = this.combo.getItem(index);
        if (Messages.ResourceCustomBuildStepBlock_label_applicability_rule_override.equals(sel)) {
            return 1;
        }
        if (Messages.ResourceCustomBuildStepBlock_label_applicability_rule_after.equals(sel)) {
            return 3;
        }
        if (Messages.ResourceCustomBuildStepBlock_label_applicability_rule_before.equals(sel)) {
            return 2;
        }
        return 4;
    }

    private boolean valid(Object[] arr) {
        return arr != null && arr.length > 0;
    }

    private int app2sel(int val) {
        switch (val) {
            case 3: {
                return this.combo.indexOf(Messages.ResourceCustomBuildStepBlock_label_applicability_rule_after);
            }
            case 2: {
                return this.combo.indexOf(Messages.ResourceCustomBuildStepBlock_label_applicability_rule_before);
            }
            case 4: {
                return this.combo.indexOf(Messages.ResourceCustomBuildStepBlock_label_applicability_rule_disable);
            }
        }
        return this.combo.indexOf(Messages.ResourceCustomBuildStepBlock_label_applicability_rule_override);
    }

    public boolean canBeVisible() {
        if (this.page.isForProject() || this.page.isForFile()) {
            if (this.page.isMultiCfg()) {
                ICMultiItemsHolder mih = (ICMultiItemsHolder)this.getCfg();
                IConfiguration[] cfs = (IConfiguration[])mih.getItems();
                int i = 0;
                while (i < cfs.length) {
                    if (cfs[i].getBuilder().isManagedBuildOn()) {
                        return true;
                    }
                    ++i;
                }
                return false;
            }
            return this.getCfg().getBuilder().isManagedBuildOn();
        }
        return false;
    }

    protected void performDefaults() {
        if (this.page.isForProject()) {
            this.config.setPrebuildStep(null);
            this.config.setPreannouncebuildStep(null);
            this.config.setPostbuildStep(null);
            this.config.setPostannouncebuildStep(null);
        } else {
            Object[] tmp;
            Object[] add;
            this.rcfg.setRcbsApplicability(4);
            ITool tool = this.getRcbsTool(this.rcfg);
            Object[] ein = tool.getInputTypes();
            if (this.valid(ein) && this.valid(add = ein[0].getAdditionalInputs())) {
                add[0].setPaths(null);
            }
            if (this.valid(tmp = tool.getOutputTypes())) {
                tmp[0].setOutputNames(null);
            }
            tool.setToolCommand(null);
            tool.setAnnouncement(null);
        }
        this.update();
    }

    protected void updateButtons() {
    }

    private Combo setCombo(Composite c, FIELD field, Set<String> set) {
        Combo combo = new Combo(c, 2048);
        this.setupControl((Control)combo, 1, 768);
        combo.setLayoutData((Object)new GridData(768));
        combo.setData("enum", (Object)field);
        combo.setData("set", set);
        this.updateCombo(combo);
        return combo;
    }

    private void updateCombo(Combo combo) {
        Set set;
        block14: {
            FIELD field = (FIELD)((Object)combo.getData("enum"));
            set = (Set)combo.getData("set");
            if (field == null || set == null) {
                return;
            }
            combo.removeAll();
            boolean prj = this.page.isForProject();
            if (!prj && this.tool == null) break block14;
            ICConfigurationDescription[] iCConfigurationDescriptionArray = this.page.getCfgsEditable();
            int n = iCConfigurationDescriptionArray.length;
            int n2 = 0;
            while (n2 < n) {
                block17: {
                    ITool t;
                    IConfiguration c;
                    block16: {
                        ICConfigurationDescription cf;
                        block15: {
                            cf = iCConfigurationDescriptionArray[n2];
                            c = null;
                            t = null;
                            if (!prj) break block15;
                            c = BuildStepsTab.getCfg(cf);
                            break block16;
                        }
                        ICResourceDescription r = cf.getResourceDescription(this.cfgdescr.getPath(), true);
                        if (r != null && r instanceof ICFileDescription) {
                            t = this.getRcbsTool((IFileInfo)this.getResCfg(r));
                        }
                        if (t == null) break block17;
                    }
                    String s = null;
                    switch (field) {
                        case PRECMD: {
                            s = prj ? c.getPrebuildStep() : this.getInputTypes(t);
                            break;
                        }
                        case PREANN: {
                            s = prj ? c.getPreannouncebuildStep() : this.getOutputNames(t);
                            break;
                        }
                        case PSTCMD: {
                            s = prj ? c.getPostbuildStep() : t.getToolCommand();
                            break;
                        }
                        case PSTANN: {
                            String string = s = prj ? c.getPostannouncebuildStep() : t.getAnnouncement();
                        }
                    }
                    if (s != null && s.trim().length() > 0) {
                        set.add(s.trim());
                    }
                }
                ++n2;
            }
        }
        if (set.size() > 0) {
            combo.setItems(set.toArray(new String[set.size()]));
        }
    }

    private static enum FIELD {
        PRECMD,
        PREANN,
        PSTCMD,
        PSTANN;

    }
}

