/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.togglefunction;

import java.util.List;
import org.eclipse.cdt.core.dom.ast.IASTComment;
import org.eclipse.cdt.core.dom.ast.IASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCatchHandler;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionWithTryBlock;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateDeclaration;
import org.eclipse.cdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTSimpleDeclaration;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.cdt.internal.ui.refactoring.ModificationCollector;
import org.eclipse.cdt.internal.ui.refactoring.togglefunction.IToggleRefactoringStrategy;
import org.eclipse.cdt.internal.ui.refactoring.togglefunction.Messages;
import org.eclipse.cdt.internal.ui.refactoring.togglefunction.NotSupportedException;
import org.eclipse.cdt.internal.ui.refactoring.togglefunction.ToggleNodeHelper;
import org.eclipse.cdt.internal.ui.refactoring.togglefunction.ToggleRefactoringContext;
import org.eclipse.text.edits.TextEditGroup;

public class ToggleFromInHeaderToClassStrategy
implements IToggleRefactoringStrategy {
    private TextEditGroup infoText;
    private ToggleRefactoringContext context;

    public ToggleFromInHeaderToClassStrategy(ToggleRefactoringContext context) {
        if (this.isFreeFunction(context)) {
            throw new NotSupportedException(Messages.ToggleFromInHeaderToClassStrategy_CanNotToggleTemplateFreeFunction);
        }
        this.context = context;
        this.infoText = new TextEditGroup(Messages.EditGroupName);
    }

    private boolean isFreeFunction(ToggleRefactoringContext context) {
        return this.isNotInsideAClass(context.getDefinition().getDeclarator(), context.getDeclaration());
    }

    boolean isNotInsideAClass(IASTFunctionDeclarator declarator, IASTFunctionDeclarator backup) {
        if (declarator.getName() instanceof ICPPASTQualifiedName) {
            declarator = backup;
        }
        return CPPVisitor.findAncestorWithType((IASTNode)declarator, IASTCompositeTypeSpecifier.class) == null;
    }

    @Override
    public void run(ModificationCollector modifications) {
        ASTRewrite rewriter = this.removeDefinition(modifications);
        IASTFunctionDefinition newDefinition = this.getNewDefinition();
        this.replaceDeclarationWithDefinition(rewriter, newDefinition);
        IASTNode parentTemplateDeclaration = ToggleNodeHelper.getParentTemplateDeclaration((IASTNode)this.context.getDeclaration());
        if (!(parentTemplateDeclaration instanceof ICPPASTTemplateDeclaration)) {
            this.restoreLeadingComments(rewriter, newDefinition);
        }
    }

    private void restoreLeadingComments(ASTRewrite rewriter, IASTFunctionDefinition newDefinition) {
        List comments = rewriter.getComments(this.context.getDefinition().getParent(), ASTRewrite.CommentPosition.leading);
        if (comments != null) {
            for (IASTComment comment : comments) {
                rewriter.addComment((IASTNode)newDefinition, comment, ASTRewrite.CommentPosition.leading);
                rewriter.remove((IASTNode)comment, this.infoText);
            }
        }
    }

    private ASTRewrite removeDefinition(ModificationCollector modifications) {
        ASTRewrite rewriter = modifications.rewriterForTranslationUnit(this.context.getDefinitionAST());
        IASTNode parentRemovePoint = ToggleNodeHelper.getParentRemovePoint(this.context.getDefinition());
        rewriter.remove(parentRemovePoint, this.infoText);
        return rewriter;
    }

    private IASTFunctionDefinition getNewDefinition() {
        IASTNode parent;
        IASTFunctionDefinition newDefinition = ToggleNodeHelper.createInClassDefinition(this.context.getDeclaration(), this.context.getDefinition(), this.context.getDefinitionAST());
        newDefinition.setBody(this.context.getDefinition().getBody().copy(IASTNode.CopyStyle.withLocations));
        if (newDefinition instanceof ICPPASTFunctionWithTryBlock) {
            ICPPASTFunctionWithTryBlock newTryFun = (ICPPASTFunctionWithTryBlock)newDefinition;
            ICPPASTFunctionWithTryBlock oldTryFun = (ICPPASTFunctionWithTryBlock)this.context.getDefinition();
            ICPPASTCatchHandler[] iCPPASTCatchHandlerArray = oldTryFun.getCatchHandlers();
            int n = iCPPASTCatchHandlerArray.length;
            int n2 = 0;
            while (n2 < n) {
                ICPPASTCatchHandler catchH = iCPPASTCatchHandlerArray[n2];
                newTryFun.addCatchHandler(catchH.copy(IASTNode.CopyStyle.withLocations));
                ++n2;
            }
        }
        if ((parent = CPPVisitor.findAncestorWithType((IASTNode)this.context.getDefinition(), ICPPASTCompositeTypeSpecifier.class)) != null) {
            newDefinition.setParent(parent);
        } else {
            newDefinition.setParent((IASTNode)this.context.getDefinitionAST());
        }
        return newDefinition;
    }

    private ASTRewrite replaceDeclarationWithDefinition(ASTRewrite rewriter, IASTFunctionDefinition newDefinition) {
        IASTSimpleDeclaration fullDeclaration = (IASTSimpleDeclaration)CPPVisitor.findAncestorWithType((IASTNode)this.context.getDeclaration(), CPPASTSimpleDeclaration.class);
        ASTRewrite newRewriter = rewriter.replace((IASTNode)fullDeclaration, (IASTNode)newDefinition, this.infoText);
        return newRewriter;
    }
}

