/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.model;

import com.nvidia.viper.activity.CuptiActivityOpenAcc;
import com.nvidia.viper.jni.OpenAccAggregate;
import com.nvidia.viper.model.Session;
import java.util.Stack;

public class OpenAccSummary {
    private Session session;
    private OpenAccAggregate root;
    private Stack<OpenAccAggregate> timelineStack;
    private long totalTime;

    public OpenAccSummary(Session session) {
        this.session = session;
        this.root = new OpenAccAggregate(this);
        this.timelineStack = new Stack();
    }

    private void incrementAggregate(OpenAccAggregate entry, CuptiActivityOpenAcc openAcc) {
        entry.setCalls(entry.getCalls() + 1L);
        entry.incrementEndTime(openAcc.end);
        entry.incrementInclusiveTime(openAcc.end - openAcc.start);
        if (!entry.isSource()) {
            entry.incrementExclusiveTime(openAcc.end - openAcc.start);
        }
    }

    public OpenAccAggregate findSourceAggregate(CuptiActivityOpenAcc openAcc) {
        OpenAccAggregate entry = this.root.getChild(openAcc);
        if (entry == null) {
            entry = new OpenAccAggregate(this, this.root, openAcc, true);
            this.root.addChild(entry);
        } else {
            this.incrementAggregate(entry, openAcc);
        }
        return entry;
    }

    public OpenAccAggregate findAggregate(CuptiActivityOpenAcc openAcc) {
        OpenAccAggregate sourceEntry = this.findSourceAggregate(openAcc);
        OpenAccAggregate entry = sourceEntry.getChild(openAcc);
        if (entry == null) {
            entry = new OpenAccAggregate(this, sourceEntry, openAcc, false);
            sourceEntry.addChild(entry);
        } else {
            this.incrementAggregate(entry, openAcc);
        }
        this.clearTimelineStack(openAcc.end);
        this.timelineStack.push(entry);
        this.calculateExclusiveTime(openAcc.end - openAcc.start);
        return entry;
    }

    public void clearTimelineStack(long cursor) {
        while (!this.timelineStack.isEmpty() && this.timelineStack.peek().getEndTime() < cursor) {
            this.timelineStack.pop();
        }
    }

    public void finishCalculatingOpenAccExclusiveTime() {
        this.clearTimelineStack(Long.MAX_VALUE);
    }

    public void calculateExclusiveTime(long activityDuration) {
        if (this.timelineStack.size() >= 2) {
            OpenAccAggregate enclosedAggregate = this.timelineStack.pop();
            OpenAccAggregate enclosingAggregate = this.timelineStack.peek();
            if (enclosingAggregate != null) {
                enclosingAggregate.subtractExclusiveTime(activityDuration);
            }
            this.timelineStack.push(enclosedAggregate);
        }
    }

    public Session getSession() {
        return this.session;
    }

    public OpenAccAggregate getRoot() {
        return this.root;
    }

    public void setTotalTime(long openAccTotalTime) {
        this.totalTime = openAccTotalTime;
    }

    public long getTotalTime() {
        return this.totalTime;
    }
}

