/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.ui.analysis;

import com.nvidia.viper.activity.CuptiActivityDevice;
import com.nvidia.viper.activity.CuptiActivityNvLink;
import com.nvidia.viper.activity.CuptiDevType;
import com.nvidia.viper.analysis.AnalysisResult;
import com.nvidia.viper.analysis.AnalysisResultNVLink;
import com.nvidia.viper.model.InstantaneousMetricManager;
import com.nvidia.viper.model.ProfileDataModel;
import com.nvidia.viper.model.Session;
import com.nvidia.viper.ui.UIUtils;
import com.nvidia.viper.ui.analysis.AnalysisResultControl;
import com.nvidia.viper.ui.analysis.NVLinkColorLegendControl;
import com.nvidia.viper.ui.analysis.NVLinkPropertyControl;
import com.nvidia.viper.ui.analysis.NVLinkTopology;
import com.nvidia.viper.ui.analysis.NVSwitchTableViewer;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class NVLinkTopologyControl
extends AnalysisResultControl {
    private TreeMap<Integer, NvSwitchModel> deviceIdModelMap;
    private long peakBanwidthPerPort;

    public NVLinkTopologyControl(Composite parent, AnalysisResult result, Session session) {
        super(parent, result, session);
    }

    private static void setBackground(Composite composite, Color color) {
        composite.setBackground(color);
        Control[] controlArray = composite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            if (child instanceof Composite && !(child instanceof NVLinkColorLegendControl)) {
                NVLinkTopologyControl.setBackground((Composite)child, color);
            } else {
                child.setBackground(color);
            }
            ++n2;
        }
    }

    private Set<CuptiActivityNvLink> getLinks() {
        if (this.result instanceof AnalysisResultNVLink) {
            return ((AnalysisResultNVLink)this.result).getLinks();
        }
        return null;
    }

    @Override
    protected void setColors(boolean isSelected) {
        List<Color> colors = this.getColors(isSelected);
        if (colors != null && colors.size() >= 3) {
            NVLinkTopologyControl.setBackground(this, colors.get(0));
            UIUtils.setForeground(this, colors.get(1));
            this.setDetailsForeground(colors.get(2));
        }
    }

    @Override
    protected boolean hasExtension() {
        return true;
    }

    @Override
    protected void createExtension(Composite parent) {
        this.peakBanwidthPerPort = -1L;
        Set<CuptiActivityNvLink> linkRecords = this.getLinks();
        if (linkRecords == null || linkRecords.isEmpty()) {
            return;
        }
        CuptiActivityNvLink nvlinkActivity = linkRecords.iterator().next();
        if (nvlinkActivity.nvswitchConnected == 1L) {
            NVSwitchTableViewer viewer = new NVSwitchTableViewer(parent);
            TreeMap<Integer, NvSwitchModel> map = this.createNvSitchModel(linkRecords);
            viewer.setInput(map.values());
        } else {
            SashForm sashForm = new SashForm(parent, 256);
            sashForm.setLayout((Layout)new RowLayout());
            sashForm.setLayoutData((Object)new GridData(4, 4, true, true));
            AnalysisResultNVLink nvlinkResult = (AnalysisResultNVLink)this.result;
            NVLinkTopology linkTopology = new NVLinkTopology((Composite)sashForm, 2048, this.activeSession, nvlinkResult, linkRecords);
            NVLinkPropertyControl propertyControl = new NVLinkPropertyControl((Composite)sashForm, 0);
            propertyControl.setInput(linkTopology.getCanvas());
            linkTopology.getCanvas().addPropertyChangeListener(propertyControl);
            sashForm.setWeights(new int[]{4, 5});
            sashForm.setSashWidth(5);
        }
    }

    private TreeMap<Integer, NvSwitchModel> createNvSitchModel(Set<CuptiActivityNvLink> linkRecords) {
        if (this.deviceIdModelMap == null) {
            this.deviceIdModelMap = new TreeMap();
        }
        for (CuptiActivityNvLink activity : linkRecords) {
            if (this.peakBanwidthPerPort == -1L) {
                long peakBanwidthLink = activity.bandwidth / 1000000L;
                this.peakBanwidthPerPort = peakBanwidthLink / (long)activity.physicalNvLinkCount;
            }
            this.updateModel(activity.typeDev0, activity.uuidDev0, activity.portDev0, activity.bandwidth);
            this.updateModel(activity.typeDev1, activity.uuidDev1, activity.portDev1, activity.bandwidth);
        }
        Map.Entry<Integer, NvSwitchModel> entry = this.deviceIdModelMap.lastEntry();
        NvSwitchModel model = entry.getValue();
        model.peakBandwidth = model.linkBandwidth / 1000000L;
        return this.deviceIdModelMap;
    }

    private void updateModel(int type, byte[] uuid, int[] port, long bandwidth) {
        int i;
        long achievedBandwidth;
        long totalReceive;
        long totalTransmit;
        long transmit;
        long received;
        if (type != CuptiDevType.CUPTI_DEV_TYPE_GPU.getCode()) {
            return;
        }
        int deviceId = this.getDeviceIdFromUUID(uuid);
        NvSwitchModel model = this.deviceIdModelMap.get(deviceId);
        if (model != null) {
            int i2;
            if (model.listPorts == null) {
                model.listPorts = new int[port.length];
                i2 = 0;
                while (i2 < model.listPorts.length) {
                    model.listPorts[i2] = -1;
                    ++i2;
                }
            }
            i2 = 0;
            while (i2 < port.length) {
                if (port[i2] > -1 && model.listPorts[i2] <= -1) {
                    model.listPorts[i2] = port[i2];
                    model.peakBandwidth += this.peakBanwidthPerPort;
                }
                ++i2;
            }
            return;
        }
        model = new NvSwitchModel();
        this.deviceIdModelMap.put(deviceId, model);
        model.deviceId = deviceId;
        InstantaneousMetricManager metricMngr = this.activeSession.getInstantaneousMetricManager();
        model.receiveBandwidth = received = (long)metricMngr.getAvgBandwidth(deviceId, "nvlink_receive_throughput");
        model.transmitBandwidth = transmit = (long)metricMngr.getAvgBandwidth(deviceId, "nvlink_transmit_throughput");
        model.totalDataTransmitted = totalTransmit = metricMngr.getAggregateMetricValues(deviceId, "nvlink_total_data_transmitted");
        model.totalDataReceived = totalReceive = metricMngr.getAggregateMetricValues(deviceId, "nvlink_total_data_received");
        model.achievedBandwidth = achievedBandwidth = Math.max(Math.max(received, transmit), received + transmit);
        model.linkBandwidth = bandwidth;
        if (model.listPorts == null) {
            model.listPorts = new int[port.length];
            i = 0;
            while (i < model.listPorts.length) {
                model.listPorts[i] = -1;
                ++i;
            }
        }
        i = 0;
        while (i < port.length) {
            if (port[i] > -1) {
                model.listPorts[i] = port[i];
                model.peakBandwidth += this.peakBanwidthPerPort;
            }
            ++i;
        }
    }

    private int getDeviceIdFromUUID(byte[] uuid) {
        ProfileDataModel pdm = this.activeSession.getTimelinePdms().get(0);
        for (CuptiActivityDevice device : pdm.devices) {
            if (!Arrays.equals(device.uuid, uuid)) continue;
            return device.id;
        }
        return -1;
    }

    @Override
    public boolean grabsVerticalSpace() {
        return true;
    }

    class NvSwitchModel {
        int deviceId = -1;
        long transmitBandwidth = -1L;
        long receiveBandwidth = -1L;
        long totalDataTransmitted = -1L;
        long totalDataReceived = -1L;
        long peakBandwidth = 0L;
        long achievedBandwidth = -1L;
        long linkBandwidth = -1L;
        int[] listPorts = null;

        NvSwitchModel() {
        }
    }
}

