/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.webapp.service;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.help.internal.webapp.HelpWebappPlugin;
import org.eclipse.help.internal.webapp.WebappResources;
import org.eclipse.help.internal.webapp.data.UrlUtil;
import org.eclipse.help.internal.webapp.parser.AboutParser;
import org.eclipse.help.internal.webapp.servlet.AboutServlet;
import org.eclipse.help.internal.webapp.servlet.PreferenceWriter;
import org.eclipse.help.internal.webapp.servlet.XMLGenerator;
import org.osgi.framework.Bundle;

public class AboutService
extends AboutServlet {
    private static final long serialVersionUID = 1L;
    private long service;

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        boolean boolIsJSON;
        boolean boolIsHTML;
        req.setCharacterEncoding("UTF-8");
        String returnType = req.getParameter("returnType");
        boolean bl = boolIsHTML = returnType != null && returnType.equalsIgnoreCase("html");
        if (boolIsHTML) {
            super.doGet(req, resp);
            return;
        }
        resp.setHeader("Cache-Control", "no-store, no-cache, must-revalidate");
        resp.setContentType("application/xml; charset=UTF-8");
        this.locale = UrlUtil.getLocaleObj(req, resp);
        String response = this.processRequest(req, resp);
        boolean bl2 = boolIsJSON = returnType != null && returnType.equalsIgnoreCase("json");
        if (boolIsJSON) {
            resp.setContentType("text/plain");
            response = this.getJSONResponse(response);
        }
        resp.getWriter().write(response);
    }

    protected String getJSONResponse(String response) throws IOException {
        AboutParser aboutParser = new AboutParser(this.service);
        InputStream is = null;
        try {
            if (response != null) {
                is = new ByteArrayInputStream(response.getBytes("UTF-8"));
                aboutParser.parse(is);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (is != null) {
            is.close();
        }
        return aboutParser.toJSON();
    }

    private String processRequest(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        StringBuffer buf = new StringBuffer();
        buf.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        String showParam = req.getParameter("show");
        if ("agent".equalsIgnoreCase(showParam)) {
            this.getAgent(buf, req, resp);
        } else if ("preferences".equalsIgnoreCase(showParam)) {
            this.getPreferences(buf, resp);
        } else {
            this.getAboutPlugins(buf, req, resp);
        }
        return buf.toString();
    }

    private void getAgent(StringBuffer buf, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.service = 1L;
        String title = WebappResources.getString("userAgent", this.locale);
        String agent = req.getHeader("User-Agent");
        buf.append("<userAgent\n      title=\"");
        buf.append(XMLGenerator.xmlEscape(title));
        buf.append("\">");
        buf.append(agent);
        buf.append("</userAgent>");
    }

    private void getPreferences(StringBuffer buf, HttpServletResponse resp) throws IOException {
        this.service = 2L;
        String title = WebappResources.getString("preferences", this.locale);
        buf.append("<preferences\n      title=\"");
        buf.append(XMLGenerator.xmlEscape(title));
        buf.append("\">");
        PreferenceWriter writer = new PreferenceWriter(buf, this.locale, true);
        writer.writePreferences();
        buf.append("\n</preferences>");
    }

    private void getAboutPlugins(StringBuffer buf, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.service = 3L;
        String sortParam = req.getParameter("sortColumn");
        int sortColumn = 3;
        if (sortParam != null) {
            try {
                sortColumn = Integer.parseInt(sortParam);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        String title = WebappResources.getString("aboutPlugins", this.locale);
        buf.append("<aboutPlugins\n      title=\"");
        buf.append(XMLGenerator.xmlEscape(title));
        buf.append("\"");
        ArrayList<Object> plugins = new ArrayList<Object>();
        Bundle[] bundles = HelpWebappPlugin.getContext().getBundles();
        int k = 0;
        while (k < bundles.length) {
            plugins.add(this.pluginDetails(bundles[k]));
            ++k;
        }
        AboutServlet.PluginComparator pluginComparator = new AboutServlet.PluginComparator(this, sortColumn);
        Collections.sort(plugins, pluginComparator);
        String[] headerColumns = new String[]{"provider", "pluginName", "version", "pluginId"};
        int i = 0;
        while (i < headerColumns.length) {
            buf.append("\n          ");
            buf.append(headerColumns[i]);
            buf.append("=\"");
            buf.append(XMLGenerator.xmlEscape(WebappResources.getString(headerColumns[i], this.locale)));
            buf.append("\"");
            ++i;
        }
        buf.append(">");
        Iterator iter = plugins.iterator();
        while (iter.hasNext()) {
            AboutServlet.PluginDetails details = (AboutServlet.PluginDetails)iter.next();
            buf.append("\n        <plugin");
            int i2 = 0;
            while (i2 < headerColumns.length) {
                buf.append("\n          ");
                buf.append(headerColumns[i2]);
                buf.append("=\"");
                buf.append(XMLGenerator.xmlEscape(details.columns[i2]));
                buf.append("\"");
                ++i2;
            }
            buf.append(">\n        </plugin>");
        }
        buf.append("\n</aboutPlugins>");
    }
}

