/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl;

import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.birt.data.engine.api.DataEngine;
import org.eclipse.birt.data.engine.api.IBaseDataSetDesign;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.core.security.URLSecurity;
import org.eclipse.birt.data.engine.impl.IIncreCacheDataSetDesign;
import org.eclipse.birt.data.engine.impl.OdaDataSetAdapter;

class IncreCacheDataSetAdapter
extends OdaDataSetAdapter
implements IIncreCacheDataSetDesign {
    private static final String DATE = "\\Q${DATE}$\\E";
    private static final String TS_COLUMN = "\\Q${TIMESTAMP-COLUMN}$\\E";
    private static final String TS_FORMAT = "\\Q${TIMESTAMP-FORMAT}$\\E";
    protected URL configFileUrl;
    protected String queryTemplate;
    protected String timestampColumn;
    protected String formatPattern;
    protected int cacheMode;
    private String queryForUpdate;

    public IncreCacheDataSetAdapter(IBaseDataSetDesign source) {
        super(source);
    }

    @Override
    public int getCacheMode() {
        return this.cacheMode;
    }

    @Override
    public URL getConfigFileUrl() {
        return this.configFileUrl;
    }

    @Override
    public String getQueryForUpdate(long timestamp) {
        return this.parseQuery(timestamp);
    }

    private String parseQuery(long time) {
        SimpleDateFormat formater = new SimpleDateFormat(this.formatPattern);
        String timestamp = formater.format(new Timestamp(time));
        if (this.queryForUpdate == null) {
            this.queryForUpdate = this.replaceIgnoreCase(this.queryTemplate, TS_COLUMN, this.timestampColumn);
            this.queryForUpdate = this.replaceIgnoreCase(this.queryForUpdate, TS_FORMAT, this.formatPattern);
        }
        return this.replaceIgnoreCase(this.queryForUpdate, DATE, timestamp);
    }

    private String replaceIgnoreCase(String source, CharSequence target, CharSequence replacement) {
        return Pattern.compile(target.toString(), 2).matcher(source).replaceAll(IncreCacheDataSetAdapter.quote(replacement.toString()));
    }

    private static String quote(String s) {
        if (s.indexOf(92) == -1 && s.indexOf(36) == -1) {
            return s;
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (c == '\\') {
                sb.append('\\');
                sb.append('\\');
            } else if (c == '$') {
                sb.append('\\');
                sb.append('$');
            } else {
                sb.append(c);
            }
            ++i;
        }
        return sb.toString();
    }

    @Override
    public String getTimestampColumn() {
        return this.timestampColumn;
    }

    public void setConfigFileUrl(URL configFileUrl) {
        this.configFileUrl = configFileUrl;
    }

    public void setQueryTemplate(String queryTemplate) {
        this.queryTemplate = queryTemplate;
    }

    public void setTimestampColumn(String timestampColumn) {
        this.timestampColumn = timestampColumn;
    }

    public void setFormatPattern(String formatPattern) {
        this.formatPattern = formatPattern;
    }

    public void setCacheMode(int cacheMode) {
        this.cacheMode = cacheMode;
    }

    public static URL getConfigFileURL(Map appContext) throws DataException {
        if (appContext != null) {
            Object configValue = appContext.get(DataEngine.INCREMENTAL_CACHE_CONFIG);
            URL url = null;
            if (configValue instanceof URL) {
                url = (URL)configValue;
            } else if (configValue instanceof String) {
                String configPath = configValue.toString();
                try {
                    url = URLSecurity.getURL(configPath);
                }
                catch (MalformedURLException malformedURLException) {
                    try {
                        url = URLSecurity.getURL("file", "/", configPath);
                    }
                    catch (MalformedURLException malformedURLException2) {
                        return null;
                    }
                }
            }
            return url;
        }
        return null;
    }
}

