/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.birt.data.engine.api.querydefn.ConditionalExpression;
import org.eclipse.birt.data.engine.api.querydefn.FilterDefinition;
import org.eclipse.birt.data.engine.api.querydefn.GroupDefinition;
import org.eclipse.birt.data.engine.api.querydefn.InputParameterBinding;
import org.eclipse.birt.data.engine.api.querydefn.OdaDataSetDesign;
import org.eclipse.birt.data.engine.api.querydefn.OdaDataSourceDesign;
import org.eclipse.birt.data.engine.api.querydefn.QueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.data.engine.api.querydefn.SortDefinition;

public final class LogUtil {
    private LogUtil() {
    }

    public static String toString(Object source) {
        if (source instanceof Collection) {
            return LogUtil.toString_Collection(source);
        }
        if (source instanceof FilterDefinition) {
            return LogUtil.toString_FilterDefinition(source);
        }
        if (source instanceof ConditionalExpression) {
            return LogUtil.toString_ConditionalExpression(source);
        }
        if (source instanceof ScriptExpression) {
            return LogUtil.toString_ScriptExpression(source);
        }
        if (source instanceof InputParameterBinding) {
            return LogUtil.toString_InputParameterBinding(source);
        }
        if (source instanceof GroupDefinition) {
            return LogUtil.toString_GroupDefinition(source);
        }
        if (source instanceof SortDefinition) {
            return LogUtil.toString_SortDefinition(source);
        }
        if (source instanceof QueryDefinition) {
            return LogUtil.toString_QueryDefinition(source);
        }
        if (source instanceof OdaDataSetDesign) {
            return LogUtil.toString_OdaDataSetDesign(source);
        }
        if (source instanceof OdaDataSourceDesign) {
            return LogUtil.toString_OdaDataSourceDesign(source);
        }
        if (source == null) {
            return "null";
        }
        return source.toString();
    }

    private static String toString_Collection(Object source) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = ((Collection)source).iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(String.valueOf(LogUtil.toString(iterator.next())) + ", \r\n\t");
        }
        String str = stringBuffer.toString();
        if (str.endsWith("\t")) {
            str = str.substring(0, str.length() - 5);
        }
        return str;
    }

    private static String toString_FilterDefinition(Object source) {
        return "FilterDefinition(" + LogUtil.toString(((FilterDefinition)source).getExpression()) + ")";
    }

    private static String toString_ConditionalExpression(Object source) {
        StringBuffer stringBuffer = new StringBuffer("ConditionalExpression(");
        ConditionalExpression conditionalExpression = (ConditionalExpression)source;
        stringBuffer.append("Operator : " + conditionalExpression.getOperator() + ", ");
        stringBuffer.append("Expression : " + LogUtil.toString(conditionalExpression.getExpression()) + ", ");
        if (!LogUtil.isEmpty(conditionalExpression.getOperand1())) {
            stringBuffer.append("Operand1 : " + LogUtil.toString(conditionalExpression.getOperand1()) + ", ");
        }
        if (!LogUtil.isEmpty(conditionalExpression.getOperand2())) {
            stringBuffer.append("Operand2 : " + LogUtil.toString(conditionalExpression.getOperand2()) + ")");
        }
        return stringBuffer.toString();
    }

    private static String toString_ScriptExpression(Object source) {
        return "ScriptExpression(Text:" + ((ScriptExpression)source).getText() + ")";
    }

    private static String toString_InputParameterBinding(Object source) {
        InputParameterBinding inputParameterBinding = (InputParameterBinding)source;
        StringBuffer stringBuffer = new StringBuffer("InputParameterBinding(");
        if (!LogUtil.isEmpty(inputParameterBinding.getName())) {
            stringBuffer.append("Name : " + inputParameterBinding.getName() + ", ");
        }
        stringBuffer.append("Position : " + inputParameterBinding.getPosition() + ", ");
        stringBuffer.append("Expression : " + LogUtil.toString(inputParameterBinding.getExpr()));
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    private static String toString_SortDefinition(Object source) {
        SortDefinition sort = (SortDefinition)source;
        StringBuffer stringBuffer = new StringBuffer("SortDefinition(");
        if (!LogUtil.isEmpty(sort.getColumn())) {
            stringBuffer.append("Column : " + sort.getColumn() + ", ");
        }
        if (!LogUtil.isEmpty(sort.getExpression())) {
            stringBuffer.append("getExpression : " + sort.getExpression() + ", ");
        }
        stringBuffer.append("SortDirection : " + sort.getSortDirection() + ",");
        stringBuffer.append("SortStrength : " + sort.getSortStrength() + ",");
        stringBuffer.append("SortLocale : " + sort.getSortLocale() + ")");
        return stringBuffer.toString();
    }

    private static String toString_GroupDefinition(Object source) {
        GroupDefinition group = (GroupDefinition)source;
        StringBuffer stringBuffer = new StringBuffer("GroupDefinition(");
        if (!LogUtil.isEmpty(group.getName())) {
            stringBuffer.append("Name : " + group.getName() + ", ");
        }
        if (!LogUtil.isEmpty(group.getKeyColumn())) {
            stringBuffer.append("KeyColumn : " + group.getKeyColumn() + ", ");
        }
        if (!LogUtil.isEmpty(group.getKeyExpression())) {
            stringBuffer.append("KeyExpression : " + group.getKeyExpression() + ", ");
        }
        stringBuffer.append("SortDirection : " + group.getSortDirection() + ", ");
        stringBuffer.append("Interval : " + group.getInterval() + ", ");
        stringBuffer.append("IntervalRange : " + group.getIntervalRange() + ", ");
        if (!LogUtil.isEmpty(group.getIntervalStart())) {
            stringBuffer.append("IntervalStart : " + group.getIntervalStart() + ", ");
        }
        if (!LogUtil.isEmpty(group.getSubqueries())) {
            stringBuffer.append("Subqueries : " + LogUtil.toString(group.getSubqueries()) + ", ");
        }
        if (!LogUtil.isEmpty(group.getSorts())) {
            stringBuffer.append("Sorts : " + LogUtil.toString(group.getSorts()) + ", ");
        }
        if (!LogUtil.isEmpty(group.getFilters())) {
            stringBuffer.append("Filters : " + LogUtil.toString(group.getFilters()));
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    private static String toString_QueryDefinition(Object source) {
        QueryDefinition querySpec = (QueryDefinition)source;
        StringBuffer stringBuffer = new StringBuffer("QueryDefinition(");
        stringBuffer.append("DataSetName : " + querySpec.getDataSetName() + "\r\n");
        if (!LogUtil.isEmpty(querySpec.getBindings())) {
            stringBuffer.append("ResultSetExpressions : " + LogUtil.toString(querySpec.getBindings()) + "\r\n");
        }
        if (!LogUtil.isEmpty(querySpec.getParentQuery())) {
            stringBuffer.append("ParentQuery : " + LogUtil.toString(querySpec.getParentQuery()) + "\r\n");
        }
        if (!LogUtil.isEmpty(querySpec.getSubqueries())) {
            stringBuffer.append("Subqueries : " + LogUtil.toString(querySpec.getSubqueries()) + "\r\n");
        }
        stringBuffer.append("MaxRows : " + querySpec.getMaxRows() + "\r\n");
        if (!LogUtil.isEmpty(querySpec.getColumnProjection())) {
            int i = 0;
            while (i < querySpec.getColumnProjection().length) {
                stringBuffer.append("ColumnProjection : " + querySpec.getColumnProjection()[i] + "   ");
                ++i;
            }
            stringBuffer.append("\r\n");
        }
        if (!LogUtil.isEmpty(querySpec.getGroups())) {
            stringBuffer.append("Groups : " + LogUtil.toString(querySpec.getGroups()) + "\r\n");
        }
        if (!LogUtil.isEmpty(querySpec.getFilters())) {
            stringBuffer.append("Filters : " + LogUtil.toString(querySpec.getFilters()) + "\r\n");
        }
        if (!LogUtil.isEmpty(querySpec.getSorts())) {
            stringBuffer.append("Sorts : " + LogUtil.toString(querySpec.getSorts()) + "\r\n");
        }
        if (!LogUtil.isEmpty(querySpec.getInputParamBindings())) {
            stringBuffer.append("InputParamBindings : " + LogUtil.toString(querySpec.getInputParamBindings()) + ")\r\n");
        }
        return stringBuffer.toString();
    }

    private static String toString_OdaDataSetDesign(Object source) {
        OdaDataSetDesign dataSet = (OdaDataSetDesign)source;
        StringBuffer stringBuffer = new StringBuffer("OdaDataSetDesign(");
        if (!LogUtil.isEmpty(dataSet.getName())) {
            stringBuffer.append("Name : " + dataSet.getName() + "\r\n");
        }
        if (!LogUtil.isEmpty(dataSet.getDataSourceName())) {
            stringBuffer.append("DataSourceName : " + dataSet.getDataSourceName() + "\r\n");
        }
        if (!LogUtil.isEmpty(dataSet.getAfterCloseScript())) {
            stringBuffer.append("AfterCloseScript : " + dataSet.getAfterCloseScript() + "\r\n");
        }
        if (!LogUtil.isEmpty(dataSet.getAfterOpenScript())) {
            stringBuffer.append("AfterOpenScript : " + dataSet.getAfterOpenScript() + "\r\n");
        }
        if (!LogUtil.isEmpty(dataSet.getBeforeCloseScript())) {
            stringBuffer.append("BeforeCloseScript : " + dataSet.getBeforeCloseScript() + "\r\n");
        }
        if (!LogUtil.isEmpty(dataSet.getBeforeOpenScript())) {
            stringBuffer.append("BeforeOpenScript : " + dataSet.getBeforeOpenScript() + "\r\n");
        }
        if (!LogUtil.isEmpty(dataSet.getOnFetchScript())) {
            stringBuffer.append("OnFetchScript : " + dataSet.getOnFetchScript() + "\r\n");
        }
        if (!LogUtil.isEmpty(dataSet.getComputedColumns())) {
            stringBuffer.append("ComputedColumns : " + LogUtil.toString(dataSet.getComputedColumns()) + "\r\n");
        }
        if (!LogUtil.isEmpty(dataSet.getFilters())) {
            stringBuffer.append("Filters : " + LogUtil.toString(dataSet.getFilters()) + "\r\n");
        }
        if (!LogUtil.isEmpty(dataSet.getParameters())) {
            stringBuffer.append("Parameters : " + LogUtil.toString(dataSet.getParameters()) + "\r\n");
        }
        if (!LogUtil.isEmpty(dataSet.getInputParamBindings())) {
            stringBuffer.append("InputParamBindings : " + LogUtil.toString(dataSet.getInputParamBindings()) + "\r\n");
        }
        if (!LogUtil.isEmpty(dataSet.getResultSetHints())) {
            stringBuffer.append("ResultSetHints : " + LogUtil.toString(dataSet.getResultSetHints()) + "\r\n");
        }
        if (!LogUtil.isEmpty(dataSet.getExtensionID())) {
            stringBuffer.append("ExtensionID : " + dataSet.getExtensionID() + "\r\n");
        }
        if (!LogUtil.isEmpty(dataSet.getPrimaryResultSetName())) {
            stringBuffer.append("PrimaryResultSetName : " + dataSet.getPrimaryResultSetName() + "\r\n");
        }
        if (!LogUtil.isEmpty(dataSet.getQueryText())) {
            stringBuffer.append("QueryText : " + dataSet.getQueryText() + "\r\n");
        }
        if (!LogUtil.isEmpty(dataSet.getPrivateProperties())) {
            stringBuffer.append("PrivateProperties : " + LogUtil.toString(dataSet.getPrivateProperties()) + "\r\n");
        }
        if (!LogUtil.isEmpty(dataSet.getPublicProperties())) {
            stringBuffer.append("PublicProperties : " + LogUtil.toString(dataSet.getPublicProperties()) + "\r\n");
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    private static String toString_OdaDataSourceDesign(Object source) {
        OdaDataSourceDesign dataSource = (OdaDataSourceDesign)source;
        StringBuffer stringBuffer = new StringBuffer("OdaDataSourceDesign(");
        if (!LogUtil.isEmpty(dataSource.getName())) {
            stringBuffer.append("Name : " + dataSource.getName() + "\r\n");
        }
        if (!LogUtil.isEmpty(dataSource.getAfterCloseScript())) {
            stringBuffer.append("AfterCloseScript : " + dataSource.getAfterCloseScript() + "\r\n");
        }
        if (!LogUtil.isEmpty(dataSource.getAfterOpenScript())) {
            stringBuffer.append("AfterOpenScript : " + dataSource.getAfterOpenScript() + "\r\n");
        }
        if (!LogUtil.isEmpty(dataSource.getBeforeCloseScript())) {
            stringBuffer.append("BeforeCloseScript : " + dataSource.getBeforeCloseScript() + "\r\n");
        }
        if (!LogUtil.isEmpty(dataSource.getBeforeOpenScript())) {
            stringBuffer.append("BeforeOpenScript : " + dataSource.getBeforeOpenScript() + "\r\n");
        }
        if (!LogUtil.isEmpty(dataSource.getExtensionID())) {
            stringBuffer.append("ExtensionID : " + dataSource.getExtensionID() + "\r\n");
        }
        if (!LogUtil.isEmpty(dataSource.getPrivateProperties())) {
            stringBuffer.append("PrivateProperties : " + dataSource.getPrivateProperties() + "\r\n");
        }
        if (!LogUtil.isEmpty(dataSource.getPublicProperties())) {
            Map publicProperties = dataSource.getPublicProperties();
            String logMsg = " PulicProperties : ";
            for (Map.Entry entry : publicProperties.entrySet()) {
                String propName = entry.getKey().toString();
                String lcPropName = propName.toLowerCase();
                String propVal = lcPropName.indexOf("password") >= 0 || lcPropName.indexOf("pwd") >= 0 ? "***" : entry.getValue().toString();
                logMsg = String.valueOf(logMsg) + propName + "=" + propVal + ";";
            }
            stringBuffer.append(String.valueOf(logMsg) + "\r\n");
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    private static boolean isEmpty(Object source) {
        return source == null || "".equals(LogUtil.toString(source));
    }
}

