/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.cursor;

import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.ULocale;
import java.util.ArrayList;
import java.util.Date;
import org.eclipse.birt.data.engine.olap.cursor.MemberTreeNode;
import org.eclipse.birt.data.engine.olap.cursor.MirrorMetaInfo;
import org.eclipse.birt.data.engine.olap.data.api.DimLevel;
import org.eclipse.birt.data.engine.olap.data.api.IAggregationResultSet;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.Member;

class TimeMemberUtil {
    private static final String DATE_TIME_LEVEL_TYPE_MONTH = "month";
    private static final String DATE_TIME_LEVEL_TYPE_QUARTER = "quarter";
    private static final String DATE_TIME_LEVEL_TYPE_DAY_OF_YEAR = "day-of-year";
    private static final String DATE_TIME_LEVEL_TYPE_DAY_OF_MONTH = "day-of-month";
    private static final String DATE_TIME_LEVEL_TYPE_DAY_OF_WEEK = "day-of-week";
    private static final String DATE_TIME_LEVEL_TYPE_HOUR = "hour";
    private static final String DATE_TIME_LEVEL_TYPE_MINUTE = "minute";
    private static final String DATE_TIME_LEVEL_TYPE_SECOND = "second";
    private static final String DATE_TIME_LEVEL_TYPE_WEEK_OF_MONTH = "week-of-month";
    private static final String DATE_TIME_LEVEL_TYPE_WEEK_OF_YEAR = "week-of-year";
    private static final String DATE_TIME_LEVEL_TYPE_YEAR = "year";
    private static Calendar calendar;

    TimeMemberUtil() {
    }

    public static MemberTreeNode[] getDateTimeNodes(DimLevel[] dimLevels, Object dateTimeValue, int index, MirrorMetaInfo service) {
        String[] dateTypes = new String[dimLevels.length - index];
        int i = index;
        while (i < dimLevels.length) {
            dateTypes[i - index] = service.getLevelType(dimLevels[i]);
            ++i;
        }
        calendar = Calendar.getInstance((ULocale)service.getSession().getEngineContext().getLocale());
        calendar.setTimeZone(service.getSession().getEngineContext().getTimeZone());
        calendar.clear();
        MemberTreeNode[] secondsNode = null;
        MemberTreeNode[] minutesNode = null;
        MemberTreeNode[] hoursNode = null;
        MemberTreeNode[] dayOfYearNode = null;
        MemberTreeNode[] dayOfMonthNode = null;
        MemberTreeNode[] dayOfWeekNode = null;
        MemberTreeNode[] monthNode = null;
        MemberTreeNode[] parent = null;
        ArrayList<MemberTreeNode[]> temp = new ArrayList<MemberTreeNode[]>();
        ArrayList<MemberTreeNode[]> parentList = new ArrayList<MemberTreeNode[]>();
        int i2 = 0;
        while (i2 < dateTypes.length) {
            int year;
            int t;
            temp.clear();
            if (DATE_TIME_LEVEL_TYPE_SECOND.equals(dateTypes[i2])) {
                if (parentList.size() > 0) {
                    t = 0;
                    while (t < parentList.size()) {
                        MemberTreeNode[] nodes = (MemberTreeNode[])parentList.get(t);
                        int j = 0;
                        while (j < nodes.length) {
                            secondsNode = TimeMemberUtil.createSecond();
                            nodes[j].addAllNodes(secondsNode);
                            temp.add(secondsNode);
                            ++j;
                        }
                        ++t;
                    }
                    parentList.clear();
                    parentList.addAll(temp);
                } else {
                    parent = secondsNode = TimeMemberUtil.createSecond();
                    parentList.clear();
                    parentList.add(secondsNode);
                }
            } else if (DATE_TIME_LEVEL_TYPE_MINUTE.equals(dateTypes[i2])) {
                if (parentList.size() > 0) {
                    t = 0;
                    while (t < parentList.size()) {
                        MemberTreeNode[] nodes = (MemberTreeNode[])parentList.get(t);
                        int j = 0;
                        while (j < nodes.length) {
                            minutesNode = TimeMemberUtil.createMinute();
                            nodes[j].addAllNodes(minutesNode);
                            temp.add(minutesNode);
                            ++j;
                        }
                        ++t;
                    }
                    parentList.clear();
                    parentList.addAll(temp);
                } else {
                    parent = minutesNode = TimeMemberUtil.createMinute();
                    parentList.clear();
                    parentList.add(minutesNode);
                }
            } else if (DATE_TIME_LEVEL_TYPE_HOUR.equals(dateTypes[i2])) {
                if (parentList.size() > 0) {
                    t = 0;
                    while (t < parentList.size()) {
                        MemberTreeNode[] nodes = (MemberTreeNode[])parentList.get(t);
                        int j = 0;
                        while (j < nodes.length) {
                            hoursNode = TimeMemberUtil.createHour();
                            nodes[j].addAllNodes(hoursNode);
                            temp.add(hoursNode);
                            ++j;
                        }
                        ++t;
                    }
                    parentList.clear();
                    parentList.addAll(temp);
                } else {
                    parent = hoursNode = TimeMemberUtil.createHour();
                    parentList.clear();
                    parentList.add(hoursNode);
                }
            } else if (DATE_TIME_LEVEL_TYPE_DAY_OF_YEAR.equals(dateTypes[i2])) {
                year = TimeMemberUtil.getCalendar((Date)dateTimeValue).get(1);
                if (parentList.size() > 0) {
                    int t2 = 0;
                    while (t2 < parentList.size()) {
                        MemberTreeNode[] nodes = (MemberTreeNode[])parentList.get(t2);
                        int j = 0;
                        while (j < nodes.length) {
                            dayOfYearNode = TimeMemberUtil.createDayOfYearNode(year);
                            nodes[j].addAllNodes(dayOfYearNode);
                            temp.add(dayOfYearNode);
                            ++j;
                        }
                        ++t2;
                    }
                    parentList.clear();
                    parentList.addAll(temp);
                } else {
                    parent = dayOfYearNode = TimeMemberUtil.createDayOfYearNode(year);
                    parentList.clear();
                    parentList.add(dayOfYearNode);
                }
            } else if (DATE_TIME_LEVEL_TYPE_DAY_OF_MONTH.equals(dateTypes[i2])) {
                year = TimeMemberUtil.getCalendar((Date)dateTimeValue).get(1);
                int month = TimeMemberUtil.getCalendar((Date)dateTimeValue).get(2);
                boolean isUnderMonthHierarchy = false;
                if (i2 > 0) {
                    isUnderMonthHierarchy = TimeMemberUtil.isDayMonth(dateTypes[i2 - 1]);
                }
                if (parentList.size() > 0) {
                    int t3 = 0;
                    while (t3 < parentList.size()) {
                        MemberTreeNode[] nodes = (MemberTreeNode[])parentList.get(t3);
                        int j = 0;
                        while (j < nodes.length) {
                            dayOfMonthNode = isUnderMonthHierarchy ? TimeMemberUtil.createDayOfMonth(year, (Integer)((Member)nodes[j].key).getKeyValues()[0]) : TimeMemberUtil.createDayOfMonth(year, month + 1);
                            nodes[j].addAllNodes(dayOfMonthNode);
                            temp.add(dayOfMonthNode);
                            ++j;
                        }
                        ++t3;
                    }
                    parentList.clear();
                    parentList.addAll(temp);
                } else {
                    parent = dayOfMonthNode = TimeMemberUtil.createDayOfMonth(year, month + 1);
                    parentList.clear();
                    parentList.add(dayOfMonthNode);
                }
            } else if (DATE_TIME_LEVEL_TYPE_DAY_OF_WEEK.equals(dateTypes[i2])) {
                if (parentList.size() > 0) {
                    t = 0;
                    while (t < parentList.size()) {
                        MemberTreeNode[] nodes = (MemberTreeNode[])parentList.get(t);
                        int j = 0;
                        while (j < nodes.length) {
                            dayOfWeekNode = TimeMemberUtil.createDayOfWeek();
                            nodes[j].addAllNodes(dayOfWeekNode);
                            temp.add(dayOfWeekNode);
                            ++j;
                        }
                        ++t;
                    }
                    parentList.clear();
                    parentList.addAll(temp);
                } else {
                    parent = dayOfWeekNode = TimeMemberUtil.createDayOfWeek();
                    parentList.clear();
                    parentList.add(dayOfWeekNode);
                }
            } else if (DATE_TIME_LEVEL_TYPE_MONTH.equals(dateTypes[i2])) {
                if (TimeMemberUtil.isQuarterMonth(dateTypes)) {
                    t = 0;
                    while (t < parentList.size()) {
                        MemberTreeNode[] nodes = (MemberTreeNode[])parentList.get(t);
                        int k = 0;
                        while (k < nodes.length) {
                            monthNode = TimeMemberUtil.createQuarterMonthNode(k);
                            nodes[k].addAllNodes(monthNode);
                            temp.add(monthNode);
                            ++k;
                        }
                        ++t;
                    }
                    parentList.clear();
                    parentList.addAll(temp);
                } else {
                    parent = monthNode = TimeMemberUtil.createMonthNode();
                    parentList.add(parent);
                }
            } else if (DATE_TIME_LEVEL_TYPE_QUARTER.equals(dateTypes[i2])) {
                parent = TimeMemberUtil.createQuarterNode();
                parentList.add(parent);
            }
            ++i2;
        }
        return parent;
    }

    private static Calendar getCalendar(Date d) {
        if (d == null) {
            throw new IllegalArgumentException("date value is null!");
        }
        Calendar c = Calendar.getInstance();
        c.setTime(d);
        return c;
    }

    private static boolean isQuarterMonth(String[] types) {
        int i = 0;
        while (i < types.length) {
            if (DATE_TIME_LEVEL_TYPE_QUARTER.equals(types[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean isDayMonth(String types) {
        return DATE_TIME_LEVEL_TYPE_MONTH.equals(types);
    }

    private static MemberTreeNode[] createQuarterNode() {
        MemberTreeNode[] nodes = new MemberTreeNode[4];
        calendar.clear();
        int i = 1;
        while (i <= nodes.length) {
            Member member = new Member();
            member.setKeyValues(new Object[]{i});
            calendar.set(2, (i - 1) * 3);
            member.setAttributes(new Object[]{calendar.getTime()});
            nodes[i - 1] = new MemberTreeNode(member);
            ++i;
        }
        return nodes;
    }

    private static MemberTreeNode[] createMonthNode() {
        MemberTreeNode[] nodes = new MemberTreeNode[12];
        calendar.clear();
        int i = 1;
        while (i <= nodes.length) {
            Member member = new Member();
            member.setKeyValues(new Object[]{i});
            calendar.set(2, i - 1);
            member.setAttributes(new Object[]{calendar.getTime()});
            nodes[i - 1] = new MemberTreeNode(member);
            ++i;
        }
        return nodes;
    }

    private static MemberTreeNode[] createQuarterMonthNode(int quarter) {
        MemberTreeNode[] nodes = new MemberTreeNode[3];
        calendar.clear();
        switch (quarter) {
            case 0: {
                int i = 1;
                while (i <= nodes.length) {
                    Member member = new Member();
                    member.setKeyValues(new Object[]{i});
                    calendar.set(2, i - 1);
                    member.setAttributes(new Object[]{calendar.getTime()});
                    nodes[i - 1] = new MemberTreeNode(member);
                    ++i;
                }
                break;
            }
            case 1: {
                int i = 4;
                while (i <= nodes.length + 3) {
                    Member member = new Member();
                    member.setKeyValues(new Object[]{i});
                    calendar.set(2, i - 1);
                    member.setAttributes(new Object[]{calendar.getTime()});
                    nodes[i - 4] = new MemberTreeNode(member);
                    ++i;
                }
                break;
            }
            case 2: {
                int i = 7;
                while (i <= nodes.length + 6) {
                    Member member = new Member();
                    member.setKeyValues(new Object[]{i});
                    calendar.set(2, i - 1);
                    member.setAttributes(new Object[]{calendar.getTime()});
                    nodes[i - 7] = new MemberTreeNode(member);
                    ++i;
                }
                break;
            }
            case 3: {
                int i = 10;
                while (i <= nodes.length + 9) {
                    Member member = new Member();
                    member.setKeyValues(new Object[]{i});
                    calendar.set(2, i - 1);
                    member.setAttributes(new Object[]{calendar.getTime()});
                    nodes[i - 10] = new MemberTreeNode(member);
                    ++i;
                }
                break;
            }
        }
        return nodes;
    }

    private static MemberTreeNode[] createDayOfYearNode(int year) {
        calendar.clear();
        int count = 0;
        count = year % 4 == 0 && year % 100 != 0 || year % 400 == 0 ? 366 : 365;
        MemberTreeNode[] nodes = new MemberTreeNode[count];
        int i = 1;
        while (i <= count) {
            Member member = new Member();
            member.setKeyValues(new Object[]{i});
            calendar.set(6, i);
            member.setAttributes(new Object[]{calendar.getTime()});
            nodes[i - 1] = new MemberTreeNode(member);
            ++i;
        }
        return nodes;
    }

    private static MemberTreeNode[] createDayOfMonth(int year, int month) {
        boolean isLeapYear = false;
        if (year % 4 == 0 && year % 100 != 0 || year % 400 == 0) {
            isLeapYear = true;
        }
        MemberTreeNode[] nodes = new MemberTreeNode[]{};
        if (month == 1 || month == 3 || month == 5 || month == 7 || month == 8 || month == 10 || month == 12) {
            nodes = new MemberTreeNode[31];
            int i = 1;
            while (i <= nodes.length) {
                Member member = new Member();
                member.setKeyValues(new Object[]{new Integer(i)});
                calendar.set(2, month - 1);
                calendar.set(5, i);
                member.setAttributes(new Object[]{calendar.getTime()});
                nodes[i - 1] = new MemberTreeNode(member);
                ++i;
            }
        } else if (month == 2) {
            if (isLeapYear) {
                nodes = new MemberTreeNode[29];
                int i = 1;
                while (i <= nodes.length) {
                    Member member = new Member();
                    member.setKeyValues(new Object[]{i});
                    calendar.set(2, month - 1);
                    calendar.set(5, i);
                    member.setAttributes(new Object[]{calendar.getTime()});
                    nodes[i - 1] = new MemberTreeNode(member);
                    ++i;
                }
            } else {
                nodes = new MemberTreeNode[28];
                int i = 1;
                while (i <= nodes.length) {
                    Member member = new Member();
                    member.setKeyValues(new Object[]{i});
                    calendar.set(2, month - 1);
                    calendar.set(5, i);
                    member.setAttributes(new Object[]{calendar.getTime()});
                    nodes[i - 1] = new MemberTreeNode(member);
                    ++i;
                }
            }
        } else {
            nodes = new MemberTreeNode[30];
            int i = 1;
            while (i <= nodes.length) {
                Member member = new Member();
                member.setKeyValues(new Object[]{i});
                calendar.set(2, month - 1);
                calendar.set(5, i);
                member.setAttributes(new Object[]{calendar.getTime()});
                nodes[i - 1] = new MemberTreeNode(member);
                ++i;
            }
        }
        return nodes;
    }

    private static MemberTreeNode[] createDayOfWeek() {
        MemberTreeNode[] nodes = new MemberTreeNode[7];
        calendar.clear();
        int i = 1;
        while (i <= nodes.length) {
            Member member = new Member();
            member.setKeyValues(new Object[]{i});
            calendar.set(7, i);
            member.setAttributes(new Object[]{calendar.getTime()});
            nodes[i - 1] = new MemberTreeNode(member);
            ++i;
        }
        return nodes;
    }

    private static MemberTreeNode[] createHour() {
        MemberTreeNode[] nodes = new MemberTreeNode[24];
        calendar.clear();
        int i = 1;
        while (i <= nodes.length) {
            Member member = new Member();
            member.setKeyValues(new Object[]{i});
            calendar.set(11, i);
            member.setAttributes(new Object[]{calendar.getTime()});
            nodes[i - 1] = new MemberTreeNode(member);
            ++i;
        }
        return nodes;
    }

    private static MemberTreeNode[] createMinute() {
        MemberTreeNode[] nodes = new MemberTreeNode[60];
        calendar.clear();
        int i = 1;
        while (i <= nodes.length) {
            Member member = new Member();
            member.setKeyValues(new Object[]{i});
            calendar.set(12, i);
            member.setAttributes(new Object[]{calendar.getTime()});
            nodes[i - 1] = new MemberTreeNode(member);
            ++i;
        }
        return nodes;
    }

    private static MemberTreeNode[] createSecond() {
        MemberTreeNode[] nodes = new MemberTreeNode[60];
        calendar.clear();
        int i = 1;
        while (i <= nodes.length) {
            Member member = new Member();
            member.setKeyValues(new Object[]{i});
            calendar.set(13, i);
            member.setAttributes(new Object[]{calendar.getTime()});
            nodes[i - 1] = new MemberTreeNode(member);
            ++i;
        }
        return nodes;
    }

    public static boolean isTimeMirror(IAggregationResultSet rs, int index, MirrorMetaInfo service) {
        int i = index;
        while (i < rs.getLevelCount()) {
            if (rs.getLevelAttributes(i) == null || !TimeMemberUtil.isTimeMirrorAttributes(service.getLevelType(rs.getLevel(i)))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean containsTimeMirror(IAggregationResultSet rs, MirrorMetaInfo service) {
        int index = service.getMirrorStartPosition();
        return TimeMemberUtil.isTimeMirror(rs, index, service);
    }

    private static boolean isTimeMirrorAttributes(String types) {
        return types != null && !types.equals(DATE_TIME_LEVEL_TYPE_WEEK_OF_MONTH) && !types.equals(DATE_TIME_LEVEL_TYPE_WEEK_OF_YEAR) && !types.equals(DATE_TIME_LEVEL_TYPE_YEAR);
    }
}

