/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.remote.rse.core.miners;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.dstore.core.model.Handler;
import org.eclipse.ptp.internal.remote.rse.core.miners.CommandMinerThread;

public class OutputHandler
extends Handler {
    private DataInputStream _reader;
    private boolean _isStdError;
    private boolean _isTerminal;
    private CommandMinerThread fCommandThread;
    private boolean _isShell;
    private boolean _endOfStream = false;
    private List<String> _encodings;
    private BufferedReader fBufferedReader;
    private boolean fIsFinished;
    char[] buf = new char[1024];
    int readindex = 0;
    int writeindex = 0;

    public OutputHandler(DataInputStream reader, String qualifier, boolean isTerminal, boolean isStdError, boolean isShell, CommandMinerThread commandThread) {
        this._reader = reader;
        this._isStdError = isStdError;
        this._isTerminal = isTerminal;
        this.fCommandThread = commandThread;
        this._isShell = isShell;
        this._encodings = new ArrayList<String>();
        String system = System.getProperty("os.name").toLowerCase();
        if (system.startsWith("z")) {
            this._encodings.add("IBM-1047");
        } else {
            String specialEncoding = System.getProperty("dstore.stdin.encoding");
            if (specialEncoding != null) {
                this._encodings.add(specialEncoding);
            }
            this._encodings.add(System.getProperty("file.encoding"));
        }
        for (String encoding : this._encodings) {
            try {
                this.fBufferedReader = new BufferedReader(new InputStreamReader((InputStream)this._reader, encoding));
                break;
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
    }

    public synchronized void handle() {
        String[] lines = this.readLines();
        if (lines != null) {
            if (lines.length > 0) {
                int i = 0;
                while (i < lines.length) {
                    String ln = lines[i];
                    if (ln.indexOf(10) > 0) {
                        String[] lns = ln.split("\n");
                        int j = 0;
                        while (j < lns.length) {
                            String line = this.convertSpecialCharacters(lns[j]);
                            this.fCommandThread.interpretLine(line, this._isStdError);
                            ++j;
                        }
                    } else {
                        String line = this.convertSpecialCharacters(ln);
                        this.fCommandThread.interpretLine(line, this._isStdError);
                    }
                    ++i;
                }
                if (!this._isTerminal) {
                    this.doPrompt();
                }
                this.fCommandThread.refreshStatus();
            }
        } else {
            this.finish();
        }
    }

    public synchronized void finish() {
        if (!this.fIsFinished) {
            this.fIsFinished = true;
            super.finish();
            try {
                this.fBufferedReader.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private String convertSpecialCharacters(String input) {
        if (this.fCommandThread._supportsCharConversion) {
            StringBuffer output = new StringBuffer();
            int idx = 0;
            while (idx < input.length()) {
                char currChar = input.charAt(idx);
                switch (currChar) {
                    case '&': {
                        output.append("&#38;");
                        break;
                    }
                    case ';': {
                        output.append("&#59;");
                        break;
                    }
                    default: {
                        output.append(currChar);
                    }
                }
                ++idx;
            }
            return output.toString();
        }
        return input;
    }

    private void doPrompt() {
        block5: {
            try {
                if (this._isStdError || !this._isShell || this._reader.available() != 0 || this._isTerminal) break block5;
                try {
                    Thread.sleep(200L);
                    if (this._reader.available() == 0) {
                        this.fCommandThread.createPrompt(String.valueOf(this.fCommandThread.getCWD()) + '>', this.fCommandThread.getCWD());
                    }
                }
                catch (Exception exception) {}
            }
            catch (IOException e) {
                this.fCommandThread._dataStore.trace((Throwable)e);
            }
        }
    }

    private String[] readLines() {
        if (this._endOfStream || this.fBufferedReader == null) {
            return null;
        }
        ArrayList<String> outputLines = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        try {
            boolean lineFound = false;
            block7: do {
                int currVal = this.fBufferedReader.read();
                switch (currVal) {
                    case -1: {
                        this._endOfStream = true;
                        if (sb.length() <= 0) continue block7;
                        outputLines.add(sb.toString());
                        sb = new StringBuilder();
                        break;
                    }
                    case 10: 
                    case 13: {
                        if (sb.length() > 0) {
                            outputLines.add(sb.toString());
                            sb = new StringBuilder();
                            lineFound = true;
                        }
                        this.fBufferedReader.mark(65536);
                        break;
                    }
                    default: {
                        sb.append((char)currVal);
                    }
                }
            } while (!this._endOfStream && !lineFound);
            if (sb.length() > 0) {
                this.fBufferedReader.reset();
            }
        }
        catch (UnsupportedEncodingException e) {
            this.fCommandThread._dataStore.trace((Throwable)e);
        }
        catch (IOException e) {
            this._endOfStream = true;
            this.fCommandThread._dataStore.trace((Throwable)e);
        }
        return outputLines.toArray(new String[0]);
    }

    public synchronized void waitForInput() {
        try {
            Thread.sleep(100L);
        }
        catch (Exception exception) {}
    }
}

