/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.editor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EmptyStackException;
import java.util.List;
import java.util.Stack;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorElifStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorElseStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorEndifStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorIfStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorIfdefStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorIfndefStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorStatement;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.text.IBackgroundHighlight;
import org.eclipse.cdt.ui.text.ILineBackgroundPainter;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TypedPosition;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.RGB;

public class InactiveCodeHighlighting
implements IBackgroundHighlight,
IPropertyChangeListener {
    public static final String INACTIVE_CODE_COLOR = "inactiveCodeColor";
    public static final String INACTIVE_CODE_ENABLE = "inactiveCodeEnable";
    private static final String INACTIVE_CODE_KEY = "inactiveCode";
    private IDocument fDocument;
    private ILineBackgroundPainter fLineBackgroundPainter;
    private IPreferenceStore fPrefStore;

    @Override
    public List<Position> collectPositions(IASTTranslationUnit translationUnit) {
        IASTPreprocessorStatement[] preprocStmts;
        if (!this.isInactiveCodePositionsActive() || translationUnit == null) {
            return Collections.emptyList();
        }
        String fileName = translationUnit.getFilePath();
        if (fileName == null) {
            return Collections.emptyList();
        }
        ArrayList<Position> positions = new ArrayList<Position>();
        int inactiveCodeStart = -1;
        boolean inInactiveCode = false;
        Stack<Boolean> inactiveCodeStack = new Stack<Boolean>();
        IASTPreprocessorStatement[] iASTPreprocessorStatementArray = preprocStmts = translationUnit.getAllPreprocessorStatements();
        int n = preprocStmts.length;
        int n2 = 0;
        while (n2 < n) {
            IASTPreprocessorStatement statement = iASTPreprocessorStatementArray[n2];
            IASTFileLocation floc = statement.getFileLocation();
            if (floc != null && fileName.equals(floc.getFileName())) {
                int inactiveCodeEnd;
                if (statement instanceof IASTPreprocessorIfStatement) {
                    IASTPreprocessorIfStatement ifStmt = (IASTPreprocessorIfStatement)statement;
                    inactiveCodeStack.push(inInactiveCode);
                    if (!ifStmt.taken() && !inInactiveCode) {
                        inactiveCodeStart = floc.getNodeOffset();
                        inInactiveCode = true;
                    }
                } else if (statement instanceof IASTPreprocessorIfdefStatement) {
                    IASTPreprocessorIfdefStatement ifdefStmt = (IASTPreprocessorIfdefStatement)statement;
                    inactiveCodeStack.push(inInactiveCode);
                    if (!ifdefStmt.taken() && !inInactiveCode) {
                        inactiveCodeStart = floc.getNodeOffset();
                        inInactiveCode = true;
                    }
                } else if (statement instanceof IASTPreprocessorIfndefStatement) {
                    IASTPreprocessorIfndefStatement ifndefStmt = (IASTPreprocessorIfndefStatement)statement;
                    inactiveCodeStack.push(inInactiveCode);
                    if (!ifndefStmt.taken() && !inInactiveCode) {
                        inactiveCodeStart = floc.getNodeOffset();
                        inInactiveCode = true;
                    }
                } else if (statement instanceof IASTPreprocessorElseStatement) {
                    IASTPreprocessorElseStatement elseStmt = (IASTPreprocessorElseStatement)statement;
                    if (!elseStmt.taken() && !inInactiveCode) {
                        inactiveCodeStart = floc.getNodeOffset();
                        inInactiveCode = true;
                    } else if (elseStmt.taken() && inInactiveCode) {
                        inactiveCodeEnd = floc.getNodeOffset();
                        positions.add((Position)this.createHighlightPosition(inactiveCodeStart, inactiveCodeEnd, false, INACTIVE_CODE_KEY));
                        inInactiveCode = false;
                    }
                } else if (statement instanceof IASTPreprocessorElifStatement) {
                    IASTPreprocessorElifStatement elifStmt = (IASTPreprocessorElifStatement)statement;
                    if (!elifStmt.taken() && !inInactiveCode) {
                        inactiveCodeStart = floc.getNodeOffset();
                        inInactiveCode = true;
                    } else if (elifStmt.taken() && inInactiveCode) {
                        inactiveCodeEnd = floc.getNodeOffset();
                        positions.add((Position)this.createHighlightPosition(inactiveCodeStart, inactiveCodeEnd, false, INACTIVE_CODE_KEY));
                        inInactiveCode = false;
                    }
                } else if (statement instanceof IASTPreprocessorEndifStatement) {
                    try {
                        boolean wasInInactiveCode = (Boolean)inactiveCodeStack.pop();
                        if (inInactiveCode && !wasInInactiveCode) {
                            inactiveCodeEnd = floc.getNodeOffset() + floc.getNodeLength();
                            positions.add((Position)this.createHighlightPosition(inactiveCodeStart, inactiveCodeEnd, true, INACTIVE_CODE_KEY));
                        }
                        inInactiveCode = wasInInactiveCode;
                    }
                    catch (EmptyStackException emptyStackException) {}
                }
            }
            ++n2;
        }
        if (inInactiveCode) {
            int inactiveCodeEnd = this.fDocument.getLength();
            positions.add((Position)this.createHighlightPosition(inactiveCodeStart, inactiveCodeEnd, true, INACTIVE_CODE_KEY));
        }
        return positions;
    }

    private HighlightPosition createHighlightPosition(int startOffset, int endOffset, boolean inclusive, String key) {
        IDocument document = this.fDocument;
        try {
            if (document != null) {
                int start = document.getLineOfOffset(startOffset);
                int end = document.getLineOfOffset(endOffset);
                startOffset = document.getLineOffset(start);
                if (!inclusive) {
                    endOffset = document.getLineOffset(end);
                }
            }
        }
        catch (BadLocationException badLocationException) {}
        return new HighlightPosition(startOffset, endOffset - startOffset, key);
    }

    private RGB getColor(String key) {
        if (this.fPrefStore != null) {
            RGB rgb = PreferenceConverter.getColor((IPreferenceStore)this.fPrefStore, (String)key);
            return rgb;
        }
        return null;
    }

    private void hideInactiveCodePositions() {
        if (this.fLineBackgroundPainter != null) {
            this.fLineBackgroundPainter.refresh();
        }
    }

    @Override
    public void install(IDocument document, ILineBackgroundPainter lineBackgroundPainter) {
        assert (lineBackgroundPainter != null);
        this.fPrefStore = CUIPlugin.getDefault().getPreferenceStore();
        this.fLineBackgroundPainter = lineBackgroundPainter;
        this.fDocument = document;
        this.fLineBackgroundPainter.setBackgroundColor(INACTIVE_CODE_KEY, this.getColor(INACTIVE_CODE_COLOR));
        this.fPrefStore.addPropertyChangeListener((IPropertyChangeListener)this);
    }

    private boolean isInactiveCodePositionsActive() {
        if (this.fPrefStore != null) {
            return this.fPrefStore.getBoolean(INACTIVE_CODE_ENABLE);
        }
        return false;
    }

    public void propertyChange(PropertyChangeEvent event) {
        String p = event.getProperty();
        if (p.equals(INACTIVE_CODE_ENABLE)) {
            if (this.isInactiveCodePositionsActive()) {
                this.showInactiveCodePositions(true);
            } else {
                this.hideInactiveCodePositions();
            }
        } else if (p.equals(INACTIVE_CODE_COLOR)) {
            this.updateInactiveCodeColor();
        }
    }

    private void showInactiveCodePositions(boolean refresh) {
        if (this.fLineBackgroundPainter != null) {
            this.fLineBackgroundPainter.refresh();
        }
    }

    @Override
    public void uninstall() {
        if (this.fLineBackgroundPainter != null && !this.fLineBackgroundPainter.isDisposed()) {
            this.fLineBackgroundPainter = null;
        }
        this.fDocument = null;
    }

    private void updateInactiveCodeColor() {
        if (this.fLineBackgroundPainter != null) {
            this.fLineBackgroundPainter.setBackgroundColor(INACTIVE_CODE_KEY, this.getColor(INACTIVE_CODE_COLOR));
            if (this.isInactiveCodePositionsActive()) {
                this.fLineBackgroundPainter.refresh();
            }
        }
    }

    private static class HighlightPosition
    extends TypedPosition
    implements IRegion {
        public HighlightPosition(int offset, int length, String type) {
            super(offset, length, type);
        }

        public HighlightPosition(IRegion region, String type) {
            super(region.getOffset(), region.getLength(), type);
        }
    }
}

