/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper;

import com.nvidia.viper.ViperException;
import com.nvidia.viper.ViperExceptionHandler;
import com.nvidia.viper.ViperRunMode;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.xml.bind.DatatypeConverter;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.intro.IIntroPart;

public class Viper {
    public static String REBEL_UI_EXE = "ncu-ui";
    public static String REBEL_PRODUCT_NAME = "NVIDIA Nsight Compute";
    public static String REBEL_COMMAND_LINE_EXE = "ncu";
    public static String REBEL_COMMAND_LINE_EXT = ".ncu-rep";
    public static String REBEL_UI_FILE_OPTION = " ";
    public static String PGI_PRODUCT_VERSION = System.getenv("PGPROF_PRODUCT_VERSION");
    public static String PGI_PGEXPLAIN_LOCATION = System.getenv("PGI_PGEXPLAIN_LOCATION");
    public static final String PRODUCT_NAME = Viper.isPgiProduct() ? "PGPROF" : "NVIDIA Visual Profiler";
    public static final String SESSION_FILE_EXT = Viper.isPgiProduct() ? ".pgprof" : ".nvvp";
    public static final String REPORT_FILE_EXT = ".pdf";
    public static final String NVVP_FILE_TYPE = String.format("%s Files (*%s)", PRODUCT_NAME, SESSION_FILE_EXT);
    public static final String PDF_FILE_TYPE = String.format("PDF Files (%s)", ".pdf");
    public static final String PLUGIN_ID = "com.nvidia.viper";
    public static final String PERSPECTIVE_VIPER = "com.nvidia.viper.perspective";
    public static final String EDITOR_SESSION = "com.nvidia.viper.sessioneditor";
    public static final String EDITOR_SRC_SASS = "com.nvidia.viper.sourcesasseditor";
    public static final String ANALYSIS_VIEW = "com.nvidia.viper.analysisview";
    public static final String CONSOLE_VIEW = "com.nvidia.viper.consoleview";
    public static final String EXPERT_VIEW = "com.nvidia.viper.expertview";
    public static final String SETTINGS_VIEW = "com.nvidia.viper.settingsview";
    public static final String CPUTREE_VIEW = "com.nvidia.viper.cpuview";
    public static final String OPENACC_VIEW = "com.nvidia.viper.openaccview";
    public static final String OPENMP_VIEW = "com.nvidia.viper.openmpview";
    public static final String PROPERTIES_VIEW = "com.nvidia.viper.timelinepropertyview";
    public static final String FILE_MENU = "com.nvidia.viper.filemenu";
    public static final String VIEW_MENU = "com.nvidia.viper.viewmenu";
    public static final String WINDOW_MENU = "com.nvidia.viper.windowmenu";
    public static final String RUN_MENU = "com.nvidia.viper.runmenu";
    public static final String HELP_MENU = "com.nvidia.viper.helpmenu";
    public static final String DEBUG_MENU = "com.nvidia.viper.debugmenu";
    public static final String DO_NOT_SHOW_COLLECT_TIMELINE_PREF = "DoNotShowAgainCollectTimeline";
    public static final String DO_NOT_SHOW_DEPRECATE_MESSAGE_PREF = "DoNotShowDeprecatedMessage";
    public static final String COLLECT_TIMELINE_PREF = "CollectTimeline";
    public static final String SHOW_UVM_INFO_PREF = "ShowUvmInfo";
    public static final String SHOW_NVPROF_WARNING_INFO_PREF = "ShowNvprofWarningInfo";
    public static final String SHOW_VERSION_MISMATCH_WARNING_PREF = "ShowVersionMismatchWarning";
    public static final String PREF_SHOW_BAR_COL_CUDA = "ShowBarColCuda";
    public static final String PREF_SHOW_EXEC_COL_CUDA = "ShowExecCountColCuda";
    public static final String PREF_SHOW_BAR_COL_SASS = "ShowBarColSass";
    public static final String PREF_SHOW_EXEC_COL_SASS = "ShowExecCountColSass";
    public static final String PREF_SHOW_SAMPLING_BAR_COL_CUDA = "ShowSamplingBarColCuda";
    public static final String PREF_SHOW_SAMPLES_COL_CUDA = "ShowSamplesColCuda";
    public static final String PREF_SHOW_NO_STALL_SAMPLES_COL_CUDA = "ShowNoStallSamplesColCuda";
    public static final String PREF_SHOW_SAMPLING_BAR_COL_SASS = "ShowSamplingBarColSass";
    public static final String PREF_SHOW_SAMPLES_COL_SASS = "ShowSamplesColSass";
    public static final String PREF_SHOW_NO_STALL_SAMPLES_COL_SASS = "ShowNoStallSamplesColSass";
    public static final String PREF_OPEN_DIALOG_PATH = "OpenDialogPath";
    public static final String PREF_SAVE_DIALOG_PATH = "SaveDialogPath";
    public static final String PREF_SAVE_AS_PDF_PATH = "SaveAsPdfPath";
    public static final String PREF_IMPORT_PATH = "ImportPath";
    public static final String PREF_PATH_MAPPING_WIZARD_PATH = "PathMappingWizardPath";
    public static final String PREF_EXECUTABLE_PATH = "ExecutablePath";
    public static final String PREF_WORKING_DIR_PATH = "WorkingDirPath";
    public static final String PREF_PAGE_ID_DIALOGS = "com.nvidia.viper.ViperPreferencePage";
    public static final String PREF_PAGE_ID_WORKSPACES = "com.nvidia.viper.workspacepage";
    public static final String ENV_LARGE_PDM = "__LARGE_PDM";
    public static final String ENV_EMBED_REBEL = "EMBED_REBEL";
    public static final String PDM_LOAD_THREAD_NAME = "LoadPdm";
    public static final String PDM_LOAD_CANCEL = "LoadPdmCancel";
    public static final String TIMELINE_REFRESH_THREAD_NAME = "Timeline Refresh";
    public static final String EVENT_REFRESH_THREAD_NAME = "Event Refresh";
    public static final String PDM_EMPTY = "PDM_EMPTY";
    public static final String DEP_ANALYSIS_THREAD_NAME = "Dependency Analysis";
    public static final String SOURCE_SASS_VIEWER_THREAD_NAME = "Source Sass";
    public static final String COMMANDLINE_PRODUCT_NAME = Viper.isPgiProduct() ? "PGPROF" : "nvprof";
    public static final int MAX_REG_PER_THREAD = 255;

    public static boolean isPgiProduct() {
        return PGI_PRODUCT_VERSION != null;
    }

    public static void exit(int exitCode) {
        if (ViperRunMode.getRunMode().equals((Object)ViperRunMode.RunMode.TEST)) {
            ViperExceptionHandler.handle("Exit", "Exit", null);
        } else {
            System.exit(exitCode);
        }
    }

    public static void setWelcomePageStandby(IWorkbenchWindow window) {
        if (window != null) {
            IIntroPart introPart = window.getWorkbench().getIntroManager().getIntro();
            window.getWorkbench().getIntroManager().setIntroStandby(introPart, true);
        }
    }

    public static String serialize(Object obj) throws ViperException {
        String str = null;
        if (obj != null) {
            try {
                ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
                ObjectOutputStream objOut = new ObjectOutputStream(byteOut);
                objOut.writeObject(obj);
                objOut.flush();
                str = DatatypeConverter.printBase64Binary((byte[])byteOut.toByteArray());
                byteOut.close();
                objOut.close();
            }
            catch (Exception exception) {
                throw new ViperException("Unable to serialize object");
            }
        }
        return str;
    }

    public static <T> T deserialize(String strData, Class<T> cls) throws ViperException {
        T obj = null;
        if (strData != null && !strData.isEmpty()) {
            try {
                byte[] data = DatatypeConverter.parseBase64Binary((String)strData);
                ByteArrayInputStream byteInput = new ByteArrayInputStream(data);
                ObjectInputStream objInput = new ObjectInputStream(byteInput);
                obj = cls.cast(objInput.readObject());
                byteInput.close();
                objInput.close();
            }
            catch (Exception exception) {
                throw new ViperException("Unable to deserialize object");
            }
        }
        return obj;
    }

    public static boolean isTuringAndOnward(int major, int minor) {
        if (major > 7) {
            return true;
        }
        return major == 7 && minor >= 3;
    }
}

