/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.common.toolkit;

import java.util.regex.Pattern;

public enum ToolkitVersion {
    v5_5("CUDA Toolkit 5.5", "/usr/local/cuda-5.5/bin", "/Developer/NVIDIA/CUDA-5.5/bin", ".*release 5\\.5.*"),
    v6_0("CUDA Toolkit 6.0", "/usr/local/cuda-6.0/bin", "/Developer/NVIDIA/CUDA-6.0/bin", ".*release 6\\.0.*"),
    v6_5("CUDA Toolkit 6.5", "/usr/local/cuda-6.5/bin", "/Developer/NVIDIA/CUDA-6.5/bin", ".*release 6\\.5.*"),
    v7_0("CUDA Toolkit 7.0", "/usr/local/cuda-7.0/bin", "/Developer/NVIDIA/CUDA-7.0/bin", ".*release 7\\.0.*"),
    v7_5("CUDA Toolkit 7.5", "/usr/local/cuda-7.5/bin", "/Developer/NVIDIA/CUDA-7.5/bin", ".*release 7\\.5.*"),
    v8_0("CUDA Toolkit 8.0", "/usr/local/cuda-8.0/bin", "/Developer/NVIDIA/CUDA-8.0/bin", ".*release 8\\.0.*"),
    v9_0("CUDA Toolkit 9.0", "/usr/local/cuda-9.0/bin", "/Developer/NVIDIA/CUDA-9.0/bin", ".*release 9\\.0.*"),
    v9_1("CUDA Toolkit 9.1", "/usr/local/cuda-9.1/bin", "/Developer/NVIDIA/CUDA-9.1/bin", ".*release 9\\.1.*"),
    v9_2("CUDA Toolkit 9.2", "/usr/local/cuda-9.2/bin", "/Developer/NVIDIA/CUDA-9.2/bin", ".*release 9\\.2.*"),
    v10_0("CUDA Toolkit 10.0", "/usr/local/cuda-10.0/bin", "/Developer/NVIDIA/CUDA-10.0/bin", ".*release 10\\.0.*"),
    v10_1("CUDA Toolkit 10.1", "/usr/local/cuda-10.1/bin", "/Developer/NVIDIA/CUDA-10.1/bin", ".*release 10\\.1.*"),
    v10_2("CUDA Toolkit 10.2", "/usr/local/cuda-10.2/bin", "/Developer/NVIDIA/CUDA-10.2/bin", ".*release 10\\.2.*"),
    v11_2("CUDA Toolkit 11.2", "/usr/local/cuda-11.2/bin", "/Developer/NVIDIA/CUDA-11.2/bin", ".*release 11\\.2.*"),
    v11_3("CUDA Toolkit 11.3", "/usr/local/cuda-11.3/bin", "/Developer/NVIDIA/CUDA-11.3/bin", ".*release 11\\.3.*"),
    v11_4("CUDA Toolkit 11.4", "/usr/local/cuda-11.4/bin", "/Developer/NVIDIA/CUDA-11.4/bin", ".*release 11\\.4.*"),
    v11_5("CUDA Toolkit 11.5", "/usr/local/cuda-11.5/bin", "/Developer/NVIDIA/CUDA-11.5/bin", ".*release 11\\.5.*"),
    v11_6("CUDA Toolkit 11.6", "/usr/local/cuda-11.6/bin", "/Developer/NVIDIA/CUDA-11.6/bin", ".*release 11\\.6.*"),
    v11_7("CUDA Toolkit 11.7", "/usr/local/cuda-11.7/bin", "/Developer/NVIDIA/CUDA-11.7/bin", ".*release 11\\.7.*"),
    v11_8("CUDA Toolkit 11.8", "/usr/local/cuda-11.8/bin", "/Developer/NVIDIA/CUDA-11.8/bin", ".*release 11\\.8.*"),
    v12_0("CUDA Toolkit 12.0", "/usr/local/cuda-12.0/bin", "/Developer/NVIDIA/CUDA-12.1/bin", ".*release 12\\.1.*"),
    v12_1("CUDA Toolkit 12.1", "/usr/local/cuda-12.1/bin", "/Developer/NVIDIA/CUDA-12.1/bin", ".*release 12\\.1.*"),
    v12_2("CUDA Toolkit 12.2", "/usr/local/cuda-12.2/bin", "/Developer/NVIDIA/CUDA-12.2/bin", ".*release 12\\.2.*"),
    v12_3("CUDA Toolkit 12.3", "/usr/local/cuda-12.3/bin", "/Developer/NVIDIA/CUDA-12.3/bin", ".*release 12\\.3.*"),
    v12_4("CUDA Toolkit 12.4", "/usr/local/cuda-12.4/bin", "/Developer/NVIDIA/CUDA-12.4/bin", ".*release 12\\.4.*");

    public static ToolkitVersion[] supportedToolkits;
    public static ToolkitVersion latest;
    public final Pattern compilerVersionRegex;
    public final String defaultBinPath;
    public final String defaultMacBinPath;
    public final String label;

    static {
        supportedToolkits = new ToolkitVersion[]{v12_4, v12_3, v12_2, v12_1, v12_0, v11_8, v11_7, v11_6, v11_5, v11_4, v11_3, v11_2, v10_2, v10_1, v10_0, v9_2, v9_1, v9_0, v8_0, v7_5, v7_0, v6_5, v6_0};
        latest = supportedToolkits[0];
    }

    private ToolkitVersion(String label, String defaultBinPath, String defaultMacBinPath, String compilerVersionRegex) {
        this.label = label;
        this.defaultBinPath = defaultBinPath;
        this.defaultMacBinPath = defaultMacBinPath;
        this.compilerVersionRegex = Pattern.compile(compilerVersionRegex);
    }

    public boolean matches(String compilerOutput) {
        return this.compilerVersionRegex.matcher(compilerOutput).matches();
    }
}

