// Coordinates: 40.879820, 28.306729
// Map Width: 400km

RMS.LoadLibrary("rmgen");
RMS.LoadLibrary("rmgen2");

InitMap();

log("Initializing tile classes...");
setBiome(5);
initMapSettings();
initTileClasses();

log("Initializing environment...");

setSunColor(0.753, 0.586, 0.584);
setSkySet("sunset");

setWaterHeight(18);
setWaterTint(0.25, 0.67, 0.65);
setWaterColor(0.18, 0.36, 0.39);
setWaterWaviness(8);
setWaterMurkiness(0.99);
setWaterType("lake");

setTerrainAmbientColor(0.521, 0.475, 0.322);

setSunRotation(PI * .85);
setSunElevation(PI / 14);

setFogFactor(0.15);
setFogThickness(0);
setFogColor(0.64, 0.5, 0.35);

setPPEffect("hdr");
setPPContrast(0.67);
setPPSaturation(0.42);
setPPBloom(0.23);

log("Initializing biome...");

g_Terrains.mainTerrain = "grass_mediterranean_dry_1024test";
g_Terrains.forestFloor1 = "steppe_grass_dirt_66";
g_Terrains.forestFloor2 = "steppe_dirt_a";
g_Terrains.tier1Terrain = "medit_grass_field_b";
g_Terrains.tier2Terrain = "medit_grass_field_dry";
g_Terrains.tier3Terrain = "medit_shrubs_golden";
g_Terrains.tier4Terrain = "steppe_dirt_b";
g_Terrains.roadWild = "road_med_a";
g_Terrains.road = "road2";
g_Gaia.mainHuntableAnimal = "gaia/fauna_horse";
g_Gaia.secondaryHuntableAnimal =  "gaia/fauna_boar";
g_Gaia.fish = "gaia/fauna_fish";
g_Gaia.tree1 = "gaia/flora_tree_carob";
g_Gaia.tree2 = "gaia/flora_tree_poplar_lombardy";
g_Gaia.tree3 = "gaia/flora_tree_dead";
g_Gaia.tree4 = "gaia/flora_tree_dead";
g_Gaia.tree5 = "gaia/flora_tree_carob";
g_Gaia.fruitBush = "gaia/flora_bush_grapes";
g_Gaia.metalSmall = "gaia/geology_metal_desert_small";
g_Decoratives.grass = "actor|props/special/eyecandy/block_limestone.xml";
g_Decoratives.grassShort = "actor|props/special/eyecandy/blocks_sandstone_pile_a.xml";
g_Decoratives.rockLarge = "actor|geology/stone_savanna_med.xml";
g_Decoratives.rockMedium = "actor|geology/stone_granite_small.xml";
g_Decoratives.bushMedium = "actor|props/flora/bush_medit_me_dry.xml";
g_Decoratives.bushSmall = "actor|props/flora/bush_medit_sm_dry.xml";
g_Decoratives.reeds = "actor|props/flora/reeds_pond_lush_a.xml";

initBiome();
RMS.SetProgress(5);

log("Resetting terrain...");
resetTerrain(g_Terrains.mainTerrain, g_TileClasses.land, 1);
RMS.SetProgress(10);

log("Copying heightmap...");
var scale = paintHeightmap(getHeightMap(), getTileMap(), getTilePallet(), (tile, x, y) => {
	if (tile.indexOf("cliff") >= 0)
		addToClass(x, y, g_TileClasses.mountain);
});
RMS.SetProgress(30);

log("Paint tile classes...");
paintTileClassBasedOnHeight(-100, -1, 3, g_TileClasses.water);
RMS.SetProgress(40);

log("Placing players...");
// Coordinate system of the heightmap
var singleBases = [
	[40, 175],
	[80, 280],
	[120, 40],
	[285, 165],
	[200, 50]
];

if (g_MapInfo.mapSize >= 320 || g_MapInfo.numPlayers > singleBases.length)
	singleBases.push(
		[45, 70],
		[280, 80],
		[125, 205]
	);

var strongholdBases = [
	[265, 65],
	[60, 220],
	[105, 60]
];
randomPlayerPlacementAt(singleBases, strongholdBases, scale, 0.06);
RMS.SetProgress(50);

addElements([
	{
		"func": addLayeredPatches,
		"avoid": [
			g_TileClasses.bluff, 2,
			g_TileClasses.dirt, 5,
			g_TileClasses.forest, 2,
			g_TileClasses.mountain, 2,
			g_TileClasses.plateau, 2,
			g_TileClasses.player, 12,
			g_TileClasses.water, 3
		],
		"sizes": ["normal"],
		"mixes": ["normal"],
		"amounts": ["many"]
	},
	{
		"func": addDecoration,
		"avoid": [
			g_TileClasses.bluff, 2,
			g_TileClasses.forest, 2,
			g_TileClasses.mountain, 2,
			g_TileClasses.plateau, 2,
			g_TileClasses.player, 12,
			g_TileClasses.water, 3
		],
		"sizes": ["normal"],
		"mixes": ["normal"],
		"amounts": ["many"]
	}
]);
RMS.SetProgress(60);

addElements(shuffleArray([
	{
		"func": addMetal,
		"avoid": [
			g_TileClasses.berries, 5,
			g_TileClasses.bluff, 5,
			g_TileClasses.forest, 3,
			g_TileClasses.mountain, 2,
			g_TileClasses.plateau, 2,
			g_TileClasses.player, 30,
			g_TileClasses.rock, 20,
			g_TileClasses.metal, 30,
			g_TileClasses.water, 3
		],
		"sizes": ["normal"],
		"mixes": ["same"],
		"amounts": ["normal", "many"]
	},
	{
		"func": addSmallMetal,
		"avoid": [
			g_TileClasses.berries, 5,
			g_TileClasses.bluff, 5,
			g_TileClasses.forest, 3,
			g_TileClasses.mountain, 2,
			g_TileClasses.plateau, 2,
			g_TileClasses.player, 30,
			g_TileClasses.rock, 20,
			g_TileClasses.metal, 30,
			g_TileClasses.water, 3
		],
		"sizes": ["normal"],
		"mixes": ["same"],
		"amounts": ["normal", "many"]
	},
	{
		"func": addStone,
		"avoid": [
			g_TileClasses.berries, 5,
			g_TileClasses.bluff, 5,
			g_TileClasses.forest, 3,
			g_TileClasses.mountain, 2,
			g_TileClasses.plateau, 2,
			g_TileClasses.player, 30,
			g_TileClasses.rock, 30,
			g_TileClasses.metal, 20,
			g_TileClasses.water, 3
		],
		"sizes": ["normal"],
		"mixes": ["same"],
		"amounts": ["normal", "many"]
	},
	{
		"func": addForests,
		"avoid": [
			g_TileClasses.berries, 5,
			g_TileClasses.bluff, 5,
			g_TileClasses.forest, 10,
			g_TileClasses.metal, 3,
			g_TileClasses.mountain, 5,
			g_TileClasses.plateau, 5,
			g_TileClasses.player, 20,
			g_TileClasses.rock, 3,
			g_TileClasses.water, 2
		],
		"sizes": ["normal"],
		"mixes": ["similar"],
		"amounts": ["tons"]
	}
]));
RMS.SetProgress(70);

addElements(shuffleArray([
	{
		"func": addBerries,
		"avoid": [
			g_TileClasses.berries, 30,
			g_TileClasses.bluff, 5,
			g_TileClasses.forest, 5,
			g_TileClasses.metal, 10,
			g_TileClasses.mountain, 2,
			g_TileClasses.plateau, 2,
			g_TileClasses.player, 20,
			g_TileClasses.rock, 10,
			g_TileClasses.water, 3
		],
		"sizes": ["normal"],
		"mixes": ["same"],
		"amounts": ["normal", "many"]
	},
	{
		"func": addAnimals,
		"avoid": [
			g_TileClasses.animals, 20,
			g_TileClasses.bluff, 5,
			g_TileClasses.forest, 2,
			g_TileClasses.metal, 2,
			g_TileClasses.mountain, 1,
			g_TileClasses.plateau, 2,
			g_TileClasses.player, 20,
			g_TileClasses.rock, 2,
			g_TileClasses.water, 3
		],
		"sizes": ["huge"],
		"mixes": ["unique"],
		"amounts": ["tons"]
	},
	{
		"func": addFish,
		"avoid": [
			g_TileClasses.fish, 12,
			g_TileClasses.player, 8
		],
		"stay": [g_TileClasses.water, 4],
		"sizes": ["normal"],
		"mixes": ["same"],
		"amounts": ["tons"]
	},
	{
		"func": addStragglerTrees,
		"avoid": [
			g_TileClasses.berries, 5,
			g_TileClasses.bluff, 5,
			g_TileClasses.forest, 5,
			g_TileClasses.metal, 2,
			g_TileClasses.mountain, 1,
			g_TileClasses.plateau, 2,
			g_TileClasses.player, 12,
			g_TileClasses.rock, 2,
			g_TileClasses.water, 5
		],
		"sizes": ["normal"],
		"mixes": ["same"],
		"amounts": ["tons"]
	}
]));
RMS.SetProgress(80);

log("Adding reeds...");
createObjectGroups(
	new SimpleGroup(
		[
			new SimpleObject(g_Decoratives.reeds, 5, 12, 1, 2),
			new SimpleObject(g_Decoratives.rockMedium, 1, 2, 1, 3)
		],
		true,
		g_TileClasses.dirt
	),
	0,
	[
		stayClasses(g_TileClasses.water, 0),
		borderClasses(g_TileClasses.water, scaleByMapSize(2,8), scaleByMapSize(2,8))
	],
	scaleByMapSize(1000, 4000),
	500
);
RMS.SetProgress(85);

ExportMap();

// MapTiles - Do Not Edit Below This Line
function getHeightMap()
{
	return [-1.28,-0.89,-0.38,0.08,0.29,0.42,0.59,0.95,1.57,3.84,5,6,5,5,4,2,1,0,0,1,-1,-1,-1,-2,-3.79,-4.86,-4.55,-3.39,-2.93,-3.43,-4.28,-5.24,-6.13,-6.36,-6.83,-7.16,-6.65,-6,-7.03,-8.21,-8.93,-9.02,-8.63,-8.08,-7.58,-7.15,-6.79,-6.43,-6.28,-6.28,-6.72,-6.58,-6.27,-6,-5.79,-5.60,-5.12,-5.89,-7.22,-8.89,-10,-12,-12,-13,-13,-12,-12,-11,-12,-12,-12,-13,-14,-14,-14,-13,-12,-11,-10,-10,-9.41,-8.88,-8.46,-8.46,-9.29,-10,-11,-11,-12,-12,-12,-13,-14,-15,-16,-16,-16,-16,-16,-15,-15,-15,-15,-15,-13,-12,-12,-11,-10,-11,-12,-12,-12,-11,-9.85,-8.35,-8.92,-9.17,-10,-11,-11,-9.89,-8.04,-7.53,-8.08,-8.50,-8.14,-6.93,-5.77,-4.99,-3.63,-3.67,-5.49,-6.18,-6.42,-6.21,-5.62,-5.14,-4.52,-4.15,-3.84,-3.67,-3.58,-3.47,-3.40,-3.34,-3.13,-2.75,-2.40,-2.18,-2.15,-1.88,-1.48,-1.04,-0.63,-0.27,0.01,0.14,0.15,0.07,0,0,0,0,0.20,0.87,1,2,3,3,3,2,2,2,3,4,6,6,7,6,6,7,8,8,8,8,7,6,5,4,5,6,6,5,4,3,3,4,5,6,6,5,5,5,4,4,3,2,2,2,3,3,4,4,5,6,6,6,6,7,6,4,3,3,3,2,2,2,3,3,2,2,2,2,3,4,6,6,5,4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,2,3,3,4,3,3,3,3,3,3,-1,-0.77,-0.38,-0.03,0.26,0.49,0.78,1.37,2.60,3.92,6,5,6,4,3,2,1,1,0,1,1,1,-1,-2.79,-5.93,-7.51,-7.36,-5.11,-3.15,-3.39,-4.24,-5.55,-6.73,-6.74,-6.29,-6.85,-6.25,-5.34,-6.04,-7.09,-7.92,-8.21,-8.01,-7.64,-7.30,-7.02,-6.80,-6.63,-6.66,-6.86,-7.16,-7,-6.68,-6.43,-6.27,-6.12,-5.77,-6.54,-8.04,-10,-12,-13,-14,-14,-14,-14,-13,-12,-12,-12,-13,-14,-14,-14,-14,-13,-12,-12,-11,-10,-10,-10,-11,-11,-11,-11,-12,-12,-12,-12,-12,-13,-14,-15,-16,-16,-17,-17,-17,-17,-18,-19,-19,-19,-18,-17,-15,-14,-14,-14,-15,-16,-16,-16,-13,-11,-9.54,-11,-13,-14,-14,-13,-11,-10,-11,-11,-11,-10,-9.30,-7.10,-5.34,-5.98,-6.63,-7.08,-7.04,-6.72,-6.09,-5.54,-4.91,-4.50,-4.13,-3.88,-3.73,-3.65,-3.75,-3.84,-3.65,-3.03,-2.38,-1.87,-1.64,-1.46,-1.15,-0.78,-0.43,-0.13,0.09,0.15,0.12,0.04,0,0,0,0,0.20,0.87,1,2,2,2,3,2,2,2,3,4,5,6,6,5,6,7,8,8,8,8,7,6,5,5,4,5,5,5,4,3,3,3,4,5,5,5,5,5,4,3,2,2,2,2,3,3,4,4,5,6,6,6,6,6,5,4,3,3,3,2,2,2,3,3,2,2,2,2,3,4,5,5,5,4,3,2,1,1,1,1,0,0,0,0,0,0,0,0,0,1,1,1,2,2,2,3,3,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,2,3,3,3,3,3,3,3,3,3,-0.73,-0.64,-0.39,-0.10,0.28,0.62,1.12,1.95,3.08,4.48,5,6,5,4,3,3,2,2,1,1,1,-1,-1,-3.38,-6.22,-8.63,-8.92,-7.13,-4.65,-4.11,-5.10,-6.42,-7.05,-6.97,-6.03,-5.55,-4.85,-4,-4.24,-5.04,-6.05,-6.66,-6.87,-6.86,-6.80,-6.76,-6.78,-6.88,-7.14,-7.83,-7.79,-7.59,-7.25,-7.02,-6.90,-6.88,-6.90,-7.67,-9.42,-12,-14,-15,-16,-16,-16,-15,-14,-13,-13,-13,-14,-15,-15,-15,-14,-13,-13,-12,-11,-11,-11,-12,-12,-12,-12,-12,-12,-13,-13,-13,-13,-14,-14,-15,-16,-17,-18,-18,-18,-19,-20,-20,-20,-20,-20,-20,-17,-16,-16,-17,-18,-19,-19,-19,-17,-15,-15,-15,-16,-17,-17,-16,-15,-15,-14,-14,-14,-14,-11,-9.78,-8.67,-8.25,-8.34,-8.38,-8.11,-7.54,-6.86,-6.16,-5.54,-5.03,-4.60,-4.17,-3.88,-3.85,-4.22,-4.78,-4.80,-3.86,-1.79,-1.28,-1.13,-0.93,-0.71,-0.41,-0.15,0.03,0.14,0.15,0.10,0.03,0,0,0,0,0.20,0.87,1,1,1,2,2,2,2,2,3,4,5,5,5,4,5,6,7,8,8,8,7,6,6,5,4,4,4,4,4,3,4,3,3,4,4,4,4,4,3,2,2,2,2,2,3,3,4,4,5,5,5,5,5,5,5,4,3,3,2,2,2,3,4,4,3,2,2,2,3,4,6,5,5,4,2,2,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,2,2,2,3,3,3,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,3,3,3,3,3,3,3,3,3,-0.63,-0.60,-0.39,-0.05,0.39,0.83,1.39,2.25,3.47,4.70,6,5,4,3,3,3,3,3,2,1,1,-1,-1,-2.48,-5.83,-8.72,-8.35,-8.28,-6.62,-6.23,-7.62,-7.30,-6.65,-6.13,-4.90,-3.55,-2.75,-2.14,-1.22,-2.72,-3.68,-4.73,-5.38,-5.83,-6.04,-6.38,-6.68,-6.99,-7.40,-8.14,-8.23,-7.90,-7.66,-7.53,-7.50,-7.63,-8.04,-8.76,-10,-13,-14,-16,-17,-17,-17,-15,-14,-14,-13,-13,-14,-15,-16,-15,-14,-13,-12,-12,-12,-12,-12,-12,-13,-13,-13,-12,-12,-13,-13,-13,-13,-14,-15,-16,-17,-17,-18,-19,-19,-19,-20,-20,-20,-20,-20,-20,-19,-18,-18,-19,-19,-19,-19,-19,-19,-18,-19,-18,-17,-18,-18,-18,-18,-18,-16,-16,-17,-14,-13,-11,-10,-10,-9.86,-9.76,-9.33,-8.54,-7.66,-6.78,-6.10,-5.74,-5.11,-4.43,-3.79,-3.75,-4.13,-6,-7.92,-5.26,-2.02,-0.73,-0.61,-0.49,-0.33,-0.10,0.07,0.14,0.16,0.13,0.08,0.01,0,0,0,0,0.20,0.87,1,1,1,2,2,2,2,2,3,4,4,5,5,4,4,5,6,8,8,7,7,6,5,5,4,4,3,3,3,3,3,3,2,3,3,4,3,3,3,2,1,2,2,3,3,4,4,4,5,5,5,5,5,5,5,4,3,2,2,2,3,4,5,5,4,3,2,2,3,5,6,6,5,3,2,1,1,1,0,0,0,0,0,0,0,0,0,0,0,1,1,1,2,2,2,3,3,3,3,3,3,3,2,2,2,2,2,2,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,2,3,3,5,4,3,3,3,3,3,-0.78,-0.67,-0.38,0.08,0.53,1,1.54,2.38,3.51,5.34,6,5,4,4,4,4,4,4,3,2,1,1,-0.88,-1.59,-3.71,-6.38,-7.62,-8.09,-7.58,-8.34,-9.03,-7.89,-5.29,-4,-2.13,-1.41,-0.86,-0.33,-0.13,-0.25,-1.01,-2.12,-4.72,-4.28,-5,-6,-6.65,-6.89,-7.29,-7.85,-7.80,-7.74,-7.73,-7.74,-7.78,-8.01,-8.66,-9.14,-10,-12,-13,-14,-16,-16,-16,-15,-14,-13,-13,-13,-13,-14,-15,-14,-14,-12,-12,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-13,-13,-13,-14,-15,-16,-17,-18,-18,-19,-19,-19,-19,-19,-19,-19,-20,-19,-19,-19,-19,-19,-19,-19,-19,-19,-19,-19,-20,-19,-18,-18,-18,-18,-19,-18,-17,-17,-18,-15,-14,-12,-12,-11,-10,-10,-10,-9.58,-8.40,-7.23,-6.27,-5.85,-6.92,-3.89,-2.92,-2.75,-2.47,-2.49,-3.13,-2.04,-0.60,-0.27,-0.22,-0.14,-0.08,0.10,0.14,0.15,0.13,0.09,0.03,0,0,0,0,0.01,0.12,0.10,0,0,1,1,2,3,3,3,3,4,4,3,3,3,4,5,6,6,6,7,7,7,6,5,4,3,3,3,3,3,3,2,2,2,3,3,3,2,2,1,1,2,2,3,3,3,3,4,4,5,5,5,5,5,4,4,3,2,2,2,3,5,6,6,5,4,3,3,4,5,5,5,4,2,1,1,1,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,2,2,2,3,3,3,3,3,3,3,3,2,2,2,2,2,1,1,1,1,1,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,1,2,3,4,4,5,4,3,3,3,3,-0.93,-0.75,-0.28,0.21,0.63,1.07,1.57,2.32,3.33,4.34,5.20,5.11,5.02,4.98,5.03,5,5,5,4,3,2,1,-0.63,-1.47,-2.25,-4.18,-6.10,-7.91,-9.48,-10,-9.49,-7.51,-4.50,-1.74,-0.52,-0.22,0.02,0.14,0.13,0.01,-0.12,-0.30,-0.36,-0.46,-2.28,-5.68,-7.79,-5.89,-6.01,-6.39,-6.76,-7.11,-7.37,-7.53,-7.66,-7.84,-8.47,-8.63,-9.15,-8.89,-9.84,-11,-12,-13,-13,-13,-12,-12,-11,-11,-12,-13,-13,-12,-12,-11,-10,-9.99,-10,-11,-10,-10,-11,-11,-11,-11,-11,-12,-12,-12,-13,-13,-14,-15,-17,-18,-18,-19,-19,-19,-19,-19,-19,-19,-19,-19,-19,-18,-18,-19,-19,-19,-19,-19,-19,-19,-20,-20,-19,-19,-18,-17,-17,-17,-17,-17,-18,-15,-14,-13,-12,-12,-11,-11,-10,-10,-9.26,-7.28,-5.71,-4.88,-4.36,-1.27,-0.55,-0.47,-0.34,-0.22,-0.12,-0.05,-0.02,0,0,0.02,0.07,0.13,0.13,0.12,0.08,0.03,0,0,0,0,0.12,0.12,0.12,0,0,0,1,1,2,2,3,3,3,3,3,2,2,3,4,5,5,5,5,6,8,8,6,5,4,3,3,3,2,2,2,2,2,2,2,2,2,2,1,1,1,2,2,3,3,3,3,3,4,4,5,5,5,5,4,4,3,2,2,2,3,4,5,6,5,4,3,3,4,5,5,4,3,2,1,1,0,0,0,0,0,0,0,0,0,0,0,1,1,2,1,1,2,2,3,3,4,4,4,4,4,3,3,3,2,2,2,2,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,2,3,4,4,5,4,3,3,3,3,-0.73,-0.46,-0.10,0.33,0.65,1,1.46,2.11,2.90,3.75,4.57,5.04,5.40,6,5.75,5.87,6.98,7,5,4,2,1,-0.48,-1.12,-1.84,-3.36,-5.52,-7.91,-10,-11,-8.87,-6.71,-3.16,-0.68,-0.33,0.03,0.37,0.58,0.63,0.53,0.39,0.17,-0.03,-0.22,-0.38,-0.62,-2.89,-5.08,-4.25,-4.78,-5.62,-6.21,-6.76,-6.97,-6.88,-7.30,-7.13,-7.52,-7.33,-6.10,-6.16,-6.71,-9.09,-10,-10,-10,-10,-10,-10,-9.72,-9.75,-10,-10,-9.92,-9.17,-8.73,-8.40,-8.02,-7.38,-8.18,-7.60,-8.93,-9.71,-10,-10,-10,-11,-11,-11,-12,-12,-13,-14,-15,-16,-17,-18,-18,-18,-19,-19,-19,-19,-19,-19,-19,-19,-18,-18,-18,-18,-18,-18,-18,-18,-18,-20,-20,-19,-18,-18,-17,-16,-15,-15,-15,-16,-15,-14,-13,-12,-12,-11,-11,-10,-10,-8.88,-6.15,-3.38,-0.61,-0.11,-0.13,-0.15,-0.13,-0.04,0.02,0.09,0.11,0.11,0.10,0.09,0.09,0.09,0.10,0.09,0.07,0.02,0,0,0,0,0,0.12,0.83,0.10,0,0,0,1,1,1,2,3,3,3,2,2,2,2,3,4,5,4,4,4,5,6,7,7,5,4,4,4,3,3,2,2,2,2,2,2,2,2,2,1,1,1,1,2,2,3,3,3,3,3,4,4,4,4,5,4,3,3,2,2,2,3,4,5,5,6,4,3,3,4,4,5,3,2,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,2,2,3,4,4,4,5,4,4,4,3,3,2,2,2,2,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,2,2,2,2,1,1,0,0,0,0,0,1,2,3,4,4,4,4,3,3,3,2,-0.22,-0.04,0.17,0.39,0.60,0.86,1.25,1.78,2.47,3.21,4.04,4.66,5.38,5.85,5.83,5.83,6.54,6.98,5,4,3,1,0.37,-0.85,-1.68,-2.55,-5.39,-8,-9.50,-10,-8.49,-5.24,-2.21,-0.53,-0.12,0.33,0.75,1.08,1.17,1.07,0.84,0.54,0.26,0.04,-0.13,-0.33,-0.50,-1.62,-3.71,-3.91,-4.38,-5.28,-5.98,-7.05,-5.40,-4.26,-4.53,-4.66,-6.23,-5.97,-3.63,-4.41,-6.23,-7.64,-7.40,-6.76,-8.30,-9.51,-7.36,-7.49,-6.85,-5.49,-6.27,-6.13,-5.25,-6.09,-6.79,-5.65,-6.09,-6.41,-5.88,-7.04,-8.02,-8.87,-9.52,-9.99,-10,-10,-10,-11,-11,-12,-13,-14,-15,-16,-16,-17,-17,-18,-18,-19,-19,-19,-19,-19,-18,-18,-17,-17,-17,-17,-18,-18,-18,-18,-20,-19,-18,-18,-17,-16,-15,-14,-13,-13,-13,-13,-13,-13,-12,-12,-11,-10,-9.46,-7.38,-6.03,-2.43,-0.54,-0.04,0.08,0.08,0.02,0.02,0.07,0.10,0.12,0.12,0.11,0.10,0.09,0.07,0.04,0.03,0.02,0.01,0,0,0,0,0,0,0.12,0.12,0.04,0,0,0,1,1,1,2,2,3,2,2,2,2,2,3,4,4,4,4,3,4,5,5,6,5,5,5,4,4,3,3,3,2,2,2,2,2,2,2,1,1,1,1,1,2,2,2,2,2,3,3,3,3,3,3,3,3,2,3,2,2,3,4,5,5,5,4,3,3,3,4,3,2,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,2,2,3,3,4,4,4,5,5,5,4,3,3,2,2,2,2,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,2,3,3,2,1,1,0,0,0,0,0,1,2,3,3,4,5,3,3,3,2,2,0.24,0.29,0.37,0.41,0.49,0.65,0.97,1.39,1.96,2.60,3.35,4,4.62,5.24,5.12,5.11,5.13,4.96,4,3,2,1,0.33,-0.50,-1.37,-1.67,-3.66,-6.38,-7.49,-8.75,-7.36,-4.49,-1.53,-0.29,0.10,0.60,1.11,1.58,1.75,1.58,1.24,0.82,0.48,0.24,0.07,-0.05,-0.15,-0.22,-1.26,-2.52,-3.48,-3.67,-3.35,-3.15,-2.64,-2.73,-2.77,-2.68,-4.25,-3.58,-0.98,-1.34,-2.51,-3.47,-3.39,-2.65,-1.67,-2.71,-3,-3.74,-4.17,-2.22,-2.73,-3.43,-2.83,-2.89,-4.02,-4.30,-5.03,-5,-4.52,-5.14,-6.18,-7.24,-8.18,-8.91,-9.47,-9.91,-10,-10,-11,-11,-12,-13,-13,-14,-15,-15,-16,-17,-18,-18,-19,-19,-19,-19,-18,-18,-17,-16,-16,-16,-17,-17,-17,-17,-16,-18,-18,-17,-16,-15,-14,-13,-13,-12,-12,-12,-13,-13,-12,-11,-10,-9.60,-7.73,-4.86,-2.59,-1.03,-0.08,0.11,0.13,0.11,0.08,0.07,0.07,0.09,0.10,0.11,0.10,0.09,0.07,0.03,0.02,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,2,2,2,1,1,2,2,3,4,4,4,3,3,3,4,4,4,5,5,6,5,4,3,3,3,3,2,2,2,2,2,2,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,3,2,2,2,2,2,3,4,4,5,4,3,2,2,3,3,2,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,2,2,2,3,3,4,4,4,5,5,5,5,3,3,2,2,2,2,2,2,2,2,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,1,1,1,2,2,3,3,2,1,1,0,0,0,0,0,1,2,2,3,4,4,3,3,2,2,2,0.47,0.47,0.42,0.38,0.37,0.46,0.65,0.99,1.39,1.89,2.47,3.04,3.64,4.07,4.16,4.15,4.07,4.21,4.02,3,2,1,0.48,-0.23,-0.83,-1.13,-1.54,-3.11,-4.96,-6.51,-5.96,-4.38,-1.67,-0.18,0.24,0.75,1.36,1.90,2.14,1.98,1.50,0.97,0.59,0.32,0.14,0.08,0.07,0.12,0.04,-0.30,-0.33,-0.13,-0.26,-0.35,-0.40,-0.48,-0.51,-0.52,-0.50,-0.43,-0.36,-0.28,-0.42,-0.63,-0.62,-0.38,-0.23,-0.33,-0.49,-0.62,-0.59,-0.39,-0.38,-0.62,-0.92,-1.12,-1.18,-1.47,-1.65,-1.65,-2.25,-2.89,-4.13,-5.63,-6.93,-7.93,-8.43,-9.09,-9.73,-10,-10,-10,-12,-11,-12,-12,-13,-14,-15,-16,-17,-18,-18,-18,-19,-19,-18,-17,-17,-16,-15,-15,-16,-16,-16,-16,-16,-16,-17,-16,-15,-15,-14,-13,-13,-12,-12,-12,-12,-12,-12,-11,-10,-8.98,-6.72,-3.77,-1.43,-0.39,-0.01,0.12,0.12,0.09,0.04,0.03,0.04,0.09,0.12,0.13,0.14,0.12,0.09,0.03,0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,2,2,3,4,4,4,3,2,2,3,3,4,4,5,6,5,4,3,4,3,3,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,1,1,2,2,3,4,4,4,3,2,2,2,2,2,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,2,2,2,3,3,3,4,4,5,5,5,5,4,4,3,2,2,2,2,2,2,2,2,2,2,2,1,1,0,0,0,0,0,0,0,0,0,0,0,1,1,1,2,2,3,3,2,1,1,0,0,0,0,0,1,2,2,3,3,4,3,2,2,2,2,0.58,0.50,0.41,0.33,0.26,0.28,0.38,0.58,0.84,1.11,1.54,2.04,2.57,2.95,3.14,3.32,3.59,3.95,4.33,5,3,1,0.70,0,-0.46,-0.66,-0.63,-0.98,-2.75,-5.02,-5.88,-5.42,-2.50,-0.26,0.20,0.79,1.45,2.03,2.33,2.23,1.77,1.12,0.62,0.28,0.12,0.10,0.12,0.23,0.42,0.37,-0.35,-0.28,-0.02,-0.11,-0.21,-0.23,-0.25,-0.28,-0.28,-0.24,-0.15,-0.12,-0.08,-0.03,0.04,0.15,0.23,0.03,-0.13,-0.17,-0.12,0.04,0.07,-0.27,-0.38,-0.50,-0.14,-0.23,-0.42,-0.64,-0.79,-1.02,-1.37,-3.04,-7.01,-6.35,-6.99,-7.93,-9.16,-8.66,-8.35,-8.61,-8.99,-10,-10,-10,-11,-12,-14,-15,-16,-17,-18,-18,-18,-18,-18,-17,-16,-15,-14,-14,-14,-14,-15,-15,-15,-15,-15,-15,-15,-14,-14,-13,-13,-13,-12,-12,-12,-12,-12,-11,-10,-8.75,-6.38,-2.88,-1.04,-0.29,-0.01,0.10,0.09,0.03,0.01,0.02,0.07,0.12,0.21,0.27,0.29,0.25,0.16,0.10,0.02,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,2,2,3,4,5,3,3,2,2,2,3,3,4,5,6,5,4,3,3,3,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,3,3,4,4,2,2,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,2,2,2,3,3,4,4,4,5,6,7,6,5,4,4,3,2,2,2,2,2,2,3,2,2,2,2,2,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,2,2,3,3,2,1,1,0,0,0,0,0,1,2,2,2,3,4,3,2,2,2,1,0.57,0.49,0.38,0.28,0.22,0.16,0.17,0.23,0.25,0.47,0.76,1.15,1.58,1.92,2.23,2.57,3.08,3.76,4.63,6,4,2,0.52,0.28,-0.16,-0.39,-0.36,-0.29,-1.42,-4.04,-6.29,-6.13,-3.42,-0.79,0.07,0.66,1.41,1.98,2.29,2.25,1.87,1.33,0.53,0.17,0.09,0.08,0.12,0.22,0.35,0.45,0.39,0.37,0.32,0.01,0.12,0.09,0.01,-0.04,-0.09,-0.05,0.01,0.07,0.08,0.11,0.12,0.35,0.35,0.33,0.37,0.47,0.62,0.83,1,1,1,1,0.26,0.09,-0.01,-0.03,-0.12,-0.30,-0.48,-0.79,-2.12,-4.13,-2.90,-5.18,-7.64,-6.53,-5.13,-4.97,-5.88,-5.50,-7.24,-8.23,-10,-11,-13,-14,-15,-16,-17,-17,-17,-17,-17,-16,-15,-14,-13,-13,-12,-11,-12,-13,-14,-14,-14,-14,-14,-14,-14,-14,-13,-13,-13,-13,-13,-12,-12,-11,-10,-8.86,-6.55,-3.63,-0.96,-0.35,-0.03,0.04,0.04,0.01,0,0.02,0.10,0.23,0.38,0.53,0.60,0.50,0.35,0.16,0.04,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,2,3,3,4,3,3,2,2,2,2,2,3,3,4,4,4,3,3,3,2,2,2,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,3,3,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,2,2,3,3,4,5,5,5,6,7,7,6,5,4,4,3,2,2,2,2,2,2,3,2,2,2,2,2,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,2,2,3,2,2,1,1,0,0,0,0,0,1,2,2,2,3,3,3,2,2,1,1,0.48,0.42,0.36,0.27,0.21,0.12,0.04,-0.08,-0.08,0.04,0.25,0.51,0.84,1.13,1.46,1.87,2.49,3.33,4.39,6,5,3,1.37,0.62,0.08,-0.14,-0.05,-0.05,-0.53,-3.10,-6.02,-6.40,-4.38,-1.59,-0.02,0.52,1.22,1.85,2.29,2.35,2.04,1,0.01,0.09,0.04,0.14,0.26,0.28,0.38,0.39,0.38,0.50,0.57,0.63,0.58,0.50,0.34,0.17,0.07,0.07,0.11,0.17,0.26,0.17,0,0,0,0,0,0,0,0,0,0,0,0,0.36,0.25,0.21,0.17,0.12,-0.10,-0.22,-0.29,-0.36,-0.62,-1.43,-1.58,-1.53,-1.54,-1.93,-1.93,-2.23,-2.17,-1.72,-4.99,-6.91,-14,-12,-12,-14,-17,-16,-16,-16,-16,-15,-14,-13,-12,-11,-10,-10,-10,-10,-10,-12,-12,-12,-13,-13,-14,-14,-14,-14,-13,-13,-13,-13,-12,-12,-11,-10,-8.97,-6.65,-3.88,-0.84,-0.25,-0.08,0.02,0.02,0,0,0.03,0.14,0.35,0.63,0.97,1.07,0.91,0.57,0.26,0.07,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,2,3,4,3,3,2,2,2,2,2,2,2,3,3,3,3,3,3,3,2,2,1,1,1,2,2,2,2,2,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,0,0,1,1,1,2,2,2,2,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,2,2,2,3,4,5,5,6,6,6,7,6,5,5,4,4,3,3,2,2,2,2,2,2,2,2,2,2,2,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,2,2,2,2,1,1,1,0,0,0,0,0,1,2,2,2,2,2,2,2,1,1,1,0.28,0.32,0.32,0.28,0.24,0.14,0,-0.14,-0.23,-0.18,-0.05,0.13,0.36,0.60,0.87,1.25,1.84,2.66,3.75,5,5,3,2,1.20,0.79,0.52,0.40,0.26,0.08,-2.10,-5.63,-6.66,-5.23,-2.04,-0.12,0.37,0.98,1.59,2.10,2.32,1.89,1,0,0,0.12,0.17,0.76,0.78,0.74,0.36,0.40,0.46,1.03,1.27,1.26,1.07,0.75,0.28,0.20,0.08,0.07,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.21,0.22,0.20,0.11,0.03,-0.02,-0.11,-0.16,-0.22,-0.23,-0.18,-0.13,-0.11,-0.11,-0.13,-0.28,-0.55,-0.76,-1.38,-4.40,-5.27,-9.28,-7.80,-10,-16,-15,-14,-12,-13,-13,-12,-13,-12,-11,-9.80,-9.04,-10,-8.21,-8.36,-8.54,-9.40,-10,-11,-12,-13,-14,-14,-14,-13,-13,-13,-13,-12,-12,-11,-10,-8.96,-6.53,-3.67,-0.85,-0.25,-0.10,0,0.01,0,0,0.04,0.20,0.45,0.87,1.34,2.17,1.32,0.77,0.28,0.04,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,2,2,3,2,2,2,2,1,1,1,2,2,2,2,2,2,2,3,2,2,1,1,1,1,1,2,2,2,2,1,1,2,1,1,0,0,0,0,1,1,1,1,1,0,0,0,0,0,1,1,1,1,1,2,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,2,2,2,2,2,3,4,4,5,6,6,6,6,6,5,5,4,4,3,3,2,2,2,2,2,2,2,2,2,2,2,1,1,0,0,0,0,0,0,0,0,0,1,1,1,1,2,2,2,1,1,1,1,0,0,0,0,0,1,2,2,2,2,2,1,1,1,1,1,0,0.21,0.33,0.36,0.35,0.25,0.07,-0.13,-1.76,-1.77,-0.21,-0.08,0.10,0.28,0.50,0.77,1.21,1.91,2.90,4,4,3,2,2.15,1.87,1.47,1.10,0.74,0.37,-1.51,-5.27,-6.92,-5.60,-2.04,-0.22,0.22,0.74,1.33,1.87,2.35,1.86,1.11,0,0,0.07,0.87,1.15,1.78,1.23,1.20,1.13,1.32,1.86,2.27,2.17,1.78,1.21,0.84,0.07,0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.03,0.10,0.12,0.12,0.12,0.10,0.08,0.01,-0.05,-0.12,-0.13,-0.11,-0.02,0.03,0.08,0.07,-0.01,-0.22,-0.30,-0.37,-0.65,-1.75,-2.01,-2.26,-4,-6.27,-11,-13,-10,-9.03,-11,-9.58,-9.66,-8.75,-7.16,-5.55,-5.75,-5.23,-5,-4.47,-5.50,-5.23,-8,-9.79,-11,-12,-13,-13,-13,-13,-13,-13,-12,-12,-12,-11,-10,-8.86,-6.24,-3.38,-0.98,-0.30,-0.08,-0.01,0,0,0,0.04,0.20,0.49,0.91,1.86,1.88,1.95,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,1,1,1,1,1,2,1,0,1,1,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,2,2,1,1,2,2,1,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,2,2,2,2,3,3,4,4,5,6,6,6,6,5,5,5,4,3,3,3,2,2,2,2,2,2,2,2,2,2,2,1,1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,2,1,1,1,1,1,0,0,1,0,0,1,1,2,2,1,1,1,1,1,1,1,0,0.48,0.57,0.58,0.52,0.40,0.21,-0.03,-1.72,-3.88,-2.38,-0.21,-0.04,0.12,0.28,0.48,0.76,1.29,2.09,3,2,2,3,3.98,3.07,2.52,1.95,1.32,0.71,-1.34,-4.72,-6.61,-5.96,-2.54,-0.28,0,0.47,1.04,1.75,2.09,1.75,1.24,1,1,1,1.04,1.88,2.13,2.15,2.14,2.07,2.21,2.82,3.84,3.86,2.11,1.95,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.01,0.08,0.10,0.11,0.11,0.07,0,-0.09,-0.12,-0.10,0,0.09,0.14,0.17,0.16,0.14,0,0.01,-0.12,-0.12,-0.18,-0.30,-0.48,-0.92,-3.04,-7.71,-6.90,-9.52,-8.89,-5.63,-2.98,-2.21,-2.01,-1.85,-0.92,-1.58,-1.47,-2.52,-2.50,-2.87,-5.39,-8.09,-10,-11,-12,-13,-13,-13,-13,-12,-12,-12,-12,-11,-10,-8.52,-5.76,-2.90,-1.10,-0.50,-0.13,-0.01,0,0,0,0.03,0.14,0.35,0.89,1.07,1.01,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,1,1,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,2,2,1,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,2,2,2,2,2,3,3,4,4,5,6,6,6,6,5,5,5,4,3,3,3,2,2,2,2,2,2,2,2,2,2,2,1,1,1,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1.01,1.02,0.99,0.88,0.70,0.42,0.14,-0.10,-2.35,-3.90,-1.77,-0.13,0.04,0.21,0.32,0.50,0.85,1.37,2,2,2,3,5,4.35,3.79,2.92,1.97,1.04,-0.77,-3.85,-6.38,-6.27,-3.58,-0.91,-0.25,0.13,0.74,1.42,1.77,1.70,1.37,1,1,1,2,2.98,3.07,3.89,3.12,3.01,3,3.11,3.10,3.92,2.98,2,2,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.02,0.07,0.10,0.11,0.09,0.01,-0.08,-0.13,-0.12,-0.03,0.09,0.17,0.24,0.24,0.24,0.29,0.14,0.08,0.11,0.07,-0.10,-0.25,-0.38,-0.48,-1.01,-3.03,-2.90,-3.90,-1.04,-0.30,-0.27,-0.25,-0.15,-0.12,-0.24,-0.74,-1.28,-1.85,-2.29,-3.76,-6.75,-9.04,-10,-12,-13,-13,-13,-12,-12,-12,-12,-12,-11,-10,-8.10,-5.27,-2.41,-1.13,-0.52,-0.14,0,0.01,0,0,0,0.07,0.14,0,1,1,1,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,1,1,2,2,2,2,2,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,2,2,2,2,3,3,3,4,5,5,6,7,7,6,5,5,5,4,3,3,3,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,0,0,0,0,0,1,1,1,1,1,2,1,1,1,1,1,1,0,0,0,0,0,1,1,1,2,1,1,1,1,1,1,1,1,2,1.62,1.61,1.57,1.41,1.12,0.76,0.39,0.08,-0.17,-1.79,-1.77,-0.13,0.04,0.17,0.24,0.33,0.50,0.86,1,1,2,3,5,6.25,5.45,4.02,2.62,1.36,0,-3.04,-6.11,-6.49,-4.43,-1.87,-0.63,-0.34,0.40,1.13,1.57,1.66,1.41,1,1,2,3,4,4,5,4,4,4,3,3,3,3,2,2,2,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.02,0.08,0.10,0.09,0.02,-0.04,-0.12,-0.13,-0.08,0.01,0.12,0.17,0.22,0.24,0.23,0.22,0.22,0.39,0.24,0.15,-0.03,-0.17,-0.25,-0.33,-0.36,-0.35,-0.27,-0.18,-0.12,-0.05,-0.01,0.09,0.24,0.13,-0.47,-1.05,-1.65,-2.16,-3.40,-5.76,-8.05,-10,-11,-12,-13,-12,-12,-11,-12,-12,-12,-11,-9.98,-7.74,-5.04,-1.87,-1.08,-0.48,-0.12,0.01,0.02,0,0,0,0.01,0.01,0,1,1,2,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,2,2,2,2,1,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,2,2,2,2,3,3,3,4,4,5,6,7,8,8,7,6,5,5,4,3,3,3,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,0,0,0,1,1,1,1,2,2,1,1,1,1,1,1,0,0,0,0,1,0,0,1,1,1,1,1,1,1,1,1,1,1,2,2.07,2.16,2.25,2.08,1.66,1.16,0.67,0.25,-0.03,-0.17,-0.14,-0.01,0.12,0.17,0.20,0.23,0.27,0.26,1,1,2,3,5,7.25,6.85,5.26,3.22,1.38,0.17,-2.33,-5.75,-6.50,-5.23,-2.47,-1.03,-0.59,0.12,0.85,1.35,1.59,1.41,1,2,2,3,4,6,5,5,4,4,4,4,4,3,3,2,2,2,2,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.01,0.04,0.10,0.10,0.04,-0.04,-0.13,-0.14,-0.13,-0.04,0.07,0.14,0.21,0.23,0.24,0.25,0.27,0.25,0.62,0.36,0.16,0.04,-0.02,-0.11,-0.18,-0.21,-0.09,0.01,0.07,0.09,0.10,0.15,0.24,0.32,-0.17,-0.75,-1.38,-1.92,-2.68,-4.88,-7.03,-9.13,-10,-12,-12,-12,-12,-11,-12,-12,-12,-11,-9.87,-7.71,-5.10,-2.18,-0.88,-0.33,-0.02,0.04,0.02,0,0,0,0,0,0,1,1,2,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,2,1,1,0,0,0,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,2,2,2,3,3,3,4,4,4,5,6,7,8,8,7,7,5,5,4,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,0,0,0,1,1,1,2,2,2,1,1,1,1,1,0,0,0,0,0,0,0,1,1,2,1,1,1,1,1,1,1,1,1,2,2.01,2.85,3.12,2.85,2.27,1.62,1,0.49,0.14,0,0.02,0.12,0.17,0.20,0.17,0.16,0.25,0.01,1,1,2,3,5,6.53,6.98,5.77,3.50,1.46,0.12,-1.92,-5.37,-6.78,-5.62,-2.52,-1.11,-0.71,-0.09,0.61,1.12,1.34,1.25,1,2,3,4,4,5,5,5,5,4,4,4,4,4,3,3,3,4,3,2,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0.03,0.11,0.13,0.10,-0.04,-0.13,-0.18,-0.17,-0.12,0,0.11,0.17,0.22,0.25,0.28,0.33,0.38,0.40,0.48,0.37,0.32,0.26,0.22,0,0.16,0.29,0.29,0.21,0.10,0.09,0.11,0.15,0.37,0.16,-0.38,-0.99,-1.54,-1.98,-3.96,-5.90,-7.92,-9.93,-11,-12,-12,-12,-11,-12,-12,-12,-11,-10,-7.88,-5.34,-2.61,-0.62,-0.16,0,0.03,0.02,0,0,0,0,0.01,0.14,1,1,1,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,2,2,2,3,3,4,4,4,4,5,6,7,8,9,8,6,5,4,4,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,0,0,1,1,1,2,2,2,2,1,1,1,1,0,0,0,0,0,0,0,0,1,2,2,1,1,1,1,1,1,1,1,1,2,2,3.91,4.41,3.62,2.87,2.08,1.34,0.75,0.37,0.22,0.21,0.24,0.24,0.21,0.16,0.25,0.08,1,1,2,3,3,5,6.11,6.98,5.63,3.26,1.32,-0.04,-2.11,-5.41,-6.80,-5.64,-2.51,-1.01,-0.66,-0.15,0.46,0.89,1.12,1.11,1,2,3,3,4,5,5,6,5,4,4,4,4,4,4,4,4,4,2,2,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0.02,0.12,0.16,0.13,0,-0.12,-0.21,-0.24,-0.21,-0.12,0,0.10,0.17,0.26,0.34,0.39,0.42,0.45,0.39,0.35,0.37,0.49,0.66,0.98,1,1,1,0,0,0,0,0,0,0.47,0.09,-0.51,-1.05,-1.52,-2.91,-4.61,-6.55,-8.64,-10,-11,-12,-12,-11,-12,-12,-12,-12,-10,-8.33,-5.73,-2.93,-0.47,-0.05,0.03,0.08,0.03,0,0,0,0,0.02,0.13,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,2,2,2,3,3,3,3,4,4,5,5,6,7,8,9,8,6,5,4,4,4,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,0,0,1,1,1,2,2,2,2,1,1,1,0,0,0,0,0,0,0,0,0,1,2,2,1,1,1,1,1,1,1,1,1,4,4,4,4.90,4.48,3.42,2.50,1.66,1.01,0.59,0.37,0.32,0.29,0.27,0.23,0.26,0.09,1,1,2,2,3,3,4,5.54,6.12,4.46,2.74,1.12,0,-1.98,-5.42,-6.88,-5.74,-2.47,-0.87,-0.58,-0.14,0.37,0.75,1,1.02,1,2,3,3,4,5,5,5,5,5,4,4,4,4,4,4,5,3,2,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0.02,0.11,0.22,0.20,0.09,-0.04,-0.15,-0.25,-0.38,-0.43,-0.35,-0.13,0.11,0.25,0.37,0.48,0.50,0.47,0.38,0.29,0.17,0.22,0.29,0.37,0.01,1,0,0,0,0,0,0,0,0.32,0.36,-0.08,-0.55,-1.04,-1.54,-3.12,-4.87,-7.08,-9.41,-11,-11,-11,-12,-13,-13,-13,-13,-11,-8.96,-6.18,-3.30,-0.49,-0.04,0.07,0.09,0.04,0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,2,2,2,3,3,3,3,3,4,4,5,6,7,8,9,9,8,6,5,4,4,4,4,3,3,2,2,2,2,2,1,1,2,2,3,3,2,1,1,1,0,0,1,1,1,2,2,2,2,1,1,0,0,0,0,0,0,0,0,0,1,1,2,2,1,1,1,1,1,1,1,1,1,6,7,6,5,4.95,3.90,2.92,2.02,1.23,0.77,0.50,0.36,0.35,0.41,0.32,0.04,1,1,2,3,3,2,3,4,4.08,4.03,3.23,2.08,0.96,0.16,-1.76,-4.89,-6.63,-6.09,-2.89,-0.79,-0.51,-0.13,0.32,0.70,0.95,1.12,1,2,3,3,4,5,5,6,6,5,4,4,4,4,4,4,3,2,1,1,1,0,0,0,0,1,0,0,0,0,1,1,0,0,0,0,0,0,0.01,0.02,0.11,0.24,0.26,0.23,0.12,-0.01,-0.16,-0.47,-1.09,-1,-0.37,-0.24,0.11,0.36,0.50,0.54,0.50,0.39,0.26,0.15,0.08,0.10,0.08,0.25,1,1,0,0,0,0,0,0,0.83,0.41,0.25,-0.17,-0.63,-1.10,-1.50,-2.17,-5.13,-8.63,-10,-11,-12,-13,-14,-14,-14,-14,-12,-9.61,-6.66,-3.66,-0.67,-0.23,0,0.08,0.04,0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,2,2,2,3,3,4,4,4,4,4,5,5,6,7,9,10,9,7,6,5,5,4,4,4,3,3,3,3,2,2,1,1,1,2,3,3,4,2,1,1,1,0,0,1,1,1,2,2,2,1,1,0,0,0,0,0,0,0,0,0,0,1,2,2,1,1,1,1,1,1,1,1,1,1,8,9,8,6,5,4.01,3.92,2.10,1.12,0.88,0.87,0.12,0.10,0.92,0.98,1,1,2,2,2,2,2,2,2,2.98,2.59,2.10,1.47,0.75,0.22,-1.18,-3.98,-6,-5.63,-3.36,-1.21,-0.50,-0.15,0.27,0.71,1.03,1.03,2,3,3,4,4,5,6,6,5,5,3,3,3,3,3,3,2,1,1,1,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0.12,0.08,0.13,0.21,0.34,0.47,0.48,0.38,0.25,0.03,-0.34,-1,-2.03,-1.59,-0.74,-0.17,0.17,0.41,0.51,0.50,0.39,0.26,0.17,0.11,0.07,0.07,0.16,0.16,1,0,0,0,0,1,0,0,0.28,0.33,0.10,-0.33,-0.76,-1.16,-1.50,-3.03,-6.88,-10,-12,-12,-14,-14,-15,-15,-14,-12,-9.88,-6.99,-3.92,-0.88,-0.39,-0.09,0.03,0.07,0.02,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,2,2,3,3,4,4,5,5,5,5,5,5,6,8,9,9,7,7,6,5,5,4,4,3,3,3,2,2,2,1,1,1,1,2,3,4,3,2,1,1,1,0,0,0,1,1,1,2,1,1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,9,9,8,6,5,4,3,2,1,2,1,1,1,1,1,1,1,2,2,1,1,1,1,1,1,1.08,1.27,0.96,0.52,0.14,-0.52,-2.76,-4.92,-5.13,-3.37,-1.50,-0.49,-0.16,0.25,0.73,1.21,1.78,3,3,4,4,4,5,5,5,4,4,3,2,2,2,3,2,1,1,1,0,0,0,0,0,0,0,0,0,1,1,2,2,1,1,1,1,1,0,0.34,0.41,0.47,0.58,0.76,0.83,0.76,0.61,0.37,0.01,-0.35,-0.91,-1.53,-1.40,-0.61,-0.15,0.12,0.32,0.40,0.33,0.22,0.16,0.13,0.12,0.12,0.12,0.21,0.07,0.01,0,0,0,0,0,0,0.01,0.26,0.21,-0.11,-0.51,-0.89,-1.24,-2.22,-5.64,-8.88,-11,-12,-13,-14,-15,-15,-14,-12,-10,-7.03,-4.03,-1.10,-0.58,-0.18,0,0.04,0.03,0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,2,3,3,4,4,5,5,5,6,6,5,5,6,7,8,6,6,5,6,6,4,4,3,3,3,2,2,1,1,1,1,1,1,2,3,3,2,2,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,8.88,8.87,6.99,5.11,4.10,3.08,2.97,2,2,2,2,2,2,2,1,1,1,2,1,1,0,1,1,1,1,0.85,0.72,0.52,0.25,-0.01,-0.25,-1.75,-4.62,-5.38,-4.05,-1.61,-0.52,-0.18,0.21,0.72,1.34,2.01,2.85,3,4,4,4,4,5,4,4,3,3,2,2,2,2,1,1,1,1,0,0,0,0,0,0,0,0,0,1,2,2,2,2,1,1,1,1,1,1,0.95,0.87,0.98,1.20,1.28,1.24,1.03,0.73,0.39,0.07,-0.27,-0.39,-0.75,-0.75,-0.76,-0.50,0.07,0.09,0.12,0.12,0.12,0.14,0.14,0.13,0.12,0.08,0.03,0,0,0,0,0,0,0,0,0.01,0.48,0,-0.33,-0.65,-0.99,-2.08,-4.40,-7.03,-9.25,-10,-12,-14,-14,-15,-14,-12,-9.74,-6.88,-3.93,-1.28,-0.73,-0.28,-0.03,0.07,0.07,0.04,0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,2,3,3,4,5,5,5,5,5,5,5,6,5,5,5,5,4,4,4,4,4,3,3,3,2,2,1,1,1,1,1,1,1,2,2,2,2,2,1,1,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,8.58,7.62,6.28,4.82,3.37,2.73,2.14,1.95,2,2,2,2,2,2,2,1,1,1,1,0.15,0.42,0.47,0.61,0.62,0.61,0.50,0.36,0.16,-0.02,-0.23,-0.46,-1.93,-4.83,-6.09,-4.87,-2,-0.63,-0.33,0,0.61,1.33,2.04,2.65,3,3,4,4,4,4,4,4,3,2,2,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,2,2,2,2,2,1,1,1,2,2,1.98,1.34,1.49,1.74,1.86,1.79,1.50,1.08,0.63,0.33,0.13,-0.08,-0.28,-0.54,-0.91,-1.53,-0.63,-0.24,-0.14,-0.03,0.04,0.12,0.14,0.14,0.12,0.08,0.02,0,0,0,0,0,0,0,0,0,0,0.09,-0.13,-0.42,-0.75,-1.65,-3.50,-5.80,-7.54,-8.75,-10,-12,-13,-14,-13,-11,-9.29,-6.54,-3.87,-1.46,-0.86,-0.36,-0.05,0.07,0.09,0.08,0.04,0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,2,3,3,4,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,2,2,2,1,1,1,1,1,1,1,1,2,2,2,2,2,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,8.36,7.03,5.59,4.17,3,2.04,1.38,1.24,1.91,2,3,4,3,3,2,1,1,0.98,0.66,0.35,0.20,0.23,0.28,0.35,0.33,0.21,0.02,-0.16,-0.28,-0.60,-1.15,-3.50,-5.21,-5.91,-5.13,-3.46,-1.86,-0.73,-0.27,0.45,1.33,2.14,2.76,3.01,3,3,4,4,4,3,3,3,2,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,2,2,2,3,3,2,2,2,2,2,3,3,2,2.12,2.34,2.51,2.48,2.03,1.34,0.73,0.41,0.25,0.14,0,-0.18,-0.49,-0.75,-1.35,-0.72,-0.48,-0.23,-0.05,0.04,0.12,0.14,0.12,0.10,0.03,0.01,0,0,0,0,0,0,0,0,0,0.23,0.12,-0.16,-0.50,-1.11,-2.38,-3.97,-5.77,-6.76,-8.43,-10,-11,-12,-12,-10,-8.67,-6.34,-3.83,-1.60,-0.92,-0.39,-0.08,0.08,0.10,0.09,0.04,0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,2,2,2,3,2,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,8.17,6.17,4.74,3.46,2.34,1.42,0.58,0.41,1.13,1.95,2,3,3,3,3,1,0.98,0.87,0.39,0.09,-0.09,-0.11,0,0.12,0.15,0.08,-0.04,-0.18,-1,-1.83,-3.16,-4.64,-6.04,-6.59,-5.88,-4.29,-2.62,-1.27,-0.25,0.46,1.21,2.12,3.34,3.07,3,3,3,3,3,3,3,3,2,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,2,2,3,3,3,3,3,2,2,3,3,3,3,3,2.89,2.90,3.75,2.72,1.33,0.73,0.41,0.34,0.32,0.26,0.16,-0.02,-0.25,-0.67,-1.34,-0.77,-0.49,-0.24,-0.04,0.07,0.12,0.13,0.12,0.08,0.04,0.03,0.04,0.04,0.01,0,0,0,0,0,0.42,0.49,0.16,-0.16,-0.50,-1.43,-2.37,-3.49,-4.37,-6.02,-8.37,-10,-11,-11,-10,-8.33,-6.22,-4.03,-1.89,-0.98,-0.40,-0.05,0.07,0.09,0.07,0.03,0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,3,3,4,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,2,2,3,3,2,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,1,1,0,0,0,6.04,4.90,3.67,2.60,1.66,0.83,0.57,0.53,0.41,1.23,1.97,2,3,3,1.97,1.09,0.90,0.49,0.12,-0.23,-0.42,-0.43,-0.30,-0.13,0.01,0,-0.09,-1.01,-2.23,-3.26,-4.35,-5.46,-6.36,-6.66,-6.41,-4.96,-3.22,-1.67,-0.40,0.34,1,1.88,2.83,3.89,4,3,3,3,3,3,3,3,2,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,2,3,3,3,4,4,3,3,3,3,3,4,4,3,3.07,3.13,2.86,2.23,1.29,0.71,0.46,0.42,0.48,0.49,0.41,0.23,-0.02,-0.30,-0.71,-1.33,-0.83,-0.53,-0.23,-0.03,0.07,0.12,0.13,0.12,0.11,0.12,0.20,0.25,0.12,0,0,0,0,0,0.60,0.83,0.53,0.21,-0.15,-0.50,-1.08,-1.67,-2.09,-3.35,-6.59,-8.75,-10,-10,-9.67,-8.24,-6.37,-4.33,-2.26,-1.01,-0.42,-0.08,0.07,0.07,0.02,0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,2,3,3,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,3.97,3.38,2.53,1.74,1.09,0.70,0.58,0.71,1.03,1.37,2.02,2,3,2.02,1.10,0.99,0.60,0.23,-0.15,-0.50,-0.71,-0.92,-1.24,-1.38,-1.11,-0.87,-1.05,-2.48,-3.41,-4.37,-5.26,-6.09,-6.74,-6.90,-6.38,-5.30,-3.61,-2.01,-0.64,0.11,0.66,1.50,2.52,3.86,5,4,3,3,3,3,3,3,2,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,2,2,3,3,4,4,4,4,4,4,4,4,4,4,3.98,3.11,2.83,2,1.22,0.71,0.53,0.62,0.74,0.75,0.64,0.42,0.21,-0.04,-0.37,-0.75,-1.53,-0.88,-0.49,-0.22,0,0.11,0.16,0.17,0.20,0.24,0.37,0.63,0.77,0.95,0,0,0,0,0.71,1.04,0.87,0.61,0.21,-0.17,-0.50,-0.78,-1.03,-1.97,-5.18,-7.78,-9.58,-10,-9.86,-8.47,-6.63,-4.64,-2.65,-1.05,-0.47,-0.09,0.04,0.03,0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,2,2,2,2,2,2,2,2,2,2,2,3,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,2.42,2.07,1.47,0.88,0.57,0.50,0.65,1.07,1.52,2.07,2.75,3,2.04,1.40,1.03,0.63,0.29,-0.03,-0.38,-0.88,-1.87,-2.79,-3.38,-3.75,-3.90,-3.74,-3.77,-4.09,-4.63,-5.25,-5.89,-6.53,-6.91,-6.97,-6.46,-5.43,-3.86,-2.29,-0.89,-0.18,0.27,1.08,2.12,3.33,5,4,4,3,3,3,3,3,2,2,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,2,2,3,3,4,4,5,4,4,4,4,4,4,4,4,3.95,2.87,1.82,1.12,0.62,0.75,0.92,1.11,1.11,0.90,0.62,0.36,0.14,-0.08,-0.33,-0.77,-1.60,-0.89,-0.49,-0.22,0,0.12,0.21,0.25,0.34,0.50,0.77,1.53,0.98,0.98,1,1,0,0.84,1.14,1.15,1,0.57,0.14,-0.23,-0.52,-0.78,-1.25,-4.28,-6.90,-8.90,-9.90,-9.74,-8.61,-6.89,-4.97,-2.93,-1.08,-0.49,-0.12,0.02,0.02,0,0,0,0.01,0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,2,2,1,1,1,1,1,2,2,2,2,2,3,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,1.37,1.08,0.64,0.21,0.16,0.35,0.72,1.24,2.26,2.47,2.66,2.54,1.70,1.13,0.71,0.32,0,-0.28,-1.10,-2.24,-3.86,-5.30,-6.17,-6.58,-6.46,-6.21,-5.91,-5.78,-5.86,-6.13,-6.53,-6.93,-7.14,-6.99,-6.50,-5.49,-4.04,-2.55,-1.16,-0.41,-0.05,0.64,1.63,2.78,3.83,4,5,4,3.02,3.08,3.89,3.87,2.87,2.12,1.87,1.10,1.08,1,1,1,1,0,0,0,0,0,0,0,0,1,1,2,2,3,4,4,5,5,5,4,4,4,4,4,4,4,2.07,1.12,1.16,0.97,1.02,1.28,1.57,1.54,1.15,0.76,0.48,0.26,0.12,-0.05,-0.24,-0.79,-1.58,-1.02,-0.53,-0.37,-0.08,0.13,0.26,0.38,0.53,0.78,0.95,1.01,0.98,1,1,1,1,1.24,1.37,1.35,0.87,0.42,0.03,-0.28,-0.54,-0.84,-3.41,-6.34,-8.65,-9.92,-9.97,-8.91,-7.22,-5.23,-3.13,-1.03,-0.48,-0.12,0.02,0.02,0,0,0.01,0.12,0.13,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.62,0.45,0.20,-0.01,0,0.24,0.64,1.15,1.66,2.37,2,1.72,1.21,0.73,0.33,-0.03,-0.29,-0.92,-2.64,-4.28,-6.12,-7.59,-8.63,-9.04,-8.83,-8.37,-7.78,-7.27,-7.02,-7,-7.23,-7.46,-7.51,-7.25,-6.65,-5.64,-4.30,-2.84,-1.42,-0.51,-0.25,0.36,1.27,2.41,3.34,4,5,4.04,3.88,3.85,3.86,3.79,3.79,2.20,2,1.83,1.14,1.11,1,1,1,0,0,0,0,0,0,0,0,0,1,1,2,3,4,5,5,5,5,5,5,5,4,4,4,3,2,1.95,1.11,1.13,1.41,1.58,1.87,1.84,1.33,0.89,0.59,0.37,0.25,0.15,-0.01,-0.28,-0.84,-1.63,-1.78,-0.98,-0.42,-0.10,0.15,0.34,0.50,0.66,0.79,0.89,0.92,0.98,1,1,1,1.02,1.39,1.47,1.02,0.62,0.24,-0.10,-0.36,-0.63,-2.43,-5.72,-8.25,-9.75,-9.99,-9.09,-7.41,-5.41,-3.27,-1.03,-0.39,-0.10,0.02,0.02,0,0,0.01,0.13,0.85,0.11,0.03,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.04,-0.02,-0.09,0,0.21,0.52,0.86,1.17,1.36,1.32,1.02,0.63,0.25,-0.09,-0.38,-1.17,-2.79,-4.68,-6.16,-7.98,-9.53,-10,-11,-10,-10,-9.25,-8.47,-7.97,-7.80,-7.93,-8.13,-8.05,-7.71,-7.09,-6.08,-4.73,-3.17,-1.59,-0.52,-0.30,0.16,1,2.12,3.47,4,4.91,4.87,4.16,4.21,4.08,3.76,3.26,2.77,2.25,2.10,1.78,1.16,1.12,1.08,1,1,0,0,0,0,0,0,0,0,0,1,2,3,3,4,4,4,5,5,5,5,5,4,4,3,3,2,2.01,1.92,1.87,1.62,1.66,1.73,1.37,0.97,0.70,0.50,0.40,0.32,0.22,0,-0.34,-0.88,-1.72,-1.83,-0.86,-0.43,-0.13,0.14,0.40,0.59,0.72,0.84,0.86,0.79,1,0,0,1,1.13,1.34,1.04,0.73,0.38,0.10,-0.17,-0.46,-1.86,-4.99,-7.36,-8.96,-9.42,-8.84,-7.43,-5.59,-3.47,-1.13,-0.28,-0.03,0.04,0.03,0,0,0,0.12,0.11,0.92,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.12,-0.10,-0.05,-0.01,0.09,0.22,0.40,0.57,0.66,0.72,0.62,0.39,0.11,-0.21,-0.67,-1.77,-3.09,-4.61,-6.22,-7.88,-9.47,-11,-12,-12,-11,-11,-10,-9.11,-8.51,-8.39,-8.54,-8.88,-8.65,-8.29,-7.74,-6.86,-5.33,-3.62,-1.83,-0.75,-0.28,0.10,0.75,1.92,3.24,4.95,4.87,4.84,4.76,4.73,4.12,3.77,3.32,3.01,2.79,2.71,2.26,2.12,1.88,1.87,1.04,1,0,0,0,0,0,0,0,0,0,1,1,2,3,3,3,4,4,5,5,5,5,4,4,4,3,3,3,3,2,1.01,1.33,1.39,1.26,1,0.84,0.75,0.65,0.54,0.40,0.25,0.01,-0.30,-0.42,-0.85,-0.84,-0.76,-0.59,-0.10,0.24,0.50,0.63,0.74,0.66,0.57,0.33,0.13,0,0,0.86,1.12,1,0.78,0.52,0.25,-0.02,-0.30,-1.24,-4.23,-6.75,-8.54,-9.29,-8.90,-7.64,-5.88,-3.78,-1.41,-0.16,0.02,0.08,0.04,0.01,0,0,0,0.03,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.04,0.07,0.09,0.13,0.22,0.26,0.29,0.28,0.26,0.22,0.10,-0.13,-0.37,-1.26,-2.43,-3.91,-5.33,-6.64,-8,-9.23,-10,-11,-11,-12,-11,-10,-9.88,-9,-8.48,-8.55,-8.98,-9.36,-9.16,-8.83,-8.67,-7.75,-6.02,-4.13,-2.36,-1.15,-0.33,-0.13,0.40,1.45,2.96,4.88,4.85,4.97,4.86,4.29,4.24,3.92,3.65,3.35,3.29,3.22,3.12,3,2.76,2.16,1.88,1.02,1,0,0,0,0,0,0,0,0,1,1,2,2,3,3,4,4,5,5,5,5,5,4,4,4,3,3,2,1,1,1,1.12,1.10,1.01,1.03,1.09,1.04,0.87,0.63,0.45,0.27,0.12,-0.08,-0.25,-0.39,-0.73,-1.53,-0.48,0.11,0.39,0.53,0.61,0.51,0.37,0.22,0.08,0,0.01,1,0.88,0.97,0.88,0.72,0.42,0.12,-0.15,-0.63,-3.50,-6.11,-8.13,-9.17,-9.05,-7.97,-6.30,-4.33,-2.01,-0.05,0.10,0.12,0.09,0.02,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,2,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.54,0.50,0.42,0.37,0.35,0.26,0.15,0.03,-0.08,-0.18,-0.34,-0.73,-1.85,-3.29,-4.38,-6.17,-7.47,-8.48,-9.40,-10,-10,-10,-10,-10,-10,-9.80,-8.84,-8.09,-7.71,-8.04,-8.88,-9.71,-9.24,-9.13,-8.75,-7.83,-6.35,-4.74,-3.12,-1.84,-0.74,-0.34,0.12,1.07,2.51,3.85,4.78,5.16,5.11,4.82,4.37,4.34,4.10,3.89,3.78,3.89,3.99,3.97,3.73,3.21,2.85,2.08,1,1,0,0,0,0,0,0,0,1,1,2,3,3,3,4,4,5,5,5,5,5,5,4,4,3,2,1,1,1,1,1,1,1.01,1.11,1.71,1.59,1.24,0.91,0.66,0.49,0.33,0.20,0.07,-0.12,-0.33,-0.66,-0.63,0.03,0.26,0.47,0.50,0.40,0.26,0.15,0.11,0.12,0.27,0.01,0.98,0.99,1.02,0.96,0.62,0.32,0,-0.26,-2.87,-5.33,-7.40,-8.68,-8.93,-8.25,-6.92,-5.14,-3,-0.61,0.20,0.21,0.12,0.03,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.26,1.03,0.74,0.50,0.33,0.12,-0.05,-0.24,-0.39,-0.73,-1.58,-2.40,-3.77,-5.13,-7.12,-8.38,-9.37,-9.89,-10,-10,-10,-10,-9.65,-9.33,-8.84,-8.02,-7.18,-6.52,-6.16,-6.58,-7.77,-8.29,-8.53,-8.87,-8.72,-7.89,-6.73,-5.41,-4.05,-2.73,-1.39,-0.46,-0.03,0.79,2.09,3.16,4.75,5.71,5.73,5.37,5.09,4.88,4.65,4.39,4.39,4.72,4.92,4.95,4.74,4.24,3.87,3.10,2,1,1,0,0,0,0,0,0,1,1,2,3,4,4,4,5,5,5,5,5,4,4,4,4,3,3,1,1,1,1,2,2,2,2.07,2.76,2.03,1.63,1.29,1,0.73,0.51,0.37,0.24,0.11,-0.09,-0.27,-0.85,-0.75,0.17,0.35,0.37,0.34,0.24,0.17,0.15,0.22,0.25,0.70,1,0.98,1.10,1.10,0.83,0.50,0.20,-0.09,-1.92,-4.66,-7.02,-8.61,-9.24,-8.92,-7.87,-6.28,-4.29,-2,-0.09,0.13,0.24,0.11,0.14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,2,2,2,2,3,2,2,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,1,0,0,0,1,2,1.23,0.77,0.39,0.11,-0.15,-0.38,-0.55,-1.36,-2.41,-3.50,-4.28,-6.10,-7.87,-9.63,-10,-10,-10,-10,-9.73,-9.12,-8.50,-7.92,-7.40,-6.83,-6,-5.21,-4.49,-3.88,-4,-5,-5.76,-6.80,-7.77,-8.12,-7.75,-7.04,-6.13,-5.04,-3.78,-2.38,-0.84,-0.08,0.71,1.65,2.97,4.75,6.70,6.64,5.83,5.72,5.60,5.28,5.01,5.13,5.60,5.82,5.91,5.83,5.75,4.99,4.87,4,2,1,0,0,0,0,0,0,1,1,2,3,3,4,5,5,6,6,5,4,4,4,4,3,3,2,1,2,2,2,2,2,3,4,2.89,2.26,2.14,1.79,1.41,1.04,0.75,0.52,0.37,0.24,0.11,-0.13,-0.86,-1.92,-0.92,0.21,0.26,0.27,0.23,0.20,0.16,0.20,0.24,0.27,0.17,1,1.01,1.22,1.04,0.72,0.36,0.09,-1.29,-4.05,-6.40,-8.30,-9.46,-9.68,-9.04,-7.67,-5.88,-3.76,-0.99,0.07,0.25,0.38,0.48,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,2,2,2,3,3,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1.37,1.01,0.51,0.09,-0.26,-0.53,-0.75,-1.75,-3.37,-4.59,-5.33,-6.78,-8.89,-10,-11,-11,-10,-10,-9.25,-8.35,-7.52,-6.75,-6.02,-5.29,-4.62,-4,-2.89,-2.10,-1.52,-0.89,-1.29,-2.16,-4.64,-6.22,-7.25,-7.49,-7.33,-6.88,-6.11,-4.90,-3.38,-1.54,-0.27,0.41,1.22,2.20,3.73,5.67,5.64,5.83,6.03,6.58,5.82,5.41,5.79,6.20,6.61,6.84,6.91,6.73,6.16,5.12,4,2,1,0,0,0,0,0,0,1,1,2,3,3,4,5,6,7,6,6,5,5,5,4,3,2,1,1,2,4,3,3,3,4,4,3.01,3.11,2.84,2.45,1.95,1.42,1.01,0.71,0.50,0.36,0.23,0.01,-0.02,-1.04,-1.89,-0.79,0.16,0.24,0.24,0.21,0.17,0.17,0.20,0.25,0.50,0.83,0.98,1.12,1.61,0.76,0.45,0.21,-0.46,-2.98,-5.38,-7.62,-9.35,-10,-10,-9.22,-7.51,-5.53,-3.12,-0.03,0.29,0.51,0.75,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,2,2,2,3,3,3,3,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,1,0.86,0.51,0.04,-0.38,-0.72,-0.98,-2.02,-4.01,-5.50,-6.88,-8.17,-9.79,-10,-11,-12,-11,-10,-8.76,-7.63,-6.60,-5.65,-4.85,-4.10,-3.25,-2.25,-1.63,-0.78,-0.40,-0.15,-0.17,-0.28,-0.47,-1.61,-4.90,-6.54,-7.35,-7.63,-7.53,-7,-6.14,-4.40,-2.47,-0.68,0,0.74,1.35,2.26,3.32,4.35,5.61,6.12,6.34,6.25,6.24,6.38,6.79,7.29,7.84,8.01,7.84,7.79,5.87,4,2,1,0,0,0,0,0,0,1,1,2,2,4,4,5,6,6,6,6,6,5,4,3,3,2,1,1,2,4,4,4,4,4,4,4,4,3.77,3.22,2.50,1.83,1.26,0.87,0.62,0.47,0.35,0.24,0.12,0.02,-0.89,-1.97,-1,0.16,0.16,0.17,0.16,0.15,0.16,0.26,0.49,0.73,0.89,1.04,0.89,0.70,0.45,0.23,0.02,-1.42,-4.01,-6.38,-8.41,-9.88,-10,-10,-9.13,-7.13,-4.76,-1.97,0.26,0.60,0.79,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,2,2,2,3,3,3,3,3,3,3,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,2,2,2,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0.47,-0.08,-0.50,-0.88,-1.21,-2.28,-4.41,-6.18,-7.84,-9.14,-10,-11,-12,-11,-11,-10,-8.46,-6.99,-5.68,-4.63,-3.75,-3.01,-2.35,-1.51,-0.53,-0.24,-0.13,0,0.01,-0.02,-0.17,-0.40,-1.86,-4.64,-6.53,-7.58,-8.05,-8.25,-7.98,-6.91,-5.21,-3.25,-1.28,-0.39,0.35,0.95,1.25,2.29,4.01,5.37,6.60,6.41,6.72,6.92,7.15,7.39,8,8.64,9.70,8.75,7.79,6.09,4,3,1,1,0,0,0,0,0,0,1,1,2,2,3,4,5,5,6,8,7,5,4,3,3,2,1,1,3,4,4,5,4,5,6,5,5,4.50,3.98,3.04,2.14,1.40,0.98,0.73,0.58,0.48,0.39,0.28,0.15,0.03,-1.12,-2.04,-0.90,0.09,0.11,0.12,0.12,0.14,0.25,0.39,0.60,0.67,0.72,0.71,0.48,0.37,0.25,0.10,-0.15,-2.68,-5.05,-7.42,-9.50,-10,-10,-10,-8.25,-6.16,-3.34,-0.62,0.62,0.85,0.96,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,2,2,2,2,2,2,3,3,4,4,3,3,3,3,3,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,1,1,1,1,2,2,3,2,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,-0.47,-0.71,-1.05,-1.39,-2.47,-4.60,-6.58,-8.42,-10,-11,-11,-12,-12,-10,-9.37,-8.08,-6.38,-4.83,-3.51,-2.61,-1.98,-1.47,-0.84,-0.24,-0.12,-0.04,0,0.11,0.24,0.09,-0.14,-0.42,-2.75,-5.54,-7.42,-8.38,-8.63,-8.66,-8.28,-7.28,-5.84,-3.80,-1.83,-0.67,0.10,0.64,1.24,2.28,3.88,5.62,6.61,7.11,7.39,7.77,8.12,8.38,8.86,9.15,9.16,9.75,7.83,6.10,5,3,2,1,1,0,0,0,0,0,0,1,1,2,2,3,4,5,7,8,7,6,4,3,3,2,2,2,3,4,5,5,5,5,6,6,5,4.89,4.26,3.24,2.35,1.61,1.14,0.90,0.75,0.70,0.62,0.52,0.37,0.20,0.02,-0.93,-1.89,-1.02,-0.10,0,0.03,0.11,0.20,0.28,0.34,0.36,0.35,0.29,0.34,0.32,0.25,0.15,0,-0.84,-3.63,-6.05,-8.34,-10,-10,-10,-9.18,-7.09,-4.28,-1.36,0.63,0.91,1.12,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,2,2,2,2,2,3,3,4,4,4,3,3,3,3,3,3,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,2,3,4,2,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,-1.17,-1.83,-2.86,-4.18,-5.89,-7.40,-8.97,-10,-11,-12,-12,-11,-10,-8.78,-7.14,-5.68,-4.26,-2.30,-1.05,-0.60,-0.38,-0.22,-0.05,0.01,0.04,0.15,0.25,0.25,0.45,0.17,-0.22,-1.78,-4.65,-7.34,-9.91,-9.55,-9.28,-9.02,-8.59,-7.64,-6.08,-4.15,-2.24,-0.65,-0.02,0.45,1.13,2.26,3.96,5.66,7,7.77,8.29,8.78,9.20,9.62,9.64,9.70,8.88,8.12,7.14,5.99,5,3,2,2,1,1,0,0,1,0,0,1,1,1,2,3,3,5,6,8,7,6,5,4,3,3,2,2,4,5,5,5,6,6,6,6,5,5.83,4.28,3.32,2.48,1.79,1.38,1.13,0.99,0.92,0.89,0.82,0.63,0.40,0.22,0.08,-0.96,-1.97,-1.11,-0.15,-0.05,0.03,0.12,0.17,0.23,0.24,0.23,0.24,0.24,0.24,0.21,0.14,0.11,-0.11,-2.18,-4.63,-7.25,-9.46,-10,-10,-9.76,-7.48,-4.84,-1.84,0.58,0.97,1.33,1.84,2,1,1,1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,2,2,2,2,2,3,3,4,5,4,4,3,3,3,3,3,3,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,2,3,4,2,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,-2.50,-4.22,-6.12,-7.25,-8.66,-10,-11,-11,-12,-12,-11,-10,-8,-6.62,-5.46,-3.93,-2.05,-0.88,-0.58,-0.30,-0.13,-0.02,0.04,0.10,0.20,0.13,0.82,0.76,0.25,-0.11,-0.78,-3.47,-6.18,-9.21,-11,-10,-9.50,-9,-8.37,-7.48,-6.12,-4.39,-2.46,-0.51,-0.03,0.40,0.34,2.23,3.87,5.72,7.66,8.64,9.27,9.87,10.64,10.22,10.04,9.71,8.33,7.35,6.66,5.72,4.12,3.07,2.22,1.87,1.89,0.99,0,1,1,1,1,1,1,1,2,2,3,4,6,7,7,7,5,4,4,3,3,3,4,6,6,6,6,6,7,7,6,5,4.34,3.47,2.66,2.09,1.64,1.37,1.22,1.17,1.17,1.11,0.91,0.65,0.40,0.21,0.04,-0.91,-2.01,-1.27,-0.18,0,0.09,0.12,0.15,0.16,0.17,0.17,0.20,0.21,0.20,0.14,0.08,0,-0.78,-3.04,-5.97,-8.55,-10,-10,-9.49,-7.63,-4.98,-2,0.54,1.01,1.49,2.01,2.70,1.98,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,2,2,2,2,2,3,3,4,5,5,5,4,3,3,3,3,3,3,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,3,4,2,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,-3.85,-6.02,-7.87,-9.35,-10,-11,-12,-12,-12,-11,-10,-8.23,-5.93,-4.68,-3.27,-2,-1,-0.65,-0.35,-0.12,0.01,0.09,0.10,0.09,0.03,0.90,0.87,-0.84,-0.27,-0.39,-1.30,-3.66,-6.88,-9.11,-10,-10,-9.40,-8.85,-8.25,-7.48,-6.27,-4.52,-2.52,-0.38,0.07,0.46,1.12,2.17,3.87,5.26,7.71,8.98,9.98,11.67,11.07,10.77,10.16,9.60,8,6.45,5.41,4.38,3.40,2.78,2.27,1.99,1.75,1.16,0.92,1,1,1,1,1,1,1,2,2,3,4,5,6,6,6,5,4,4,4,4,3,4,5,5,6,6,7,8,8,7,6,4.98,3.83,2.96,2.38,1.90,1.57,1.38,1.37,1.41,1.40,1.24,0.92,0.62,0.35,0.15,0.04,-1.01,-2.01,-1.13,-0.12,0.04,0.10,0.13,0.15,0.16,0.17,0.20,0.21,0.20,0.14,0.08,-0.04,-0.24,-1.99,-4.85,-7.54,-9.47,-10,-9.16,-7.46,-4.67,-1.88,0.53,1.01,1.48,1.98,2.38,1.83,1.01,1,0,0,0,0,0,0,1,2,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,2,2,2,3,3,4,4,5,5,5,4,4,3,3,3,3,3,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,3,4,2,2,2,1,1,0,0,0,0,0,0,0,0,0,0,0,0,-4.72,-6.71,-8.67,-10,-11,-12,-12,-11,-11,-10,-8.47,-6.24,-4.48,-2.74,-1.54,-1.08,-0.77,-0.48,-0.23,-0.04,0.03,0.08,0.04,0.01,0,0.97,-0.92,-0.88,-0.64,-0.59,-1.92,-5.33,-7.72,-9.29,-9.88,-9.54,-9.11,-8.61,-8.05,-7.38,-6.25,-4.60,-2.60,-0.40,0.09,0.60,1.26,2.12,3.89,5.98,8.75,9.23,10.28,11.65,11.64,11.13,10.46,9.29,7.62,6.14,4.54,3.52,3.11,2.51,2.23,1.99,1.74,1.29,1.20,1.08,1,1,1,1,1,1,2,2,3,3,4,5,6,7,6,5,4,4,3,3,4,4,4,5,6,7,8,9,8,7,6,4.01,3.20,2.61,2.08,1.62,1.45,1.46,1.61,1.70,1.57,1.21,0.78,0.48,0.26,0.15,0.11,-0.85,-1.83,-1.05,-0.12,0.01,0.07,0.10,0.13,0.17,0.22,0.23,0.21,0.15,0.08,-0.04,-0.22,-1.47,-4.02,-6.54,-8.40,-9.12,-8.39,-6.50,-3.97,-1.40,0.52,1,1.37,1.67,1.76,1.54,1.23,1,0,0,0,0,0,0,1,2,2,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,2,2,2,3,3,4,4,5,5,5,4,4,4,3,3,3,3,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,3,3,2,2,2,2,1,1,0,0,0,0,0,0,0,0,0,0,0,-6.03,-7.48,-9.27,-10,-12,-12,-11,-11,-10,-8.59,-6.75,-4.73,-2.52,-1.33,-1.09,-0.83,-0.54,-0.29,-0.11,0.01,0.07,0.04,0.01,0,0,1,-0.99,-0.96,-0.58,-1.34,-4.23,-7.51,-9.01,-9.55,-9.51,-9.21,-8.79,-8.38,-7.92,-7.28,-6.22,-4.63,-2.73,-0.64,-0.01,0.62,1.35,2.04,4.11,6.14,8.16,9.75,10.29,11.34,11.64,11.49,11.34,9.53,7.74,5.74,4.73,3.70,2.98,2.51,2.21,2.03,1.91,1.88,1.89,1.96,1.99,2,2,2,1,1,2,2,3,3,3,4,5,7,6,6,5,4,4,4,4,4,4,4,5,7,8,8,8,6,5,4,3,2.83,1.98,1.58,1.35,1.51,1.74,1.95,1.86,1.41,0.90,0.57,0.34,0.24,0.17,0.12,-0.78,-1.88,-3.09,-2.12,-0.14,-0.09,0.01,0.12,0.22,0.25,0.24,0.17,0.10,-0.02,-0.18,-1.37,-3.34,-5.38,-7.02,-7.75,-7.22,-5.42,-3.01,-0.27,0.50,0.99,1.34,1.51,1.51,1.36,1.14,0.84,0,0,0,0,0,0,1,2,2,2,1,1,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,2,2,2,3,3,4,4,5,5,5,4,4,4,3,3,3,3,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,3,3,3,2,2,2,2,1,1,1,0,0,0,0,0,0,0,0,0,0,-6.62,-8.18,-10,-11,-12,-12,-11,-10,-8.68,-6.90,-5.01,-3.22,-1.38,-1,-0.78,-0.58,-0.34,-0.12,0.03,0.10,0.10,0.02,0,0,0,1,-1,-0.85,0.14,-2.83,-7.46,-11,-10,-9.64,-9.38,-8.88,-8.52,-8.18,-7.85,-7.36,-6.39,-4.78,-2.88,-0.96,-0.24,0.57,1.50,3,4.97,7,8.84,10.17,11.14,11.78,12,11.92,11.32,10.15,8.51,6.78,4.91,3.87,3.16,2.62,2.28,2.16,2.24,2.45,2.66,2.85,2.96,2.97,2,2,2,1,2,2,3,3,3,4,5,6,6,7,7,5,4,4,4,4,4,4,5,7,8,8,7,6,5,4,3,2,2,1.27,1.50,1.64,1.85,2,1.89,1.48,1,0.63,0.40,0.32,0.26,0.21,0.10,-0.96,-3.09,-3.86,-3.73,-0.86,-0.23,-0.01,0.15,0.25,0.26,0.22,0.12,0.01,-0.13,-0.72,-2.49,-4.15,-5.54,-6.25,-5.87,-4.23,-1.51,-0.08,0.49,1,1.46,1.65,1.62,1.37,1.13,0.67,0,0,0,0,0,0,1,2,3,2,2,2,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,2,2,3,3,3,4,4,5,5,5,4,4,4,3,3,3,3,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,1,1,1,1,1,2,2,3,3,3,3,2,2,2,2,2,1,1,1,0,0,0,0,0,0,0,0,0,0,-7.39,-9.05,-10,-12,-12,-12,-10,-9.12,-7.18,-5.13,-3.36,-1.64,-0.85,-0.66,-0.50,-0.34,-0.13,0.09,0.20,0.22,0.02,0,0,0,0,1,-1,-0.71,-0.61,-2.89,-8.63,-11,-10,-9.39,-8.93,-8.46,-8.14,-7.87,-7.52,-6.98,-6.09,-4.68,-2.98,-1.13,-0.39,0.47,1.59,3,6,7.95,9.75,10.70,12.38,12.32,12.47,12.35,11.87,10.96,9.62,7.96,6.14,4.62,3.54,2.87,2.48,2.39,2.60,3.01,3.51,3.73,3.78,3.91,3,2,2,2,2,2,3,3,4,4,5,6,6,6,6,5,5,5,5,4,5,5,5,7,8,7,6,5,4,4,3,2,2,1.99,1.90,1.95,1.98,1.99,1.84,1.45,1.08,0.75,0.52,0.42,0.37,0.27,0.13,-0.01,-0.21,-4.73,-6.65,-4,-0.63,-0.16,0.02,0.22,0.27,0.25,0.16,0.08,-0.05,-0.18,-1.33,-2.55,-3.50,-4.02,-3.66,-2.25,-0.71,-0.17,0.39,0.95,1.49,1.82,1.87,1.64,1.33,0.88,0,0,0,0,0,0,1,2,2,3,2,2,2,1,1,1,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,2,2,2,3,3,3,4,5,5,5,5,5,5,4,4,3,3,3,3,3,3,3,3,2,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,2,2,2,2,2,2,2,2,1,1,0,0,0,0,0,0,0,0,0,0,-8.54,-10,-11,-12,-12,-12,-10,-7.90,-5.58,-3.27,-1.55,-0.68,-0.54,-0.40,-0.28,-0.15,0,0.13,0.50,0.01,0,0,0,0,0,1,1,-0.58,-0.61,-1.66,-6.13,-9.75,-8.88,-8.43,-8.10,-7.79,-7.62,-7.40,-7.11,-6.55,-5.71,-4.49,-3.01,-1.34,-0.51,0.34,1.50,3,5.98,7.75,9.50,10.75,12.13,12.89,12.98,13,12.74,12.12,10.91,9.29,7.38,5.39,4.15,3.25,2.75,2.63,2.96,3.62,4.25,4.59,4.73,3.99,3,3,2,2,2,2,3,3,4,4,5,5,6,6,6,6,5,5,5,5,5,6,6,7,7,7,6,5,4,4,3,3,2,3,2.98,2.29,2.15,2,1.85,1.50,1.23,0.91,0.72,0.60,0.47,0.34,0.21,0.03,-0.14,-1.87,-6.25,-5.03,-1.92,-0.26,-0.05,0.12,0.23,0.27,0.23,0.13,0.01,-0.11,-0.25,-0.87,-1.71,-2,-1.64,-1.18,-0.88,-0.36,0.23,0.77,1.33,1.74,2.02,1.97,1.73,1.23,1,0,0,0,0,1,1,1,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,2,2,2,3,3,4,4,5,6,5,5,5,5,5,4,3,3,3,3,3,3,3,3,2,1,1,1,1,1,1,1,1,1,1,2,2,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,0,0,0,0,0,0,0,0,0,0,-9.59,-10,-12,-13,-12,-11,-9.13,-6.53,-3.93,-1.51,-0.53,-0.38,-0.26,-0.16,-0.10,0,0.10,0.22,0.01,0,0,0,0,0,0,0,1,0.49,-0.27,-0.73,-2.38,-5.39,-6.53,-6.90,-7.02,-7,-6.97,-6.88,-6.64,-6.16,-5.38,-4.33,-3.04,-1.75,-0.63,0.24,0.87,3.01,5.12,6.48,8.73,10.72,11.99,12.88,13.45,13.72,13.73,13.34,13.02,10.58,8.51,6.63,4.97,3.74,3.02,2.85,3.21,4.04,5.45,5.54,5.09,4.12,4,3,3,2,2,3,3,4,4,4,4,5,6,6,6,6,6,5,5,6,6,6,7,8,7,7,6,4,4,3,3,3,3,3,3,3,2.17,2.12,2,1.79,1.45,1.14,0.88,0.75,0.53,0.38,0.25,0.12,-0.05,-0.24,-4.55,-6.28,-1.73,-0.35,-0.13,0.03,0.16,0.25,0.27,0.20,0.09,-0.03,-0.17,-0.39,-0.72,-1.08,-1.35,-1.37,-1.08,-0.54,0.04,0.52,0.98,1.45,1.97,2.25,2.14,1.75,1,1,0,0,0,1,1,1,1,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,2,2,2,2,3,3,4,4,5,5,5,5,5,5,5,4,3,3,3,4,4,3,3,3,2,1,1,1,1,1,1,1,1,1,2,2,2,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,1,1,2,2,2,2,2,1,1,0,0,0,0,0,0,0,0,0,0,-9.63,-10,-12,-12,-12,-10,-7.75,-4.96,-2.33,-0.51,-0.29,-0.16,-0.09,-0.02,0.01,0.03,0.03,0,0,0,0,0,0,0,0,0,0,0.46,0.14,-0.49,-1,-2.22,-4.13,-5.13,-5.74,-6.03,-6.28,-6.39,-6.28,-5.90,-5.23,-4.25,-3.09,-1.84,-0.64,0.15,1.26,2.40,5.12,7.28,9.27,10.90,12.16,13.10,13.84,14.36,14.64,14.61,13.62,11.72,9.57,7.58,5.78,4.35,3.34,2.88,3.29,4.17,5.41,6.51,5.65,5.10,4,4,3,3,3,3,3,4,4,4,4,5,5,6,6,6,6,6,5,6,7,7,8,8,7,7,6,4,3,3,4,4,5,5,3,3,2,2,2.97,2.04,1.92,1.22,1.09,0.78,0.59,0.41,0.29,0.16,0.02,-0.13,-3.34,-5.39,-2.72,-0.51,-0.18,-0.05,0.09,0.20,0.25,0.24,0.12,0.02,-0.13,-0.38,-0.73,-1.13,-1.43,-1.50,-1.18,-0.60,0.02,0.42,0.74,1.17,1.89,2.41,2.66,2.32,2,1,0,0,0,0,0,0,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,2,2,2,3,3,3,3,4,4,4,5,5,5,5,5,5,4,3,3,4,5,4,3,3,3,2,1,1,1,1,1,1,1,1,2,2,2,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,1,1,1,2,2,2,2,2,1,1,0,0,0,0,0,0,0,0,0,0,-8.58,-9.88,-11,-12,-11,-9.13,-6,-2.91,-0.60,-0.27,-0.11,0,0.03,0.04,0.03,0.02,0,0,0,0,0,0,0,1,0,0,0,0.41,0.36,0.10,-0.47,-0.62,-1.87,-3.27,-4.27,-4.97,-5.48,-5.80,-5.88,-5.66,-5.13,-4.25,-3.13,-1.88,-0.60,0.23,1.27,3.12,5.25,8.17,9.95,11.62,12.38,13.34,14.21,14.88,15.25,15.33,14.35,12.47,10.46,8.42,6.58,4.97,3.77,2.90,3.36,3.99,4.86,5.71,6.65,5.87,5,5,4,4,3,3,3,4,3,3,3,4,5,5,6,5,5,5,5,5,6,8,8,7,6,5,4,4,3,3,4,5,6,5,4,3,2,3,3,3,3,1.90,1.20,0.84,0.60,0.42,0.32,0.21,0.08,-0.04,-2,-4.54,-4.64,-2.80,-0.53,-0.21,-0.03,0.12,0.22,0.23,0.17,0.12,0,-0.25,-0.62,-1.04,-1.39,-1.46,-1.15,-0.51,0.08,0.38,0.52,0.90,1.64,2.37,2.91,3.42,2,1,1,0,0,0,0,0,0,1,1,1,1,1,2,1,1,1,1,1,1,1,2,2,2,2,2,1,1,1,1,2,2,2,2,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,2,2,2,3,3,3,4,4,4,4,5,5,5,5,5,5,5,4,4,3,4,4,4,3,3,3,2,1,1,1,1,1,1,1,2,2,2,2,3,3,3,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,2,2,2,2,2,1,1,1,1,1,0,0,0,0,0,0,0,-6.23,-7.73,-10,-11,-10,-7.49,-3.47,-1.05,-0.34,-0.10,0.03,0.11,0.11,0.08,0.03,0,0,0,0,0,0,0,0,0,0,0,0,0.21,0.25,0.33,0.04,-0.22,-0.38,-0.98,-2.85,-3.88,-4.66,-5.21,-5.52,-5.53,-5.17,-4.40,-3.33,-1.97,-0.50,0.25,1.35,3.10,5.20,7.39,9.70,11.40,12.40,13.47,14.48,15.33,15.75,15.62,14.76,13.23,11.29,9.32,7.42,5.76,4.28,3.70,3.49,3.64,4.27,5.14,6.70,6.12,6,6,5,5,4,4,3,3,3,3,3,3,4,4,5,4,4,4,5,5,6,7,7,6,5,4,4,4,3,4,5,7,7,5,4,3,3,3,3,4,3,2,1.15,0.86,0.62,0.45,0.32,0.20,0.07,-0.04,-1.04,-3.64,-5.85,-4.78,-1.83,-0.38,-0.21,0.01,0.15,0.22,0.24,0.28,0.25,0.12,-0.28,-0.75,-1.14,-1.17,-0.83,-0.21,0.26,0.39,0.37,0.66,1.37,2.20,2.96,3.51,3,2,1,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,3,3,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,2,2,2,3,3,3,4,5,5,5,5,5,5,5,5,5,5,4,4,4,4,4,4,3,3,3,2,2,1,1,1,1,1,2,2,2,2,2,3,2,2,2,2,2,2,2,2,3,2,2,2,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,0,0,0,0,0,0,-2.24,-4.83,-7.09,-7.63,-6.47,-4.21,-1.88,-0.55,-0.25,-0.03,0.09,0.12,0.12,0.08,0.01,0,0,0,0,0,0,0,0,0,0,0,0,0.10,0.20,0.37,0.28,0.02,-0.11,-0.24,-1.29,-2.87,-3.80,-4.63,-5.28,-5.63,-5.50,-4.85,-3.67,-2.15,-0.40,0.28,1.17,2.76,4.72,6.82,8.85,10.62,12.12,13.42,14.62,15.62,16.27,16.28,15.54,14.08,12.23,10.25,8.42,6.75,5.45,4.40,3.70,3.61,3.51,4.40,5.26,6.89,7,7,7,6,5,4,3,3,2,2,2,3,3,3,4,4,3,4,4,5,6,6,6,6,4,3,3,3,4,4,5,7,7,6,5,3,3,3,4,4,4,2,1.10,1,0.70,0.48,0.29,0.15,0.02,-0.16,-1.35,-3.99,-5.55,-5.35,-3.52,-1.71,-0.38,-0.08,0.12,0.21,0.32,0.37,0.39,0.37,-0.02,-0.46,-0.74,-0.60,-0.18,0.13,0.33,0.27,0.22,0.50,1.14,2.01,2.76,3.08,3,2,1,1,1,1,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,3,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,2,2,2,3,3,3,4,5,5,5,5,5,6,5,6,5,5,4,4,4,4,4,4,3,3,3,2,2,2,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,2,2,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,0,0,0,0,1,-0.22,-1.51,-2.86,-3.50,-2.88,-1.58,-0.75,-0.38,-0.13,0.02,0.12,0.13,0.22,0.03,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.16,0.11,0.03,-0.03,-0.17,-1.75,-2.83,-3.98,-5,-5.79,-6.13,-5.65,-4.38,-2.52,-0.38,0.25,0.97,2.21,4.13,6.11,8.08,9.92,11.63,13.21,14.62,15.87,16.78,17.49,16.53,15.12,13.22,11.28,9.50,7.92,6.59,5.35,4.47,3.57,3.48,4.20,5.20,6.08,7,7,8,6,6,4,3,2,2,2,2,2,2,3,3,3,3,4,4,5,6,5,5,4,4,3,3,3,4,4,6,7,7,6,5,4,3,4,5,5,4,3,1.99,1.20,0.87,0.52,0.28,0.13,0,-0.65,-2.21,-4.38,-7.58,-6.35,-4.65,-2.83,-1.21,-0.14,0.07,0.20,0.28,0.41,0.46,0.58,0.28,0.08,-0.10,0.01,0.26,0.32,0.32,0.15,0.12,0.40,1.04,1.92,2.73,3.15,3,2,2,1,1,1,1,0,0,0,0,1,1,2,2,2,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,2,2,2,2,3,3,3,4,4,5,5,5,6,6,5,5,5,5,4,4,4,4,4,4,3,3,3,2,2,2,2,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,0,0,0,1,-0.40,-0.47,-1.04,-1.49,-1.36,-0.89,-0.46,-0.13,0.04,0.13,0.14,0.24,0.03,1,2,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0.01,0.01,0.09,0.10,0.08,0,-0.13,-1.80,-3.01,-4.33,-5.68,-6.71,-6.77,-5.47,-3.21,-0.46,0.15,0.75,1.84,3.57,5.37,7.25,9.15,11.03,12.84,14.50,16.02,17.34,17.97,18.37,16.07,14.17,12.34,10.63,9.10,7.73,6.42,5.34,4.41,3.39,4.25,5.02,6.02,7,7,8,6,5,4,3,2,2,2,2,2,2,2,2,3,3,3,4,5,5,4,3,3,2,2,2,3,4,4,6,7,7,6,5,4,4,5,5,6,4,3,2.87,1.86,1.11,0.62,0.25,0.12,-0.01,-0.99,-2.63,-4.75,-6.54,-7.05,-5.62,-3.53,-1.74,-0.23,0.01,0.16,0.28,0.33,0.39,0.46,0.26,0.24,0.23,0.33,0.38,0.26,0.15,0.07,0.09,0.37,0.91,1.83,2.75,4,4,3,3,2,2,1,1,1,0,0,0,0,1,2,2,2,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,2,2,2,2,3,3,4,4,4,4,5,5,6,5,5,5,5,5,4,4,4,4,4,4,3,3,3,2,2,2,2,2,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,1,1,1,0,0,0,1,1,0.67,-0.87,-1.18,-0.88,-0.36,0.04,0.12,0.10,0.11,0.21,0,1,2,3,3,2,3,3,2,2,1,1,0,0,0,0,0,0,0,0,0.07,0.11,0.12,0.10,0.02,-0.58,-1.89,-3.24,-5.13,-7.90,-8.88,-7.73,-3.79,-0.62,-0.02,0.53,1.63,2.96,4.54,6.35,8.27,10.28,12.27,14.22,16.02,17.63,19.27,18.29,16.75,14.99,13.32,11.73,10.25,8.87,7.57,6.34,5.23,4.37,4.20,5,6,8,7,6,5,4,3,3,2,2,2,1,1,1,1,2,2,3,3,4,5,5,4,3,2,2,2,2,2,3,4,5,6,6,5,5,5,5,6,6,5,4,4,2.99,2.21,1.74,0.34,0.20,0.12,0,-1.25,-2.99,-4.80,-6.36,-6.89,-5.87,-3.89,-2.01,-0.37,-0.10,0.15,0.26,0.39,0.62,0.36,0.25,0.32,0.29,0.25,0.16,0.09,0.03,0,0.04,0.25,0.70,1.35,2.98,4,5,4,4,3,2,2,1,1,0,0,0,0,1,2,2,2,1,1,1,1,1,1,1,2,2,2,2,2,1,2,2,2,2,2,2,2,2,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,2,2,2,2,2,3,3,4,4,4,4,4,5,5,5,5,5,5,4,4,4,4,4,4,4,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,-1,-1,-1,-1,1,1,0,0,0,0,1,2,3,4,3,3,2,2,2,2,2,1,1,1,0,0,0,0,0,0,0.07,0.12,0.14,0.14,0.11,0,-0.59,-1.08,-3.13,-6.77,-8.38,-7.22,-3.28,-0.72,-0.23,0.29,1.23,2.28,3.61,5.27,7.25,9.38,11.54,13.66,15.76,17.63,19.36,18.37,16.97,15.54,14.12,12.73,11.36,10.03,8.71,7.34,6,5.08,4.11,5,6,7,7,5,4,3,3,3,2,2,1,1,1,1,1,1,2,3,3,4,5,5,5,3,2,2,2,2,2,2,3,4,5,5,5,5,5,6,6,7,5,4,4,3.87,2.20,1.17,0.29,0.15,0.12,0.02,-1.48,-3.23,-4.97,-6.30,-6.65,-5.63,-4.05,-2.21,-0.59,-0.25,0.01,0.28,0.37,0.22,0.17,0.07,0.07,0.08,0.07,0.02,0,0,0,0.01,0.12,0.29,1.01,2,4,6,6,5,4,3,2,1,1,0,0,0,0,1,2,2,2,1,1,1,1,1,1,1,1,1,2,2,1,1,1,2,2,2,2,2,3,2,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,2,2,2,2,2,3,3,4,4,4,4,4,4,4,5,5,5,4,4,4,4,4,4,4,4,3,3,3,3,3,2,2,2,2,2,2,3,3,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,0,1,1,1,1,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,2,3,4,4,4,2,2,2,2,2,2,2,2,1,1,1,0,0,0,0,0.13,0.22,0.23,0.21,0.16,0.11,-0.02,-0.17,-1.10,-3.77,-5.13,-4.13,-1.62,-0.66,-0.38,0.09,0.79,1.58,2.50,3.95,6.12,8.37,10.62,12.83,15,17.62,18.50,17.72,16.87,15.87,14.78,13.62,12.37,11.08,10.08,8.12,6.63,5.22,5.01,5,6,7,6,5,4,3,3,2,2,1,1,1,1,1,1,1,2,3,3,4,5,6,5,4,2,2,2,2,2,2,3,4,5,6,6,6,6,7,7,6,5,4,4,3.10,2.12,1.07,0.27,0.15,0.13,0.02,-1.65,-3.49,-5.23,-6.41,-6.58,-5.83,-4.38,-2.66,-0.86,-0.48,-0.13,0.20,0.33,0.17,0.03,0.01,0,0,0,0,0,0,0,0,0,0,1,2,4,5,6,5,4,3,2,1,1,0,0,0,0,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,2,2,2,2,3,4,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,2,2,2,2,2,2,2,1,2,2,2,0,0,0,0,0,0,0,0,0,1,2,3,4,5,4,4,3,2,2,2,2,2,3,3,2,2,2,1,0,0,0,0.39,0.40,0.36,0.27,0.24,0.22,0.12,-0.08,-0.25,-1.13,-1.79,-1.29,-0.55,-0.58,-0.49,-0.05,0.39,1,1.38,2.82,5.11,7.29,9.51,11.70,13.82,15.54,16.75,16.83,16.51,16,15.32,14.42,13.35,12.07,10.52,8.38,7.14,5.90,5.10,5,6,7,6,5,4,3,3,2,1,1,1,1,1,1,1,1,2,3,3,4,5,6,6,5,3,2,2,2,2,2,3,4,5,5,6,6,6,7,7,5,4,4,4,3,1.99,1.02,0.25,0.16,0.11,-0.08,-1.83,-3.75,-5.62,-6.85,-7.05,-6.43,-5.21,-3.61,-1.79,-0.75,-0.27,0.08,0.23,0.21,0.09,0,0,0,0,0,0,0,0,0,0,0,1,2,3,5,6,5,4,3,3,2,1,0,0,0,0,1,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,2,2,2,2,3,3,3,3,3,3,3,4,4,4,4,4,4,4,5,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,0,0,0,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,1,2,3,3,4,5,6,4,3,3,3,2,2,3,3,3,3,3,3,2,1,1,1,0.82,0.65,0.51,0.37,0.32,0.33,0.26,0.11,-0.14,-0.33,-0.26,-0.25,-0.35,-0.47,-0.52,-0.08,0.20,0.71,1.25,2.46,4.15,6.24,8.35,10.40,12.32,13.92,15.09,15.75,16,16,15.77,15.27,14.40,13.09,11.37,9.70,7.25,6.16,5.12,5,6,8,7,6,5,4,3,2,1,1,1,1,1,1,1,1,2,2,3,3,4,6,6,4,3,2,2,1,2,2,3,4,5,6,6,6,6,7,6,4,3,3,4,2.98,1.88,0.89,0.23,0.15,0.01,-0.25,-1.65,-4.12,-6.22,-7.64,-8.11,-7.63,-6.48,-4.89,-3.13,-1.61,-0.42,-0.08,0.13,0.24,0.12,0,0,0,0,0,0,0,0,0,0,0,1,2,3,4,6,5,4,3,2,2,1,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,2,2,2,2,2,2,2,3,3,3,3,3,3,4,4,4,4,5,5,4,4,4,4,4,4,3,3,3,4,3,3,4,3,3,3,3,3,2,2,2,2,2,1,1,1,1,2,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,2,2,2,2,1,2,2,3,2,0,0,0,0,0,0,1,1,2,3,4,4,5,6,7,5,4,3,3,3,3,3,4,4,5,4,3,3,2,2,2,1,0.89,0.62,0.42,0.34,0.37,0.41,0.23,0,-0.12,-0.15,-0.13,-0.17,-0.21,-0.16,-0.13,0.41,0.60,0.96,1.45,3.35,5.22,7.16,9.09,10.87,12.45,13.73,14.71,15.40,15.87,16.14,16.34,15.41,14.14,12.37,10.32,8.26,6.20,5.12,6,7,8,8,7,6,4,3,2,1,1,1,1,1,1,1,1,1,2,2,3,4,5,5,4,3,2,2,1,1,2,3,3,4,6,7,6,6,6,5,3,2,3,3,3,1.04,0.87,0.17,0.10,-0.11,-0.43,-1.80,-4.35,-7.49,-9.33,-9.75,-9.47,-8.23,-6.37,-4.38,-2.54,-0.98,-0.16,0.10,0.24,0.25,0,0,1,1,0,0,0,0,0,0,0,1,2,3,4,5,4,4,3,2,1,1,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,2,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,2,2,2,2,2,2,2,3,3,3,3,3,3,4,4,4,5,5,5,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,1,1,1,1,1,1,2,1,1,1,1,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,3,2,0,0,0,0,0,1,2,2,3,4,5,5,6,6,6,6,5,4,4,4,4,4,4,5,5,5,4,4,3,2,2,1,0.98,0.71,0.47,0.29,0.32,0.33,0.28,0.16,0.12,0.09,0.10,0.08,0.09,0.25,0.46,0.76,0.39,0.60,1.15,2.48,4.29,6.08,7.85,9.53,11.11,12.50,13.74,14.78,15.66,16.45,16.87,16.92,15.38,13.49,11.27,9.20,7.20,6.12,6,7,9,9,8,6,4,3,2,1,1,1,1,1,1,1,1,1,1,2,2,3,4,4,4,4,2,2,1,1,2,2,3,4,5,6,6,6,5,4,2,2,2,3,2,1,0.07,0.12,0.08,-0.22,-0.59,-1.33,-4.73,-7.80,-9.41,-10,-10,-9.49,-7.62,-5.47,-3.36,-1.61,-0.25,0,0.23,0.42,0.65,0.96,1.15,0.98,0.22,0.01,0,0,0,0,0,1,2,3,4,5,4,3,2,2,1,1,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,2,2,2,2,2,2,2,3,3,3,3,3,3,4,4,4,4,5,5,5,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,3,3,0,0,0,0,0,1,3,4,4,6,6,7,7,7,6,6,6,5,5,5,5,5,5,5,5,6,5,4,3,2,1,1,1,0.98,0.37,0.17,0.17,0.21,0.21,0.22,0.22,0.21,0.23,0.24,0.25,0.26,0.13,0.20,0.24,0.38,0.88,2.04,3.52,5.13,6.75,8.37,9.99,11.47,12.86,14.15,15.40,16.59,17.77,18,17.32,14.62,12.29,10.25,8.79,7.12,6,6,7,8,8,6,4,3,2,2,1,1,1,1,1,1,1,1,1,2,2,3,3,3,3,3,2,1,1,1,1,2,3,3,4,4,5,6,4,3,2,1,2,2,2,1,0,0.04,0.13,-0.27,-0.64,-0.86,-3.79,-7.58,-9.39,-10,-10,-9.88,-8.36,-6.36,-4.28,-2.26,-0.38,-0.05,0.24,0.59,1,1.46,1.66,1.50,1,0.37,0.09,0,0,0,0,1,2,2,3,4,4,3,2,1,1,1,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,2,2,2,2,2,3,3,3,3,3,3,3,4,4,4,5,4,4,4,4,4,5,4,5,5,5,4,4,3,3,3,3,3,3,3,3,3,3,3,2,2,2,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,2,2,3,3,0,0,0,0,0.01,1.07,2.99,4.87,6.87,6.87,7.87,7.10,6.92,6.01,6,7,7,6,6,6,6,5,5,6,6,6,6,5,4,2,1,1,1,1,0,0.03,0.08,0.09,0.11,0.12,0.12,0.12,0.10,0.08,0.03,0,0.03,0.02,0.07,0.35,0.67,1.83,3.14,4.37,5.57,7.59,9.10,10.59,12.03,13.59,14.99,16.75,17.91,18.15,17.45,15.20,13.71,11.85,10.10,8.10,7,6,5,6,7,5,3,3,2,2,2,1,1,1,1,1,1,1,1,2,2,3,3,3,3,3,2,1,1,1,1,2,2,2,3,3,4,4,4,2,1,1,1,1,1,0,0,0,0.29,-0.33,-0.86,-1,-3.88,-6.96,-8.89,-10,-10,-9.97,-8.83,-7.12,-5.12,-3.05,-1.05,-0.16,0.17,0.58,1.04,1.59,1.99,2.07,1.67,1.09,0.45,0.09,0,0,0,1,1,2,3,3,3,2,1,1,1,1,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,2,2,2,2,3,3,3,3,4,4,4,3,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,4,3,3,3,3,3,3,3,3,3,3,3,2,2,2,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,1,1,1,1,2,2,3,3,0,0,0,0.95,0.11,1.13,3,5.79,6.79,7.79,7.79,7.83,7,6.11,6.04,7,8,8,7,7,6,6,6,6.97,7,6.95,6.07,5.92,3.96,2.02,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.02,0.29,1.11,2,2.90,4.17,5.57,7.11,8.58,9.40,11.45,12.96,14.77,15.03,15.50,15.73,15.61,15.70,13.84,13.78,11.85,9.08,7,6,4,5,5,4,3,3,3,2,2,2,1,1,1,1,1,2,2,2,3,3,3,3,3,3,2,2,1,1,1,1,2,2,2,3,3,3,2,2,1,1,1,1,0,0,0,0,0.42,-0.38,-0.89,-1.68,-3.76,-6.22,-8.05,-9.50,-10,-10,-9.29,-7.80,-5.96,-3.93,-2.09,-0.39,0,0.40,0.86,1.37,1.84,2.13,2.11,1.70,1.07,0.39,0.07,0,0,0,1,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,2,2,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,5,5,6,6,5,4,4,3,3,3,3,3,3,3,4,3,3,2,2,2,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,1,1,1,2,3,3,3,0,0,0.07,0.12,0.83,1.21,2.88,4.25,5.73,6.26,7.75,7.21,7.78,7,7,7.92,8,8,7,7,6.99,7.02,7.95,8.08,8.10,7.89,6.89,5.10,4.01,2.08,1.04,1.02,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0.02,0.25,1.25,2.49,3.23,4.25,5.50,7.01,8.82,9.87,11.11,12.29,13.03,13.26,13.17,13.22,13.66,13.26,13.76,12.83,12.88,9.97,8,6,5,4,4,4,4,4,3,3,2,1,1,1,1,1,1,2,2,2,2,3,3,3,4,3,2,2,1,1,1,2,1,2,2,2,2,2,2,1,1,0,0,0,0,0,0,0,0.59,-0.14,-0.63,-0.78,-3.08,-4.91,-7.25,-9.25,-10,-10,-9.83,-8.48,-6.75,-4.83,-2.92,-1.24,-0.34,-0.01,0.40,0.86,1.39,1.84,2.11,1.97,1.45,0.76,0.25,0,0,0,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,2,2,3,3,3,4,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,5,5,6,6,5,5,4,3,3,3,3,3,3,3,4,3,3,2,2,2,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,2,3,3,3,0,0,0,0.17,0.90,1.98,2.89,3.32,4.32,5.32,5.32,6.72,7.22,7.76,7.17,7.12,7.04,8,7,7,7.03,7.91,9.89,10.88,9.87,9.09,7.98,6.12,4.12,3.11,2.09,2.08,1.96,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0.01,0.17,1.25,2.66,3.57,4.04,5.25,6.86,8.53,10.04,11,11.73,12.04,11.72,10.42,10.32,10.96,11.23,11.82,11.87,11.95,10,8,7,6,5,4,5,5,5,5,3,2,1,1,1,1,1,1,1,1,2,2,3,3,3,3,3,2,2,2,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0.82,0.36,-0.36,-0.52,-1.86,-3.97,-6.28,-9.25,-10,-10,-10,-9.05,-7.43,-5.63,-3.80,-2.17,-0.79,-0.58,-0.21,0.32,0.86,1.33,1.73,1.85,1.62,1.04,0.47,0.07,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,2,2,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,5,5,6,6,6,5,4,4,3,3,3,3,3,3,3,3,3,2,2,2,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,2,3,3,3,0,0,0,0.23,1.12,2.32,3.66,4.35,4.78,4.36,5.35,6.16,7.23,7.76,7.87,7.16,7.11,7.01,7,7,7.08,8,9.12,11.86,11.13,10.84,9.84,7.85,5.91,4.12,3.87,3.10,3,2.96,2,2,2,2,1,0,0,0,0,0,0,0,0,0,0,0.12,1.12,2.75,2.89,3.36,4.48,6.53,8.58,10.39,10.87,11.46,11.51,10.62,9.26,8.24,9.15,9.16,9.12,9.91,10,10,10,8,7,6,6,6,6,6,5,4,2,1,1,1,1,1,1,0,1,2,3,3,3,3,4,3,2,2,2,1,2,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0.62,-0.25,-0.23,-0.75,-3.04,-4.43,-9.30,-10,-11,-10,-9.39,-8,-6.36,-4.63,-3,-1.76,-1.05,-0.75,-0.15,0.47,0.92,1.27,1.53,1.57,1.26,0.90,0.89,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,2,2,2,3,3,4,3,3,3,3,3,3,4,4,4,4,4,4,5,5,5,5,5,5,5,6,6,7,5,4,4,3,3,3,3,3,3,3,3,3,2,2,2,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,2,2,3,3,0,0,0,0.26,1.25,2.77,4.63,5.62,5.96,5.99,5.37,6.28,7.25,8.67,8.73,8.21,7.13,7.07,7,7.01,7.10,7.12,9.13,11.84,12.84,11.84,11.82,9.16,7.16,6.14,5.13,4.12,4.89,3.92,3,3,4,4,2,1,0,0,0,0,0,0,0,0,0,0.07,0.87,1.21,2.25,3.25,4.35,6.40,9.52,10.50,10.63,10.41,10.65,9.77,7.20,8.04,8.14,8.11,8.04,8,8,9,9,10,8,7,7,7,8,7,6,4,3,2,1,1,1,1,0,1,1,2,2,3,3,3,4,3,2,2,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.98,0.59,0.25,-0.24,-1.02,-3.66,-7.79,-11,-10,-10,-9.68,-8.60,-7.09,-5.40,-3.67,-2.23,-1.33,-0.92,-0.35,0.20,0.62,0.92,1.29,1.53,1.46,1.23,1,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,2,2,3,3,3,3,3,3,3,3,3,3,4,5,4,4,4,5,5,5,5,5,5,5,5,6,7,7,5,4,4,3,3,3,3,3,3,3,3,3,3,2,2,2,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,2,2,2,3,0,0,0.01,0.27,1.33,3,4.96,6.61,7.59,7.59,7,6.37,7.36,8.66,9.72,9.75,8,7.11,7,7.03,7.14,7.66,9.15,11.12,12.12,13.16,12.27,10.50,9.16,8.03,6.97,5.99,5,4.08,3.03,3,5,4,3,2,1,0,0,0,0,0,0,0,0,0.02,0.08,1.14,2.11,3.12,4.25,6.78,9.72,11.70,10.27,9.24,9.07,8.12,7.14,7.10,8.91,7.97,7,6,7,7,8,9,10,8,7,8,9,8,7,5,3,2,1,1,1,1,1,1,1,2,2,3,4,3,3,4,2,1,1,1,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.01,0.62,0.29,-0.29,-1.16,-5.40,-7.88,-9.37,-9.66,-9.71,-8.88,-7.76,-6.28,-4.62,-2.96,-1.65,-0.76,-0.30,0.12,0.41,0.73,1.14,1.53,1.62,1.40,1.12,1,2,3,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,2,2,2,3,3,3,3,3,3,3,3,3,4,4,4,5,5,5,5,5,5,5,5,6,5,6,6,7,7,5,4,4,3,3,3,3,3,3,2,3,3,3,3,2,2,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,2,2,2,2,0,0,0.01,0.32,1.35,3.01,5.17,7.59,9.58,9.58,7.98,7.39,8,8.97,9.71,9.75,8.20,7.15,7.09,7.10,7.23,7.78,8.78,9.98,11.21,11.92,11.92,11.28,10.46,10.48,8.79,7.14,5.88,4.10,3.07,4,5,5,4,3,2,1,0,0,0,0,0,0,0,0.04,0.09,1.11,2.12,3.02,4.14,6.14,9.85,11.85,10.98,9.12,8.11,7.09,6.04,7.01,8,8,6,5,6,6,7,9,9,9,8,8,9,9,8,6,4,3,2,1,1,1,2,1,1,1,2,3,3,3,3,3,2,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.07,0.70,0.42,-0.58,-1.65,-5.39,-7.52,-8.80,-9.27,-9.13,-8.47,-7.28,-5.71,-3.93,-2.26,-0.85,-0.17,0.11,0.35,0.65,1.12,1.59,1.78,1.71,1.12,1,2,2,3,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,2,2,2,2,2,2,2,3,3,3,3,4,4,4,5,5,5,6,6,6,5,5,5,5,6,6,7,8,7,5,4,4,3,3,3,3,3,2,2,3,3,3,3,3,2,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,2,2,2,1,0,0,0.01,0.32,1.26,2.83,4.99,7.58,9.58,9.58,8.29,7.88,8.37,9.63,9.82,9.73,8.22,7.54,7.26,7.22,7.26,7.62,8.24,9.07,9.95,10.67,11.13,11.33,11.20,10.58,9.42,8.11,6.86,5.88,4.08,4.01,5,6,5,4,3,2,1,0,0,0,0,0,0.04,0.09,1,1.87,2.14,3.14,4.16,6.16,9.16,12.83,11.84,10.86,9.87,8.88,7.09,6.04,6.99,7,7,5,5,6,7,9,10,9,9,9,9,10,9,6,5,4,3,2,1,2,2,1,1,1,2,2,3,3,3,2,2,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0.10,0.15,0.79,-0.72,-0.93,-3.16,-5.79,-7.83,-8.91,-9.60,-9.50,-8.54,-7,-5.02,-2.98,-1.36,-0.13,0.11,0.36,0.71,1.17,1.74,2.22,2.29,2.11,2,2,2,3,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,2,2,2,2,2,2,2,3,3,3,4,4,5,5,5,5,6,6,7,6,6,6,6,6,6,7,7,7,6,5,5,4,3,3,3,3,2,2,2,3,3,3,3,3,2,2,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,0,0,0.01,0.32,1.15,2.37,4.40,6.58,8.58,8.58,7.75,7.40,8.62,9.63,9.78,9.73,8.83,8.10,7.65,7.39,7.35,7.46,7.71,8.16,8.87,9.72,10.41,10.91,11.25,10.96,9.91,8.58,7.86,5.12,5.08,5.97,7,7,7,6,4,2,2,1,0,0,0,0,0.08,0.89,1.87,2.11,2.83,3.17,4.17,6.20,9,11.82,13.82,11.92,10.85,8.98,7.10,6.08,6,6,5,4,4,5,6,8,10,10,9,9,9,10,8,6,5,4,3,2,2,2,2,1,1,1,2,2,2,2,2,2,2,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0.01,0.20,0.75,0.64,-0.62,-1.47,-4.26,-6.75,-8.67,-10,-10,-9.87,-8.43,-6.50,-4.34,-2.18,-0.22,0.08,0.36,0.74,1.25,1.90,2.60,3.38,2.89,2,2,2,2,3,3,2,1,1.03,1.04,1.04,1.02,1.01,1.01,1.02,1.04,1.04,1.02,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,4,4,5,5,5,5,5,6,7,8,7,6,6,6,7,7,7,7,7,6,6,5,4,3,3,3,2,2,2,2,2,3,3,3,2,2,2,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0.01,0.32,1.03,2.34,3.78,5.40,6.58,7.58,6.40,6.39,7.37,8.64,9.67,9.57,8.88,8.48,8.12,7.77,7.50,7.40,7.41,7.61,8.11,8.97,9.88,10.60,10.99,10.87,9.92,8.77,7.33,6.87,6.08,7.02,8,9,8,7,5,4,3,2,0,0,0,0,0.09,0.99,1.85,2.15,3.17,4,5.02,6.21,8.21,11.78,13.79,12.82,10.84,9.10,7.87,6.09,5.03,5,4,4,4,4,6,7,9,10,9,9,9,8,7,6,5,4,3,2,2,2,2,2,1,1,2,2,1,2,2,2,2,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.02,0.14,0.40,0.27,-0.14,-0.59,-2.13,-5.63,-8.34,-10,-11,-11,-10,-8.08,-5.68,-3.25,-1.38,-0.10,0.26,0.67,1.24,1.97,2.86,3.52,3.92,3,3,3,3,3,3,2.09,1.87,1.49,1.39,1.29,1.24,1.20,1.20,1.22,1.25,1.25,1.17,1.10,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,2,2,2,2,2,3,3,3,4,4,5,5,5,5,5,6,7,8,8,7,7,7,7,7,8,8,8,7,6,6,5,5,4,3,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0.01,0.24,0.82,1.98,3.62,4.39,5.10,5.22,5.02,5.15,6.13,7.66,8.72,8.62,8.70,8.77,8.62,8.21,7.79,7.53,7.48,7.52,7.91,8.65,9.70,10.49,10.91,10.79,10.04,8.90,7.52,7.90,7.99,8.01,9,9,8,6,5,5,5,2,1,0,0,0.04,0.10,1.11,1.88,2.87,3.86,4.86,5.21,7,8.88,11.78,12.78,11.92,10.83,9.10,7.12,6.10,5.04,5,4,4,4,4,5,7,9,10,9,8,8,8,7,6,5,4,3,3,3,3,3,2,2,1,1,1,1,2,3,3,3,2,2,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.09,0.14,0.24,0.37,0.45,0.29,0.04,-0.33,-1.25,-3.84,-7.88,-10,-12,-12,-11,-9.65,-7.14,-4.48,-2.14,-0.65,0.04,0.50,1.10,1.82,2.75,3.74,4.98,4,4,4,4,3.99,3.82,3.16,2.59,2.14,1.82,1.61,1.47,1.39,1.38,1.41,1.47,1.50,1.70,1.21,1.12,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,2,2,2,2,3,3,3,3,4,5,5,6,6,6,6,7,7,8,8,7,7,7,7,7,8,8,8,7,6,6,5,5,5,3,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0.12,0.32,1.34,2.63,3.62,3.76,3.76,3.37,3.36,4.91,6.11,7.11,7.74,8.37,9.08,9.12,8.63,8.22,7.87,7.79,7.86,8.23,8.92,9.90,10.77,11.29,11.27,10.63,9.10,8.65,9.89,9.07,9.01,9,8,8,6,5,5,5,3,1,0,0,0.04,0.89,1.12,2.12,3.16,4.79,5.78,6.78,7.21,8.97,10.21,11.78,10.96,10.83,8.85,7.12,6.10,5.95,5,4,4,3,4,4,6,8,10,9,8,7,7,6,5,5,4,4,4,4,4,4,4,3,2,1,1,1,1,2,3,4,3,2,2,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.89,0.79,0.46,0.45,0.36,0.25,-0.01,-0.23,-0.91,-2.89,-7.24,-10,-12,-13,-12,-10,-8.48,-5.92,-3.52,-1.36,-0.25,0.24,0.83,1.54,2.40,3.92,5,5,4,5,5,5.11,4.70,4.08,3.39,2.78,2.32,1.98,1.75,1.64,1.62,1.64,1.67,1.72,1.65,1.65,1.21,1.10,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,2,2,2,2,3,3,3,3,3,4,5,6,6,7,7,7,8,8,8,8,7,7,7,7,7,8,8,8,7,6,6,5,5,4,3,2,2,2,2,2,2,2,2,2,2,2,2,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0.01,0.11,0,0.01,0.25,0.88,1.66,2.35,2.74,2.86,2.35,3.25,3.32,5,6,6.99,8.01,9.20,9.50,9.04,8.60,8.34,8.28,8.48,8.87,9.58,10.59,11.50,12.14,12.36,11.70,10.85,9.75,10.91,10.96,10.99,10,8,7,6,5,5,5,3,1,0,0,0.95,1.10,1.89,2.14,3.16,4.79,6.78,6.84,7.83,8.78,9.78,9.99,9.87,9.16,8.85,7.12,6.10,5.95,4,4,3,3,3,4,6,8,10,9,8,7,6,6,5,5,4,4,5,5,5,5,5,5,3,2,1,1,1,1,2,3,2,2,2,2,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.87,0.62,0.48,0.48,0.29,0.10,-0.15,-0.35,-0.76,-2.25,-6.38,-10,-12,-13,-12,-11,-9.50,-7.05,-4.66,-2.49,-0.59,-0.08,0.50,1.21,2.23,3.84,5,5,5,5,6.82,6.57,5.61,4.98,4.25,3.50,2.87,2.39,2.11,1.95,1.88,1.89,1.90,1.89,1.84,1.70,1.71,1.17,1.02,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,1,1,1,1,2,2,2,2,3,3,3,3,3,4,5,6,6,7,7,8,8,8,8,8,8,7,7,7,7,7,8,8,8,7,6,6,5,5,5,3,2,2,2,2,2,2,2,2,2,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0.04,0,0,0.12,0.26,0.88,1.32,1.87,2.29,2.76,3.27,3.88,4.23,5.15,6.20,7.58,8.92,9.48,9.26,8.76,8.63,8.75,9.09,9.65,10.50,11.50,12.52,13.41,13.72,13.08,12.15,11.73,11.92,12.98,11,10,8,6,6,5,5,4,3,2,1,1,1.95,2.10,2.87,3.14,4.12,5.01,5.21,6.78,7.78,8.78,9.21,9.21,8.89,8.16,7.85,7.11,6.10,5.04,4,3,3,3,3,4,5,8,10,9,7,6,6,6,5,4,4,5,6,6,6,6,7,6,4,2,1,1,1,1,1,2,2,1,1,2,3,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.72,0.38,0.27,0.34,0.25,0.02,-0.25,-0.46,-0.67,-1.64,-4.71,-9.54,-12,-13,-13,-12,-10,-8.01,-5.60,-3.25,-1.28,-0.35,0.15,0.77,1.67,2.79,3.86,4.98,4,5,5.74,6.35,6.40,5.86,5.08,4.23,3.47,2.87,2.50,2.27,2.20,2.15,2.13,2.10,2,1.85,1.59,1.25,1.03,1,1,2,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,2,2,2,3,3,4,4,4,4,4,5,6,7,7,8,9,8,8,8,8,8,7,7,7,7,8,8,8,8,7,6,6,5,5,4,3,3,3,3,3,3,4,3,2,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0.07,0,0,0.12,0.24,0.77,1.23,1.87,2.75,3.75,4.78,3.88,4.12,5.25,6.50,7.84,8.57,8.75,8.60,8.72,9.03,9.59,10.37,11.36,12.50,13.75,14.66,14.67,13.70,12.76,12.29,12.96,12.99,12,10,9,8,7,6,5,5,4,2,1,1,1.96,2.90,3.87,4.85,5,5.17,6.12,6.21,7.21,8.78,9.78,9.79,8.17,7.15,7.14,6.87,6.90,5.03,4,3,3,3,3,4,5,7,9,8,8,6,6,5,5,4,4,5,5,6,6,6,6,6,5,3,2,2,2,2,1,1,1,1,0,1,3,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.14,0.17,0.15,0.32,0.25,0.03,-0.29,-0.48,-0.73,-1.09,-3.68,-8.96,-11,-12,-12,-12,-10,-8.59,-6.30,-4.10,-2,-0.53,-0.25,0.29,1.13,2.03,2.90,3.66,3.98,4.22,5.25,6.25,6.89,6.66,5.77,4.91,4.09,3.41,2.96,2.65,2.50,2.41,2.37,2.28,2.15,1.95,1.64,1.28,1.07,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,2,2,2,3,4,4,4,5,5,5,5,6,6,7,8,8,8,8,8,8,8,7,7,7,7,8,8,8,7,6,6,6,5,4,4,3,3,3,3,4,4,4,3,2,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0.04,0,0,0.12,0.20,0.79,1.20,2.09,2.83,3.13,3.11,3.04,4.35,5.32,6.15,6.89,7.49,7.96,8.47,9.08,9.85,10.87,12.11,13.41,14.74,15.39,14.98,13.72,12.60,12.02,11.99,11,11,10,9,9,9,7,6,5,4,3,1,1,2.02,3.08,4.89,5.12,5.98,6.83,6.87,7.12,7.20,8.20,9.17,9.82,8.83,7.89,7.12,6.10,5.91,4.97,4,3,3,3,3,3,4,6,7,8,8,7,5,5,4,4,4,4,5,5,5,6,6,6,6,5,3,3,3,3,2,1,1,1,0,1,1,2,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.02,0.04,0.13,0.27,0.35,0.14,-0.13,-0.40,-0.71,-2.61,-4.88,-9.04,-11,-12,-12,-12,-10,-9.09,-6.97,-4.80,-2.72,-0.75,-0.51,-0.03,0.64,1.38,2.08,2.62,3.02,3.37,4.79,6.07,6.79,6.86,6.36,5.60,4.75,4.01,3.45,3.07,2.83,2.67,2.58,2.47,2.28,2.03,1.71,1.33,1.07,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,0,1,1,1,1,2,2,2,2,3,4,4,5,5,6,5,5,6,6,7,8,9,9,8,8,8,7,7,7,7,7,8,7,7,6,6,6,5,5,4,4,3,3,3,3,4,4,4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,1,1,0,0,0,0,0.12,0.12,0.87,1.12,1.89,2.07,2.98,3,3.62,4.15,4.63,5.22,5.98,6.87,7.75,8.71,9.78,11.11,12.75,14.28,15.53,15.91,15.12,13.57,12.02,10.53,11,11,10,10,9,10,10,8,7,6,6,3,2,2,2,3.95,4.90,5.88,6.87,7.85,7.84,7.83,7.90,8.16,8.87,9.84,8.96,8.12,7.88,6.90,5.95,4,3,3,3,3,3,3,4,5,6,8,9,8,5,4,4,4,3,4,4,4,5,6,6,6,6,5,4,3,3,2,2,2,2,2,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.01,0.10,0.22,0.28,0.22,0,-0.28,-1.29,-4.15,-6.13,-8.12,-10,-11,-12,-11,-10,-9.34,-7.54,-5.61,-3.54,-1.04,-0.86,-0.47,0.14,0.82,1.41,1.92,2.37,3.24,4.26,5.49,6.59,7.03,6.87,6.26,5.48,4.67,4,3.49,3.13,2.90,2.75,2.59,2.37,2.10,1.74,1.33,1.08,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,2,2,2,2,3,4,4,4,5,5,5,5,6,6,7,8,8,8,8,8,8,8,7,7,6,7,7,7,6,6,5,5,5,5,4,4,4,4,4,4,4,4,4,3,3,2,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,1,1,2,2,3,3.20,3.53,3.72,3.99,4.64,5.67,6.77,8,9.36,10.92,12.73,14.27,15.46,15.74,14.87,13.34,11.75,10.38,10,11,10,9,9,9,9,9,8,7,6,4,3,2,3,3.98,4.95,5.09,6.11,7.12,7.85,8.08,8.85,8.14,8.85,8.85,8.87,8.88,7.90,6.95,5.98,4,3,3,3,3,3,3,4,5,6,8,9,8,5,4,4,3,3,3,3,4,4,5,5,6,5,5,5,4,3,3,3,3,3,3,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.07,0.15,0.29,0.34,0.15,-0.14,-2.02,-4.83,-6.63,-7.68,-10,-11,-12,-11,-10,-9.66,-8.16,-6.49,-4.66,-2.79,-1.35,-1,-0.46,0.22,0.87,1.42,1.96,2.66,3.65,4.92,6.26,7.49,7.38,6.95,6.24,5.40,4.60,3.92,3.46,3.12,2.87,2.66,2.42,2.12,1.74,1.33,1.08,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,2,2,2,2,2,3,3,3,4,4,4,5,5,6,6,6,7,8,8,8,8,8,8,8,6,6,6,7,7,6,5,5,5,6,5,4,4,4,5,4,4,4,4,4,3,4,2,2,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,2,2,2.82,3.38,3.21,3.25,3.66,4.48,5.75,7.09,8.53,10.12,11.90,13.45,14.52,14.77,14.10,12.91,11.73,10.82,10,9,10,10,9,8,9,10,9,7,6,5,3,3,3,4,4.99,5.95,6.09,7.10,7.87,8.11,8.12,8.11,8,7.98,7.98,7.90,6.98,5.99,5,4,3,3,3,3,3,3,4,5,6,8,9,8,5,4,3,3,3,3,3,3,4,4.10,4.38,4.34,4.24,4.02,4,3.87,3.75,3.87,4,4,4,4,3,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.01,0.03,0.09,0.15,0.24,0.25,0.21,-0.05,-1.92,-4.64,-6.38,-8.33,-10,-11,-12,-11,-11,-10,-8.85,-7.46,-5.98,-4.52,-2.77,-1.67,-1.11,-0.42,0.29,0.98,1.49,2.01,2.83,4.24,5.83,7.45,7.76,7.54,7,6.15,5.23,4.38,3.75,3.29,2.98,2.72,2.45,2.12,1.74,1.33,1.08,1,2,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,3,3,3,4,4,5,5,5,6,6,7,7,7,8,8,8,8,8,7,6,6,6,6,6,5,5,5,5,5,5,4,4,4,4,4,4,4,4,3,3,3,3,2,2,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,2,2,2.75,2.86,2.76,3.03,3.63,4.82,6.10,7.49,8.98,10.50,11.90,12.95,13.33,12.95,12.26,11.65,11,9,8,9,10,9,8,8,9,10,8,7,5,4,3,3,4,5,6.98,7.95,8.08,8.09,8.10,8,7.89,7.10,7.09,7,6.95,5.99,5,4,3,3,3,3,3,3,3,3,4,6,7,9,8,5,4,3,3,4,4,4,3.97,3.34,3.66,3.67,3.60,3.49,3.38,3.47,3.58,3.77,4.33,5.40,5.09,4.97,4,3,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.04,0.09,0.12,0.14,0.21,0.25,0.26,0.15,-0.08,-1.01,-3.71,-6.47,-10,-12,-12,-12,-12,-11,-10,-9.64,-8.49,-7.26,-6.11,-5.24,-3.41,-2.04,-1.09,-0.28,0.50,1.09,1.47,1.86,3.48,5,6.47,7.64,8.22,7.75,6.83,5.78,4.79,4,3.45,3.03,2.73,2.42,2.13,1.79,1.28,1.14,1,1,1,2,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,2,2,2,2,3,3,4,4,4,5,6,5,6,6,7,7,7,8,7,7,7,7,7,7,6,6,5,5,5,5,4,4,5,5,4,4,4,4,4,3,3,3,3,3,3,4,3,2,2,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.11,0.11,0.12,0.12,0.11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,2,2.98,2.32,2.36,2.52,3,3.98,5.12,6.37,7.74,9.16,10.59,11.67,12.15,12.03,11.38,10.98,10,8,7,8,8,9,8,7,9,9,8,7,6,5,4,4,5,6,7,7.99,9.97,9.96,8.95,8.04,7.04,7,6.03,6.02,5.99,5,4,4,3,3,3,3,3,3,3,3,4,5,7,8,7,5,4,3,4,5,6,5.02,4.38,3.88,3.57,3.47,3.28,3.20,3.10,3.17,3.28,3.62,4.47,5.41,6.33,5.38,4.97,4,3,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.15,0.26,0.23,0.22,0.25,0.28,0.26,0.13,-0.09,-0.33,-2.42,-6.67,-10,-13,-13,-12,-12,-12,-11,-10,-9.58,-8.52,-7.52,-6.98,-5.30,-3.61,-2.17,-0.88,-0.03,0.63,0.95,1.62,2.64,3.98,5.39,6.96,8.32,8.22,7.34,6.12,5.07,4.17,3.51,3.03,2.67,2.39,2.12,1.87,1.75,1.12,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,2,2,2,3,3,3,4,4,4,5,5,5,6,6,7,7,7,8,7,7,7,7,6,6,6,5,5,5,5,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,3,2,2,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.13,0.86,0.86,0.86,0.13,0.12,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1.98,1.92,2.16,2.51,3.20,4.12,5.33,6.58,7.91,9.24,10.53,11.38,11.65,11,10,9,8,7,7,7,7,7,7,8,8,8,8,7,6,6,5,6,6,7,8,9,10,9,8,8,7,6,6,5,5,4,4,3,3,3,3,3,3,3,3,4,5,6,6,6,5,4,3,4,5,7,6.65,5.45,4.47,3.84,3.51,3.40,3.28,3.26,3.20,3.21,3.35,4.14,5.29,6.03,5.62,4.99,5,3,2,2,1,0,0,0,0,0,0,0,0,0,0,0.02,0.09,0.20,0.32,0.27,0.16,0.02,0.04,0.12,0.16,0.24,0.12,-0.11,-0.36,-1.71,-5.73,-9.84,-12,-13,-13,-13,-12,-12,-11,-10,-9.84,-8.78,-7.52,-6.22,-4.83,-3.68,-2.17,-0.90,-0.03,0.28,0.96,1.76,2.77,4.07,5.51,7.45,8.34,7.25,6.04,5.09,4.22,3.51,2.98,2.59,2.29,2.09,1.95,1.85,1.96,1,1,1,1,1,2,2,2,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,2,2,3,3,3,3,3,3,3,4,5,5,5,6,6,6,7,7,7,7,7,7,6,6,6,6,5,5,5,5,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,3,3,2,2,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.14,0.83,-0.84,0.83,0.83,0.14,0.12,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,2,1.90,2.16,2.52,3.32,4.32,5.34,6.58,7.84,9.25,10.82,12,11,9,7,7,6,6,7,6,6,7,7,8,9,9,8,7,7,6,6,6,7,8,9,9,9,9,8,7,7,6,5,5,5,4,4,3,3,3,3,3,3,3,3,4,6,5,5,5,4,3,4,5,5.98,7.40,6.20,5.23,4.49,4.15,4.03,3.96,3.96,3.86,3.74,3.54,3.95,4.66,5.27,5.21,4.87,4.82,3,2,2,1,0,0,0,0,0,0,0,0,0,0.02,0.10,0.21,0.34,0.35,0.16,-0.04,-0.18,-0.16,-0.09,0.02,0.09,0.09,-0.11,-0.38,-2.14,-5.53,-9.29,-12,-13,-14,-14,-13,-13,-12,-12,-11,-10,-8.39,-7.51,-6.25,-5.25,-4.26,-2.97,-1.62,-0.42,0.34,0.71,1.49,2.52,3.79,5.02,5.83,6.02,5.53,4.86,4.11,3.39,2.83,2.38,2.11,1.97,1.91,1.97,2,1,1,2,2,2,2,2,2,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,2,2,3,3,3,3,3,3,3,4,4,5,5,6,6,6,6,6,6,6,6,6,6,6,6,6,5,5,6,5,5,5,5,4,4,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.02,0.07,0.16,0.82,-0.83,-0.83,0.82,0.83,0.14,0,0,0,0,0,0,0,0,0,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,2,2,2,3,3,4,5,6,8,9,10,9,8,6,6,6,6,6,6,6,6,7,8,9,8,8,7,7,7,7,7,7,8,9,9,9,9,9,8,8,7,6,6,6,6,5,4,3,3,3,3,2,2,3,3,4,5,5,5,4,3,3,4,5.22,6.23,6.26,5.74,5.21,4.98,4.92,4.97,5.17,5.20,4.89,4.20,3.87,4.07,4.47,4.57,4.33,3.75,3,2,1,0,0,0,0,0,0,0,0,0,0,0.07,0.17,0.33,0.35,0.17,-0.02,-0.25,-0.39,-0.48,-0.37,-0.17,-0.04,-0.02,-0.11,-0.39,-2.09,-6.75,-10,-13,-15,-15,-15,-14,-14,-13,-13,-13,-12,-11,-11,-10,-8.79,-6.76,-5.34,-4.27,-2.24,-1.13,-0.50,0.21,1.02,2,3,3.99,4.58,4.76,4.42,3.83,3.14,2.54,2.09,1.77,1.63,1.87,2,2,1,2,2,2,2,2,2,2,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,2,2,2,3,3,3,3,3,3,3,4,4,4,5,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,5,5,5,5,4,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0.01,0.03,0.09,0.13,0.29,0.28,0.42,-0.64,-0.83,0.82,0.16,0,0,0,0,0,0,0,0,1,2,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,2,2,2,2,3,3,4,5,6,8,8,8,7,6,6,6,7,6,6,6,5,6,7,8,7,7,7,6,7,7,7,7,8,9,10,10,9,9,10,8,8,7,6,7,7,6,4,3,3,3,2,2,2,2,3,3,4,4,5,4,3,3,3,4.24,5.09,5.65,5.72,5.59,5.48,5.49,5.73,6.20,6.62,6.39,5.60,4.70,4.24,4.17,4.13,3.87,3.42,3,2,1,0,0,0,0,0,0,0,0,0,0.01,0.10,0.25,0.29,0.14,-0.23,-0.41,-0.62,-0.93,-1.34,-1.18,-0.63,-0.22,-0.15,-0.23,-1.04,-3.72,-8.59,-12,-15,-16,-16,-16,-16,-15,-15,-14,-14,-14,-14,-14,-13,-12,-10,-8.40,-6.30,-4.71,-2.60,-1.73,-0.92,-0.25,0.49,1.42,2.41,3.26,3.87,3.90,3.37,2.76,2.16,1.66,1.34,1.11,1,1,1,1,2,3,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,2,2,2,3,3,3,3,3,3,3,4,4,4,5,6,6,6,6,6,7,7,7,7,7,7,7,7,6,6,6,5,5,5,5,4,3,3,4,3,3,3,3,3,3,3,3,3,3,2,2,1,1,0,0,0,0,0,0,0,0,0,0,0,0.02,0.07,0.10,0.14,0.21,0.25,0.25,0.02,-0.35,-0.49,0.78,0.17,0,0,0,0,0,0,0,0,0,4,3,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,2,2,2,2,2,2,3,3,4,6,7,8,8,8,7,7,8,8,7,7,5,4,5,6,7,6,6,6,6,6,7,7,7,8,9,10,10,10,9,9,9,8,7,7,7,8,7,5,3,3,3,2,2,2,2,2,2,3,3,3,4,3,3,3,3.51,4.21,4.88,5.27,5.47,5.50,5.62,5.95,6.59,7.39,7.60,7.14,6.14,5.28,4.52,4.07,3.58,3.10,3,2,1,1,0,0,0,0,0,0,0,0,0.01,0.12,0.28,0.23,-0.14,-0.64,-0.88,-1.53,-2.58,-3.41,-3.22,-2.10,-1.47,-1.21,-2.15,-3.66,-6.89,-10,-14,-17,-18,-18,-17,-16,-16,-16,-16,-16,-16,-17,-16,-16,-15,-13,-11,-8.67,-6.26,-4.22,-2.50,-1.92,-1.30,-0.66,0.15,1.12,2.03,2.87,3.16,2.84,2.26,1.71,1.22,0.73,0.61,0.63,0.71,0.83,1.24,1.84,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,2,2,3,3,3,4,4,4,4,4,4,4,4,5,5,6,6,6,6,7,7,8,8,7,7,7,7,7,6,5,5,5,4,4,3,3,3,4,3,3,3,3,3,3,3,3,3,3,2,2,1,1,1,0,0,0,0,0,0,0,0,0,0.01,0.07,0.11,0.14,0.17,0.21,0.20,0.10,-0.13,-0.38,-0.14,0.42,0.21,0.03,0,0,0,0,0,0,0,0,6,5,2,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,2,3,3,3,3,3,3,3,4,6,7,9,9,9,8,8,7,6,6,6,4,4,4,5,5,5,5,5,5,5,6,7,7,7,9,9,9,9,8,8,8,8,7,7,7,8,7,5,4,3,3,2,2,2,2,2,2,2,2,3,3,4,3,3.03,3.23,3.73,4.49,5.07,5.36,5.48,5.58,5.88,6.54,7.37,8.02,8.10,7.59,6.66,5.58,4.48,3.58,2.87,2,2,2,2,1,0,0,0,0,0,0,0,0.02,0.13,0.28,0.12,-0.33,-0.92,-1.58,-3.66,-5.51,-6.16,-5.23,-4.47,-3.76,-3.72,-4.51,-6.38,-9.13,-12,-15,-17,-18,-18,-18,-17,-17,-16,-17,-17,-17,-17,-18,-17,-16,-15,-13,-10,-7.88,-5.49,-3.64,-2.58,-2.22,-1.60,-0.89,-0.03,0.87,1.66,2.25,2.12,1.71,1.21,0.62,0.38,0.34,0.32,0.40,0.62,1.12,1.62,1.95,1.98,1.99,2,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,2,2,3,3,3,4,4,4,5,5,4,4,4,5,5,6,6,6,6,6,7,8,9,8,7,7,6,6,5,5,5,4,4,3,3,3,3,3,3,2,2,3,3,3,3,3,3,3,3,2,2,1,1,1,0,0,0,0,0,0,0,0,0.02,0.09,0.13,0.15,0.14,0.12,0.08,-0.03,-0.18,-0.29,0,0.15,0.20,0.11,0.02,0,0,0,0,0,0,1,6,5,3,1,0,0,0,0,0,0,0,0,0,0,0,0,1,2,3,4,4,4,4,4,4,4,4,6,7,9,10,8,7,6,6,5,5,4,4,4,4,5,5,4,4,4,4,4,5,6,6,6,7,8,8,8,7,7,8,8,8,7,7,7,7,6,5,4,3,3,2,2,2,2,2,2,2,2,3,3,3.97,3.08,3.25,3.76,4.53,5.15,5.50,5.57,5.47,5.71,6.45,7.22,7.90,8.27,8.22,7.61,6.53,5.13,3.83,2.66,2,3,3,3,1,1,0,0,0,0,0,0.01,0.08,0.20,0.33,0.23,-0.25,-0.88,-2.78,-6.02,-7.63,-7.59,-7.37,-6.65,-6.30,-6.42,-7.18,-8.64,-10,-13,-15,-17,-17,-17,-17,-16,-16,-16,-16,-17,-17,-17,-18,-18,-17,-16,-14,-12,-9.23,-6.42,-4.33,-3.01,-2.64,-2.38,-1.88,-1.15,-0.29,0.60,1.22,1.40,1.17,0.78,0.40,0.22,0.16,0.10,0.11,0.45,1,1.57,1.87,1.83,1.92,1.01,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,2,2,2,3,3,3,4,5,5,5,5,5,4,4,5,5,6,6,6,6,6,7,8,8,8,8,7,6,6,5,5,5,4,3,3,3,3,3,3,2,2,2,3,3,3,3,3,3,3,3,2,2,2,1,1,1,0,0,0,0,0,0,0,0.03,0.11,0.14,0.13,0.08,-0.02,-0.11,-0.15,-0.15,-0.10,0.02,0.13,0.15,0.12,0.07,0.01,0,0,0,0,0,0,6,5,3,1,0,0,0,0,0,0,0,0,0,0,0,0,1,2,4,5,5,5,5,5,5,5,6,6,7,8,8,8,6,5,5,5,4,4,4,4,4,5,5,4,4,3,3,3,4,5,6,5,6,6,7,7,7,7,7,8,7,7,7,7,7,7,6,5,4,3,3,2,2,2,2,2,2,2,2,3,3.07,3.11,3.54,4.17,4.95,5.60,5.98,6.04,5.89,6.02,6.58,7.25,7.71,7.98,8.12,8.02,7.39,6.07,4.47,3.46,3,3,3,3,2,1,0,0,0,0,0,0.03,0.15,0.29,0.40,0.25,-0.15,-0.88,-4.27,-7,-8.76,-9.08,-9.14,-8.61,-8.40,-8.58,-9.13,-10,-11,-12,-14,-15,-15,-15,-14,-14,-13,-13,-14,-15,-16,-17,-17,-17,-17,-16,-14,-12,-10,-7.62,-4.77,-3.60,-2.85,-2.75,-2.43,-1.88,-1.16,-0.41,0.24,0.61,0.64,0.49,0.28,0.17,0.12,0.07,0.14,0.45,0.89,1.42,1.64,1.47,1.26,1.04,1.02,1,1,1,1,2,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,2,2,2,3,3,3,4,5,6,6,5,5,5,5,5,6,6,6,7,7,7,7,8,8,8,8,7,6,6,5,5,4,4,3,3,3,3,3,3,2,2,2,3,3,4,3,3,3,3,2,2,2,2,1,1,1,0,0,0,0,0,0,0,0.04,0.12,0.15,0.12,-0.02,-0.22,-0.33,-0.30,-0.23,-0.10,0.01,0.10,0.14,0.14,0.10,0.03,0,0,0,0,0,0,5,5,3,1,0,0,0,0,0,0,0,0,0,0,0,0,1,3,5,6,7,6,6,6,5,6,7,7,7,7,7,6,6,5,5,5,4,4,4,4,4,5,4,4,3,3,3,3,3,4,5,4,5,5,6,6,6,6,6,6,6,6,7,7,7,7,7,5,4,4,3,2,2,2,2,2,2,3,3,3.03,3.10,3.12,3.67,4.42,5.37,6.34,6.77,6.79,6.75,6.76,7.16,7.48,7.67,7.79,7.89,8.09,7.70,6.62,5,4.13,4,4,4,4,2,1,1,0,0,0,0,0.08,0.25,0.28,0.26,0.03,-0.12,-1.85,-5.33,-7.72,-9.59,-10,-10,-10,-9.99,-10,-10,-10,-10,-11,-11,-11,-12,-11,-11,-10,-10,-10,-11,-12,-14,-14,-15,-15,-15,-15,-14,-13,-10,-8.63,-6.16,-4.78,-3.60,-2.93,-2.75,-2.39,-1.85,-1.18,-0.55,-0.10,0.15,0.16,0.12,0.10,0.12,0.17,0.21,0.46,0.76,1.07,1.12,0.97,0.90,1.01,1.95,1.98,1,2,2,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,2,2,2,2,3,3,3,4,5,7,7,6,6,5,6,6,7,6,6,7,8,8,8,8,8,8,7,6,6,5,5,4,4,4,3,3,3,3,3,2,2,2,2,3,3,4,3,3,3,3,2,2,2,2,1,1,1,0,0,0,0,0,0,0,0.07,0.12,0.17,0.11,-0.11,-0.38,-0.54,-0.52,-0.42,-0.15,-0.16,-0.05,0.07,0.13,0.12,0.08,0.01,0,0,0,0,0.01,5,5,3,1,0,0,0,0,0,0,0,0,0,0,0,0,1,3,5,6,7,7,6,6,6,6,6,7,7,7,6,6,6,6,6,5,4,4,4,4,4,4,4,4,3,3,3,3,3,3,4,4,4,5,5,6,6,6,6,6,6,6,6,7,7,7,8,6,5,4,4,3,3,2,2,3,3,4,4,4.92,3.11,3.15,3.63,4.36,5.36,6.63,7.50,7.66,7.71,7.84,7.91,7.88,7.74,7.61,7.60,7.85,7.58,6.72,5.21,4.38,5,5,4,4,3,2,1,0,0,0,0.01,0.11,0.34,0.24,0.09,-0.17,-0.98,-3.54,-6.13,-8.25,-10,-10,-11,-10,-10,-10,-10,-10,-9.65,-8.79,-8.22,-6.74,-7.10,-7.63,-7.11,-6.12,-6.63,-7.89,-8.79,-9.55,-10,-11,-12,-13,-13,-13,-13,-12,-11,-9.54,-7.85,-5.91,-4.84,-3.63,-2.91,-2.73,-2.35,-1.84,-1.27,-0.78,-0.46,-0.28,-0.18,-0.11,0.01,0.29,0.27,0.42,0.62,0.72,0.63,0.47,0.50,0.79,1.09,1.96,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,3,3,3,4,6,6,6,6,6,6,7,8,7,6,6,7,8,8,8,8,8,7,7,7,5,5,4,4,4,4,3,3,3,3,2,2,2,2,2,3,4,4,3,3,3,3,2,2,2,2,1,1,1,0,0,0,0,0,0,0.01,0.08,0.15,0.20,0.13,-0.16,-0.52,-0.75,-0.83,-0.77,-0.66,-0.52,-0.38,-0.13,0.12,0.22,0.16,0.04,0,0,0,0,0.08,4,3,3,1,0,0,0,0,0,0,0,0,0,0,0,1,2,4,6,6,6,6,5,5,5,5,5,5,6,5,5,6,6,7,7,6,5,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,4,4,5,5,5,5,5,5,6,6,6,6,6,7,7,7,6,5,5,4,3,3,3,4,4,4,6,4.91,4.12,3.15,3.37,3.98,4.84,6.13,7.52,8.22,8.54,8.87,8.87,8.34,7.72,7.27,7.08,7.08,6.79,6.08,4.77,4.12,4,5,5,5,3,3,2,1,0,0,0.03,0.17,0.40,0.32,0.12,-0.42,-1.91,-4.51,-6.83,-8.62,-10,-10,-11,-11,-10,-10,-9.98,-9.13,-7.77,-6.42,-4.49,-4.25,-5.41,-4.63,-4.42,-5.38,-6.11,-6.23,-7.01,-6.75,-6.28,-8,-9.13,-10,-10,-11,-11,-11,-11,-10,-9.16,-7.75,-6.03,-4.88,-3.42,-2.88,-2.66,-2.34,-1.91,-1.50,-1.18,-0.97,-0.79,-0.63,-0.39,-0.02,0.11,0.28,0.49,0.48,0.37,0.21,0.25,0.51,0.89,1.08,1.02,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,3,3,4,5,6,7,7,7,7,7,8,7,7,6,6,7,7,8,8,8,7,7,7,6,5,4,4,3,3,3,3,3,2,2,2,2,2,2,2,3,4,4,4,3,3,3,2,2,2,1,1,1,1,0,0,0,0,0.01,0.04,0.10,0.13,0.21,0.22,0.12,-0.23,-0.62,-0.93,-1.13,-1.22,-1.21,-1.08,-0.84,-0.48,-0.05,0.25,0.33,0.17,0.04,0,0,0.02,0.36,3,2,2,1,1,0,0,0,0,0,0,0,0,0,0,1,2,4,5,6,5,5,4,4,4,4,4,5,5,5,5,6,8,7,7,5,5,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,4,4,5,5,5,5,5,5,5,5,5,6,6,7,8,7,6,5,5,4,3,4,4,5,5,5,5.91,5,4.16,3.98,2.57,3.92,5.54,7,8.22,9.10,9.52,9.32,8.42,7.46,6.78,6.36,6.10,5.83,5.32,4.34,3,3,4,4,5,4,3,3,2,1,0,0.04,0.25,0.28,0.12,-0.17,-1.03,-3.13,-5.41,-7.38,-8.88,-10,-10,-10,-10,-10,-9.64,-8.67,-7.25,-5.35,-3.48,-3.54,-5.83,-5.02,-3.89,-4.77,-7.90,-7.09,-5.21,-5.77,-5.11,-4.85,-4.50,-6.13,-7.25,-8.34,-9.34,-10,-10,-11,-10,-10,-9.35,-7.97,-6.04,-5.12,-4.62,-4.13,-3.64,-3.14,-2.62,-2.02,-1.71,-1.51,-1.30,-1.09,-0.74,-0.39,-0.15,0.16,0.25,0.34,0.27,0.25,0.40,0.87,0.99,0.99,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,2,2,3,3,3,2,3,3,3,4,5,7,7,7,7,7,8,8,8,6,6,6,6,7,7,7,7,7,7,6,5,5,4,3,3,3,2,2,3,2,2,2,2,2,2,3,3,4,4,4,4,4,3,2,2,1,1,1,1,0,0,0,0,0,0.04,0.12,0.20,0.24,0.26,0.25,0.09,-0.27,-0.71,-1.10,-1.47,-1.88,-2.14,-2.08,-1.62,-0.97,-0.40,0.07,0.26,0.21,0.11,0.01,0,0.09,0.36,2,2,2,2,2,1,0,0,0,0,0,0,0,0,0,1,2,4,4,4,4,4,4,4,4,4,5,5,5,5,6,7,8,8,6,5,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,4,5,5,5,5,5,5,4,4,5,6,6,6,7,7,6,5,4,4,3,3,4,5,5,6,5.98,5.96,5.83,5.78,3.25,3.64,4.90,6.32,7.79,8.87,9.21,8.77,7.84,6.95,6.12,5.52,5.16,5.09,4.65,4,3,2,3,4,4,4,4,3,2,1,0,0.03,0.25,0.12,-0.16,-0.52,-1.65,-4.15,-6.24,-7.88,-9.15,-10,-10,-10,-10,-9.58,-8.61,-7.27,-5.34,-2.46,-0.41,-2.36,-3.38,-2.64,-2.76,-3.51,-6.03,-5.08,-3.52,-3.78,-3.65,-3.97,-3.66,-3.22,-4.88,-5.98,-7.40,-8.65,-9.64,-10,-10,-10,-10,-9.36,-8.60,-8.08,-7.73,-7.11,-6.33,-5.52,-4.75,-4.01,-3.35,-2.51,-2.02,-1.80,-1.67,-1.30,-0.91,-0.41,-0.14,0.20,0.25,0.33,0.50,0.87,0.99,0.99,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,2,2,3,3,3,3,3,3,3,3,4,5,6,7,7,7,7,8,7,7,6,5,5,6,6,6,6,6,6,6,6,5,4,4,3,3,3,2,2,2,2,2,2,2,2,3,3,4,4,4,4,3,3,2,2,1,1,1,1,0,0,0,0,0,0,0.08,0.15,0.25,0.29,0.32,0.25,0.09,-0.29,-0.74,-1.27,-2.26,-2.88,-3.24,-3.23,-2.75,-1.99,-0.85,-0.18,0.14,0.23,0.12,0.02,0,0.12,0.35,3,3,3,3,2.92,1.91,1.12,0.28,0.28,0.24,0.12,0.08,0.04,0.03,0,1,2,3,3,3,3,4,4,4,5,5,6,6,6,6,6,7,8,8,6,5,4,4,4,5,4,4,4,4,3,3,3,3,3,3,3,3,3,3,4,5,5,5,6,5,4,4,4,5,5,5,6,7,8,7,5,4,4,3,3,3,4,6,6,6.91,6.87,6.84,6.20,5.76,3.26,4.35,5.36,6.96,7.83,7.90,7.61,7.01,6.27,5.51,4.73,4.37,4.39,4.97,4,3,2,2,3,4,5,4,3,2,1,0,0.11,0.17,0.02,-0.39,-0.98,-2.09,-5.08,-6.86,-8.37,-9.61,-10,-10,-10,-9.68,-8.75,-7.37,-5.55,-2.78,-0.37,-0.09,-0.08,-0.12,-1.39,-1.50,-0.79,-1.42,-1.43,-1.05,-1.63,-2.49,-2.76,-2.47,-2.48,-3.18,-4.14,-5.77,-7.29,-8.61,-9.64,-10,-10,-10,-10,-10,-10,-10,-9.85,-8.84,-7.77,-6.78,-5.87,-4.96,-4.09,-3.25,-2.47,-2.38,-2.13,-1.80,-1.36,-0.88,-0.38,0.07,0.27,0.46,0.87,0.89,0.95,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,2,2,3,3,4,4,4,3,3,3,4,4,5,6,6,7,8,8,7,7,6,6,5,5,5,5,5,5,5,5,5,5,5,5,4,3,3,3,2,2,1,1,2,2,2,3,3,4,5,4,4,3,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0.08,0.15,0.25,0.29,0.29,0.24,0.10,-0.24,-0.75,-1.87,-2.86,-3.55,-3.98,-3.92,-3.54,-2.77,-1.60,-0.34,0.12,0.22,0.13,0.03,0.01,0.12,0.35,4,4,3.98,3.85,3.72,2.64,1.91,1.39,1,0.50,0.37,0.20,0.14,0.24,0.88,2,2,2,3,3,3,4,4,5,6,6,6,6,7,6,7,7,8,8,6,5,5,5,5,5,5,5,5,4,4,3,3,3,3,3,3,3,3,3,4,5,5,6,7,5,4,4,4,4,4,5,5,6,7,7,5,4,3,3,3,3,4,5,5,6.07,7.08,7.84,7.79,6.78,4.24,3.25,4.16,4.97,5.85,6.39,6.41,6.13,5.62,5,4.28,3.28,3.92,4,4,3,2,1,2,4,4,4,3,3,2,0.07,0.09,0.16,0.10,-0.49,-1.12,-2.36,-5.59,-7.21,-8.90,-9.99,-10,-10,-10,-9.21,-7.91,-6.53,-3.75,-1.25,-0.14,-0.03,0,-0.02,-0.11,-0.18,-0.25,-0.27,-0.25,-0.22,-0.64,-1.15,-1.46,-1.62,-1.68,-2.13,-2.92,-4.55,-6.14,-7.78,-9.15,-10,-11,-11,-11,-12,-12,-12,-12,-11,-9.78,-8.63,-7.58,-6.53,-5.50,-4.49,-3.54,-2.83,-2.68,-2.48,-2.13,-1.72,-1.04,-0.34,0.16,0.40,0.12,0.89,0.95,0,0,0,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,2,2,3,3,4,4,4,4,4,4,4,4,4,5,5,6,7,8,8,7,6,6,5,5,4,4,4,4,5,5,5,4,4,5,5,5,4,3,2,2,1,1,1,2,2,2,3,4,5,4,4,4,3,3,2,1,1,1,1,0,0,0,0,0,0,0,0.01,0.07,0.13,0.22,0.25,0.26,0.22,0.10,-0.18,-0.97,-2.22,-3.22,-4.15,-4.71,-4.77,-4.26,-3.27,-2.10,-0.65,0.11,0.24,0.16,0.08,0.04,0.14,0.36,6,5.01,4.83,4.32,3.82,3.25,2.59,2.41,2,1.45,0.62,0.46,0.27,0.38,0.74,1,1,2,2,3,4,3,4,5,5,5,6,6,6,7,7,7,8,8,6,5,5,6,6,6,6,5,6,5,4,4,3,3,3,3,3,3,3,4,4,5,6,6,7,6,4,4,4,4,4,4,5,6,6,6,5,4,4,3,3,3,4,4,5,6,7.09,8.87,8.83,6.95,5.23,3.24,2.24,3.25,3.98,4.75,5.75,5.12,4.97,4.83,4.12,3.10,3.03,4,5,4,2,1,2,3,4,3,3,2,1.97,0.11,0.07,0.24,0.20,-0.38,-0.88,-2.27,-5.13,-7.38,-9.18,-10,-11,-11,-10,-8.83,-7.16,-5.21,-2.75,-0.61,-0.24,-0.10,-0.01,-0.01,-0.08,-0.13,-0.15,-0.12,0.01,0.17,0.33,0.20,-0.13,-0.36,-0.63,-1.39,-2.30,-3.68,-5.25,-7.13,-8.76,-10,-11,-12,-12,-13,-13,-14,-14,-12,-11,-10,-9.10,-7.99,-6.85,-5.66,-4.53,-3.47,-2.91,-2.83,-2.67,-2.37,-1.71,-0.72,0.02,0.32,0.12,0.10,0.04,0,0,0,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,2,2,2,3,3,4,4,4,4,4,4,5,5,5,5,6,7,8,8,7,7,6,5,5,5,4,4,4,4,4,4,4,4,4,5,5,4,3,3,2,1,1,1,1,2,2,2,3,4,4,4,4,3,3,2,2,1,1,1,0,0,0,0,0,0,0,0,0.01,0.07,0.12,0.17,0.24,0.25,0.21,0.08,-0.18,-1.14,-2.41,-3.93,-4.99,-5.52,-5.63,-5.18,-4.16,-2.50,-0.92,0.10,0.26,0.25,0.16,0.14,0.23,0.38,6.98,6.84,5.67,4.98,4.36,3.64,3.75,3.66,3.35,2.62,1.71,0.67,0.50,0.38,0.41,0.25,0.88,1,2,3,2,3,3,4,4,4,5,5,5,7,7,7,8,8,6,6,6,6,7,7,6,6,6,5,4,4,3,3,3,3,3,3,3,3,4,5,5,7,6,5,4,4,4,4,4,4,4,5,6,6,6,5,4,3,3,3,3,4,5,5.99,6.92,7.88,8.86,7.83,5.79,4.07,2.23,2.23,1.23,3.10,3.78,4,4.16,4.86,4.88,3.07,2,3,4,4,2,1,1,2,3,3,3,2,1.08,0.13,0.07,0.28,0.20,-0.38,-0.86,-1.98,-4.90,-7.38,-9.55,-11,-11,-11,-10,-8.49,-6.38,-4.36,-1.68,-0.51,-0.34,-0.18,-0.10,-0.05,-0.09,-0.11,-0.08,0.07,0.32,0.66,1,1.21,1.21,0.88,0.62,-0.96,-1.84,-2.98,-4.55,-6.68,-8.50,-10,-11,-12,-13,-14,-14,-15,-14,-13,-12,-11,-10,-9.24,-8.02,-6.74,-5.42,-4.24,-3.15,-2.98,-2.88,-2.71,-2.01,-0.89,0.15,0.33,0,0,0,0,0,0,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,2,2,2,2,3,3,4,4,4,4,4,4,5,6,6,6,6,8,9,9,8,7,6,5,5,5,5,4,4,4,4,4,4,4,5,5,5,3,2,2,2,1,1,1,1,2,2,2,3,3,4,4,3,3,2,2,2,1,1,0,0,0,0,0,0,0,0,0,0,0.08,0.13,0.21,0.25,0.25,0.21,0.04,-0.25,-1.17,-2.96,-4.41,-5.46,-6,-6.13,-5.79,-4.88,-3.23,-1.14,-0.05,0.29,0.28,0.25,0.25,0.34,0.47,7.90,7.28,6.42,5.58,5.25,4.75,4.87,5.23,5.12,4.20,2.83,1.70,0.72,0.50,0.34,0.34,0.22,1.01,2,2,2,2,3,3,3,4,4,4,5,6,7,7,8,7,6,6,6,6,7,7,7,6,6,5,5,4,3,3,3,3,3,3,3,3,4,5,5,6,6,5,4,4,4,3,3,3,4,5,6,7,7,7,5,4,3,3,3,3,5,6,6.02,6.91,7.08,6.86,6.04,4.79,3.20,2.16,1.21,1.83,2.20,2.88,3.13,4.88,4.91,3.97,3,2,4,3,1,0,0,1,2,3,2,2,0.89,0.20,0.15,0.29,0.08,-0.42,-0.90,-1.53,-4.67,-7.38,-9.55,-11,-11,-11,-10,-7.98,-5.55,-3,-0.63,-0.46,-0.46,-0.29,-0.15,-0.11,-0.11,-0.11,-0.03,0.16,0.58,1.12,1.75,2.20,2.17,2,0.98,-1,-1,-2.04,-4.27,-6.50,-8.40,-10,-11,-12,-13,-14,-15,-15,-15,-14,-13,-12,-11,-10,-9.01,-7.65,-6.25,-4.91,-3.79,-3,-2.97,-2.86,-2.22,-0.97,0.34,0.28,0.10,0,0,0,0,0,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,2,2,2,2,2,3,3,4,4,4,4,4,4,5,5,6,6,7,8,10,10,9,8,7,6,5,5,5,5,5,5,4,4,4,4,5,5,4,3,2,2,1,1,1,1,2,2,2,2,2,3,3,3,3,3,2,2,1,1,1,0,0,0,0,0,0,0,0,0,0.02,0.11,0.16,0.23,0.25,0.25,0.16,-0.01,-0.35,-1.53,-3.77,-5.37,-6.23,-6.63,-6.76,-6.48,-5.50,-3.66,-1.46,-0.25,0.11,0.13,0.16,0.25,0.37,0.51,8.20,8.37,8.12,7.37,6.49,5.84,6.01,6.53,8.07,5.64,4.07,2.54,1.45,0.72,0.49,0.38,0.29,0.87,1,1,1,2,2,2,2,3,4,5,5,6,7,6,6,6,5,6,6,6,7,7,7,7,6,6,5,5,4,3,3,3,3,3,3,3,3,4,5,5,5,5,5,4,4,3,3,3,4,5,6,6,6,7,6,4,3,2,2,3,4,5,5,5.96,6.08,6.11,6.87,5.84,3.85,2.83,1.16,1.04,1.15,1.88,2.88,3.08,4.96,4,3,2,3,2,1,0,0,1,2,2,2,1,0.87,0.26,0.20,0.26,0.02,-0.41,-0.99,-1.15,-4.48,-7.26,-9.66,-11,-12,-11,-9.92,-7.50,-4.64,-1.38,-0.23,-0.28,-0.35,-0.29,-0.15,-0.13,-0.14,-0.15,-0.10,0.15,0.66,1.45,2.35,3.27,3.22,2.34,1,1,-1,-2.22,-4.30,-6.58,-8.51,-10,-11,-12,-13,-14,-14,-15,-14,-14,-13,-13,-12,-10,-9.75,-8.37,-6.90,-5.50,-4.23,-3,-2.99,-2.88,-2.25,-1.17,0.58,0.88,0.09,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,2,2,2,2,2,3,3,3,3,3,3,4,4,5,5,6,7,8,9,10,10,9,8,7,6,5,5,5,5,6,5,4,4,4,4,4,5,4,3,2,1,1,1,2,2,2,2,2,2,2,2,3,3,3,3,2,1,1,1,1,0,0,0,0,0,0,0,0,0.07,0.09,0.13,0.23,0.25,0.25,0.21,0.10,-0.16,-1.15,-2.86,-4.99,-6.65,-7.98,-8.37,-7.80,-7.03,-6.13,-4.28,-1.86,-0.68,-0.46,-0.38,-0.27,-0.14,0.13,0.45,10.13,10.37,10.38,9.27,7.83,6.88,6.95,7.62,8,7,5.14,3.40,1.86,1.13,0.67,0.63,0.75,0.88,1,1,1,1,2,2,2,2,3,4,4,4,5,5,4,4,5,5,6,6,7,7,7,7,7,6,6,5,5,4,4,3,4,3,3,3,3,3,4,5,5,5,4,4,3,3,3,3,4,5,5,5,5,5,5,5,3,2,2,2,3,4,5,5,5.97,6.92,5.89,4.97,3.96,2.87,1.12,0.12,0.11,1,1.92,2.02,3,3,3,2,2,1,0,0,0,0,1,1,1,1,0.27,0.20,0.20,0.24,0.13,-0.33,-0.84,-1.09,-4.33,-7.11,-9.39,-11,-11,-11,-9.26,-6.64,-3.65,-0.35,-0.01,-0.04,-0.13,-0.15,-0.12,-0.35,-0.40,-0.28,-0.28,-0.11,0.50,1.50,2.77,3.70,3.41,2.45,1,1,-1,-2.48,-4.75,-6.90,-8.85,-10,-11,-12,-13,-14,-14,-14,-14,-14,-13,-13,-12,-11,-10,-8.87,-7.39,-5.97,-4.61,-3.27,-2.98,-2.86,-2.33,-1.42,-0.88,0.90,0.04,0.01,0,0,0,0,0,0,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,2,2,2,2,2,3,3,3,3,3,3,4,4,5,5,6,7,9,10,10,9,8,8,8,6,5,5,5,6,6,5,4,4,4,4,4,4,4,3,2,1,1,1,2,3,2,2,2,2,2,2,2,2,2,2,2,1,1,1,0,0,0,0,0,0,0,0,0.12,0.14,0.15,0.17,0.23,0.28,0.23,0.13,-0.02,-0.91,-2.50,-4.30,-5.96,-7.91,-8.96,-9.29,-8.99,-7.78,-6.48,-4.86,-3.02,-1.63,-1.39,-1.18,-1.04,-0.79,-0.47,-0.04,11.65,12.50,13.35,11.24,8.70,7.76,7.78,8.27,8.97,7.97,5.97,3.99,2.49,1.50,1.04,0.96,1.09,1.23,1,1,1,2,2,2,3,2,2,2,3,3,3,3,3,4,4,4,5,6,7,7,7,7,8,7,6,5,5,5,4,4,3,3,3,2,2,2,3,5,5,5,5,4,3,3,2,3,3,4,4,4,4,4,4,4,3,2,2,2,2,3,4,5,5,5,4.99,4.07,3.91,2.91,1.08,0.08,0.07,0.03,0,1,1,1,1,2,2,0,0,0,0,0,0,1,1,0,0.15,0.10,0.13,0.22,0.22,-0.16,-0.73,-1.15,-4.25,-7.05,-9.27,-10,-11,-10,-8.76,-5.91,-2.28,-0.10,0.10,0.10,0.04,-0.01,-0.09,-1.50,-2.62,-1.49,-0.58,-0.38,0.20,1.16,2.25,3.01,3.10,2.59,1.78,0.54,-0.58,-2.24,-4.36,-7.39,-9.71,-10,-12,-12,-13,-14,-14,-14,-14,-14,-13,-13,-12,-11,-10,-9.16,-7.75,-6.34,-4.98,-3.65,-2.97,-2.86,-2.41,-1.85,-0.73,0.33,0.35,0.12,0.02,0,0,0,0,0,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,2,2,2,2,2,3,3,3,4,4,4,4,4,4,5,6,7,8,10,10,9,9,8,7,7,6,5,5,5,6,5,5,4,4,4,3,4,4,3,2,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,0,0,0,0,0,0,0,0.02,0.11,0.25,0.26,0.25,0.23,0.22,0.23,0.20,0.09,-0.40,-2.13,-3.93,-5.59,-7.42,-8.93,-9.72,-9.90,-9.60,-8.47,-7.22,-5.85,-4.40,-3.37,-2.85,-2.42,-2.04,-1.64,-1.22,-0.80,12.65,12.47,12.34,10.25,8.88,7.95,8.37,8.97,8.97,7.74,6.08,4.27,2.76,1.76,1.28,1.24,1.41,1.75,2,2,2,2,3,3,3,3,2,2,2,2,2,2,3,3,3,4,4,5,6,7,7,8,8,7,6,5,5,5,5,4,4,3,3,2,2,2,2,4,5,6,5,4,3,3,2,2,3,3,4,4,4,4,4,3,3,2,2,2,2,3,4,5,5,5,4,4,3,3,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.01,0.04,0.11,0.22,0.26,-0.02,-0.67,-1.27,-4.24,-6.96,-9.30,-10,-11,-10,-8.51,-5.46,-1.72,-0.14,0.07,0.12,0.11,0.01,-0.11,-1.36,-3.50,-2.63,-0.78,-0.63,-0.05,0.85,1.77,2.57,3.02,2.79,2,0.83,-0.30,-1.59,-4.03,-7.23,-9.46,-10,-11,-12,-13,-13,-14,-14,-14,-14,-13,-13,-12,-11,-10,-9.33,-7.98,-6.63,-5.34,-4.04,-3.10,-2.87,-2.72,-2.05,-1.08,0.02,0.24,0.17,0.08,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,2,2,2,2,2,3,3,4,4,4,4,4,5,4,5,6,8,9,11,10,9,9,8,7,6,6,6,6,6,5,5,5,4,4,3,3,3,3,3,2,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,1,1,1,0,0,0,0,0,0,0,0,0.07,0.17,0.37,0.34,0.28,0.24,0.20,0.16,0.11,-0.09,-1.37,-3.33,-5.15,-6.73,-8.66,-9.99,-10,-10,-10,-9.18,-8.09,-6.92,-5.84,-4.98,-4.25,-3.66,-3.12,-2.55,-2.01,-1.55,11.65,10.92,10.04,8.78,8.63,8.62,8.84,9.08,8.97,7.66,6,4.28,2.84,1.86,1.42,1.46,1.76,2.22,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,3,3,3,4,5,7,7,8,8,8,8,6,5,5,5,5,5,5,3,2,2,2,2,2,3,4,6,7,6,4,3,2,2,2,3,3,3,3,3,3,3,3,3,2,2,2,3,4,5,6,5,5,4,4,3,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.01,0.04,0.12,0.24,0.25,-0.02,-0.67,-1.51,-4.33,-6.88,-9.03,-10,-10,-9.89,-7.87,-5.05,-1.60,-0.25,-0.04,0.07,0.04,-0.03,-0.15,-0.30,-2.43,-3.46,-1.50,-0.50,-0.09,0.62,1.38,2.16,2.78,2.64,1.92,0.75,-0.24,-1.37,-3.92,-7.25,-9.41,-10,-11,-12,-13,-13,-13,-14,-14,-14,-13,-13,-12,-11,-10,-9.38,-8.13,-6.87,-5.64,-4.51,-3.49,-2.96,-2.83,-2.28,-1.39,-0.38,0.12,0.22,0.12,0.01,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,2,2,2,2,3,3,3,4,4,4,4,4,4,4,5,7,8,10,11,10,9,9,8,7,6,6,6,6,6,5,5,4,4,4,3,3,3,3,2,2,1,1,1,1,2,2,2,2,3,2,2,2,2,1,1,1,1,0,0.02,0,0,0,0,0,0,0.01,0.09,0.21,0.35,0.32,0.25,0.20,0.13,0.10,0,-0.61,-2.21,-4.26,-6.50,-8.03,-9.53,-10,-11,-11,-10,-9.99,-9.02,-8.09,-7.17,-6.37,-5.63,-4.92,-4.24,-3.52,-2.85,-2.26,10.08,9.50,8.64,7.75,8.62,9,9.22,9.28,8.97,7.63,5.91,4.15,2.76,1.83,1.54,1.61,2.09,2.75,3,4,4,4,4,3,3,3,2,2,2,2,2,2,2,2,3,3,4,5,6,7,8,8,7,7,6,5,5,5,5,6,5,3,2,2,2,2,2,3,4,5,6,6,5,4,3,2,2,2,3,3,3,3,3,3,3,3,3,2,2,3,4,5,5,5,5,5,4,3,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.07,0.16,0.28,0.36,0.28,-0.01,-0.64,-1.79,-4.42,-6.97,-9.12,-10,-10,-9.66,-7.53,-4.76,-1.39,-0.36,-0.13,0,0.02,-0.04,-0.16,-3.16,-5.18,-4.33,-2.36,-0.36,-0.15,0.29,0.97,1.71,2.27,2.22,1.62,0.66,-0.29,-2.03,-4.87,-7.73,-9.62,-10,-11,-12,-12,-13,-13,-13,-14,-13,-13,-13,-12,-11,-10,-9.40,-8.24,-7.08,-5.91,-4.75,-3.86,-3.16,-2.88,-2.50,-1.77,-0.84,-0.09,0.26,0.16,0.04,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,2,2,2,2,3,3,4,4,4,4,4,4,4,5,6,7,9,11,11,9,9,8,7,7,7,7,7,6,5,5,5,4,4,4,3,3,3,2,2,2,1,1,1,1,1,2,2,3,2,2,2,2,1,1,1,1,0,0.02,0,0,0,0,0,0,0,0.02,0.10,0.17,0.27,0.21,0.12,0.03,-0.02,-0.11,-0.64,-1.50,-2.88,-5.50,-7.78,-9.39,-10,-11,-12,-12,-11,-10,-10,-9.18,-8.40,-7.66,-6.93,-6.18,-5.38,-4.52,-3.67,-2.98,9.26,8.46,8.61,8.64,8.83,9.13,10.04,9.03,9,8,5.51,3.89,2.67,1.78,1.67,1.98,2.37,3,4,4,5,5,4,4,3,3,2,2,2,2,2,2,2,2,3,3,4,5,6,7,7,7,7,6,6,6,5,6,5,5,4,3,2,2,2,2,2,3,3,3,4,5,4,3,3,3,3,3,3,3,2,3,3,3,3,2,2,2,2,3,3,4,6,6,6,6,5,3,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.16,0.36,0.51,0.53,0.37,-0.08,-0.63,-1.71,-4.41,-7.03,-9.23,-10,-10,-9.41,-7.14,-4.35,-1.33,-0.43,-0.17,0.01,0.11,0.04,-0.10,-4.09,-5.22,-2.53,-2.51,-1.65,-0.49,-0.16,0.45,1.15,1.67,1.65,1.23,0.35,-0.92,-3.38,-6.30,-8.61,-10,-11,-11,-12,-12,-13,-13,-13,-13,-13,-13,-13,-12,-11,-10,-9.48,-8.38,-7.27,-6.18,-5.03,-4.09,-3.42,-2.91,-2.63,-2.01,-1.13,-0.26,0.16,0.21,0.10,0.01,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,2,2,2,2,3,3,4,5,4,5,5,5,5,5,7,8,9,10,9,9,8,8,7,7,7,7,7,6,5,5,5,4,4,4,3,3,2,2,2,2,1,1,1,1,1,2,2,2,2,2,2,1,1,0.98,0.03,0.07,0.09,0,0,0,0,0,0.02,0.02,0.03,0.07,0.12,0.16,0.17,0.03,-0.12,-0.25,-0.35,-1.10,-1.75,-2.61,-4.30,-6.60,-8.50,-10,-11,-12,-12,-12,-12,-11,-10,-10,-9.53,-8.88,-8.17,-7.40,-6.50,-5.51,-4.51,-3.66,9.79,9.62,8.99,8.86,9.24,9.15,8.25,8.07,8.07,6.22,4.78,3.50,2.61,2.15,2.12,2.37,2.84,3.12,4,5,5,6,6,5,4,3,3,3,3,3,3,3,3,3,3,4,4,5,6,6,7,7,6,6,6,6,5,5,4,4,4,3,2,2,2,2,2,2,2,3,3,3,3,3,3,4,4,3,3,3,3,2,2,2,2,2,1,1,2,2,3,4,5,6,7,7,5,4,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.26,0.53,0.75,0.76,0.46,0.01,-0.50,-1.48,-4.42,-7.02,-9.26,-10,-10,-9.04,-6.59,-3.68,-1.15,-0.46,-0.16,0.17,0.34,0.33,0.14,-1.11,-3.39,-2.73,-2.92,-4.08,-2.01,-0.76,-0.10,0.66,1.21,1.22,0.82,-0.11,-1.66,-4.61,-7.75,-9.66,-10,-11,-12,-12,-12,-13,-13,-13,-14,-13,-13,-13,-12,-11,-10,-9.62,-8.54,-7.50,-6.48,-5.51,-4.39,-3.63,-3.09,-2.75,-2.25,-1.41,-0.51,0.08,0.22,0.13,0.02,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,2,2,2,2,3,3,4,4,5,5,5,5,5,6,7,8,10,9,9,8,8,8,7,6,6,6,5,5,5,5,5,5,4,4,4,3,2,2,2,2,1,0,0,1,1,2,2,2,2,2,2,1,0.99,0.91,0.10,0.01,0.01,0.01,0.01,0.04,0.09,0.11,0.08,0.07,0.09,0.12,0.15,0.15,0.09,-0.21,-0.46,-0.68,-1.53,-2.73,-3.51,-4.68,-6.12,-7.75,-9.39,-10,-11,-12,-13,-13,-13,-12,-11,-11,-10,-9.92,-9.27,-8.50,-7.52,-6.41,-5.27,-4.30,9.90,9.71,9.57,8.41,8.32,7.25,6.37,5.95,5.48,4.73,3.77,3.01,2.54,2.41,2.52,2.97,3.22,4.03,6,6,6,7,7,6,5,4,3,3,3,3,3,3,3,3,4,4,5,5,5,6,6,6,6,6,6,5,5,4,4,4,4,3,2,2,2,2,2,2,2,2,3,2,2,2,3,4,4,3,3,3,2,2,2,2,2,2,1,1,1,2,3,4,4,6,7,7,6,4,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.27,0.66,0.86,0.78,0.50,0.11,-0.28,-1.34,-4.02,-7.13,-9.47,-10,-10,-8.79,-5.88,-2.83,-0.78,-0.26,0.12,0.51,0.77,0.77,0.53,0.08,-2.47,-3.11,-2.54,-3.74,-3.75,-2.41,-0.75,0.13,0.76,0.90,0.50,-0.67,-2.52,-6.05,-8.87,-10,-11,-12,-12,-12,-13,-13,-13,-13,-14,-14,-14,-13,-12,-11,-10,-9.86,-8.79,-7.76,-6.74,-5.75,-4.73,-3.92,-3.23,-2.85,-2.43,-1.72,-0.83,-0.11,0.23,0.17,0.07,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,2,2,3,4,4,4,5,5,5,5,5,6,7,8,9,8,8,8,8,8,7,6,5,4,4,5,5,5,5,5,5,4,4,3,2,1,2,2,1,0,0,0,1,1,2,2,2,2,2,1.03,1.09,0.87,0.13,0.01,0,0.02,0.08,0.12,0.16,0.15,0.09,0.07,0.09,0.13,0.21,0.15,-0.05,-0.50,-0.86,-1.72,-3.21,-4.46,-5.25,-6.29,-7.53,-8.87,-10,-11,-12,-13,-13,-13,-13,-12,-12,-11,-11,-10,-10,-9.38,-8.35,-7.15,-5.91,-4.87,8.98,8.84,7.85,6.97,5.86,4.64,3.71,3.75,3.76,3.39,2.74,2.62,2.54,2.52,3.23,3.82,4.11,5,6,7,7,7,7,7,5,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,6,6,5,5,4,3,3,3,3,3,2,2,2,3,3,3,3,3,3,3,2,2,3,3,3,4,3,3,2,2,2,3,2,2,1,1,1,2,3,4,5,6,6,7,6,4,3,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.22,0.40,0.57,0.57,0.50,0.15,-0.14,-1.04,-2.71,-5.30,-7.42,-8.41,-8.08,-6.68,-4.46,-1.58,-0.38,0.03,0.59,1.15,1.41,1.36,1.08,0.53,-0.62,-2.75,-4.65,-4.50,-5.61,-4,-1.24,-0.39,0.39,0.70,0.12,-1.34,-3.77,-7.22,-9.97,-11,-12,-13,-13,-13,-13,-13,-14,-14,-14,-14,-14,-13,-13,-12,-11,-10,-9.10,-8.02,-7.10,-5.97,-5.01,-4.24,-3.29,-2.89,-2.61,-1.98,-1.11,-0.29,0.13,0.21,0.10,0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,2,2,3,4,4,5,5,6,5,5,5,6,7,7,8,7,8,8,8,7,6,5,4,3,4,4,5,5,5,5,5,4,4,3,1,1,2,2,1,1,0,0,0,1,2,2,2,2,1.96,1.90,1.87,1.84,0.17,0.01,0.02,0.09,0.16,0.24,0.25,0.12,-0.11,-0.15,-0.10,0.01,0.11,0.01,-0.33,-1.09,-1.92,-3.41,-4.63,-5.71,-6.62,-7.63,-8.72,-9.83,-10,-11,-12,-13,-13,-13,-13,-13,-12,-12,-11,-11,-10,-9.92,-8.88,-7.64,-6.37,-5.26,7,6.98,6.82,5.15,3.42,2.52,2.59,2.62,2.62,2.59,2.46,2.45,2.49,3.24,3.89,4.87,6,6,6,7,7,8,8,8,6,5,5,5,5,5,5,5,5,5,5,6,6,5,5,5,5,5,5,6,5,4,3,3,3,3,3,3,3,2,3,3,4,4,3,3,4,3,3,3,3,3,3,3,3,2,2,2,2,2,2,1,1,1,2,2,3,3,4,6,6,6,6,4,3,2,1,0,1,1,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0.11,0.17,0.29,0.36,0.38,0.13,-0.10,-0.53,-1.63,-3.39,-4.85,-5.55,-5.52,-4.38,-2,-0.36,-0.03,0.45,1.08,1.72,2.23,1.88,1.37,0.52,-0.61,-2.79,-5.66,-5.75,-5.36,-4.58,-2.97,-2.36,-0.96,0.01,-0.48,-2.27,-5.13,-8.27,-10,-12,-13,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-13,-12,-11,-10,-9.40,-8.35,-7.29,-6.38,-5.42,-4.39,-3.40,-2.96,-2.71,-2.15,-1.33,-0.50,0.07,0.20,0.12,0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,2,3,3,4,4,5,5,5,5,5,5,5,6,7,7,7,8,8,7,7,5,4,3,3,3,4,5,5,5,5,5,4,3,2,2,2,2,2,1,1,1,0,0,1,2,3,2,1.99,1.99,2.09,2.84,1.79,0.22,0.03,0.09,0.17,0.25,0.36,0.12,-0.23,-0.52,-0.63,-0.59,-0.41,-0.30,-0.61,-1.65,-2.55,-3.61,-4.68,-5.79,-6.77,-7.74,-8.66,-9.62,-10,-11,-12,-12,-13,-13,-13,-13,-12,-12,-12,-11,-11,-10,-9.88,-8.91,-7.77,-6.61,-5.51,5,5,4.98,3.14,2.27,2.34,2.24,2.23,2.22,2.21,2.23,2.39,2.88,3.75,4.88,5,6,7,7,7,7,8,9,8,7,6,6,5,6,6,6,6,7,7,6,6,6,5,5,4,4,5,5,5,4,4,3,2,3,3,3,4,3,3,3,4,4,4,4,4,4,4,4,3,3,4,4,4,3,3,2,2,1,1,1,1,1,1,2,3,2,3,4,5,6,7,5,4,3,2,1,1,2,2,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0.03,0.08,0.24,0.25,0.12,-0.09,-0.25,-0.92,-1.59,-2.35,-2.92,-2.63,-1.41,-0.27,-0.05,0.28,0.83,1.51,2.28,3,2.34,1.47,0.53,-0.52,-1.49,-3.28,-3.35,-4.53,-5.89,-6.43,-6.02,-3.86,-2.05,-1.16,-3.37,-6.25,-9.34,-11,-13,-14,-14,-14,-14,-14,-14,-14,-14,-15,-15,-14,-14,-13,-13,-11,-10,-9.74,-8.71,-7.83,-6.88,-5.80,-4.60,-3.42,-2.98,-2.74,-2.23,-1.40,-0.55,0.02,0.20,0.12,0.02,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,0,0,1,1,2,3,4,4,4,4,5,5,4,4,4,5,5,6,6,7,8,7,6,5,4,3,3,3,3,4,4,4,5,5,4,3,2,2,2,2,2,1,1,1,2,1,0,1,2,2,2,1.96,1.89,1.97,1.95,1.77,0.24,0.08,0.21,0.27,0.24,0.12,-0.27,-0.77,-1.14,-1.28,-1.25,-1.16,-1.52,-2.34,-3.15,-4.05,-5,-5.97,-6.92,-7.75,-8.63,-9.46,-10,-10,-11,-12,-12,-12,-13,-13,-12,-12,-12,-11,-11,-10,-10,-9.75,-8.85,-7.76,-6.65,-5.63,4,4,3,2,2.07,2.09,2.08,2.04,2.04,2.07,2.10,2.22,3,3.96,4,5,6,7,8,9,8,9,9,9,8,7,6,6,6,6,6,7,7,7,7,6,6,5,5,4,4,4,5,4,4,4,3,2,2,3,3,3,3,3,3,4,4,4,5,4,4,4,4,4,4,4,5,4,4,3,2,2,1,1,1,1,1,2,2,3,2,2,3,4,5,5,5,4,3,2,2,2,2,3,2,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0.04,0.25,0.24,0.12,-0.08,-0.23,-0.33,-0.58,-0.91,-0.89,-0.51,-0.16,0,0.25,0.66,1.25,1.95,2.53,3.02,2.25,1.40,0.50,-0.41,-1.22,-1.63,-2.41,-4.93,-6.35,-7.88,-7.71,-5.75,-4.12,-2.84,-4.63,-7.51,-10,-12,-14,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-14,-14,-13,-12,-11,-10,-8.99,-8.36,-7.41,-6.16,-4.75,-3.38,-2.96,-2.66,-2.13,-1.28,-0.48,0.08,0.22,0.12,0.02,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,1,2,3,3,3,4,4,4,4,4,4,4,4,4,5,5,6,7,7,6,5,4,3,2,2,3,3,4,4,4,4,4,4,3,2,1,1,2,1,1,1,1,1,1,0,1,1,1.02,1.03,1.87,1.83,1.22,1.74,1.72,0.28,0.22,0.37,0.29,0.01,-0.41,-0.91,-1.46,-1.77,-1.97,-2.01,-2.71,-3.26,-3.93,-4.71,-5.48,-6.26,-7.08,-7.88,-8.54,-9.27,-9.96,-10,-11,-11,-11,-12,-12,-12,-12,-12,-11,-11,-11,-10,-10,-10,-9.41,-8.59,-7.61,-6.59,-5.73,3,3,2,2,2,2,2,2,2,2,2,2,3,4,4,5,6,7,8,9,9,10,10,10,9,8,7,7,7,7,7,7,7,7,7,7,6,6,5,4,3,3,4,4,4,3,3,2,2,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,5,4,4,4,4,3,2,1,1,1,1,3,3,3,3,2,1,2,3,4,5,5,4,3,3,3,3,3,3,2,1,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0.02,0.15,0.46,0.14,-0.02,-0.21,-0.29,-0.34,-0.30,-0.25,-0.13,0.03,0.28,0.64,1.17,1.83,2.45,2.79,2.71,2.16,1.28,0.42,-0.33,-0.89,-1.21,-2.85,-5.22,-6.96,-7.97,-8.35,-7.75,-6.73,-5.63,-6.43,-9.18,-11,-13,-15,-15,-16,-16,-15,-15,-15,-15,-15,-15,-15,-15,-15,-14,-13,-12,-11,-10,-9.18,-8.55,-7.64,-6.40,-4.83,-3.47,-2.89,-2.51,-1.87,-1,-0.23,0.20,0.24,0.12,0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,2,3,3,3,3,3,4,4,3,3,3,4,4,4,5,6,6,6,5,4,3,2,2,2,3,3,3,4,4,4,4,3,2,1,1,1,1,1,1,1,1,1,1,1,0.16,0.36,0.87,1.36,1.40,1.37,1.25,1.11,0.85,0.49,0.33,0.35,0.03,-0.55,-1.10,-1.61,-2.04,-2.46,-3.02,-3.77,-4.30,-4.88,-5.49,-6.12,-6.73,-7.33,-7.92,-8.58,-9.09,-9.66,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-9.60,-9,-8.24,-7.36,-6.46,-5.68,3,3,2,2,2,2,2,2,2,2,2,2,3,3,4,5,6,7,9,10,10,11,11,10,9,9,8,8,8,7,7,7,7,8,8,8,7,6,5,4,3,3,4,3,3,3,2,2,3,3,3,3,3,3,3,4,4,4,4,5,4,4,4,4,5,4,4,5,4,4,3,2,2,1,1,2,2,3,4,4,3,2,2,2,3,3,4,3,3,3,3,4,4,2,1,1,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0.01,0.20,0.27,0.11,-0.17,-0.33,-0.37,-0.30,-0.17,0,0.25,0.62,1.13,1.85,2.61,3.15,3.27,2.90,2.17,1.26,0.09,-0.18,-0.59,-0.84,-2.50,-5.40,-8.25,-10,-11,-10,-9.65,-9.26,-9.76,-11,-12,-14,-15,-16,-16,-16,-16,-15,-15,-15,-15,-15,-15,-15,-14,-14,-13,-12,-11,-10,-9.14,-8.50,-7.59,-6.34,-4.92,-3.42,-2.75,-2.25,-1.48,-0.63,0.09,0.27,0.23,0.10,0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,3,4,4,4,3,3,3,3,3,3,3,3,4,4,5,5,6,7,6,4,3,2,2,2,3,3,3,3,3,3,3,3,2,1,1,0,0,0,0,1,1,1,1.01,0.72,0.26,0.28,0.75,1.22,1.27,1.14,0.95,0.74,0.51,0.37,0.35,0.15,-0.54,-1.21,-1.77,-2.25,-3.26,-4.25,-4.91,-5.46,-5.93,-6.38,-6.85,-7.27,-7.71,-8.11,-8.53,-9,-9.38,-9.80,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.86,-9.52,-9.10,-8.55,-7.89,-7.13,-6.34,-5.66,3,3,3,2,2,2,2,2,2,2,2,3,3,3,4,5,6,8,9,10,11,11,10,10,10,9,9,9,9,8,7,7,8,8,8,8,7,6,5,4,3,3,3,3,3,3,2,2,2,3,3,3,3,3,3,4,4,4,5,5,4,4,4,4,4,5,5,5,4,4,4,3,2,2,2,2,2,3,4,4,4,3,2,1,1,2,2,2,2,2,3,4,3,2,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.76,0.32,-0.14,-0.39,-0.41,-0.33,-0.14,0.11,0.46,0.97,1.70,2.62,3.59,4.16,4.10,3.40,2.39,1.37,0.54,-0.03,-0.37,-0.59,-1.62,-6.24,-10,-12,-12,-12,-12,-12,-12,-13,-14,-15,-16,-16,-16,-16,-16,-16,-15,-15,-15,-15,-15,-14,-14,-14,-13,-12,-11,-10,-9.25,-8.33,-7.24,-6.14,-4.92,-3.37,-2.54,-1.89,-1.04,-0.26,0.21,0.26,0.16,0.07,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,3,4,4,3,3,3,3,3,3,3,3,3,4,4,4,5,5,6,6,4,3,2,2,2,3,3,3,3,3,2,2,2,2,1,1,1,1,0,0,1,1,1.98,1.65,0.61,0.24,0.25,0.66,1.22,1.32,0.97,0.72,0.48,0.25,0.09,0.03,-0.62,-1.22,-1.83,-2.39,-4,-5.17,-6.22,-6.75,-7.15,-7.43,-7.71,-7.93,-8.16,-8.38,-8.63,-8.88,-9.18,-9.47,-9.77,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.97,-9.83,-9.72,-9.58,-9.38,-9.10,-8.72,-8.24,-7.64,-6.98,-6.29,-5.73,3,3,4,2,2,2,2,2,2,2,3,3,3,4,4,5,6,7,8,9,10,11,11,11,11,10,9,10,10,9,8,7,8,7,8,7,7,6,5,4,4,3,3,2,2,2,2,2,2,3,3,3,4,4,4,4,4,5,5,5,4,4,4,4,4,4,5,5,4,4,3,2,2,2,2,2,2,3,4,4,4,4,2,1,1,1,1,1,1,1,2,2,2,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.62,-0.25,-0.42,-0.38,-0.28,-0.09,0.22,0.63,1.27,2.20,3.37,4.50,5.45,5.32,4,2.62,1.51,0.72,0.15,-0.23,-0.48,-1.83,-6.40,-10,-12,-13,-14,-14,-14,-14,-14,-15,-16,-16,-17,-17,-16,-16,-16,-15,-15,-15,-14,-14,-14,-14,-13,-12,-11,-10,-9.55,-9.01,-8.18,-7.14,-5.92,-4.65,-3.26,-2.28,-1.49,-0.63,0.08,0.25,0.22,0.10,0.02,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,2,3,3,3,3,3,2,2,2,3,3,3,3,3,4,4,4,4,4,4,4,3,3,3,2,2,3,3,2,2,2,1,1,1,1,1,1,1,0,0.13,0.87,1.58,1.21,0.90,0.50,0.20,0.25,0.61,0.95,0.92,0.76,0.52,0.25,-0.05,-0.38,-0.78,-1.26,-1.88,-2.47,-4.21,-5.68,-7.09,-8.12,-8.38,-8.64,-8.72,-8.74,-8.75,-8.77,-8.83,-8.90,-9.04,-9.24,-9.42,-9.65,-9.87,-10,-10,-10,-10,-10,-9.97,-9.84,-9.67,-9.52,-9.38,-9.28,-9.17,-9.02,-8.78,-8.47,-8.03,-7.52,-6.93,-6.36,-5.87,4,4,3,2,2,2,2,2,2,3,3,3,4,4,4,5,6,7,8,9,10,11,11,11,11,9,9,9,10,9,8,7,6,6,6,6,6,6,5,4,4,4,3,2,2,2,2,2,2,3,3,4,4,5,4,4,4,5,6,6,5,4,5,5,4,4,4,5,5,3,3,2,2,2,2,2,3,3,4,4,4,4,3,2,1,0,0,0,0,0,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.98,0.59,-0.13,-0.22,-0.18,0.01,0.33,0.77,1.50,2.53,3.84,5.20,6,6.59,4.37,2.77,1.58,0.77,0.23,-0.15,-0.43,-2.93,-6.29,-9.63,-12,-13,-14,-15,-15,-15,-16,-16,-16,-17,-17,-17,-16,-16,-16,-15,-15,-14,-14,-14,-13,-13,-12,-12,-10,-10,-9.38,-8.83,-8.11,-7.08,-5.63,-4.24,-2.91,-1.88,-1.10,-0.27,0.16,0.23,0.14,0.04,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,2,2,3,3,3,3,2,2,2,2,3,3,2,3,3,3,4,4,4,3,3,3,3,3,3,2,2,2,2,2,1,1,1,1,1,1,0,1,0.98,0.75,0.75,0.97,1.03,0.90,0.62,0.34,0.17,0.25,0.48,0.70,0.66,0.54,0.33,-0.02,-0.49,-0.92,-1.39,-1.91,-2.63,-4.11,-5.58,-7.16,-8.52,-9.50,-9.64,-9.77,-9.66,-9.49,-9.29,-9.14,-9.04,-9.02,-9.08,-9.17,-9.36,-9.52,-9.67,-9.80,-9.89,-9.92,-9.89,-9.85,-9.73,-9.61,-9.48,-9.33,-9.18,-9.08,-8.98,-8.85,-8.64,-8.38,-8,-7.53,-7.02,-6.50,-6.08,4,4,3,2,2,2,2,2,2,2,3,3,4,5,5,5,6,7,8,9,9,10,10,11,10,9,8,9,10,9,8,6,5,5,5,5,6,6,5,5,4,3,3,2,2,2,2,2,2,2,3,4,4,5,4,4,4,5,5,6,5,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,4,5,5,4,3,3,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0.98,0.45,-0.01,-0.02,0.11,0.42,0.89,1.65,2.73,4.01,5.23,5.96,5.91,4.37,2.82,1.60,0.79,0.24,-0.14,-0.84,-3.48,-6.61,-9.72,-12,-14,-15,-16,-16,-16,-17,-17,-17,-17,-17,-17,-16,-16,-15,-15,-14,-14,-13,-13,-13,-12,-12,-11,-10,-9.77,-9.50,-8.88,-7.89,-6.64,-5.29,-3.77,-2.38,-1.47,-0.75,-0.05,0.21,0.17,0.10,0.02,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,1,2,2,2,3,3,3,2,2,2,2,2,3,2,2,2,3,3,3,3,3,3,3,3,2,2,2,2,2,1,1,1,0,0,0,0,0,0,0,0.01,0.70,0.86,1.04,1.07,0.92,0.72,0.47,0.25,0.16,0.24,0.38,0.50,0.47,0.33,0.07,-0.46,-1.14,-1.75,-2.33,-2.99,-3.93,-5.26,-6.74,-8.23,-9.50,-10,-10,-10,-10,-9.97,-9.63,-9.34,-9.13,-9.03,-9.02,-9.11,-9.25,-9.40,-9.55,-9.67,-9.76,-9.79,-9.78,-9.75,-9.67,-9.58,-9.47,-9.35,-9.23,-9.10,-8.98,-8.85,-8.66,-8.42,-8.11,-7.68,-7.22,-6.74,-6.30,5,4,4,2,2,2,2,2,2,2,2,3,4,4,4,5,5,6,7,8,8,9,10,10,9,8,8,9,10,9,8,7,5,5,5,5,5,5,5,5,4,3,3,2,2,2,2,2,2,2,3,4,4,5,4,3,4,4,5,5,5,4,4,4,4,4,4,4,4,4,3,3,3,4,4,3,3,3,4,5,6,5,4,3,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0.95,0.71,0.39,0.01,0.26,0.50,0.95,1.71,2.77,4.02,5.21,5.92,5.32,4.09,2.74,1.60,0.78,0.23,-0.16,-1.22,-3.62,-6.89,-10,-12,-14,-16,-17,-17,-17,-17,-17,-17,-17,-17,-17,-16,-16,-15,-15,-14,-13,-13,-13,-12,-11,-11,-10,-9.58,-9.48,-9.18,-8.58,-7.65,-6.51,-5.04,-3.29,-1.86,-1.03,-0.41,-0.01,0.13,0.12,0.07,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,2,2,2,2,2,2,2,2,2,2,2,2,3,2,2,2,2,3,3,3,3,2,2,2,2,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0.15,0.46,0.77,1.03,1.07,0.87,0.62,0.38,0.22,0.15,0.21,0.27,0.28,0.21,-0.09,-0.49,-1.38,-2.21,-2.90,-3.53,-4.18,-5.10,-6.30,-7.60,-8.90,-10,-10,-11,-10,-10,-10,-9.78,-9.40,-9.15,-9.02,-9,-9.04,-9.22,-9.37,-9.51,-9.63,-9.74,-9.78,-9.80,-9.80,-9.76,-9.68,-9.61,-9.51,-9.40,-9.28,-9.15,-9.01,-8.85,-8.62,-8.33,-7.93,-7.49,-7,-6.53,5,5,3,3,2,2,2,2,2,2,2,3,3,3,4,4,5,5,6,7,7,8,9,10,9,8,8,8,9,9,7,7,5,4,4,4,4,5,4,4,3,3,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,4,4,5,5,4,4,4,4,4,4,4,4,4,3,3,4,4,4,4,3,4,5,6,5,5,4,3,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.95,1.07,0.96,0.72,0.48,0.39,0.59,0.96,1.72,2.73,3.86,5.04,6,4.84,3.70,2.57,1.54,0.75,0.20,-0.18,-1.37,-3.85,-7.16,-10,-13,-15,-17,-17,-18,-18,-18,-18,-18,-17,-17,-17,-16,-16,-15,-14,-14,-13,-12,-12,-11,-11,-9.80,-9.74,-9.55,-9.13,-8.88,-8.36,-7.58,-6.43,-4.78,-2.96,-1.46,-0.41,0,0.15,0.14,0.09,0.01,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,0,0,0,0,0,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,2,2,2,3,3,2,2,2,2,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0.13,0.20,0.38,0.66,0.97,0.99,0.75,0.52,0.35,0.22,0.16,0.20,0.20,0.08,-0.25,-0.74,-1.83,-2.74,-3.63,-4.37,-4.97,-5.54,-6.26,-7.21,-8.28,-9.41,-10,-11,-11,-11,-10,-10,-9.87,-9.46,-9.17,-9.03,-9.02,-9.10,-9.21,-9.40,-9.55,-9.72,-9.83,-9.89,-9.93,-9.97,-9.96,-9.90,-9.86,-9.78,-9.71,-9.60,-9.47,-9.30,-9.13,-8.90,-8.63,-8.25,-7.79,-7.29,-6.79,4,4,3,3,3,2,2,2,2,3,3,3,3,3,3,4,4,4,5,6,7,8,9,10,10,9,7,8,7,7,6,6,5,4,3,3,4,4,3,3,2,2,2,2,1,1,1,1,1,1,2,2,2,2,2,2,3,4,4,4,4,4,3,3,4,4,4,4,4,4,3,3,4,5,5,4,4,4,5,6,5,5,4,4,3,2,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.01,0.83,1.07,1.49,1,0.70,0.52,0.62,1,1.64,2.53,3.50,4.37,4.91,4.16,3.22,2.27,1.39,0.67,0.14,-0.24,-1.26,-4,-7.51,-10,-13,-16,-17,-18,-18,-18,-18,-18,-18,-17,-17,-16,-16,-15,-15,-14,-13,-13,-12,-11,-11,-10,-9.64,-9.83,-9.71,-9.30,-8.78,-8.13,-7.17,-6.08,-4.60,-2.68,-1.40,-0.50,-0.03,0.13,0.12,0.07,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,2,2,2,2,2,2,2,1,1,1,2,2,2,1,1,2,2,2,3,2,3,2,2,1,1,0,0,0,0,0,0,0,0,0,0,0,0.01,0.08,0.58,0.36,0.39,0.54,0.71,0.74,0.60,0.42,0.29,0.23,0.20,0.13,-0.03,-0.43,-1,-2.23,-3.25,-4.25,-5.21,-5.91,-6.38,-6.75,-7.25,-7.93,-8.78,-9.72,-10,-11,-11,-11,-10,-10,-9.92,-9.52,-9.26,-9.14,-9.15,-9.24,-9.37,-9.53,-9.73,-9.88,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.96,-9.83,-9.66,-9.49,-9.25,-8.99,-8.63,-8.14,-7.63,-7.11,3,3,3,3,3,3,3,3,4,3,4,3,3,4,4,4,4,4,5,6,7,7,8,9,10,9,8,8,7,6,6,6,5,4,3,3,3,3,3,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,2,2,3,3,4,4,3,3,3,3,4,4,4,4,4,3,3,4,5,5,5,5,5,5,5,5,5,4,4,3,3,2,2,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.10,0.25,0.90,1.45,1.27,0.71,0.49,0.58,0.91,1.51,2.24,2.96,3.52,3.66,3.36,2.67,1.92,1.20,0.57,0.08,-0.28,-1,-4.35,-7.97,-11,-14,-16,-17,-18,-18,-18,-18,-18,-18,-17,-17,-16,-16,-15,-15,-14,-13,-12,-12,-11,-10,-10,-10,-10,-9.90,-9.38,-8.60,-7.93,-7,-5.87,-4.38,-2.67,-1.51,-0.64,-0.02,0.15,0.12,0.03,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,0,0,0,1,1,1,1,1,1,1,0,0,0,0,1,0,0,0,1,1,1,1,1,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,3,3,2,1,0.01,0,0.01,0.03,0.07,0.08,0.07,0.02,0,0,0,0.10,0.35,0.41,0.38,0.37,0.40,0.49,0.50,0.41,0.36,0.26,0.20,-0.11,-0.43,-0.98,-1.68,-2.61,-3.62,-4.73,-5.76,-6.64,-7.23,-7.54,-7.75,-8.03,-8.49,-9.11,-9.84,-10,-11,-11,-11,-10,-10,-10,-9.67,-9.47,-9.38,-9.39,-9.50,-9.63,-9.78,-9.97,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.86,-9.63,-9.36,-8.99,-8.50,-7.99,-7.46,2,2,3,3,3,3,4,4,4,5,5,4,4,4,5,5,5,5,5,6,7,7,7,9,8,8,8,9,8,8,7,7,6,5,3,3,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,3,3,3,3,3,3,3,4,4,4,4,4,3,3,4,4,5,5,7,7,6,5,5,4,4,4,4,3,3,3,2,2,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.08,0.28,0.61,0.84,0.77,0.59,0.38,0.40,0.75,1.26,1.85,2.37,2.73,2.82,2.59,2.12,1.53,0.95,0.40,-0.01,-0.40,-1,-4.98,-8.51,-11,-14,-16,-17,-18,-18,-18,-18,-18,-18,-17,-17,-16,-16,-15,-14,-14,-13,-12,-12,-11,-10,-10,-10,-10,-10,-9.46,-8.52,-7.83,-7,-5.86,-4.38,-2.66,-1.52,-0.73,-0.12,0.12,0.14,0.08,0.02,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,2,2,2,2,2,2,1,1,1,1,1,1,1,1,0,1,1,2,2,2,2,2,3,2,1,0.01,0.23,0.17,0.26,0.25,0.24,0.22,0.16,0.13,0.09,0.02,0.02,0.11,0.27,0.34,0.28,0.26,0.26,0.29,0.34,0.33,0.25,0.09,-0.34,-0.73,-1.27,-2.01,-2.92,-3.92,-4.99,-6.08,-7.02,-7.75,-8.16,-8.37,-8.42,-8.55,-8.83,-9.25,-9.80,-10,-10,-11,-11,-10,-10,-10,-9.90,-9.75,-9.68,-9.74,-9.85,-9.99,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.71,-9.33,-8.85,-8.30,-7.78,2,2,3,3,4,4,5,5,6,6,6,6,5,6,6,6,6,6,6,6,6,6,7,7,7,7,8,9,9,8,8,7,7,5,3,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,5,6,6,6,5,4,4,4,4,4,3,3,3,3,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.04,0.16,0.35,0.48,0.47,0.36,0.25,0.28,0.52,0.96,1.40,1.82,2.08,2.12,1.96,1.61,1.14,0.65,0.21,-0.18,-1,-2.23,-5.68,-9.15,-12,-15,-17,-17,-18,-18,-18,-18,-18,-18,-17,-17,-16,-15,-15,-14,-13,-13,-12,-11,-11,-11,-10,-10,-10,-10,-9.46,-8.54,-7.52,-6.76,-5.85,-4.53,-2.74,-1.55,-0.78,-0.22,0.09,0.14,0.12,0.08,0.03,0.02,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,0,0,0,1,1,1,1,1,1,1,1,2,2,2,2,2,2,1,1,1,1,1,1,1,0,0,0,1,1.71,1.76,1.65,1.33,1.22,1.11,0.87,0.28,0.24,0.20,0.16,0.13,0,0,0.09,0.20,0.28,0.16,0.08,0.07,0.09,0.15,0.21,0.21,0.17,0.21,0.23,0.22,0.11,-0.15,-0.73,-1.21,-1.76,-2.47,-3.26,-4.15,-5.13,-6.13,-7.13,-7.97,-8.51,-8.78,-8.85,-8.83,-8.85,-8.98,-9.27,-9.68,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-9.64,-9.15,-8.62,-8.11,2,2,3,4,4,5,5,6,7,8,8,7,7,7,8,7,7,7,7,7,7,6,6,6,6,7,7,9,9,7,7,7,6,5,3,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,3,3,3,3,4,4,5,4,4,4,4,4,4,4,4,5,5,5,5,4,4,3,3,4,4,3,2,2,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.01,0.09,0.16,0.24,0.25,0.17,0.12,0.16,0.36,0.65,1,1.33,1.51,1.54,1.41,1.14,0.76,0.35,-0.05,-0.63,-1.83,-3.26,-6.63,-9.87,-12,-15,-17,-17,-18,-18,-18,-18,-18,-18,-17,-17,-16,-15,-15,-14,-13,-12,-12,-11,-11,-10,-11,-10,-10,-10,-9.54,-8.77,-7.83,-6.96,-5.91,-4.51,-3.08,-1.75,-1.02,-0.46,-0.10,0.08,0.12,0.11,0.10,0.07,0.03,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,2,2,2,2,2,2,2,1,1,1,1,1,1,0,0,0,0.22,0.65,1.22,1.42,1.22,0.87,0.70,0.62,0.50,0.27,0.07,0.01,-0.13,-0.29,-0.59,-0.60,-0.36,-0.12,0.16,0.23,0.13,0.09,0.08,0.10,0.13,0.14,0.13,0.12,0.12,-0.08,-0.42,-1.24,-1.86,-2.50,-3.13,-3.80,-4.53,-5.35,-6.16,-7.04,-7.88,-8.53,-8.93,-9.11,-9.05,-8.98,-8.91,-8.97,-9.16,-9.50,-9.90,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-9.96,-9.46,-8.90,-8.38,2,3,3,5,5,5,5,7,7,8,9,9,8,8,8,8,8,7,7,7,7,7,7,7,7,6,6,7,7,6,6,6,5,4,3,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,5,5,5,4,3,3,3,3,3,2,2,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.03,0.10,0.13,0.12,0.08,0.04,0.08,0.20,0.40,0.66,0.89,1.04,1.09,0.98,0.75,0.41,0.03,-0.51,-1.41,-2.86,-4.91,-7.73,-10,-13,-15,-16,-17,-18,-18,-18,-18,-18,-18,-17,-17,-16,-15,-15,-14,-13,-12,-11,-11,-11,-11,-11,-11,-10,-10,-9.97,-9.18,-8.22,-7.24,-6.12,-4.88,-3.46,-2.17,-1.43,-0.88,-0.42,-0.15,0,0.08,0.11,0.10,0.08,0.02,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,2,2,2,2,2,2,2,2,1,1,1,1,1,0,0,0,0,0.11,0.33,0.65,0.74,0.64,0.50,0.42,0.37,0.24,-0.02,-0.28,-0.53,-0.84,-1.12,-1.41,-1.40,-1.09,-0.63,-0.17,0.12,0.15,0.12,0.11,0.11,0.09,-0.01,-0.15,-0.27,-0.38,-0.62,-1.78,-2.58,-3.27,-3.91,-4.53,-5.14,-5.76,-6.40,-7.04,-7.74,-8.38,-8.86,-9.12,-9.16,-9.10,-8.97,-8.85,-8.86,-8.99,-9.25,-9.64,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-9.75,-9.17,-8.61,2,3,4,4,4,5,5,6,7,7,8,8,8,9,9,9,8,8,7,7,7,7,7,8,8,6,6,5,6,6,5,5,5,4,3,3,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,3,3,3,4,4,4,4,4,4,4,4,5,4,4,4,4,4,4,4,3,3,3,2,2,2,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.02,0.08,0.11,0.10,0.04,-0.01,0,0.08,0.22,0.38,0.57,0.66,0.70,0.61,0.40,0.12,-0.26,-0.91,-2.16,-4.04,-6.48,-9,-11,-13,-15,-16,-17,-18,-18,-18,-18,-18,-18,-17,-17,-16,-15,-15,-14,-13,-12,-11,-11,-11,-11,-11,-11,-11,-10,-10,-9.23,-8.23,-7.22,-6.18,-5.25,-4.01,-2.86,-1.92,-1.41,-0.96,-0.59,-0.30,-0.12,0.01,0.10,0.10,0.07,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,2,2,2,2,2,2,2,2,2,2,1,1,1,1,0,0,0,0,0,0,0.11,0.25,0.38,0.40,0.36,0.26,0.12,-0.13,-0.51,-0.88,-1.21,-1.53,-1.85,-2.02,-1.98,-1.66,-1.24,-0.43,0.10,0.23,0.14,0.07,-0.08,-0.37,-0.63,-0.97,-1.29,-1.75,-2.43,-3.35,-4.11,-4.75,-5.33,-5.87,-6.37,-6.85,-7.33,-7.77,-8.27,-8.73,-9.03,-9.17,-9.16,-9.03,-8.88,-8.72,-8.64,-8.78,-9.03,-9.39,-9.80,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-10,-10,-10,-9.43,-8.84,3,3,3,3,4,4,5,6,6,7,7,7,8,9,11,10,9,8,8,7,7,7,7,7,7,7,5,5,5,5,5,5,4,4,4,4,3,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,3,3,3,3,3,4,4,4,5,5,4,5,6,5,5,5,4,4,4,4,4,4,3,2,2,2,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.01,0.07,0.10,0.10,0.04,0,-0.03,-0.02,0.03,0.15,0.28,0.37,0.39,0.33,0.12,-0.25,-0.79,-1.72,-3.34,-5.65,-8.05,-10,-12,-14,-15,-16,-17,-18,-18,-18,-18,-18,-18,-17,-17,-16,-15,-15,-14,-13,-12,-11,-11,-11,-11,-11,-11,-11,-10,-9.91,-8.96,-8.01,-7.25,-6.36,-5.37,-4.49,-3.49,-2.50,-1.97,-1.54,-1.14,-0.78,-0.47,-0.17,0.01,0.11,0.11,0.01,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,0,1,1,1,1,2,2,2,3,3,2,2,2,2,2,2,1,1,1,0,0,0,0,0,0,0.02,0.07,0.20,0.23,0.22,0.16,0.08,-0.18,-0.63,-1.11,-1.49,-1.83,-2.13,-2.37,-2.47,-2.37,-1.99,-1.33,-0.53,0.01,0.21,-0.09,-0.29,-0.66,-1.13,-1.76,-2.35,-2.90,-3.62,-4.39,-5.11,-5.66,-6.14,-6.60,-7,-7.38,-7.73,-8.08,-8.39,-8.75,-9.03,-9.23,-9.25,-9.15,-8.99,-8.77,-8.61,-8.50,-8.58,-8.87,-9.23,-9.63,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-10,-10,-9.68,-9.10,4,3,3,3,3,4,5,5,5,5,6,7,8,10,11,11,10,9,8,7,7,7,6,6,6,5,5,5,5,5,4,4,4,4,5,4,3,3,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,3,3,3,3,4,3,3,4,5,5,4,4,5,6,5,5,5,4,4,4,4,4,4,5,4,3,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.01,0.07,0.10,0.10,0.07,0,-0.05,-0.09,-0.05,0,0.08,0.13,0.14,0.08,-0.35,-1.16,-2.33,-3.80,-5.66,-7.67,-9.71,-11,-13,-14,-16,-17,-17,-18,-18,-18,-18,-18,-18,-18,-17,-16,-16,-15,-14,-13,-12,-11,-11,-11,-11,-11,-11,-11,-10,-9.86,-8.98,-8.13,-7.41,-6.60,-5.63,-4.88,-3.86,-3.04,-2.40,-2.11,-1.75,-1.36,-0.90,-0.48,-0.12,0.11,0.15,0.04,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,3,3,3,3,2,2,2,2,2,1,1,0,0.11,0,0,0,0,0.04,0.12,0.15,0.15,0.09,-0.01,-0.14,-0.38,-0.76,-1.25,-1.71,-2.24,-2.87,-3.26,-3.33,-3.03,-2.73,-2.30,-1.73,-1.13,-0.73,-0.63,-0.88,-1.34,-1.97,-2.71,-3.42,-4.13,-4.77,-5.49,-6.27,-6.72,-7.12,-7.38,-7.64,-7.90,-8.15,-8.41,-8.68,-8.93,-9.17,-9.37,-9.42,-9.38,-9.22,-8.99,-8.75,-8.59,-8.48,-8.50,-8.73,-9.12,-9.52,-9.92,-10,-10,-10,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-13,-13,-13,-13,-13,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-10,-9.92,-9.37,5,4,3,4,3,3,4,4,4,5,5.01,7,8.10,9.12,9.89,10.09,9.87,8.98,7.92,6.98,6,6,6,5,5,5,5,5,5,4,4,3,4,4,3,3,3,3,3,3,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,3,3,4,3,3,3,3,3,4,4,4,4,4,5,5,5,5,5,4,4,4,4,5,6,6,4,3,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.01,0.07,0.10,0.11,0.08,0,-0.09,-0.13,-0.14,-0.12,-0.09,-0.04,-0.04,-0.30,-1.40,-2.64,-4.13,-5.80,-7.63,-9.50,-11,-12,-14,-15,-16,-17,-17,-18,-18,-18,-18,-18,-18,-18,-17,-16,-16,-15,-14,-13,-12,-12,-11,-11,-11,-11,-11,-11,-10,-9.88,-9.24,-8.51,-7.65,-6.96,-6.18,-5.43,-4.42,-3.61,-2.85,-2.52,-2.25,-1.87,-1.37,-0.83,-0.28,0.09,0.22,0.11,0.03,0.03,0.11,0.12,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,3,3,3,3,3,2,2,2,2,1,1,0.98,0.26,0,0,0,0.09,0.12,0.17,0.23,0.12,-0.04,-0.27,-0.50,-0.75,-1.03,-1.42,-2.12,-3.12,-4.18,-4.86,-5.10,-5.02,-4.65,-4.08,-3.35,-2.65,-2.04,-1.77,-2.14,-2.88,-3.42,-4.04,-4.68,-5.30,-5.92,-6.52,-7.12,-7.68,-8,-8.24,-8.35,-8.46,-8.59,-8.75,-8.97,-9.21,-9.40,-9.60,-9.68,-9.67,-9.55,-9.35,-9.09,-8.84,-8.64,-8.55,-8.58,-8.75,-9.08,-9.50,-9.90,-10,-10,-11,-11,-11,-11,-12,-12,-12,-12,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-12,-12,-12,-12,-12,-11,-11,-10,-10,-9.60,7,6,5,5,4,4,4,4,4,5.07,6.11,7.14,8.83,9.11,9.21,9.87,9.86,9.14,7.85,6.11,5.07,5,5,4,4,5,5,5,5,4,4,4,4,3,3,3,3,3,3,3,3,3,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,3,4,4,3,3,3,3,3,3,4,4,3,4,4,5,5,5,5,5,5,5,5,6,7,7,6,3,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.02,0.08,0.12,0.14,0.11,0.02,-0.09,-0.15,-0.21,-0.21,-0.18,-0.17,-0.27,-1.42,-2.73,-4.13,-5.79,-7.58,-9.43,-11,-12,-13,-15,-15,-16,-17,-18,-18,-18,-18,-19,-19,-18,-18,-17,-17,-16,-15,-14,-13,-13,-12,-12,-11,-11,-11,-10,-10,-10,-9.85,-9.25,-8.62,-8.12,-7.50,-6.76,-5.96,-4.97,-4.24,-3.38,-2.80,-2.60,-2.25,-1.76,-1.16,-0.50,0.02,0.24,0.15,0.08,0.08,0.20,0.87,1,1,0,0,0,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,3,4,4,4,3,3,2,2,1,1,0.99,0.70,0.34,0,0.12,0.20,0.14,0.20,0.25,0.22,-0.12,-0.47,-0.78,-1.12,-1.63,-2.14,-3,-4.23,-5.48,-6.60,-7.05,-7.09,-6.89,-6.35,-5.59,-4.75,-4.05,-3.72,-3.99,-4.50,-5.05,-5.63,-6.15,-6.66,-7.17,-7.66,-8.11,-8.50,-8.80,-8.91,-9,-8.99,-9,-9.05,-9.17,-9.37,-9.61,-9.80,-9.97,-10,-9.96,-9.77,-9.53,-9.25,-9,-8.80,-8.72,-8.74,-8.88,-9.15,-9.51,-9.92,-10,-10,-11,-11,-11,-12,-12,-12,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-12,-12,-12,-12,-11,-10,-10,-9.80,9,7,6,5,5,4,4,4,5.07,5.87,6.83,7.78,8.75,9.75,9.25,10.21,10.75,9.75,7.78,5.83,4.12,4.02,4,3,3,4,4,4,5,4,4,4,4,4,4,4,4,4,4,4,4,4,3,2,2,1,1,1,1,1,1,1,1,1,1,1,1,2,2,3,4,4,3,3,4,3,3,3,3,3,2,3,4,5,5,5,5,5,6,6,7,7,8,8,6,4,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.01,0.11,0.17,0.23,0.20,0.10,-0.04,-0.16,-0.25,-0.27,-0.27,-0.98,-2.22,-3.12,-4.38,-5.76,-7.35,-9.08,-10,-12,-13,-14,-15,-16,-17,-17,-18,-18,-18,-19,-19,-19,-18,-18,-17,-17,-16,-15,-14,-14,-13,-13,-12,-11,-11,-11,-10,-10,-10,-9.73,-9.50,-9.21,-8.85,-8.14,-7.29,-6.46,-5.77,-5.02,-4,-3.13,-2.79,-2.54,-2.13,-1.51,-0.83,-0.10,0.17,0.20,0.12,0.09,0.20,0.87,1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,3,4,5,4,4,3,3,2,1,1,0.99,0.76,0.53,0.35,0.39,0.25,0.03,0.07,0.09,-0.08,-0.53,-0.97,-1.43,-2.34,-3.03,-4.04,-5.16,-6.42,-7.86,-8.50,-8.93,-8.96,-8.55,-7.90,-7.13,-6.35,-5.87,-5.98,-6.30,-6.80,-7.38,-7.88,-8.25,-8.59,-8.88,-9.14,-9.37,-9.50,-9.60,-9.50,-9.43,-9.38,-9.36,-9.38,-9.49,-9.66,-9.91,-10,-10,-10,-10,-10,-9.75,-9.47,-9.21,-9.01,-8.91,-8.92,-9.08,-9.30,-9.65,-10,-10,-10,-11,-11,-12,-12,-12,-13,-13,-13,-13,-13,-14,-14,-14,-14,-14,-13,-13,-13,-13,-13,-13,-13,-13,-12,-12,-12,-11,-11,-10,-10,7,6,5,5,5,5,5,5.07,6,6.82,7.23,8.11,8.91,9.70,10.20,10.67,11.70,9.71,7.21,5.16,3.17,3.12,3.07,3,3,3,3,4,4,4,4,4,4,4,4,5,5,5,5,5,4,4,4,3,2,2,1,1,1,1,1,1,1,1,1,1,1,1,2,2,3,3,3,3,3,3,3,2,2,2,2,2,3,4,4,4,5,5,7,7,8,9,9,8,7,4,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.13,0.27,0.37,0.33,0.22,0.04,-0.13,-0.25,-0.36,-1.88,-3.09,-3.78,-4.79,-5.92,-7.25,-8.72,-10,-11,-13,-14,-15,-16,-16,-17,-17,-18,-18,-18,-18,-19,-19,-18,-18,-17,-17,-16,-15,-15,-14,-14,-13,-12,-11,-11,-11,-10,-10,-10,-9.92,-9.85,-9.61,-9.34,-8.74,-7.79,-7.09,-6.48,-5.63,-4.66,-3.72,-2.96,-2.74,-2.42,-1.90,-1.21,-0.46,0.10,0.21,0.13,0.07,0.11,0.12,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,3,3,4,4,4,4,4,3,2,1,0.99,0.98,0.87,0.75,0.38,0.22,-0.16,-0.35,-0.41,-0.43,-0.63,-1.38,-2.04,-2.99,-3.84,-4.75,-5.84,-7,-8.24,-9.41,-10,-10,-10,-9.86,-9.24,-8.50,-7.88,-7.73,-7.91,-8.41,-9.04,-9.59,-9.97,-10,-10,-10,-10,-10,-10,-10,-9.78,-9.65,-9.58,-9.52,-9.55,-9.66,-9.88,-10,-10,-10,-10,-10,-10,-9.91,-9.64,-9.40,-9.23,-9.13,-9.14,-9.27,-9.50,-9.85,-10,-10,-11,-11,-11,-12,-12,-13,-13,-13,-13,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-13,-13,-13,-13,-13,-13,-12,-12,-11,-11,-10,-10,6,5,5,6,7,6,6.01,6.11,7.16,7.98,8.26,8.29,8.79,9.64,10.15,11.63,10.64,8.65,6.29,4.26,3.23,3.03,3,3,3,3,3,3,3,3,3,3,3,4,4,5,5,5,5,5,4,4,4,3,3,2,2,1,1,1,1,1,1,1,1,1,1,1,2,2,3,3,3,3,4,3,2,2,2,2,2,2,2,3,3,4,4,5,5,6,7,8,8,7,6,4,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.17,0.42,0.57,0.54,0.40,0.16,-0.09,-0.29,-1.11,-3.47,-4.37,-5.25,-6.23,-7.35,-8.58,-9.90,-11,-12,-13,-15,-15,-16,-17,-17,-17,-18,-18,-18,-18,-18,-18,-18,-18,-17,-17,-16,-15,-15,-14,-14,-13,-12,-11,-10,-10,-10,-10,-10,-10,-10,-10,-9.83,-9.24,-8.48,-7.87,-7.27,-6.39,-5.21,-4.25,-3.33,-2.89,-2.64,-2.34,-1.64,-0.75,-0.04,0.25,0.14,0.02,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,3,3,3,3,4,4,4,3,2,1,0.99,0.98,0.98,0.72,0.22,-0.37,-0.73,-0.96,-1.08,-1.35,-2.02,-2.75,-3.65,-4.60,-5.50,-6.42,-7.40,-8.48,-9.58,-10,-11,-11,-11,-10,-10,-9.51,-9.12,-9.12,-9.48,-10,-10,-11,-11,-11,-11,-11,-10,-10,-10,-10,-9.86,-9.72,-9.63,-9.60,-9.63,-9.76,-9.98,-10,-10,-10,-10,-10,-10,-10,-9.79,-9.59,-9.42,-9.36,-9.37,-9.49,-9.72,-10,-10,-10,-11,-11,-12,-12,-12,-13,-13,-13,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-13,-13,-13,-13,-12,-12,-12,-11,-10,-10,5,5,6,8,7,8,7.07,7.89,8.78,9.74,9.70,9.17,8.36,8.37,9.85,10.62,9.62,7.63,5.34,3.29,3.17,3.01,3,3,3,4,4,2,2,2,2,2,2,3,3,4,4,5,6,5,4,4,4,4,3,3,2,1,1,1,1,1,1,1,1,1,1,1,2,2,2,3,3,4,3,2,2,1,1,1,1,1,1,2,3,3,3,4,4,4,5,6,6,5,5,3,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.29,0.64,0.87,0.87,0.65,0.33,-0.04,-0.36,-2.08,-4.25,-5.22,-6.34,-7.43,-8.55,-9.73,-10,-12,-13,-14,-15,-16,-16,-17,-17,-17,-17,-18,-18,-18,-18,-18,-18,-17,-17,-16,-16,-16,-15,-14,-14,-13,-12,-11,-10,-10,-9.66,-9.53,-9.77,-10,-10,-10,-10,-9.88,-9.33,-8.61,-7.90,-6.89,-5.78,-4.85,-3.75,-2.99,-2.85,-2.50,-1.84,-0.99,-0.13,0.22,0.12,0.02,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,3,3,3,3,3,3,3,2,2,1,0.99,0.98,0.72,0.23,-0.41,-0.96,-1.38,-1.63,-2.02,-2.59,-3.35,-4.27,-5.25,-6.18,-7.05,-7.88,-8.72,-9.58,-10,-11,-11,-11,-11,-11,-10,-10,-9.92,-10,-10,-11,-11,-12,-12,-12,-11,-11,-10,-10,-10,-9.91,-9.74,-9.63,-9.58,-9.58,-9.63,-9.77,-9.98,-10,-10,-10,-10,-10,-10,-10,-9.90,-9.74,-9.60,-9.53,-9.55,-9.68,-9.92,-10,-10,-11,-11,-11,-12,-12,-13,-13,-13,-14,-14,-14,-14,-14,-15,-15,-15,-14,-14,-14,-14,-14,-14,-14,-13,-13,-13,-13,-12,-12,-11,-11,-10,5,5,6,7,8,8,8.89,9.16,10.24,11.71,11.03,10.26,9.37,9.13,9.34,9.60,8.60,6.62,4.36,3.34,3.07,3,3,3,3,4,3,2,2,2,2,2,2,2,2,3,3,4,5,4,4,4,4,3,3,2,2,1,1,1,1,1,1,1,1,1,1,1,2,2,2,3,4,3,3,2,2,1,1,1,1,1,1,1,2,2,2,2,3,3,4,4,4,3,3,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.50,0.97,1.26,1.27,1,0.51,0,-0.41,-2.23,-4.15,-5.68,-7.13,-8.41,-9.62,-10,-11,-12,-13,-14,-15,-16,-16,-17,-17,-17,-17,-17,-17,-17,-17,-17,-17,-17,-17,-16,-16,-16,-15,-14,-14,-13,-12,-11,-10,-9.67,-9.24,-9.15,-9.78,-10,-10,-11,-11,-10,-10,-9.35,-8.61,-7.52,-6.42,-5.35,-4.13,-3.15,-2.87,-2.55,-1.97,-1.15,-0.35,0.11,0.12,0.04,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,3,3,3,3,3,2,2,2,1,1,0.98,0.75,0.25,-0.43,-1,-1.48,-1.91,-2.39,-3,-3.79,-4.75,-5.76,-6.75,-7.65,-8.43,-9.11,-9.72,-10,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-11,-11,-12,-12,-12,-12,-12,-11,-10,-10,-9.87,-9.63,-9.51,-9.47,-9.46,-9.50,-9.58,-9.72,-9.89,-10,-10,-10,-10,-10,-10,-10,-9.98,-9.84,-9.74,-9.64,-9.72,-9.87,-10,-10,-10,-11,-11,-12,-12,-13,-13,-13,-14,-14,-14,-14,-15,-15,-15,-15,-15,-15,-15,-14,-14,-14,-14,-14,-14,-13,-13,-13,-12,-12,-11,-11,-10,6,6,7,8,9,10,10.12,11,11.87,12.70,12.64,11.70,10.39,9.41,9.22,8.58,7.25,5.60,4.17,3.33,3.03,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,2,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,3,3,3,3,2,2,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.16,0.75,1.32,1.75,1.76,1.37,0.75,0.09,-0.47,-1.50,-3.77,-5.80,-7.63,-9.21,-10,-11,-12,-13,-14,-15,-15,-16,-16,-17,-17,-17,-17,-17,-17,-17,-17,-17,-17,-17,-17,-16,-16,-16,-15,-14,-14,-13,-12,-11,-10,-9.42,-8.75,-9.03,-9.83,-10,-11,-11,-11,-11,-10,-9.75,-8.93,-8.08,-7.13,-5.88,-4.42,-3.29,-2.88,-2.58,-2.04,-1.35,-0.61,-0.09,0.12,0.09,0.01,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,3,3,3,3,2,2,1,1,1,1,0.75,0.27,-0.41,-1,-1.55,-2.08,-2.60,-3.22,-4.02,-5.01,-6.11,-7.21,-8.18,-9.01,-9.63,-10,-10,-10,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-11,-11,-12,-12,-12,-12,-11,-11,-10,-9.86,-9.50,-9.30,-9.24,-9.25,-9.28,-9.37,-9.48,-9.62,-9.77,-9.96,-10,-10,-10,-10,-10,-10,-10,-9.97,-9.89,-9.87,-9.92,-10,-10,-10,-11,-11,-11,-12,-12,-13,-13,-13,-14,-14,-14,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-14,-14,-14,-14,-13,-13,-13,-13,-12,-11,-11,-10,8,8,8,9,10,11,11.87,12.78,13.25,14.03,14.63,13.25,11.95,10.65,9.27,7.78,6.12,4.39,3.37,3.17,3.01,3,3,3,3,3,4,3,3,2,2,2,2,2,2,2,2,2,3,2,2,2,2,2,3,2,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,3,4,3,3,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.37,0.97,1.65,2.24,2.27,1.78,1.01,0.21,-0.48,-0.97,-3.51,-5.78,-7.96,-9.83,-11,-12,-13,-14,-14,-15,-15,-16,-16,-16,-16,-16,-16,-16,-16,-16,-16,-16,-17,-17,-17,-17,-16,-16,-15,-14,-14,-13,-12,-11,-10,-9.13,-8.46,-8.87,-9.87,-10,-11,-11,-11,-11,-10,-9.79,-9.11,-8.43,-7.51,-6.29,-4.68,-3.42,-2.88,-2.62,-2.17,-1.54,-0.84,-0.22,0.11,0.11,0,0,0,0,0,0,0,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,3,3,3,3,2,1,1,0,1,1,0.52,-0.25,-0.97,-1.63,-2.24,-2.79,-3.39,-4.13,-5.10,-6.21,-7.39,-8.51,-9.51,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-11,-11,-11,-12,-12,-11,-11,-10,-9.99,-9.43,-9.13,-9.01,-9,-9.02,-9.13,-9.24,-9.36,-9.50,-9.65,-9.80,-9.96,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-12,-12,-12,-13,-13,-14,-14,-14,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-14,-14,-14,-14,-13,-13,-13,-12,-12,-11,-10,9,9,9,10,10,11,12.87,13.95,15.74,15.03,15.63,14.62,13.60,11.58,9.58,7.07,5.23,3.39,3.22,3.03,3,3,3,3,3,3,4,5,4,3,2,2,2,2,2,2,2,2,1.97,1.92,1.89,1.87,1.88,2.12,2.12,2,1.07,1.02,1,1,1,1,1,1,2,1,1,1,1,1,1,2,2,3,4,4,3,2,2,1,1,0,0,0,1,1,1,0,0,0,0.02,0.91,0.89,0.87,0.12,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.40,1.12,1.96,2.75,2.87,2.23,1.27,0.29,-0.48,-1.04,-3.38,-5.79,-8.13,-10,-11,-12,-13,-14,-15,-15,-16,-16,-16,-16,-16,-16,-16,-15,-15,-16,-16,-16,-17,-17,-17,-17,-16,-16,-15,-14,-13,-12,-11,-10,-9.79,-8.88,-8.39,-8.64,-9.88,-10,-11,-11,-11,-11,-10,-9.80,-9.23,-8.55,-7.64,-6.41,-4.88,-3.51,-2.96,-2.74,-2.35,-1.74,-1,-0.24,0.13,0.12,0.01,0,0,0,0,0,0,0,1,1,1,1,2,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,2,2,3,3,3,3,2,1.99,1.02,0.04,0.07,0.92,0.92,0.38,-0.80,-1.66,-2.43,-3.10,-3.72,-4.36,-5.14,-6.13,-7.28,-8.50,-9.67,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-10,-10,-9.61,-9.14,-8.89,-8.79,-8.80,-8.88,-8.98,-9.11,-9.25,-9.38,-9.53,-9.68,-9.84,-9.97,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-12,-12,-13,-13,-13,-14,-14,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-14,-14,-14,-14,-13,-13,-13,-12,-12,-11,-10,11,10,10,11,12,12,13.12,15.79,15.75,15.70,14.77,14.62,12.75,10.84,8.41,6.41,4.41,3.39,3.08,3,3,3,3.12,3.12,3,4,4,5,4,4,3,2,2,2,2,2,2,1.07,1.11,1.13,1.16,1.20,2,2.20,2.79,2.16,2,1.88,1.07,1,1,1,1,1,1,1,1,1,1,1,1,2,3,3,3,3,2,2,1,1,1,0,0,0,0,0,0,0,0,0,0.11,0.13,0.16,0.20,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.47,1.23,2.22,3.11,3.34,2.62,1.52,0.40,-0.48,-1.13,-3.38,-5.78,-8.22,-10,-12,-13,-14,-14,-15,-15,-16,-16,-16,-16,-15,-15,-15,-15,-15,-15,-16,-16,-16,-17,-17,-16,-16,-15,-15,-14,-13,-12,-11,-10,-9.38,-8.83,-8.38,-8.61,-9.89,-10,-11,-11,-11,-11,-10,-9.92,-9.09,-8.41,-7.50,-6.24,-4.97,-3.58,-3,-2.86,-2.58,-1.93,-1.08,-0.18,0.21,0.15,0.03,0,0,0,0,0,0,0,0,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,3,3,3,3,3,2,1.22,0.85,0.46,0.37,0.32,-0.27,-0.83,-1.64,-2.62,-3.40,-4.11,-4.75,-5.39,-6.15,-7.11,-8.22,-9.39,-10,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-9.92,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.75,-9.34,-8.99,-8.78,-8.71,-8.72,-8.78,-8.89,-9.02,-9.14,-9.30,-9.47,-9.63,-9.78,-9.93,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-12,-12,-13,-13,-14,-14,-14,-15,-15,-15,-15,-15,-16,-16,-16,-15,-15,-15,-15,-15,-15,-14,-14,-14,-14,-13,-13,-12,-12,-11,-10,12,12,11,12,13,14,13.99,14.83,14.75,14.16,13.82,13.63,11.95,10.14,8.16,5.39,4.39,3.37,3.08,3,3,3.01,3.16,3.89,4,4,5,5,5,4,3,3,3,2,2,2,1.92,1.12,1.16,1.21,1.24,1.78,2.23,2.86,3.74,3.16,2.78,2.16,1.87,1.07,1,1,1,1,1,1,1,1,1,1,1,2,3,3,3,2,2,1,1,1,1,1,0,0,0,0,0,0,0,0.01,0.01,0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.57,1.41,2.49,3.46,3.82,3.04,1.86,0.59,-0.46,-1.22,-3.35,-5.68,-8.05,-10,-12,-13,-14,-14,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-14,-15,-15,-16,-16,-16,-16,-16,-16,-15,-14,-13,-12,-11,-10,-9.83,-9.05,-8.75,-8.42,-8.52,-9.58,-10,-11,-11,-11,-11,-10,-10,-9.16,-8.18,-7.05,-5.98,-4.87,-3.51,-3,-2.96,-2.68,-2.05,-1.12,-0.17,0.25,0.20,0.08,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,3,4,3,3,2.07,1.66,1.14,0.73,0.42,0.09,-0.50,-1.10,-1.87,-2.77,-3.64,-4.46,-5.14,-5.77,-6.39,-7.11,-7.96,-8.96,-10,-11,-11,-11,-12,-11,-11,-11,-11,-11,-10,-10,-10,-10,-9.92,-9.80,-9.85,-9.96,-10,-10,-10,-10,-10,-10,-9.83,-9.48,-9.15,-8.91,-8.76,-8.71,-8.72,-8.77,-8.88,-9.02,-9.14,-9.30,-9.50,-9.67,-9.87,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-12,-12,-12,-13,-13,-14,-14,-15,-15,-15,-15,-15,-16,-16,-16,-16,-16,-16,-15,-15,-15,-15,-14,-14,-14,-14,-13,-13,-12,-12,-11,-10,14,13,13,14,14.97,14.91,13.84,13.26,13.32,13,12.41,12.08,11.25,9.89,8.23,6.62,4.90,3.36,3.16,3.01,3,3.02,3.14,3.92,5,4,5,6,6,5,5,4,4,3,3,2.07,1.88,1.82,1.76,1.77,1.99,2.29,2.67,3.21,3.70,3.73,3.74,2.87,2.17,1.87,1.07,1,2,3,1,1,1,1,1,1,1,2,4,4,3,2,1,1,1,1,1,1,1,0,0,0,0,0.07,0.12,0.20,0.12,0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.91,1.77,2.89,3.85,4.33,3.63,2.34,0.89,-0.34,-1.24,-3.15,-5.43,-7.76,-10,-11,-13,-14,-14,-15,-15,-15,-15,-15,-15,-15,-14,-14,-14,-14,-15,-15,-16,-16,-16,-16,-16,-15,-14,-13,-13,-11,-11,-10,-9.42,-9.11,-8.83,-8.48,-8.48,-9.36,-10,-11,-11,-11,-11,-10,-9.91,-8.92,-7.91,-6.76,-5.65,-4.52,-3.42,-3,-2.91,-2.63,-2,-1.10,-0.25,0.20,0.23,0.11,0.01,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,3,3,3,3,2.07,1.78,1.32,0.92,0.52,0.07,-0.50,-1.23,-2,-2.93,-3.85,-4.74,-5.51,-6.17,-6.75,-7.29,-7.91,-8.64,-9.49,-10,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-9.98,-9.79,-9.68,-9.68,-9.73,-9.84,-9.92,-9.99,-9.99,-9.90,-9.75,-9.54,-9.30,-9.10,-8.91,-8.80,-8.76,-8.78,-8.87,-8.97,-9.11,-9.22,-9.39,-9.60,-9.78,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-12,-12,-13,-13,-13,-14,-14,-15,-15,-15,-15,-16,-16,-16,-16,-16,-16,-16,-15,-15,-15,-15,-15,-14,-14,-14,-13,-13,-12,-12,-11,-10,14,15,14,13.95,13.99,13.85,13.21,12.29,12.37,12.26,11.47,11.49,10.97,9.89,8.59,6.91,5.64,4.03,3.27,3.03,3,3.04,3.21,3.86,4.12,4.87,5.11,5.89,5.92,5.98,6,6,5,4,3.02,2.11,2.12,2.01,2.11,2.29,2.66,2.87,3.12,3.36,3.87,4.16,3.97,3.26,2.87,2.83,2.10,2.02,3,3,2,1,1,1,1,1,1,2,3,4,3,2,1.01,1.07,1.10,1.12,1.12,1.12,1.12,1.10,1.07,1.01,1.02,1.11,1.16,0.89,0.26,0.16,0.02,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1.46,2.40,3.51,4.49,5.09,4.39,2.92,1.33,-0.12,-1.17,-2.87,-5.05,-7.28,-9.47,-11,-12,-13,-14,-15,-15,-15,-15,-15,-15,-14,-14,-14,-14,-14,-15,-15,-16,-16,-16,-16,-15,-15,-14,-13,-12,-11,-10,-10,-9.52,-9.35,-9.08,-8.73,-8.71,-9.48,-10,-10,-11,-11,-10,-10,-9.33,-8.39,-7.61,-6.62,-5.29,-4.15,-3.26,-2.99,-2.87,-2.50,-1.85,-0.97,-0.21,0.21,0.24,0.12,0.01,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,3,3,3,2.99,1.98,1.40,1.01,0.64,0.16,-0.46,-1.24,-2.04,-3,-3.91,-4.85,-5.72,-6.47,-7.05,-7.58,-8.05,-8.59,-9.16,-9.86,-10,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-9.80,-9.65,-9.55,-9.53,-9.53,-9.60,-9.64,-9.68,-9.67,-9.63,-9.51,-9.38,-9.23,-9.09,-8.99,-8.91,-8.90,-8.93,-9,-9.11,-9.24,-9.37,-9.54,-9.75,-9.93,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-12,-12,-13,-13,-14,-14,-14,-15,-15,-15,-16,-16,-16,-16,-16,-16,-16,-16,-16,-15,-15,-15,-15,-14,-14,-14,-13,-13,-12,-12,-11,-10,14,14,13.91,13.87,13.17,13.21,12.95,12.33,12.34,12.09,11.79,11.54,11.50,9.87,8.54,6.65,5.21,4.03,3.25,3.04,3.01,3.08,3.22,3.20,4.12,4.78,5.20,5.16,5.99,6.11,6.92,7,7,5,3.92,2.88,2.21,2.25,2.29,2.87,3.16,3.62,3.37,3.73,4.35,4.75,4.65,3.98,3.25,2.78,2.13,2.92,4,3,2,2,1,1,1,1,1,1,2,3,3,2,1.11,1.13,1.83,2,2.12,2.20,2.20,2.83,2.87,2.98,2.95,2.86,2.78,1.90,1.15,0.34,0.17,0.02,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,2.24,3.23,4.29,5.29,5.84,5.14,3.49,1.72,0.12,-1.05,-2.51,-4.63,-6.78,-8.86,-10,-12,-13,-14,-14,-15,-15,-15,-14,-14,-14,-14,-14,-14,-14,-14,-15,-15,-15,-16,-15,-15,-14,-14,-13,-12,-11,-10,-9.92,-9.67,-9.50,-9.25,-8.89,-9.02,-9.52,-9.97,-10,-10,-10,-10,-9.79,-8.87,-8.09,-7.17,-6.14,-5,-3.78,-3.13,-2.98,-2.78,-2.33,-1.55,-0.67,-0.02,0.25,0.23,0.11,0.01,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,3,3,2.20,1.61,1.08,0.70,0.27,-0.33,-1.13,-2.01,-2.97,-3.91,-4.86,-5.75,-6.54,-7.24,-7.77,-8.23,-8.63,-9.04,-9.52,-10,-10,-10,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-9.83,-9.64,-9.50,-9.41,-9.38,-9.38,-9.40,-9.43,-9.48,-9.48,-9.42,-9.37,-9.28,-9.21,-9.13,-9.09,-9.08,-9.09,-9.13,-9.22,-9.29,-9.40,-9.55,-9.74,-9.90,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-12,-12,-13,-13,-14,-14,-14,-15,-15,-15,-16,-16,-16,-16,-16,-16,-16,-16,-16,-15,-15,-15,-15,-14,-14,-14,-13,-13,-12,-12,-11,-10,14,13.95,13.12,13.17,13.23,13.26,13.12,12.87,12.61,12.23,11.90,11.62,11.49,9.57,7.79,6.14,4.29,3.84,3.26,3.10,3.08,3.11,3.15,3.25,4.13,4.79,5.25,5.78,6.21,6.83,7.11,7.07,7,6,4.10,3.16,2.77,2.28,2.76,3.63,3.61,3.39,3.40,4.39,5.21,5.61,5.63,4.66,3.28,3.13,3.16,3.10,4,4,3,2,2,2,2,2,1,1,2,2,2.92,2,1.16,1.88,2.75,2.87,3.22,3.73,3.99,4.24,4.78,4.83,4.76,4.75,4.14,3.28,2.25,1.29,0.38,0.17,0.02,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,2,3.13,4.14,5.02,6,6.39,5.61,3.85,1.98,0.29,-0.92,-2.14,-4.22,-6.33,-8.36,-10,-11,-13,-13,-14,-14,-15,-14,-14,-14,-14,-14,-13,-13,-14,-14,-15,-15,-15,-15,-15,-15,-14,-14,-13,-11,-10,-10,-9.86,-9.75,-9.59,-9.30,-9.13,-9.15,-9.50,-9.88,-10,-10,-10,-9.78,-9.17,-8.38,-7.48,-6.62,-5.75,-4.71,-3.58,-3,-2.97,-2.75,-2.16,-1.29,-0.37,0.16,0.25,0.15,0.07,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,3,1.78,1.09,0.75,0.42,-0.08,-0.88,-1.88,-2.87,-3.84,-4.79,-5.68,-6.53,-7.25,-7.87,-8.27,-8.67,-9.04,-9.40,-9.77,-10,-10,-10,-11,-11,-11,-11,-10,-10,-10,-10,-10,-9.83,-9.63,-9.48,-9.37,-9.28,-9.25,-9.27,-9.28,-9.29,-9.34,-9.35,-9.34,-9.29,-9.25,-9.23,-9.21,-9.22,-9.24,-9.28,-9.36,-9.43,-9.52,-9.64,-9.77,-9.92,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-12,-12,-13,-13,-14,-14,-14,-15,-15,-15,-16,-16,-16,-16,-16,-16,-16,-16,-16,-15,-15,-15,-15,-14,-14,-14,-13,-13,-12,-12,-11,-10,13.02,13.11,13.17,13.23,13.76,13.86,13.65,13.28,12.78,12.36,11.97,11.51,10.50,8.96,7.17,5.38,4.29,3.85,3.27,3.23,3.12,3.15,3.28,3.83,4.32,5.12,5.75,6.24,6.75,7.22,7.82,7.87,7.07,7,5,3.79,3.12,2.89,3.01,3.35,3.39,3.92,4.41,5.58,6.21,6.60,5.62,4.35,3.29,3.79,4,4.12,4,5,3,3,3,3,3,2,2,2,1,2.04,2.12,2,2,2.26,2.99,3.67,4.24,5,5.67,5.98,6,6.11,6.25,6.66,5.70,4.75,3.66,2.38,1.29,0.41,0.15,0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,3,4.83,4.79,5.51,6.33,6.60,5.77,3.99,2.10,0.40,-0.78,-1.78,-3.83,-5.92,-7.96,-9.86,-11,-12,-13,-14,-14,-14,-14,-14,-14,-13,-13,-13,-13,-14,-14,-14,-15,-15,-15,-15,-15,-14,-13,-12,-11,-10,-10,-9.86,-9.75,-9.54,-9.28,-9.18,-9.26,-9.41,-9.76,-9.97,-10,-9.75,-9.16,-8.47,-8.02,-7.30,-6.54,-5.53,-4.37,-3.41,-3,-2.97,-2.72,-2.08,-1.13,-0.23,0.21,0.23,0.11,0.02,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1.16,0.64,0.46,0.16,-0.64,-1.65,-2.65,-3.68,-4.67,-5.62,-6.48,-7.24,-7.87,-8.34,-8.75,-9.09,-9.38,-9.65,-9.93,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.79,-9.62,-9.46,-9.33,-9.24,-9.18,-9.16,-9.17,-9.22,-9.24,-9.25,-9.26,-9.28,-9.27,-9.27,-9.28,-9.30,-9.36,-9.41,-9.50,-9.59,-9.67,-9.77,-9.88,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-12,-12,-12,-13,-13,-14,-14,-14,-15,-15,-15,-16,-16,-16,-16,-16,-16,-16,-16,-15,-15,-15,-15,-15,-14,-14,-14,-13,-13,-12,-11,-11,-10,13.08,13.14,13.21,14.12,14.67,14.64,14.16,13.62,13,12.39,12.08,11.54,10.25,8.42,6.39,5.34,4.28,4.17,3.82,3.25,3.26,3.29,3.83,4.35,5.01,5.67,6.34,6.89,7.29,7.77,7.95,7.83,7.11,6.98,5.12,4.02,3.25,3.14,3.26,3.38,4.07,4.41,5.98,7.58,7.58,6.40,5.37,4.36,4.32,4.78,5.11,5.12,6,4,3,4,5,5,4,3,3,3,2.99,2.11,2.12,2,2.26,2.88,3.33,4.25,5.14,6.12,7.64,7.66,7.12,7.22,7.63,7.62,6.95,6.64,5.02,3.75,2.36,1.09,0.29,0.04,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,3,5,4.92,5.49,6.25,6.50,5.73,4,2.11,0.45,-0.66,-1.54,-3.50,-5.62,-7.66,-9.55,-11,-12,-13,-14,-14,-14,-14,-14,-14,-13,-13,-13,-13,-14,-14,-14,-14,-15,-15,-14,-14,-14,-13,-12,-11,-10,-9.88,-9.87,-9.75,-9.51,-9.18,-9.12,-9.37,-9.46,-9.62,-9.74,-9.51,-9.17,-8.64,-8.43,-8.05,-7.29,-6.58,-5.79,-4.65,-3.34,-3,-2.97,-2.71,-2.04,-1.10,-0.24,0.15,0.17,0.07,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,1,1,1,1,0.52,0.45,0.25,-0.43,-1.36,-2.38,-3.43,-4.50,-5.50,-6.39,-7.22,-7.88,-8.38,-8.80,-9.14,-9.41,-9.64,-9.85,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.96,-9.75,-9.59,-9.41,-9.29,-9.21,-9.13,-9.13,-9.13,-9.14,-9.17,-9.22,-9.25,-9.27,-9.28,-9.30,-9.33,-9.37,-9.41,-9.50,-9.61,-9.72,-9.83,-9.91,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-12,-12,-12,-13,-13,-13,-14,-14,-15,-15,-15,-16,-16,-16,-16,-16,-16,-16,-16,-15,-15,-15,-15,-14,-14,-14,-13,-13,-13,-12,-11,-10,-9.90,13.10,13.90,14.25,15.11,15.65,15.62,14.39,13.77,13.20,12.70,12.27,11.62,10.62,8.34,6.29,5.97,5.25,4.87,4.21,3.90,3.72,3.95,4.36,5.12,5.79,6.37,7.15,7.83,8.34,8.70,8.25,7.78,7.14,6.92,5.12,4.13,3.25,3.32,3.91,4.38,5.14,6.01,7.09,8.58,8.58,6.35,5.21,5.03,5.67,6.07,6.25,6.76,5.87,5.87,4.12,4.87,5.89,5.92,4.98,4,4,5,4.92,3.86,2.21,1.26,2.67,3.65,4.23,5.04,6.14,7.24,7.98,8.09,7.89,8,8.60,8.59,7.59,6.65,5.76,5.61,3.58,1.42,0.42,0.15,0.02,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,3,4,4.01,5.25,6.02,6.26,5.51,3.87,2.03,0.38,-0.63,-1.40,-3.27,-5.40,-7.50,-9.40,-11,-12,-13,-14,-14,-14,-14,-14,-13,-13,-13,-13,-13,-13,-14,-14,-14,-15,-15,-14,-14,-13,-13,-12,-11,-10,-9.91,-9.89,-9.77,-9.60,-9.38,-9.33,-9.52,-9.51,-9.40,-9.29,-9.14,-8.75,-8.63,-8.46,-7.92,-7.24,-6.59,-5.83,-4.88,-3.83,-3,-2.97,-2.72,-2.04,-1.10,-0.22,0.14,0.14,0.02,0,0.02,0.13,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,0,0,0,0,0.03,0.12,0.15,0.37,0.13,-0.27,-1,-2.02,-3.11,-4.22,-5.28,-6.27,-7.16,-7.90,-8.46,-8.89,-9.25,-9.51,-9.71,-9.85,-9.97,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.88,-9.71,-9.53,-9.39,-9.26,-9.16,-9.13,-9.11,-9.11,-9.13,-9.16,-9.22,-9.25,-9.28,-9.33,-9.35,-9.37,-9.40,-9.46,-9.54,-9.65,-9.78,-9.91,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-12,-12,-12,-13,-13,-13,-14,-14,-15,-15,-15,-15,-16,-16,-16,-16,-16,-16,-16,-15,-15,-15,-15,-14,-14,-14,-13,-13,-13,-12,-11,-10,-9.64,14.12,15.09,15.75,16.26,16.63,15.82,14.82,13.87,13.29,12.88,12.58,11.88,10.62,8.36,7.20,6.74,6.71,5.71,4.89,4.28,4.32,4.36,5.26,6.12,6.89,7.39,8.38,9.09,9.63,9.65,8.86,8,7.16,6.10,5.12,4.20,3.95,4.23,4.89,5.86,6.60,7.24,7.87,8.58,7.59,6.03,4.37,5.35,6.62,7.62,7.64,7,6.20,5.21,5.14,5.20,5.83,5.12,4.11,4.99,6,6,6.89,4.88,3.24,2.27,3.01,4,4.99,6,7.13,8.59,8.78,8.88,8.36,8.33,8.87,8.58,7.75,6.67,5.73,4.73,3.60,2.01,0.95,0.37,0.13,0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,3,3,4,5.01,5.90,6.12,5.37,3.75,1.97,0.41,-0.53,-1.37,-3.13,-5.29,-7.42,-9.38,-11,-12,-13,-14,-14,-14,-14,-14,-13,-13,-13,-13,-13,-13,-14,-14,-14,-14,-14,-14,-14,-13,-13,-12,-11,-10,-10,-10,-9.98,-9.83,-9.55,-9.41,-9.63,-9.63,-9.41,-9.01,-8.59,-8.33,-8.53,-8.52,-8.10,-7.29,-6.59,-5.88,-5.10,-4.03,-3.22,-2.98,-2.72,-2.04,-1.10,-0.18,0.16,0.13,0.02,0,0.03,0.20,1,1,1,1,1,1,1,0,0,0,0,1,1,1,2,2,2,2,2,2,1,0,0,0,0,0.01,0.08,0.14,0.08,-0.18,-0.72,-1.58,-2.67,-3.85,-5,-6.10,-7.09,-7.92,-8.53,-9.02,-9.39,-9.65,-9.84,-9.92,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.92,-9.78,-9.63,-9.50,-9.38,-9.25,-9.17,-9.12,-9.10,-9.11,-9.13,-9.18,-9.24,-9.28,-9.34,-9.38,-9.40,-9.43,-9.47,-9.50,-9.59,-9.68,-9.83,-9.97,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-12,-12,-12,-13,-13,-13,-14,-14,-14,-15,-15,-15,-15,-16,-16,-16,-16,-16,-15,-15,-15,-15,-14,-14,-14,-14,-13,-13,-12,-12,-11,-10,-9.78,15.87,16.78,16.82,17.66,17.63,16.13,14.85,13.82,13.26,13.02,12.82,12.59,10.60,8.36,7.51,7,6.52,5.97,5.35,4.91,4.86,5.29,6.14,7.37,8.15,9.16,10,10.60,10.62,10.21,9.29,8.75,7.20,6.12,5.10,4.16,4.24,5.11,5.98,7.01,8.61,8.09,8.20,8.59,7.07,5.38,4.36,5.38,7.58,7.77,8.62,7.65,6.75,5.25,5.25,5.75,5.23,4.21,4.83,5.12,6.92,8,7.87,6,4.25,3.32,3.35,4.36,5.60,6.87,8.22,9.34,10.17,10.22,10,9.77,9.59,8.96,7.91,6.40,5.34,4.35,3.25,2.14,1.24,0.60,0.24,0.02,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,2,3,4,5.11,6.07,6.51,5.50,3.75,1.96,0.47,-0.47,-1.29,-3.10,-5.30,-7.48,-9.46,-11,-12,-13,-14,-14,-14,-14,-14,-13,-13,-13,-13,-13,-13,-14,-14,-14,-14,-14,-14,-14,-13,-13,-12,-11,-10,-10,-10,-10,-9.88,-9.65,-9.39,-9.58,-9.53,-9.33,-8.92,-8.34,-8.28,-8.85,-8.93,-8.55,-7.79,-7.18,-6.38,-5.13,-4.08,-3.38,-2.98,-2.74,-2.08,-1.10,-0.16,0.20,0.12,0.02,0.02,0.14,0,1,1,1,1,1,1,0,0,0,0,0,1,1,2,2,2,2,2,2,2,2,1,0,0,0,0.01,0.09,0.02,-0.13,-0.50,-1.23,-2.18,-3.38,-4.61,-5.79,-6.91,-7.88,-8.65,-9.21,-9.60,-9.88,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.98,-9.90,-9.84,-9.73,-9.60,-9.47,-9.36,-9.25,-9.18,-9.13,-9.12,-9.13,-9.16,-9.23,-9.27,-9.35,-9.39,-9.46,-9.49,-9.52,-9.54,-9.60,-9.63,-9.71,-9.84,-9.97,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-13,-13,-13,-14,-14,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-14,-14,-14,-14,-13,-13,-13,-12,-12,-11,-11,-10,16.87,16.83,17.73,17.66,17.63,16.60,14.40,13.42,13.37,13.32,12.95,12.59,10.37,8.72,7.74,7.12,6.62,6.11,5.62,5.34,5.41,5.99,7.01,8.25,9.50,10.75,12.46,11.90,11.50,11.35,10.66,9.65,7.98,6.12,5.07,5.13,5.21,6,6.87,7.84,8.63,8.62,8.10,7.61,6.62,5.29,4.39,5.41,6.63,7.79,8.60,7.63,6.70,5.32,5.71,5.70,5.28,4.95,4.23,5.82,7,8.92,8.87,6.87,5.26,4.32,4.27,4.37,5.97,7.58,9.08,10.58,11.74,12.59,11.37,11.28,10.61,9.59,8.29,6.88,5.29,4.16,3.09,2.16,1.38,0.78,0.33,0.02,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,2,3,3,4,5.42,6.26,6.78,5.87,3.72,1.85,0.35,-0.52,-1.23,-3.13,-5.43,-7.63,-9.61,-11,-12,-13,-14,-14,-14,-14,-14,-14,-13,-13,-13,-13,-13,-14,-14,-14,-14,-14,-14,-14,-13,-13,-12,-11,-11,-10,-10,-10,-9.99,-9.73,-9.47,-9.28,-9.16,-9.11,-8.66,-8.26,-8.58,-9.13,-9.18,-8.77,-8.08,-7.39,-6.60,-5.36,-4.11,-3.38,-2.98,-2.78,-2.12,-1.09,-0.14,0.22,0.13,0.04,0.14,0.02,1,1,1,1,1,1,0,0,0,0,0,0,1,1,2,2,2,2,2,3,2,1,0,0.09,0,0,0.04,0.10,-0.03,-0.30,-0.83,-1.72,-2.88,-4.11,-5.40,-6.65,-7.75,-8.64,-9.38,-9.88,-10,-10,-10,-10,-10,-10,-10,-10,-9.96,-9.90,-9.86,-9.79,-9.74,-9.64,-9.55,-9.47,-9.37,-9.26,-9.21,-9.16,-9.15,-9.16,-9.22,-9.25,-9.34,-9.40,-9.48,-9.52,-9.59,-9.62,-9.64,-9.66,-9.71,-9.75,-9.84,-9.96,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-13,-13,-13,-14,-14,-14,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-14,-14,-14,-14,-13,-13,-13,-12,-12,-12,-11,-11,-10,16.12,16.79,16.89,17.67,16.16,15.03,14.20,13.42,13.62,13.57,13.57,11.42,10.24,8.95,8.02,7.36,6.77,6.26,5.82,5.62,5.84,6.58,7.83,9.28,10.75,12.16,13.36,13.41,13.20,12.64,12.50,10.59,8.32,7.04,6.02,6.11,6.16,6.98,7.73,8.25,8.66,8.35,7.76,6.98,6,5.08,4.40,5.25,6.37,7.54,8.59,7.36,6.35,6.14,6.12,6.22,6.03,5.29,5.26,6.14,7.14,8.11,8.85,7.79,6.26,5.32,5.36,5.65,5.40,7.65,9.58,11.58,13.58,14.59,13.62,12.63,11.64,10.11,8.83,7.62,5.85,4.29,3.07,2.24,1.63,0.87,0.33,0.02,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,2,2,2,3,4,5,5.76,6.26,6.45,5.21,3.46,1.77,0.45,-0.50,-1.46,-3.30,-5.72,-7.86,-9.83,-11,-12,-13,-14,-15,-15,-15,-14,-14,-14,-13,-13,-13,-14,-14,-14,-14,-14,-14,-14,-14,-13,-13,-12,-11,-11,-11,-10,-10,-10,-9.88,-9.53,-9.18,-8.91,-8.68,-8.46,-8.26,-8.52,-9.13,-9.34,-8.91,-8.14,-7.18,-6.38,-5.34,-4.15,-3.23,-2.93,-2.83,-2.15,-1.01,0,0.25,0.10,0.15,0.02,1,1,1,1,1,1,0,0,0,0,0,0,0,1,2,2,2,2,2,2,2,1,0,0.03,0,0,0.02,0.11,0.07,-0.12,-0.50,-1.25,-2.25,-3.58,-4.92,-6.27,-7.51,-8.61,-9.50,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.97,-9.86,-9.78,-9.72,-9.65,-9.60,-9.52,-9.47,-9.39,-9.33,-9.25,-9.22,-9.18,-9.24,-9.26,-9.33,-9.39,-9.48,-9.54,-9.62,-9.66,-9.73,-9.75,-9.77,-9.79,-9.83,-9.87,-9.93,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-13,-13,-13,-13,-14,-14,-14,-14,-15,-15,-15,-15,-15,-15,-14,-14,-14,-14,-13,-13,-13,-13,-12,-12,-12,-11,-11,-10,-10,15.10,15.82,15.83,15.70,14.34,14.08,13.39,14.12,14.28,14.02,13,11.64,10.12,9.25,8.40,7.66,7,6.45,5.97,5.86,6.09,7.08,8.75,10.39,12.02,13.42,14.45,15.34,14.51,14.39,12.59,10.88,9.11,7.24,7.08,7.07,7.87,7.82,7.97,8.74,8.71,8.70,7.32,6.32,5.70,4.36,4.40,5.17,6.20,7.12,7.39,7.08,6.37,6.37,6.73,7.07,7.21,7.14,6.96,6.25,7.21,8.12,8.82,8.09,7.25,6.78,6.74,6.63,6.87,7.40,9.41,11.74,14.59,15.60,14.62,13.64,11.67,10.26,9.66,7.67,6.75,4.26,3.01,2.22,1.66,0.87,0.29,0.02,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,2,2,3,4,5,6,5.65,5.72,5.28,4.24,2.87,1.48,0.25,-0.68,-1.87,-3.78,-6.11,-8.13,-10,-11,-13,-14,-14,-15,-15,-15,-14,-14,-14,-14,-14,-14,-14,-14,-14,-15,-15,-15,-14,-14,-14,-13,-13,-12,-11,-11,-11,-10,-10,-10,-9.71,-9.26,-8.83,-8.49,-8.28,-8.11,-8.63,-9.25,-9.25,-8.97,-8.25,-7.11,-5.99,-5.15,-4,-3,-2.88,-2.63,-2.26,-0.78,0.41,0.28,0.13,0,1,1,1,1,1,1,1,0,0,0,0,0,0,0,1,2,2,2,2,1,1,1,0,0,0,0,0.01,0.08,0.10,0.02,-0.25,-0.76,-1.76,-2.90,-4.37,-5.83,-7.22,-8.46,-9.51,-10,-10,-11,-11,-11,-11,-10,-10,-10,-10,-9.89,-9.75,-9.64,-9.61,-9.54,-9.50,-9.47,-9.41,-9.38,-9.35,-9.30,-9.29,-9.30,-9.35,-9.39,-9.47,-9.53,-9.62,-9.71,-9.76,-9.84,-9.88,-9.89,-9.91,-9.92,-9.93,-9.98,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-13,-13,-13,-13,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-13,-13,-13,-13,-12,-12,-12,-11,-11,-11,-10,-10,14.91,14.85,14.78,13.26,13.32,13.35,13.88,14.62,15.60,14.60,13.08,11.82,10.70,9.73,8.87,8.03,7.25,6.59,6.12,6.03,6.60,7.97,9.75,11.62,13.37,14.77,15.71,16.11,15.54,14.50,13.12,11.37,9.52,8.40,7.87,8.85,8.87,8.07,7.86,7.85,7.84,7.74,6.74,5.89,5.04,4.34,4.37,5.16,6.14,7.04,7.63,7.25,6.39,6.87,7.39,8.34,9,9.15,8.65,8.11,7.97,8.16,8.79,8.83,8.22,7.97,7.92,7.63,7.34,7.39,9.14,11.32,13.60,13.83,13.63,12.33,11.12,10.75,8.25,6.76,5.16,3.88,2.77,2,1.26,0.76,0.25,0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,2,3,4,5,5,5.22,4.74,4.09,3.16,2.12,1,-0.09,-0.99,-2.38,-4.40,-6.48,-8.36,-10,-11,-13,-14,-15,-15,-15,-15,-15,-14,-14,-14,-14,-14,-14,-14,-15,-15,-15,-15,-15,-15,-14,-14,-13,-13,-12,-12,-11,-11,-10,-10,-9.99,-9.49,-9,-8.49,-8.29,-8.42,-8.75,-8.96,-9.03,-8.63,-7.74,-6.96,-5.98,-4.63,-3.49,-3,-2.88,-2.47,-1.41,-0.83,1,0,0,1,1,1,1,2,1,1,1,0,0,0,0,0,0,0,1,2,2,2,1,1,0,0,0,0,0,0,0.03,0.11,0.09,-0.09,-0.48,-1.24,-2.38,-3.67,-5.25,-6.75,-8.16,-9.41,-10,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-9.85,-9.67,-9.55,-9.50,-9.49,-9.47,-9.43,-9.43,-9.42,-9.42,-9.42,-9.42,-9.47,-9.50,-9.58,-9.64,-9.73,-9.79,-9.87,-9.92,-9.99,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-13,-13,-13,-13,-14,-14,-14,-14,-14,-14,-14,-14,-13,-13,-13,-13,-13,-12,-12,-12,-12,-11,-11,-11,-10,-10,-9.77,13.97,13.10,12.17,12.16,12.20,12.92,13.98,14.95,15.14,14.36,13.32,12.16,11.21,10.33,9.38,8.38,7.42,6.62,6.22,6.49,7.58,9.04,10.86,12.87,14.78,16.27,16.88,16.76,16.12,15.20,13.53,11.79,10.37,8.71,8.07,8.01,8.82,7.83,7.16,7.09,6.87,6.20,6.20,5.20,5.07,4.28,4.34,5.29,6.23,7.28,8.62,7.75,7.38,7.41,8.41,9.79,11.60,11.62,10.64,9.29,8.25,9.14,9.82,9.13,8.87,8.75,8.74,8.65,7.36,7.37,9.02,10.66,11.98,12.63,12.11,11.14,10.13,8.78,7.13,5.12,4.11,3.11,2.16,1.79,1.11,0.78,0.20,0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,2,4,4,5,4.65,4.01,3.12,2.25,1.37,0.48,-0.43,-1.34,-2.87,-4.76,-6.86,-8.46,-10,-11,-13,-14,-15,-15,-15,-15,-15,-14,-14,-14,-14,-14,-14,-15,-15,-16,-16,-16,-16,-16,-15,-15,-14,-14,-13,-12,-12,-11,-11,-10,-10,-9.85,-9.28,-8.88,-8.60,-8.74,-9,-9.23,-9,-8.50,-7.75,-6.49,-5.40,-4.11,-3.26,-2.91,-2.63,-2,-1,0.36,0.62,0.98,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,2,2,1,0,0,0,0,0,0,0,0.08,0.10,0.01,-0.27,-0.84,-1.85,-3.10,-4.53,-6.15,-7.73,-9.16,-10,-11,-12,-12,-12,-12,-11,-11,-11,-10,-10,-10,-9.78,-9.63,-9.51,-9.46,-9.43,-9.47,-9.49,-9.51,-9.53,-9.55,-9.59,-9.62,-9.65,-9.72,-9.77,-9.85,-9.90,-9.98,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-12,-12,-12,-12,-13,-13,-13,-13,-13,-13,-13,-14,-14,-13,-13,-13,-13,-13,-12,-12,-12,-12,-12,-11,-11,-11,-11,-10,-10,-9.84,-9.35,12,11.04,11.03,10.17,11.23,12.26,14.10,15.67,15.66,14.66,13.41,12.51,11.70,10.89,9.88,8.62,7.48,6.59,6.48,7.27,8.49,10.03,11.95,14.08,16.12,17.92,18.07,17.64,16.72,15.45,14.15,11.91,9.98,8.45,7.46,7.26,7.20,6.89,6.84,6.12,6.10,6.12,6.12,6.12,5.12,5.22,5.25,5.28,6.32,7.67,8.62,8.32,7.98,8.22,9.25,11.02,13.60,13.62,12.63,11.32,10.25,10.21,10.14,9.88,9.16,9.23,9.73,8.97,8.33,8.13,8.89,10.10,11.28,11.66,11.32,10.26,9.23,8,6.11,4.98,3.02,2.08,1.89,1.12,0.87,0.12,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,3,4,4,4.84,3.60,2.38,1.45,0.77,0.09,-0.68,-1.66,-3.28,-5.01,-6.76,-8.36,-10,-11,-13,-14,-15,-15,-15,-15,-15,-14,-14,-14,-14,-14,-15,-15,-16,-16,-17,-17,-17,-17,-16,-16,-15,-15,-14,-13,-13,-12,-11,-11,-10,-10,-9.75,-9.37,-9.12,-9.24,-9.39,-9.50,-9.27,-8.53,-7.61,-6.41,-5,-3.97,-3.02,-2.79,-2.37,-1.54,-0.54,0.37,0.85,0.92,0.98,1,1,1,1,1,2,1,0,0,0,0,0,0,0,1,1,1,1,1,0,0,0,0,0,0,0,0.01,0.09,0.07,-0.11,-0.54,-1.29,-2.50,-3.86,-5.41,-7.04,-8.65,-10,-11,-12,-12,-13,-12,-12,-12,-11,-11,-10,-10,-9.99,-9.75,-9.61,-9.50,-9.48,-9.47,-9.49,-9.59,-9.63,-9.68,-9.75,-9.78,-9.84,-9.88,-9.92,-9.99,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-12,-12,-12,-12,-11,-11,-11,-11,-11,-10,-10,-10,-9.78,-9.37,-9.08,10,10,10.08,10.12,11.17,12.78,14.12,15.74,15.10,14.26,13.60,12.84,12.09,11.33,10.12,8.65,7.29,6.66,7.01,8,9.29,10.95,12.90,15.13,17.29,18.95,19.28,18.49,17.21,15.61,13.75,11.73,9.71,7.61,6.53,6.47,6.36,6.23,5.17,5.12,5.07,7,8,8,6,6.12,6.08,6.33,7.26,8.29,8.90,8.98,8.53,8.51,9.82,11.63,13.60,14.62,14.63,13.67,12.74,11.78,11.11,10.95,9.99,9.82,9.76,9.73,8.72,8.32,8.32,9.67,10.87,11.72,11.11,10.13,9.01,7.87,6.04,4,3,2,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,3,4,5,3.35,2.03,0.97,0.45,-0.14,-0.86,-1.93,-3.48,-5.09,-6.39,-8.15,-9.86,-11,-13,-14,-15,-15,-15,-15,-15,-14,-14,-14,-14,-15,-15,-16,-17,-17,-18,-18,-18,-18,-17,-17,-16,-15,-15,-14,-13,-13,-12,-11,-11,-10,-10,-9.91,-9.75,-9.76,-9.79,-9.75,-9.37,-8.36,-7.39,-6.26,-4.75,-3.42,-2.91,-2.71,-2.10,-1.18,-0.15,0.53,0.79,0.87,0.82,1,0,1,1,2,1,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0.03,0.07,-0.01,-0.29,-0.88,-1.80,-3.13,-4.60,-6.21,-7.88,-9.49,-10,-12,-12,-13,-13,-13,-12,-12,-11,-11,-10,-10,-9.96,-9.75,-9.62,-9.54,-9.53,-9.58,-9.63,-9.71,-9.78,-9.88,-9.93,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-13,-13,-13,-13,-13,-13,-13,-12,-12,-12,-12,-11,-11,-11,-11,-11,-10,-10,-10,-10,-9.87,-9.64,-9.38,-9.11,9,9,10,10.95,11.88,13,14.17,15.12,15.13,14.21,13.87,13.22,12.39,11.48,10.03,8.53,7.15,6.77,7.46,8.64,10.04,11.73,13.67,15.91,18.24,19.76,20,19.37,17.39,15.58,13.51,11.33,9.41,8.13,7.47,7.09,6.79,6.26,6.20,6.04,6.11,7.01,8,9,8,7.16,7,7.27,8,9.12,10.40,9.74,9.22,8.60,9.91,11.47,13.53,14.62,15.64,14.70,14.75,12.79,11.87,11,10.07,9.87,9.16,8.98,8.75,8.25,8.26,9.26,10.75,11.75,11.78,10.16,9.11,7.92,6,4,3,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,3,4,3.37,1.82,0.76,0.29,-0.27,-0.91,-2.05,-3.60,-4.90,-6.28,-7.91,-9.63,-11,-12,-14,-14,-15,-15,-14,-14,-14,-14,-14,-14,-15,-16,-16,-17,-18,-19,-19,-19,-19,-18,-18,-17,-16,-15,-15,-14,-13,-13,-12,-11,-11,-10,-10,-10,-10,-10,-9.85,-9.14,-8.26,-6.84,-5.62,-4.21,-3.13,-2.78,-2.46,-1.79,-0.84,0.03,0.63,0.75,0.72,0.60,0.17,0,1,1,1,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0.01,0.08,0,-0.15,-0.55,-1.27,-2.33,-3.71,-5.23,-6.86,-8.53,-10,-11,-12,-13,-13,-13,-13,-12,-12,-11,-11,-10,-10,-9.93,-9.75,-9.66,-9.63,-9.65,-9.73,-9.79,-9.89,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-9.72,-9.38,-9.05,9,9,10,11,11.99,13.08,14.89,15.87,15.87,15.08,14.46,13.71,12.79,11.50,9.87,8.32,7.13,6.90,7.85,9.23,10.70,12.34,14.21,16.32,18.50,19.76,20.01,18.52,17.12,15.12,13.15,10.88,8.73,8.46,8.36,7.79,7.46,7.26,7.12,7.02,7.14,8,9,9,8.92,8.12,7.82,7.45,8.65,9.73,11.37,10.45,9.83,9.39,9.61,10.79,12.50,14.58,14.65,14.71,13.91,12.83,11.10,11,10,9.95,9,8.13,8.16,8.20,8.79,9.20,10.20,11.10,11,10.88,9,8,6,4,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,4,2.41,1.48,0.77,0.24,-0.28,-0.93,-1.99,-3.52,-4.92,-6.23,-7.50,-9.42,-11,-12,-13,-14,-14,-14,-14,-14,-14,-14,-14,-15,-15,-16,-17,-18,-19,-19,-19,-19,-19,-19,-18,-18,-17,-16,-15,-15,-14,-13,-12,-12,-11,-11,-10,-10,-10,-10,-9.71,-8.89,-7.98,-6.41,-5.08,-3.83,-2.78,-2.50,-2,-1.26,-0.48,0.17,0.50,0.59,0.50,0.34,0.15,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0.03,0,-0.10,-0.38,-0.88,-1.68,-2.80,-4.22,-5.73,-7.35,-8.99,-10,-11,-12,-13,-13,-13,-13,-12,-11,-11,-10,-10,-10,-9.96,-9.80,-9.75,-9.76,-9.83,-9.90,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-9.84,-9.49,-9.13,9,9,10,11,12,13,14,15,16,16,15.33,14.47,13.11,11.34,9.59,8,7.12,7.17,8.33,9.74,11.20,12.75,14.46,16.29,18.02,18.85,18.32,17.34,16.16,14.03,12.21,10.52,8.75,8.90,8.75,8.57,8.38,8.65,8,7.90,8.16,8.89,10,9.95,9.12,8.75,8.37,8.53,9.10,10.01,10.73,11.33,10.39,9.65,8.63,9.61,11.53,12.91,13.76,14.02,13.78,12.85,11.07,10,9,9,8.98,8.07,8.10,8.88,9.12,10.12,10.87,11.10,11.07,10.01,9,7,5,4,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,1.65,1,0.62,0.21,-0.26,-0.90,-1.79,-3.48,-5.05,-6.02,-7.25,-9.26,-10,-12,-13,-13,-13,-14,-14,-13,-14,-14,-14,-15,-16,-17,-18,-18,-19,-19,-19,-19,-19,-19,-19,-18,-17,-17,-16,-15,-14,-14,-13,-12,-12,-11,-11,-10,-10,-9.90,-9.33,-8.42,-7.55,-6.01,-4.40,-3.12,-2.59,-2.10,-1.41,-0.68,-0.10,0.26,0.38,0.37,0.27,0.16,0.08,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.08,-0.04,-0.25,-0.64,-1.27,-2.14,-3.26,-4.65,-6.13,-7.68,-9.24,-10,-11,-12,-13,-13,-13,-12,-12,-11,-11,-10,-10,-10,-9.99,-9.90,-9.89,-9.93,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-9.89,-9.55,-9.22,10,10,10,11,12,13,14,15,16,17,15.89,15,13.02,10.99,9.21,7.82,7.28,7.63,8.77,10.08,11.47,12.87,14.38,15.91,17.17,17.40,16.76,15.66,14.27,12.73,10.79,10.58,10.10,9.66,9.48,9.40,9.37,9.12,8.78,8.25,9.11,9.87,10.01,9.98,9.83,9.11,8.86,8.92,9.38,10.04,10.78,11.29,10.87,10.24,9.96,10.34,11.24,12.20,12.95,13.75,13.83,12.88,11.98,10,10,9,9,8,9,10,10,11,12,12,12,11,9,7,5,3,3,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1.02,0.62,0.47,0.21,-0.23,-0.80,-1.59,-3.25,-4.87,-5.90,-7.46,-9.11,-10,-11,-12,-13,-13,-13,-13,-13,-13,-14,-14,-15,-16,-17,-18,-19,-19,-19,-19,-19,-19,-19,-19,-18,-18,-17,-16,-16,-15,-14,-13,-13,-12,-11,-11,-10,-10,-9.59,-8.75,-7.73,-6.63,-5.04,-3.54,-2.77,-2.35,-1.63,-0.85,-0.15,0.16,0.27,0.25,0.17,0.12,0.07,0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.10,-0.12,-0.47,-0.98,-1.71,-2.63,-3.74,-5.11,-6.50,-7.96,-9.35,-10,-11,-12,-12,-12,-12,-12,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.99,-9.93,-9.91,-9.96,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-9.96,-9.61,-9.23,11,11,11,12,13,13,14,15,16,17,16.58,14.59,12.50,10.49,8.64,7.60,7.48,8.09,9.09,10.17,11.37,12.66,14.04,15.34,16.09,16.03,15.25,14.03,12.76,11.88,10.78,11.25,11.25,10.70,10.47,10.58,10.53,10.13,9.32,9.25,9.78,10.87,10.07,10.86,9.78,9.25,8.98,9.04,9.42,10.07,10.78,11.33,11.32,10.75,10.50,10.66,11.22,11.79,12.36,12.75,13.08,13.92,12,11,10,9,9,9,9,10,10.98,11.92,12.89,12.87,12.87,11.12,9.87,7.89,5.92,3.99,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0.90,0.38,0.41,0.25,-0.13,-0.64,-1.34,-2.79,-4.40,-5.90,-7.50,-9,-10,-11,-12,-12,-12,-13,-13,-13,-13,-14,-14,-15,-16,-17,-18,-19,-19,-19,-19,-19,-19,-19,-19,-19,-18,-17,-17,-16,-15,-14,-14,-13,-12,-12,-11,-10,-10,-9.23,-8.13,-6.92,-5.55,-4.11,-3,-2.73,-2.15,-1.30,-0.40,0.14,0.28,0.24,0.13,0.07,0.02,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.16,-0.21,-0.71,-1.38,-2.21,-3.17,-4.29,-5.61,-6.90,-8.17,-9.39,-10,-11,-11,-12,-12,-12,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.99,-9.92,-9.88,-9.83,-9.75,-9.72,-9.71,-9.74,-9.85,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-9.91,-9.55,-9.24,12,12,12,12,13,13,14,15,16,16,15.79,13.86,11.82,9.87,8.23,7.49,7.61,8.22,9.10,9.98,11,12.17,13.49,14.62,15.23,15,14.13,12.89,11.75,11.75,12.51,12.54,12.27,11.67,11.62,11.98,12.53,11.36,10.32,10.25,10.21,10.12,10.10,9.98,9.75,9.11,8.87,8.96,9.39,10.01,10.75,11.36,11.36,11.09,10.62,10.87,11.17,11.54,11.75,12.02,12.07,13,13,11,10,10,9,9,10,10.07,11.88,12.85,12.83,12.79,12.78,11.78,9.79,7.83,5.85,4.09,2.92,1,0,0,0,0,0,1,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,3,1.15,0.50,0.48,0.21,-0.14,-0.54,-1.25,-2.55,-4.13,-5.96,-7.52,-8.98,-10,-11,-11,-12,-12,-12,-12,-13,-13,-14,-14,-15,-16,-17,-18,-19,-19,-19,-19,-19,-19,-19,-19,-19,-18,-18,-17,-16,-15,-15,-14,-13,-13,-12,-11,-10,-10,-8.90,-7.63,-6.22,-4.74,-3.18,-2.93,-2.68,-2.10,-1.18,-0.25,0.25,0.32,0.21,0.09,0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.02,0.25,-0.33,-1,-1.84,-2.79,-3.87,-4.99,-6.23,-7.38,-8.48,-9.46,-10,-10,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.98,-9.93,-9.91,-9.89,-9.87,-9.83,-9.76,-9.71,-9.63,-9.55,-9.50,-9.46,-9.42,-9.48,-9.59,-9.75,-9.98,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-9.87,-9.59,-9.26,13,13,13,13,13,14,15,15,16,15.86,14.85,13.04,11.04,9.24,7.79,7.25,7.50,8.07,8.77,9.50,10.40,11.52,12.84,14,14.61,14.38,13.65,12.64,13.22,13.82,14.26,14.26,13.62,13.25,13.26,13.61,13.70,13.20,12.17,11.25,10.79,10.12,10.01,9.79,9.22,8.78,8.35,8.75,9.26,9.98,10.71,11.25,11.47,11.29,11.11,11.03,11.17,11.28,11.29,11.17,12,12,12,12,11,10,10,10,10.07,10.12,10.83,11.21,11.24,11.14,10.74,9.77,8.75,7.75,5.21,3.83,2.87,1.92,0,0,0,0,1,2,3,2,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,3,2.98,1.29,0.62,0.23,-0.12,-0.48,-1.17,-2.55,-4.37,-6.02,-7.61,-9,-10,-11,-11,-12,-12,-12,-12,-12,-13,-13,-14,-15,-16,-17,-18,-19,-19,-19,-19,-19,-19,-19,-19,-19,-18,-18,-17,-16,-15,-15,-14,-13,-13,-12,-11,-11,-10,-8.71,-7.24,-5.72,-4.03,-3.10,-2.90,-2.65,-2.09,-1.24,-0.38,0.14,0.28,0.21,0.10,0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.28,-0.50,-1.38,-2.38,-3.50,-4.65,-5.78,-6.88,-7.90,-8.80,-9.61,-10,-10,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.97,-9.88,-9.85,-9.77,-9.75,-9.72,-9.63,-9.54,-9.47,-9.38,-9.28,-9.21,-9.14,-9.13,-9.16,-9.28,-9.48,-9.71,-9.97,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-9.91,-9.65,-9.30,14,14,14,14,14,14,15,15.98,16.15,16.41,14.37,12.35,10.38,8.66,7.50,7.10,7.29,7.75,8.29,8.88,9.61,10.74,12.22,13.63,14.41,14.47,13.57,13.61,14.45,16.34,16.33,15.78,15.12,14.59,14.92,15.40,15.72,15.65,13.88,12.24,11.16,10.89,10,9.21,8.82,8.32,8.27,8.37,9.14,9.97,10.75,11.37,11.67,11.75,11.50,11.48,11.36,11.24,11.11,11.12,11,11,12,13,12,11,10,10.92,10.87,10.17,10.14,10.12,9.91,9.70,8.89,7.97,6.85,5.28,4.10,2.89,2.08,1.12,0.07,0,0,0,1.01,2.92,3.89,2.87,2.12,1.87,1.87,0.89,0.07,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1.98,2.62,1.41,0.72,0.25,-0.12,-0.47,-1.24,-2.85,-4.58,-6.23,-7.76,-9.13,-10,-11,-11,-12,-12,-12,-12,-12,-13,-13,-14,-15,-16,-17,-18,-19,-19,-19,-19,-19,-19,-19,-19,-19,-18,-18,-17,-16,-16,-15,-14,-14,-13,-12,-12,-11,-10,-8.62,-7,-5.41,-3.90,-3,-2.79,-2.50,-1.99,-1.27,-0.53,-0.01,0.23,0.22,0.12,0.02,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.10,0.16,0.23,-0.77,-1.84,-3,-4.24,-5.43,-6.58,-7.61,-8.49,-9.23,-9.80,-10,-10,-10,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.99,-9.89,-9.80,-9.76,-9.72,-9.62,-9.50,-9.38,-9.25,-9.13,-9.01,-8.90,-8.83,-8.79,-8.84,-8.97,-9.15,-9.39,-9.66,-9.97,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-9.98,-9.71,-9.38,14,15,15,15,15,15,15.98,16.33,16.59,16.10,14.12,11.84,9.57,8.13,7.20,6.87,7.09,7.48,7.87,8.34,8.91,10.09,11.72,13.38,15.37,14.60,14.53,14.51,15.51,16.74,18.39,17.10,16.50,16.37,16.46,17.21,18.65,17.70,15.74,13.21,11.89,10.92,9.99,9.13,8.25,8.15,8.10,8.37,9.08,10,10.99,11.73,12.17,12.39,12.62,12.36,11.95,11.25,11.14,10.89,11,11,12,12,12,11,10.99,10.88,10.83,10,9.73,9.29,8.88,8.21,7.34,6.22,5.01,3.74,2.29,1.96,1.23,0.83,0.11,0.01,0,0.95,1.11,2.13,2.87,2.99,2.78,2.78,2.11,1.16,0.13,0.11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1.17,1.40,1.17,0.67,0.25,-0.12,-0.49,-1.27,-3.21,-4.84,-6.48,-8.01,-9.38,-10,-11,-11,-12,-12,-12,-12,-12,-12,-13,-14,-14,-15,-17,-17,-18,-19,-19,-19,-19,-19,-19,-19,-19,-18,-17,-17,-16,-15,-15,-14,-14,-13,-13,-12,-11,-10,-8.63,-6.92,-5.29,-3.79,-2.87,-2.53,-2.13,-1.62,-1.08,-0.52,-0.09,0.20,0.23,0.13,0.02,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.17,0.21,0,-1.15,-2.36,-3.64,-4.98,-6.25,-7.38,-8.36,-9.11,-9.66,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.88,-9.84,-9.74,-9.61,-9.46,-9.28,-9.13,-8.96,-8.78,-8.63,-8.51,-8.47,-8.50,-8.62,-8.83,-9.08,-9.37,-9.68,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-9.68,-9.39,14,14,16,16,16,16,16.66,17.01,16.97,15.97,13.90,11.53,9.26,7.61,6.84,6.82,7.01,7.37,7.71,8.17,8.86,9.89,11.48,13.22,14.83,14.72,14.37,15.25,16.11,17.50,18.49,17.84,17.75,17.89,18.34,18.85,19.70,17.87,15.83,13.83,12.11,10.99,9.99,9.03,8.25,8.03,8.04,8.37,9.09,10.13,11.29,12.58,12.77,13.22,13.62,13.64,12.87,12.01,11.20,10.87,10,10,11,12,12,12,11.07,10.85,10.10,9.25,9,8.73,8.12,7.12,5.96,4.72,3.37,2.36,1.34,1.29,1.12,0.78,0.14,0.07,1.07,1.87,2.12,2.21,2.89,3.20,3.25,3.09,2.76,2.12,1.21,0.16,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0.16,0.73,1,0.89,0.59,0.21,-0.16,-0.58,-1.42,-3.39,-5.10,-6.79,-8.38,-9.74,-10,-11,-12,-12,-12,-12,-12,-12,-12,-13,-13,-14,-15,-16,-17,-18,-18,-19,-19,-19,-19,-19,-19,-18,-18,-17,-17,-16,-15,-15,-14,-14,-14,-13,-12,-11,-10,-8.75,-6.93,-5.12,-3.68,-2.67,-2.13,-1.53,-1,-0.60,-0.25,0.03,0.25,0.26,0.16,0.04,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.23,0.07,-0.48,-1.63,-2.91,-4.33,-5.71,-7.03,-8.17,-9.09,-9.71,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.97,-9.84,-9.67,-9.50,-9.29,-9.10,-8.88,-8.65,-8.46,-8.26,-8.15,-8.16,-8.28,-8.50,-8.77,-9.10,-9.43,-9.78,-10,-10,-10,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-9.79,-9.39,13,14,15,16,16,16.86,17.46,17.76,17.38,16.07,13.92,11.53,9.28,7.62,6.76,6.78,7.07,7.39,7.76,8.26,9.11,10.40,11.85,13.02,14.08,14.15,14.78,15.70,16.64,16.98,17.38,18.12,18.70,19.67,19.70,20.71,19.74,18.76,15.82,13.12,12.07,11,9.99,9.01,8.24,8.01,8.03,8.36,9.11,10.28,11.66,12.83,13.39,13.99,14.63,15.66,14.14,12.24,11.83,10.89,10,10,10,12,13,13,11.10,10.83,9.92,8.28,8.34,8.63,7.62,6.24,4.95,3.39,2.39,1.37,1.25,1.12,1.14,1.01,0.87,1.04,1.87,2.82,2.85,3.11,3.27,3.70,3.75,3.67,3.29,3.72,2.74,1.23,0.17,0.02,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.28,0.60,0.84,0.75,0.49,0.11,-0.27,-0.68,-1.66,-3.38,-5.38,-7.21,-8.83,-10,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-13,-14,-15,-16,-17,-17,-18,-18,-19,-19,-19,-19,-18,-18,-17,-17,-16,-16,-15,-15,-14,-14,-14,-13,-13,-12,-10,-8.88,-6.97,-5.05,-3.54,-2.46,-1.65,-0.83,-0.23,-0.03,0.14,0.29,0.41,0.39,0.26,0.13,0.04,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.20,0.16,-0.21,-0.90,-2.13,-3.50,-4.97,-6.40,-7.76,-8.89,-9.74,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.85,-9.63,-9.40,-9.16,-8.91,-8.65,-8.38,-8.13,-7.97,-7.91,-8.02,-8.25,-8.55,-8.90,-9.26,-9.63,-9.91,-10,-10,-10,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-9.88,-9.49,12,13,14,15,16,16.92,18.23,18.25,17.87,16.42,14.12,11.62,9.32,7.75,7.09,7.24,7.52,7.87,8.27,8.96,10.10,11.57,13.12,14,15,14,14.99,15.12,15.88,16.21,17.24,18.25,19.25,20.74,20.75,19.75,18.78,16.83,14.87,12.99,12,11,9.92,9,8.21,8.01,8.03,8.34,9.21,10.37,12.09,13.62,14.62,14.36,15.07,16.70,15.74,13.78,12.13,11.07,10,10.02,10.08,11.89,12.87,12.12,11.88,11.22,10.35,9.37,8.37,7.37,6.60,5.41,4.36,3.14,1.41,1.39,1.37,1.35,1.29,1.75,1.22,1.23,2.03,2.85,3.73,3.75,4.08,4.64,4.25,4,3.89,3.85,3.70,2.10,0.23,0.15,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0.24,0.48,0.65,0.62,0.38,-0.01,-0.39,-0.86,-1.76,-3.47,-5.80,-7.71,-9.34,-10,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-13,-13,-14,-15,-16,-17,-17,-18,-18,-18,-18,-18,-18,-17,-17,-16,-16,-15,-15,-14,-14,-14,-14,-14,-13,-12,-10,-8.98,-6.90,-4.96,-3.42,-2.27,-1.30,-0.23,0.26,0.29,0.37,0.50,0.60,0.54,0.46,0.26,0.12,0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.01,0.28,0.02,-0.48,-1.27,-2.62,-4.09,-5.60,-7.05,-8.40,-9.50,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.85,-9.61,-9.35,-9.08,-8.77,-8.47,-8.15,-7.92,-7.84,-7.90,-8.13,-8.46,-8.84,-9.22,-9.58,-9.84,-10,-10,-10,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-9.92,-9.55,11,12,13,14,15,16.49,17.74,18.36,18.28,16.86,14.40,11.76,9.33,8,7.62,7.85,8.12,8.41,8.87,9.64,11,12.75,14.60,17,16,16,15,15.07,15.11,16.14,17.16,18.79,19.78,19.96,19.79,18.83,17.14,15.88,13.07,12,11,10,9.98,8.88,8.16,8,8.02,8.29,9.28,10.64,12.28,14.63,14.64,14.11,14.70,15.73,15.76,13.95,12.88,11.01,10.04,10.11,10.88,11.87,12.79,12.87,12.33,11.92,11.57,10.52,8.53,6.42,5.96,5.23,4.39,3.41,2.41,2.39,2.34,2.17,2.02,1.74,1.26,1.26,2.21,3.17,3.84,4.26,4.63,4.70,4.62,4.37,4.28,4.36,4.65,2.70,1.16,0.21,0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.15,0.35,0.51,0.53,0.25,-0.16,-0.53,-1.01,-1.78,-4.38,-6.41,-8.26,-9.85,-11,-12,-12,-13,-12,-12,-12,-12,-11,-11,-12,-12,-13,-14,-15,-15,-16,-17,-17,-18,-18,-18,-17,-17,-17,-16,-16,-15,-15,-14,-14,-14,-14,-14,-13,-13,-12,-10,-8.85,-6.73,-4.76,-3.21,-2.33,-1,0,0.33,0.33,0.36,0.49,0.65,0.72,0.58,0.62,0.01,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.04,0.26,-0.10,-0.72,-1.58,-3.10,-4.64,-6.15,-7.62,-8.91,-9.91,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-9.86,-9.59,-9.29,-9,-8.67,-8.37,-8.10,-7.96,-7.99,-8.16,-8.49,-8.86,-9.25,-9.63,-9.93,-10,-10,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-9.97,-9.55,10,11,12,13,14,15.70,17.20,18.25,18.61,17.45,14.76,11.86,9.37,8.42,8.36,8.58,8.85,9.09,9.50,10.36,11.82,13.74,16.37,18,18,16,15,16,16.01,17.07,18.10,19.87,20.87,19.87,18.12,16.99,15.92,13.98,12,11,10,10,9,8.95,8.12,7.99,8,8.25,9.22,10.70,11.90,13.67,13.08,12.90,13.21,13.76,14.82,13.87,12,10.91,10.12,10.16,11.21,12.24,13.20,13.74,13.61,12.54,11.50,10.48,8.51,7,5.48,5.41,5.29,4.41,4.35,4.08,3.82,3.36,2.89,2.24,1.29,2,2.75,3.72,4.09,4.63,4.82,4.90,4.83,4.75,4.67,4.74,4.63,2.98,1.27,0.24,0.02,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.10,0.26,0.45,0.38,0.14,-0.29,-0.71,-1.22,-2.33,-5.36,-7.09,-8.78,-10,-11,-12,-12,-13,-12,-12,-12,-11,-11,-11,-11,-12,-12,-13,-14,-15,-15,-16,-16,-17,-17,-17,-17,-16,-16,-16,-15,-15,-14,-14,-13,-13,-13,-13,-13,-12,-11,-10,-8.46,-6.36,-4.38,-2.85,-1.68,-0.73,0.02,0.23,0.21,0.20,0.27,0.42,0.59,0.82,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.02,0.12,0.24,-0.22,-0.88,-2,-3.54,-5.15,-6.67,-8.11,-9.30,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-9.87,-9.60,-9.29,-9,-8.68,-8.42,-8.26,-8.24,-8.37,-8.63,-8.98,-9.36,-9.75,-10,-10,-10,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-9.93,-9.55,9,10,11,12,13,15.04,16.67,18.04,18.62,17.49,14.70,11.74,9.37,8.74,8.98,9.35,9.59,9.79,10.28,11.21,12.60,14.49,16.57,19,19,17,17,17,17,18,20,20,21,20,17,15,14,12,10,10,9,9,9,8,7.99,7.87,7.83,8.01,8.77,9.86,10.95,11.74,11.25,11.24,11.21,12,12.12,12,11.04,10.12,10,10.23,11.74,12.71,13.70,14.67,14.57,12.73,11.41,10.08,8.52,6.57,6.51,6.75,6.95,6.71,6.37,6.11,5.70,4.92,4,3.01,2.32,2.32,2.99,3.70,4.27,4.65,4.95,4.98,4.96,4.97,5.07,5.01,4.62,3.09,1.29,0.25,0.02,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.09,0.25,0.39,0.41,-0.02,-0.52,-1,-1.49,-3.25,-6.01,-7.60,-9.13,-10,-11,-12,-12,-13,-12,-12,-11,-11,-11,-11,-11,-11,-12,-12,-13,-14,-15,-15,-16,-16,-16,-16,-16,-16,-15,-15,-14,-14,-13,-13,-13,-13,-13,-13,-12,-12,-11,-9.77,-7.88,-5.84,-3.87,-2.25,-1.13,-0.34,0.22,0.26,0.03,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.07,0.13,0.16,-0.30,-1,-2.30,-3.97,-5.64,-7.15,-8.52,-9.63,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-9.92,-9.65,-9.38,-9.11,-8.86,-8.67,-8.62,-8.67,-8.86,-9.13,-9.50,-9.88,-10,-10,-10,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-9.88,-9.49,10,10,10,11,13,14.52,16.37,17.95,18.39,17.12,14.23,11.40,9.37,9.03,9.47,10,10.29,10.57,11.07,11.98,13.32,14.99,16.91,19,18,17,19,19,18,19,20,22,21,19,17,15,13,11,10,9,8,8,8,8,8,7.04,7.11,7.13,8.16,9.09,9.78,10.12,10.14,10.04,10.13,10.11,10.95,10.97,10.11,9.16,9.23,10.87,12.10,13.21,13.97,14.64,13.63,12.51,11.37,10.09,8.48,7.07,6.54,8.49,9.57,8.60,8.17,8.62,7.63,6.65,5.09,3.88,3.09,2.29,3.14,3.76,4.36,4.87,5.10,5.04,5.03,5.08,5.17,5.60,4.62,3.63,1.32,0.25,0.03,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.08,0.24,0.38,0.33,-0.08,-0.73,-1.24,-1.99,-4.01,-6.37,-7.86,-9.25,-10,-11,-12,-12,-12,-12,-11,-11,-11,-10,-10,-10,-10,-11,-12,-12,-13,-14,-14,-15,-15,-15,-15,-15,-15,-14,-14,-14,-13,-13,-12,-12,-12,-12,-12,-12,-11,-10,-9.01,-7.23,-5.24,-3.26,-1.50,-0.60,-0.12,0.23,0.21,0.09,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.09,0.15,0.11,-0.33,-1.16,-2.50,-4.35,-6.10,-7.62,-8.93,-9.97,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-9.78,-9.52,-9.28,-9.12,-9.02,-9.03,-9.15,-9.36,-9.65,-10,-10,-10,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-9.77,-9.38,11,11,11,11,12,14.29,16.33,17.92,18.03,16.27,13.52,10.77,9.23,9.15,9.82,10.50,10.95,11.32,11.84,12.71,13.89,15.42,17.04,19,18,18,20,20,20,20,21,21,20,18,17,15,13,11,11,10,9,8,7,7,7,7,6.01,7,7.89,8.12,9.01,9.12,9.12,9.10,8.92,9.01,10,10.91,9.87,9.21,9.99,10.99,12.65,13.62,13.97,13.85,13.22,12.33,11.41,10.39,8.38,6.60,5.57,7.59,9.53,9.62,9.62,9.16,8.65,7.29,6,4.87,3.26,3.26,3.25,3.89,4.63,5.62,5.33,5.17,5.16,5.25,5.41,5.32,4.90,3.85,2.32,0.25,0.21,0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.03,0.16,0.29,0.36,-0.09,-0.64,-1.26,-2.29,-4.14,-6.25,-8.02,-9.14,-10,-11,-11,-12,-12,-11,-11,-10,-10,-9.97,-9.79,-9.92,-10,-10,-11,-12,-12,-13,-13,-14,-14,-14,-14,-14,-14,-14,-13,-13,-13,-12,-12,-12,-11,-11,-11,-11,-10,-9.63,-8.28,-6.62,-4.73,-2.60,-0.92,-0.33,0.04,0.32,0.21,0.07,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.02,0.12,0.13,-0.05,-0.58,-1.38,-2.93,-4.72,-6.51,-8.04,-9.30,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-9.97,-9.71,-9.51,-9.42,-9.41,-9.49,-9.63,-9.84,-10,-10,-10,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-11,-11,-11,-12,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-9.64,-9.23,11,11,12,12,12,14.49,16.64,18.12,17.86,15.54,12.77,10.22,9.09,9.26,10,10.86,11.51,12.07,12.62,13.38,14.42,15.76,17.48,18,19,21,19,19,20,20,20,20,19,18,17,15,13,12,11,11,11,10,8,8,7,6,6,7,7,8,9,9,9,8,8,7,8,9.89,9.16,9.75,9.87,10.87,12.20,13.61,13.62,13.59,12.57,11.79,11.42,9.54,7.86,6.39,5.58,7.14,8.60,9.75,10.64,9.91,9.11,8.09,6.99,5.16,5.76,4.77,4.02,3.29,4.92,5.62,5.75,5.41,5.41,5.64,5.74,5.60,5.08,4.64,3.70,1.79,0.20,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.01,0.11,0.24,0.28,0.08,-0.38,-0.93,-2.04,-3.88,-6.01,-7.73,-8.97,-9.86,-10,-11,-11,-11,-10,-10,-9.90,-9.42,-9.08,-8.91,-9.08,-9.40,-10,-10,-11,-12,-12,-12,-13,-13,-13,-13,-13,-13,-13,-13,-12,-12,-12,-11,-11,-11,-11,-10,-10,-9.79,-8.90,-7.67,-6.14,-4.35,-2.54,-1.25,-0.41,0.02,0.27,0.21,0.07,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.07,0.16,0.11,-0.24,-0.87,-1.79,-3.23,-5.12,-6.99,-8.50,-9.68,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-9.89,-9.79,-9.78,-9.84,-9.92,-10,-10,-10,-10,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-9.53,-9.04,11,11,12,12,13,14.90,16.87,18.90,17.64,15.08,12.14,9.78,8.98,9.27,10.11,11.08,11.97,12.74,13.39,14.10,14.89,16.10,17.37,19,21,21,19,18,19,18,18,18,18,17,17,16,14,12,11,11,11,9,10,9,8,6,6,7,7,8,9,9,8,8,7,7,7,8.12,8.79,8.87,9.29,10.22,11.63,12.73,13.59,12.38,11.58,10.67,9.65,8.49,7.08,5.57,5.53,7.04,8.40,9.67,10.70,10.71,9.86,8.86,7.87,7.87,6.84,5.83,4.24,4.27,5,6.63,6.16,5.89,5.82,5.98,6.60,5.85,5.36,4.87,4.02,2.75,1.16,0.10,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0.08,0.17,0.25,0.27,-0.13,-0.66,-1.67,-3.37,-5.51,-7.27,-8.60,-9.50,-10,-10,-10,-10,-10,-9.43,-8.86,-8.34,-7.98,-7.86,-8.10,-8.50,-9.23,-9.96,-10,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-10,-10,-10,-9.79,-9.22,-8.38,-7.26,-5.88,-4.27,-2.77,-1.54,-0.72,-0.11,0.17,0.21,0.09,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.02,0.13,0.14,-0.04,-0.53,-1.17,-2.18,-3.71,-5.66,-7.52,-8.97,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-12,-12,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-9.90,-9.53,-9.11,11,11,12,13,14,15.16,17.13,18.17,17.83,14.72,11.83,9.65,8.98,9.28,10.22,11.26,12.34,13.28,14.11,14.76,15.48,16.42,17.83,19,20,20,20,18,18,17,16,16,16,16,16,16,13,12,11,10,10,9,10,10,8,6,6,6,7,8,9,9,8,8,8,7,7,7.87,7.87,8.11,8.32,9.35,10.85,12.59,11.58,10.75,9.86,8.97,8.10,7.26,6.47,5.51,6.29,7.29,8.37,9.76,10.75,11.02,10.78,9.83,8.12,8.07,7.92,6.86,5.15,3.25,5.12,6.65,6.63,6.29,6.12,6.23,6.24,6.11,5.65,5.22,4.74,3.78,2.12,0.92,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.26,0.22,0.25,0.33,-0.02,-0.43,-1.17,-2.78,-4.68,-6.52,-7.90,-9.11,-10,-10,-10,-9.75,-9.11,-8.34,-7.62,-7.02,-6.66,-6.63,-7,-7.58,-8.41,-9.25,-10,-10,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-11,-11,-11,-10,-10,-10,-9.74,-9.38,-8.86,-8.10,-7.08,-5.80,-4.38,-2.99,-1.78,-0.87,-0.18,0.16,0.20,0.11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.08,0.20,0.11,-0.23,-0.83,-1.49,-2.73,-4.40,-6.34,-8.14,-9.63,-10,-10,-11,-11,-10,-10,-10,-10,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-9.92,-9.54,-9.13,11,11,12,14,14,16,17.17,18.34,17.03,14.32,11.74,9.84,9.21,9.51,10.41,11.51,12.65,13.72,14.62,15.39,16.21,17.25,18.02,19,20,21,19,19,18,17,16,15,14,14,15,14,13,11,10,10,9,9,10,9,8,7,6,6,7,8,9,9,7,7,8,8,7,6.99,7.20,7.25,7.88,8.64,9.61,10.59,9.41,8.75,7.99,7.35,6.40,6.46,6.46,6.47,6.42,8.12,9.33,10.21,11.20,11.83,11.85,10.88,9.92,9,8.98,7,5.16,5.23,4.26,5.87,6.66,6.64,6.21,6.21,6.64,6.25,6,5.73,5.20,4.16,3.11,1.01,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,1,0.98,0.37,0.33,0.37,0.16,-0.24,-0.73,-2.18,-3.73,-5.39,-7.73,-9.76,-10,-10,-9.88,-9.01,-8.09,-7.14,-6.14,-5.47,-5.14,-5.24,-5.84,-6.61,-7.63,-8.63,-9.50,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-9.89,-9.60,-9.25,-8.75,-8.04,-7.12,-5.91,-4.51,-2.97,-1.75,-0.76,-0.10,0.22,0.21,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.01,0.12,0.25,0,-0.49,-1.13,-1.84,-3.50,-5.25,-7.04,-8.75,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-12,-12,-12,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-9.91,-9.54,-9.13,11,12,13,14,15,16.84,17.64,17.33,16,13.87,11.61,10.03,9.50,9.87,10.75,11.87,13.02,14.13,15.12,16.02,16.96,18.01,19.78,19.87,19.97,20,19,18,17,17,17,15,14,13,14,14,13,11,10,9,9,10,10,10,8,7,6,6,7,8,9,9,8,6,6,6,6,6.11,6.79,6.87,7.29,7.75,7.99,7.39,7.25,6.41,6.58,5.40,6.25,6.70,7.03,7.28,8.08,9.32,10.75,11.87,12.11,12.89,12.92,11.98,10,10,8,7.04,6.87,6.82,6.01,5.25,6.10,6.24,6.16,6.20,6.29,6.72,6.25,5.99,5.82,5.87,4.04,3,1,0,0,0,0,0,0,0,1,1,0,0,0,1,1,1,1,1,0.83,0.77,0.47,0.03,-0.49,-1.39,-2.80,-5.39,-8.68,-10,-11,-10,-9.83,-8.14,-6.72,-5.54,-4.40,-3.39,-3.38,-3.90,-4.62,-5.60,-6.88,-8.08,-9.13,-9.93,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-9.97,-9.66,-9.33,-8.88,-8.23,-7.30,-6.18,-4.77,-3,-1.50,-0.51,0.14,0.28,0.22,0.11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.07,0.17,0.34,-0.01,-0.71,-1.42,-2.54,-4.25,-6,-7.74,-9.29,-10,-10,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-13,-13,-13,-13,-13,-12,-12,-12,-12,-12,-12,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-12,-12,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-9.86,-9.48,-9.03,12,12,13,14.98,16.25,17.42,18.24,17.28,15.46,13.47,11.54,10.25,9.87,10.25,11.12,12.25,13.45,14.60,15.66,16.72,17.75,18.87,19.64,19.85,19.82,18.07,17,17,16,16,15,15,14,13,13,13,12,11,10,11,10,10,10,10,9,8,7,7,6,7,8,8,7,6,5,5,4,5.10,6,6.24,6.77,7,6.37,6.38,5.39,5.40,5.40,5.39,6.38,7.62,7.66,8.01,8.90,10.83,12.89,13,13,13,13,11,11,10,9,8,7.98,7.87,6.99,6.21,5.90,6.01,6.25,6.25,6.25,6.75,6.78,6.12,5.99,5.92,6,4,2,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,2,2,1.38,0.89,0.37,-0.21,-0.80,-2.63,-6.30,-9.36,-10,-11,-10,-8.97,-6.67,-4.80,-3.47,-2.58,-2.11,-2.41,-2.74,-3.13,-4.63,-6.13,-7.60,-8.84,-9.77,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-9.88,-9.58,-9.15,-8.55,-7.66,-6.46,-5.03,-3.13,-1.22,-0.27,0.26,0.33,0.23,0.10,0.01,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,1,0,0,0,0,0,0,0.01,0.12,0.24,0.25,-0.14,-0.96,-1.88,-3.25,-4.99,-6.68,-8.34,-9.71,-10,-10,-10,-10,-10,-10,-9.83,-9.75,-9.79,-9.91,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-13,-13,-13,-13,-13,-13,-13,-13,-12,-12,-12,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-9.75,-9.38,-8.96,12,13,14.01,15.62,17.10,18.10,18.20,17.22,15.27,13.21,11.39,10.26,10,10.49,11.40,12.59,13.87,15.12,16.34,17.46,18.75,19.75,20.21,20,19.21,17.96,16.08,16,16,16,15,14,14,13,14,13,13,12,12,12,10,10,11,10,9,8,8,7,7,6,7,6,6,5,5,5,5,5.08,6.14,6.21,6.25,7.23,7.34,7.25,7.25,7.13,6.38,6.90,7.23,7.34,8.11,8.25,9.21,10.85,11.91,13,13,12,11,11,11,11,10,9,9,8.95,7.88,6.86,5.16,5.79,6.78,6.78,6.20,6.16,6.13,6.11,6.04,6,5,4,2,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,2,2,3,2.01,1.39,0.75,0.11,-0.72,-3.24,-6.80,-9.79,-11,-11,-9.78,-7.39,-4.97,-2.71,-1.46,-1.22,-1.46,-1.83,-2.21,-2.54,-3.46,-5.53,-7.21,-8.65,-9.73,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-9.86,-9.43,-8.84,-7.91,-6.78,-5.25,-3.14,-1,-0.17,0.23,0.32,0.24,0.12,0.03,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0.04,0.17,0.36,0.21,-0.38,-1.28,-2.43,-4.01,-5.63,-7.25,-8.73,-9.88,-10,-10,-10,-10,-9.97,-9.63,-9.40,-9.35,-9.41,-9.58,-9.76,-9.99,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-12,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-9.96,-9.61,-9.24,-8.80,13,14,15.07,16.46,17.79,18.60,18.45,17.21,15.17,13.01,11.07,9.97,9.85,10.48,11.52,12.85,14.28,15.71,17.02,18.47,19.91,21.38,21.04,20.50,19.40,18.13,16.15,17,17,16,15,15,14,14,15,14,14,13,13,12,11,11,11,10,10,9,8,8,7,7,6,5,5,5,5,5,5,6.02,7.88,7.83,7.23,8.73,8.70,9,9.34,9.64,9.64,8.35,8.23,8.70,8.26,8.77,9.16,10.11,10.97,11,11,10,10,10,11,11,10,9,10,9,8.98,6.92,5.10,5.12,5.87,5.98,6.12,6.10,6.07,6.98,7,6,6,5,2,1,0,0,0,0,0,0,0,0,0,0,0,1,1,1,2,3,3,2.75,1.88,1.04,0.25,-1,-4.11,-7.14,-9.42,-10,-10,-9.04,-5.88,-2.84,-0.77,-0.47,-0.50,-0.71,-1.08,-1.52,-2.04,-2.85,-4.91,-6.98,-8.49,-9.64,-10,-10,-10,-10,-9.98,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-9.65,-9.01,-8.23,-6.90,-5.26,-3.12,-0.78,-0.15,0.16,0.29,0.27,0.20,0.09,0.02,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0.10,0.25,0.28,-0.12,-0.77,-1.75,-3.11,-4.66,-6.17,-7.63,-8.88,-9.77,-10,-10,-10,-10,-9.64,-9.36,-9.17,-9.13,-9.23,-9.38,-9.61,-9.84,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-12,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-9.75,-9.39,-9.02,-8.66,14,14.15,15.87,17.24,18.39,19.03,18.75,17.33,15.22,12.99,11.10,10.10,10.07,10.67,11.75,13.12,14.63,16.25,17.88,19.50,21.26,22.28,21.98,21.41,20.08,18.38,18.25,18.88,17.97,17,15,14,15,16,16,14,14,13,12,12,11,11,11,11,10,9,9,9,8,8,7,6,6,5,5,5,5,7,8.95,8.87,9.11,9.23,9.87,10.71,11.70,11.67,10.67,9.70,9.11,8.88,8.99,9.17,9.87,9.95,10,10,9,9,9,10,10,10,9,9,9,9,8,7,5,5,5,5,6,7,7,7,7,7,5.83,4.37,3.09,1.74,0.85,0.27,0.07,0,0,0,0,0,0,0,0,1,1,1,2,4,5,3.49,2.25,1.11,0.20,-1.52,-4.28,-7.14,-9.47,-10,-10,-8.18,-4.68,-1.25,-0.11,0.07,0.12,0.01,-0.21,-0.68,-1.36,-2.30,-4.13,-6.55,-8.50,-9.41,-10,-10,-10,-9.78,-9.62,-9.63,-9.84,-10,-10,-10,-10,-11,-11,-11,-11,-10,-10,-10,-10,-9.79,-9.21,-8.27,-6.91,-5.26,-3.12,-0.76,-0.17,0.10,0.25,0.33,0.25,0.14,0.07,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0.01,0.17,0.38,0.24,-0.34,-1.15,-2.29,-3.74,-5.22,-6.59,-7.79,-8.78,-9.50,-9.90,-10,-9.92,-9.68,-9.42,-9.22,-9.09,-9.08,-9.15,-9.33,-9.52,-9.77,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-12,-12,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-9.63,-9.27,-8.92,-8.59,15,15.37,16.75,18.12,19.17,19.76,19.27,17.62,15.32,13,11.12,10.20,10.20,10.84,11.92,13.36,15,16.82,18.75,20.75,22.33,23.24,22.75,21.95,20.85,19.83,19.08,18.86,17.91,16,15,15,16,17,15,14,14,13,12,12,11,11,12,11,10,9,10,10,10,9,8,7,6,6,5,5,5,7,9,9.91,10.87,10.16,10.21,11.75,12.75,12.74,11.25,10.25,9.87,9.21,9.16,9.87,9.91,10,9,9,8,8,8,9,9,9,9,8,8,8,8,7,5,5,6,6,7,7,8,8,8.98,7.11,5.92,4.71,3.46,2.25,1.21,0.48,0.12,0.01,0.02,0.03,0.02,0,0,0,0,1,1,1,2,4,6,4.34,2.25,1.02,0.12,-1.52,-4.40,-7.22,-9.13,-9.88,-9.33,-6.96,-2.78,-0.17,0.20,0.48,0.64,0.66,0.50,-0.04,-0.83,-1.64,-3.34,-5.65,-7.93,-9.36,-9.67,-9.91,-9.68,-9.30,-9.09,-9.13,-9.43,-9.78,-10,-10,-10,-10,-11,-11,-11,-11,-10,-10,-10,-9.97,-9.25,-8.26,-6.91,-5.26,-3.23,-1.12,-0.30,0.03,0.13,0.20,0.25,0.17,0.11,0.01,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0.03,0.25,0.33,-0.02,-0.75,-1.52,-2.84,-4.27,-5.67,-6.87,-7.88,-8.64,-9.22,-9.54,-9.66,-9.63,-9.48,-9.30,-9.17,-9.12,-9.13,-9.22,-9.36,-9.55,-9.79,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-14,-14,-14,-13,-13,-13,-13,-13,-13,-12,-12,-12,-12,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-9.71,-9.33,-8.91,-8.48,16,16.98,18.01,19.20,20.21,20.62,19.89,17.92,15.45,13.02,11.16,10.27,10.29,10.97,12.07,13.51,15.27,17.27,19.54,22.14,24.16,23.90,23.50,22.58,21.60,20.54,19.63,18.16,17.10,16,15,16,16,16,15,14,14,13,12,12,11,11,11,11,10,10,10,10,9,9,8,7,7,5,5,6,6,7,8,10,10.95,11.88,12.11,12.83,13.20,12.87,12.11,11.20,10.83,10.14,10.11,10.04,10,10,9,8,8,7,7,8,8,8,7,7,6,6,6,6,5,6,6,7,8,9,9,9.98,8.62,7.41,6.12,4.90,3.72,2.50,1.38,0.53,0.14,0.03,0.08,0.10,0.07,0.02,0,0,0,1,1,2,3,4,4.98,3.27,1.99,0.83,-0.01,-1.36,-4.30,-6.53,-8.21,-8.75,-7.50,-4.71,-1.27,-0.05,0.48,0.89,1.24,1.35,1.20,0.62,-0.30,-1.22,-2.23,-4.75,-6.91,-8.24,-9.34,-9.80,-9.54,-8.55,-8.04,-8.61,-9.01,-9.42,-9.85,-10,-10,-10,-10,-11,-11,-11,-10,-10,-10,-10,-9.37,-8.35,-7,-5.38,-3.42,-1.62,-0.58,-0.24,-0.12,0,0.14,0.21,0.11,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0.03,0.28,0.42,-0.25,-1.11,-1.87,-3.37,-4.78,-6.11,-7.21,-7.98,-8.55,-9,-9.27,-9.40,-9.43,-9.39,-9.34,-9.27,-9.25,-9.27,-9.35,-9.48,-9.64,-9.88,-10,-10,-10,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-14,-14,-14,-14,-14,-14,-14,-14,-13,-13,-13,-13,-13,-12,-12,-12,-12,-11,-11,-11,-11,-11,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-9.71,-9.33,-8.92,-8.49,18,18.24,19.22,20.32,21.21,21.47,20.36,18.12,15.50,13.11,11.34,10.50,10.54,11.13,12.17,13.62,15.41,17.53,20.03,23.13,24.37,25.17,24.26,23.07,21.87,21.50,19.58,18.27,17.23,16.15,16.15,16.15,16.84,15.12,14.90,14.02,14,13,12,12,11,11,11,11,11,11,11,10,10,9,8,7,6,5,6,7,7,8,8,9,11,12.97,12.99,13.89,14.87,13.12,13.11,12.87,12,11.08,11.02,11,11,10,10,9,8,8,8,7,7,6,6,5,6,5,6,6,6,6,7,8,9,10,11,9.73,8.77,7.52,6.25,5.03,3.84,2.62,1.46,0.59,0.15,0.07,0.10,0.12,0.10,0.03,0,0,0,0,1,2,3,3,2.92,2.38,1.46,0.59,-0.11,-1.23,-4.17,-6.78,-8.09,-7.88,-6.37,-3.86,-0.92,0.23,0.90,1.52,1.95,2.11,1.85,1.17,0.27,-0.75,-1.85,-3.35,-5.43,-7.08,-8.26,-8.68,-8.59,-8.53,-8.35,-8.50,-8.83,-9.21,-9.61,-9.98,-10,-10,-10,-10,-11,-11,-11,-10,-10,-10,-9.59,-8.59,-7.28,-5.72,-3.87,-2.05,-1,-0.67,-0.40,-0.18,0.03,0.15,0.10,0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.03,0.29,0.63,-0.49,-1.42,-2.48,-3.88,-5.25,-6.50,-7.47,-8.12,-8.55,-8.89,-9.13,-9.28,-9.38,-9.42,-9.43,-9.43,-9.46,-9.48,-9.52,-9.62,-9.76,-9.96,-10,-10,-10,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-13,-13,-13,-13,-13,-13,-13,-13,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-13,-13,-13,-13,-12,-12,-12,-12,-12,-11,-11,-11,-11,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-9.64,-9.33,-8.90,-8.46,18,19.34,20.03,21,21.58,21.46,20.20,17.91,15.46,13.22,11.62,10.90,10.89,11.38,12.33,13.66,15.41,17.52,20.01,23.13,25.15,26.16,25.23,23.24,21.62,20.48,19.37,18.25,17.36,17.04,16.99,16.89,16.25,15.82,15.01,14.13,13.91,13,12,12,12,12,12,12,13,13,12,11,11,10,9,7,5,5,6,7,9,8,9,10,11,12,13,15,15,14,14,15,13,12,13,13,12,11,11,10,9,8,7,7,6,6,5,5,5,6,7,6,7,7,7,8,9,10,10.83,9.91,8.86,7.62,6.32,5.09,3.87,2.64,1.49,0.62,0.15,0.04,0.08,0.10,0.08,0.02,0,0,0,0,1,2,2,2.23,2.02,1.59,0.99,0.35,-0.21,-1.88,-4.93,-7.04,-7.90,-7.54,-5.89,-3.33,-0.67,0.66,1.53,2.28,2.85,3.12,2.82,2,0.95,-0.21,-1.38,-2.58,-4.10,-5.50,-6.74,-7.29,-7.86,-8.36,-8.37,-8.43,-8.71,-9.03,-9.41,-9.78,-10,-10,-10,-10,-11,-11,-11,-11,-10,-10,-9.91,-8.98,-7.74,-6.22,-4.48,-2.65,-1.55,-1.11,-0.71,-0.33,-0.02,0.15,0.12,0.02,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.04,0.28,0.65,-0.58,-1.52,-2.89,-4.36,-5.72,-6.88,-7.73,-8.28,-8.62,-8.88,-9.11,-9.28,-9.41,-9.52,-9.60,-9.63,-9.64,-9.66,-9.71,-9.76,-9.88,-10,-10,-10,-10,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-13,-13,-13,-13,-13,-13,-13,-13,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-13,-13,-13,-13,-12,-12,-12,-12,-12,-11,-11,-11,-11,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-9.89,-9.58,-9.23,-8.85,-8.50,18,18.89,20.02,20.86,21.12,20.67,19.37,17.45,15.33,13.39,12.03,11.37,11.28,11.67,12.50,13.72,15.33,17.28,19.57,21.98,24.15,25.17,25.23,22.87,21.24,19.67,19.03,18.24,17.45,17.89,18.04,17.79,17.17,16.32,15.26,14.79,14,13.09,12,12,12,12,12,12,12,12,12,12,11,11,10,8,6,5,6,8,10,10,10,10,11,12,13,15,15,16,15,15,15,14,14,13,13,13,12,10,9,8,7,7,6,6,5,5,5,6,7,7,7,8,8,9,10,11,10.62,9.91,8.89,7.66,6.36,5.10,3.87,2.64,1.50,0.62,0.16,0.02,0.02,0.04,0.02,0,0,0,0,0,1,1,1.84,1.63,1.42,1.07,0.62,0.13,-0.89,-3.13,-5.58,-7.15,-7.80,-7.13,-5.25,-2.78,-0.29,1.21,2.25,3.15,3.87,4.25,3.96,2.97,1.73,0.46,-0.74,-1.88,-3.03,-4.18,-5.22,-5.98,-7.21,-7.86,-8.18,-8.34,-8.61,-8.92,-9.28,-9.64,-9.99,-10,-10,-10,-11,-11,-11,-11,-11,-10,-10,-9.51,-8.38,-6.85,-5.13,-3.37,-2,-1.49,-0.88,-0.35,0.13,0.21,0.12,0.04,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.01,0.12,0.29,0.40,-0.65,-1.66,-3.25,-4.75,-6.12,-7.18,-7.92,-8.42,-8.74,-8.96,-9.14,-9.34,-9.50,-9.65,-9.76,-9.83,-9.84,-9.84,-9.85,-9.88,-9.98,-10,-10,-10,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-13,-13,-13,-13,-13,-13,-14,-14,-14,-14,-14,-14,-15,-15,-15,-15,-14,-14,-14,-14,-14,-14,-13,-13,-13,-13,-12,-12,-12,-12,-12,-11,-11,-11,-11,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.78,-9.49,-9.21,-8.88,-8.52,17,18.04,19.17,20.11,20.24,19.75,18.62,17,15.17,13.53,12.37,11.75,11.62,11.95,12.64,13.73,15.14,16.88,18.87,20.96,22.62,24.21,23.26,22.07,20.73,19.62,18.64,18.35,18.40,18.82,19.59,19.14,18.39,17.37,16.35,15.71,14.24,13.15,12.91,12,12,12,12,12,12,11,11,11,11,10,9,7,6,5,6,8,10,11,10,10,12,13,14,15,16,16,15,14,14,15,14,13,13,14,12,11,10,9,8,7,7,6,5,5,5,6,7,8,7,8,8,9,10,11,10.60,10,8.92,7.70,6.37,5.11,3.88,2.66,1.51,0.65,0.20,0.02,0,0,0,0,0,0,0,0,1,1,1.25,1.24,1,0.71,0.36,-0.21,-1.67,-3.62,-5.68,-7.04,-7.41,-6.68,-4.68,-2.14,0.35,1.79,3.02,4.09,4.91,5.50,5.23,4.04,2.64,1.25,-0.01,-1.11,-2.10,-3.04,-4.01,-5.08,-6.40,-7.26,-7.84,-8.15,-8.48,-8.84,-9.17,-9.53,-9.88,-10,-10,-10,-11,-11,-11,-11,-11,-11,-10,-10,-9.11,-7.54,-5.78,-3.99,-2.50,-1.85,-1.01,-0.14,0.26,0.24,0.15,0.09,0.02,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.04,0.16,0.40,0.14,-0.77,-1.88,-3.54,-5.08,-6.41,-7.41,-8.09,-8.53,-8.83,-9.01,-9.18,-9.38,-9.60,-9.76,-9.89,-9.96,-9.97,-9.93,-9.92,-9.98,-10,-10,-10,-10,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-13,-13,-13,-13,-13,-14,-14,-14,-14,-15,-15,-15,-15,-15,-15,-15,-15,-14,-14,-14,-14,-13,-13,-13,-13,-13,-12,-12,-12,-12,-12,-11,-11,-11,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.99,-9.77,-9.48,-9.21,-8.88,-8.52,16,16.58,18.40,19.34,19.63,19.23,18.20,16.72,15.10,13.64,12.60,12,11.87,12.12,12.73,13.66,14.89,16.37,18.01,20.12,21.21,21.53,21.58,21.01,20.23,19.37,18.65,18.58,18.87,19.54,20.52,20.52,20.54,18.58,17.27,16.64,14.87,13.88,13.13,12.97,12,12,12,11,11,11,11,11,11,10,8,7.01,6.07,6.10,6.87,8.12,9.87,10.87,10.98,11.07,12.01,13,14,15,15,14,14,13,13,13,12,12,12,13,13,12,10,9,9,9,8,7,5,5,6,7,8,7,8,8,8,10,10,11,10.41,9.77,8.89,7.75,6.47,5.20,3.98,2.75,1.62,0.75,0.25,0.07,0,0,0,0,0,0,0,0,1,1,0.97,0.87,0.66,0.46,0.15,-0.61,-2.03,-3.63,-5.28,-6.33,-6.61,-5.75,-3.62,-1.01,1.15,2.50,3.82,4.96,5.95,6.60,6.53,5.16,3.64,2.14,0.83,-0.25,-1.21,-2.02,-2.84,-4.01,-5.26,-6.50,-7.38,-7.89,-8.37,-8.72,-9.09,-9.43,-9.78,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-10,-9.88,-8.29,-6.41,-4.50,-2.55,-1.91,-1.10,-0.22,0.26,0.25,0.22,0.14,0.09,0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.01,0.11,0.22,0.23,-0.17,-0.85,-2,-3.75,-5.33,-6.65,-7.63,-8.24,-8.63,-8.88,-9.03,-9.18,-9.37,-9.54,-9.73,-9.86,-9.91,-9.93,-9.93,-9.97,-10,-10,-10,-10,-10,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-13,-13,-13,-13,-14,-14,-14,-14,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-14,-14,-14,-14,-13,-13,-13,-13,-13,-12,-12,-12,-12,-11,-11,-11,-11,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.73,-9.46,-9.17,-8.83,-8.50,15.97,16.73,17.88,18.97,19.40,19.10,18.09,16.62,15.07,13.71,12.71,12.13,11.98,12.20,12.73,13.54,14.60,15.78,17.10,18.27,19.12,19.62,19.96,20.25,19.70,19.12,18.74,18.75,19.10,19.75,20.50,20.50,20.50,19.52,17.54,16.04,14.97,14.14,13.82,12.97,13,12,11,11,11,10,10,10,10,10,8.92,7.11,6.14,6.16,7.14,8.21,9.84,10.91,11.83,11.96,12.88,13.92,14,15,14,14,12,12,11,11,11,11,11,11,11,10,9,9,9,8.82,8.59,6.73,5.70,5.63,6.28,7.07,7.50,7.82,7.91,8,8,9,10,11,10.17,9.54,8.83,7.82,6.62,5.40,4.22,2.99,1.83,0.95,0.38,0.12,0.02,0,0,0,0,0,0,0,1,1,0.92,0.61,0.45,0.28,0,-0.76,-2.46,-4.49,-5.83,-6.01,-5.46,-4.42,-2.39,0.12,1.82,3.11,4.41,5.88,6.67,7.78,7.53,6.25,4.73,3.11,1.85,0.66,-0.34,-1.14,-1.76,-2.80,-4.37,-5.89,-6.90,-7.63,-8.17,-8.60,-8.99,-9.36,-9.72,-10,-10,-10,-11,-11,-11,-11,-12,-12,-12,-11,-10,-8.89,-6.88,-4.85,-2.85,-1.89,-1.18,-0.49,0.08,0.17,0.26,0.23,0.17,0.10,0.03,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0.13,0.27,0.07,-0.26,-0.83,-1.93,-3.96,-5.63,-6.89,-7.87,-8.43,-8.76,-8.93,-9.03,-9.13,-9.25,-9.40,-9.58,-9.71,-9.78,-9.85,-9.88,-9.96,-10,-10,-10,-10,-10,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-13,-13,-13,-13,-14,-14,-14,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-14,-14,-14,-13,-13,-13,-13,-13,-12,-12,-12,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-9.84,-9.49,-9.13,-8.77,-8.40,15.03,16.25,17.64,18.98,19.67,19.38,18.20,16.61,15.01,13.66,12.72,12.16,12.01,12.20,12.65,13.37,14.24,15.21,16.13,16.92,17.50,17.62,18.57,19.27,19.27,18.63,18.37,18.54,19.47,19.26,19.47,19.15,18.73,18.50,16.57,15.28,14.62,13.87,13.76,12.87,12,12,11,10,11,10,9,9,10,9.92,8.87,7.97,7.01,6.24,7.20,8.74,9.83,11.75,11.75,11.96,12.83,12.98,13.92,13,13,12,11,11,11,10,10,10,10,10,10,10,9,8.01,8.10,8.36,7.34,6.48,5.89,6.04,6.75,7.38,7.89,8.24,8.41,8.36,9,10,10,11,9.65,9.23,8.64,7.78,6.77,5.66,4.53,3.33,2.14,1.21,0.58,0.23,0.07,0,0,0,0,0,0,0,1,2,0.86,0.53,0.37,0.16,-0.13,-1.76,-4.01,-5.83,-6.71,-6.52,-5.22,-2.93,-0.65,1.07,2.20,3.51,4.84,6.07,7.46,7.64,7.63,7.02,5.90,4.51,3,1.64,0.50,-0.40,-1.21,-1.77,-3.50,-5.39,-6.49,-7.34,-7.98,-8.43,-8.88,-9.26,-9.63,-10,-10,-10,-11,-11,-11,-12,-12,-12,-12,-11,-10,-9.17,-7.04,-4.92,-2.91,-1.77,-1.26,-0.75,-0.37,-0.09,0.16,0.27,0.38,0.25,0.13,0.02,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.17,0.26,-0.03,-0.39,-0.49,-2.34,-4.22,-5.90,-7.25,-8.14,-8.73,-8.96,-9.03,-9.04,-9.05,-9.13,-9.23,-9.36,-9.49,-9.61,-9.71,-9.79,-9.90,-10,-10,-10,-10,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-13,-13,-13,-14,-14,-14,-14,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-14,-14,-14,-13,-13,-13,-13,-13,-12,-12,-12,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-9.88,-9.53,-9.21,-8.76,-8.35,14.04,15.10,17.74,19.27,20,19.76,18.27,16.51,14.88,13.57,12.65,12.15,12,12.16,12.58,13.15,13.88,14.63,15.41,15.79,16.10,16.39,17.10,18.34,18.35,17.72,17.54,17.79,18.48,18.22,17.99,17.58,16.87,15.90,14.88,14,13.39,13.16,12.74,12.15,12,11,10,9,9,9,8,8,8.07,8.87,8.82,8.76,7.74,6.28,7.15,8.32,9.67,10.70,10.97,11.25,11.76,12.17,12.12,12,11,11,11,11,10,10,10,10,10,11,11,10,8.01,7.40,7.32,6.98,6.51,6,6.04,6.58,7.29,8,8.52,8.90,9.22,9.54,9.91,10.01,10,10,9.62,9,8.34,7.64,6.82,5.86,4.82,3.64,2.50,1.52,0.83,0.37,0.12,0.02,0,0,0,0,0,0,1,1,0.86,0.57,0.45,0.15,-0.68,-2.97,-5.01,-6.39,-7,-6.66,-4.92,-1.76,0.24,1.23,2.50,3.78,5.04,6.25,7.20,7.85,8.08,7.97,7.35,6.07,4.36,2.54,1.29,0.23,-0.67,-1.53,-3.01,-4.88,-6.09,-7.03,-7.78,-8.28,-8.75,-9.17,-9.55,-9.93,-10,-10,-11,-11,-11,-12,-12,-12,-12,-11,-10,-9.03,-6.84,-4.65,-2.63,-1.59,-1.22,-0.88,-0.65,-0.39,-0.11,0.14,0.40,0.26,0.24,0.04,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0.28,0.23,-0.22,-0.63,-1.34,-2.64,-4.66,-6.34,-7.67,-8.61,-9.03,-9.22,-9.16,-9.09,-9,-9,-9.03,-9.14,-9.26,-9.40,-9.53,-9.68,-9.85,-10,-10,-10,-10,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-11,-11,-11,-10,-10,-11,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-13,-13,-13,-14,-14,-14,-15,-15,-15,-15,-15,-15,-16,-16,-15,-15,-15,-15,-15,-14,-14,-14,-13,-13,-13,-13,-13,-12,-12,-12,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-9.88,-9.58,-9.18,-8.78,-8.38,15.04,16.10,18.38,19.65,20.22,19.62,18.11,16.25,14.62,13.37,12.57,12.12,12,12.14,12.49,12.97,13.52,14.16,14.60,14.73,14.57,15.12,15.50,16.10,16.29,16.25,16.25,16.54,16.74,16.82,16.58,15.98,14.98,13.52,12.98,12.40,12.20,12.64,11.85,11.15,11,10,9,8,8,8,7,7.01,7.11,7.97,8.76,8.73,7.29,6.34,6.96,7.99,9.63,9.72,10,10.29,10.91,11.76,11.16,11.11,11.01,11,11,11,11,11,11,10,11,11,12,11,8.36,7.37,6.64,6.15,5.75,5.67,6.15,6.97,7.87,8.64,9.25,9.76,10.27,10.71,11,11.04,11,12,10.48,8.87,8,7.46,6.83,6,5.03,3.97,2.89,1.91,1.14,0.58,0.23,0.07,0,0,0,0,0,0,1,1,0.97,0.91,0.63,0.25,-1.38,-3.75,-5.38,-6.49,-6.92,-6.35,-4.60,-1.88,0.23,1.41,2.67,3.99,5.25,6.40,7.38,8.15,8.75,9.02,9.24,8.17,5.47,3.57,2,0.78,-0.26,-1.42,-2.85,-4.43,-5.74,-6.80,-7.59,-8.14,-8.64,-9.10,-9.49,-9.87,-10,-10,-10,-11,-11,-12,-12,-12,-12,-11,-10,-8.41,-6.21,-4.02,-2,-1.30,-1.02,-0.78,-0.68,-0.63,-0.37,-0.17,0.23,0.23,0.28,0.07,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0.25,0.02,-0.39,-1.03,-1.86,-3.55,-5.29,-6.90,-8.23,-9.13,-9.51,-9.48,-9.34,-9.12,-8.92,-8.84,-8.85,-8.91,-9.04,-9.22,-9.39,-9.55,-9.78,-10,-10,-10,-10,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-13,-13,-14,-14,-14,-15,-15,-15,-15,-15,-16,-16,-16,-16,-15,-15,-15,-15,-14,-14,-14,-13,-13,-13,-13,-13,-12,-12,-12,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-9.86,-9.53,-9.24,-8.88,-8.50,17.95,18.10,19.26,20.26,20.38,19.28,17.59,15.76,14.23,13.11,12.45,12.12,12.04,12.16,12.45,12.79,13.17,13.58,13.74,13.64,13.62,13.88,14.33,14.39,14.46,14.48,14.75,14.97,15.11,15.17,15.45,14.45,13.27,12.13,11.37,10.47,10.98,11,10.87,10.84,10,9,9,9,8,7,7,6.92,6.88,7.21,7.86,8.70,7.65,6.36,6.75,7.37,8.35,8.88,9.17,9.34,10.29,10.98,11.21,11.13,11.01,11,11,11,11,12,11,11,11,12,12,10.82,8.86,7.40,6.46,5.86,5.58,5.73,6.28,7.22,8.25,9.17,9.98,10.72,11.40,11.96,12.16,11.92,11.82,12,10.62,8.75,7.77,7.45,7.08,6.38,5.37,4.48,3.47,2.47,1.59,0.87,0.38,0.12,0.01,0,0,0,0,0,1,1,1.49,1.36,0.97,0.39,-1.42,-3.90,-5.58,-6.49,-6.66,-6.08,-4.55,-1.99,0.21,1.46,2.76,4.13,5.49,6.75,7.82,8.73,9.39,10.28,10.22,8.26,6.32,4.22,2.54,1.22,0.15,-1.13,-2.61,-4.12,-5.47,-6.54,-7.41,-8.02,-8.55,-9.01,-9.41,-9.78,-10,-10,-10,-11,-11,-11,-11,-11,-11,-10,-9.38,-7.38,-5.15,-3.10,-1.28,-1.01,-0.75,-0.50,-0.37,-0.29,-0.16,-0.08,0.22,0.22,0.28,0.07,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0.20,0.02,-0.49,-1.16,-2.40,-4.46,-6.09,-7.67,-8.93,-9.72,-9.93,-9.83,-9.51,-9.15,-8.88,-8.72,-8.66,-8.74,-8.88,-9.05,-9.27,-9.51,-9.76,-10,-10,-10,-10,-11,-11,-11,-11,-11,-12,-12,-12,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-13,-13,-13,-14,-14,-15,-15,-15,-15,-15,-15,-16,-16,-16,-15,-15,-15,-15,-14,-14,-14,-13,-13,-13,-13,-13,-12,-12,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-9.91,-9.61,-9.30,-8.98,-8.62,19.95,19.89,20.01,20.50,20.37,19.01,16.84,15.08,13.67,12.78,12.34,12.14,12.15,12.29,12.51,12.67,12.92,13.03,13,12.85,12.25,12.91,13.16,13.65,13.24,13.17,13.28,13.47,13.53,13.53,13.46,13.45,11.53,10.51,10.27,10.25,10.28,9.34,10.25,10.15,10,10,11,10,9,8,7,6.10,6.16,6.77,7.12,7.20,6.72,6.37,6.39,7.25,7.90,8.36,8.37,9.32,10.07,10.87,11.75,11.16,11.10,11,11,11,11,11,12,12,12,12,11,10.11,8.78,7.51,6.58,5.97,5.63,5.77,6.39,7.35,8.46,9.54,10.62,11.62,12.59,13.16,13.08,12.41,11.60,11,9.83,8.20,7.77,7.98,7.92,7.40,6.37,5.47,4.37,3.25,2.16,1.25,0.60,0.22,0.04,0,0,0,0,0,1,2,2.25,1.92,1.37,0.62,-0.75,-3.38,-5.12,-6.01,-6.17,-5.54,-3.99,-1.39,0.14,1.40,2.75,4.22,5.75,7.15,8.38,9.26,10.27,10.12,9.78,9.15,6.71,4.59,2.86,1.50,0.29,-0.96,-2.38,-3.88,-5.23,-6.38,-7.28,-7.96,-8.50,-8.98,-9.37,-9.72,-10,-10,-10,-10,-11,-11,-11,-11,-10,-9.63,-8.10,-6,-3.88,-1.66,-1.01,-0.76,-0.43,-0.12,0.11,0.13,0.12,0.12,0.25,0.26,0.24,0.04,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0.01,0.15,0.03,-0.42,-1.03,-2.83,-5,-6.96,-8.51,-9.65,-10,-10,-10,-9.66,-9.25,-8.89,-8.67,-8.62,-8.66,-8.79,-9,-9.25,-9.50,-9.76,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-12,-12,-12,-13,-13,-13,-14,-14,-15,-15,-15,-15,-15,-15,-15,-16,-15,-15,-15,-15,-15,-14,-14,-14,-13,-13,-13,-12,-12,-12,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-9.80,-9.43,-9.04,-8.65,20.96,20.90,20.42,20.15,20,17.95,15.78,14.01,12.91,12.39,12.16,12.15,12.32,12.54,12.79,13,13.07,12.95,12.72,12.41,12.04,12,12.12,12.17,12.20,12.12,12.14,12.24,12.26,12.25,12.04,11.51,10.51,9.50,9.47,10.16,10.37,10.87,11.13,11.12,11,11,11,10,9,8,7,6.12,6.20,6.25,6.70,6.35,6.15,5.39,6.41,7.58,7.78,8.21,8.74,9.37,10.13,10.97,11.75,11.79,11.12,11,11,11,11,11,12,13,12,12,11,9.92,8.78,7.74,6.91,6.29,5.91,5.96,6.53,7.50,8.62,9.84,11.11,12.41,13.51,13.96,13.59,12.50,11.12,9,8,7.33,7.66,9.04,9.50,9,8.11,6.96,5.66,4.28,2.91,1.72,0.85,0.32,0.09,0,0,0,0,0,1,2,2.50,2.51,1.77,0.85,-0.12,-2.11,-3.88,-4.79,-4.91,-4.23,-2.64,-0.80,0.10,1.28,2.62,4.15,5.87,7.74,8.87,9.76,10.15,10.12,9.66,9.21,6.79,4.75,2.95,1.65,0.45,-0.84,-2.23,-3.68,-5.05,-6.24,-7.22,-7.96,-8.50,-8.97,-9.36,-9.66,-9.96,-10,-10,-10,-10,-10,-10,-10,-9.43,-8.27,-6.58,-4.47,-1.92,-0.97,-0.79,-0.59,-0.28,0.04,0.28,0.37,0.35,0.34,0.34,0.25,0.14,0.02,0,0,0,0,0,0,0,1,1,1,1,1,1,0.15,0.03,0.15,0.10,-0.25,-1.02,-2.62,-5.23,-7.36,-9.22,-10,-10,-10,-10,-9.77,-9.29,-8.90,-8.66,-8.60,-8.64,-8.79,-9,-9.26,-9.52,-9.83,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-12,-12,-12,-13,-13,-13,-14,-14,-14,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-14,-14,-14,-13,-13,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-9.99,-9.61,-9.24,-8.76,21,21.91,20.12,19.34,18.11,16.53,14.73,13.45,12.73,12.46,12.42,12.61,12.90,13.25,13.52,13.66,13.62,13.36,13.01,12.66,12.10,11,11.09,11.17,11.26,11.35,11.39,11.45,11.47,11.50,11.47,10.50,10.50,10.47,10.45,10.39,11.35,12.73,12.17,12.90,12,11,11,10,9,8,8,6.87,6.21,6.16,6.17,6.15,5.98,6,6.41,7.11,7.76,8.28,8.89,9.62,10.25,11.01,11.74,11.92,11.87,11,11,11,11,11,12,13,12,12,11,10.20,9.03,8.10,7.41,6.84,6.42,6.38,6.91,7.87,8.97,10.17,11.49,12.74,13.77,14.03,13.54,12.07,10.41,9,7,8,9.07,10.45,11.29,10.99,9.98,8.70,7.15,5.38,3.67,2.16,1.01,0.39,0.09,0,0,0,0,0,1,2,2.71,2.73,2.04,1,0.08,-0.73,-1.76,-2.71,-2.79,-2.04,-1.22,-0.65,0.01,1.02,2.35,3.89,5.70,7.79,9.38,10.33,10.35,10.14,9.54,8.32,6.62,4.75,3.15,1.83,0.60,-0.66,-2.04,-3.52,-4.91,-6.13,-7.16,-8,-8.55,-9.01,-9.38,-9.66,-9.89,-10,-10,-10,-10,-10,-9.66,-9.10,-8.17,-6.80,-4.98,-2.80,-0.86,-0.73,-0.63,-0.47,-0.22,0.08,0.25,0.27,0.22,0.17,0.16,0.13,0.08,0.01,0,0,0,0,0,0,1,1,-1,1,1,1,1,0.34,0.07,0.16,0.13,-0.13,-0.96,-2.52,-4.93,-7.21,-9.23,-10,-11,-10,-10,-9.79,-9.29,-8.90,-8.65,-8.60,-8.65,-8.84,-9.04,-9.30,-9.61,-9.88,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-12,-12,-12,-13,-13,-14,-14,-14,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-14,-14,-14,-13,-13,-13,-12,-12,-12,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-9.75,-9.35,-8.90,20.99,20.03,19.29,18,16.52,15.04,13.89,13.04,12.70,12.62,12.82,13.17,13.66,14.15,14.51,14.65,14.53,14.21,13.84,13.52,13,12,11.97,11.13,11.23,11.97,12.27,12.35,12.25,12.13,11.89,11.47,11.45,11.63,11.83,12.13,12.74,13.76,13.13,12.97,12,12,11,11,9,8,8,7.12,6.21,6.16,6.10,6.15,6.25,6.38,6.41,7.14,7.71,8.32,9,9.73,10.36,11.12,11.86,12.78,12.12,12,11,11,11,12,12,13,13,12,12,10.65,9.65,8.76,8.08,7.50,7.14,7.12,7.64,8.61,9.64,10.75,11.87,12.85,13.50,13.50,12.73,11.39,10.01,8,8,8,10.01,11.83,13.40,12.65,11.54,10.12,8.41,6.40,4.25,2.49,1.10,0.38,0.03,0,0,0,0,0,1,2,2.66,2.92,2.04,1.13,0.26,-0.35,-0.76,-1.02,-1.12,-1.03,-0.84,-0.52,-0.05,0.65,1.89,3.41,5.17,7.08,8.75,10.35,10.48,10.39,9.63,8.12,6.26,4.54,3.12,1.92,0.79,-0.42,-1.79,-3.36,-4.85,-6.11,-7.15,-8.02,-8.71,-9.15,-9.50,-9.74,-9.89,-9.98,-9.98,-9.88,-9.68,-9.35,-8.79,-8.02,-6.90,-5.36,-3.51,-1.21,-0.52,-0.50,-0.43,-0.33,-0.13,0.07,0.16,0.15,0.11,0.09,0.17,0.17,0.13,0.01,0,0,0,0,0,0,1,-1,-1,-1,1,1,1,0.25,0.08,0.21,0.12,-0.14,-0.93,-2.40,-4.73,-7.14,-9.03,-10,-11,-10,-10,-9.75,-9.22,-8.83,-8.61,-8.55,-8.66,-8.88,-9.13,-9.40,-9.71,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-9.92,-9.90,-9.91,-9.99,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-12,-12,-12,-13,-13,-13,-14,-14,-14,-15,-15,-15,-15,-15,-15,-15,-15,-15,-14,-14,-14,-14,-13,-13,-12,-12,-12,-12,-11,-11,-11,-11,-11,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-9.84,-9.41,-8.99,19,19,18.48,16.74,15.25,14.08,13.28,12.84,12.72,12.87,13.27,13.86,14.52,15.20,15.65,15.84,15.70,15.37,15,14.75,14.98,14,13,12.08,12.15,13,13.71,13.64,13.37,13.29,13.14,13,12.99,13.08,13.28,13.71,13.77,13.84,13.91,13,13,13,13,11,9,9,8,7.12,6.79,6.17,6.17,6.35,6.74,7.08,7.34,7.41,7.87,8.37,9,9.82,10.64,11.23,11.99,12.79,12.87,12,12,12,12,12,13,13,14,13,12,11.32,10.36,9.52,8.84,8.26,7.92,8.03,8.70,9.67,10.72,11.63,12.42,13,13.17,12.78,11.87,10.66,9.62,9,9,9,11,13,14.83,13.92,12.61,11.02,9.33,6.76,4.37,2.51,1.03,0.16,0,0,0,0,0,0,1,2,2.60,2.62,2.09,1.33,0.57,0.02,-0.28,-0.48,-0.60,-0.64,-0.61,-0.47,-0.15,0.37,1.28,2.78,4.46,6.25,8.42,9.38,10.35,11.35,10.27,8.17,5.82,3.88,3.09,1.92,0.91,0.26,-1.55,-3.18,-4.74,-6.11,-7.23,-8.16,-8.86,-9.37,-9.71,-9.89,-9.98,-9.93,-9.80,-9.58,-9.21,-8.66,-7.96,-7,-5.67,-4.05,-1.91,-0.55,-0.34,-0.33,-0.26,-0.16,-0.03,0.07,0.11,0.09,0.04,0.07,0.16,0.27,0.12,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0.15,0.20,0.17,-0.01,-0.41,-1.09,-2.52,-4.78,-7.38,-8.87,-9.98,-10,-10,-10,-9.55,-9.04,-8.68,-8.52,-8.54,-8.72,-8.96,-9.25,-9.54,-9.85,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-9.88,-9.79,-9.75,-9.75,-9.77,-9.87,-9.99,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-12,-12,-13,-13,-13,-14,-14,-14,-14,-15,-15,-15,-15,-15,-15,-15,-14,-14,-14,-14,-13,-13,-12,-12,-12,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-9.88,-9.50,-9.02,18,18,16.75,15.52,14.17,13.29,12.85,12.70,12.84,13.22,13.83,14.58,15.40,16.23,16.79,17.08,16.95,16.60,16.22,16,16,15,14,14,14.09,14.15,14.78,14.98,14.92,14.82,14.73,14.63,14.59,14.57,14.60,14.66,14.84,13.95,13,13,13,13,13,11,10,9,9,7.89,6.16,6.24,6.28,6.85,7.36,8.22,8.60,8.39,8.33,8.39,9.02,9.84,10.65,11.25,12.01,12.83,12.89,13,12,13,13,14,14,15,15,15,13,11.83,10.91,10.17,9.54,8.95,8.62,8.90,9.82,10.99,12.03,12.75,13.15,13.26,13.03,12.36,11.28,10,8.70,10,11,11,12,15,16,15,14,12,9,6,4,2,1,0,0,0,0,0,0,0,1,2,2.39,2.50,2.17,1.62,0.96,0.45,0.12,-0.08,-0.24,-0.38,-0.40,-0.38,-0.17,0.24,0.87,2.14,3.67,5.28,6.89,8.46,9.51,10.38,10.28,8.27,6.40,4.67,2.95,1.90,0.84,0.25,-1.39,-3.04,-4.63,-6.09,-7.35,-8.34,-9.12,-9.66,-10,-10,-10,-10,-9.73,-9.34,-8.78,-8.10,-7.21,-6.13,-4.68,-2.60,-0.88,-0.24,-0.22,-0.17,-0.13,-0.04,0.04,0.11,0.11,0.07,0.02,0.03,0.13,0.13,0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.25,0.33,-0.25,-0.78,-1.28,-2.73,-5.22,-7.09,-8.63,-9.60,-10,-10,-9.75,-9.33,-8.90,-8.63,-8.53,-8.63,-8.83,-9.10,-9.39,-9.71,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-9.91,-9.77,-9.67,-9.61,-9.58,-9.60,-9.67,-9.84,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-12,-12,-12,-13,-13,-13,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-13,-13,-13,-12,-12,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-9.87,-9.48,-9,17,16,16,14.39,13.53,12.89,12.60,12.71,13.03,13.63,14.41,15.32,16.27,17.24,17.92,18.28,18.14,17.74,17.28,17,17,16,17,16,15.99,15.97,16.21,16.41,16.50,16.47,16.39,16.35,16.24,16.07,15.77,15.39,14.79,13.99,13,12,12,13,12,10,9,9,9,7.07,7,6.90,7.12,7.29,8.34,9.63,10.62,9.86,9.21,8.37,9.15,9.86,10.29,11.25,12.21,12.86,13.07,13,13,13,14,15,16,16,16,15,14,11.82,11,10.64,10.11,9.37,9.12,9.58,10.87,12.37,13.51,13.95,13.89,13.59,13.01,12.13,11.01,9.70,8.59,10,12,13,14,16,18,17,15,11,8,5,3,2,1,0,0,0,0,0,0,1,1,2,2.34,2.50,2.42,1.90,1.33,0.79,0.45,0.22,0.03,-0.16,-0.26,-0.30,-0.17,0.21,0.86,1.73,2.89,4.42,5.40,7.27,8.50,9.50,9.37,8.24,7.13,5.04,3.54,2.22,0.83,0.15,-1.34,-2.91,-4.51,-6.02,-7.40,-8.59,-9.40,-10,-10,-10,-10,-10,-9.63,-9.02,-8.26,-7.36,-6.27,-4.88,-3.22,-1.27,-0.27,-0.16,-0.13,-0.09,-0.01,0.07,0.12,0.13,0.11,0.04,0.01,0.01,0.01,0.01,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0.15,0.25,0.10,-0.59,-1.21,-1.76,-2.79,-5.12,-7,-8.49,-9.34,-9.68,-9.72,-9.48,-9.12,-8.79,-8.61,-8.60,-8.74,-8.97,-9.25,-9.55,-9.87,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-9.85,-9.71,-9.58,-9.48,-9.42,-9.43,-9.53,-9.68,-9.89,-10,-10,-10,-10,-10,-11,-11,-11,-11,-12,-12,-12,-13,-13,-13,-13,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-13,-13,-13,-12,-12,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-9.83,-9.41,-8.96,16,15,14,13.98,13.12,12.70,12.54,12.79,13.37,14.13,15.03,16.02,17.08,18.17,19,19.41,19.25,18.75,18.01,18,17,17,17,17.99,17.23,17.60,17.75,17.92,18.08,18.12,18.11,18.03,18.07,17.52,16.96,16.15,15.16,14.10,12,12,12,12,11,9,9,8,7,7.01,7.11,7.83,7.89,8.26,9.29,11.65,11.64,11.63,10.09,9.35,9.34,9.89,10.74,11.76,12.83,13.88,13.01,13,13,13,13,14,15,16,14,13,12,11.15,10.37,10.09,9.87,9.52,9.46,10.16,11.85,13.59,14.82,15,14.51,13.82,12.99,12.03,11.02,9.85,9.40,12,13,15,17,19,19,18,16,13,9,5,3,2,1,0,0,0,0,0,0,1,2,2,2.37,2.50,2.45,2.09,1.50,0.97,0.60,0.35,0.20,0,-0.09,-0.12,-0.04,0.25,1,1.73,2.78,3.59,5.25,6.35,7.62,8.07,7.95,7.33,6.34,5.20,4.14,2.50,1.26,0.20,-1.24,-2.77,-4.38,-5.96,-7.43,-8.74,-9.80,-10,-10,-11,-10,-10,-9.63,-8.79,-7.80,-6.67,-5.35,-3.75,-1.60,-0.52,-0.21,-0.13,-0.04,0.02,0.10,0.14,0.16,0.14,0.10,0.03,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0.25,0.13,-0.33,-1,-1.67,-2.24,-3.29,-5.11,-7.12,-8.49,-9.28,-9.58,-9.54,-9.30,-9,-8.75,-8.63,-8.68,-8.87,-9.12,-9.41,-9.73,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-9.96,-9.77,-9.63,-9.49,-9.38,-9.29,-9.34,-9.41,-9.62,-9.86,-10,-10,-10,-10,-11,-11,-11,-11,-11,-12,-12,-12,-12,-13,-13,-13,-13,-14,-14,-14,-14,-14,-14,-14,-14,-14,-13,-13,-13,-12,-12,-12,-11,-11,-10,-10,-10,-10,-9.90,-9.88,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-9.73,-9.29,-8.92,15,14,14,13,13.01,12.76,12.70,13.07,13.74,14.62,15.64,16.67,17.75,18.90,19.97,20.28,20.07,19.98,19,19,19,18,18,18.09,18.25,18.57,19.29,19.29,19.62,19.84,19.84,19.73,19.52,19.16,18.26,17.12,15.75,14.39,13.82,14,12,11,10,9,8,7,7,7,7.92,8.12,8.82,9.23,10.24,11.71,12.70,11.67,10.67,9.78,9.28,9.99,10.90,11.82,12.87,12.92,13,13,12,12,13,13,14,14,13,12,11,9.84,9.32,9,9.37,9.54,9.92,10.98,12.77,14.65,16,15.96,14.97,13.90,12.90,12.02,11.22,10.63,11.17,12,15,18,21,22,22,21,19,15,9,5,3,2,1,0,0,0,0,0,1,1,3,3,2.83,2.48,2.23,1.89,1.42,0.92,0.59,0.37,0.27,0.15,0.12,0.15,0.37,0.78,1.27,2.26,3.27,4.33,5.20,6.22,6.95,7.22,7,6.46,5.75,5.23,4.13,2.54,1.36,0.29,-1.12,-2.61,-4.21,-5.83,-7.42,-8.91,-10,-10,-11,-11,-11,-10,-9.59,-8.50,-7.28,-5.98,-4.52,-2.88,-1.04,-0.30,-0.17,-0.08,0.03,0.15,0.24,0.24,0.28,0.08,0.07,0.03,0.01,0,0,0,0,0,0,0,0,1,1,1,2,1,1,1,1,0,0,0.26,0.14,-0.58,-1.48,-2.08,-2.74,-3.96,-5.83,-7.43,-8.71,-9.43,-9.67,-9.59,-9.26,-8.90,-8.66,-8.66,-8.76,-8.99,-9.26,-9.58,-9.88,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-9.89,-9.73,-9.54,-9.40,-9.28,-9.26,-9.29,-9.41,-9.63,-9.91,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-12,-12,-12,-13,-13,-13,-13,-13,-14,-14,-14,-14,-14,-14,-13,-13,-13,-13,-12,-12,-12,-11,-11,-10,-10,-10,-9.86,-9.63,-9.53,-9.63,-9.91,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-9.75,-9.34,-8.98,15,14,14,14,13,13,13.13,13.47,14.17,15,15.97,17.17,18.15,19.26,20.52,20.77,21,20,20,20,20,19,18.89,18.65,18.46,18.79,19.34,19.96,20.50,21.02,21.14,21.10,20.95,20.50,19.63,18.24,16.65,15.50,14.65,13.89,13,12,10,9,8,7,7,7,8,8.92,9.87,9.99,10.78,11.24,11.75,11.25,10.74,9.86,9.24,9.89,10.83,11.87,12.07,12,12,12,11,11,12,12,12,13,12,10,9,8,8.36,8.60,9.01,9.87,10.74,12,13.66,15.53,17.23,16.64,15.23,13.90,12.77,12.02,11.66,11.85,12,14,17,21,24,25,24,23,20,15,10,5,3,2,1,0,0,0,0,1,1,2,2,3,3,2.34,2.11,1.72,1.25,0.79,0.50,0.36,0.32,0.32,0.39,0.62,1.07,1.59,2.36,3.25,4.27,5.16,5.85,6.22,7.13,7.16,6.42,5.59,5.03,4.25,3.28,2.25,1.25,0.34,-0.96,-2.38,-4,-5.67,-7.38,-9,-10,-11,-12,-12,-11,-10,-9.48,-8.13,-6.74,-5.29,-3.79,-2.23,-0.49,-0.26,-0.12,0,0.13,0.25,0.37,0.34,0.09,0.96,0.97,0.99,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0.26,0.23,-0.67,-1.64,-2.35,-3.22,-4.83,-6.42,-7.97,-9.12,-9.78,-9.93,-9.75,-9.39,-9.02,-8.87,-8.80,-8.91,-9.14,-9.43,-9.74,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-9.86,-9.66,-9.50,-9.37,-9.25,-9.23,-9.26,-9.41,-9.67,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-12,-12,-12,-11,-11,-10,-10,-10,-9.76,-9.50,-9.33,-9.34,-9.54,-9.89,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-9.89,-9.50,-9.08,15,14,14,14,14,14,13,14,15,15,16,17,19,19,20,20,19,19,19,19,19,19,18.76,18.20,18.21,18.61,19.32,20.15,21.03,21.79,22.13,22.15,22.23,22.13,21.25,19.49,17.58,16.10,15.52,13.96,13,11,10,8,7,7,7,8,9,9,9.92,10.11,10.85,11.10,11.01,10.78,10.21,9.87,9.16,9.87,10.11,11.07,12,12,12,11,11,10,10,10,11,11,10,9,8,8,8.01,8.40,9.49,10.50,11.58,12.85,14.40,16.20,17.51,16.88,15.28,13.75,12.58,12.12,12.28,13,14,16,19,24,26,27,26,24,20,15,10,5,3,2,1,0,0,0,0,2,2,2,3,3,3,2.98,2.14,1.65,1.10,0.75,0.46,0.38,0.36,0.41,0.71,1.29,2.09,2.91,3.73,4.50,5.83,6.16,6.79,7.20,7.77,8.77,6.42,5.27,4.32,3.47,2.61,1.77,1.02,0.27,-0.80,-2.08,-3.72,-5.49,-7.30,-9.08,-10,-11,-12,-12,-11,-10,-9.15,-7.63,-6.12,-4.60,-3.09,-1.71,-0.39,-0.18,-0.02,0.11,0.22,0.36,0.42,0.97,1,1,2,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0.23,0.35,-0.64,-1.72,-2.49,-3.71,-5.35,-7,-8.47,-9.54,-10,-10,-9.99,-9.58,-9.23,-9,-8.96,-9.09,-9.33,-9.60,-9.88,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-9.98,-9.80,-9.63,-9.48,-9.34,-9.24,-9.18,-9.25,-9.43,-9.74,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-12,-12,-12,-11,-11,-10,-10,-10,-9.68,-9.40,-9.21,-9.15,-9.29,-9.55,-9.88,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-9.62,-9.18,15,15,14,14,15,15,14,15,16,16,17,18,19,19,20,19,18,18,18,18,18,18,17.70,17.41,17.57,18.24,19.07,20.04,21.13,22,22.57,22.78,23.12,23.83,22.89,20.72,18.59,16.73,15.40,13.99,12,11,9,8,7,7,7,8,10,10,10,10.98,11,11.10,11,10.12,10.12,9.88,9.89,9.92,10.01,11,12,12,12,11,10,10,9,9,9,9,9,9,9,9,10,10,10.36,11.25,12.28,13.49,14.88,16.46,17.25,16.73,15.34,13.63,12.63,12.36,13.01,14,16,17,21,26,28,27,26,25,22,17,11,6,3,2,1,0,0,0,0,1,3,4,4,4,3,3,2.98,1.34,1.20,0.91,0.72,0.53,0.41,0.48,0.89,1.97,3.25,4.39,5.10,5.98,6.87,7.14,7.83,8.20,8.79,8.79,6.61,4.54,3.65,2.75,2,1.36,0.78,0.24,-0.63,-1.86,-3.38,-5.30,-7.25,-9.15,-10,-12,-12,-12,-11,-10,-8.75,-7.03,-5.39,-3.80,-2.42,-1.25,-0.34,-0.12,0.10,0.22,0.28,0.41,0.89,2,2,2,2,1,0,0,0,0,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0.12,0.53,-0.51,-1.58,-2.43,-3.83,-5.77,-7.40,-8.84,-9.88,-10,-10,-10,-9.71,-9.34,-9.12,-9.10,-9.23,-9.46,-9.74,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-9.93,-9.77,-9.61,-9.46,-9.30,-9.22,-9.16,-9.25,-9.46,-9.75,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-13,-13,-13,-13,-13,-13,-13,-13,-12,-12,-12,-12,-11,-11,-11,-10,-10,-9.64,-9.33,-9.08,-8.98,-9.10,-9.33,-9.61,-9.88,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-9.67,-9.27,16,15,14,14,15,15,15,16,16,16,17,18,19,19,20,19,17,17,17,17,17,17,16.37,16.60,17.12,17.79,18.62,19.52,20.57,21.73,22,22.45,23.23,24,23.85,21.82,19.62,17.64,15.89,14.04,12,10,9,8,7,7,8,9,10,11,11,11,11,12,11,11,10,10,10,10,10,11,11,11,12,11,10,9,9,9,8,8,8,9,10,11,11,12,11,11.98,12.87,13.85,15.04,16.41,17.25,16.90,15.59,13.97,12.17,13,14,15,17,19,23,27,28,28,27,26,23,17,11,6,3,2,1,0,0,0,0,1,2,4,5,5,4,3,3,2,1.16,1.42,1.24,1,0.79,0.64,1.23,2.58,4.17,5.50,6.75,7.09,7.88,8.87,8.85,8.83,9.83,7.90,6.21,4.37,2.96,2.03,1.47,0.99,0.58,0.16,-0.50,-1.61,-3.22,-5.10,-7.21,-9.18,-10,-12,-12,-12,-11,-9.84,-8.05,-6.27,-4.55,-3.05,-1.78,-0.85,-0.26,-0.03,0.16,0.40,0.33,0.29,0.86,1,1,1,1,1,0,0,0,0,1,2,2,2,2,1,1,1,1,0,0,0,0,0,0.01,0.14,0.77,-0.42,-1.25,-2.22,-3.71,-5.85,-7.59,-9.03,-10,-10,-10,-10,-9.75,-9.39,-9.21,-9.18,-9.35,-9.58,-9.86,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-9.91,-9.75,-9.60,-9.42,-9.28,-9.17,-9.15,-9.24,-9.42,-9.75,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-13,-13,-13,-13,-12,-12,-12,-12,-12,-11,-11,-11,-10,-10,-9.63,-9.24,-8.92,-8.76,-8.83,-9.05,-9.34,-9.63,-9.91,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-9.72,-9.28,16,15,14,14,15,15,16,16,16,17,18,19,20,20,19,18,16,16,16,16,16,16,15.39,15.92,16.59,17.27,17.90,18.59,19.35,20.03,20.62,21.17,21.96,23,23.83,22.36,20.38,18.40,16.37,14.60,12,10,9,8,8,7,8,9,10,11,11,11,12,12,11,11,10,10,10,10,10,11,11,11,11,11,10,9,9,8,8,8,8,10,11,12,13,12,12,13,13,14,15,16,18,18,17,14,13,14,15,16,18,21,27,30,30,30,29,26,23,16,11,6,3,2,1,0,0,0,0,1,3,4,5,5,4,4,3,2.01,2.17,2.02,1.86,1.66,1.37,1,1.13,3.07,5,6.45,7.40,8.57,8.11,8.11,8.87,8.85,8.85,7.83,5.71,3.75,2.21,1.46,1.01,0.70,0.40,0.12,-0.47,-1.38,-3,-5.03,-7.18,-9.30,-11,-12,-12,-12,-10,-9.13,-7.23,-5.38,-3.68,-2.25,-1.17,-0.59,-0.17,0.02,0.23,0.34,0.40,0.37,0.91,1,1,1,1,1,0,0,0,0,1,2,3,3,2,1,1,1,0,0,0,0,0,0,0.01,0.14,0.77,0.72,-0.87,-1.85,-3.17,-5.50,-7.50,-9.08,-10,-10,-10,-10,-9.72,-9.39,-9.24,-9.26,-9.42,-9.66,-9.97,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-9.89,-9.75,-9.60,-9.41,-9.26,-9.15,-9.13,-9.21,-9.38,-9.67,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-10,-10,-10,-9.60,-9.15,-8.79,-8.60,-8.55,-8.73,-9.01,-9.35,-9.65,-9.96,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-9.72,-9.25,15,14,14,14,15,16,16,16,17,18,19,20,20,19,19,17,15,15,15,15,15,14,14.39,15.14,16.20,16.50,16.96,17.37,17.89,18.41,18.90,19.42,20.22,21.24,22.24,22.12,21.03,18.85,16.57,14.14,12,10,9,8,8,8,8,9,10,11,11,12,12,12,11,11,10,10,10,10,10,11,11,11,11,11,10,10,9,8.17,8.01,7.52,8.91,10.15,11.50,12.62,13.47,13.17,13.17,14,14,14,15,16,17,18,17,14,14,15,16,18,20,24,30,32,32,31,29,26,22,16,10,6,3,2,1,0,0,0,0,2,3.82,4.87,5.50,5.52,5.37,4.75,4,3.37,3.10,2.99,2.85,2.52,2.10,1.71,1.99,3.39,5.23,6.86,8,8.47,8.58,8.11,8.11,8.12,7.12,6.87,5,3.37,2,1.12,0.75,0.49,0.28,0.10,-0.24,-1.28,-2.83,-4.97,-7.18,-9.29,-11,-12,-12,-11,-9.98,-8.10,-6.15,-4.34,-2.72,-1.48,-0.77,-0.27,-0.08,0.11,0.25,0.35,0.50,0.95,1.22,2,1,1,1,1,0,0,0,0,1,2,2,2,1,1,1,0,0,0,0,0,0,0,0,0.12,0.22,0.74,-0.88,-1.46,-2.64,-5.09,-7.25,-8.92,-10,-10,-10,-9.98,-9.63,-9.34,-9.23,-9.29,-9.50,-9.76,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-9.89,-9.75,-9.59,-9.41,-9.26,-9.14,-9.10,-9.13,-9.28,-9.54,-9.88,-10,-10,-10,-11,-11,-11,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-10,-10,-10,-9.54,-9.08,-8.68,-8.43,-8.37,-8.42,-8.65,-8.98,-9.33,-9.66,-9.99,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-9.64,-9.16,14,14,14,15,16,16,16.95,17.12,17.79,18.24,19.12,19.74,19.23,18.20,17.12,16.04,15,14,14,14,14,13,13.37,14.28,14.99,15.50,15.76,16.04,16.39,16.78,17.17,17.59,18.22,19.23,20.25,20.92,20.04,18.23,16.12,13.83,11,10,9,8,8,8,8,9,10,11,11,12,13,12,11,11,11,10,10,10,10,11,11,11,11,11,10,10.02,9.75,9.12,8.38,8.39,9.17,10.58,11.89,13.02,13.48,13.71,13.82,14,14.02,15,15,16,17,18,16,14,15,16,17,19,21,26,31,34,32,31,29,25,20,15,9,5,3,2,1,0,0,0,1.01,2.36,4.74,6.15,6.75,6.97,6.70,6,5.12,4.41,4.17,4,3.77,3.46,2.82,2.37,2.48,3.52,5.14,7.01,8.37,9.04,9.09,9,8.92,7.98,6.88,5.11,4.45,3.14,1.91,1.08,0.62,0.36,0.23,0.09,-0.18,-0.71,-2.72,-4.90,-7.23,-9.38,-11,-11,-11,-10,-9.01,-6.92,-4.89,-3.15,-1.74,-0.92,-0.38,-0.14,0.02,0.17,0.27,0.37,0.59,1.21,2.75,2,2,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0.03,0.22,0.73,-0.91,-1.10,-2.02,-4.89,-7.05,-8.75,-9.75,-10,-10,-9.83,-9.50,-9.26,-9.22,-9.34,-9.55,-9.86,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-9.89,-9.75,-9.59,-9.41,-9.25,-9.13,-9.04,-9.04,-9.15,-9.36,-9.63,-9.97,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-9.85,-9.46,-9.02,-8.63,-8.33,-8.18,-8.22,-8.36,-8.60,-8.90,-9.27,-9.64,-9.99,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-9.90,-9.55,-9.23,14,14,15,16,17,17.12,17.77,18.25,18.65,18.96,19.27,19.60,19.04,18.16,16.96,15.22,14.12,13,13,13,13,13,12.91,13.46,13.79,14.20,14.49,14.71,14.95,15.21,15.50,15.77,16.32,17.16,18.03,18.49,18.17,17.11,15.67,13.73,11,9,9,8,8,8,9,9,10,11,12,13,13,12,12,12,11,11,11,11,11,11,11,11,11,11,11.02,10.97,10.61,9.91,9.20,8.87,9.53,10.84,12.22,13.22,13.66,13.92,14.15,14.37,14.76,15.02,16,16,17,17,16,15,16,17,18,20,24,28,32,34,33,30,27,23,18,13,8,5,3,2,1,0,0,0.01,1.40,3.58,6,7.62,8.38,8.71,8.51,7.28,6.23,5.51,5.28,5.10,4.75,4.11,3.32,2.61,2.50,3.34,4.86,6.75,8.48,9.17,9.26,9.36,9.77,7.96,6.92,5.07,4.22,3.07,1.98,1.12,0.59,0.33,0.21,0.11,-0.12,-0.50,-2.30,-4.77,-7.21,-9.35,-10,-11,-11,-9.80,-7.74,-5.49,-3.47,-1.96,-1.04,-0.40,-0.18,-0.03,0.12,0.23,0.28,0.37,0.65,1.28,2,3,3,1,1,1,0,0,1,0,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0.03,0.22,0.70,0.37,-1.01,-2.68,-5.03,-7.05,-8.63,-9.55,-10,-9.98,-9.74,-9.42,-9.23,-9.22,-9.37,-9.62,-9.92,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-9.90,-9.75,-9.60,-9.41,-9.25,-9.11,-9,-8.97,-9,-9.13,-9.35,-9.60,-9.86,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-9.67,-9.33,-8.97,-8.60,-8.27,-8.05,-8,-8.09,-8.25,-8.51,-8.85,-9.22,-9.60,-9.96,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-9.89,-9.58,-9.24,14,15,16,17,17.87,18.15,18.34,19.59,19.51,19.49,19.21,19.48,19.49,18.25,17.10,15.76,14.25,13.12,13,13,12,12,12.12,12.28,12.62,12.91,13.16,13.35,13.50,13.70,13.88,14.12,14.51,15.25,15.96,16.35,16.32,16.03,15.52,13.96,12,9,8,9,9,9,9,10,11,12,13,13,13,13,13,13,12,11,11,11,11,11,12,12,12,12,11.98,11.72,11.13,10.41,9.86,9.57,9.96,11.01,12.24,13.27,13.72,14.10,14.45,14.79,15.17,15.65,16,16,16,16,15,16,17,18,19,21,26,30,34,34,32,29,25,20,15,10,7,5,3,2,1,1,0,0.36,1.73,4.28,6.76,8.65,9.60,9.91,9.35,8.29,7.34,6.73,6.46,6.23,5.74,4.78,3.70,2.51,2.12,2.82,4.24,6.02,7.66,8.51,8.58,8.29,7.91,8,7,6,4.15,3.03,2.02,1.22,0.64,0.34,0.22,0.12,-0.02,-0.34,-1.80,-4.63,-7.08,-8.93,-10,-10,-10,-8.48,-6.16,-3.88,-1.88,-1,-0.33,-0.17,-0.11,0.01,0.14,0.25,0.26,0.33,0.54,1.01,1.79,3,2,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0.12,0.20,0.64,-0.08,-1.42,-3.50,-5.51,-7.37,-8.73,-9.63,-10,-9.97,-9.72,-9.41,-9.23,-9.25,-9.40,-9.67,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-9.91,-9.76,-9.61,-9.42,-9.25,-9.09,-8.96,-8.87,-8.86,-8.90,-9.03,-9.23,-9.41,-9.60,-9.72,-9.78,-9.83,-9.84,-9.84,-9.87,-9.92,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.86,-9.53,-9.21,-8.87,-8.55,-8.27,-8.02,-7.85,-7.83,-7.92,-8.13,-8.41,-8.75,-9.13,-9.50,-9.86,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-9.87,-9.55,-9.21,15,16,17,18.87,19.74,18.77,18.57,18.49,18.54,18.62,18.75,18.87,18.78,18.40,17.50,16.27,14.85,13.25,12.90,12,12,11,11.10,11.34,11.53,11.87,12.12,12.15,12.27,12.38,12.50,12.62,12.96,13.59,14.14,14.54,14.70,14.87,15.65,14.89,12,10,8,9,10,11,10,11,12,13,13,14,13,13,13,14,12,11,12,12,12,12,13,13,13,12.82,12.62,12.10,11.46,10.88,10.47,10.29,10.46,11.07,11.92,12.89,13.51,14.07,14.61,15.11,15.52,15.85,16,16,16,16,16,17,18,19,21,23,28,33,34,33,31,27,24,18,13,9,7,5,4,3,2,1,0.17,1.21,2.76,4.75,7,8.75,9.78,10.07,9.62,8.87,8.22,7.82,7.65,7.42,6.77,5.53,4.10,2.57,1.83,2.25,3.40,4.79,6.25,6.96,7.02,6.62,6.28,6,6,5,4.12,3.17,2.20,1.36,0.74,0.37,0.22,0.14,0.04,-0.17,-1,-4,-6.85,-8.71,-9.80,-10,-9.41,-7.61,-4.52,-1.40,-0.64,-0.38,-0.16,-0.03,0.02,-0.03,0.21,0.25,0.22,0.23,0.37,0.63,0.98,1,1,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0.12,0.83,0.28,-0.68,-2.09,-4.15,-6.17,-7.86,-9.09,-9.88,-10,-10,-9.77,-9.48,-9.27,-9.28,-9.46,-9.74,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-9.93,-9.78,-9.62,-9.42,-9.25,-9.08,-8.90,-8.78,-8.74,-8.73,-8.78,-8.89,-9.03,-9.16,-9.28,-9.38,-9.46,-9.50,-9.55,-9.64,-9.75,-9.89,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.93,-9.72,-9.43,-9.13,-8.83,-8.51,-8.25,-8,-7.78,-7.63,-7.63,-7.76,-8,-8.30,-8.66,-9.04,-9.40,-9.75,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-9.83,-9.50,-9.16,15,16,17.95,19.77,19.64,19.45,18.53,17.61,17.65,17.76,18,18.20,18.36,18.34,18.38,16.82,15.46,14.13,12.95,12.04,11,11,11,11.02,11.16,11.29,11.45,11.47,11.49,11.50,11.50,11.61,11.83,12.25,12.79,13.11,13.40,13.61,13.79,14,13,11,9,9,9,10,12,13,13,14,14,14,14,14,14,13,12,12,12,13,14,13,13,14,13,13.61,12.91,12.36,11.82,11.28,11.10,10.90,10.85,11.01,11.52,12.23,12.99,13.75,14.50,15.24,15.72,16.10,16.27,16,16,17,17,18,19,20,23,27,31,34,32,31,29,25,22,17,12,10,8,5,4,3,2,1,1.09,1.84,3.27,4.99,6.70,8.12,9.16,9.59,9.57,9.24,8.91,8.79,8.83,8.74,7.96,6.37,4.59,2.92,1.72,1.83,2.54,3.59,4.52,5.10,5.16,4.96,4.62,4,4,4,4.33,3.34,2.45,1.58,0.87,0.42,0.23,0.14,0.09,-0.09,-0.36,-2.50,-5.38,-7.24,-8.13,-8.11,-7.27,-5.58,-2.80,-0.75,-0.50,-0.25,-0.05,0.08,0.12,0.20,0.22,0.23,0.15,0.13,0.20,0.27,0.10,0,0,1,1,2,1,0,0,1,2,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0.09,0.66,-0.60,-1.48,-2.50,-5.04,-6.88,-8.43,-9.53,-10,-10,-10,-9.86,-9.53,-9.35,-9.35,-9.50,-9.77,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-9.97,-9.79,-9.63,-9.43,-9.25,-9.05,-8.88,-8.75,-8.64,-8.61,-8.62,-8.66,-8.75,-8.87,-8.98,-9.08,-9.16,-9.26,-9.38,-9.50,-9.63,-9.79,-9.97,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.96,-9.79,-9.62,-9.39,-9.13,-8.85,-8.54,-8.26,-8.01,-7.76,-7.55,-7.43,-7.43,-7.55,-7.84,-8.18,-8.59,-8.98,-9.33,-9.65,-9.98,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-9.75,-9.42,-9.05,16,16,18.12,19.28,20.61,20.39,19.34,17.66,16.72,17.15,17.24,17.39,17.62,18.27,17.62,17.38,16.48,14.40,13.10,12,11,11,11,11,11.02,11.16,11.29,11.42,11.46,11.46,11.47,11.36,11.35,11.57,11.63,12.41,12.39,12.23,12,12,11,10,9,8,9,10,12,14,15,15,15,15,15,15,15,14,13,12,13,14,14,14,14,14,14,13.46,13.12,12.65,12.29,12,11.76,11.50,11.23,11.02,11.12,11.62,12.42,13.28,14.23,15.02,15.71,16.25,16.62,16.88,17.17,17.57,18.21,19.04,20,22,25,29,34,34,32,30,27,23,19,15,12,10,7,6,5,3,2,1,1.34,2.25,3.53,4.97,6.37,7.62,8.61,9.24,9.47,9.46,9.42,9.59,9.87,10.03,9.20,7.29,5.14,3.23,1.77,1.57,2.04,2.70,3.25,3.62,3.75,3.67,3.46,3.37,3.37,3.85,3.99,3.62,2.86,1.95,1.11,0.52,0.24,0.13,0.08,-0.03,-0.25,-0.87,-3.23,-4.99,-5.90,-5.89,-5.03,-3.38,-1.14,-0.59,-0.36,-0.15,0,0.12,0.20,0.23,0.23,0.15,0.10,0.07,0.07,0.04,0.01,0,0,0,1,1,1,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0.03,0.47,-0.62,-1.79,-2.83,-5.34,-7.38,-8.93,-9.98,-10,-10,-10,-9.90,-9.58,-9.38,-9.38,-9.53,-9.80,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-9.99,-9.80,-9.63,-9.43,-9.25,-9.05,-8.88,-8.74,-8.62,-8.54,-8.53,-8.55,-8.62,-8.68,-8.78,-8.90,-9.01,-9.14,-9.27,-9.43,-9.59,-9.75,-9.90,-10,-10,-10,-10,-10,-10,-10,-9.99,-9.88,-9.74,-9.59,-9.40,-9.18,-8.93,-8.66,-8.38,-8.12,-7.86,-7.63,-7.42,-7.30,-7.28,-7.40,-7.68,-8.11,-8.51,-8.91,-9.26,-9.60,-9.89,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-9.80,-9.40,-9,17,17,19.20,21.04,22.51,22.40,20.63,18.72,17.52,16.79,16.50,16.46,16.59,16.66,16.75,17.34,16.40,14.35,13.07,12.12,11,11,11,11,11,11.20,11.67,11.82,11.90,11.91,11.95,11.85,11.60,11.53,12.17,12.65,12.20,12,12,10,10,9,9,9,9,10,12,14,16,15,16,15,15,15,15,14,13,13,13,14,15,15,15,14,14,13.65,13.34,13.08,12.84,12.64,12.42,12.10,11.70,11.35,11.20,11.46,12.10,13.23,14.15,15.02,15.84,16.53,17.16,17.73,18.25,18.78,19.53,20.57,21.37,24.01,27,31,33,33,33,30,27,23,17,14,11,9,7,6,5,4,2,1,1.64,2.59,3.72,4.91,6.10,7.23,8.23,8.96,9.35,9.51,9.70,10.04,10.59,10.92,10.12,8.07,5.63,3.51,1.82,1.64,1.72,2.02,2.35,2.57,2.66,2.67,2.63,2.78,3.25,3.77,4.14,4.12,3.48,2.42,1.39,0.64,0.25,0.12,0.07,-0.01,-0.17,-0.39,-1.23,-2.52,-3.33,-3.35,-2.60,-1.37,-0.62,-0.41,-0.24,-0.08,0.03,0.12,0.15,0.15,0.13,0.09,0.03,0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.32,-0.71,-1.61,-3,-5.52,-7.75,-9.34,-10,-10,-10,-10,-9.88,-9.53,-9.37,-9.38,-9.55,-9.84,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-9.99,-9.80,-9.63,-9.42,-9.25,-9.05,-8.88,-8.74,-8.63,-8.55,-8.53,-8.54,-8.59,-8.65,-8.75,-8.86,-8.99,-9.13,-9.27,-9.46,-9.61,-9.76,-9.90,-10,-10,-10,-10,-10,-10,-10,-9.88,-9.76,-9.63,-9.48,-9.28,-9.09,-8.86,-8.60,-8.34,-8.08,-7.83,-7.60,-7.38,-7.25,-7.22,-7.35,-7.63,-8.05,-8.49,-8.88,-9.24,-9.55,-9.87,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-9.83,-9.38,-8.96,17,19,21.11,22.87,24.49,24.38,22.29,19.87,17.96,16.60,15.77,15.45,15.38,15.41,15.50,15.33,14.74,13.76,12.85,12.24,12,12,12,12,12,12,12.10,12.76,12.29,12.62,12.60,12.60,12.37,12.77,13.23,13.10,13,13,11,10,10,10,9,9,9,10,12,13,15,15,16,16,16,15,15,14,13,13,14,15,16,15,15,15,14,13.79,13.60,13.41,13.26,13.14,12.91,12.54,12.13,11.78,11.66,11.88,12.62,13.45,14.36,15.24,16.11,16.97,17.82,18.65,19.52,20.42,21.37,22.37,23.76,25.59,28.98,31,31,32,32,31,27,22,17,13,11,9,7,6,5,4,2,1,2.08,2.99,4.03,5.03,6.01,7.03,8,8.74,9.17,9.41,9.67,10.13,10.76,11.23,10.46,8.41,5.91,3.75,2.12,1.58,1.49,1.58,1.72,1.85,1.92,2.01,2.14,2.54,3.23,4,4.62,4.86,4.28,2.97,1.72,0.76,0.27,0.11,0.07,0,-0.12,-0.28,-0.50,-0.92,-1.36,-1.37,-0.99,-0.60,-0.42,-0.26,-0.12,0,0.08,0.11,0.11,0.09,0.07,0.02,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.05,0.25,-0.71,-1.64,-3.38,-5.79,-7.68,-9.28,-10,-10,-10,-10,-9.76,-9.46,-9.30,-9.37,-9.55,-9.85,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-9.99,-9.79,-9.62,-9.41,-9.24,-9.04,-8.89,-8.76,-8.66,-8.62,-8.60,-8.62,-8.64,-8.73,-8.80,-8.91,-9.04,-9.21,-9.35,-9.50,-9.66,-9.83,-9.93,-10,-10,-10,-10,-10,-10,-9.98,-9.87,-9.75,-9.60,-9.42,-9.25,-9.05,-8.84,-8.60,-8.35,-8.09,-7.85,-7.62,-7.41,-7.27,-7.24,-7.38,-7.68,-8.08,-8.48,-8.87,-9.22,-9.53,-9.85,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-9.75,-9.36,-8.90,18,21,23.02,25.60,25.48,25.37,23.27,20.50,18.14,16.35,14.85,14.59,14.39,14.36,14.26,14.03,13.62,13.07,12.39,12.25,13,13,13,13,13,13,13,13,13,13,13,13,13,14,15,15,13,12,12,11,10,11,10,9,10,11,12,13,13,15,15,16,15,15,15,14,14,14,14,15,16,16,16,15,14,13.88,13.73,13.57,13.42,13.34,13.11,12.74,12.37,12.12,12.11,12.57,13.20,13.98,14.79,15.65,16.54,17.50,18.53,19.70,20.92,22.12,23.25,24.01,24.96,26.25,26.62,28,28,29,30,30,27,21,16,13,10,8,7,6,5,4,2,2,2.62,3.61,4.52,5.37,6.16,7.03,7.88,8.58,8.98,9.22,9.48,9.90,10.42,10.79,10.11,8.25,5.88,3.82,2.11,1.50,1.32,1.27,1.34,1.39,1.49,1.62,1.96,2.51,3.40,4.42,5.27,5.75,4.74,3.46,1.99,0.86,0.32,0.12,0.08,0.03,-0.04,-0.23,-0.38,-0.52,-0.63,-0.63,-0.55,-0.43,-0.28,-0.13,0,0.09,0.12,0.12,0.10,0.07,0.02,0.02,0.01,0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.13,0.12,-0.86,-1.93,-3.65,-5.67,-7.79,-9.30,-10,-10,-10,-10,-9.61,-9.30,-9.23,-9.34,-9.55,-9.86,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-9.98,-9.78,-9.59,-9.39,-9.22,-9.04,-8.90,-8.79,-8.73,-8.68,-8.68,-8.73,-8.76,-8.85,-8.92,-9.03,-9.16,-9.30,-9.46,-9.62,-9.76,-9.90,-10,-10,-10,-10,-10,-10,-10,-10,-9.89,-9.76,-9.62,-9.43,-9.26,-9.08,-8.86,-8.63,-8.38,-8.13,-7.88,-7.64,-7.46,-7.30,-7.28,-7.46,-7.75,-8.12,-8.49,-8.86,-9.21,-9.52,-9.85,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-9.67,-9.33,-8.97,20,22,25.74,26.60,26.48,25.37,23.27,20.52,18.09,15.85,14.74,13.85,13.78,13.66,13.48,13.22,12.96,12.51,12.39,13.25,14,14,14,15,15,15,15,14,14,14,14,14,14,15,15,15,14,13,13,11,11,11,10,10,10,11,12,14,14,15,15,15,15,15,15,14,14,14,15,16,16,16,16,15,14,13.87,13.67,13.47,13.25,13.09,12.84,12.53,12.28,12.22,12.57,13.14,13.86,14.64,15.48,16.29,17.16,18.14,19.33,20.75,22.28,23.88,24.82,24.77,24.37,24.02,24.04,23.97,24,24,27,28,25,20,15,11,9,8,7,6,5,4,3,2,3.22,4.15,5.10,5.76,6.40,7.12,7.86,8.45,8.78,8.98,9.16,9.49,9.78,9.92,9.25,7.63,5.58,3.67,2,1.45,1.20,1.12,1.12,1.16,1.25,1.45,1.88,2.65,3.83,5.08,6.12,6.24,5.32,3.79,2.25,1.01,0.38,0.14,0.11,0.09,-0.01,-0.14,-0.28,-0.42,-0.52,-0.54,-0.47,-0.33,-0.17,-0.02,0.10,0.15,0.17,0.16,0.13,0.09,0.04,0.03,0.13,0.10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,-0.16,-0.23,-1.02,-2.41,-3.99,-6.33,-8,-9.35,-10,-10,-10,-9.78,-9.40,-9.15,-9.13,-9.28,-9.55,-9.87,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-9.96,-9.75,-9.54,-9.36,-9.17,-9.02,-8.90,-8.84,-8.78,-8.78,-8.80,-8.86,-8.90,-9,-9.09,-9.18,-9.30,-9.43,-9.59,-9.74,-9.88,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.96,-9.80,-9.64,-9.48,-9.28,-9.10,-8.88,-8.66,-8.41,-8.16,-7.90,-7.66,-7.48,-7.33,-7.33,-7.50,-7.80,-8.14,-8.50,-8.86,-9.21,-9.53,-9.86,-10,-10,-10,-10,-10,-10,-11,-11,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-9.71,-9.37,-9,21,23,24.75,25.61,24.49,23.52,22.29,20.24,17.79,15.84,14.63,13.85,13.64,13.49,13.26,12.70,12.61,13.01,13.38,14.12,15,15,15,16,17,16,16,15,15,15,15,15,15,15,15,15,15,15,14,12,11,12,11,11,11,11,13,14,16,16,15,15,15,15,15,14,14,15,15,15,15,15,15,15,14,13.77,13.47,13.08,12.76,12.52,12.32,12.12,12.02,12.14,12.91,13.74,14.60,15.47,16.32,17.12,17.92,18.87,20.09,21.62,23.48,24.99,25.35,24.28,22.95,21.76,21.03,20.59,19,20,22,23,22,17,13,10,8,7,7,7,5,4,3,3,3.58,4.64,5.49,6.09,6.62,7.20,7.79,8.28,8.58,8.72,8.82,8.95,9.01,8.84,8.10,6.71,5.02,3.39,1.92,1.38,1.12,1.03,1.02,1.07,1.14,1.39,1.96,2.95,4.37,5.91,6.99,6.91,5.75,4.12,2.37,1.12,0.46,0.21,0.14,0.12,0.04,-0.08,-0.22,-0.37,-0.48,-0.50,-0.42,-0.25,-0.08,0.08,0.20,0.25,0.28,0.28,0.25,0.16,0.15,0.11,0.03,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,-0.01,0.63,-0.40,-1.34,-2.83,-4.96,-6.66,-8.25,-9.27,-9.96,-10,-9.92,-9.55,-9.21,-9.01,-9.05,-9.26,-9.55,-9.88,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-9.91,-9.71,-9.50,-9.28,-9.13,-9,-8.90,-8.86,-8.84,-8.87,-8.90,-8.98,-9.04,-9.13,-9.24,-9.35,-9.47,-9.60,-9.73,-9.87,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.87,-9.71,-9.51,-9.33,-9.12,-8.90,-8.68,-8.43,-8.17,-7.91,-7.66,-7.47,-7.33,-7.35,-7.53,-7.85,-8.17,-8.51,-8.87,-9.23,-9.54,-9.86,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-9.67,-9.38,-9,21,23,23.79,22.97,22.48,22.07,20.98,19.36,17.48,15.79,14.79,14.25,13.96,13.77,13.60,13.47,13.47,13.60,14.32,15.10,15.97,16,17,17,17,17,17,16,15,15,15,15,15,16,16,15,16,16,15,13,12,12,13,12,11,11,13,15,16,16,16,15,15,15,15,14,15,14,15,15,15,15,15,15,14,13.61,12.97,12.47,12.11,11.89,11.79,11.75,11.83,12.25,13.38,14.37,15.37,16.36,17.24,18.02,18.76,19.60,20.70,22.11,23.87,24.98,24.65,23.12,21.34,19.53,18,17.21,16,16,18,18,17,14,11,8,7,7,7,7,6,5,4,4,4.34,5.09,5.82,6.27,6.70,7.13,7.62,8.02,8.25,8.36,8.37,8.36,8.22,7.78,6.97,5.76,4.39,3.03,1.86,1.35,1.10,1.01,1,1.02,1.13,1.47,2.14,3.37,4.90,6.53,7.52,7.11,6.08,4.15,2.45,1.15,0.50,0.26,0.27,0.24,0.14,0.01,-0.15,-0.30,-0.42,-0.47,-0.38,-0.22,0,0.16,0.32,0.39,0.45,0.46,0.42,0.38,0.02,0.99,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.04,0.39,-0.61,-1.63,-3.18,-5.43,-7.11,-8.16,-9.10,-9.64,-9.79,-9.62,-9.33,-9.03,-8.92,-9.01,-9.25,-9.58,-9.89,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-9.88,-9.64,-9.42,-9.25,-9.09,-8.97,-8.89,-8.87,-8.88,-8.92,-9,-9.09,-9.16,-9.26,-9.37,-9.49,-9.61,-9.74,-9.87,-9.99,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.91,-9.74,-9.53,-9.34,-9.12,-8.89,-8.66,-8.41,-8.15,-7.89,-7.64,-7.46,-7.30,-7.35,-7.54,-7.86,-8.18,-8.52,-8.88,-9.23,-9.55,-9.86,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-9.93,-9.65,-9.35,-8.98,19,19,20.12,21.04,21.25,20.98,20.08,18.71,17.20,15.75,15.15,14.77,14.58,14.45,14.37,14.37,14.46,14.60,15.34,16.10,16.89,17.07,18,18,18,18,17,16,16,15,15,15,15,16,16,16,16,17,15,14,13,13,12,13,12,12,13,14,15,16,16,15,15,15,14,14,14,15,15,15,14,14,14,14,14,12.95,12.24,11.72,11.39,11.37,11.57,11.82,12.16,12.83,13.99,15.10,16.20,17.25,18.20,18.96,19.58,20.21,21.02,22.10,23.33,23.87,23.21,21.58,19.71,17.72,15.96,14.62,14,14,14,15,13,11,9,7,6,6,7,7,7,5,4,4,4.82,5.42,6.09,6.37,6.62,6.91,7.27,7.61,7.79,7.88,7.87,7.75,7.48,6.91,6.04,4.96,3.76,2.65,1.75,1.28,1.09,1,0.99,1.02,1.16,1.59,2.41,3.75,5.35,6.78,7.27,6.70,5.50,3.97,2.16,1.20,0.51,0.47,0.49,0.40,0.28,0.12,-0.09,-0.26,-0.38,-0.39,-0.33,-0.16,0.03,0.25,0.45,0.59,0.65,0.70,0.73,0.82,1,1,2,2,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,-0.08,0.25,-0.87,-1.98,-3.36,-5.47,-7.12,-8.01,-8.78,-9.25,-9.38,-9.27,-9.09,-8.89,-8.87,-9,-9.25,-9.58,-9.90,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-9.80,-9.59,-9.37,-9.16,-9,-8.90,-8.87,-8.87,-8.90,-8.98,-9.05,-9.15,-9.25,-9.37,-9.48,-9.60,-9.73,-9.86,-9.99,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.96,-9.75,-9.54,-9.33,-9.10,-8.87,-8.63,-8.37,-8.11,-7.85,-7.61,-7.41,-7.30,-7.36,-7.54,-7.85,-8.18,-8.53,-8.88,-9.22,-9.53,-9.80,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-9.88,-9.59,-9.26,-8.89,16,16,18.04,19.22,20.64,20.53,19.46,18.14,16.97,16.10,15.62,15.42,15.37,15.36,15.37,15.46,15.63,15.99,16.45,17.12,17.87,18.87,18.92,19,19,18,17,17,16,16,15,15,16,16,16,16,16,16,16,15,15,13,13,12,12,12,13,14,15,16,16,15,14,14,14,14,15,15,15,15,14,13,13,13,13,12,11.35,10.97,10.96,11.33,11.84,12.33,12.88,13.62,14.67,15.82,16.99,18.12,19.11,19.84,20.32,20.64,21.08,21.64,22.22,22.33,21.51,20,18.16,16.25,14.34,12.75,11,11,12,11,10,8,7,6,6,6,7,7,7,6,5,4,4,5.63,6.12,6.36,6.38,6.57,6.83,7.08,7.26,7.37,7.39,7.26,6.91,6.27,5.37,4.27,3.17,2.21,1.60,1.25,1.08,1,0.99,1.02,1.22,1.70,2.63,4,5.52,6.57,6.58,5.87,4.79,3.50,2,1,1,1,0.74,0.63,0.49,0.25,0,-0.21,-0.30,-0.33,-0.25,-0.13,0.07,0.28,0.52,0.73,0.85,0.90,0.96,1.10,2,2,2,2,1,1,2,1,1,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0.91,0.14,-1.08,-2.14,-3.46,-5.03,-6.75,-7.67,-8.40,-8.80,-8.96,-8.93,-8.85,-8.76,-8.80,-8.99,-9.26,-9.59,-9.90,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.75,-9.50,-9.27,-9.09,-8.92,-8.85,-8.83,-8.86,-8.91,-9,-9.12,-9.22,-9.33,-9.42,-9.54,-9.67,-9.80,-9.93,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.97,-9.75,-9.51,-9.27,-9.03,-8.78,-8.53,-8.27,-8.01,-7.76,-7.54,-7.38,-7.29,-7.35,-7.51,-7.83,-8.16,-8.52,-8.88,-9.18,-9.49,-9.75,-9.97,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-9.75,-9.49,-9.13,-8.76,14,15,17,17.87,18.75,19.62,18.53,17.48,16.64,16.24,16.11,16.16,16.28,16.38,16.50,16.66,16.96,17.33,17.75,18.13,18.78,19.82,19.98,19.98,20,18,17,17,16,16,16,16,16,16,17,17,17,17,17,16,15,14,13,13,12,12,13,13,14,15,15,14,14,14,14,14,15,16,15,15,15,13,12,12,11,11,10.33,10.24,10.97,11.66,12.32,12.96,13.61,14.36,15.36,16.49,17.70,18.88,19.91,20.62,20.92,20.98,20.95,21,21,20.67,19.85,18.42,16.71,14.85,13.01,11.17,9.36,9.01,9,9,8,6,5,5,5,6,7,7,7,6,5,4,4,4.98,6.14,5.91,5.99,6.11,6.29,6.51,6.75,6.95,7.04,7,6.65,5.98,4.96,3.77,2.63,1.92,1.46,1.17,1.04,1,0.99,1.02,1.24,1.76,2.76,4.12,5.50,6.25,5.96,5.21,4.17,3.11,2,1,1,1,1,0.91,0.75,0.45,0.13,-0.10,-0.22,-0.24,-0.21,-0.13,0.03,0.27,0.57,0.78,0.95,1,1.04,1.14,1,2,2,2,2,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.90,-0.63,-1.24,-2.23,-3.38,-4.99,-6.23,-7.25,-7.96,-8.36,-8.54,-8.61,-8.61,-8.63,-8.75,-8.98,-9.26,-9.60,-9.90,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-9.96,-9.68,-9.41,-9.17,-8.99,-8.85,-8.77,-8.77,-8.84,-8.92,-9.02,-9.14,-9.25,-9.37,-9.48,-9.61,-9.74,-9.88,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.93,-9.72,-9.47,-9.22,-8.96,-8.68,-8.42,-8.16,-7.91,-7.67,-7.49,-7.35,-7.27,-7.30,-7.48,-7.76,-8.13,-8.50,-8.85,-9.14,-9.40,-9.64,-9.84,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-9.72,-9.37,-9.01,-8.63,13,14,15,17,16.90,17.74,16.96,16.45,16.29,16.35,16.60,16.95,17.26,17.51,17.74,18,18.36,18.75,19.12,19.28,19.25,20.10,20.84,21.89,19.99,19,18,17,17,16,16,16,16,17,17,18,18,18,17,17,15,14,13,13,13,13,13,13,13,14,14,13,13,13,13,14,15,16,15,15,14,13,12,11,11,10,9.32,10.48,11.36,12.15,12.87,13.54,14.22,14.96,15.92,17.07,18.28,19.50,20.60,21.33,21.47,21.20,20.75,20.32,19.86,19.23,18.24,16.87,15.25,13.51,11.77,10.02,7.74,8.08,8.98,7,6,5,4,4,5,6,7,7,7,5,4,4,3,3,4.85,5.28,5.47,5.61,5.77,6,6.32,6.63,6.91,7,6.75,6.03,4.87,3.27,2.38,1.73,1.35,1.13,1.02,0.99,0.99,1.03,1.25,1.79,2.83,4.17,5.41,6.01,5.61,4.73,3.65,2.77,2,2,1,1,1.12,1.50,1.01,0.60,0.26,0.03,-0.10,-0.15,-0.16,-0.14,-0.01,0.22,0.51,0.77,0.92,1,1.02,1.02,1,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0.90,-0.36,-1.16,-2.34,-3.34,-4.78,-6.01,-6.80,-7.50,-7.92,-8.15,-8.26,-8.36,-8.49,-8.67,-8.96,-9.26,-9.60,-9.89,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.89,-9.63,-9.36,-9.12,-8.91,-8.78,-8.74,-8.75,-8.83,-8.92,-9.03,-9.15,-9.27,-9.38,-9.50,-9.63,-9.76,-9.91,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.89,-9.65,-9.38,-9.12,-8.85,-8.58,-8.30,-8.04,-7.80,-7.60,-7.41,-7.29,-7.25,-7.25,-7.40,-7.68,-8.04,-8.41,-8.76,-9.08,-9.33,-9.52,-9.71,-9.86,-9.99,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-9.68,-9.33,-8.91,-8.49,12,13,14,14,15,15.12,15.22,15.36,15.98,16.48,17.07,17.75,18.29,18.71,19.02,19.37,19.79,20.32,20.73,20.84,20.71,20.25,20.97,21.86,20.07,19,18,17,17,16,16,16,17,17,18,19,19,19,18,17,15,14,13,13,13,13,13,13,13,13,13,13,13,13,13,13,14,15,16,15,14,12,11,11,10,10,10.14,11.08,12.08,12.72,13.38,14.01,14.66,15.39,16.39,17.54,18.77,20,21.09,21.82,21.87,21.33,20.57,19.72,18.86,17.89,16.75,15.37,13.85,12.25,10.70,9.12,7.75,7.23,6.76,6,5,4,4,4,5,6,7,6,6,5,4,3,3,3,3.98,4.66,4.91,5.10,5.26,5.53,5.97,6.50,7.02,7.36,7.25,6.72,5.11,3.27,2.28,1.62,1.26,1.10,1.01,0.99,1,1.07,1.29,1.83,2.90,4.34,5.57,6.07,5.50,4.48,3.32,2.52,2,1,1,1,1.12,1.76,1.15,0.65,0.36,0.16,0.03,-0.08,-0.13,-0.14,-0.08,0.13,0.45,0.70,0.86,0.92,0.98,0.99,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,0,0,0,0,0,0,0,0.75,-0.49,-1.61,-2.58,-3.55,-4.39,-5.62,-6.50,-7.17,-7.61,-7.85,-7.99,-8.13,-8.34,-8.61,-8.92,-9.25,-9.60,-9.89,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.86,-9.58,-9.28,-9.03,-8.85,-8.72,-8.66,-8.72,-8.79,-8.91,-9.04,-9.16,-9.28,-9.39,-9.51,-9.63,-9.78,-9.96,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.84,-9.59,-9.29,-9.01,-8.74,-8.47,-8.18,-7.93,-7.72,-7.51,-7.37,-7.26,-7.22,-7.23,-7.37,-7.62,-7.96,-8.30,-8.64,-8.96,-9.21,-9.40,-9.59,-9.75,-9.89,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-9.97,-9.63,-9.25,-8.88,-8.39,12,12,12,13,13,14,14.04,15.12,15.86,16.47,17.61,18.59,19.40,19.95,20.37,20.77,21.32,21.73,22.62,22.64,21.67,20.75,20.76,20.84,19.89,19,18,17,17,17,17,17,17,17,18,20,21,21,19,17,15,14,14,13,13,13,13,13,13,13,13,13,13,13,13,13,14,15,15,14,13,12,11,10,10,10,11,11.71,12.62,13.27,13.85,14.39,14.99,15.70,16.83,17.99,19.21,20.39,21.41,22.11,22.09,21.37,20.35,19.20,18,16.75,15.42,14.01,12.57,11.12,9.75,8.47,7.33,6.51,5.63,5.01,4,4,4,4,5,6,6,6,5,4,3,3,3,3,3.60,4.12,4.49,4.63,4.73,4.99,5.60,6.47,7.37,8.13,8.34,7.35,5.28,3.36,2.22,1.53,1.23,1.08,1,0.99,1,1.12,1.45,2.11,3.33,4.73,5.99,6.46,5.63,4.33,3.15,2.37,2,1,1,1,1.12,1.79,1.08,0.64,0.38,0.24,0.13,0.02,-0.05,-0.11,-0.05,0.12,0.36,0.51,0.61,0.72,0.79,0.87,1,1,1,2,2,2,1,1,1,1,2,2,2,2,2,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,0.59,-0.96,-2,-2.96,-3.83,-4.51,-5.25,-6.41,-7.05,-7.43,-7.65,-7.78,-7.97,-8.22,-8.53,-8.89,-9.25,-9.60,-9.89,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.80,-9.52,-9.25,-9,-8.79,-8.67,-8.64,-8.71,-8.79,-8.92,-9.08,-9.18,-9.29,-9.40,-9.51,-9.62,-9.77,-9.97,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.76,-9.50,-9.22,-8.91,-8.63,-8.36,-8.10,-7.86,-7.63,-7.47,-7.34,-7.25,-7.21,-7.22,-7.34,-7.53,-7.85,-8.16,-8.49,-8.78,-9.05,-9.29,-9.51,-9.72,-9.88,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-9.86,-9.50,-9.13,-8.77,-8.42,12,12,12,12,13,13,14,15,15.88,16.89,18.09,19.65,20.62,21.27,21.75,22.15,22.59,23.60,22.25,21.62,21,20.28,20.25,19.97,19.12,18,18,18,18,17,17,17,17,18,18,19,21,21,18,17,15,14,14,14,13,13,13,13,13,13,13,13,13,13,12,13,14,15,14,14,13,12,11,10,10,10,11,11.97,12.87,13.62,14.25,14.84,15.42,16.16,17.24,18.39,19.59,20.71,21.64,22.17,22.08,21.25,20.07,18.70,17.25,15.82,14.35,12.88,11.47,10.13,8.92,7.84,6.84,5.96,5.12,4.40,4,4,4,4,5,5,6,5,5,4,3,3,3,3,3.35,3.75,4.08,4.25,4.40,4.77,5.51,6.58,7.73,8.63,8.60,7.34,5.21,3.22,1.92,1.45,1.17,1.04,1,0.99,1.03,1.24,1.72,2.59,3.92,5.27,6.50,6.61,5.53,4.09,2.87,2.12,2,1,1,1,1.10,1.10,0.92,0.60,0.38,0.27,0.21,0.12,0.02,-0.02,0,0.13,0.29,0.37,0.33,0.25,0.17,0.10,1,1,1,1,1,1,1,1,1,2,2,2,2,3,3,2,1,1,1,1,1,1,1,0,0,0,0,0,0,1,-0.58,-1.35,-2.36,-3.22,-4.05,-5.10,-5.93,-6.60,-7.15,-7.49,-7.65,-7.75,-7.89,-8.15,-8.51,-8.89,-9.25,-9.60,-9.90,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.77,-9.50,-9.22,-8.98,-8.78,-8.67,-8.65,-8.73,-8.84,-8.97,-9.11,-9.23,-9.34,-9.42,-9.52,-9.63,-9.78,-9.99,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.93,-9.68,-9.41,-9.13,-8.83,-8.52,-8.25,-8,-7.77,-7.60,-7.43,-7.33,-7.24,-7.21,-7.23,-7.30,-7.50,-7.75,-8.02,-8.33,-8.63,-8.91,-9.21,-9.47,-9.71,-9.90,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.98,-9.67,-9.41,-9.14,-8.79,-8.47,12,12,12,12,13,13,14,15.12,16.20,17.13,18.29,19.84,21.62,22.60,22.70,23.59,23.59,22.59,21.60,20.37,20.24,20.11,19.87,19.79,18.87,18,18,19,19,18,18,18,18,18,18,19,20,20,18,17,15,14,14,14,13,13,13,13,13,13,13,13,13,12,12,12,13,14,13,13,13,13,11,10,10,10,11,11.99,12.96,13.85,14.70,15.38,16.03,16.71,17.64,18.82,19.92,20.97,21.76,22.12,21.88,20.99,19.65,18.16,16.60,15.01,13.48,12,10.60,9.36,8.25,7.24,6.37,5.50,4.71,4.23,4,4,4,4,4,5,6,5,4,3,3,3,3,3,3.20,3.45,3.67,3.86,4.08,4.51,5.34,6.46,7.66,8.51,8.37,7,4.88,2.97,1.62,1.34,1.12,1.02,0.99,1,1.09,1.37,2.03,3.16,4.60,5.95,6.64,6.25,5.04,3.66,2.34,2,1,1,1,1,1.09,1.10,0.87,0.62,0.40,0.29,0.24,0.16,0.10,0.07,0.10,0.20,0.28,0.33,0.27,0.24,0.14,0.07,1,1,1,1,1,1,1,1,2,2,2,2,3,2,2,2,1,1,1,1,1,1,1,0,0,0,0,0,0,1,-0.50,-1.66,-2.52,-3.28,-4.52,-5.59,-6.43,-6.99,-7.40,-7.67,-7.79,-7.87,-7.96,-8.22,-8.53,-8.90,-9.26,-9.61,-9.91,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.75,-9.49,-9.23,-9,-8.83,-8.74,-8.73,-8.78,-8.89,-9.02,-9.15,-9.27,-9.38,-9.48,-9.55,-9.66,-9.84,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.88,-9.63,-9.36,-9.04,-8.75,-8.46,-8.17,-7.93,-7.74,-7.55,-7.42,-7.33,-7.25,-7.22,-7.24,-7.33,-7.48,-7.66,-7.89,-8.15,-8.47,-8.80,-9.13,-9.43,-9.71,-9.92,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.88,-9.67,-9.40,-9.12,-8.78,-8.46,12,12,12,13,13,14,15,15.87,16.79,17.25,18.29,19.75,21.62,22.60,23.59,22.70,22.59,21.11,20.13,19.37,19.75,19.83,19.74,18.85,18.12,18,18,19,20,19,19,18,18,18,18,19,19,19,18,17,15,14,14,13,13,13,13,13,13,13,13,13,13,13,12,12,13,13,13,12,12,12,11,10,10,11,11,11.98,12.90,13.85,14.70,16.45,16.39,17.14,18.11,19.21,20.28,21.16,21.76,21.90,21.50,20.52,19.13,17.59,15.95,14.32,12.75,11.28,9.97,8.76,7.65,6.75,5.88,5.10,4.42,4.12,4,4,4,4,4,4,5,4,4,3,3,3,3,3,3.10,3.22,3.36,3.49,3.73,4.21,5.02,6.12,7.21,8,7.86,6.45,4.47,2.57,1.45,1.13,1.08,1,0.99,1,1.12,1.49,2.32,3.51,5.03,6.12,6.37,5.70,4.58,3.27,2.01,1,1,1,1,1,1.60,1.37,1.09,0.74,0.48,0.33,0.23,0.15,0.11,0.10,0.13,0.25,0.36,0.45,0.50,0.54,0.87,1.02,1,1,1,1,1,2,2,2,2,2,3,2,2,2,2,2,1,1,1,1,2,1,1,0,0,0,0,0,0,1,-0.49,-1.74,-2.47,-3.39,-4.74,-6,-6.92,-7.41,-7.76,-7.93,-8,-8.01,-8.10,-8.29,-8.59,-8.92,-9.27,-9.62,-9.91,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.75,-9.51,-9.26,-9.05,-8.89,-8.83,-8.83,-8.89,-9,-9.13,-9.24,-9.35,-9.42,-9.51,-9.61,-9.72,-9.88,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.86,-9.60,-9.30,-9,-8.68,-8.38,-8.13,-7.89,-7.71,-7.54,-7.41,-7.34,-7.26,-7.24,-7.25,-7.35,-7.48,-7.65,-7.87,-8.12,-8.40,-8.75,-9.10,-9.39,-9.67,-9.90,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.90,-9.63,-9.35,-9.05,-8.75,-8.37,12,12,12,12,13,14,15,16.87,16.99,17.75,18.23,19.32,20.62,22.61,22.60,21.28,20.37,19.39,18.38,18.87,19.65,19.71,18.83,18.10,17.12,18,18,19,20,20,20,19,19,18,18,19,19,19,18,16,15,14,14,13,13,13,13,13,13,13,13,13,14,14,13,13,13,13,12,12,11,11,12,11,10,11,11,11,12.04,13.12,14.15,15.20,16.60,17.46,18.40,19.52,20.64,21.29,21.63,21.53,20.99,19.92,18.50,16.92,15.25,13.62,12.07,10.65,9.41,8.27,7.28,6.35,5.48,4.75,4.29,4.08,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3.01,3.07,3.12,3.23,3.45,3.89,4.67,5.72,6.74,7.38,7.24,5.86,4.01,2.23,1.27,1.07,1.01,1,0.99,1,1.13,1.53,2.39,3.53,4.88,6.10,5.73,5.25,4.27,3.01,2,1,1,1,1,1.17,1.98,1.92,1.39,0.95,0.57,0.32,0.15,0.09,0.03,0.04,0.13,0.28,0.47,0.64,0.85,1.17,1.75,2,2,2,2,2,2,2,3,3,3,3,2,2,2,2,2,2,2,2,2,1,1,1,1,0,0,0,0,0,0,1,-0.22,-1.29,-2.26,-3.43,-5.09,-6.46,-7.39,-7.90,-8.09,-8.16,-8.17,-8.15,-8.22,-8.37,-8.64,-8.97,-9.29,-9.63,-9.93,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.77,-9.55,-9.35,-9.14,-9,-8.93,-8.96,-9.01,-9.12,-9.24,-9.34,-9.41,-9.50,-9.59,-9.64,-9.75,-9.91,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.85,-9.59,-9.28,-8.99,-8.65,-8.36,-8.10,-7.87,-7.67,-7.53,-7.42,-7.36,-7.29,-7.27,-7.30,-7.39,-7.53,-7.73,-7.92,-8.17,-8.48,-8.76,-9.05,-9.36,-9.62,-9.86,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.99,-9.67,-9.36,-9,-8.64,-8.28,12,12,12,13,13,14,16,16.89,17.15,17.23,17.79,18.67,19.34,19.99,20.01,19.39,18.75,18.16,17.92,18.01,18.32,18.72,17.87,17.15,17.01,17,18,19,19,20,21,20,19,19,19,19,19,18,17,16,15,14,14,13,13,13,13,13,13,13,13,14,15,15,14,13,13,13,12,11,11,11,11,10,10,11,11,11,12,12.95,13.12,15.03,16.28,17.46,18.53,19.62,20.65,21.47,21.38,21.09,20.38,19.26,17.83,16.22,14.52,12.87,11.35,10,8.85,7.89,6.96,6,5.13,4.50,4.17,4.03,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3.02,3.10,3.27,3.71,4.45,5.41,6.41,7.03,6.79,5.45,3.63,2.02,1.22,1.02,0.99,0.99,0.99,1,1.08,1.47,2.26,3.34,4.34,4.96,5.27,5.12,5,3,2,1,1,1,1,1.72,2.37,2.38,1.75,1.15,0.63,0.27,0.08,-0.01,-0.05,-0.02,0.10,0.29,0.58,0.87,1.21,1.62,2.16,3,3,2,2,2,2,3,3,4,3,3,3,2,2,2,2,2,2,2,2,1,1,1,1,0,0,0,0,0,0,0.85,-0.10,-0.91,-2.02,-3.64,-5.37,-6.64,-7.59,-8.16,-8.34,-8.39,-8.30,-8.25,-8.27,-8.41,-8.67,-9,-9.34,-9.65,-9.97,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.83,-9.63,-9.42,-9.25,-9.13,-9.08,-9.09,-9.14,-9.24,-9.35,-9.42,-9.50,-9.58,-9.63,-9.71,-9.76,-9.93,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.86,-9.60,-9.29,-8.99,-8.66,-8.37,-8.09,-7.87,-7.67,-7.54,-7.47,-7.38,-7.35,-7.35,-7.38,-7.48,-7.63,-7.83,-8.04,-8.28,-8.54,-8.80,-9.08,-9.30,-9.55,-9.79,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.75,-9.39,-9.04,-8.63,-8.16,13,13,13,13,14,15,17,17.92,17.13,17.12,17.25,17.28,18.04,18.28,18.29,18.03,17.37,17.37,17.33,17.33,17.28,17.22,16.87,16.13,16.07,17,17,18,19,19,20,21,19,19,19,19,19,18,17,15,14,14,13,13,13,13,13,13,13,13,14,14,15,15,15,14,13,13,12,11,11,11,11,10,10,11,11,11,12,13,13.95,14.97,16.23,17.45,18.62,19.73,20.65,21.26,21.12,20.67,19.86,18.67,17.22,15.51,13.74,12,10.49,9.25,8.28,7.46,6.58,5.66,4.87,4.35,4.10,4.01,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3.03,3.21,3.60,4.32,5.27,6.26,7.03,6.73,5.34,3.49,1.97,1.17,1.01,0.99,1,1,1,1,1,2,3,4,4,5,6,5,4,2,1,1,1,1,2.03,2.70,2.71,2.12,1.35,0.70,0.23,-0.01,-0.12,-0.14,-0.12,0.03,0.29,0.66,1.08,1.49,1.97,2.46,3,4,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,1,1,1,1,1,0,0,0,0,0,0,0.67,-0.08,-0.91,-2.04,-3.68,-5.52,-6.77,-7.67,-8.24,-8.46,-8.53,-8.38,-8.27,-8.28,-8.43,-8.72,-9.03,-9.38,-9.71,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.88,-9.71,-9.51,-9.37,-9.25,-9.21,-9.21,-9.26,-9.36,-9.43,-9.52,-9.61,-9.65,-9.72,-9.75,-9.84,-9.99,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.88,-9.63,-9.34,-9.02,-8.71,-8.39,-8.12,-7.88,-7.73,-7.61,-7.51,-7.47,-7.42,-7.42,-7.48,-7.59,-7.74,-7.93,-8.16,-8.40,-8.64,-8.88,-9.10,-9.30,-9.49,-9.75,-9.99,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.71,-9.40,-9.02,-8.60,-8.15,13,13,13,13,14,16,18,17.97,17.10,17.01,17.01,17.13,17.26,17.32,17.34,17.25,17,16.78,16.70,16.71,16.74,16.22,16,15.89,15.97,16,17,17,18,19,19,20,19,19,19,19,19,18,17,15,14,13,13,13,13,13,13,13,13,13,14,15,15,15,15,15,14,13,12,11,11,12,11,11,10,11,11,11,12,13,14,15.01,16.22,17.50,18.75,19.89,20.78,21.20,20.74,20.02,19.07,17.79,16.29,14.62,12.87,11.22,9.76,8.61,7.72,6.95,6.15,5.35,4.65,4.24,4.04,4,4,4,4,4,4,5,5,5,4,3,3,3,3,3,3,3,3,3.01,3.16,3.53,4.25,5.21,6.22,7.02,6.70,5.28,3.35,1.87,1.12,1,0.99,1,1,1,1,1,1,2,3,4,6,6,5,4,3,2,2,2,2,2.35,2.87,2.87,2.37,1.53,0.67,0.08,-0.11,-0.21,-0.23,-0.18,-0.03,0.26,0.72,1.23,1.73,2.15,2.58,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,1,1,1,1,1,0,0,0,0,0,0,0.57,-0.13,-0.99,-2.16,-3.73,-5.41,-6.73,-7.62,-8.18,-8.54,-8.49,-8.33,-8.25,-8.26,-8.43,-8.75,-9.09,-9.43,-9.76,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.93,-9.77,-9.61,-9.47,-9.37,-9.30,-9.30,-9.37,-9.46,-9.53,-9.63,-9.68,-9.75,-9.78,-9.84,-9.89,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.92,-9.66,-9.38,-9.08,-8.75,-8.42,-8.14,-7.93,-7.78,-7.68,-7.63,-7.58,-7.53,-7.53,-7.59,-7.68,-7.86,-8.04,-8.27,-8.51,-8.75,-8.97,-9.17,-9.38,-9.55,-9.73,-9.90,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.92,-9.64,-9.30,-8.93,-8.54,-8.10,14,14,14,14,15,17,18,17,17.07,16.99,17,17,17.01,17,17,16.87,16.70,16.28,16.27,16.25,16.10,15.82,15.12,15.07,15,16,16,17,17,18,18,19,19,19,18,18,18,18,17,15,14,13,13,13,13,13,13,13,13,13,14,15,16,16,16,15,14,13,12,12,13,12,11,11,11,11,11,11,12,13,13.92,14.89,16.22,17.59,18.99,20.32,21.14,21.24,20.41,19.48,18.33,16.96,15.39,13.74,12.04,10.48,9.11,8.01,7.16,6.42,5.72,5,4.47,4.14,4.02,4,4,4,4,4,4,5,6,5,4,4,3,3,3,3,3,3,3,3,3.11,3.48,4.17,5.13,6.13,7.01,6.85,5.26,3.22,1.65,1.08,1,1,1,1,1,1,1,1,2,3,4,5,6,6,5,4,4,3,2,2,2.85,3.21,3.21,2.73,1.84,0.85,0.04,-0.25,-0.29,-0.26,-0.29,-0.18,0.13,0.72,1.34,1.92,2.38,2.74,3,3,3,4,3,3,3,3,3,3,3,3,3,3,3,3,2,2,1,1,1,1,1,1,1,0,0,0,0,0,0.50,-0.12,-1.09,-2.29,-4.04,-5.42,-6.75,-7.48,-7.96,-8.35,-8.24,-8.17,-8.14,-8.25,-8.49,-8.79,-9.15,-9.51,-9.85,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.85,-9.68,-9.54,-9.46,-9.39,-9.40,-9.46,-9.53,-9.63,-9.71,-9.76,-9.83,-9.87,-9.89,-9.98,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.99,-9.74,-9.43,-9.13,-8.83,-8.50,-8.23,-8.02,-7.88,-7.79,-7.75,-7.71,-7.66,-7.66,-7.71,-7.79,-7.96,-8.16,-8.39,-8.62,-8.85,-9.04,-9.26,-9.49,-9.68,-9.84,-9.88,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.84,-9.54,-9.24,-8.89,-8.52,-8,14,14,14,15,16,17,18,17,17,16.99,16.99,16.99,16.98,16.97,16.85,16.74,16.25,16.13,16.01,15.88,15.84,15.12,15.07,15,15,15,16,16,17,17,17,18,18,18,18,18,18,18,16,15,14,13,13,13,13,13,13,13,13,13,14,15,16,16,16,15,15,14,14,13,12,12,11,11,11,11,11,11,12,12.01,13.11,14.83,16,17.49,19.04,20.45,21.24,21.13,20.12,19,17.67,16.21,14.59,12.90,11.27,9.78,8.52,7.52,6.73,6,5.34,4.73,4.32,4.09,4,4,4,4,4,4,5,5,6,5,5,4,3,3,3,3,3,3,3,3,3.03,3.39,4.09,5.07,6.07,6.92,7.27,5.39,3.21,1.20,1,1,1,1,1,1,1,1,1,2,3,4,5,6,6,6,5,4,4,3,3,3.49,3.79,3.75,3.23,2.26,1.16,0.26,-0.15,-0.27,-0.25,-0.28,-0.17,0.11,0.74,1.50,2.23,2.75,3.10,3,3,4,4,4,3,3,3,3,3,3,3,3,3,3,2,2,2,1,1,2,2,1,1,1,1,1,0,0,0,0.48,-0.21,-1.21,-2.88,-4.63,-5.98,-6.83,-7.59,-8,-7.97,-8,-8,-8.09,-8.27,-8.55,-8.89,-9.25,-9.62,-9.93,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.90,-9.75,-9.63,-9.52,-9.49,-9.49,-9.53,-9.62,-9.71,-9.78,-9.86,-9.90,-9.96,-9.99,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-10,-10,-10,-10,-10,-10,-9.79,-9.50,-9.21,-8.88,-8.59,-8.33,-8.13,-8.02,-7.96,-7.90,-7.87,-7.84,-7.83,-7.86,-7.93,-8.09,-8.28,-8.50,-8.73,-8.92,-9.15,-9.37,-9.58,-9.77,-9.89,-9.93,-9.97,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.97,-9.73,-9.47,-9.17,-8.87,-8.52,-7.87,14,14,15,16,18,19,18,17,17,17,16.99,16.99,16.98,16.86,16.82,16.20,16.12,16,15.87,15.86,15.10,15.07,15,15,15,15,15,16,16,16,16,16,16,17,17,17,17,17,16,15,14,13,13,13,13,13,13,13,13,14,15,16,16,16,16,16,15,15,14,13,12,11,11,12,12,11,11,11,11,11.92,12.85,14.11,15.54,17.11,18.71,20.12,20.96,20.87,19.96,18.61,17.15,15.57,13.88,12.20,10.60,9.20,8.04,7.13,6.38,5.71,5.08,4.52,4.20,4.03,4,4,4,5,5,5,5,6,6,6,5,4,3,3,3,3,3,3,3,3,3,3,4,5.01,6,6.96,7.96,5.96,3.03,1.02,1,0.99,1,1,1,1,1,1,1,2,3,4,5,6,6,7,6,5,4,4,4,4.38,4.60,4.48,3.87,2.85,1.62,0.58,0.01,-0.22,-0.34,-0.41,-0.33,0.04,0.87,1.82,2.73,3.35,3.74,4,4,4,4,4,4,3,3,3,3,3,3,3,2,2,2,2,2,1,1,1,1,1,1,1,1,1,0,0,0.98,0.34,-0.05,-1.90,-3.39,-5,-6.27,-7.21,-7.79,-8.02,-7.91,-7.84,-7.85,-8.03,-8.34,-8.65,-9.03,-9.39,-9.74,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.97,-9.80,-9.68,-9.61,-9.55,-9.58,-9.63,-9.71,-9.79,-9.88,-9.96,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-9.87,-9.58,-9.25,-8.93,-8.66,-8.42,-8.26,-8.17,-8.12,-8.08,-8.02,-8,-8,-8.02,-8.12,-8.25,-8.39,-8.62,-8.84,-9.04,-9.25,-9.47,-9.63,-9.78,-9.93,-9.99,-9.99,-9.96,-9.92,-9.91,-9.91,-9.99,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.86,-9.63,-9.39,-9.13,-8.84,-8.50,-7.72,15,15,16,18,19,20,18,17,17,17,17,16.99,16.92,16.89,16.12,16.12,16,15.87,15.89,15.07,15.02,15,15,15,16,15,15,15,15,15,15,15,15,16,17,16,16,17,16,15,14,13,13,13,13,13,13,13,13,14,16,16,16,16,17,16,16,15,15,14,13,12,11,12,13,12,11,11,11,11.10,12.16,13.24,14.96,16.50,18.02,19.41,20.33,20.40,19.66,18.38,16.76,15.09,13.33,11.61,10,8.70,7.66,6.87,6.22,5.57,4.96,4.45,4.12,4.01,4,4,5,6,7,6,6,6,7,6,5,4,3,3,3,3,3,3,3,3,3,3.01,4,5,6.10,7.09,7.87,5.87,3.12,1.10,1.08,1,0.99,1,1,1,1,1,1,1,3,4,5,6,7,8,7,6,5,5,5,5.50,5.52,5.29,4.63,3.52,2.14,0.88,0.23,-0.14,-0.43,-0.63,-0.60,-0.04,0.98,2.20,3.41,4.17,4.50,5,5,5,5,5,4,4,4,3,3,3,3,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,0,0,0.92,-0.37,-1.03,-2.51,-4,-5.13,-6.30,-7.27,-7.85,-8.02,-7.86,-7.75,-7.78,-8.05,-8.39,-8.78,-9.16,-9.52,-9.88,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.88,-9.75,-9.66,-9.63,-9.65,-9.72,-9.79,-9.89,-9.99,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-9.92,-9.63,-9.29,-9,-8.71,-8.49,-8.37,-8.33,-8.27,-8.24,-8.18,-8.15,-8.14,-8.17,-8.27,-8.40,-8.58,-8.75,-8.98,-9.17,-9.38,-9.54,-9.68,-9.80,-9.89,-9.96,-9.90,-9.88,-9.84,-9.84,-9.86,-9.92,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.80,-9.60,-9.36,-9.09,-8.78,-8.47,-7.53,16,16,17,19,20,19,18,17,17,17,17,17,17,16,16,16,16,16,15,15,15,15,15,15,16,16,16,15,15,15,15,15,14,15,15,15,16,16,16,15,14,13,13,13,14,14,14,14,14,15,16,17,17,17,16,16,16,15,15,15,14,12,12,12,13,12,12,11,11,11.12,11.90,12.90,14.34,15.88,17.37,18.64,19.54,19.84,19.35,18.15,16.54,14.74,12.90,11.12,9.53,8.28,7.39,6.74,6.17,5.62,4.97,4.39,4.07,4,4,4,5,6,7,7,7,6,6,5,4,4,4,3,3,3,3,3,3,3,3,3.07,4,5.01,6.12,7.83,7.82,5.82,3.16,2.03,1.12,1,0.99,0.99,1,1,1,1,1,1,2,4,5,6,7,8,8,7,6,6,7,6.66,6.58,6.27,5.63,4.32,2.74,1.29,0.37,-0.15,-0.58,-0.89,-0.91,-0.24,1.02,2.50,3.99,5.13,5.59,5,5,5,6,6,5,4,4,4,3,3,3,2,2,2,2,2,2,1,1,1,1,1,0,0,0,0,0,0,0.89,-0.43,-1.76,-3.13,-4.41,-5.63,-6.58,-7.38,-7.78,-7.92,-7.86,-7.73,-7.79,-8.13,-8.51,-8.91,-9.30,-9.68,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-9.93,-9.83,-9.75,-9.72,-9.74,-9.79,-9.88,-9.99,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-9.98,-9.65,-9.34,-9.01,-8.75,-8.58,-8.49,-8.46,-8.41,-8.38,-8.34,-8.28,-8.28,-8.34,-8.43,-8.59,-8.75,-8.92,-9.13,-9.34,-9.50,-9.63,-9.75,-9.83,-9.87,-9.87,-9.85,-9.78,-9.75,-9.77,-9.85,-9.93,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.79,-9.58,-9.30,-9.02,-8.72,-8.38,-7.30,17,18,19,20,19,18,18,17,17,17,17,17,17,16,16,16,16,15,15,15,15,15,15,15,16,17,16,16,15,15,15,14,14,14,14,15,15,15,15,14,14,13,13,13,14,15,15,14,14,15,16,17,18,17,16,16,16,16,15,15,14,13,13,12,14,13,12,12,11,11.12,11.95,12.25,13.99,15.47,16.89,18.13,18.99,19.29,19,17.96,16.37,14.48,12.58,10.76,9.22,8.01,7.21,6.70,6.34,5.90,5.26,4.17,4,4,4,5,6,7,8,8,7,7,6,5,4,4,4,4,4,3,3,3,3,3,3,3.12,4,5,6.10,6.97,6.90,5.76,3.87,2.21,1.17,1,0.99,0.99,0.99,1,1,1,1,1,2,4,5,5,7,8,8,7,8,8,8,7.86,7.70,7.38,6.72,5.22,3.37,1.57,0.41,-0.17,-0.63,-0.93,-1.05,-0.36,1.03,2.63,4.35,5.38,5.82,5,5,6,6,6,5,5,4,4,3,3,3,2,2,2,2,2,2,1,1,1,1,0,0,0,0,0,0,0,0.87,-0.58,-2.04,-3.52,-5.21,-6.35,-7.26,-7.83,-8.04,-8,-7.88,-7.75,-7.87,-8.23,-8.63,-9.04,-9.48,-9.87,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-9.88,-9.79,-9.76,-9.79,-9.87,-9.97,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-9.65,-9.34,-9.02,-8.79,-8.65,-8.61,-8.58,-8.54,-8.51,-8.47,-8.41,-8.41,-8.48,-8.60,-8.75,-8.91,-9.11,-9.29,-9.48,-9.63,-9.73,-9.79,-9.85,-9.86,-9.85,-9.80,-9.76,-9.74,-9.76,-9.85,-9.96,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.79,-9.55,-9.28,-8.99,-8.66,-8.34,-7.13,18,19,20,21,19,18,18,17,17,18,17,17,17,16,16,16,16,15,15,15,15,15,15,15,15,16,16,16,15,15,15,14,14,14,14,14,15,15,14,14,14,14,14,14,14,15,16,15,15,15,16,17,18,17,17,16,16,16,15,14,14,14,14,13,13,14,13,12,12,11.87,12.23,12.62,13.99,15.49,16.83,17.99,18.75,19.02,18.73,17.74,16.17,14.29,12.32,10.42,8.82,7.62,6.91,6.62,6.52,6.64,6,5,4,4,5,6,7,9,9,8,8,7,6,5,5,4,4,4,4,5,3,3,3,3,3.01,3.15,4.01,5.01,6,6.77,7.74,5.75,4.01,2.24,1.22,1.01,0.99,0.99,0.99,0.99,1,1,1,1,2,3,5,5,6,6.97,7.08,7.92,8.87,9.87,9.12,8.87,8.58,8.29,7.70,6.12,4,1.91,0.41,-0.17,-0.62,-0.92,-1.02,-0.40,1,2.59,4.25,5.62,5,5,5,5,6,6,6,5,4,4,3,3,3,2,2,2,2,2,2,1,1,1,1,0,0,0,0,0,0,0,0.87,-0.64,-1.98,-3.96,-5.61,-6.75,-7.58,-8.05,-8.15,-8.14,-7.90,-7.83,-7.99,-8.35,-8.75,-9.21,-9.63,-10,-10,-10,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-9.96,-9.87,-9.83,-9.84,-9.90,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-9.65,-9.34,-9.04,-8.87,-8.76,-8.73,-8.71,-8.67,-8.63,-8.59,-8.52,-8.50,-8.58,-8.72,-8.88,-9.08,-9.25,-9.42,-9.59,-9.73,-9.79,-9.85,-9.88,-9.88,-9.87,-9.84,-9.80,-9.78,-9.83,-9.86,-9.93,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.99,-9.78,-9.55,-9.29,-9,-8.66,-8.34,-7.01,18,19,21,20,19,18,18,18,18,17,17,17,17,16,16,16,16,15,15,15,15,15,15,15,15,15,15,15,16,15,15,15,15,15,15,15,15,15,15,15,15,14,14,14,15,16,16,15,15,15,16,18,18,17,17,17,16,16,16,15,14,15,15,14,13,13,14,13,12,12.13,12.91,13.62,14.71,15.89,17.25,18.28,18.95,19.10,18.65,17.62,16.07,14.17,12.21,10.34,8.77,7.71,7.14,7.02,7.04,7,7,5,4,5,6,7,8,9,10,9,8,8,7,6,5,5,4,5,4,4,4,3,3,3,3.01,3.20,4.01,5.01,6.10,6.98,7.03,6.08,4.28,2.26,1.25,1.02,1,0.99,0.99,0.99,1,1,1,1,2,3,3.88,4.35,5.32,6.25,7.16,8.12,9.21,10.33,10.46,9.63,8.82,8.42,8.13,6.95,4.60,2.35,0.60,-0.11,-0.53,-0.76,-0.96,-0.36,0.97,2.39,3.78,4.98,5,5,5,5,5,5,5,4,4,3,3,3,2,2,2,2,2,2,2,2,1,1,1,0,0,0,0,0,0,0,0.87,-0.79,-1.92,-3.88,-5.51,-6.75,-7.55,-8.02,-8.22,-8.14,-7.93,-7.88,-8.12,-8.43,-8.88,-9.36,-9.80,-10,-10,-10,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-9.88,-9.84,-9.86,-9.91,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-9.66,-9.36,-9.11,-8.96,-8.88,-8.86,-8.85,-8.80,-8.76,-8.71,-8.64,-8.60,-8.65,-8.83,-9.01,-9.22,-9.38,-9.53,-9.66,-9.77,-9.86,-9.90,-9.93,-9.92,-9.90,-9.89,-9.89,-9.89,-9.88,-9.89,-9.96,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.99,-9.78,-9.58,-9.33,-9.03,-8.74,-8.38,-7.02,18,20,21,21,20,19,18,18,18,17,17,17,17,16,16,16,16,15,15,15,15,15,15,15,15,15,15,15,15,15,15,16,16,16,16,17,17,16,16,16,15,15,14,14,15,16,16,15,15,15,16,17,18,17,17,17,16,16,15,15,16,16,16,14,13,14,14,13,13,13.27,13.77,14.59,15.62,16.91,18.12,19.03,19.54,19.54,18.95,17.74,16.10,14.16,12.16,10.32,8.88,8.04,7.65,7.63,8.01,9,6,5,5,6,7,8,9,11,10,10,9,9,7,6,5,5,5,4,4,4,3,3,3,3,3.01,3.22,4.01,5.02,6.11,7.70,7.67,6.67,4.86,3.13,1.26,1.15,1,0.99,0.99,0.99,1,1,1,2,2.01,3.24,3.91,4.47,4.92,6.01,7.12,8.24,9.38,10.41,11.03,9.72,8.52,8.04,8.46,7.23,5.15,2.98,1.13,0.15,-0.15,-0.30,-0.50,-0.14,0.84,2.13,3.01,4,4,4,4,4,4,4,4,4,3,3,3,3,2,2,2,2,2,2,2,2,2,2,1,0,0,0,0,0,0,0,0.87,-0.65,-2.11,-3.43,-5.13,-6.61,-7.63,-8.16,-8.22,-8.10,-7.99,-8,-8.21,-8.55,-9.03,-9.51,-9.99,-10,-10,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-9.88,-9.80,-9.80,-9.88,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-9.72,-9.42,-9.22,-9.09,-9.02,-9.01,-9,-8.98,-8.91,-8.85,-8.75,-8.72,-8.76,-8.92,-9.13,-9.34,-9.50,-9.63,-9.74,-9.84,-9.90,-9.97,-10,-10,-9.98,-9.98,-10,-10,-9.98,-9.96,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.99,-9.80,-9.61,-9.37,-9.10,-8.79,-8.46,-7,18,20,22,22,20,19,18,18,18,17,17,17,17,16,16,16,16,15,15,15,15,15,15,15,15,15,15,15,15,15,16,16,18,17,18,18,18,18,17,17,16,15,15,15,15,16,16,15,15,15,16,17,17,17,17,16,16,16,16,16,16,17,16,15,14,14,14,14,14.04,14.27,14.79,15.72,16.95,18.22,19.36,20.25,20.61,20.41,19.58,18.14,16.34,14.29,12.26,10.50,9.24,8.52,8.57,9.02,9.97,9,7,6,6,7,8,9,10,12,11,10,9,8,8,7,6,5,5,4,4,3,3,3,3,3,3.02,3.23,4,4.99,6.04,6.84,7.11,6.66,5.66,3.84,2.28,1.26,1.04,1.01,1,1.09,1,1,2,2.98,3.35,3.92,4.60,5.10,5.61,6.22,7.25,8.37,9.50,10.47,10.72,9.53,8.28,6.62,7.25,7.62,5.71,3.63,1.63,0.41,0.25,0.29,0.40,-0.60,0.90,2,3,4,4,4,4,4,3,3,4,3,3,3,3,2,2,2,2,2,2,2,2,1,1,2,1,0,0,0,0,1,1,0.01,0.60,-0.63,-2.08,-3.43,-5.02,-6.53,-7.61,-8.25,-8.25,-8.15,-8.08,-8.12,-8.33,-8.75,-9.21,-9.68,-10,-10,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-9.88,-9.77,-9.77,-9.85,-9.98,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-9.80,-9.55,-9.37,-9.25,-9.22,-9.21,-9.17,-9.14,-9.09,-8.99,-8.90,-8.86,-8.90,-9.05,-9.25,-9.43,-9.60,-9.71,-9.79,-9.88,-9.97,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.84,-9.63,-9.39,-9.13,-8.84,-8.49,-6.93,19,21,23,22,21,19,19,18,18,18,17,17,17,16,16,16,16,15,15,15,15,15,15,15,15,15,15,15,15,16,16,17,18,19,19,19,19,19,18,18,17,16,15,15,15,15,15,15,15,15,16,16,16,16,16,16,16,16,16,17,17,17,16,15,15,15,15,15,15.37,15.58,16.12,17.12,18.35,19.72,20.96,21.74,22.12,21.82,20.67,18.88,16.74,14.51,12.33,10.60,9.62,9.41,9.88,10.97,11,9,8,8,8,8,9,10,11,12,12,11,10,9,8,7,6,6,5,4,4,3,3,3,3,3,3.02,3.25,3.99,4.86,5.74,6.65,6.82,6.65,5.79,4.66,2.91,1.27,1.17,1.13,1.14,1.10,2,2,3,3.75,4.38,4.96,5.46,5.89,6.29,6.75,7.54,8.66,9.66,10.29,10.21,9.23,7.92,6.89,6.57,6.76,6.83,4.88,1.02,0,0,0,1,1,1,2,4,4,5,4,4,3,3,3,3,3,3,3,3,2,2,2,3,2,2,2,2,1,1,1,0,0,0,0,0,1,0.01,0.35,0.33,-0.73,-1.90,-3.78,-5.40,-6.53,-7.49,-8.13,-8.25,-8.24,-8.21,-8.27,-8.53,-8.91,-9.39,-9.88,-10,-10,-11,-11,-12,-12,-12,-12,-12,-13,-13,-13,-13,-13,-12,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-9.96,-9.84,-9.79,-9.86,-9.97,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-9.96,-9.74,-9.55,-9.46,-9.41,-9.40,-9.38,-9.35,-9.26,-9.16,-9.08,-9.01,-9.04,-9.18,-9.38,-9.53,-9.67,-9.77,-9.88,-9.96,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.88,-9.65,-9.41,-9.14,-8.85,-8.48,-6.87,19,21,23,22,21,20,19,19,18,18,17,17,17,16,16,16,16,15,15,15,15,15,15,15,15,16,16,16,16,17,17,18,18,19,20,20,20,20,19,18,17,16,15,15,15,15,15,15,16,16,15,16,16,16,16,16,16,16,17,17,18,17,17,16,16,16,16,17,16.66,16.88,17.50,18.39,19.62,21.15,22.64,23.48,23.73,23.12,21.62,19.59,17.25,14.95,12.79,11.24,10.48,10.58,11,12,11,10,10,10,10,10,10,11,12,13,12,11,10,10,9,8,7,6,5,4,4,3,3,3,3,3,3.02,3.37,3.89,4.62,5.42,6.13,6.62,6.64,6.23,5.12,3.46,2.26,1.25,1.21,1.89,2.10,3.15,4.66,4.53,4.97,5.45,5.98,6.42,6.83,7.17,7.62,8.33,9.22,9.98,10.25,9.84,8.86,7.65,6.62,5.82,6.03,5.78,4.85,1.08,0,0,0,0,0,1,2,3,4,5,4,4,3,3,3,3,3,3,3,3,2,2,3,3,3,3,3,2,1,1,0,0,0,0,0,0,0,0.12,0.26,0.11,-0.78,-1.89,-3.72,-5.55,-6.87,-7.88,-8.28,-8.35,-8.34,-8.37,-8.48,-8.73,-9.12,-9.59,-10,-10,-11,-11,-11,-12,-12,-12,-13,-13,-13,-13,-13,-13,-13,-13,-13,-12,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-9.88,-9.84,-9.87,-9.99,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-9.92,-9.77,-9.67,-9.63,-9.62,-9.60,-9.53,-9.47,-9.36,-9.24,-9.16,-9.17,-9.30,-9.48,-9.63,-9.76,-9.88,-9.98,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.91,-9.68,-9.42,-9.14,-8.84,-8.42,-6.78,19,21,23,22,21,20,20,19,19,18,18,17,17,16,16,16,16,15,15,15,15,15,15,15,16,16,16,17,17,17,18,18,18,19,20,21,21,21,20,18,17,16,15,15,15,15,15,15,15,15,15,16,16,16,16,16,16,16,16,17,17,18,18,17,17,17,17,18,17.74,18.02,18.62,19.46,20.54,21.98,23.48,24.28,24.61,23.96,22.61,20.32,17.77,15.34,13.11,11.67,11.32,11.70,13,13,13,12,12,12,11,11,11,12,13,13,13,12,11,10,10,9,8,7,6,5,4,4,3,3,3,3,3.08,3.28,3.75,4.40,5.20,5.96,6.62,7.03,6.90,6.02,4.51,3.02,2.08,2.11,2.82,3.87,5.08,5.73,6,6.23,6.58,7.01,7.42,7.79,8.15,8.62,9.24,9.96,10.46,10.42,9.70,8.52,7.29,6.24,5.59,5.26,5.75,3.20,1.84,0.10,0,0,0.01,0.12,1.03,2.07,3.98,4,5,4,4,3,3,3,3,3,3,3,3,3,2,3,3,3,4,3,2,2,1,0,0,0,0,0,0,0,0.15,0.33,0,-0.83,-1.98,-3.75,-5.75,-7.12,-8.09,-8.36,-8.38,-8.42,-8.50,-8.64,-8.92,-9.34,-9.78,-10,-10,-11,-11,-12,-12,-12,-12,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-12,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-11,-10,-10,-10,-10,-9.93,-9.88,-9.90,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-9.90,-9.86,-9.84,-9.79,-9.75,-9.65,-9.53,-9.41,-9.35,-9.35,-9.43,-9.58,-9.72,-9.86,-9.99,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.98,-9.74,-9.47,-9.15,-8.84,-8.38,-6.77,19,21,22,22,21,20,20,20,20,19,19,18,17,16,16,16,16,15,15,15,15,15,15,16,16,16,16,17,17,18,18,19,19,20,20,21,21,21,19,18,17,16,16,15,15,15,15,15,15,15,15,16,16,17,17,16,16,16,16,17,17,18,19,18,17,17,18,18,18.40,18.91,19.52,20.26,21.09,22.11,23.15,24.12,24.49,24,22.76,20.71,18.12,15.74,13.62,12.60,12.54,13.10,14,14,15,14,14,13,12.79,12.58,12.36,12.50,12.76,12.88,12.66,12.40,11.58,10.79,10,10,10,8,7,6,5,4,4,3,3,3,3.08,3.23,3.62,4.25,5.01,5.86,6.70,7.53,7.73,7.04,5.39,3.77,2.54,2.24,3.73,5.34,6.48,7.21,7.29,7.50,7.73,8.08,8.41,8.77,9.16,9.63,10.22,10.78,11.09,10.71,9.62,8.23,6.88,5.78,5.01,4.52,3.75,2.73,1.26,0.21,0.03,0.01,0.04,0.25,1.09,2.17,3.87,4.92,5,5,4,3,3,3,3,3,3,3,3,2,2,3,3,3,4,3,2,2,1,1,0,0,0,0,0,0.11,0.23,0.29,-0.17,-0.79,-2.33,-4.01,-5.48,-6.89,-7.71,-8.21,-8.39,-8.50,-8.63,-8.83,-9.13,-9.51,-9.99,-10,-10,-11,-11,-12,-12,-12,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-12,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-10,-10,-10,-10,-10,-9.92,-9.96,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-9.92,-9.84,-9.71,-9.59,-9.50,-9.50,-9.58,-9.66,-9.80,-9.96,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.76,-9.50,-9.18,-8.86,-8.39,-6.83,20,21,22,22,21,20,20,20,21,21,20,18,17,16,16,16,16,15,15,15,15,15,16,16,16,16,16,17,17,18,18,19,19,20,21,21,21,20,19,18,18,17,16,15,15,15,15,15,15,15,16,16,17,17,17,17,17,17,16,17,17,18,19,18,18,18,18,18,18.91,19.54,20.22,20.76,21.34,22.07,22.79,23.42,23.67,23.33,22.45,20.75,18.23,15.88,13.99,13.35,13.62,14.12,15,15,15,15,14.98,13.63,13.25,13.13,12.98,12.84,12.85,12.84,12.62,12.20,11.60,10.95,10.36,10.01,10,9,8,7,6,5,5,3,3.12,3.03,3.09,3.17,3.54,4.14,4.88,5.71,6.64,7.84,8.39,7.83,6.12,4.51,2.97,3.13,4.51,6.12,7.64,8.42,8.59,8.74,8.88,9.12,9.38,9.72,10.12,10.60,11.14,11.62,11.73,11,9.61,7.95,6.46,5.26,4.41,3.67,2.90,1.97,1.07,0.32,0.12,0.10,0.13,0.35,1.12,2.17,3.25,4.83,5.90,5,4,4,3,3,3,3,3,3,3,3,2,3,3,4,4,4,3,3,2,1,1,0,0,0,0,0.15,0.24,0.11,-0.22,-0.93,-2.37,-4.03,-5.51,-6.75,-7.63,-8.14,-8.39,-8.58,-8.74,-8.97,-9.28,-9.71,-10,-10,-11,-11,-12,-12,-12,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-10,-10,-10,-10,-10,-9.99,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-12,-12,-12,-12,-12,-13,-13,-12,-12,-12,-12,-12,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-9.99,-9.86,-9.74,-9.66,-9.66,-9.73,-9.80,-9.96,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.79,-9.52,-9.24,-8.91,-8.47,-6.90,22,21,21,21,20,20,20,20,20,20,20,19,18,17,17,16,16,16,16,16,16,16,16,16,16,16,16,17,17,18,18,19,20,21,21,21,21,20,20,19,18,17,16,15,15,15,15,15,15,16,16,16,17,17,17,17,17,17,17,17,17,18,18,19,19,19,19,19,19.27,19.99,20.66,21.20,21.57,21.99,22.48,22.87,22.91,22.52,21.75,20.32,18.08,15.77,14.24,13.99,14.41,15.29,15,15,16,14.98,14.01,13.50,13.16,13.04,13,12.90,12.87,12.83,12.62,12.21,11.64,11.11,10.76,10.61,10.98,10,9,8,7,6,5,4.12,3.37,3.20,3.27,3.41,3.74,4.22,4.78,5.49,6.29,7.14,7.90,7.70,6.50,5.15,4.24,4.32,5.33,6.83,8.46,9.59,9.79,9.92,10.01,10.11,10.28,10.57,10.91,11.37,11.87,12.37,12.36,11.33,9.61,7.72,5.98,4.76,3.86,3.07,2.25,1.45,0.49,0.34,0.28,0.33,0.29,0.42,1.14,2.11,3.27,4.26,4.84,4.90,4,4,4,3,3,3,3,3,3,3,3,3,3,4,4,5,5,4,3,2,1,0,0,0,0,0.21,0.16,0.04,-0.25,-1.09,-2.24,-3.79,-5.52,-6.86,-7.68,-8.14,-8.43,-8.63,-8.84,-9.09,-9.42,-9.87,-10,-10,-11,-11,-12,-12,-12,-13,-13,-13,-13,-14,-14,-14,-14,-13,-13,-13,-13,-13,-13,-13,-13,-13,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-12,-12,-12,-13,-13,-13,-13,-13,-13,-13,-13,-12,-12,-12,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-9.88,-9.83,-9.84,-9.89,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.84,-9.59,-9.30,-9,-8.58,-7.01,22,22,20,20,20,20,20,19,19,19,19,19,20,19,18,17,17,17,16,16,16,16,16,16,16,16,17,17,17,17,18,19,20,21,21,21,21,21,21,20,20,18,16,16,15,15,15,15,15,16,17,16,17,17,17,17,17,17,17,18,18,18,19,19,20,20,19,19,19.50,20.20,21.03,21.57,21.87,22.08,22.26,22.37,22.15,21.59,20.62,19.29,17.29,15.28,14.12,14.32,14.98,15.53,16,16,15,14.08,13.35,12.95,12.84,12.79,12.77,12.78,12.82,12.83,12.66,12.34,11.84,11.37,11.07,10.91,10.72,10,10,8,7,7,6,4.33,3.87,3.73,3.70,3.75,3.96,4.25,4.66,5.17,5.78,6.48,6.92,6.87,6.33,5.58,5,5.12,6,7.48,9.27,10.62,10.88,11.04,11.03,11,11.10,11.27,11.54,11.90,12.33,12.66,12.59,11.46,9.64,7.62,5.62,4.37,3.50,2.65,1.79,1.04,0.52,0.35,0.50,0.49,0.49,0.50,1.21,2.11,3.12,4.65,4.73,4.15,4.03,4,4,3,3,3,3,3,3,3,3,4,4,4,4,5,4,4,3,2,1,0,0,0,0,0.11,0.13,0,-0.30,-1.13,-2.26,-3.78,-5.72,-6.96,-7.75,-8.18,-8.49,-8.71,-8.91,-9.18,-9.55,-10,-10,-11,-11,-12,-12,-12,-13,-13,-13,-13,-14,-14,-14,-14,-14,-14,-14,-13,-13,-13,-13,-13,-13,-13,-13,-12,-12,-12,-12,-12,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-12,-12,-12,-13,-13,-13,-14,-14,-14,-14,-13,-13,-13,-13,-12,-12,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-9.98,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.88,-9.64,-9.38,-9.09,-8.64,-7.11,22,21,20,19,19,19,19,18,18,18,18,19,19,20,19,19,18,17,17,16,16,16,16,16,16,17,17,17,17,17,18,18,19,20,21,22,22,22,22,22,21,19,17,16,15,15,15,15,15,16,16,16,17,17,17,17,17,17,17,18,18,18,19,20,20,19,19,19,19.40,20.25,21.21,21.96,22.17,22.17,22.14,21.98,21.50,20.70,19.58,18.12,16.42,14.72,14.03,14.50,15.13,15.84,16,15,14.20,13.35,12.73,12.51,12.47,12.50,12.59,12.67,12.79,12.87,12.82,12.53,12.12,11.65,11.32,11.09,10.86,10.79,10,9,8,7,6,5.03,4.61,4.42,4.38,4.35,4.34,4.39,4.59,4.87,5.23,5.67,6.08,6.25,6.09,5.74,5.45,5.58,6.42,7.91,9.85,11.36,11.71,11.92,11.87,11.75,11.75,11.85,12,12.24,12.49,12.62,12.49,11.45,9.74,7.76,5.76,4.40,3.38,2.48,1.58,0.59,0.41,0.39,0.46,-0.43,0.42,0.63,1.21,2,2.99,3.66,3.95,4.03,4.87,4,4,3,3,3,3,3,3,3,3,4,4,4,3,3,3,4,2,1,1,0,0,0,0,0.09,0.10,-0.09,-0.42,-1.09,-2.71,-4.21,-5.61,-6.86,-7.66,-8.22,-8.53,-8.77,-9,-9.29,-9.67,-10,-10,-11,-11,-12,-12,-12,-13,-13,-13,-14,-14,-14,-14,-14,-14,-14,-14,-14,-13,-13,-13,-13,-13,-13,-13,-13,-12,-12,-12,-12,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-12,-12,-13,-13,-14,-14,-14,-14,-14,-14,-14,-14,-14,-13,-13,-12,-12,-12,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.97,-9.72,-9.43,-9.13,-8.71,-7.15,21,20,19,19,18,18,18,18,18,18,18,18,19,19,19,19,18,18,17,16,16,16,16,16,16,17,17,18,18,18,17,18,19,20.02,21.13,22.41,22.59,22.76,22.84,23.32,21.41,19.15,17.20,16,15,15,15,15,15,16,16,16,17,17,17,17,17,17,17,17,18,18,19,20,20,19,19,19,19.17,20.17,21.22,21.99,22.23,22.10,21.89,21.54,20.90,19.92,18.63,17.13,15.50,14.36,14.12,14.65,15.26,15.87,17,16,13.86,12.84,12.34,12.25,12.28,12.41,12.61,12.79,12.98,13.08,13.03,12.83,12.46,11.99,11.59,11.28,11.09,10.83,10,9,8,7,6,5.61,5.40,5.37,5.36,5.23,4.96,4.73,4.62,4.64,4.75,5,5.37,5.67,5.84,5.76,5.71,5.78,6.60,8.03,9.98,11.61,12.11,12.48,12.50,12.35,12.29,12.32,12.36,12.45,12.52,12.50,12.15,11.32,9.89,8.12,6.33,4.75,3.50,2.47,1.51,0.61,0.39,0.39,0.40,-0.41,-0.41,0.45,1.08,1.75,2.60,3.54,3.37,3.26,4.12,4.02,4,3,3,3,3,3,3,3,3,4,4,3,3,2,2,2,2,1,1,0,0,0,0,0.07,0.02,-0.17,-0.54,-1.25,-2.88,-4.39,-5.62,-6.76,-7.63,-8.25,-8.63,-8.89,-9.13,-9.41,-9.79,-10,-10,-11,-11,-12,-12,-13,-13,-13,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-13,-13,-13,-13,-13,-13,-13,-13,-12,-12,-12,-12,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-12,-12,-13,-13,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-13,-13,-13,-12,-12,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.79,-9.50,-9.18,-8.73,-7.18,20,20,20,19,19,18,18,18,18,18,18,18,18,19,19,18,17,17,16,16,16,16,16,16,16,16,17,17,17,17,17,18,19.01,20.11,21.25,22.25,23.01,23.26,23.15,22.45,21,18.95,17.20,15.95,15.01,15,15,15,15,16,16,16,17,17,17,18,17,17,17,17,18,18,19,20,20,19,19,19,19,20.08,21.01,21.71,21.90,21.79,21.50,21.02,20.34,19.28,17.90,16.36,14.97,14.37,14.47,14.92,15.37,16,16,15,13.57,12.62,12.21,12.13,12.28,12.60,12.96,13.26,13.46,13.48,13.37,13.14,12.79,12.34,11.89,11.51,11.24,10.95,11,9,8,7,6.15,6.23,6.25,6.37,6.45,6.26,5.88,5.39,4.98,4.66,4.48,4.52,4.85,5.27,5.62,5.75,5.76,5.99,6.53,7.85,9.62,11.32,12.11,12.66,12.86,12.83,12.75,12.72,12.67,12.65,12.60,12.42,12.02,11.28,10.16,8.53,6.79,5.13,3.74,2.54,1.53,0.84,0.37,0.40,0.38,-0.38,-0.38,0.37,0.61,1.41,2.25,2.86,3.28,3.67,4.11,4.96,4,4,3,3,3,3,3,3,3,3,3,3,2,1,1,1,1,1,1,0,0,0,0,0.07,-0.01,-0.26,-0.65,-1.54,-2.76,-4.24,-5.58,-6.77,-7.74,-8.38,-8.80,-9.09,-9.29,-9.58,-9.93,-10,-10,-11,-11,-12,-12,-13,-13,-13,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-13,-13,-13,-13,-13,-13,-13,-12,-12,-12,-12,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-12,-12,-13,-13,-14,-14,-14,-15,-15,-15,-15,-15,-15,-14,-14,-14,-13,-13,-13,-12,-12,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-9.89,-9.59,-9.25,-8.75,-7.22,20,20,20,21,19,18,18,18,18,18,18,18,18,18,18,17,17,16,16,16,16,16,16,16,16,16,17,17,17,17,17.01,18.02,19.07,20.17,21.37,22.46,23.25,23.54,23.12,22.03,20.33,18.50,16.90,15.87,15.33,15.01,15,15,15,16,16,16,17,17,17,18,17,17,17,17,18,18,19,20,19,19,19,19,19,20,20.78,21.28,21.46,21.36,20.92,20.38,19.73,18.83,17.45,15.87,14.72,14.51,14.87,15.25,15.98,16,15,14,13.25,12.49,12.12,12.10,12.37,12.87,13.48,13.95,14.13,14.03,13.77,13.45,13.04,12.59,12.12,11.67,11.25,10.91,11,9,9,7,6.78,6.76,6.99,7.25,7.42,7.35,6.95,6.29,5.63,4.95,4.45,4.26,4.50,4.91,5.37,5.62,5.70,5.88,6.33,7.41,9.09,10.71,11.84,12.58,12.99,13.13,13.13,13.11,13.03,12.92,12.76,12.49,12.01,11.27,10.34,8.90,7.14,5.52,3.99,2.71,1.58,0.57,0.39,0.45,0.37,-0.38,-0.38,0.37,0.61,1.14,1.87,2.52,3.14,3.66,4.22,4.95,5,4,3,3,3,3,3,3,3,3,3,3,2,1,1,1,1,1,1,0,0,0,0,0.16,-0.01,-0.29,-0.75,-1.65,-2.86,-4,-5.61,-6.98,-8,-8.72,-9.13,-9.38,-9.54,-9.77,-10,-10,-11,-11,-12,-12,-12,-13,-13,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-13,-13,-13,-13,-13,-13,-12,-12,-12,-12,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-12,-12,-13,-13,-14,-14,-14,-15,-15,-15,-15,-15,-15,-15,-15,-15,-14,-14,-13,-13,-13,-12,-12,-12,-11,-11,-11,-11,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-9.66,-9.30,-8.77,-7.23,20,20,20,20,20,19,18,18,18,18,18,17,17,17,17,16,16,16,16,16,16,16,16,16,16,16,16,17,16,17,17.36,18.10,19.12,20.25,21.50,22.72,23.58,23.76,23.07,21.65,19.86,17.99,16.53,15.70,15.27,15.07,15,15,15,16,16,17,17,17,17,17,17,17,17,18,18,18,19,19,19,19,19,19,19,20,20.98,21.08,21.01,20.75,20.22,19.67,19.11,18.37,17.15,15.78,14.74,14.75,15.37,15.98,16,16,15,14,13,12.34,11.99,12,12.37,13.08,13.91,14.70,14.90,14.60,14.12,13.54,13.04,12.54,12.09,11.62,11.10,10.53,10,9,8,7,7.07,7.21,7.50,7.84,8.12,8.16,7.89,7.25,6.37,5.41,4.60,4.12,4.14,4.52,4.99,5.32,5.48,5.72,6.09,6.97,8.57,10.11,11.42,12.27,12.91,13.33,13.50,13.48,13.42,13.29,13.08,12.71,12.12,11.27,10.15,8.78,7.36,5.88,4.49,3.08,1.84,0.50,0.48,0.40,0.37,-0.38,0.37,0.37,0.61,1.01,1.61,2.21,2.84,3.65,4.15,4.92,5,4,3,3,3,3,3,3,2,2,2,3,2,1,1,1,1,1,1,1,1,0,1,0.17,0,-0.30,-0.76,-1.53,-2.68,-4.03,-5.87,-7.37,-8.50,-9.24,-9.63,-9.80,-9.91,-10,-10,-10,-11,-11,-12,-12,-13,-13,-13,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-13,-13,-13,-13,-13,-13,-12,-12,-12,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-12,-12,-13,-13,-14,-14,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-14,-14,-13,-13,-13,-12,-12,-12,-11,-11,-11,-11,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-9.75,-9.38,-8.84,-7.25,19,19,20,20,20,19,18,18,18,18,17,17,17,17,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16.89,17.52,18.25,19.16,20.27,21.53,22.82,23.87,24.09,23.23,21.46,19.46,17.57,16.17,15.52,15.17,15.04,15,15,15,16,16,16,17,17,17,18,18,17,17,17,18,18,19,20,20,20,20,19,18,19,21,21,20.82,19.95,19.33,18.87,18.51,18.01,17.29,15.59,14.40,14.90,16,17,16,16,15,14,12.74,12.10,11.75,11.78,12.23,13.03,14.04,15.11,15.46,15.04,14.24,13.40,12.72,12.14,11.70,11.26,10.71,10.04,9,8,8,7,7.10,7.32,7.66,8.08,8.46,8.62,8.48,7.87,6.95,5.78,4.78,4.03,3.83,4.07,4.48,4.87,5.16,5.50,5.89,6.66,8.12,9.59,10.90,11.99,12.71,13.32,13.71,13.90,13.87,13.73,13.50,13.09,12.40,11.41,10.12,8.62,7.23,6.37,4.96,3.67,2.33,1.15,0.54,0.40,-0.38,-0.38,-0.38,0.41,0.62,0.87,1.35,1.85,2.39,3,3.87,4.92,5,4,3,3,3,3,3,3,2,2,2,2,2,1,1,1,1,1,1,1,1,1,0,0.17,0,-0.28,-0.76,-1.30,-2.40,-4.38,-6.25,-7.89,-9.15,-9.91,-10,-10,-10,-10,-10,-10,-11,-11,-12,-12,-13,-13,-13,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-13,-13,-13,-13,-13,-12,-12,-12,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-12,-13,-13,-14,-14,-14,-15,-15,-15,-15,-16,-16,-16,-15,-15,-15,-15,-15,-14,-14,-13,-13,-12,-12,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-9.77,-9.40,-8.87,-7.27,19,19,19,19,19,19,18,18,18,18,17,17,17,16,16,16,16,16,16,16,16,16,16,16,16,16,17,17,17,17.23,17.77,18.40,19.23,20.24,21.40,22.62,23.82,24.10,23.12,21.12,18.98,17.16,15.88,15.34,15.10,15.03,15.01,15,16,16,16,17,17,17,18,17,17,17,17,17,18,18,19,20,21,20,19,18,18,19,19,20,20,19,18,18,18,18,17,15,14,15,16,18,17,16,15,13,12.41,11.79,11.52,11.53,11.98,12.79,13.87,14.90,15.46,15.11,14.10,13.03,12.13,11.49,11.01,10.62,10.17,9.62,9,8,8,7,6.95,7.11,7.58,8.04,8.53,8.83,8.72,8.14,7.22,6.04,4.92,3.97,3.50,3.57,3.96,4.37,4.82,5.25,5.75,6.50,7.76,9.12,10.38,11.50,12.41,13.09,13.65,14.04,14.25,14.23,14,13.63,12.99,11.87,10.37,8.49,6.49,5.74,5.67,4.63,2.63,1.37,0.53,0.41,0.38,0.38,0.38,0.38,0.50,0.63,0.97,1.52,1.85,2.29,3.20,4.95,4,4,3,3,3,3,3,3,2,2,2,2,2,1,1,1,1,1,2,1,1,1,0,0.07,0,-0.27,-0.75,-1.28,-2.12,-4.60,-6.64,-8.46,-9.79,-10,-10,-10,-10,-10,-10,-11,-11,-11,-12,-12,-13,-13,-13,-14,-14,-14,-14,-14,-15,-15,-14,-14,-14,-14,-14,-14,-14,-14,-14,-13,-13,-13,-13,-13,-12,-12,-12,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-12,-12,-13,-13,-14,-14,-15,-15,-15,-15,-16,-16,-16,-16,-16,-15,-15,-15,-15,-14,-14,-14,-13,-13,-12,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-9.77,-9.41,-8.88,-7.33,19,19,19,18,18,18,18,18,18,18,17,17,17,16,16,16,16,16,16,16,16,16,16,16,16,17,17,17,17,17.66,18.07,18.57,19.25,20.12,21.14,22.17,23.14,23.37,22.36,20.29,18.28,16.59,15.54,15.15,15.03,15.09,15.17,15,16,16,16,16,17,17,17,17,17,17,17,17,18,18,19,20,20,19,18,17,17,18,18,18,18,18,18,18,17,17,16,15,14,15,16,18,17,16,14,13,12.21,11.62,11.34,11.35,11.72,12.41,13.39,14.46,15.07,14.83,13.64,12.48,11.45,10.72,10.24,9.88,9.57,9.26,9,9,8,7,6.45,6.62,7.20,7.82,8.46,8.87,8.82,8.24,7.32,6.23,5.08,3.99,3.32,3.14,3.42,3.91,4.42,4.98,5.57,6.33,7.38,8.61,9.79,10.88,11.86,12.72,13.35,13.91,14.34,14.54,14.54,14.33,13.82,13.20,10.73,8.66,6.15,4.21,4.70,3.65,2.60,1.37,0.50,0.33,0.34,0.34,0.33,0.28,0.28,0.35,0.49,0.83,1.24,1.83,2.84,3.03,4,3,3,3,3,3,3,3,3,2,2,2,2,1,1,1,1,1,1,1,1,1,0,0.04,0,-0.29,-0.75,-1.25,-2.41,-4.79,-6.98,-8.88,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-12,-12,-13,-13,-14,-14,-14,-14,-14,-15,-15,-15,-15,-15,-14,-14,-14,-14,-14,-14,-14,-13,-13,-13,-13,-13,-12,-12,-12,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-12,-12,-13,-13,-14,-14,-15,-15,-15,-15,-16,-16,-16,-16,-16,-16,-15,-15,-15,-15,-14,-14,-13,-13,-13,-12,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-9.75,-9.41,-8.89,-7.37,20,21,19,18,18,18,18,18,18,18,18,17,17,16,16,16,16,16,16,16,16,16,16,16,16,17,18,17,18,18.03,18.28,18.65,19.24,20,20.85,21.59,21.99,21.91,20.85,19.12,17.38,16.01,15.26,15,15.02,15.20,15.39,16,16,16,16,16,17,17,17,18,17,17,17,17,17,18,19,20,20,19,17,17,16,16,17,17,17,17,18,17,17,16,16,14,13,14,16,17,16,15,14,13,12.09,11.49,11.20,11.22,11.49,12,12.76,13.57,14.25,14.02,12.90,11.66,10.65,9.92,9.47,9.15,8.95,8.77,9,9,8,6,5.53,5.97,6.61,7.36,8.10,8.64,8.73,8.27,7.46,6.45,5.34,4.16,3.26,2.86,2.98,3.46,4.04,4.64,5.27,5.97,6.87,7.95,9.04,10.11,11.10,12.02,12.87,13.63,14.27,14.77,15.03,15,14.40,13.14,11.21,8.79,5.99,4.73,3.65,3.45,2.41,1.41,0.46,0.17,0.13,0.12,0.12,0.12,0.12,0.13,0.23,0.36,0.32,1.20,1.97,2.97,3,3,3,3,3,3,3,3,3,2,2,2,2,1,1,2,2,1,1,1,1,0,0,0.03,-0.04,-0.28,-0.73,-1.24,-2.52,-4.93,-7.17,-9.16,-10,-11,-12,-12,-11,-11,-11,-11,-11,-12,-12,-12,-13,-13,-14,-14,-14,-14,-14,-15,-15,-15,-15,-15,-14,-14,-14,-14,-14,-14,-14,-13,-13,-13,-13,-13,-12,-12,-12,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-12,-12,-13,-14,-14,-14,-15,-15,-15,-16,-16,-16,-16,-16,-16,-16,-16,-15,-15,-15,-14,-14,-13,-13,-13,-12,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-9.75,-9.41,-8.91,-7.41,20,21,20,18,18,19,19,19,19,19,18,17,17,16,16,16,16,16,16,16,16,16,16,16,17,17,18,18,18,18.26,18.40,18.70,19.23,19.92,20.62,21.03,21.01,20.42,19.29,17.85,16.41,15.37,14.91,14.85,15.01,15.28,15.62,16,17,16,16,16,17,17,18,18,17,17,17,17,17,18,19,20,20,18,17,16,16,16,16,16,17,17,17,17,16,15,14,13,13,13,15,15,16,15,14,13,12.03,11.41,11.13,11.14,11.32,11.62,12.04,12.50,12.79,12.51,11.53,10.57,9.72,9.11,8.71,8.46,8.35,8.20,8,8,7,6,5.22,5.28,5.87,6.67,7.42,8.01,8.25,8.12,7.61,6.76,5.67,4.41,3.34,2.62,2.57,3,3.63,4.25,4.85,5.41,6.17,7.12,8.13,9.20,10.23,11.23,12.17,13.04,13.84,14.53,15,15.01,14.62,13.33,11.47,9.33,7.14,5.47,4.54,3.79,2.84,1.48,0.45,0.12,0.04,0.01,0.01,0.01,0.01,0.03,0.08,0.12,0.24,0.95,1.04,2,2,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,1,1,1,0,0,0,0.03,-0.01,-0.25,-0.67,-1.21,-2.38,-4.92,-7.18,-9.25,-10,-11,-12,-12,-11,-11,-11,-11,-11,-12,-12,-12,-13,-13,-14,-14,-14,-14,-15,-15,-15,-15,-15,-15,-15,-14,-14,-14,-14,-14,-14,-13,-13,-13,-13,-13,-12,-12,-12,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-12,-12,-13,-14,-14,-14,-15,-15,-15,-16,-16,-16,-16,-16,-16,-16,-16,-15,-15,-15,-14,-14,-13,-13,-13,-12,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-9.74,-9.42,-8.96,-7.46,20,20,19,19,19,20,20,21,20,19,18,18,17,16,16,16,16,16,16,16,16,16,16,16,17,18,17,18,18,18.25,18.37,18.65,19.22,19.92,20.54,20.73,20.32,19.36,18.08,16.73,15.57,14.85,14.60,14.65,14.92,15.29,15.67,16,17,17,16,16,17,18,18,18,18,17,17,17,17,17,18,18,18,17,17,16,16,16,16,16,16,17,17,17,15,14,13,13,12,13,14,15,14,15,14,13,12,11.36,11.11,11.13,11.25,11.37,11.50,11.50,11.27,10.72,9.96,9.20,8.60,8.14,7.85,7.70,7.65,8,7,7,6,5,4.76,4.65,5.08,5.75,6.37,6.85,7.27,7.59,7.48,6.95,5.89,4.53,3.22,2.33,2.16,2.57,3.17,3.75,4.25,4.70,5.32,6.13,7.11,8.16,9.26,10.36,11.40,12.39,13.33,14.15,14.74,15.12,14.70,13.59,11.91,10.07,8.24,6.73,5.62,4.59,3.39,2.07,0.42,0.24,0.03,0,0,0,0,0,0,0.04,0.15,0.92,1.98,2,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,1,1,1,0,0,0,0,0.02,0.01,-0.18,-0.61,-1.14,-2.10,-4.64,-6.93,-9.08,-10,-11,-12,-12,-11,-11,-11,-11,-11,-12,-12,-12,-13,-13,-14,-14,-14,-14,-15,-15,-15,-15,-15,-15,-15,-14,-14,-14,-14,-14,-14,-13,-13,-13,-13,-13,-12,-12,-12,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-12,-12,-13,-14,-14,-14,-15,-15,-15,-16,-16,-16,-16,-16,-16,-16,-16,-15,-15,-15,-14,-14,-14,-13,-13,-12,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-9.99,-9.73,-9.42,-8.96,-7.47,19,19,19,19,20,21,21,21,20,19,18,17,17,16,16,16,16,16,16,16,16,16,16,16,17,17,18,18,18,18.04,18.21,18.57,19.21,20,20.66,20.75,19.89,18.61,17.15,15.88,14.97,14.49,14.34,14.45,14.74,15.12,15.58,16,17,16,16,17,17,18,18,18,18,18,17,18,18,17,17,18,17,17,16,16,16,16,16,16,16,16,17,15,14,13,12,12,12,12,12,13,13,13,13,13,12,11.01,11.14,11.21,11.27,11.25,11.12,10.74,10.10,9.20,8.26,7.75,7.35,7.02,6.77,6.66,6.98,7,7,6,6,5,4.15,4,4.23,4.83,5.17,5.50,5.96,6.59,6.88,6.53,5.54,4.04,2.67,1.85,1.86,2.26,2.79,3.23,3.52,3.78,4.33,5.03,6,7.10,8.26,9.46,10.61,11.72,12.75,13.67,14.52,14.84,14.60,13.75,12.37,10.79,9.24,7.87,6.70,5.48,4.08,2.54,1.24,0.33,0.04,0,0,0,0,0,0,0.01,0.07,0.97,2,3,4,3,3,3,3,3,3,2,2,2,2,2,1,2,2,2,1,1,0,0,0,0,1,0,0.09,-0.09,-0.51,-1.12,-1.89,-4.01,-6.42,-8.54,-10,-11,-11,-11,-11,-11,-11,-11,-11,-12,-12,-12,-13,-13,-14,-14,-14,-14,-15,-15,-15,-15,-15,-15,-15,-14,-14,-14,-14,-14,-14,-13,-13,-13,-13,-13,-12,-12,-12,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-12,-12,-13,-13,-14,-14,-15,-15,-15,-16,-16,-16,-16,-16,-16,-16,-16,-15,-15,-15,-14,-14,-14,-13,-13,-12,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-10,-10,-10,-10,-10,-10,-9.97,-9.71,-9.40,-8.92,-7.42,18,18,18,19,20,21,21,21,19,18,17,17,16,16,16,16,16,16,16,16,16,16,16,16,17,17,17,18,18,17.71,17.90,18.38,19.14,20.01,20.87,20.86,19.67,18.01,16.50,15.28,14.59,14.24,14.14,14.25,14.48,14.82,15.22,16,16,16,16,17,17,18,19,18,18,17,17,17,16,16,17,17,17,16,16,16,17,16,16,16,16,16,15,14,13,12,12,12,11,11,11,12,12,12,12,12,11,11,10.98,11.63,11.28,11.17,11,10.26,9.26,8.13,7.10,6.51,6.13,5.79,5.63,5.01,5,6,6,5,6,5,4,3.27,3.45,3.75,4.01,4.03,4.57,5.42,5.87,5.48,4.49,3.15,1.98,1.49,1.75,2.23,2.60,2.75,2.88,3,3.23,3.79,4.77,5.97,7.25,8.54,9.82,11.02,12.25,13.20,13.92,14.29,14.22,13.63,12.66,11.48,10.24,9,7.75,6.38,4.74,3.01,1.47,0.41,0.02,0,0,0,0,0,0,0,0.01,0,1,2,3,4,3,3,3,3,3,2,2,2,2,1,1,1,2,1,1,0,0,0,0,0,1,0,0.13,0.04,-0.46,-1.09,-1.92,-3.48,-5.85,-7.85,-9.42,-10,-11,-11,-11,-11,-11,-11,-11,-12,-12,-12,-13,-13,-14,-14,-14,-14,-15,-15,-15,-15,-15,-15,-15,-14,-14,-14,-14,-14,-14,-13,-13,-13,-13,-12,-12,-12,-12,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-12,-12,-13,-13,-14,-14,-15,-15,-15,-16,-16,-16,-16,-16,-16,-16,-15,-15,-15,-15,-14,-14,-13,-13,-13,-12,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-9.92,-9.65,-9.36,-8.88,-7.38,17,17,17,18,19,19,19,19,18,17,17,16,16,16,16,16,16,16,16,16,16,16,16,16,17,16,16,17,17,17.12,17.47,18.10,18.91,19.86,20.51,20.32,19.01,17.35,15.90,14.88,14.34,14.11,14.04,14.10,14.24,14.46,14.83,15,16,16,16,17,17,18,18,17,17,17,17,16,16,15,16,16,16,16,16,16,16,16,17,17,16,15,15,14,13,12,12,12,11,11,11,11,12,13,12,11,11,10,10,11,11.79,10.84,10.40,9.72,8.64,7.51,6.57,5.87,5.37,4.20,4,4,4,4,4,5,5,4,3,2.97,2.33,2.99,3,2.92,3.35,4.17,4.62,4.17,3.23,2.12,1.35,1.27,1.92,2.50,2.63,2.52,2.50,2.39,2.47,2.87,3.75,4.91,6.22,7.58,8.92,10.29,11.52,12.62,13.45,13.96,14.03,13.71,13.02,12.16,11.24,10.17,8.92,7.35,5.46,3.37,1.54,0.49,0,0,0,0,0,0,0,0,0,0,1,2,3,3,3,3,3,3,3,2,2,2,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0.15,0.08,-0.46,-1.09,-1.96,-3.48,-5.38,-7.17,-8.71,-9.80,-10,-10,-10,-11,-11,-11,-11,-12,-12,-12,-13,-13,-14,-14,-14,-14,-14,-15,-15,-15,-15,-15,-14,-14,-14,-14,-14,-14,-13,-13,-13,-13,-13,-12,-12,-12,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-12,-12,-13,-13,-14,-14,-15,-15,-15,-16,-16,-16,-16,-16,-16,-16,-15,-15,-15,-14,-14,-14,-13,-13,-13,-12,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-9.89,-9.62,-9.29,-8.79,-7.28,16,16,16,17,17,17,17,17,17,17,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16.20,16.97,17.65,18.48,19.27,19.62,19.14,17.87,16.51,15.33,14.57,14.17,14.03,14,14.02,14.09,14.17,14.20,15,15,16,16,17,17,17,17,17,17,17,16,16,15,15,15,15,15,16,16,16,16,17,18,17,16,15,15,14,13,13,12,12,11,11,11,11,12,13,13,12,11,10,10,10,11,10,9,9,8,7,6,6,5,4,4,4,4,4,5,5,4,3,3,2,2.02,2.27,2.57,2.57,2.66,3.10,3.32,2.87,2.12,1.45,1.23,1.50,2.27,3.97,3.02,2.72,2.37,2.07,1.96,2.15,2.84,3.87,5.14,6.57,8.04,9.49,10.84,12,12.97,13.61,13.87,13.76,13.41,12.91,12.34,11.54,10.34,8.57,6.29,3.82,1.66,0.48,0,0,0,0,0,0,0,0,0,1,1,2,3,3,3,3,3,3,2,2,2,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0.21,0,-0.38,-1.05,-1.96,-3.35,-5.09,-6.73,-8.13,-9.24,-9.98,-10,-10,-10,-11,-11,-11,-12,-12,-12,-13,-13,-13,-14,-14,-14,-14,-14,-15,-15,-15,-14,-14,-14,-14,-14,-14,-14,-13,-13,-13,-13,-13,-12,-12,-12,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-12,-12,-13,-13,-14,-14,-15,-15,-15,-15,-16,-16,-16,-16,-16,-15,-15,-15,-15,-14,-14,-14,-13,-13,-13,-12,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-9.88,-9.58,-9.24,-8.72,-7.18,17,17,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,15,16,16,16.36,17.08,17.79,18.33,18.29,17.65,16.71,15.62,14.77,14.32,14.09,14,14,14,14.01,14.03,14,14,15,16,16,16,16,17,17,17,17,16,16,16,15,15,15,15,15,15,15,15,16,16,17,17,16,15,14,14,13,13,13,12,11,11,11,11,12,13,13,13,11,10,10,10,10,10,9,8,8,7,6,5,4,4,4,4,4,5,6,6,5,4,3,3,2,2,2.84,2.66,2.11,2.12,2.10,1.87,1.45,1.11,1.22,1.84,3,3,4,3.09,2.39,1.84,1.48,1.46,1.72,2.74,3.97,5.49,7.12,8.66,10.12,11.35,12.38,13.14,13.59,13.76,13.76,13.64,13.38,12.77,11.75,9.88,7.25,4.48,1.78,0.48,0,0,0,0,0,0,0,0,0,1,2,2,3,3,4,3,3,2,2,2,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0.25,0.08,-0.28,-0.99,-1.90,-3.11,-4.87,-6.40,-7.75,-8.80,-9.55,-10,-10,-10,-10,-11,-11,-11,-12,-12,-13,-13,-13,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-13,-13,-13,-13,-13,-12,-12,-12,-12,-11,-11,-11,-10,-10,-10,-10,-9.93,-10,-10,-10,-10,-10,-11,-11,-11,-12,-12,-13,-13,-14,-14,-14,-15,-15,-15,-15,-16,-16,-16,-15,-15,-15,-15,-15,-14,-14,-14,-13,-13,-13,-12,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-9.84,-9.51,-9.13,-8.49,-7.10,19,17,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,17,17,18,17,17,16,16,16,17,16.01,16.38,16.88,17.28,17.08,16.46,15.63,14.89,14.38,14.13,14.02,14,14,14,14,14,14,14,15,15,16,16,16,16,16,17,16,16,16,16,16,15,15,15,15,15,15,15,15,16,16,16,16,16,15,13,13,13,12,12,11,11,11,12,12,13,13,13,12,11,10,10,10,10,9,8,7,6,5,5,4,4,4,4,5,6,6,7,5,4,3,2,2,2,2,2,2,1,1,1,1,1,1,2,3,4,4,3.97,3.12,2.16,1.54,1.28,1.32,2.04,3.02,4.62,6.24,7.87,9.39,10.77,11.95,12.85,13.48,13.89,14.17,14.37,14.39,13.99,12.87,10.85,8.11,5,2.27,0.59,0,0,0,0,0,0,0,0,1,1,2,3,3,3,3,3,2,2,2,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0.17,0.15,-0.14,-0.86,-1.83,-3.24,-4.68,-6.14,-7.41,-8.43,-9.22,-9.76,-10,-10,-10,-11,-11,-11,-12,-12,-13,-13,-13,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-13,-13,-13,-13,-12,-12,-12,-12,-11,-11,-11,-10,-10,-10,-10,-9.85,-9.80,-9.88,-10,-10,-10,-10,-11,-11,-11,-12,-12,-13,-13,-14,-14,-14,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-14,-14,-14,-14,-13,-13,-13,-12,-12,-12,-11,-11,-11,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-9.78,-9.48,-9.08,-8.27,-7,20,19,17,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,17,18,19,19,19,17,16,17,17,17,16,15.01,16.04,16.37,15.98,15.50,14.87,14.40,14.16,14.03,14,14,14,14,14,14,14,14,14,15,15,15,16,16,16,16,16,16,16,16,16,15,15,15,15,14,14,14,15,16,16,16,17,16,14,13,13,13,13,12,11,11,11,12,13,13,13,13,12,11,11,10,10,9,9,8,7,6,5,5,4,4,4,5,5,6,7,7,5,4,2,2,1,1,1,2,2,1,1,1,1,1,2,2.17,3.36,4.29,5.36,4.77,3.92,2.91,2.02,1.48,1.34,1.65,2.39,3.87,5.49,7.21,8.78,10.26,11.57,12.61,13.41,14.03,14.54,14.98,15.17,14.86,13.62,11.42,8.52,5.47,2.65,0.67,0,0,0,0,0,0,0,0,1,2,2,3,3,3,3,3,2,2,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0.13,0.21,-0.01,-0.64,-1.65,-3.10,-4.49,-5.84,-7.05,-8.10,-8.89,-9.50,-9.88,-10,-10,-10,-11,-11,-12,-12,-12,-13,-13,-13,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-13,-13,-13,-13,-13,-12,-12,-12,-11,-11,-11,-10,-10,-10,-10,-9.79,-9.65,-9.64,-9.74,-9.92,-10,-10,-10,-11,-11,-11,-12,-12,-13,-13,-13,-14,-14,-14,-15,-15,-15,-15,-15,-15,-15,-15,-15,-14,-14,-14,-14,-13,-13,-13,-12,-12,-12,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.99,-9.72,-9.39,-9,-8.21,-6.98,19,18,17,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,17,19,20,20,19,17,17,17,18,18,17,16,15,15.20,15.09,14.71,14.39,14.17,14.04,14,14,14,14,14,14,14,14,14,14,15,15,15,16,16,16,16,16,16,16,16,16,15,15,15,14,14,14,14,15,16,16,16,16,15,13,13,13,13,13,12,11,11,12,13,13,13,13,13,13,12,11,10,10,9,8,7,6,6,5,5,5,4,4,5,5,5,6,6,4,4,3,2,1,1,1,2,3,2,1,1,1,1.97,2.34,3.12,4,4.91,5.60,5.59,4.72,3.51,2.38,1.62,1.39,1.60,2.02,3.32,4.97,6.62,8.26,9.77,11.13,12.32,13.26,14.07,14.70,15.13,15.25,14.89,13.75,11.63,8.70,5.63,2.82,0.64,0,0,0,0,0,0,0,0,1,2,2,3,3,3,3,3,2,2,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0.22,0.15,-0.38,-1.41,-2.88,-4.15,-5.50,-6.74,-7.79,-8.63,-9.25,-9.67,-10,-10,-10,-11,-11,-12,-12,-12,-13,-13,-13,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-13,-13,-13,-13,-12,-12,-12,-12,-11,-11,-11,-10,-10,-10,-9.79,-9.59,-9.46,-9.46,-9.58,-9.77,-10,-10,-10,-10,-11,-11,-12,-12,-12,-13,-13,-14,-14,-14,-14,-14,-15,-15,-15,-15,-15,-14,-14,-14,-14,-14,-13,-13,-13,-13,-12,-12,-12,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.91,-9.64,-9.35,-8.93,-8.15,-6.98,18,18,18,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,17,20,21,20,18,17,17,17,17,18,16,16,15,15,14,14,14,14,14,14,14,14,14,14,14,15,15,14,14,15,14,15,15,16,16,16,16,16,16,16,16,16,15,14,14,14,14,15,15,16,16,16,16,14,13,13,13,13,13,12,11,11,12,13,14,14,14,14,14,12,11,10,10,9,8,7,6,6,5,5,5,4,5,5,5,4,4,3,3,4,3,2,1,1,1,2,3,2,1,1,1.02,1.99,2.82,3.67,4.65,5.52,6.04,6.08,5.33,4.07,2.84,1.87,1.49,1.51,2.10,3.04,4.49,6.14,7.78,9.36,10.82,12.11,13.20,14.10,14.79,15.25,15.28,14.66,13.26,11.11,8.46,5.52,2.84,0.52,0,0,0,0,0,0,0,1,1,2,3,3,2,2,3,3,2,2,1,1,1,2,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0.25,0.17,-0.23,-1.26,-2.36,-3.75,-5.14,-6.48,-7.59,-8.46,-9.08,-9.50,-9.86,-10,-10,-10,-11,-11,-12,-12,-13,-13,-13,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-13,-13,-13,-13,-12,-12,-12,-12,-11,-11,-11,-10,-10,-10,-9.85,-9.54,-9.34,-9.23,-9.24,-9.38,-9.59,-9.86,-10,-10,-10,-11,-11,-11,-12,-12,-12,-13,-13,-13,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-13,-13,-13,-13,-12,-12,-12,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.84,-9.59,-9.28,-8.89,-8.13,-6.97,18,17,17,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,17,19,20,19,18,17,17,17,17,16,16,16,15,15,14,14,14,14,14,14,14,14,14,15,15,15,15,15,15,15,15,14,14,15,16,16,16,16,17,16,16,15,15,14,14,14,14,14,15,16,16,17,16,14,13,13,13,13,12,12,12,12,12,13,14,14,14,15,14,13,11,10,9,8,7,7,6,6,5,5,4,4,4,5,4,3,3,2,3,3,3,2,1,1,2,3,3,2,2,1,1.66,2.21,3.04,4.09,5.10,5.92,6.36,6.38,5.75,4.62,3.33,2.16,1.62,1.53,2,2.87,4.11,5.73,7.36,8.98,10.50,11.88,13.09,14.03,14.75,15.14,15.03,14.28,12.77,10.59,7.97,5.24,2.62,0.36,0,0,0,1,1,1,1,1,1,2,3,2,2,2,2,3,2,2,1,1,2,2,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0.27,0.37,0,-0.92,-1.76,-3.15,-4.86,-6.29,-7.50,-8.36,-8.97,-9.37,-9.72,-10,-10,-10,-11,-11,-12,-12,-12,-13,-13,-13,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-13,-13,-13,-13,-12,-12,-12,-12,-11,-11,-11,-10,-10,-9.92,-9.60,-9.29,-9.09,-8.99,-9.01,-9.15,-9.38,-9.64,-9.93,-10,-10,-10,-11,-11,-11,-12,-12,-12,-13,-13,-13,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-13,-13,-13,-13,-12,-12,-12,-12,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.98,-9.75,-9.51,-9.23,-8.83,-8.10,-6.90,17,17,17,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,17,18,18,18,17,17,17,17,16,16,16,16,15,15,14,14,14,14,14,14,14,14,14,14,15,15,15,15,15,16,15,14,14,15,16,16,17,17,16,16,15,15,15,14,14,14,14,14,15,16,17,17,16,14,13,13,13,13,12,12,12,12,13,13,14,15,15,15,14,13,11,10,9,8,7,7,7,6,5,4.20,3.86,3.59,3.84,3.87,3.65,3.13,2.57,2.41,2.91,4,3,2,2,2,3,4,4,3,2,2,1.92,2.38,3.12,4.14,5.24,6.14,6.72,6.85,6.40,5.36,3.96,2.59,1.78,1.61,1.92,2.72,3.89,5.29,6.90,8.57,10.14,11.61,12.86,13.86,14.57,14.86,14.60,13.66,12.09,9.91,7.40,4.88,2.36,0.16,0,0,0,1,2,3,2,1,1,1,2,3,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0.21,0.36,0.23,-0.63,-1.37,-2.83,-4.66,-6.23,-7.48,-8.37,-8.93,-9.30,-9.61,-9.89,-10,-10,-11,-11,-12,-12,-12,-13,-13,-13,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-13,-13,-13,-13,-12,-12,-12,-11,-11,-11,-10,-10,-10,-9.72,-9.36,-9.03,-8.84,-8.74,-8.75,-8.90,-9.16,-9.43,-9.73,-10,-10,-10,-10,-11,-11,-11,-12,-12,-12,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-12,-12,-12,-12,-11,-11,-11,-10,-10,-10,-10,-9.90,-9.88,-9.90,-9.93,-9.97,-9.97,-9.98,-10,-10,-10,-10,-10,-10,-9.93,-9.89,-9.91,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.89,-9.67,-9.43,-9.14,-8.74,-8.01,-6.84,17,17,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,17,17,17,17,17,17,17,17,17,16,16,16,15,15,15,14,14,14,14,14,14,14,14,14,14,15,15,15,15,15,15,15,14,14,15,15,16,16,16,16,15,15,15,14,14,14,14,14,14,15,16,18,18,16,15,13,13,13,13,12,12,12,13,14,14,14,15,15,15,14,13,11,10,9,8,7,7,7,6.98,5.17,4.24,3.61,3.39,3.50,3.57,3.41,3.04,2.52,2.52,3.22,3.87,3.98,3,3,3,4,6,5,4,3,2.38,2.17,2.42,3.13,4.13,5.26,6.28,7.11,7.51,7.36,6.34,4.85,3.24,2.12,1.72,1.89,2.53,3.61,4.85,6.41,8.08,9.71,11.21,12.50,13.53,14.22,14.39,13.98,12.90,11.24,9.12,6.82,4.46,2.17,0,0,0,0,1,3,3,3,2,1,1,1,2,2,1,1,1,1,1,1,2,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0.11,0.33,0.37,-0.37,-1.24,-2.80,-4.66,-6.27,-7.59,-8.49,-9.04,-9.36,-9.59,-9.78,-10,-10,-10,-11,-11,-12,-12,-13,-13,-13,-13,-14,-14,-14,-14,-14,-14,-14,-14,-14,-13,-13,-13,-13,-12,-12,-12,-11,-11,-11,-10,-10,-9.96,-9.53,-9.15,-8.85,-8.62,-8.47,-8.52,-8.73,-8.98,-9.25,-9.52,-9.80,-10,-10,-10,-11,-11,-11,-11,-12,-12,-12,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-12,-12,-12,-12,-12,-11,-11,-11,-10,-10,-10,-9.87,-9.66,-9.58,-9.53,-9.59,-9.66,-9.73,-9.75,-9.76,-9.79,-9.86,-9.88,-9.88,-9.85,-9.78,-9.75,-9.75,-9.85,-9.97,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.86,-9.62,-9.37,-9.05,-8.63,-7.93,-6.75,17,17,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,17,17,17,17,17,17,17,17,17,16,16,16,15,15,15,14,14,14,14,14,14,14,14,14,14,14,14,15,15,15,15,15,15,14,14,14,15,15,16,15,15,16,15,14,14,14,14,14,14,14,15,16,17,17,16,15,13,13,13,13,12,12,12,13,14,14,15,15,15,14,14,13,12,10,9,8,8,7,7.98,6.32,5.27,4.22,3.60,3.32,3.39,3.50,3.50,3.23,2.86,2.96,3.71,4.67,5.58,4.98,4,4,5,6,7,6,5,3.53,2.63,2.57,3.15,4.13,5.29,6.47,7.50,8.37,8.57,7.64,5.87,4.11,2.63,1.89,1.86,2.36,3.29,4.40,5.88,7.49,9.07,10.52,11.82,12.83,13.46,13.53,13,11.87,10.34,8.34,6.15,4,1.92,0,0,0,0,1,2,3,3,2,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0.11,0.36,-0.18,-1.22,-3.14,-4.89,-6.55,-7.88,-8.80,-9.34,-9.53,-9.63,-9.74,-9.96,-10,-10,-11,-11,-12,-12,-12,-13,-13,-13,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-13,-13,-13,-12,-12,-12,-11,-11,-11,-10,-10,-9.84,-9.39,-9,-8.64,-8.40,-8.33,-8.38,-8.59,-8.83,-9.10,-9.37,-9.63,-9.90,-10,-10,-10,-11,-11,-11,-11,-12,-12,-12,-12,-13,-13,-13,-13,-13,-13,-13,-13,-12,-12,-12,-12,-12,-11,-11,-11,-11,-10,-10,-10,-9.77,-9.51,-9.34,-9.24,-9.23,-9.30,-9.41,-9.50,-9.54,-9.58,-9.61,-9.63,-9.64,-9.63,-9.62,-9.62,-9.63,-9.71,-9.84,-9.99,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.84,-9.60,-9.33,-9,-8.55,-7.86,-6.65,17,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,17,18,18,18,17,17,17,17,17,16,16,15,15,15,15,15,14,14,14,14,14,14,14,14,14,14,14,14,14,15,15,15,15,14,14,14,14,14,15,15,14,14,15,14,14,14,14,14,14,14,14,15,16,17,17,16,15,13,13,13,13,13,12,13,13,14,15,15,16,15,14,13,13,12,10,9,8,8,7,6.63,6.25,5.03,4.21,3.64,3.48,3.57,3.84,4.07,4.01,3.74,3.53,4.25,5.52,7.25,6.63,5,6,6,7,7,8,7,4.50,3.10,2.71,3.17,4.16,5.37,6.62,7.76,8.78,9.24,8.62,6.87,4.83,3.16,2.02,1.75,2.14,2.99,4,5.36,6.85,8.38,9.84,11.12,12.14,12.77,12.83,12.23,11.03,9.41,7.53,5.50,3.50,1.65,0,0,0,1,1,3,4,3,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0.13,-0.10,-1.25,-3.22,-5.42,-7.08,-8.43,-9.38,-9.84,-9.83,-9.76,-9.73,-9.86,-10,-10,-11,-11,-12,-12,-12,-13,-13,-13,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-13,-13,-13,-12,-12,-12,-11,-11,-10,-10,-9.87,-9.40,-8.99,-8.63,-8.38,-8.28,-8.36,-8.52,-8.75,-9.01,-9.27,-9.52,-9.77,-10,-10,-10,-10,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-10,-10,-10,-9.84,-9.51,-9.25,-9.05,-8.98,-9,-9.11,-9.22,-9.29,-9.36,-9.38,-9.41,-9.43,-9.47,-9.47,-9.49,-9.53,-9.62,-9.75,-9.90,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.87,-9.61,-9.30,-8.99,-8.53,-7.83,-6.61,17,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,17,18,17,17,17,17,17,16,16,15,15,15,15,15,15,14,14,14,14,14,14,14,14,14,14,14,14,14,14,15,15,14,14,14,15,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,15,16,17,18,17,14,13,13,13,13,13,13,13,14,15,15,17,16,15,14,13,13,12,11,9,8,7,6.20,5.89,5.39,4.64,3.97,3.61,3.66,4.11,4.74,5.29,5.41,5.04,4.53,4.53,6.37,8,8.36,7.20,7,7,8,9,8,7,5.27,3.78,3.07,3.35,4.26,5.42,6.67,7.76,8.62,9.07,8.66,7.25,5.21,3.42,2.12,1.64,1.98,2.67,3.57,4.79,6.15,7.61,9,10.27,11.33,11.98,12.03,11.45,10.26,8.67,6.87,4.91,2.99,1.34,0,0,0,1,2,2,4,3,2,1,1,1,0,0,0,1,1,1,1,1,1,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0.02,-0.11,-1.16,-3.59,-5.63,-7.87,-9.35,-10,-10,-10,-9.89,-9.74,-9.76,-10,-10,-10,-11,-11,-12,-12,-13,-13,-14,-14,-14,-14,-14,-15,-15,-15,-15,-14,-14,-14,-14,-13,-13,-13,-12,-12,-11,-11,-10,-10,-10,-9.54,-9.11,-8.75,-8.50,-8.38,-8.41,-8.55,-8.76,-9.01,-9.25,-9.50,-9.74,-9.98,-10,-10,-10,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-10,-10,-10,-10,-9.67,-9.36,-9.08,-8.87,-8.79,-8.85,-8.96,-9.04,-9.13,-9.16,-9.23,-9.27,-9.36,-9.38,-9.42,-9.50,-9.60,-9.74,-9.88,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.96,-9.67,-9.38,-9.02,-8.59,-7.87,-6.60,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,17,18,17,17,17,17,16,16,16,15,15,15,15,15,15,14,14,14,14,14,14,15,15,15,15,15,15,15,14,14,14,14,14,14,14,15,14,14,14,14,14,14,14,14,14,14,14,14,14,14,15,16,17,17,17,14,13,13,13,13,13,13,13,14,15,16,16,16,16,15,14,13,12,11,10,8,6,5.41,5.24,4.71,4.07,3.57,3.45,3.88,4.86,6.07,7.21,7.39,6.58,5.61,5.72,7.17,8.89,9.26,8.41,7,8,8,9,8,7,6.16,4.70,3.65,3.62,4.37,5.47,6.62,7.58,8.16,8.29,7.97,6.86,5.14,3.45,2.12,1.58,1.85,2.41,3.14,4.25,5.46,6.77,8.09,9.27,10.26,10.88,10.99,10.51,9.57,8.08,6.34,4.48,2.50,1,0,0,0,0,1,2,2,2,1,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.08,-0.15,-1.14,-3.47,-6.03,-8.13,-9.68,-10,-10,-10,-10,-9.75,-9.67,-9.89,-10,-10,-11,-11,-12,-12,-13,-13,-14,-14,-14,-14,-15,-15,-15,-15,-15,-15,-14,-14,-14,-14,-13,-13,-13,-12,-12,-11,-11,-10,-10,-9.88,-9.46,-9.04,-8.78,-8.65,-8.64,-8.74,-8.90,-9.13,-9.35,-9.55,-9.75,-9.99,-10,-10,-10,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-11,-10,-10,-10,-9.91,-9.61,-9.27,-8.98,-8.75,-8.68,-8.73,-8.80,-8.90,-8.98,-9.03,-9.12,-9.24,-9.36,-9.46,-9.53,-9.65,-9.76,-9.91,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-9.79,-9.49,-9.13,-8.68,-8,-6.65,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,17,18,18,17,17,16,16,16,16,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,14,14,14,14,14,14,14,15,14,14,14,14,14,14,14,14,14,14,14,14,14,15,16,16,16,15,14,13,13,13,13,13,13,14,14,15,16,15,15,16,15,14,13,12,11,11,8,6,5.37,4.75,4.12,3.49,3,3.11,4.04,5.67,7.51,9.12,9.25,8.08,6.82,6.70,8.08,9.82,11,9.45,8,8,9,9,9,9,7.36,5.88,4.57,4.10,4.54,5.53,6.61,7.41,7.79,7.75,7.28,6.36,4.99,3.48,2.26,1.67,1.77,2.20,2.76,3.72,4.76,5.98,7.17,8.32,9.29,9.97,10.12,9.75,8.84,7.54,5.95,4.15,2.38,0.82,0,0,0,0,1,2,2,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.04,-0.22,-1.11,-3.12,-5.79,-7.87,-9.42,-10,-10,-10,-10,-9.72,-9.61,-9.79,-10,-10,-11,-11,-12,-12,-13,-13,-14,-14,-14,-15,-15,-15,-15,-15,-15,-15,-15,-15,-14,-14,-14,-13,-13,-13,-12,-12,-11,-11,-10,-10,-9.77,-9.40,-9.13,-8.92,-8.87,-8.92,-9.08,-9.25,-9.47,-9.66,-9.87,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-11,-10,-10,-10,-10,-9.87,-9.53,-9.21,-8.88,-8.64,-8.59,-8.63,-8.72,-8.78,-8.86,-8.92,-9.03,-9.25,-9.42,-9.60,-9.74,-9.87,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-9.93,-9.63,-9.27,-8.85,-8.17,-6.75,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,17,18,17,17,16,16,16,16,16,16,15,15,15,15,15,15,15,15,16,16,16,16,16,16,16,16,16,16,15,15,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,15,16,17,16,15,14,13,13,13,13,13,13,14,14,15,15,15,15,15,14,14,13,12,11,10,9,6,5.23,4.46,3.70,3.01,2.60,2.99,4.35,6.42,8.75,10.51,10.67,9.36,8,7.58,8.61,10.57,10.88,10.29,9,9,9,9,10,10,8.61,6.98,5.53,4.65,4.77,5.62,6.62,7.40,7.63,7.51,7.04,6.24,5.04,3.67,2.54,1.87,1.78,2.02,2.42,3.23,4.11,5.22,6.34,7.40,8.35,9.01,9.25,8.99,8.22,7.03,5.61,3.95,2.25,0.70,0,0,0,0,1,2,2,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.01,-0.22,-0.89,-2.90,-5.08,-7.05,-8.83,-10,-10,-10,-10,-9.65,-9.51,-9.72,-10,-10,-11,-11,-12,-13,-13,-13,-14,-14,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-14,-14,-14,-13,-13,-13,-12,-12,-11,-11,-10,-10,-9.76,-9.47,-9.25,-9.16,-9.17,-9.25,-9.41,-9.60,-9.78,-9.98,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-9.76,-9.43,-9.10,-8.77,-8.55,-8.51,-8.58,-8.63,-8.68,-8.74,-8.84,-9.04,-9.33,-9.55,-9.76,-9.93,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-9.77,-9.41,-9,-8.38,-6.88,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,17,17,17,17,16,16,16,16,16,16,16,15,15,15,15,15,16,16,16,17,17,17,17,17,16,16,16,16,16,15,15,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,15,16,16,15,15,13,13,13,13,13,13,13,14,14,14,14,14,14,14,14,13,13,11,10,9,7,6,5.10,4.20,3.37,2.77,2.60,3.25,4.77,6.98,9.48,11.37,11.72,10.50,9.13,8.17,8.76,9.67,10.85,9.47,8,8,9,10,10,11,9.62,8,6.50,5.27,5.07,5.67,6.61,7.37,7.64,7.62,7.27,6.58,5.50,4.25,3.09,2.26,1.95,1.98,2.16,2.76,3.51,4.50,5.52,6.51,7.37,8.03,8.35,8.15,7.50,6.48,5.15,3.72,2.16,0.47,0,0,0,0,1,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.21,-0.74,-2.17,-4.50,-6.86,-8.63,-9.92,-10,-10,-9.97,-9.58,-9.40,-9.63,-10,-10,-11,-11,-12,-13,-13,-14,-14,-14,-15,-15,-15,-15,-15,-15,-16,-15,-15,-15,-15,-15,-14,-14,-14,-13,-13,-12,-12,-12,-11,-11,-10,-10,-9.86,-9.60,-9.47,-9.42,-9.49,-9.59,-9.75,-9.90,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-9.88,-9.60,-9.26,-8.96,-8.68,-8.52,-8.50,-8.51,-8.58,-8.63,-8.66,-8.83,-9.15,-9.43,-9.71,-9.92,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-9.90,-9.53,-9.13,-8.52,-7,16,16,16,16,16,16,16,16,16,16,16,16,17,17,16,16,16,16,16,17,17,17,16,16,16,16,16,16,16,16,16,16,16,16,16,17,17,17,17,18,18,18,17,17,17,17,16,16,15,15,15,15,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,15,15,16,15,14,13,13,13,13,12,13,13,14,14,14,14,15,15,15,14,13,12,12,10,9,7,6,5.09,3.96,3.07,2.63,2.77,3.65,5.33,7.27,9.45,11.46,12.12,11.25,9.90,8.70,8.58,8.95,8.98,8.53,8,8,9,10,11,12,10.82,8.74,7.35,6.09,5.29,5.52,6.32,7.14,7.61,7.87,7.82,7.29,6.29,5.02,3.75,2.76,2.23,2.03,2.14,2.64,3.24,4.04,4.88,5.67,6.36,6.96,7.24,7.12,6.61,5.72,4.60,3.35,2.07,0.91,0,0,0,0,1,2,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.18,-0.50,-1.65,-4,-6.38,-8.25,-9.62,-10,-10,-9.86,-9.41,-9.30,-9.55,-10,-10,-11,-12,-12,-13,-13,-14,-14,-14,-15,-15,-15,-15,-16,-16,-16,-16,-16,-15,-15,-15,-15,-14,-14,-14,-13,-13,-12,-12,-11,-11,-11,-10,-10,-9.99,-9.76,-9.68,-9.68,-9.76,-9.88,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-9.71,-9.39,-9.09,-8.77,-8.55,-8.43,-8.42,-8.48,-8.54,-8.63,-8.74,-8.97,-9.28,-9.59,-9.85,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-12,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-9.63,-9.16,-8.62,-7.08,16,16,16,16,16,16,16,16,16,16,16,17,18,18,17,16,16,16,16,16,16,17,16,16,16,16,16,16,16,16,16,16,17,17,17,17,17,18,18,19,19,18,18,18,18,17,17,16,15,15,15,15,15,14,14,14,14,14,14,14,13,14,14,14,14,13,14,14,14,15,15,15,14,13,13,13,12,12,13,13,14,15,14,14,15,15,15,15,13,13,13,11,9,8,7,5.10,3.72,2.88,2.66,3.09,4.13,5.64,7.42,9.27,11,12,11.65,10.50,9.34,8.62,8.34,8.15,7.76,7,7,8,10,12,12,10,9.34,8.23,7,5.82,5.46,5.97,6.65,7.42,8.10,8.54,8.29,7.28,5.95,4.59,3.40,2.62,2.09,2.22,2.62,3.12,3.77,4.42,5.04,5.54,5.89,6.01,5.88,5.45,4.73,3.83,2.84,1.90,0.99,0,0,0,0,1,2,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.12,-0.40,-1.13,-3.59,-5.83,-7.84,-9.38,-10,-10,-9.68,-9.30,-9.25,-9.75,-10,-10,-11,-12,-12,-13,-13,-14,-14,-15,-15,-15,-15,-16,-16,-16,-16,-16,-16,-16,-16,-15,-15,-15,-14,-14,-14,-13,-13,-12,-12,-11,-11,-11,-10,-10,-10,-9.98,-9.91,-9.93,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-9.83,-9.51,-9.21,-8.88,-8.62,-8.42,-8.37,-8.38,-8.43,-8.54,-8.71,-8.91,-9.16,-9.46,-9.73,-9.98,-10,-10,-10,-10,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-11,-10,-10,-10,-9.72,-9.22,-8.50,-7.13,16,16,16,16,16,16,16,16,16,16,16,17,18,19,17,17,16,16,16,16,16,16,16,16,17,16,16,16,16,16,17,17,17,18,18,18,18,19,19,20,20,19,19,19,18,18,17,16,16,15,15,15,15,14,14,14,14,14,14,13,13,13,14,14,13,13,13,14,14,14,14,14,14,13,13,12,12,12,13,13,14,14,14,14,15,15,15,14,13,12,12,11,10,10,7.14,5.73,4.13,3.22,3.02,3.53,4.59,5.95,7.48,9.03,10.50,11.49,11.75,10.98,10.04,9.10,8.33,7.82,7.38,7,7,8,9,10,11,10,9.97,9.53,7.84,6.41,5.51,5.47,6.15,7.13,8.21,9.25,9.40,8.48,6.85,5.37,4.07,2.88,2.42,2.51,2.91,3.39,3.89,4.35,4.72,5.02,5.17,5.13,4.84,4.36,3.73,2.98,2.20,1.45,1,0,0,0,0,1,1,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.27,-1.22,-2.77,-5.42,-7.67,-9.16,-9.90,-9.96,-9.61,-9.30,-9.50,-9.83,-10,-10,-11,-12,-12,-13,-13,-14,-14,-15,-15,-15,-16,-16,-16,-16,-16,-16,-16,-16,-16,-16,-15,-15,-15,-14,-14,-14,-13,-13,-12,-12,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-9.92,-9.63,-9.34,-9,-8.72,-8.49,-8.34,-8.29,-8.34,-8.42,-8.59,-8.78,-9.05,-9.34,-9.61,-9.86,-10,-10,-10,-10,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-10,-10,-10,-9.76,-9.26,-8.39,-7.16,16,16,16,16,16,16,16,16,16,16,16,17,18,19,18,17,17,16,16,16,16,16,16,17,17,17,16,16,16,17,17,18,18,18,19,20,20,20,20,20,20,20,20,19,19,18,18,17,16,16,15,15,14,15,14,14,14,14,13,13,13,13,13,13,13,13,13,14,14,14,14,14,13,13,12,12,12,12,13,13,14,14,14,15,15,15,15,14,13,12,11,11,10.01,9.73,8.51,6.17,4.47,3.37,3.17,3.74,4.79,6.07,7.46,8.79,10.01,11.10,11.76,11.49,10.59,9.64,8.71,7.95,7.41,7,7,7,8,9,10,10,10,9.95,8.72,7.17,5.76,5.20,5.64,6.85,8.13,9.62,10.57,9.27,7.60,6.01,4.63,3.65,3.20,3.25,3.63,4.14,4.52,4.82,4.96,5,4.92,4.71,4.26,3.53,2.89,2.21,1.52,0.89,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.07,-0.14,-1.25,-3.34,-5.25,-7.12,-8.61,-9.41,-9.68,-9.63,-9.55,-9.63,-9.92,-10,-10,-11,-12,-12,-13,-13,-14,-14,-15,-15,-15,-16,-16,-16,-16,-16,-16,-16,-16,-16,-16,-16,-15,-15,-15,-14,-14,-14,-13,-13,-12,-12,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-9.75,-9.47,-9.15,-8.87,-8.60,-8.38,-8.26,-8.25,-8.29,-8.42,-8.63,-8.89,-9.18,-9.48,-9.74,-9.99,-10,-10,-10,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-10,-10,-10,-9.80,-9.30,-8.42,-7.22,16,16,16,16,16,16,16,16,16,16,16,17,18,18,18,17,17,16,16,16,16,16,16,17,18,17,17,17,17,18,18,18,19,19,20,21,22,22,21,21,20,21,21,20,20,19,18,17,17,16,16,15,15,14,14,14,14,13,13,13,13,13,13,13,13,13,13,13,14,14,14,13,13,12,12,12,12,12,13,13,14,15,15,15,16,15,15,15,14,13,13,11.98,10.99,10.45,8.39,6.46,4.67,3.58,3.34,3.86,4.85,6.02,7.29,8.49,9.59,10.54,11.49,11.65,10.99,10.15,9.29,8.53,8.12,8,7,7,8,9,9,10,11,11,9.92,7.67,5.88,4.77,5.50,6.61,7.89,9.35,10.49,9.39,7.99,6.49,5.20,4.21,3.79,3.99,4.51,5.14,5.62,5.86,5.82,5.62,5.35,4.90,4.27,3.42,2.38,1.60,0.96,0.36,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.17,-0.11,-1.36,-3.71,-5.64,-7.22,-8.36,-9.13,-9.63,-9.61,-9.62,-9.73,-10,-10,-11,-11,-12,-12,-13,-13,-14,-14,-15,-15,-16,-16,-16,-16,-16,-16,-16,-16,-16,-16,-16,-16,-16,-15,-15,-15,-14,-14,-14,-13,-13,-12,-12,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-9.83,-9.58,-9.28,-9,-8.74,-8.50,-8.33,-8.23,-8.21,-8.27,-8.43,-8.68,-9,-9.29,-9.60,-9.86,-10,-10,-10,-10,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-11,-10,-10,-9.87,-9.36,-8.48,-7.27,16,16,16,16,16,16,16,16,16,16,16,17,19,18,18,17,17,16,16,16,16,16,16,17,17,17,17,17,18,19,19,19,19,20,20,22,23,23,21,21,21,21,22,22,20,19,18,17,17,17,16,16,15,14,14,14,13,13,13,13,13,13,13,13,13,13,13,13,13,14,13,13,12,12,12,12,12,12,13,13,14,15,15,15,16,16,16,15,15,14,13,12.73,11.20,9.85,8.25,6.38,4.78,3.72,3.38,3.84,4.74,5.82,6.95,8,9.01,9.99,10.76,11.46,11.26,10.62,9.77,9.12,9,9,8,8,8,9,9,11,13,12,10,7.92,5.12,5.16,5.77,6.25,7.57,8.79,9.63,9.23,8.01,6.79,5.62,4.73,4.46,4.79,5.54,6.32,6.92,7.23,7.17,6.85,6.37,5.75,4.91,3.87,2.58,1.47,0.70,0.11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.29,-0.23,-1.50,-3.75,-5.97,-7.63,-8.63,-9.15,-9.42,-9.52,-9.60,-9.75,-10,-10,-11,-11,-12,-12,-13,-13,-14,-14,-15,-15,-16,-16,-16,-16,-16,-17,-17,-17,-17,-16,-16,-16,-16,-16,-15,-15,-15,-14,-14,-13,-13,-13,-12,-12,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.84,-9.62,-9.37,-9.12,-8.86,-8.62,-8.40,-8.25,-8.14,-8.14,-8.25,-8.47,-8.75,-9.08,-9.38,-9.68,-9.98,-10,-10,-10,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-11,-10,-10,-9.90,-9.40,-8.51,-7.34,16,16,16,16,16,16,16,16,16,16,16,17,19,19,18,18,17,17,16,16,16,16,16,17,17,18,18,18,19,19,20,20,20,21,21,23,22,22,21,21,22,22,22,22,21,20,19,19,18,18,17,16,15,14,14,14,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,12,12,12,12,12,12,13,13,14,15,15,16,17,18,17,16,15,14,13.14,12.29,11.28,9.62,7.84,6.10,4.65,3.64,3.27,3.64,4.51,5.50,6.47,7.40,8.36,9.27,10.16,10.84,11.27,11.01,10.28,9.11,9,10,10,9,9,9,9,11,13,12,10,8,6.07,5.11,5.91,6.45,7.42,8.28,8.73,8.58,7.92,7.07,6.21,5.60,5.42,5.85,6.61,7.48,8.24,8.75,8.70,8.37,7.75,6.92,5.88,4.62,3.22,1.82,0.78,0.11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.37,-0.27,-1.63,-3.92,-6.35,-7.88,-8.86,-9.25,-9.33,-9.41,-9.52,-9.72,-10,-10,-11,-11,-12,-12,-13,-14,-14,-14,-15,-15,-16,-16,-16,-16,-17,-17,-17,-17,-17,-17,-17,-16,-16,-16,-16,-15,-15,-15,-14,-14,-13,-13,-12,-12,-12,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.96,-9.76,-9.59,-9.38,-9.14,-8.91,-8.71,-8.50,-8.29,-8.14,-8.05,-8.08,-8.22,-8.47,-8.79,-9.13,-9.48,-9.78,-10,-10,-10,-10,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-11,-10,-10,-9.96,-9.43,-8.54,-7.37,16,16,16,16,16,16,16,16,16,16,16,17,18,18,19,18,17,17,17,16,16,16,16,17,18,18,19,19,19,20,21,21,21,21,22,22,22,21,21,21,23,23,23,22,22,21,20,20,20,20,17,16,15,14,14,14,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,12,12,12,12,12,12,12,13,13,14,15,15,16,17,18,17,17,15,14,13.15,12.15,10.77,9.03,7.26,5.63,4.38,3.63,3.45,3.72,4.37,5.26,6.04,6.84,7.71,8.64,9.62,10.48,11.20,11.39,10.78,10.02,10,10,11,10,9,9,10,11,12,12,10,8,6,6.01,6.16,6.79,7.50,8.10,8.37,8.29,7.96,7.39,6.84,6.48,6.46,6.87,7.63,8.54,9.42,9.97,10.20,9.79,9.25,8.32,7.01,5.48,3.90,2.41,1.15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.45,-0.29,-2.03,-4.25,-6.05,-7.52,-8.47,-8.98,-9.18,-9.30,-9.42,-9.64,-10,-10,-11,-11,-12,-12,-13,-14,-14,-14,-15,-15,-16,-16,-16,-16,-17,-17,-17,-17,-17,-17,-17,-17,-16,-16,-16,-16,-15,-15,-15,-14,-14,-13,-13,-12,-12,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.86,-9.67,-9.50,-9.29,-9.11,-8.90,-8.73,-8.52,-8.36,-8.17,-8.04,-7.97,-8,-8.18,-8.50,-8.85,-9.22,-9.55,-9.89,-10,-10,-10,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-11,-10,-10,-9.96,-9.43,-8.55,-7.38,16,16,16,16,16,16,16,16,16,16,16,17,17,17,17,17,17,17,17,16,16,16,16,17,18,19,21,20,20,20,20,21,21,21,21,21,21,21,21,21,22,23,23,23,23,22,21,21,21,20,17,16,15,14,14,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,12,12,12,12,12,12,12,12,13,13,14,14,15,16,17,18,18,17,15.97,14.29,13.29,12.07,10.42,8.57,6.62,5.03,4,3.50,3.57,4.10,4.83,5.42,5.82,6.38,7.26,8.34,9.37,10.36,11.21,11.75,10.92,10.12,10,11,11,11,9,9,10,11,12,11,9,9,8,6,6.32,7,7.79,8.16,8.34,8.32,8.14,7.97,7.78,7.63,7.62,7.92,8.60,9.40,10.37,11.01,11.16,11.01,10.52,9.41,7.91,6.14,4.41,2.84,1.62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.38,-0.55,-2.25,-4.22,-6.13,-7.48,-8.33,-8.84,-9.05,-9.21,-9.35,-9.60,-10,-10,-11,-11,-12,-12,-13,-13,-14,-14,-15,-15,-16,-16,-16,-16,-17,-17,-17,-17,-17,-17,-17,-17,-17,-16,-16,-16,-16,-15,-15,-14,-14,-14,-13,-13,-12,-12,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.99,-9.88,-9.75,-9.58,-9.38,-9.21,-9,-8.83,-8.65,-8.50,-8.37,-8.22,-8.05,-7.93,-7.88,-7.98,-8.21,-8.53,-8.91,-9.29,-9.66,-10,-10,-10,-10,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-10,-10,-10,-9.92,-9.40,-8.52,-7.38,16,16,16,16,16,16,16,16,16,16,16,17,17,17,17,17,17,18,17,16,16,16,16,17,19,20,21,21,20,20,20,20,20,20,20,20,20,20,21,21,22,23,23,23,24,22,22,21,20,18,17,15,15,14,14,13,13,13,13,13,13,13,13,13,13,13,13,13,13,12,12,12,12,12,12,12,12,12,13,13,14,14,15,16,17,18,18,17,15.88,14.71,13.37,11.87,10.12,8.27,6.45,4.98,4.10,3.85,4.10,4.66,5.46,6.04,6.24,6.57,7.53,8.73,9.66,10.45,11.71,11.75,10.87,10.12,10,11,12,11,10,9,10,11,12,11,11,10,9,7,6.45,7.02,7.79,8.26,8.48,8.60,8.70,8.85,9,9.04,9.12,9.27,9.64,10.24,10.86,11.40,11.61,11.42,11.16,9.91,8.33,6.46,4.57,2.98,1.82,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.37,-0.93,-2.63,-4.42,-6.35,-7.50,-8.26,-8.75,-8.99,-9.13,-9.27,-9.53,-9.99,-10,-11,-11,-12,-12,-13,-13,-14,-14,-15,-15,-16,-16,-16,-16,-17,-17,-17,-17,-17,-17,-17,-17,-17,-17,-16,-16,-16,-15,-15,-15,-14,-14,-13,-13,-12,-12,-12,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.96,-9.91,-9.88,-9.87,-9.84,-9.78,-9.72,-9.61,-9.47,-9.29,-9.11,-8.89,-8.72,-8.55,-8.42,-8.30,-8.21,-8.08,-7.96,-7.87,-7.86,-7.99,-8.26,-8.63,-9.01,-9.39,-9.77,-10,-10,-10,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-11,-10,-10,-10,-9.88,-9.36,-8.48,-7.36,16,16,16,16,16,16,16,16,16,16,16,16,17,16,16,16,17,17,17,16,16,16,17,17,18,19,21,20,21,20,20,19,19,19,19,20,20,20,21,21,22,24,24,24,23,23,21,20,19,17,16,15,14,14,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,12,12,12,12,12,12,12,12,12,12,13,13,14,15,16,17,19,18,16.96,15.82,14.59,13.17,11.58,9.85,8.11,6.47,5.15,4.42,4.25,4.58,5.36,6.24,6.97,7.37,7.49,8.32,9.51,9.98,10.41,10.87,11.09,10.87,10.12,11,11,12,12,11,10,10,11,12,12,12,12,9,7,6.51,7.25,7.86,8.37,8.73,9.02,9.42,9.87,10.25,10.39,10.48,10.58,10.76,11.07,11.40,11.66,11.73,11.45,10.74,9.83,8.25,6.41,4.46,2.33,1.99,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.98,0.12,-1.14,-3.23,-4.99,-6.25,-7.43,-8.25,-8.71,-8.92,-9.08,-9.24,-9.54,-9.93,-10,-11,-11,-12,-12,-13,-13,-14,-14,-15,-15,-16,-16,-16,-16,-17,-17,-17,-17,-17,-17,-17,-17,-17,-17,-16,-16,-16,-16,-15,-15,-14,-14,-14,-13,-13,-12,-12,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.98,-9.91,-9.88,-9.84,-9.78,-9.75,-9.72,-9.65,-9.63,-9.59,-9.53,-9.46,-9.35,-9.21,-9.02,-8.84,-8.63,-8.47,-8.33,-8.23,-8.14,-8.08,-7.98,-7.89,-7.84,-7.88,-8.05,-8.38,-8.75,-9.13,-9.51,-9.88,-10,-10,-10,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-11,-11,-10,-10,-10,-9.79,-9.27,-8.42,-7.35,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,17,17,17,17,17,18,18,19,20,20,20,20,19,19,19,19,19,20,20,21,21,22,23,23,23,23,22,21,20,19,18,16,15,15,14,14,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,12,12,12,12,12,12,12,12,12,12,13,13,14,15,16,18,18,17.76,16.72,15.63,14.38,12.91,11.28,9.59,7.90,6.39,5.23,4.62,4.65,5.17,6,6.97,7.99,8.58,8.92,9.32,9.77,10,10.14,10.26,10.87,10.99,10.99,11,12,12,13,11,11,11,11,12,12,12,12,10,8,7.13,7.41,7.96,8.48,8.98,9.49,10.12,10.79,11.32,11.66,11.75,11.76,11.78,11.88,12.01,12.08,11.97,11.48,10.60,9.34,7.83,6.14,4.21,2.04,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.71,-0.10,-1.34,-3.39,-5.12,-6.46,-7.52,-8.26,-8.67,-8.88,-9.02,-9.18,-9.50,-9.92,-10,-10,-11,-12,-12,-13,-13,-14,-14,-15,-15,-16,-16,-16,-16,-17,-17,-17,-17,-17,-17,-17,-17,-17,-17,-17,-16,-16,-16,-15,-15,-15,-14,-14,-13,-13,-12,-12,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-9.96,-9.89,-9.84,-9.75,-9.71,-9.65,-9.62,-9.58,-9.51,-9.47,-9.40,-9.37,-9.29,-9.22,-9.11,-8.97,-8.78,-8.60,-8.40,-8.25,-8.13,-8.08,-8.02,-7.99,-7.92,-7.88,-7.87,-7.97,-8.18,-8.50,-8.88,-9.26,-9.64,-10,-10,-10,-10,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-11,-10,-10,-10,-10,-9.73,-9.23,-8.38,-7.30,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,17,17,17,18,18,18,18,19,19,19,19,19,19,19,19,19,19,20,20,21,21,22,22,24,24,23,22,21,20,19,18,17,16,15,15,14,14,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,12,12,12,12,12,12,12,12,12,12,13,13,14,15,16,17,17.97,17.20,16.46,15.39,14.11,12.61,10.97,9.28,7.71,6.35,5.34,4.87,5.03,5.70,6.62,7.70,8.82,9.79,10.10,10.15,9.86,9.61,9.78,10.24,10.88,11.87,11.07,11,12,13,13,12,12,11,11,12,13,13,12,10,8,7.36,7.57,8,8.54,9.13,9.86,10.65,11.50,12.26,12.77,12.91,12.86,12.76,12.71,12.65,12.52,12.17,11.52,10.48,9.08,7.42,5.63,3.95,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.15,0.50,-0.22,-1.35,-3.26,-5.41,-6.64,-7.62,-8.28,-8.65,-8.85,-8.97,-9.14,-9.47,-9.88,-10,-10,-11,-12,-12,-13,-13,-14,-14,-15,-15,-15,-16,-16,-16,-17,-17,-17,-17,-17,-17,-17,-17,-17,-17,-17,-16,-16,-16,-16,-15,-15,-14,-14,-14,-13,-13,-12,-12,-11,-11,-10,-10,-10,-10,-10,-10,-9.96,-9.87,-9.77,-9.68,-9.62,-9.54,-9.50,-9.46,-9.40,-9.36,-9.29,-9.23,-9.16,-9.10,-9,-8.89,-8.76,-8.61,-8.41,-8.25,-8.11,-8.02,-7.99,-7.98,-7.97,-7.93,-7.92,-7.97,-8.09,-8.33,-8.64,-9,-9.38,-9.75,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-9.64,-9.14,-8.33,-7.26,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,17,17,18,18,19,19,19,19,19,19,19,19,19,19,19,19,19,20,21,21,21,22,22,22,23,22,23,21,20,19,18,17,16,15,15,15,14,14,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,12,12,12,12,12,12,12,12,12,12,13,14,15,15,16,17,17.13,16.95,16.25,15.22,13.86,12.27,10.62,8.98,7.49,6.28,5.48,5.17,5.46,6.22,7.25,8.39,9.66,10.71,11.09,10.73,9.88,9.34,9.63,10.22,11.84,11.11,11.01,12,13,13,14,13,12,12,12,12,12,13,11,10,8,7.36,7.62,8.07,8.61,9.34,10.15,11.07,12,12.90,13.58,13.84,13.79,13.70,13.51,13.33,13,12.48,11.62,10.41,8.88,7.13,5.27,3,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.27,0.38,-0.10,-1.30,-3.23,-5.17,-6.55,-7.62,-8.26,-8.59,-8.75,-8.88,-9.09,-9.38,-9.79,-10,-10,-11,-11,-12,-13,-13,-14,-14,-15,-15,-15,-16,-16,-16,-17,-17,-17,-17,-17,-17,-17,-17,-17,-17,-17,-16,-16,-16,-16,-15,-15,-15,-14,-14,-13,-13,-12,-12,-11,-11,-10,-10,-10,-10,-10,-9.99,-9.89,-9.79,-9.68,-9.60,-9.50,-9.42,-9.38,-9.34,-9.28,-9.24,-9.15,-9.09,-9.01,-8.93,-8.86,-8.75,-8.63,-8.48,-8.29,-8.14,-8.03,-7.99,-7.98,-7.99,-7.99,-8,-8,-8.08,-8.22,-8.46,-8.76,-9.13,-9.50,-9.86,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-9.91,-9.55,-9.08,-8.24,-7.18,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,17,17,18,20,20,20,19,19,19,19,19,19,19,19,19,19,19,19,20,21,21,21,21,21,21,21,21,21,20,19,19,18,16,15,15,15,14,14,14,13,13,13,13,13,13,13,13,13,13,13,13,13,13,12,12,12,12,12,12,12,12,12,12,12,13,14,14,15,16,16.84,17.07,16.86,16.20,15.09,13.64,11.99,10.25,8.63,7.25,6.23,5.63,5.53,5.95,6.78,7.89,9.11,10.32,11.41,11.88,11.23,9.99,9.35,9.52,10.83,10.87,10.99,11,12,13,15,14,13,13,13,13,12,12,12,11,9,8,7.45,7.73,8.16,8.76,9.59,10.47,11.38,12.36,13.27,14.03,14.47,14.58,14.50,14.32,14,13.51,12.79,11.76,10.39,8.75,6.90,5,3.16,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.28,0.40,0.09,-1.29,-3.33,-5.09,-6.49,-7.51,-8.14,-8.46,-8.63,-8.75,-8.98,-9.27,-9.66,-10,-10,-11,-11,-12,-12,-13,-14,-14,-14,-15,-15,-16,-16,-16,-16,-17,-17,-17,-17,-17,-17,-17,-17,-17,-17,-16,-16,-16,-16,-15,-15,-15,-14,-14,-13,-13,-12,-12,-11,-11,-11,-10,-10,-10,-10,-9.99,-9.88,-9.76,-9.63,-9.52,-9.42,-9.36,-9.28,-9.24,-9.18,-9.13,-9.05,-8.98,-8.90,-8.85,-8.75,-8.66,-8.54,-8.40,-8.25,-8.13,-8.02,-8,-8,-8.02,-8.04,-8.08,-8.10,-8.16,-8.33,-8.55,-8.88,-9.23,-9.59,-9.91,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-9.79,-9.46,-8.96,-8.13,-7.10,16,16,16,16,16,16,16,16,16,16,16,16,16,16,17,17,18,19,20,21,20,19,19,19,19,19,19,19,19,19,18,18,18,19,19,20,20,20,21,20,20,20,20,20,19,19,17,16,15,15,15,14,14,14,13,13,13,13,13,13,13,13,13,13,13,13,13,13,12,12,12,12,12,12,12,12,12,12,12,13,13,14,15,16,16.88,17.25,16.97,16.23,15.02,13.49,11.73,9.91,8.28,6.99,6.13,5.78,5.92,6.51,7.45,8.61,9.84,11.02,12.12,12.62,11.79,10.38,9.59,9.32,9.87,10.07,11,11,12,13,14,15,14,13,13,13,12,11,11,10,9,9,7.71,7.77,8.34,9.04,9.85,10.70,11.62,12.60,13.52,14.34,14.88,15.17,15.22,15.03,14.64,14.01,13.11,11.89,10.37,8.62,6.72,4.84,3.14,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.25,0.32,-0.03,-1.36,-3.71,-5.14,-6.42,-7.38,-7.98,-8.27,-8.41,-8.60,-8.80,-9.12,-9.53,-10,-10,-11,-11,-12,-12,-13,-13,-14,-14,-15,-15,-15,-16,-16,-16,-17,-17,-17,-17,-17,-17,-17,-17,-17,-17,-16,-16,-16,-16,-15,-15,-15,-14,-14,-13,-13,-12,-12,-11,-11,-11,-10,-10,-10,-10,-10,-9.87,-9.75,-9.61,-9.50,-9.38,-9.29,-9.24,-9.17,-9.13,-9.08,-9,-8.91,-8.86,-8.78,-8.72,-8.63,-8.51,-8.38,-8.25,-8.13,-8.05,-8.03,-8.05,-8.10,-8.13,-8.14,-8.18,-8.26,-8.41,-8.64,-8.93,-9.27,-9.63,-9.97,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-9.97,-9.66,-9.30,-8.83,-8,-6.98,16,16,16,16,16,16,16,16,17,16,16,16,16,17,17,18,19,20,20,20,19,19,19,19,19,18,18,18,18,18,18,18,18,18,19,19,19,19,19,19,19,19,19,19,19,18,17,16,15,15,15,14,14,14,14,14,14,14,14,14,13,13,13,13,13,13,13,13,12,12,12,12,12,12,12,12,12,12,12,12,13,14,15,16,17.50,17.48,17.08,16.26,15,13.37,11.50,9.60,7.91,6.67,6.01,5.91,6.33,7.11,8.15,9.37,10.62,11.76,12.83,13.25,12.50,10.97,9.95,9.11,9.04,10,10,11,11,12,14,15,14,13,13,13,12,11,10,9,10,8,7.14,7.75,8.45,9.33,10.03,10.84,11.75,12.73,13.70,14.54,15.23,15.65,15.82,15.66,15.24,14.46,13.36,11.97,10.32,8.45,6.48,4.59,2.87,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.21,0.12,-0.29,-1.93,-3.76,-5.18,-6.38,-7.24,-7.77,-8.05,-8.23,-8.38,-8.63,-8.98,-9.38,-9.87,-10,-10,-11,-12,-12,-13,-13,-14,-14,-15,-15,-15,-16,-16,-16,-16,-17,-17,-17,-17,-17,-17,-17,-17,-17,-16,-16,-16,-16,-15,-15,-15,-14,-14,-13,-13,-12,-12,-12,-11,-11,-10,-10,-10,-10,-10,-9.88,-9.74,-9.61,-9.48,-9.37,-9.27,-9.22,-9.14,-9.11,-9.04,-8.98,-8.89,-8.84,-8.76,-8.71,-8.62,-8.51,-8.39,-8.27,-8.17,-8.12,-8.10,-8.12,-8.14,-8.17,-8.22,-8.25,-8.34,-8.49,-8.71,-8.99,-9.30,-9.64,-9.98,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-9.79,-9.50,-9.15,-8.65,-7.86,-6.86,16,16,16,16,16,16,16,17,16,16,16,16,16,17,18,19,19,19,19,19,19,19,18,19,18,18,17,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,19,19,17,17,16,15,15,15,14,14,14,14,14,15,15,14,14,13,13,13,13,13,13,13,12,12,12,12,12,12,12,12,12,12,12,12,13,14,15,17,17.41,17.62,17.12,16.26,14.99,13.28,11.33,9.29,7.53,6.29,5.84,6,6.67,7.70,8.89,10.20,11.41,12.51,13.45,13.72,12.92,11.60,10.09,9.01,9,9,10,10,11,12,13,15,14,14,13,13,12,11,10,9,8,8,7,7.57,8.35,9.34,10.04,10.83,11.76,12.77,13.78,14.72,15.48,16,16.25,16.15,15.67,14.75,13.49,11.91,10.12,8.16,6.12,4.21,2.50,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.20,0.09,-0.66,-2.26,-4.01,-5.22,-6.29,-7.10,-7.59,-7.86,-8.01,-8.21,-8.46,-8.79,-9.21,-9.66,-10,-10,-11,-11,-12,-12,-13,-13,-14,-14,-15,-15,-15,-16,-16,-16,-16,-16,-17,-17,-17,-17,-17,-17,-16,-16,-16,-16,-16,-15,-15,-15,-14,-14,-13,-13,-12,-12,-12,-11,-11,-10,-10,-10,-10,-10,-9.87,-9.74,-9.60,-9.48,-9.36,-9.26,-9.18,-9.13,-9.09,-9.02,-8.97,-8.89,-8.83,-8.76,-8.71,-8.62,-8.52,-8.40,-8.29,-8.21,-8.14,-8.13,-8.15,-8.18,-8.23,-8.25,-8.29,-8.38,-8.51,-8.73,-9,-9.29,-9.63,-9.96,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-9.88,-9.63,-9.35,-9,-8.50,-7.73,-6.74,16,16,16,16,16,16,16,16,16,16,16,16,17,17,18,19,18,18,18,18,19,18,18,18,18,17,17,17,18,18,18,18,18,17,17,17,17,17,17,17,17,18,18,18,19,19,18,17,16,16,15,15,15,15,15,15,15,15,15,15,14,13,13,13,13,14,13,13,12,12,12,12,12,12,12,12,12,12,12,12,13,14,16,17,17.64,17.64,17.16,16.33,15.02,13.32,11.25,9.11,7.17,5.90,5.59,6.01,6.96,8.20,9.59,10.97,12.24,13.25,14.01,14.03,12.96,11.01,10,9,9,9,9,10,11,12,13,14,15,14,13,13,12,11,10,9,9,8,7,7.37,8.01,8.87,9.74,10.64,11.66,12.75,13.85,14.86,15.67,16.25,16.52,16.46,15.90,14.87,13.47,11.75,9.83,7.75,5.64,3.66,2.09,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.15,0.15,-0.15,-1.15,-2.43,-4.01,-5.30,-6.33,-7.04,-7.49,-7.68,-7.85,-8.04,-8.28,-8.62,-9,-9.48,-10,-10,-11,-11,-12,-12,-13,-13,-14,-14,-14,-15,-15,-15,-16,-16,-16,-16,-16,-16,-16,-16,-16,-16,-16,-16,-16,-16,-16,-15,-15,-15,-14,-14,-13,-13,-12,-12,-12,-11,-11,-10,-10,-10,-10,-10,-9.86,-9.72,-9.59,-9.46,-9.35,-9.25,-9.17,-9.13,-9.08,-9.01,-8.96,-8.88,-8.83,-8.75,-8.68,-8.62,-8.52,-8.41,-8.30,-8.22,-8.15,-8.14,-8.17,-8.22,-8.25,-8.27,-8.33,-8.39,-8.51,-8.72,-8.97,-9.26,-9.59,-9.89,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-9.90,-9.68,-9.46,-9.17,-8.86,-8.38,-7.60,-6.63,16,16,16,16,16,16,16,16,16,16,16,17,17,18,19,18,18,18,18,19,19,19,18,18,17,17,17,16,17,17,18,18,17,17,17,17,17,17,17,17,17,18,18,18,19,19,18,17,16,16,16,15,15,15,15,15,16,16,15,15,14,13,13,13,13,13,14,14,12,12,12,12,12,12,12,12,12,12,12,12,13,15,17,18,17.95,17.74,17.25,16.40,15.14,13.38,11.25,9,6.95,5.59,5.32,5.92,7.08,8.52,10.11,11.64,12.99,13.91,14.58,14.36,13,11,10,9,9,9,9,10,11,12,13,15,14,13,13,13,13,12,10,10,10,9,8,7.17,7.51,8.25,9.25,10.34,11.49,12.70,13.88,14.98,15.85,16.41,16.63,16.47,15.85,14.76,13.27,11.47,9.39,7.23,5.09,3.13,1.63,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0.26,0.07,-0.40,-1.46,-2.75,-4.35,-5.58,-6.53,-7.17,-7.52,-7.63,-7.78,-7.93,-8.14,-8.46,-8.84,-9.28,-9.78,-10,-10,-11,-11,-12,-12,-13,-13,-14,-14,-15,-15,-15,-15,-16,-16,-16,-16,-16,-16,-16,-16,-16,-16,-16,-16,-16,-15,-15,-15,-14,-14,-14,-13,-13,-12,-12,-11,-11,-11,-10,-10,-10,-10,-9.97,-9.83,-9.67,-9.54,-9.41,-9.30,-9.22,-9.14,-9.10,-9.03,-8.99,-8.92,-8.87,-8.79,-8.75,-8.67,-8.61,-8.50,-8.39,-8.28,-8.21,-8.14,-8.14,-8.16,-8.22,-8.25,-8.26,-8.29,-8.38,-8.50,-8.67,-8.91,-9.21,-9.50,-9.80,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-9.90,-9.73,-9.50,-9.27,-9.01,-8.72,-8.25,-7.49,-6.50,16,16,16,16,16,16,16,16,16,16,17,17,18,18,18,18,18,19,19,20,19,18,18,18,17,16,16,16,16,16,16,16,16,16,16,16,16,16,17,17,17,18,18,18,19,19,18,17,16,16,16,16,16,16,16,16,16,15,15,15,14,13,13,13,13,13,13,13,13,12,12,12,12,12,12,12,12,12,12,12,14,16,17,19,18.23,17.92,17.38,16.50,15.25,13.49,11.23,8.89,6.78,5.35,5.02,5.75,7,8.62,10.37,12.10,13.50,14.48,15.15,14.89,14,12,11,10,9,10,10,10,11,12,13,13,13,13,12,12,12,11,11,11,10,10,8,7,7.16,7.62,8.75,10,11.26,12.61,13.95,15.12,16,16.52,16.64,16.34,15.62,14.50,12.99,11.11,8.92,6.65,4.50,2.62,1.50,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0.26,-0.08,-0.64,-1.51,-3.40,-4.83,-6.04,-6.99,-7.53,-7.76,-7.75,-7.87,-7.93,-8.10,-8.36,-8.71,-9.13,-9.60,-10,-10,-11,-11,-12,-12,-13,-13,-13,-14,-14,-15,-15,-15,-15,-16,-16,-16,-16,-16,-16,-16,-16,-16,-16,-16,-15,-15,-15,-15,-14,-14,-14,-13,-13,-12,-12,-11,-11,-11,-10,-10,-10,-10,-9.89,-9.76,-9.63,-9.50,-9.37,-9.25,-9.15,-9.10,-9.03,-8.99,-8.93,-8.88,-8.83,-8.76,-8.71,-8.63,-8.58,-8.48,-8.37,-8.25,-8.16,-8.12,-8.12,-8.13,-8.17,-8.22,-8.24,-8.26,-8.34,-8.43,-8.62,-8.85,-9.11,-9.39,-9.68,-9.99,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-9.89,-9.74,-9.54,-9.35,-9.12,-8.87,-8.58,-8.13,-7.37,-6.36,16,16,16,16,16,16,16,16,16,17,17,18,18,18,18,18,19,19,20,19,19,18,18,18,17,16,16,16,16,16,16,16,16,16,16,16,16,16,17,17,17,18,18,18,19,18,18,17,17,17,17,17,16,16,16,16,16,15,15,15,14,13,13,13,13,13,13,13,13,12,12,12,12,12,12,12,12,12,12,13,15,17,18,18,18.58,18.17,17.49,16.40,15.07,13.25,11.02,8.76,6.66,5.21,4.79,5.46,6.75,8.42,10.26,12.10,13.64,14.87,15.65,16,15,13,11,10,10,10,11,11,11,12,13,12,12,13,12,12,12,11,11,11,10,9,8,7,7.04,7.37,8.47,9.73,11.08,12.52,14,15.26,16.20,16.64,16.62,16.14,15.29,14.12,12.61,10.65,8.41,6.09,3.90,2.24,1.34,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,2,2,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0.26,-0.12,-0.75,-1.71,-3.61,-5.40,-6.83,-7.71,-8.11,-8.22,-8.10,-8.12,-8.10,-8.16,-8.36,-8.63,-9,-9.41,-9.88,-10,-10,-11,-11,-12,-12,-13,-13,-14,-14,-14,-15,-15,-15,-15,-15,-16,-16,-16,-16,-16,-16,-16,-15,-15,-15,-15,-15,-14,-14,-14,-13,-13,-12,-12,-12,-11,-11,-10,-10,-10,-10,-9.96,-9.80,-9.66,-9.53,-9.40,-9.28,-9.16,-9.09,-9.01,-8.97,-8.90,-8.87,-8.80,-8.75,-8.71,-8.64,-8.59,-8.50,-8.41,-8.30,-8.21,-8.11,-8.05,-8.04,-8.09,-8.13,-8.15,-8.17,-8.21,-8.25,-8.36,-8.51,-8.74,-8.99,-9.26,-9.54,-9.84,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.88,-9.73,-9.55,-9.38,-9.17,-8.97,-8.72,-8.41,-7.98,-7.22,-6.18,16,16,16,16,16,16,16,16,17,17,18,18,19,19,19,19,19,19,20,19,18,18,17,17,16,16,16,16,16,16,16,16,16,16,16,16,16,17,17,17,17,17,17,18,18,18,18,17,17,17,17,17,16,16,16,16,16,15,15,15,14,13,13,13,13,13,13,13,12,12,12,12,12,12,12,12,12,12,12,13,15,18,19,19,18.67,18.29,17.38,16.12,14.57,12.76,10.75,8.65,6.70,5.25,4.72,5.16,6.37,8,9.84,11.74,13.50,15.07,16.79,16,15,13,11,10,10,11,11,12,11,12,12,12,12,12,12,12,12,12,11,11,10,9,8,8,8,7.95,8.37,9.49,10.91,12.47,14.03,15.45,16.41,16.83,16.64,15.98,14.91,13.62,12.04,10.12,7.87,5.53,3.33,1.86,1.15,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,3,3,2,2,1,1,1,0,0,0,0,0,0,0,0,0,0.01,0.36,0.02,-0.76,-1.88,-3.75,-6.59,-7.84,-8.46,-8.79,-8.80,-8.63,-8.53,-8.41,-8.38,-8.46,-8.63,-8.91,-9.26,-9.66,-10,-10,-11,-11,-11,-12,-12,-13,-13,-14,-14,-14,-14,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-14,-14,-14,-13,-13,-13,-12,-12,-11,-11,-11,-10,-10,-10,-9.99,-9.83,-9.68,-9.55,-9.42,-9.29,-9.17,-9.05,-8.98,-8.90,-8.86,-8.80,-8.75,-8.72,-8.65,-8.61,-8.55,-8.50,-8.42,-8.35,-8.24,-8.13,-8.02,-7.98,-7.98,-8,-8.04,-8.09,-8.10,-8.12,-8.15,-8.25,-8.39,-8.61,-8.85,-9.12,-9.38,-9.64,-9.89,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.87,-9.71,-9.54,-9.38,-9.22,-9.01,-8.79,-8.54,-8.25,-7.80,-7.04,-6,16,16,16,16,16,16,16,17,17,18,18,20,19,19,19,19,19,19,19,18,18,17,17,16,16,16,16,16,16,16,16,16,16,16,16,16,16,17,17,17,17,17,17,17,18,19,18,18,18,17,17,17,17,16,16,16,15,15,15,15,14,14,13,13,13,13,13,12,12,12,12,12,12,12,12,12,12,12,12,13,16,18,19,19,18.84,18.07,17.10,15.73,14.16,12.45,10.62,8.75,6.98,5.50,4.75,4.89,5.87,7.38,9.24,11.25,13.33,15.11,17,16,14,13,12,11,11,11,12,12,12,12,12,12,12,12,12,12,12,12,11,11,11,9,8,8,8,8,8.02,9.41,10.74,12.37,14.07,15.62,16.71,17.08,16.75,15.84,14.53,13.01,11.37,9.51,7.34,5.03,2.83,1.54,1.01,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,3,3,4,3,2,2,1,1,0,0,0,0,0,0,0,0,0,0.03,0.33,-0.01,-0.84,-2.02,-4.85,-6.96,-8.16,-8.98,-9.42,-9.50,-9.30,-9.05,-8.80,-8.64,-8.60,-8.66,-8.85,-9.12,-9.43,-9.83,-10,-10,-11,-11,-12,-12,-12,-13,-13,-13,-14,-14,-14,-14,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-14,-14,-14,-14,-13,-13,-13,-12,-12,-11,-11,-11,-10,-10,-10,-9.99,-9.79,-9.65,-9.52,-9.40,-9.27,-9.15,-9.03,-8.92,-8.85,-8.76,-8.73,-8.67,-8.63,-8.59,-8.53,-8.50,-8.46,-8.39,-8.34,-8.24,-8.13,-8.01,-7.91,-7.88,-7.87,-7.89,-7.93,-7.98,-8,-8,-8.02,-8.11,-8.25,-8.43,-8.67,-8.93,-9.21,-9.46,-9.67,-9.88,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.84,-9.66,-9.51,-9.37,-9.21,-9.02,-8.84,-8.62,-8.37,-8.08,-7.63,-6.88,-5.78,16,16,16,16,16,16,17,17,18,18,19,20,21,20,19,20,20,19,18,17,17,17,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,17,16,16,16,16,16,17,17,18,18,18,17,17,17,17,17,17,16,16,15,15,15,15,14,14,14,14,14,13,13,12,12,12,12,12,12,12,12,12,12,12,12,14,16,18,19,19,18,17.71,16.71,15.50,13.96,12.46,10.89,9.16,7.42,5.88,4.83,4.59,5.26,6.64,8.53,10.75,13.17,15.98,16,16,15,13,14,12,12,12,12,12,12,12,12,12,12,12,12,12,12,11,11,10,10,9,8,8,8,9,9,9.02,10.59,12.20,14,15.77,16.95,17.33,16.91,15.76,14.17,12.39,10.60,8.77,6.74,4.70,2.65,1.33,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,2,3,4,4,4,4,3,2,2,1,1,0,0,0,0,0,0,0,0,0.04,0.37,-0.30,-1.03,-2.42,-5.17,-7.17,-8.23,-9.17,-9.84,-10,-10,-9.55,-9.18,-8.90,-8.74,-8.68,-8.75,-8.92,-9.17,-9.50,-9.88,-10,-10,-11,-11,-11,-12,-12,-13,-13,-13,-14,-14,-14,-14,-14,-14,-14,-14,-15,-14,-14,-14,-14,-14,-14,-14,-13,-13,-13,-12,-12,-12,-11,-11,-10,-10,-10,-9.96,-9.74,-9.59,-9.43,-9.35,-9.23,-9.11,-9,-8.87,-8.75,-8.66,-8.61,-8.54,-8.50,-8.47,-8.42,-8.39,-8.37,-8.33,-8.26,-8.21,-8.12,-8,-7.89,-7.79,-7.75,-7.75,-7.77,-7.83,-7.86,-7.87,-7.87,-7.88,-7.93,-8.08,-8.25,-8.50,-8.75,-9,-9.23,-9.43,-9.63,-9.80,-9.96,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.92,-9.77,-9.61,-9.46,-9.29,-9.14,-9,-8.83,-8.63,-8.39,-8.14,-7.86,-7.40,-6.67,-5.55,16,16,16,16,16,17,17,18,18,19,19,20,21,20,19,19,19,18,17,17,17,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,17,17,17,17,17,17,17,17,17,16,17,16,16,15,15,15,14,14,14,14,14,14,13,12,12,12,12,12,12,12,12,12,12,12,13,15,16,17,18,18,18,17.02,16.63,15.62,14.37,13.11,11.59,9.83,7.95,6.21,4.84,4.24,4.66,5.95,7.92,10.32,12.96,16,17,17,15,14,14,14,13,13,13,13,13,12,12,12,12,13,12,12,12,12,11,10,9,8,8,8,9,10,10,10,10.04,11.65,14.02,15.90,17.12,17.50,17.08,15.83,13.96,11.84,9.75,7.85,5.96,4.26,2.85,2.02,2,2,3,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,2,2,4,5,5,5,5,3,3,3,2,2,1,1,0,1,1,0,0,0,0.04,0.42,-0.49,-1.36,-2.60,-4.97,-6.43,-8.03,-9.11,-10,-10,-10,-9.92,-9.43,-9.03,-8.76,-8.62,-8.59,-8.66,-8.85,-9.11,-9.43,-9.83,-10,-10,-11,-11,-11,-12,-12,-13,-13,-13,-13,-13,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-13,-13,-13,-12,-12,-12,-11,-11,-11,-10,-10,-10,-9.84,-9.61,-9.40,-9.28,-9.16,-9.10,-8.98,-8.88,-8.77,-8.65,-8.54,-8.47,-8.39,-8.35,-8.29,-8.26,-8.25,-8.23,-8.21,-8.16,-8.12,-8.04,-7.97,-7.86,-7.75,-7.65,-7.61,-7.61,-7.63,-7.66,-7.71,-7.72,-7.72,-7.72,-7.75,-7.87,-8.04,-8.27,-8.52,-8.76,-8.99,-9.18,-9.37,-9.51,-9.65,-9.75,-9.83,-9.88,-9.90,-9.93,-9.98,-10,-10,-10,-9.98,-9.90,-9.79,-9.66,-9.51,-9.36,-9.21,-9.05,-8.90,-8.75,-8.59,-8.38,-8.15,-7.90,-7.62,-7.16,-6.49,-5.30,17,17,17,17,17,17,18,18,19,19,20,21,20,19,18,18,18,17,17,17,17,16,16,16,16,16,16,16,16,16,16,16,16,16,16,15,15,15,15,15,15,15,16,16,16,16,16,16,16,16,16,16,16,16,16,15,15,15,15,15,15,15,14,14,14,13,13,12,12,12,12,12,12,12,12,12,12,12,13,15,17,17,17,18,18,17,16.97,16.03,15.23,14.12,12.61,10.57,8.36,6.37,4.70,3.84,4.15,5.51,7.48,9.98,13,15,17,17,16,15,15,15,14,14,14,13,13,13,12,12,13,13,13,13,13,12,12,10,9,8,8,9,9,10,11,12,11,12.02,14.01,16.11,17.24,17.70,17.29,16.10,13.91,11.37,8.78,6.64,4.96,3.33,3.02,3,3,4,4,3,2,0,0,0,0,0,0,0,0,0,0,0,0,1,2,2,2,2,2,3,4,5,5,5,5,4,3,3,3,3,3,1,1,1,1,0,0,0,0.95,0.57,-0.80,-1.50,-2.64,-4.48,-6.25,-7.49,-8.72,-9.75,-10,-10,-9.93,-9.46,-8.93,-8.61,-8.38,-8.28,-8.29,-8.41,-8.64,-8.96,-9.30,-9.73,-10,-10,-10,-11,-11,-12,-12,-12,-12,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-12,-12,-12,-11,-11,-11,-10,-10,-9.97,-9.64,-9.38,-9.15,-8.99,-8.88,-8.79,-8.75,-8.64,-8.54,-8.50,-8.38,-8.27,-8.18,-8.12,-8.05,-8.02,-8.01,-8,-8.01,-8,-7.99,-7.93,-7.88,-7.78,-7.68,-7.59,-7.50,-7.43,-7.43,-7.47,-7.50,-7.52,-7.53,-7.52,-7.51,-7.54,-7.64,-7.83,-8.04,-8.28,-8.51,-8.74,-8.91,-9.09,-9.22,-9.35,-9.42,-9.49,-9.53,-9.59,-9.62,-9.65,-9.68,-9.71,-9.72,-9.66,-9.60,-9.50,-9.36,-9.22,-9.05,-8.91,-8.77,-8.63,-8.49,-8.30,-8.11,-7.88,-7.63,-7.34,-6.90,-6.25,-5.03,18,17,17,17,17,18,19,19,20,20,20,21,20,19,18,18,17,17,17,17,16,16,16,16,16,17,17,17,17,17,17,17,17,16,16,16,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,14,14,13,13,12,12,12,12,12,12,12,12,12,12,12,13,15,16,17,17,18,18,18,17,17,16.08,15.63,13.50,11.08,8.59,6.27,4.50,3.49,3.36,5.15,8,9,12,15,17,17,17,15,15,15,15,14,15,13,13,13,12,12,13,13,13,13,13,13,12,11,10,9,9,9,9,10,12,13,13,12,14,16.12,17.62,17.73,17.39,16.36,14.36,11.10,7.50,5.37,3.16,3,3,4,5,6,6,5,3,1,0,0,0,0,0,0,0,0,0,0,0,1,3,3,3,4,4,5,5,5,6,5,5,4,3,3,3,3,3,2,2,1,1,0,0,0,0.95,-0.75,-1.15,-1.77,-2.46,-4.33,-5.72,-6.80,-7.92,-8.99,-9.71,-9.91,-9.36,-8.99,-8.55,-8.22,-7.98,-7.85,-7.80,-7.89,-8.11,-8.39,-8.76,-9.16,-9.60,-10,-10,-10,-11,-11,-11,-12,-12,-12,-12,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-12,-12,-12,-12,-11,-11,-11,-10,-10,-10,-9.75,-9.39,-9.09,-8.80,-8.60,-8.42,-8.35,-8.26,-8.26,-8.16,-8.09,-8.04,-7.96,-7.87,-7.77,-7.73,-7.67,-7.65,-7.66,-7.66,-7.74,-7.75,-7.73,-7.68,-7.63,-7.53,-7.43,-7.34,-7.25,-7.22,-7.21,-7.23,-7.25,-7.27,-7.28,-7.27,-7.26,-7.29,-7.38,-7.54,-7.76,-8,-8.23,-8.42,-8.62,-8.76,-8.88,-8.99,-9.03,-9.10,-9.13,-9.17,-9.24,-9.27,-9.30,-9.30,-9.35,-9.28,-9.22,-9.10,-8.96,-8.80,-8.65,-8.52,-8.39,-8.25,-8.11,-7.92,-7.73,-7.50,-7.25,-6.96,-6.59,-5.98,-4.73,18,18,18,18,18,18,19,21,21,21,21,21,21,19,18,18,17,17,17,16,16,16,16,16,16,17,18,18,18,18,18,18,17,17,17,17,16,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,14,13,13,12,12,12,12,12,12,12,12,12,12,12,13,14,15,16,17,18,18,18,18,17,17,16,14,12,8,6,4,3,3,5,8,10,12,14,16,17,17,16,16,16,15,15,14,13,13,12,12,12,13,12,13,13,13,14,13,11,10,9,9,9,9,10,12,13,15,15,14,17,18,18,17,16,14,11,8,5,3,3,4,5,7,9,8,7,4,2,0,0,0,0,0,0,0,0,0,0,0,1,3,5,5,5,6,7,6,6,7,6,5,4,3,3,4,3,4,3,2,1,1,0,0,1,0.96,-0.91,-1.61,-2.13,-2.42,-3.64,-5.10,-6,-6.53,-7.58,-8.36,-8.37,-8.22,-8.10,-7.86,-7.62,-7.40,-7.26,-7.23,-7.30,-7.51,-7.84,-8.22,-8.63,-9.05,-9.49,-9.89,-10,-10,-10,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-10,-10,-9.98,-9.55,-9.13,-8.78,-8.46,-8.17,-7.93,-7.76,-7.64,-7.58,-7.52,-7.42,-7.41,-7.29,-7.22,-7.13,-7.05,-6.99,-6.92,-6.91,-7.03,-7.25,-7.29,-7.34,-7.35,-7.29,-7.24,-7.13,-7.02,-6.92,-6.86,-6.80,-6.79,-6.83,-6.87,-6.90,-6.91,-6.91,-6.90,-6.92,-7.01,-7.18,-7.40,-7.63,-7.83,-8,-8.12,-8.22,-8.27,-8.33,-8.34,-8.33,-8.33,-8.36,-8.40,-8.47,-8.61,-8.73,-8.79,-8.73,-8.63,-8.50,-8.34,-8.16,-8.02,-7.90,-7.78,-7.64,-7.50,-7.30,-7.11,-6.88,-6.63,-6.36,-6.03,-5.55,-4.23,15,19,19,19,19,19,20,21,22,22,21,21,21,20,18,18,17,17,17,16,16,16,16,16,17,18,18,18,18,19,18,18,18,18,17,17,16,16,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,14,14,13,12,12,12,12,12,12,12,12,12,12,12,13,14,15,16,18,18,18,19,18,17,17,16,14,11,8,6,5,3,3,5,7,10,11,14,16,16,16,17,17,17,16,16,15,13,12,12,12,13,12,12,12,13,13,13,13,12,10,9,9,9,9,10,11,14,16,16,16,17,18,17,17,16,14,12,8,5,4,4,5,7,9,10,10,8,6,3,1,0,0,0,0,0,0,0,0,0,0,1,3,4,6,7,8,8,8,7,8,7,5,4,3,3,3,3,3,3,2,1,1,0,0,1,-0.99,-0.93,-1.88,-2.53,-2.27,-2.13,-3.02,-3.75,-4.08,-4.88,-5.66,-6.38,-6.79,-7.03,-7.09,-6.98,-6.79,-6.64,-6.61,-6.71,-6.97,-7.34,-7.75,-8.17,-8.63,-9.05,-9.48,-9.86,-10,-10,-10,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-10,-10,-10,-9.91,-9.50,-8.98,-8.60,-8.15,-7.86,-7.50,-7.26,-7.01,-6.88,-6.75,-6.63,-6.50,-6.38,-6.30,-6.25,-6.17,-6.10,-5.99,-5.89,-5.85,-5.87,-5.89,-5.93,-5.98,-5.98,-5.93,-5.88,-5.79,-5.71,-5.63,-5.58,-5.52,-5.50,-5.49,-5.50,-5.51,-5.51,-5.50,-5.49,-5.50,-5.54,-5.67,-5.86,-6.09,-6.33,-6.52,-6.68,-6.80,-6.89,-6.96,-6.98,-6.99,-7.01,-7.08,-7.15,-7.24,-7.29,-7.33,-7.29,-7.25,-7.17,-7.08,-6.93,-6.83,-6.71,-6.61,-6.50,-6.37,-6.22,-6.02,-5.83,-5.60,-5.34,-5.05,-4.74,-4.23,-3.42,];
}

function getTileMap()
{
	return [0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,3,3,3,2,2,2,2,2,3,3,3,3,1,2,2,2,2,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,1,1,1,0,0,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,2,2,2,2,2,2,2,1,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,2,2,3,3,3,3,3,2,2,2,3,3,3,3,3,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,1,2,2,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,2,2,2,1,2,2,2,2,2,2,1,1,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,2,2,2,3,2,3,3,3,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,2,2,1,1,1,1,1,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,2,1,1,1,1,1,1,1,1,2,2,2,1,1,3,3,3,3,3,3,3,3,3,2,3,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,1,1,1,1,1,1,4,4,4,4,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,2,1,1,1,1,0,0,0,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,1,1,1,1,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,2,1,2,1,1,2,1,1,1,2,2,2,2,1,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,1,1,1,1,4,4,4,4,1,5,5,5,1,1,1,1,5,5,1,1,1,1,1,1,1,1,5,5,5,5,5,5,2,1,1,1,1,0,0,0,1,1,1,1,1,1,1,1,1,2,2,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,1,1,1,1,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,2,2,2,1,1,2,1,1,1,2,3,2,2,3,3,3,3,2,3,5,5,3,3,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,4,4,1,4,4,4,4,4,4,4,1,1,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,5,5,5,5,5,5,5,1,5,1,1,0,0,0,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,1,1,2,1,1,1,2,1,2,2,2,2,2,2,1,1,3,1,1,1,2,1,1,2,2,2,2,1,1,2,2,2,2,2,1,1,2,3,3,3,3,3,3,5,3,5,5,5,5,5,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,4,4,4,4,4,4,4,1,4,4,4,1,1,5,5,5,5,5,5,5,1,1,1,1,1,1,1,5,5,5,5,5,5,5,1,5,5,5,1,0,1,1,0,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,5,5,5,2,3,2,2,2,2,3,2,2,2,2,3,3,3,2,2,2,1,1,2,2,2,1,1,1,1,2,2,2,2,1,1,1,3,3,3,3,3,5,5,5,5,5,5,5,2,2,2,2,2,2,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,1,1,5,5,5,5,5,5,1,1,1,6,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,2,1,1,1,2,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,2,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,1,1,1,1,1,1,1,1,1,1,1,2,2,2,5,5,5,5,5,5,5,5,5,3,3,2,1,5,3,3,2,3,3,3,3,3,2,2,2,2,1,2,2,2,1,1,1,1,2,2,2,2,1,1,1,1,3,3,3,5,5,5,5,5,5,1,2,2,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,6,6,4,1,4,4,4,4,4,4,4,1,1,5,5,5,5,5,5,5,5,1,6,6,6,1,1,1,5,5,5,5,5,5,2,2,5,1,5,1,1,1,1,1,0,0,0,2,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,1,1,1,1,1,1,1,1,1,2,2,5,5,5,5,5,5,5,5,5,3,3,3,3,5,5,5,3,3,3,3,3,3,1,2,2,2,2,1,1,2,2,2,2,2,1,1,1,1,2,1,1,1,1,1,1,1,1,5,5,5,2,1,1,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,1,1,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,4,1,4,4,4,4,4,1,1,5,5,5,5,6,5,5,5,5,1,6,6,6,1,5,5,5,5,5,5,5,1,1,2,1,1,1,1,1,1,1,2,0,0,0,0,1,1,1,1,1,2,2,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,1,1,1,1,1,1,1,1,2,2,1,5,5,5,5,5,5,2,2,3,3,3,5,5,5,5,5,5,3,3,3,1,1,2,2,2,1,1,1,1,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,5,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,1,1,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,4,4,4,4,4,4,1,5,5,5,5,1,6,6,6,6,5,1,1,1,6,6,6,5,5,5,5,5,1,1,1,1,2,1,1,1,1,1,1,1,1,1,0,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,0,0,0,0,2,2,1,1,7,7,7,7,7,7,7,7,7,7,7,1,1,2,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,4,4,4,4,4,1,1,1,1,1,1,1,1,2,2,1,1,5,1,5,2,2,2,2,2,3,2,5,5,5,5,5,5,5,1,5,5,1,2,2,2,2,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,5,5,5,6,4,4,4,4,4,1,5,5,5,5,6,6,1,6,6,6,1,1,1,1,1,6,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,0,1,0,0,0,0,0,0,1,1,1,1,2,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,1,7,1,1,1,7,7,7,7,7,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,2,1,2,2,1,1,1,1,6,6,6,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,5,5,5,5,5,5,5,5,5,5,5,5,2,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,1,1,1,4,4,4,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,6,6,5,5,5,5,5,5,1,4,1,1,5,5,5,1,6,6,6,6,1,1,1,1,1,6,1,1,1,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,5,2,2,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,7,1,7,7,1,1,7,7,1,1,1,1,1,1,1,7,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,2,1,1,0,1,1,1,1,1,6,6,6,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,5,5,5,5,1,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,5,5,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,1,1,1,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,5,5,5,5,5,5,5,5,1,1,5,5,5,6,6,6,6,6,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,1,1,1,1,5,5,5,2,2,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,1,1,6,6,6,4,1,1,1,5,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,5,2,2,1,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,5,5,5,5,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,5,5,5,5,5,5,5,5,1,5,5,5,6,6,6,6,1,1,1,1,1,1,1,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,1,1,1,1,5,5,5,2,2,1,1,1,1,1,1,0,0,0,0,0,0,0,0,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,7,7,7,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,5,1,1,1,1,1,1,2,2,1,1,1,1,6,6,6,1,1,5,5,5,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,1,1,1,2,2,2,2,1,5,5,1,5,5,5,5,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,5,5,1,1,5,5,5,5,5,6,5,6,1,6,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,5,5,5,5,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,7,7,7,7,1,1,1,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,5,5,5,1,1,1,1,2,1,1,1,1,1,1,4,6,6,6,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,2,2,1,2,2,1,1,1,1,2,2,2,2,1,1,1,1,5,5,1,1,1,1,1,1,1,1,2,2,1,1,1,1,1,1,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,1,5,5,5,1,5,6,6,6,6,1,1,1,1,1,1,1,1,1,1,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,5,5,5,5,1,1,1,1,2,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,7,7,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,5,5,5,1,1,2,5,5,1,1,1,1,1,1,1,4,6,6,5,5,5,1,1,1,1,1,1,1,1,1,1,1,6,1,1,1,2,1,1,1,1,1,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,1,1,1,1,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,1,1,6,6,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,2,1,1,0,0,0,0,0,2,1,1,1,5,5,5,5,5,1,1,1,1,1,1,2,0,0,0,0,0,0,0,0,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,1,1,1,1,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,7,7,1,1,2,1,1,1,1,1,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,5,5,5,1,1,5,5,5,5,1,1,1,1,1,1,1,6,6,5,5,5,5,1,1,1,1,1,6,6,1,1,6,6,6,1,1,1,2,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,1,5,5,5,5,5,1,1,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,1,1,1,1,1,1,5,5,5,1,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,6,5,1,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,0,1,1,1,1,1,1,5,5,5,5,5,5,1,1,1,1,1,1,2,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,1,1,1,1,1,1,5,5,5,5,1,1,1,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,7,7,1,1,1,1,1,1,2,2,2,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,5,5,5,1,1,5,5,5,2,1,1,1,1,1,1,1,1,6,1,5,5,5,1,1,1,1,6,6,6,5,5,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,2,1,2,2,2,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,5,5,5,5,5,5,2,2,2,1,1,1,1,1,1,1,1,1,2,6,6,6,1,6,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,0,0,0,1,1,1,1,1,5,5,5,5,1,1,1,1,1,1,1,2,0,0,0,0,0,0,0,0,0,2,1,1,1,1,1,1,1,1,1,1,1,2,1,1,5,5,5,5,5,1,1,5,5,1,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,5,1,1,5,5,5,5,2,2,1,1,1,1,1,1,1,1,1,5,5,5,1,1,1,6,6,6,5,5,5,5,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,1,1,1,1,6,5,5,5,5,5,1,5,5,5,5,5,1,5,1,1,1,1,1,1,6,1,6,6,6,6,6,1,1,1,1,1,1,5,5,5,1,1,1,1,1,1,1,1,1,1,4,1,1,1,1,1,5,5,5,5,5,5,5,5,2,2,2,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,5,5,5,5,1,1,1,1,1,1,2,1,0,0,0,0,0,0,0,0,0,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,7,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,5,5,5,1,5,5,5,2,2,1,2,1,1,1,1,1,1,1,1,1,5,1,6,6,6,6,6,1,5,5,5,5,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,1,1,1,6,6,6,5,5,5,6,6,1,5,5,5,5,5,1,1,1,1,1,1,6,6,6,6,6,6,6,6,1,1,1,1,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,1,1,5,5,5,5,2,2,2,2,2,1,1,1,1,1,1,1,1,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,1,1,1,2,2,2,5,5,5,5,5,1,1,1,1,1,1,1,1,2,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,1,5,5,5,5,5,1,5,5,5,5,5,5,5,5,1,5,5,5,5,5,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,7,7,2,1,1,1,1,1,1,2,2,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,1,1,1,2,1,1,1,1,1,1,1,5,5,5,6,6,6,6,1,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,1,1,1,6,6,2,6,6,6,6,1,1,1,5,5,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,1,1,1,5,5,5,5,5,5,5,5,1,1,1,1,1,4,1,1,1,1,1,5,5,5,5,5,5,1,2,2,5,5,5,5,2,2,2,1,1,1,1,1,1,1,1,1,1,6,1,1,1,2,1,1,1,1,1,1,1,1,1,1,2,1,1,4,4,4,4,4,1,1,1,1,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,1,1,2,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,2,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,1,1,1,1,1,5,1,1,1,1,1,1,1,5,1,5,1,1,1,1,5,1,5,1,1,1,1,1,1,1,1,1,1,2,0,0,0,0,0,0,0,0,0,0,0,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,5,5,5,5,6,6,6,1,1,5,5,5,5,5,6,1,1,1,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,6,4,6,6,6,6,1,1,1,5,5,5,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,1,1,1,1,5,5,5,1,5,5,5,1,1,1,1,4,4,4,1,1,1,1,1,5,5,5,5,5,1,2,2,3,3,5,3,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,1,1,1,6,6,6,6,6,1,1,6,1,1,1,1,1,1,1,1,1,2,2,2,2,3,3,3,2,2,2,2,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,2,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,0,0,0,0,0,0,0,0,0,0,0,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,1,1,1,4,4,1,1,1,1,5,5,5,5,5,5,1,1,1,1,1,5,1,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,4,6,1,1,1,1,5,5,5,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,5,5,5,1,1,1,1,1,4,1,1,1,1,1,1,5,5,5,5,5,2,2,3,3,3,3,3,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,1,1,1,1,6,6,6,6,6,6,6,6,1,6,1,1,1,1,1,1,1,2,2,3,3,3,3,3,2,2,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,2,0,0,0,0,0,0,0,0,0,0,0,2,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,6,1,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,2,2,1,1,2,1,1,1,1,2,0,0,0,0,0,0,0,0,0,0,0,7,7,1,1,1,1,1,1,2,1,1,1,1,1,1,1,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,2,5,5,5,5,1,5,1,1,1,4,4,4,4,1,1,1,1,5,5,5,5,5,1,1,1,1,1,1,6,6,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,4,4,1,1,1,1,1,1,5,1,1,1,1,1,1,1,1,1,6,6,1,4,6,1,6,1,1,1,1,1,1,1,1,5,5,5,5,1,1,1,4,1,1,1,1,1,1,1,5,5,5,5,5,5,5,2,3,3,3,3,3,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,1,1,1,1,1,6,6,6,6,6,6,6,1,6,6,6,1,1,1,1,2,1,1,3,3,3,3,3,3,3,3,5,5,5,5,2,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,4,4,4,4,6,6,6,5,5,5,1,1,1,5,1,5,5,5,1,1,1,1,1,2,2,2,1,2,2,1,2,2,2,2,2,2,2,1,2,1,1,1,0,0,0,0,0,0,0,0,0,0,0,7,7,7,1,2,1,1,2,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,2,2,5,5,5,5,5,1,1,1,1,4,4,4,4,1,1,1,1,5,5,5,5,5,5,1,1,1,1,6,6,6,5,5,5,5,5,1,1,4,4,1,4,4,1,1,1,1,6,6,1,6,1,6,6,6,6,6,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,4,4,4,1,1,1,1,1,1,1,1,1,5,5,5,5,1,1,1,4,4,4,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,3,3,3,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,1,1,1,1,6,6,6,6,6,6,1,6,6,6,6,1,1,1,1,2,2,2,2,3,3,2,3,3,3,5,5,5,5,2,2,1,1,1,2,2,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,4,4,4,4,6,6,6,6,6,5,1,1,1,5,5,5,5,5,5,5,1,1,1,2,2,2,1,1,1,1,1,1,1,2,2,1,2,2,2,2,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,7,2,2,1,1,2,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,5,5,5,5,1,1,1,4,4,4,4,4,4,1,1,1,5,5,5,5,5,5,1,6,6,6,6,6,6,6,5,5,1,1,4,4,4,4,4,4,4,4,1,1,6,6,6,6,6,6,1,6,6,6,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,4,4,4,4,1,1,1,1,1,1,1,1,5,5,5,1,1,1,1,1,1,4,1,1,1,5,5,5,5,5,5,1,5,1,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,1,1,5,5,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,1,6,6,6,6,6,6,6,1,1,6,6,1,1,1,1,1,1,2,2,2,2,2,2,1,3,3,5,5,5,5,1,2,1,1,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,4,4,4,4,6,6,6,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,2,1,1,1,1,1,2,2,2,2,2,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,2,1,1,1,1,1,1,1,1,1,1,1,1,1,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,5,5,1,1,1,4,4,4,4,4,4,4,1,1,1,1,5,5,5,5,5,6,6,6,6,6,6,6,6,6,4,1,4,4,4,4,4,1,4,4,1,1,1,6,6,6,1,6,1,1,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,4,4,4,4,4,1,1,1,1,1,1,1,1,5,5,5,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,1,1,1,1,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,1,5,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,3,2,5,5,1,1,1,1,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,1,1,1,1,1,1,1,1,1,4,4,4,4,4,6,6,6,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,2,2,2,2,2,1,2,2,2,1,2,2,2,2,2,2,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,6,6,4,4,1,4,4,4,1,1,5,5,5,5,5,1,1,6,6,6,6,6,6,6,6,4,4,4,4,4,4,4,1,1,1,1,1,1,1,6,1,1,1,1,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,1,1,1,1,1,1,1,1,5,5,5,1,1,1,4,1,1,1,1,1,1,5,5,1,1,1,1,1,1,1,1,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,1,5,5,5,5,5,5,5,1,1,1,1,1,1,1,4,4,4,1,4,4,4,4,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,1,1,1,1,1,1,1,1,1,4,4,4,4,4,6,5,4,5,6,5,1,5,5,5,1,1,5,1,5,2,2,2,2,2,1,1,1,2,1,1,1,2,2,2,2,2,2,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,4,6,6,6,6,4,4,4,4,4,1,1,5,5,5,5,1,1,1,1,1,1,6,6,6,6,6,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,4,6,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,1,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,5,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,1,1,1,5,5,5,5,5,5,5,5,1,1,1,1,4,4,4,4,4,4,1,1,4,4,4,6,1,6,6,6,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,2,2,1,2,2,1,1,2,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,4,4,4,6,4,6,6,6,6,1,1,5,1,1,1,1,5,5,5,1,2,1,1,1,2,2,1,1,1,2,1,2,2,2,1,2,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,2,2,2,2,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,4,4,4,6,6,4,6,6,4,4,4,1,5,5,5,5,5,1,1,1,1,1,1,1,6,1,6,4,4,4,4,4,1,4,4,4,4,1,1,1,1,1,1,1,1,1,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,5,5,1,1,1,1,1,1,1,1,1,1,1,1,5,1,1,5,5,5,1,5,5,5,5,5,5,5,5,1,1,1,1,6,4,4,4,4,4,4,4,4,1,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,0,0,1,1,1,2,2,2,2,2,2,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,1,5,5,5,1,5,1,1,1,5,5,2,2,2,1,1,2,2,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,2,2,2,2,1,1,1,2,1,1,1,1,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,6,6,6,6,4,1,1,1,5,5,5,1,1,1,1,1,1,1,1,1,1,4,4,4,4,1,1,1,1,4,4,4,4,1,1,1,1,1,1,1,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,1,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,1,5,5,5,5,5,5,5,5,1,1,1,1,1,6,1,6,6,6,4,4,4,1,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,2,0,0,0,2,1,1,2,2,2,2,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,1,5,5,5,5,5,5,5,5,1,5,5,5,2,2,2,2,2,2,2,2,1,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,2,1,2,1,2,2,2,1,1,1,1,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,4,6,1,4,4,6,6,6,6,1,1,1,5,5,5,1,1,1,1,1,1,1,1,1,1,1,4,4,1,1,1,1,1,4,4,4,4,4,1,1,1,1,1,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,1,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,1,5,5,5,1,1,1,5,5,5,5,5,5,5,1,1,1,1,6,6,6,6,6,6,4,4,4,1,1,1,4,1,4,4,4,4,4,5,5,5,1,1,1,1,1,1,1,1,1,2,0,1,1,0,2,1,2,2,2,2,1,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,1,1,1,1,1,1,1,1,1,1,4,6,6,1,1,1,1,5,5,5,1,5,5,5,5,5,5,1,1,2,1,2,2,1,2,1,1,1,2,2,2,2,1,1,1,1,1,2,2,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,2,2,1,1,1,1,1,1,1,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,2,1,1,1,1,6,6,6,1,4,1,6,6,6,6,1,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,6,6,1,1,1,1,1,5,5,1,5,5,1,1,1,4,1,4,4,4,4,4,4,4,1,1,1,1,4,4,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,5,5,5,5,5,5,5,1,1,1,5,5,1,5,5,5,5,1,1,6,1,6,6,6,6,4,4,4,4,1,1,1,1,1,1,1,1,4,5,5,5,5,5,5,1,1,5,1,5,1,1,0,0,0,0,0,1,1,1,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,1,2,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,5,5,5,5,1,1,5,1,5,1,1,1,2,1,2,2,1,1,2,1,1,1,2,2,2,2,2,2,1,1,2,2,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,1,1,2,2,1,1,1,1,1,1,1,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,2,2,1,1,6,6,6,6,1,1,1,1,6,6,6,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,5,5,5,5,5,5,5,1,4,4,4,4,4,4,1,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,2,5,5,5,1,5,1,5,1,1,1,1,1,1,1,1,5,5,6,5,6,6,6,6,6,6,4,4,4,4,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,1,0,0,0,2,2,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,1,1,1,1,1,1,4,4,4,1,1,1,5,5,5,5,5,5,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,3,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,2,2,1,1,1,1,1,1,1,1,1,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,1,6,1,1,6,6,6,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,1,1,1,1,1,5,5,5,5,5,1,4,4,4,4,1,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,1,5,1,1,5,5,5,5,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,1,1,4,1,1,1,1,1,1,1,1,1,1,5,5,5,5,1,5,1,5,1,1,5,1,5,5,5,1,2,2,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,2,2,1,1,1,1,1,1,4,4,4,1,1,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,3,1,3,3,3,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,2,1,1,1,1,1,1,1,1,1,1,1,2,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,5,1,1,1,1,5,5,5,5,1,1,1,1,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,5,5,5,1,5,1,1,1,5,5,5,5,5,1,5,1,1,1,1,1,1,1,1,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,1,5,5,5,1,1,1,5,5,5,5,5,1,1,1,2,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,1,2,2,1,1,2,1,1,1,1,4,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,3,3,3,3,3,3,1,2,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,5,5,5,1,1,1,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,1,1,1,1,1,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,1,5,5,5,5,5,1,5,5,5,1,2,2,2,1,1,1,2,6,6,6,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,1,5,5,5,5,5,5,1,1,2,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,2,2,2,2,1,2,2,1,5,5,5,5,5,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,2,1,2,2,2,3,3,3,3,3,2,2,1,1,2,1,1,1,1,2,1,2,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,2,0,0,0,0,0,0,0,0,0,0,0,0,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,1,1,1,1,1,1,1,1,1,1,1,6,6,5,1,5,1,5,1,1,5,5,5,5,6,1,1,6,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,1,1,6,1,1,1,1,5,5,5,5,5,5,5,1,1,1,1,1,1,1,6,6,6,6,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,5,5,5,5,1,1,1,1,1,2,1,1,6,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,1,1,1,1,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,2,2,2,2,2,1,2,2,1,5,5,5,5,1,1,2,2,1,1,1,1,1,1,1,1,1,1,1,6,6,6,2,1,1,2,2,1,2,3,3,3,2,1,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,1,1,1,2,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,2,1,1,1,1,1,1,1,2,2,1,1,1,1,1,1,1,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,1,1,1,1,1,1,1,1,1,1,6,5,5,5,1,5,5,5,1,1,5,5,6,6,6,6,6,6,1,1,1,1,1,1,5,5,5,1,5,5,5,5,5,1,1,1,6,6,6,1,1,1,1,5,5,1,1,5,1,1,1,1,1,1,1,6,6,6,6,6,1,1,1,1,1,1,1,1,1,5,5,1,1,5,5,5,1,5,1,1,1,1,4,4,5,5,1,1,1,1,6,1,1,1,1,1,1,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,1,1,1,1,1,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,2,2,2,2,2,2,2,5,5,5,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,1,1,1,2,2,1,3,3,3,3,3,1,3,3,1,2,2,1,1,1,2,1,1,1,1,1,1,1,1,1,1,7,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,2,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,2,2,1,2,2,1,1,1,1,1,1,1,1,1,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,1,1,6,1,5,6,5,5,6,6,6,1,1,1,1,5,5,5,5,5,5,5,5,1,1,1,1,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,1,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,2,2,2,2,2,2,2,1,5,1,2,2,2,2,2,1,2,2,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,1,1,1,2,2,3,3,3,3,3,3,3,3,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,7,7,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,6,6,6,6,1,5,5,6,6,6,6,6,1,1,1,1,5,5,5,5,5,5,1,1,1,1,1,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,1,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,1,1,1,1,1,1,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,2,3,3,2,2,2,2,2,1,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,1,1,2,3,3,3,3,3,3,3,3,1,1,1,2,2,2,1,2,2,2,2,1,1,1,1,1,1,7,7,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,2,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,6,6,6,6,1,1,6,6,6,6,6,6,1,1,1,1,1,1,5,5,5,5,5,1,1,1,1,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,6,1,6,6,6,1,1,1,1,1,1,1,1,1,1,2,1,1,2,2,2,2,1,1,1,1,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,1,1,1,1,1,1,1,1,5,5,5,5,5,5,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,1,7,1,1,2,0,7,0,0,0,0,0,0,0,0,0,0,0,0,0,2,1,1,3,3,3,3,3,2,1,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,1,1,3,3,3,3,3,3,1,3,1,1,1,1,1,1,2,2,2,2,1,2,1,1,1,1,1,1,7,7,7,7,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,2,1,1,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,1,1,5,5,1,1,1,1,1,1,1,1,1,1,5,5,5,5,1,5,6,6,6,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,5,5,1,1,1,1,1,4,6,1,1,6,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,2,1,1,1,2,2,1,1,1,1,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,2,1,1,1,1,1,1,5,5,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,1,2,2,3,3,3,3,3,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,2,2,3,3,3,3,3,2,2,2,2,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,7,7,7,6,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,2,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,1,6,6,6,6,6,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,6,6,6,1,6,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,2,1,1,1,2,2,1,1,1,1,4,4,4,4,4,4,4,4,4,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,2,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,1,2,1,2,3,3,3,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,6,6,6,3,3,3,3,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,2,7,1,6,6,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,2,2,2,2,2,2,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,5,1,1,1,1,1,1,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,1,1,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,1,1,1,1,1,1,1,2,2,2,2,1,1,1,2,2,1,1,1,1,1,4,1,4,4,4,4,4,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,1,1,2,2,2,3,3,3,2,2,2,2,2,2,2,2,1,1,1,1,1,2,1,1,1,1,1,1,1,1,6,6,6,6,6,6,3,3,3,2,1,2,2,1,1,1,1,1,1,1,1,2,1,1,1,2,2,1,1,1,1,1,1,1,1,1,1,6,6,6,6,0,0,0,0,0,0,0,1,1,1,1,1,1,2,0,0,0,0,0,0,0,0,0,0,0,0,1,1,2,2,2,1,2,1,1,1,1,5,5,1,1,2,1,1,1,1,1,1,1,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,1,1,1,1,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,1,4,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,2,1,1,1,1,1,1,1,4,1,1,4,1,4,4,6,1,1,6,6,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,1,1,1,2,2,3,3,3,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,3,3,2,2,2,1,1,1,1,1,1,1,2,1,1,2,2,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,6,6,6,0,0,0,0,0,0,0,0,0,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,2,2,2,1,2,1,1,1,5,5,5,5,2,2,1,1,1,1,1,1,1,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,6,6,6,6,6,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,1,2,2,1,1,1,1,1,4,4,4,1,1,1,1,4,4,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,2,2,2,3,3,3,3,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,6,1,1,6,6,6,3,1,2,2,2,1,1,1,1,1,1,1,2,1,1,2,2,2,1,1,1,1,5,5,1,2,2,2,1,1,1,1,1,1,6,6,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,2,2,2,2,1,5,5,1,5,5,5,5,2,2,2,1,1,1,1,1,1,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,6,6,6,6,6,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,4,1,1,1,1,4,4,6,6,6,6,6,1,1,1,1,1,1,5,5,1,1,5,5,5,5,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,1,1,2,2,2,3,3,3,3,2,2,2,2,1,1,1,1,1,1,1,1,5,1,2,1,5,1,5,5,5,1,1,6,6,6,2,1,2,2,2,1,2,2,1,1,1,2,2,1,1,1,1,1,2,1,1,5,5,5,5,1,2,2,2,1,1,1,1,1,1,6,6,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,1,1,2,2,2,2,5,5,5,5,5,5,5,5,2,2,2,2,1,1,1,1,1,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,1,1,1,6,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,1,1,6,6,6,4,4,4,4,4,4,4,1,1,1,1,1,1,1,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,6,1,1,1,2,1,1,1,1,5,5,5,5,5,5,5,5,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,1,2,2,2,3,3,3,3,2,2,2,2,2,1,2,1,1,1,1,5,5,5,1,5,5,5,5,5,5,1,1,6,6,6,6,1,6,6,2,6,2,2,2,1,1,1,1,1,1,2,1,1,1,1,1,1,5,5,5,1,2,2,2,1,1,1,1,1,1,1,6,6,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,1,1,1,2,2,2,5,5,5,5,5,5,5,1,2,1,1,1,1,1,1,1,1,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,1,1,1,6,6,6,1,1,1,1,1,1,4,4,4,4,4,4,4,1,1,1,1,6,6,6,4,4,4,4,4,1,1,1,1,1,1,1,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,1,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,1,2,2,1,3,3,3,2,3,3,2,2,2,2,2,1,1,1,1,5,5,5,1,1,5,5,5,5,1,1,1,1,6,6,6,6,6,6,6,6,6,2,2,1,1,1,1,1,1,1,1,2,1,1,1,1,5,5,5,2,2,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,1,1,1,2,2,2,2,5,5,5,5,5,1,1,2,1,1,1,1,1,1,1,1,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,1,6,1,1,6,1,1,1,1,1,1,1,1,4,4,4,4,4,4,1,1,1,6,6,6,6,1,4,4,4,4,1,1,1,1,1,1,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,1,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,1,2,2,1,1,3,3,3,3,3,3,2,2,2,2,1,1,1,1,5,5,5,1,5,5,5,5,5,5,1,1,1,1,1,6,1,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,2,2,2,2,5,2,5,5,1,1,2,1,1,1,1,1,1,1,1,5,5,5,5,1,1,1,1,1,4,4,1,1,1,1,1,1,1,5,5,5,5,5,1,1,1,1,1,1,1,1,1,4,4,4,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,6,6,6,6,1,1,4,4,4,4,4,1,1,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,1,1,1,5,5,5,1,1,1,1,1,1,1,1,1,1,6,1,1,6,6,6,6,6,1,1,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,2,2,2,1,3,3,3,3,3,3,3,2,2,2,2,2,2,1,1,1,5,5,1,1,5,5,5,5,5,5,1,1,2,1,1,1,1,1,1,6,1,1,1,1,1,2,1,1,1,1,2,1,2,1,1,1,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,2,0,0,0,0,0,0,0,0,1,1,1,1,1,2,2,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,5,5,5,1,1,1,1,1,4,4,4,4,1,1,1,1,1,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,4,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,1,1,1,4,4,4,4,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,1,1,5,1,1,1,1,1,1,5,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,1,2,2,2,3,3,3,3,3,3,2,2,2,2,2,2,2,1,1,1,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,2,1,2,2,2,1,2,2,1,1,1,1,2,1,1,2,2,5,5,1,5,5,1,1,1,1,1,1,2,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,1,1,1,1,1,2,2,5,5,5,5,5,5,5,1,1,1,1,1,1,1,6,6,1,5,1,1,1,1,1,1,4,4,4,4,1,1,1,1,1,1,5,5,5,1,5,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,6,6,6,6,6,1,1,1,1,4,4,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,5,5,6,6,6,1,6,1,6,1,1,1,1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,5,5,5,1,1,2,2,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,1,2,2,2,3,3,3,3,3,2,2,2,2,2,2,2,2,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,2,2,2,2,1,1,2,1,1,2,2,2,1,1,1,2,5,5,5,5,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,2,5,5,5,5,5,5,5,5,1,1,1,1,1,6,6,6,6,1,1,1,1,1,1,4,4,4,4,1,1,1,1,1,1,1,1,5,1,5,5,5,1,1,1,1,1,1,1,1,1,1,6,6,1,1,1,1,1,1,1,1,1,6,6,6,6,6,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,4,4,4,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,6,6,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,1,1,1,2,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,2,2,2,2,3,3,3,3,3,2,2,2,2,2,2,2,1,2,1,1,1,2,1,5,5,5,1,1,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,2,5,1,1,2,1,1,1,1,1,1,5,5,5,5,1,1,1,1,1,1,2,2,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,2,5,5,5,5,5,5,5,1,1,1,1,1,6,6,6,6,1,1,1,1,6,1,4,4,4,4,1,1,1,1,1,1,1,1,1,1,5,5,5,5,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,1,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,5,5,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,6,1,6,1,6,1,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,6,1,5,5,1,1,1,0,0,0,0,0,0,0,2,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,7,7,2,2,2,1,3,3,3,3,2,1,2,2,2,2,2,2,2,1,1,2,1,1,1,6,6,6,1,1,5,5,5,5,1,1,1,1,1,1,1,1,1,1,5,5,5,2,1,1,1,1,1,1,1,1,5,5,5,1,1,1,1,1,2,2,2,2,2,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,5,5,5,5,5,5,1,1,1,1,1,6,6,6,6,1,1,6,6,6,6,6,4,4,4,1,1,1,1,1,1,1,1,1,1,1,5,5,5,1,1,1,1,1,1,1,1,1,1,1,6,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,1,1,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,6,5,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,6,6,6,6,6,6,6,6,6,1,1,1,1,1,1,6,1,1,1,1,1,1,6,5,5,5,5,5,5,5,5,5,5,1,1,2,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,5,1,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,7,7,1,2,2,3,3,3,3,2,2,2,1,2,2,2,2,2,2,2,2,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,1,1,1,1,1,1,1,1,1,2,5,2,1,1,1,1,1,2,2,2,2,2,2,2,1,1,1,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,2,2,1,1,6,6,6,6,1,6,6,6,6,6,6,6,6,4,4,4,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,6,1,1,1,1,1,1,1,1,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,6,6,6,2,2,1,1,1,1,1,1,1,1,1,6,1,1,1,1,1,1,1,2,2,6,6,6,6,6,6,6,6,6,6,6,1,1,1,1,1,6,6,6,6,6,1,6,5,6,5,5,5,5,5,5,5,5,5,5,5,1,2,0,0,0,0,2,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,1,5,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,7,7,1,2,2,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,1,2,2,1,6,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,1,1,2,1,1,1,1,1,1,1,2,2,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,1,6,6,6,6,6,6,6,6,6,6,6,6,6,4,4,4,4,1,1,1,1,1,1,2,1,1,1,5,5,5,5,5,5,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,1,4,4,4,4,1,1,4,1,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,1,5,6,6,6,6,2,2,2,1,1,1,1,1,6,6,6,6,1,1,1,1,1,1,1,6,6,6,6,6,1,6,6,6,6,6,6,6,1,1,1,1,1,6,6,6,6,6,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,2,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,7,7,1,1,2,3,2,2,2,2,2,2,2,2,1,2,1,2,2,2,2,1,1,1,2,1,1,1,1,1,2,2,1,1,1,1,1,1,1,1,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,1,1,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,1,6,1,6,6,6,6,6,1,6,6,6,4,4,4,4,4,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,6,6,6,6,6,1,6,1,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,1,1,6,6,2,2,2,1,1,1,1,6,6,6,6,6,1,1,1,1,1,1,1,1,5,6,6,6,6,6,6,6,6,6,6,6,6,6,1,1,1,1,1,6,6,6,1,5,5,5,5,5,5,5,5,1,1,1,1,5,5,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,1,5,1,5,5,5,5,5,1,5,5,5,1,1,1,1,1,1,1,2,2,1,1,0,0,0,0,0,0,0,0,0,0,0,7,1,1,2,2,2,2,2,2,3,3,2,2,1,1,1,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,2,1,1,1,1,1,1,1,5,1,1,1,1,1,1,1,5,5,2,5,5,5,5,5,1,1,1,5,5,6,6,5,1,1,6,6,4,4,4,4,4,4,1,1,1,1,1,1,1,1,5,5,5,5,1,5,5,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,1,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,1,6,6,6,2,1,1,1,1,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,5,5,5,6,6,6,6,1,6,6,6,6,6,1,1,1,1,1,1,1,1,4,1,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,1,2,2,2,2,1,1,1,1,5,1,1,1,1,1,1,1,1,2,1,1,1,1,0,0,0,0,0,0,0,0,0,1,1,1,1,2,2,2,2,2,3,3,3,3,2,3,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,5,5,5,5,5,5,5,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,2,1,2,2,2,2,2,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,5,5,5,1,1,1,1,1,5,5,5,2,2,2,2,2,2,1,1,1,1,5,5,5,5,1,6,6,6,4,4,4,4,4,1,1,1,1,1,1,1,1,1,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,4,6,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,6,1,1,1,1,1,1,1,1,1,1,5,1,1,1,6,1,6,6,2,1,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,6,6,5,5,5,5,6,6,6,6,1,1,1,1,1,1,4,4,4,1,5,1,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,1,2,2,1,1,2,1,1,1,1,1,1,5,1,1,5,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,2,2,2,2,1,3,3,3,3,3,3,3,2,2,2,2,2,2,1,1,1,2,2,1,1,1,1,1,1,1,1,5,5,5,5,5,1,1,5,5,5,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,2,2,1,2,2,2,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,5,5,5,5,5,1,1,1,1,1,5,5,5,2,2,2,2,2,1,1,1,1,5,1,5,5,6,1,6,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,5,5,5,5,5,1,1,1,1,6,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,2,2,5,5,5,5,5,1,5,5,5,5,6,6,6,6,1,1,1,1,1,1,1,4,4,4,1,5,5,5,1,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,1,2,1,1,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,1,1,1,1,2,2,2,2,2,3,3,3,3,3,2,2,2,2,2,2,2,1,1,2,2,2,1,1,2,1,1,1,1,5,5,5,5,5,5,5,5,5,5,1,1,1,1,2,1,1,2,1,1,1,1,1,1,1,1,1,1,2,2,1,1,2,2,2,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,5,5,5,5,5,1,1,1,1,5,5,5,5,2,1,1,1,1,1,1,5,5,5,1,6,6,6,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,1,1,1,1,1,5,5,5,5,5,1,1,1,1,6,6,6,1,1,1,1,6,6,6,6,1,1,1,1,5,5,5,5,5,1,1,2,1,1,1,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,1,1,5,5,5,5,1,1,6,6,5,5,5,1,1,1,1,4,4,4,4,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,2,1,3,3,1,1,2,1,1,1,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,5,5,5,5,5,5,1,5,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,2,5,5,5,5,1,1,1,1,2,5,5,5,5,2,1,1,1,1,5,5,5,5,5,6,6,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,1,1,1,1,1,1,1,1,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,1,1,1,1,5,5,5,5,1,1,1,1,1,1,6,1,1,1,1,6,6,6,6,1,1,1,1,5,5,5,5,5,5,5,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,1,1,1,5,5,5,5,5,1,5,5,5,5,5,5,1,4,4,4,4,4,1,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,3,3,3,3,1,1,1,1,1,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,1,2,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,1,2,2,2,1,1,1,1,1,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,2,1,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,2,2,2,1,5,5,5,1,1,1,1,2,1,5,5,5,5,1,1,1,5,5,5,5,5,6,6,6,4,4,4,2,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,1,1,5,5,5,5,5,1,1,1,1,1,1,1,6,1,6,1,6,6,6,6,1,1,1,1,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,1,1,1,1,5,5,5,5,5,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,4,4,4,4,1,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,3,3,3,3,3,1,1,2,1,1,2,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,2,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,2,1,5,1,1,1,1,1,1,1,5,5,5,5,1,1,1,1,5,5,5,5,1,6,1,1,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,1,1,1,1,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,1,1,5,5,5,5,5,1,1,1,1,1,1,1,6,6,6,6,6,1,6,1,5,5,5,5,1,5,5,5,5,5,5,1,1,1,1,1,1,1,6,1,1,1,1,6,1,2,2,1,1,1,1,1,5,5,5,1,5,2,2,1,1,1,1,2,5,5,5,5,5,1,5,5,1,5,5,5,4,4,4,1,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,1,1,1,6,6,6,3,3,3,3,3,3,3,2,1,1,1,1,2,2,1,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,3,3,3,3,3,2,2,3,2,2,1,2,2,2,2,2,1,1,1,2,1,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,2,5,5,5,1,5,5,1,1,1,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,6,1,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,6,6,6,6,6,6,1,1,1,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,6,6,6,1,1,6,6,6,2,2,1,1,1,1,5,5,5,5,5,2,2,2,1,1,1,1,2,2,5,5,1,1,1,1,1,1,1,5,4,1,4,1,5,5,5,1,1,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,3,3,3,3,3,3,3,2,1,1,1,1,1,1,5,5,5,5,1,1,1,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,3,3,3,3,6,3,3,3,3,2,2,2,2,2,2,2,2,1,1,1,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,5,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,2,1,1,1,1,1,1,1,5,2,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,6,6,6,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,4,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,1,1,1,1,1,1,6,6,6,6,6,6,6,1,1,1,5,5,5,5,5,5,5,1,5,1,1,1,1,1,1,1,1,1,1,6,1,6,6,6,6,1,1,2,2,1,1,1,1,5,5,5,1,2,2,2,2,1,1,1,1,2,5,5,5,5,1,1,1,1,1,1,1,1,1,4,5,5,5,1,1,1,5,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,5,5,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,3,2,6,6,6,3,3,3,3,2,2,2,2,2,2,2,1,1,1,1,5,5,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,2,1,2,1,1,1,1,5,5,5,2,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,6,6,6,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,1,1,1,1,1,1,1,6,6,6,6,6,6,1,1,1,5,5,5,5,1,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,1,1,1,2,2,1,1,1,5,5,5,5,5,1,2,2,2,1,1,1,1,2,2,5,5,5,5,1,1,1,1,1,1,1,1,4,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,3,3,1,1,1,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,2,6,6,6,3,3,3,3,3,3,2,2,2,2,2,2,2,1,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,6,6,6,1,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,6,6,6,6,6,6,1,1,1,1,1,5,5,5,5,1,5,5,5,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,5,5,5,5,5,2,5,1,1,5,5,5,5,1,1,2,1,2,1,1,1,1,2,2,2,5,5,5,1,1,1,1,1,1,1,1,4,4,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,6,6,1,1,6,6,3,3,2,1,1,1,1,3,3,3,3,1,1,1,1,1,1,1,1,1,6,6,6,5,5,6,5,5,1,1,2,1,1,1,1,1,1,1,1,1,2,2,1,2,6,6,6,3,3,3,3,3,3,2,1,2,1,2,2,2,1,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,1,1,1,1,1,1,5,5,5,5,5,5,5,5,1,1,1,1,1,1,6,6,6,6,6,1,6,1,1,1,1,1,1,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,6,6,5,5,5,5,5,5,5,5,5,1,1,5,5,1,1,2,2,2,2,2,1,1,1,2,2,2,1,5,1,1,1,1,1,1,1,1,1,1,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,2,1,1,1,1,1,1,3,2,2,2,1,1,1,1,1,6,6,6,6,5,5,5,5,5,5,5,1,2,1,1,1,1,1,1,1,1,2,2,2,2,6,3,6,3,3,3,3,3,3,2,2,1,1,1,2,2,2,5,5,5,1,1,1,2,2,1,1,1,1,1,1,1,5,5,5,1,1,1,1,1,1,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,2,1,1,1,1,5,5,1,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,5,5,5,5,1,5,5,5,1,1,1,1,1,6,6,6,6,6,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,2,5,1,1,1,1,1,1,1,2,2,2,2,2,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,2,2,5,1,3,3,2,1,1,1,1,1,1,1,1,1,2,1,2,1,1,2,6,6,6,6,6,1,5,5,5,5,5,1,5,1,1,1,1,1,1,1,1,2,2,6,2,6,6,6,3,3,3,3,3,1,2,2,2,1,1,1,2,2,5,5,5,5,1,2,2,1,1,1,1,1,1,1,5,1,1,5,2,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,4,4,4,1,1,1,1,1,1,5,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,5,5,5,5,1,1,1,5,1,1,1,1,1,6,6,6,6,6,6,1,1,6,1,1,1,1,1,1,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,1,1,2,1,1,1,1,2,2,2,2,2,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,2,2,1,1,1,1,1,1,1,6,1,1,1,1,1,1,1,1,1,1,1,1,5,1,1,2,2,1,2,5,5,5,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,1,1,5,5,5,5,5,5,5,5,5,1,2,1,1,1,2,2,6,6,6,6,6,6,3,3,3,2,2,2,2,2,1,1,1,1,1,1,2,5,5,1,1,1,1,2,2,1,1,1,1,5,5,5,1,1,1,1,1,1,1,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,1,1,1,1,1,6,6,4,6,4,1,4,1,1,1,1,1,1,5,5,5,1,1,1,1,1,1,1,4,4,4,4,1,1,1,1,1,5,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,1,1,6,6,6,1,1,1,1,1,1,1,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,2,5,5,5,5,2,2,2,1,1,2,2,2,2,2,2,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,6,1,1,1,1,1,1,1,5,5,5,1,1,1,2,5,2,5,1,1,1,1,1,1,4,4,1,1,1,1,1,1,1,1,1,1,1,6,6,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,1,2,2,1,1,6,6,6,6,6,6,3,2,2,2,2,2,2,2,1,1,1,1,1,1,2,2,2,1,1,1,2,2,2,1,1,1,1,1,5,1,1,1,1,1,1,1,1,1,4,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,2,1,1,2,1,1,1,1,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,1,1,6,6,6,6,4,1,4,1,1,1,1,1,1,1,5,5,5,1,1,1,1,1,1,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,1,6,1,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,5,1,1,5,1,2,5,2,2,1,1,5,5,2,1,1,1,1,1,2,2,2,2,5,1,1,1,1,2,2,2,2,1,1,1,1,1,5,5,1,5,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,1,1,1,1,5,5,5,5,5,5,1,1,5,5,5,5,5,2,1,2,1,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,5,5,5,5,1,5,5,5,5,5,1,2,2,1,1,6,6,6,6,6,3,2,2,2,2,2,2,1,1,1,1,2,2,1,2,1,2,2,2,2,1,1,1,1,1,1,5,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,1,4,1,4,1,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,6,6,6,6,1,1,4,4,4,1,1,1,1,1,1,5,5,5,5,1,1,1,1,1,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,1,5,5,5,1,1,2,6,6,5,2,1,1,5,5,5,1,1,1,1,1,1,2,2,5,5,5,2,2,2,1,1,2,2,1,1,1,1,5,5,5,5,5,5,5,5,6,5,5,5,6,6,6,6,6,6,6,1,1,1,1,5,5,5,5,5,5,1,1,1,5,5,5,5,2,2,2,2,1,4,4,4,4,4,4,4,4,1,1,1,1,1,1,2,1,2,2,1,1,1,1,1,5,5,1,1,1,1,5,5,5,1,1,2,2,1,1,6,6,6,3,3,2,1,2,2,2,2,1,1,1,1,1,2,1,1,2,2,2,1,1,1,1,1,1,5,5,5,5,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,2,1,1,1,1,1,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,5,5,5,1,5,5,5,5,1,1,1,1,5,5,5,5,1,1,5,5,5,5,5,5,1,1,6,1,1,1,1,4,4,4,1,1,1,1,1,1,5,5,5,1,1,1,1,1,1,1,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,1,5,1,1,6,6,6,6,6,2,5,5,2,5,2,2,1,1,1,2,2,2,5,5,5,2,2,2,2,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,1,1,1,1,1,5,5,5,5,5,5,1,1,1,5,5,5,5,5,2,2,1,2,1,4,4,4,4,4,4,1,1,1,1,1,1,1,2,1,2,2,1,1,1,1,1,1,1,2,1,2,5,5,5,1,1,1,1,1,1,1,2,2,3,3,3,2,2,2,2,2,2,1,1,1,1,1,1,1,1,2,1,2,1,1,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,1,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,2,2,2,2,1,5,5,5,5,5,5,5,5,5,5,5,1,1,5,5,5,5,5,5,1,1,1,5,6,6,6,6,1,1,1,1,1,1,1,4,1,5,5,5,1,1,1,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,1,1,2,1,6,6,6,6,6,6,5,5,5,5,5,5,2,1,2,2,2,2,5,5,5,2,2,2,2,2,2,2,1,1,1,1,1,5,5,5,2,5,5,5,5,5,6,5,5,5,6,6,6,1,1,1,1,1,1,1,1,5,5,1,5,5,5,1,1,5,5,5,5,5,5,5,2,2,2,1,1,1,4,4,4,1,1,1,1,1,1,1,2,2,2,1,2,1,2,2,1,1,2,2,2,1,1,5,5,5,5,1,1,1,2,1,1,2,2,3,3,3,1,2,2,2,2,1,1,1,1,1,1,1,1,1,2,2,2,2,5,5,5,5,5,5,1,2,1,2,1,1,1,1,1,1,1,4,4,1,4,4,4,4,1,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,2,2,2,2,5,5,5,5,5,5,5,5,5,5,5,1,1,5,5,5,5,5,5,5,1,1,5,5,5,6,6,1,1,1,1,1,1,1,1,1,5,5,5,5,5,1,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,2,1,1,5,5,5,5,5,2,2,2,1,6,6,6,6,2,2,5,5,5,5,5,2,1,2,2,2,5,5,5,2,2,2,2,2,1,1,2,2,1,1,1,1,5,5,5,1,2,5,5,5,6,6,2,2,6,6,6,6,6,1,1,1,1,1,1,1,5,5,1,5,5,5,5,5,5,5,5,5,5,5,1,2,1,2,2,1,1,1,4,1,1,1,1,1,1,1,1,2,2,1,1,2,2,2,2,1,1,1,1,2,1,2,1,5,5,5,5,1,1,2,2,2,2,2,1,3,3,3,1,2,2,2,2,1,1,1,1,1,1,1,2,2,2,2,2,5,5,5,5,5,1,1,1,2,1,1,1,1,1,2,2,1,1,1,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,2,2,2,2,2,5,5,5,1,5,5,5,5,1,1,1,5,5,5,5,5,1,5,1,1,1,5,5,5,6,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,2,5,1,6,2,2,2,1,1,1,5,5,2,2,2,2,2,2,2,5,5,5,2,2,2,2,2,1,2,2,2,1,1,1,5,5,5,1,1,1,5,1,1,1,1,1,1,1,6,6,6,6,1,1,1,1,1,1,5,5,1,5,5,5,5,5,5,5,5,5,5,5,1,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,5,5,5,5,5,1,1,2,2,2,2,2,2,3,2,2,2,2,2,1,1,1,1,1,1,1,1,2,2,2,2,2,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,4,1,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,1,5,1,1,1,1,1,5,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,1,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,5,5,5,6,5,5,5,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,5,5,5,5,2,2,2,5,5,2,2,1,1,1,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,1,1,1,1,1,1,1,5,1,1,5,5,5,5,5,5,1,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,1,1,1,2,2,2,2,1,2,2,2,1,2,2,1,2,1,1,1,1,1,1,1,1,2,1,1,2,5,1,1,1,2,1,1,2,1,1,1,1,1,1,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,5,5,5,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,2,2,2,6,6,6,5,2,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,5,5,5,5,5,5,5,5,5,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,1,1,1,1,5,1,5,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,2,2,2,1,2,5,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,1,1,1,1,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,2,1,2,2,1,1,2,1,1,1,1,1,1,1,1,1,1,2,1,1,1,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,1,2,5,5,5,5,5,1,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,1,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,4,1,1,4,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,2,2,6,2,2,2,5,1,2,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,5,5,5,5,5,5,5,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,1,1,5,5,5,5,1,1,1,1,1,1,1,1,2,1,1,1,1,2,2,2,2,2,2,2,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,1,1,1,1,1,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,5,1,5,5,1,1,1,1,2,2,1,1,1,1,1,1,1,1,1,2,2,2,4,4,4,4,4,4,1,1,1,1,1,1,1,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,1,1,1,1,4,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,1,1,1,1,1,4,4,4,1,1,1,1,6,1,1,1,1,1,1,6,6,6,6,6,6,6,2,2,2,5,5,5,5,2,2,1,2,2,2,2,1,2,2,2,2,2,3,3,3,3,3,5,5,5,5,5,3,3,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,1,5,1,1,1,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,5,5,5,1,1,1,2,1,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,1,1,2,1,1,5,1,5,5,5,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,4,4,4,1,1,1,1,6,6,6,1,1,1,1,1,1,6,6,6,6,6,2,2,2,5,5,5,5,5,5,2,2,2,2,2,2,1,2,2,2,2,3,3,3,3,3,3,3,3,3,3,2,3,2,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,1,1,1,1,1,1,1,5,5,6,5,1,1,1,1,1,1,1,2,2,1,1,1,2,2,2,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,2,2,5,2,2,1,1,2,2,2,2,2,2,2,1,1,1,1,1,1,5,5,1,1,1,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,6,1,1,1,2,2,2,2,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,4,1,1,1,1,1,1,4,4,4,1,1,1,6,6,6,1,1,1,1,6,1,6,6,6,6,2,2,2,5,5,5,5,5,5,5,5,2,2,2,2,2,2,2,1,2,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,0,0,1,1,1,1,1,1,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,1,1,1,5,1,1,1,1,1,6,6,6,1,6,6,6,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,1,1,5,5,5,5,5,5,1,1,1,2,1,2,2,2,2,2,2,2,2,2,2,1,1,2,2,2,2,1,1,5,5,5,5,5,1,1,5,5,5,5,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,6,7,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,4,4,4,4,1,6,6,6,1,1,1,1,6,6,6,1,6,6,2,2,2,2,2,5,5,5,5,5,5,2,5,5,5,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,2,2,2,1,2,2,2,2,2,0,0,1,1,1,1,1,1,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,2,5,5,5,1,5,5,5,1,1,1,6,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,5,5,5,5,5,5,5,1,1,1,1,1,5,5,5,5,5,1,5,1,1,1,1,1,1,1,2,2,2,2,1,1,1,2,2,2,2,5,5,5,5,5,5,1,5,5,5,5,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,1,1,1,1,1,1,1,1,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,7,7,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,1,1,1,1,1,1,1,4,4,1,6,6,6,1,1,1,1,6,1,6,1,1,2,2,2,2,2,2,2,2,5,5,5,5,2,5,5,5,5,5,2,2,2,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,1,2,2,2,2,2,0,0,0,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,2,5,5,5,5,1,5,1,1,1,1,6,5,6,6,1,6,6,6,6,1,1,1,1,1,1,1,1,5,5,5,5,5,5,1,1,1,1,1,1,5,5,5,5,5,5,5,1,1,1,1,1,1,2,2,2,2,2,1,1,2,2,2,2,1,5,5,5,5,5,5,5,5,5,1,6,6,1,1,1,1,2,6,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,1,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,6,6,6,1,1,1,2,1,2,2,2,2,2,2,5,5,5,5,2,3,5,5,5,5,2,2,2,3,3,3,3,3,3,3,3,3,1,2,2,2,2,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,1,1,1,5,5,5,1,1,5,1,6,6,6,1,1,1,1,1,1,1,5,5,5,5,5,1,1,5,1,1,5,5,5,5,5,5,5,5,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,5,1,5,5,5,5,5,6,6,6,6,2,1,1,6,6,6,2,2,1,2,2,5,5,5,1,2,2,1,1,1,1,1,1,1,1,5,5,5,5,5,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,1,1,5,5,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,1,1,1,1,1,1,1,1,1,6,1,6,1,2,1,6,1,1,6,1,1,1,1,2,2,2,2,2,2,2,2,2,5,5,2,3,3,3,5,5,5,2,2,2,3,3,3,3,3,3,3,3,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,0,0,1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,1,1,1,5,5,5,5,5,5,5,6,6,6,1,1,1,1,1,1,1,1,5,1,5,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,2,2,2,2,2,2,2,2,1,1,2,2,2,2,1,1,5,5,5,5,5,5,6,6,6,6,6,6,1,6,6,6,2,2,2,2,5,5,5,5,5,2,2,2,1,1,1,1,1,1,5,5,5,5,5,5,5,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,2,1,1,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,1,5,5,5,5,1,1,1,1,1,1,1,4,4,4,4,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,1,1,1,1,1,1,1,1,1,6,6,6,1,6,2,6,6,6,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,5,5,5,5,2,3,3,3,3,3,3,3,3,2,3,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,1,1,1,1,6,5,5,5,5,5,5,5,6,6,6,1,1,1,1,1,1,5,5,5,5,5,1,5,5,5,1,5,1,1,5,5,5,5,5,1,1,1,1,1,1,2,2,2,2,2,2,2,1,1,1,1,2,1,2,1,1,1,5,5,5,5,5,6,6,6,6,6,6,6,6,6,2,1,1,5,5,5,5,5,5,5,2,2,2,2,1,1,1,1,5,5,5,5,1,5,5,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,1,5,5,5,5,5,1,1,1,1,1,1,4,4,4,4,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,2,6,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,5,5,5,5,5,5,3,3,2,3,3,3,3,3,3,2,2,2,2,2,1,1,2,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,2,1,2,1,1,1,1,1,1,1,1,1,6,5,5,5,5,5,5,5,6,6,1,1,1,1,1,1,1,5,5,5,1,1,1,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,2,1,2,2,1,1,1,1,2,2,2,1,1,1,5,5,5,1,6,1,1,2,2,6,6,6,6,1,1,5,5,5,5,5,5,5,5,2,1,2,2,1,1,1,1,1,5,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,1,4,4,1,5,5,5,5,5,5,1,1,1,1,1,1,4,4,4,1,1,1,1,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,1,5,5,1,1,1,1,1,1,1,6,1,1,6,2,2,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,5,5,5,5,5,5,2,2,2,3,3,3,3,3,3,2,2,2,2,2,2,2,1,1,1,1,2,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,6,6,6,1,1,5,5,5,5,6,6,6,1,2,1,1,1,1,5,5,5,5,1,1,1,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,1,1,2,1,1,1,1,1,1,1,1,6,1,1,2,2,6,6,6,1,1,1,5,5,5,5,5,5,5,1,1,2,1,1,1,1,1,2,1,1,2,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,1,5,5,5,5,5,5,1,1,1,1,4,4,4,4,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,1,5,5,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,5,5,5,5,5,5,2,2,2,3,3,3,3,3,3,2,2,2,2,2,2,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,0,1,1,1,1,1,1,2,2,1,1,1,1,1,1,1,1,1,6,1,1,1,1,1,5,5,5,6,1,1,1,1,1,1,1,1,5,5,5,1,1,1,1,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,6,6,6,6,1,2,2,6,2,1,1,5,1,5,5,5,5,1,1,1,1,1,2,1,2,2,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,1,1,4,4,4,1,4,1,1,5,5,5,5,5,5,5,1,5,5,4,4,4,1,1,1,1,1,1,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,1,5,5,5,5,5,5,5,1,1,1,1,1,2,2,2,1,1,1,2,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,5,5,5,2,2,2,2,2,3,3,3,3,3,3,2,2,2,2,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,4,1,1,1,1,5,6,6,1,1,1,1,1,1,1,1,1,5,1,1,1,2,1,1,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,1,1,1,1,1,2,1,1,1,2,6,6,1,6,6,6,6,6,1,2,2,2,5,5,5,5,1,5,5,5,5,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,4,4,4,1,4,4,4,1,1,5,5,5,5,5,5,5,6,5,5,5,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,1,1,1,1,2,1,1,1,1,2,2,2,1,2,2,2,2,2,2,2,2,2,3,3,2,2,2,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,3,3,1,2,2,2,2,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,2,1,1,1,5,5,5,5,5,5,2,5,5,1,1,1,1,1,1,1,1,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,1,4,1,1,4,4,4,1,6,5,5,5,5,1,5,6,6,6,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,1,5,5,1,1,1,1,2,2,1,1,1,2,2,2,2,1,2,2,2,2,2,2,2,2,3,3,3,3,2,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,1,1,2,2,2,2,2,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,1,1,4,4,4,4,1,1,1,1,6,6,6,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,2,5,5,5,1,1,1,1,1,1,2,1,6,6,6,6,6,6,6,6,6,1,1,1,1,5,5,5,5,1,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,5,5,5,5,1,1,1,1,4,4,4,6,6,6,5,5,5,1,1,6,6,6,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,1,1,1,1,1,5,5,5,5,5,5,5,1,1,1,2,2,1,1,2,2,2,2,2,2,1,2,2,2,2,5,2,2,2,2,3,5,5,3,3,5,5,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,2,2,2,2,1,1,1,1,1,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,1,1,1,1,1,1,6,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,1,5,1,1,1,1,1,1,1,2,1,1,6,6,6,1,1,6,6,6,6,5,2,5,5,5,5,5,5,1,1,2,2,2,2,1,1,1,1,1,1,1,1,2,2,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,5,5,5,5,5,1,1,5,4,4,4,6,6,6,5,5,5,1,1,6,6,6,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,5,5,5,5,5,1,1,1,1,1,1,1,2,2,2,2,2,2,2,1,2,2,5,5,5,5,2,2,1,5,5,5,5,5,5,5,5,5,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,2,2,2,1,1,1,1,2,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,1,4,1,1,1,6,6,5,5,5,1,2,2,2,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,2,2,1,1,1,1,1,6,6,6,5,5,5,5,5,5,5,5,5,1,1,1,2,2,1,1,1,1,1,1,1,1,2,2,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,4,1,6,6,6,6,6,1,6,5,6,6,6,1,1,1,1,1,1,1,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,1,1,1,5,5,5,5,5,5,1,1,1,1,1,2,2,2,2,2,2,2,2,2,5,5,5,5,5,5,2,1,1,5,5,5,5,5,5,5,5,5,5,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,1,1,1,2,2,2,1,1,1,1,2,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,2,1,1,1,1,1,1,4,4,4,4,4,1,6,6,4,1,1,1,6,1,5,5,5,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,1,5,5,5,1,5,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,5,5,6,6,6,5,5,5,5,5,5,5,1,1,6,1,2,2,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,5,5,5,5,5,5,5,5,1,1,1,1,6,6,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,1,1,1,5,5,5,5,5,5,5,1,1,2,2,2,2,2,2,2,2,2,5,5,5,5,5,5,2,2,1,5,5,5,5,5,5,5,5,5,5,2,3,2,3,3,3,2,2,2,2,2,2,2,5,5,5,5,1,1,1,2,2,2,2,1,1,1,1,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,6,6,6,6,1,1,1,1,1,1,5,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,1,5,1,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,6,5,5,6,5,1,1,1,1,2,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,5,5,5,5,5,5,1,1,1,1,1,1,6,6,6,6,1,6,5,6,6,1,1,1,1,1,1,1,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,1,1,1,1,5,5,5,5,5,5,5,5,2,2,2,2,2,2,2,2,5,5,5,5,2,2,2,2,2,5,5,5,5,5,2,2,3,5,5,5,2,2,2,2,3,3,3,2,2,2,2,2,5,5,5,5,5,5,1,1,2,2,2,2,1,1,1,1,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,6,6,6,6,4,1,1,1,1,1,1,1,1,1,2,2,1,5,5,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,6,6,6,1,1,1,1,6,2,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,1,1,1,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,5,1,5,1,1,1,1,1,1,1,1,5,6,6,5,5,5,5,5,5,1,1,1,1,1,1,1,1,5,5,5,5,5,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,5,5,5,5,5,5,5,2,2,2,2,2,2,2,5,5,5,5,2,2,2,2,2,2,5,5,5,5,2,2,2,3,5,2,2,2,2,2,3,3,2,2,2,2,2,5,5,5,5,5,5,2,1,2,1,1,1,2,2,1,2,6,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,6,6,6,4,4,1,1,1,1,1,1,1,1,1,1,2,2,5,5,5,5,2,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,5,5,5,5,5,1,5,5,5,6,5,5,2,2,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,1,1,1,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,5,5,5,5,5,5,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,2,2,2,2,2,2,2,5,5,5,5,5,2,2,2,2,2,2,5,5,2,2,2,2,2,2,3,2,2,3,3,3,3,3,2,2,2,5,5,5,5,2,2,2,2,2,2,1,1,1,2,2,2,2,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,4,1,1,1,1,1,1,2,2,1,1,1,1,1,5,5,5,5,5,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,1,1,1,5,1,5,5,5,2,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,2,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,2,2,2,2,2,2,2,2,2,5,5,5,5,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,5,5,5,5,5,5,5,2,2,2,2,1,2,2,1,1,1,2,2,2,6,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,6,6,4,4,1,1,1,1,1,2,1,2,1,1,1,1,1,5,5,5,5,5,5,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,5,2,1,1,1,1,1,1,1,5,2,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,1,1,1,1,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,1,1,5,1,5,5,5,5,5,1,1,1,1,1,1,1,4,1,1,1,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,5,5,5,5,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,5,5,5,5,5,5,5,2,2,2,2,2,1,1,2,1,1,2,2,2,2,0,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,2,2,1,1,1,1,1,1,2,2,2,1,4,4,4,1,1,1,1,1,2,2,1,1,1,1,5,5,5,5,5,5,1,1,1,1,1,1,1,1,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,2,1,1,1,1,1,1,1,2,2,6,6,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,2,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,0,0,0,0,0,0,0,0,1,1,2,2,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,1,1,5,5,5,1,1,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,5,5,5,5,5,5,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,5,5,5,5,5,5,5,5,2,2,2,2,2,2,1,1,2,1,2,2,2,2,2,6,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,6,1,5,5,5,5,5,5,5,2,1,1,1,1,1,1,5,5,5,5,5,1,1,1,2,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,2,2,2,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,5,5,5,5,5,5,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,5,5,5,5,5,5,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,6,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,2,1,1,1,1,1,2,1,1,1,1,1,1,4,1,1,5,1,1,1,1,1,6,6,6,6,5,5,5,5,5,5,1,1,1,1,1,1,1,1,5,5,5,1,1,1,2,2,2,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,1,1,1,1,1,1,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,1,0,0,0,0,0,0,0,0,1,2,2,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,1,1,5,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,2,2,2,2,2,2,2,2,2,5,5,5,5,5,2,2,2,2,3,3,2,2,2,2,2,2,2,2,3,3,3,5,5,5,5,2,5,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,1,1,1,1,6,6,6,6,6,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,2,1,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,1,1,1,5,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,2,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,5,2,2,2,3,2,2,3,3,3,3,2,2,2,2,2,2,2,3,3,5,5,5,5,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,5,5,5,1,1,1,1,1,6,6,6,6,1,1,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,2,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,2,1,1,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,1,1,1,5,5,5,1,1,1,1,1,1,1,1,1,5,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,3,2,3,3,2,2,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,3,3,3,5,5,2,2,2,2,2,2,2,2,2,2,2,2,2,1,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,2,2,1,1,1,1,1,2,1,1,1,1,1,1,5,5,5,1,1,1,1,1,6,5,5,6,6,6,1,1,1,1,1,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,0,0,0,0,0,0,0,0,0,1,2,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,1,1,1,1,1,1,1,5,1,1,1,1,1,1,1,1,1,5,5,5,1,1,5,5,2,5,1,5,1,1,1,1,1,1,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,3,2,2,2,2,2,2,2,2,2,5,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,2,1,2,2,1,1,1,1,6,1,1,1,1,1,1,1,5,1,1,1,1,1,6,6,6,1,5,6,5,5,1,1,1,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,1,5,5,5,5,5,5,5,5,5,5,5,1,2,2,2,3,3,3,3,3,2,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,5,5,5,5,5,5,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,5,1,1,1,6,6,6,1,1,1,5,1,1,1,1,1,1,1,1,5,6,5,5,5,5,5,5,1,1,2,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,0,0,0,0,0,0,0,0,0,0,0,0,2,1,1,1,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,1,5,5,5,2,5,2,5,5,5,5,5,5,2,2,2,3,3,3,3,3,2,2,3,3,3,3,3,3,2,2,2,2,2,2,2,2,5,5,5,5,5,5,5,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,5,5,5,1,6,6,6,1,2,1,5,5,5,6,6,2,1,1,1,5,5,5,5,5,5,5,5,5,5,1,4,4,4,4,1,1,1,1,1,2,1,1,1,1,1,1,1,1,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,0,0,0,0,0,0,0,0,0,0,0,0,1,2,2,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,1,1,1,1,1,5,5,5,5,5,5,1,2,2,2,2,5,5,5,5,1,2,2,2,2,3,3,3,5,5,3,3,3,3,3,3,3,3,2,2,2,2,2,2,5,5,5,5,5,5,5,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,1,1,5,5,5,1,1,6,1,1,1,5,5,5,6,6,6,6,1,1,1,5,5,5,5,5,5,5,5,5,4,4,4,4,4,1,1,1,1,1,1,2,2,1,1,1,1,1,1,1,1,4,1,4,4,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,1,1,1,5,5,5,5,5,5,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,5,5,5,5,3,2,3,3,3,3,3,3,2,2,2,2,2,5,5,5,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,5,5,5,5,5,5,1,5,5,5,5,6,6,6,6,2,1,5,5,5,5,5,5,5,5,6,4,4,4,4,4,4,4,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,4,4,4,4,1,1,1,1,1,1,4,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,1,1,1,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,1,1,5,5,5,5,5,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,5,5,5,5,1,1,5,5,3,3,3,3,2,2,2,2,2,2,5,5,5,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,5,5,5,5,5,5,5,5,5,1,1,6,6,6,1,1,1,5,5,5,5,5,5,6,6,1,1,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,1,1,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,1,1,2,1,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,1,5,5,5,5,5,5,1,5,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,5,5,5,3,3,5,5,5,5,3,3,3,3,2,2,2,2,2,5,5,5,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,5,5,5,6,5,1,5,5,5,1,1,6,6,6,1,5,5,5,6,6,5,5,1,1,1,1,1,1,1,1,1,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,1,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,2,0,0,0,0,0,0,0,0,1,1,1,1,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,1,1,1,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,2,2,2,2,2,1,1,2,2,2,2,2,2,2,2,2,2,2,5,5,5,3,3,5,5,5,3,3,3,3,3,2,2,2,2,2,2,5,2,2,2,2,2,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,5,6,6,6,5,1,5,1,1,1,1,6,6,6,5,5,1,1,6,5,2,1,1,1,1,1,1,1,1,4,4,4,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,3,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,1,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,2,2,2,2,1,1,5,2,2,2,2,2,2,2,2,2,5,5,5,5,3,3,5,5,5,5,5,3,3,5,5,5,5,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,6,5,5,5,1,1,1,1,1,1,6,5,5,5,1,6,6,6,5,1,1,1,1,1,1,1,1,1,4,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,1,1,1,5,5,1,1,1,1,5,5,5,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,1,2,1,3,3,3,2,2,2,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,5,1,1,1,5,5,5,5,5,5,5,5,5,5,5,1,1,2,2,2,2,5,5,5,2,2,2,2,2,2,2,3,3,5,5,3,3,2,3,5,5,5,5,5,5,5,5,5,5,5,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,5,5,5,5,1,1,1,1,1,1,6,6,5,5,5,5,6,6,5,1,1,1,1,1,1,1,1,1,1,4,5,5,5,5,1,5,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,1,1,1,5,5,5,5,5,1,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,1,6,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,2,1,1,1,3,3,5,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,5,5,5,5,1,1,1,5,5,5,5,5,5,5,1,1,1,1,2,2,2,2,5,5,5,2,2,2,3,2,3,2,3,3,3,3,3,2,2,2,3,5,5,5,3,2,5,5,5,5,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,5,5,1,1,1,1,1,1,1,1,5,5,5,5,5,6,6,1,1,1,1,1,1,1,1,1,4,4,4,4,5,5,1,5,5,5,1,1,1,1,1,1,1,1,4,4,4,4,4,4,1,4,4,1,1,1,1,1,5,5,5,5,5,5,1,5,1,1,1,1,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,2,0,0,0,1,1,1,3,3,5,5,5,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,5,5,5,5,5,1,1,1,5,5,5,5,5,5,1,1,2,2,2,2,2,5,5,5,2,2,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,6,1,1,1,1,1,1,1,1,1,1,5,5,5,6,6,6,1,1,2,2,1,1,1,1,4,4,4,4,4,4,1,1,5,5,1,1,5,1,1,1,1,1,1,1,1,1,1,4,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,1,1,1,1,1,1,1,2,1,1,4,4,1,1,4,1,4,1,1,1,1,1,1,1,1,1,1,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,2,2,0,2,1,1,1,3,5,5,5,5,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,1,5,5,5,5,5,5,5,5,2,2,2,2,2,1,5,5,2,2,1,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,5,5,5,5,5,5,5,6,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,1,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,1,4,1,1,1,1,1,1,1,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,5,5,5,5,5,2,2,2,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,1,5,5,5,5,5,5,2,5,5,2,2,2,2,2,5,5,5,5,2,2,1,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,1,1,1,1,1,1,1,6,1,1,1,1,1,5,5,5,5,5,5,5,5,1,1,1,1,6,1,1,1,1,1,4,4,4,4,4,4,4,1,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,6,5,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,2,1,1,5,5,5,5,5,5,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,1,2,2,5,5,5,2,2,2,2,5,5,5,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,6,6,1,1,1,1,5,5,5,5,5,5,5,5,5,1,2,1,6,6,6,6,1,1,1,1,4,5,5,5,5,5,1,5,5,5,5,1,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,1,5,5,5,5,6,1,1,1,1,1,1,1,1,1,4,1,4,4,4,4,4,4,4,4,4,4,4,4,1,6,5,5,5,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,1,1,2,2,2,5,5,5,2,2,2,2,5,5,5,5,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,6,6,6,6,1,1,5,5,5,5,5,5,5,5,5,1,1,2,1,1,6,6,6,6,6,1,1,5,5,5,5,5,5,5,5,5,5,5,5,1,1,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,1,1,1,1,5,6,6,6,1,1,1,1,1,1,1,1,1,1,2,4,4,1,4,4,4,1,1,4,4,4,4,5,5,5,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,0,6,6,1,1,5,5,2,2,2,1,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,1,1,1,2,2,2,2,5,2,2,5,5,5,5,5,5,5,5,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,2,1,1,1,1,6,6,1,1,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,6,6,6,6,5,5,5,5,5,5,5,1,5,1,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,1,1,1,6,6,6,6,6,6,2,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,1,1,4,4,4,1,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,2,6,6,6,1,1,1,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,1,1,1,2,2,2,5,5,5,5,5,5,5,5,5,5,5,5,2,2,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,6,6,5,5,5,5,1,1,1,1,1,1,1,1,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,5,1,1,1,1,1,5,5,5,5,1,1,1,6,6,1,6,6,1,1,1,1,1,1,1,1,1,1,1,1,2,1,4,4,4,4,4,4,4,4,1,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,1,2,2,7,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,1,1,1,1,6,1,1,6,5,5,5,1,1,1,1,2,2,5,5,5,5,5,5,5,5,2,5,5,5,5,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,2,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,1,1,1,2,1,1,1,1,1,1,1,1,1,1,6,1,1,1,1,1,1,1,1,5,5,5,1,1,1,1,5,5,5,5,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,1,1,1,5,1,1,5,5,5,1,1,1,1,1,1,1,1,1,1,6,0,6,6,6,6,6,6,1,1,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,1,6,6,6,6,6,6,5,5,5,5,1,1,3,2,3,2,5,5,5,5,5,5,5,5,5,5,5,5,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,5,5,5,1,1,1,1,5,5,5,5,1,1,1,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,1,4,4,1,1,1,1,1,5,1,1,5,5,5,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,7,7,7,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,1,1,6,6,5,5,6,3,3,3,3,3,3,5,5,5,5,5,2,5,2,5,5,5,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,1,1,1,1,1,1,1,2,1,1,1,1,5,5,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,1,6,1,1,1,6,5,5,5,1,1,1,1,1,5,5,5,1,1,1,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,5,5,5,1,1,5,1,1,1,1,1,1,1,1,1,1,1,1,0,1,1,7,7,7,7,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,1,6,1,6,2,1,1,1,1,2,2,6,3,3,3,3,3,3,5,5,5,5,5,3,3,3,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,1,1,1,1,1,2,2,2,1,6,1,1,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,1,6,6,6,5,5,5,1,1,1,1,5,5,5,1,1,6,6,6,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,5,1,1,1,5,1,1,5,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,1,2,2,2,3,3,3,5,3,2,5,5,5,5,5,3,3,3,3,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,1,1,1,2,2,1,6,6,6,1,1,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,1,1,1,6,6,1,5,1,1,1,1,1,5,5,5,1,1,1,6,1,1,1,1,1,1,1,2,2,1,1,1,1,1,1,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,3,5,5,5,2,2,5,2,5,2,2,3,3,3,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,2,2,1,1,1,6,6,6,6,6,1,1,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,1,1,1,1,6,6,6,1,1,1,1,1,1,1,5,1,1,1,1,1,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,1,1,1,1,1,1,1,6,6,1,1,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,2,2,2,2,2,2,2,2,2,2,2,5,5,5,2,2,2,2,2,2,2,2,3,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,1,1,1,2,1,1,1,1,6,6,6,6,6,6,6,6,6,1,6,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,1,1,5,5,5,6,6,6,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,1,1,1,1,1,1,1,6,6,6,6,6,6,5,6,5,1,1,5,5,5,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,2,2,2,2,2,2,2,2,2,2,5,5,5,2,2,2,2,2,2,2,2,2,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,1,2,1,1,1,1,1,1,1,1,6,6,6,1,1,6,1,2,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,4,4,1,1,1,1,4,4,1,4,4,4,6,6,6,6,6,1,5,5,5,5,6,6,6,6,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,1,1,1,1,1,1,1,6,6,6,6,6,6,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,2,2,2,2,2,1,1,2,2,2,2,5,5,5,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,1,1,2,2,1,1,1,1,1,1,1,6,2,6,1,1,1,2,1,6,1,6,6,6,1,1,1,1,4,1,1,1,1,4,4,4,4,1,1,4,4,4,4,4,4,4,4,6,6,6,5,5,5,5,5,1,5,6,6,6,6,1,1,1,1,1,1,1,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,6,1,6,6,6,6,5,6,5,5,5,5,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,6,6,2,1,1,1,6,2,2,2,2,2,2,5,5,1,2,2,2,5,5,5,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,2,1,1,1,1,1,1,1,1,1,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,4,4,4,6,6,4,4,4,4,4,1,1,4,4,4,4,4,4,4,1,1,1,5,5,5,5,5,5,5,5,5,6,6,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,4,4,1,1,1,1,1,1,1,1,1,1,1,1,6,1,6,6,5,5,5,5,1,1,1,1,1,1,1,1,1,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,6,6,6,6,1,1,6,6,6,2,2,2,2,5,5,5,5,2,2,2,5,5,5,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,2,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,1,1,1,1,1,1,1,1,1,4,4,4,6,6,6,6,6,1,4,4,4,1,4,4,4,4,4,6,1,1,1,1,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,5,5,1,1,1,1,1,1,1,1,1,1,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,5,2,2,1,1,1,1,1,6,6,6,6,6,2,6,6,2,2,5,5,5,5,5,5,5,2,2,5,5,5,5,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,2,1,1,1,2,1,1,1,6,1,6,1,1,1,1,1,1,1,1,4,4,4,6,6,6,6,6,6,1,4,4,4,4,4,4,4,6,6,6,1,1,1,1,5,5,5,1,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,1,1,1,1,1,1,1,1,1,2,1,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,5,5,5,2,1,1,1,2,2,1,6,1,6,6,6,6,6,2,5,5,5,5,5,5,5,2,2,5,5,5,5,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,2,2,1,1,1,1,1,1,1,1,5,6,6,6,1,1,1,1,1,1,1,4,4,4,6,6,6,1,6,1,6,4,4,4,4,4,4,4,6,6,6,1,1,1,1,1,1,1,1,1,1,1,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,1,1,1,1,1,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,5,5,5,2,1,1,2,2,2,2,6,1,1,6,6,6,2,2,2,5,5,5,5,1,1,2,2,5,5,5,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,6,6,6,1,1,2,1,2,1,2,1,5,5,5,6,1,1,1,1,1,1,1,1,1,4,6,6,6,1,1,1,6,6,6,4,4,4,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,1,1,1,1,2,2,2,2,2,1,1,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,5,5,5,5,5,1,1,2,2,2,6,6,6,2,1,6,2,2,2,2,2,5,5,5,1,2,2,2,2,5,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,6,6,6,6,6,1,1,2,2,2,1,2,2,5,5,5,1,1,1,1,1,1,1,1,1,6,6,6,6,1,1,1,1,6,4,6,4,4,4,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,1,5,5,5,2,2,2,2,1,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,5,5,5,5,2,1,2,2,2,2,6,2,2,1,1,2,2,2,2,5,5,5,5,5,5,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,6,6,6,6,1,1,2,2,2,1,2,5,5,5,1,1,1,1,1,1,1,1,1,1,1,6,6,1,1,1,1,1,1,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,2,2,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,5,5,5,5,1,1,2,2,2,6,6,6,2,2,2,3,3,3,3,5,5,5,5,5,5,5,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,6,6,6,6,1,1,1,2,5,1,1,2,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,2,5,5,5,5,5,6,1,5,1,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,5,5,5,5,1,1,1,2,2,2,2,6,1,1,2,3,3,3,3,3,5,5,5,5,5,5,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,6,6,6,1,1,1,1,5,5,5,2,2,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,2,1,1,1,1,2,1,1,1,1,1,2,2,2,6,5,2,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,5,5,5,5,1,2,2,2,2,6,6,6,1,1,3,3,3,3,3,3,5,5,5,3,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,6,1,1,6,1,5,5,5,5,2,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,2,2,2,6,6,6,6,6,6,6,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,5,1,1,1,2,2,2,6,6,6,3,3,3,3,3,2,3,3,5,5,5,3,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,6,6,6,5,5,5,5,1,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,2,6,6,6,6,6,6,6,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,5,5,5,1,1,2,6,6,6,6,3,3,3,3,3,3,3,3,3,5,5,5,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,6,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,1,1,1,1,1,1,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,6,6,6,6,6,6,6,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,5,5,5,5,6,6,6,6,5,3,3,3,3,3,3,3,3,5,5,5,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,6,6,6,5,1,5,5,5,5,1,1,1,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,6,6,6,1,6,6,6,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,2,1,1,2,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,5,5,5,6,6,6,6,5,5,5,3,3,2,3,3,3,5,5,5,5,5,2,2,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,5,6,6,6,6,1,5,5,5,5,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,6,1,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,5,2,2,2,2,1,2,1,2,6,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,2,3,3,2,2,2,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,5,5,6,6,6,6,6,2,5,5,5,2,2,2,3,5,5,5,5,5,2,2,2,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,5,5,6,6,6,6,5,5,5,5,5,1,0,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,2,1,6,6,6,1,1,1,1,1,1,2,6,1,1,1,1,1,1,1,1,5,5,1,1,1,2,2,5,5,5,1,1,2,2,2,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,3,3,3,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,5,1,6,6,6,6,2,2,5,2,2,5,5,5,5,5,5,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,5,5,5,6,6,6,5,5,5,5,5,1,1,1,2,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,4,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,6,6,6,1,1,1,2,2,1,5,5,5,5,5,5,5,5,5,5,1,2,1,2,2,2,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,3,3,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,2,2,2,5,5,5,5,5,5,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,5,5,6,6,5,1,1,1,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,6,1,1,1,1,1,1,6,6,6,1,1,1,2,1,1,1,1,5,5,5,5,5,5,5,5,5,1,2,2,2,2,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,3,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,2,2,3,5,5,5,5,2,2,2,1,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,2,1,2,1,6,6,6,5,5,1,1,1,5,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,5,3,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,2,2,2,3,3,5,2,2,1,1,1,1,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,2,2,2,1,5,6,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,1,1,1,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,2,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,1,1,1,1,1,1,1,4,1,1,1,1,1,1,1,1,5,5,5,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,2,2,2,2,1,2,2,2,2,2,2,1,1,1,1,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,2,2,2,2,2,6,2,1,1,6,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,1,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,2,2,2,2,2,2,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,6,1,6,6,1,1,1,4,4,4,1,1,1,1,1,1,1,5,5,5,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,2,2,2,2,2,2,1,1,1,2,2,1,1,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,2,2,2,2,2,6,6,6,2,6,6,6,1,1,1,1,1,1,5,5,1,1,1,1,2,1,2,2,2,2,1,2,1,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,2,2,2,2,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,1,4,4,4,4,4,1,1,1,5,5,5,5,5,5,2,2,2,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,2,2,2,2,2,1,1,1,2,2,2,1,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,2,2,6,2,2,2,6,1,1,1,1,1,1,5,5,5,5,5,5,5,1,1,2,2,2,2,2,1,1,1,4,4,4,4,4,1,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,2,2,2,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,6,6,6,6,1,1,1,4,1,4,1,1,1,5,5,5,5,5,5,3,2,2,2,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,2,2,2,2,2,1,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,5,6,5,2,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,1,1,1,1,2,1,2,1,1,1,4,4,4,1,1,1,4,4,4,4,1,1,1,1,1,1,1,1,1,1,2,2,1,2,1,1,1,2,1,1,1,1,2,5,5,5,5,5,2,2,1,2,1,1,1,1,1,1,1,1,6,6,1,1,1,1,6,6,6,1,1,1,1,1,4,4,4,4,4,1,1,5,5,5,5,5,3,3,3,2,2,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,2,2,2,1,1,2,2,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,2,2,1,1,1,1,1,1,1,1,4,1,1,1,4,4,4,4,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,5,5,5,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,1,1,1,1,1,4,4,1,4,1,1,1,5,5,5,5,1,1,3,1,2,2,1,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,5,1,1,1,1,1,1,1,1,1,2,1,1,1,1,2,2,1,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,6,6,6,2,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,1,1,1,1,1,1,1,1,1,2,1,1,2,2,2,1,1,1,1,2,1,1,2,2,1,1,1,5,5,5,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,4,4,4,1,1,1,1,1,5,5,5,1,5,1,1,1,2,2,1,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,1,1,1,1,2,1,1,1,2,1,1,1,1,2,2,1,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,2,1,2,6,6,6,2,2,1,1,1,1,6,1,1,1,1,6,6,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,2,2,2,1,1,1,1,1,1,1,1,1,1,6,1,1,1,6,1,1,1,1,1,1,1,4,1,1,1,1,1,1,5,5,5,5,5,5,1,1,1,1,2,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,1,1,1,1,1,1,1,1,1,2,2,2,1,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,2,2,2,6,2,2,2,2,2,2,6,6,6,6,6,6,6,6,6,6,5,5,5,2,5,5,5,5,1,1,1,2,1,1,1,1,4,4,4,4,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,5,5,5,2,2,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,4,1,1,1,5,5,5,5,5,5,1,1,1,1,1,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,2,2,2,2,2,2,2,2,2,2,1,6,6,6,6,6,6,6,6,6,6,5,2,5,5,5,5,5,1,1,2,2,2,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,2,2,2,5,2,2,2,1,1,1,1,6,6,6,6,6,6,6,6,6,6,6,6,6,1,1,1,1,4,4,1,1,4,4,4,1,1,5,5,5,5,5,1,2,2,2,2,2,6,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,7,1,1,1,1,1,1,5,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,2,2,2,2,2,2,1,1,1,6,6,6,6,1,2,2,6,6,2,2,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,2,1,1,1,1,1,2,2,2,2,2,2,2,1,1,6,6,6,6,6,6,6,6,6,1,6,6,6,6,1,1,1,4,4,4,4,4,1,1,4,1,5,5,1,5,5,5,5,1,1,1,1,1,1,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,7,7,1,1,1,1,1,5,5,5,1,1,1,1,1,1,1,2,2,1,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,2,2,2,1,2,2,1,1,1,1,6,1,1,2,1,2,1,2,2,2,1,5,5,5,5,5,5,5,5,5,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,2,1,1,1,1,1,1,1,2,2,2,1,1,1,6,6,6,6,6,6,6,6,6,1,1,1,1,1,4,4,1,4,4,4,4,4,1,1,1,1,5,5,5,5,5,5,5,1,1,1,1,1,1,1,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,7,0,2,1,1,1,1,1,5,1,1,1,1,1,1,1,2,2,2,2,2,2,0,7,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,2,2,2,2,2,1,1,1,1,1,1,1,1,1,2,1,1,2,1,1,1,1,1,2,5,5,5,5,5,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,6,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,1,1,1,1,5,5,5,5,5,5,1,2,1,1,1,1,1,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,7,7,7,2,1,1,1,1,1,1,1,1,5,1,1,1,1,1,2,2,2,2,2,2,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,5,5,5,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,2,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,1,1,1,4,1,1,1,5,5,5,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,7,1,1,1,1,1,1,1,1,1,5,5,5,1,1,1,1,2,2,2,2,1,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,2,2,2,2,2,5,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,1,1,1,5,5,1,1,1,2,1,1,1,4,4,4,4,4,4,4,4,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,2,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,5,5,1,1,1,1,2,2,2,2,1,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,2,2,2,2,2,2,2,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,2,1,1,1,1,1,1,1,6,1,1,5,5,5,5,1,1,1,1,4,4,4,4,4,4,1,1,4,4,4,1,1,4,1,1,1,1,1,1,1,1,1,1,1,1,2,1,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,1,1,1,1,1,1,1,1,1,2,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,2,2,1,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,2,1,1,1,2,2,2,1,1,2,1,1,2,2,2,2,1,1,1,2,1,2,2,1,1,1,1,1,6,6,6,1,5,5,5,5,1,1,1,4,4,4,4,4,1,1,1,4,4,4,4,1,1,4,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,1,1,1,1,1,1,2,2,1,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,2,2,2,2,1,2,2,2,2,2,2,1,1,1,2,2,1,1,2,2,2,2,1,1,1,6,2,1,5,5,5,5,1,1,4,4,4,4,4,1,1,1,1,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,2,1,1,1,1,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,2,1,1,2,2,1,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,2,1,1,1,1,1,2,2,1,1,1,1,5,5,5,5,5,1,2,1,4,4,4,1,1,1,1,1,1,4,1,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,2,1,2,1,1,1,2,2,2,2,1,2,2,2,2,2,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,1,1,1,2,2,1,1,1,1,1,2,2,1,2,1,1,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,2,2,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,2,2,1,5,5,3,2,2,2,1,2,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,2,2,1,2,2,2,2,1,1,2,2,2,2,2,1,5,5,2,2,5,2,2,1,1,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,4,4,4,4,1,1,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,1,5,5,1,1,1,1,2,2,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,2,6,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,2,5,5,5,5,3,2,2,2,2,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,2,1,2,2,2,2,2,2,1,2,2,2,2,2,5,5,5,5,5,5,5,2,1,2,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,1,1,1,2,2,2,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,2,6,6,6,6,1,1,1,1,1,6,6,6,2,2,2,1,1,1,2,2,5,5,5,5,5,5,5,5,2,2,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,5,5,5,5,5,5,5,2,2,5,5,5,2,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,1,1,1,2,2,1,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,2,2,2,2,2,2,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,1,1,5,5,5,5,5,5,2,2,2,5,5,5,5,2,2,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,1,1,1,1,2,1,1,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,5,5,2,2,5,5,5,2,2,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,3,5,5,5,6,6,6,2,5,5,5,5,2,2,5,5,5,5,5,5,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,7,1,1,2,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,2,6,6,6,1,1,6,6,6,6,1,1,6,6,6,6,6,6,6,5,5,2,5,5,5,5,2,2,2,2,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,2,2,1,1,2,1,1,3,5,5,5,6,6,6,6,6,6,5,5,2,2,2,2,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,7,7,7,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,2,2,6,1,1,1,1,6,6,1,1,1,6,6,6,2,6,6,5,6,5,5,5,5,5,5,5,3,3,2,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,2,1,1,1,1,6,5,6,6,6,6,6,6,6,6,6,2,2,2,2,2,2,2,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,1,1,7,2,7,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,2,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,2,1,2,1,1,5,6,5,5,2,2,6,6,6,6,6,6,6,5,3,3,3,3,2,2,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,6,6,6,5,6,5,5,5,3,6,6,2,2,2,2,2,2,2,2,1,5,5,5,1,1,1,1,1,1,2,1,1,1,1,5,1,1,1,1,1,5,5,5,1,1,1,1,1,2,1,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,2,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,1,2,5,5,5,5,5,2,5,6,6,6,6,6,6,6,3,3,3,3,2,1,2,1,1,1,1,1,1,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,6,5,1,2,3,3,3,3,3,3,2,2,2,2,1,2,2,2,2,1,2,1,1,1,1,1,1,1,1,1,1,1,5,5,5,1,1,1,5,5,5,5,1,1,1,1,1,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,2,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,5,1,2,2,2,2,1,1,1,1,1,1,1,1,2,2,2,5,5,5,5,5,5,5,6,6,6,6,6,3,3,3,3,3,3,2,2,1,1,1,1,1,1,1,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,6,5,1,1,1,1,3,3,2,3,3,3,3,2,2,1,2,2,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,1,2,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,5,5,1,1,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,5,5,5,2,2,2,2,1,1,1,1,1,1,1,1,2,2,1,1,5,5,5,3,5,5,5,5,2,2,2,1,2,2,3,3,3,3,2,2,6,1,1,1,6,1,1,1,1,1,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,2,2,2,3,3,3,3,2,2,2,2,2,2,1,1,1,2,1,1,1,1,1,2,1,1,5,5,5,5,5,5,5,5,5,1,1,1,1,1,2,2,1,2,2,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,5,5,5,5,2,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,5,5,5,5,2,2,2,2,1,1,1,1,1,1,1,2,2,1,2,5,5,5,3,3,5,5,2,1,1,1,1,2,2,2,3,3,3,2,6,6,6,1,6,6,6,1,1,1,1,1,1,6,6,6,6,6,1,6,1,6,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,2,2,2,3,3,3,3,2,2,2,2,2,2,1,1,1,1,1,1,1,1,2,2,5,5,5,5,5,5,5,5,5,1,2,2,2,1,1,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,2,1,1,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,5,5,5,5,2,2,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,5,5,5,2,2,6,1,1,1,1,1,1,1,2,2,1,2,3,5,5,5,3,2,2,2,2,1,1,1,1,2,2,2,2,3,2,2,1,6,1,1,1,6,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,6,6,1,1,1,1,6,6,6,6,6,1,1,1,1,1,1,2,2,2,3,3,3,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,2,1,1,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,5,5,5,1,1,2,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,5,5,5,5,2,6,6,6,1,1,1,1,1,1,2,2,1,3,3,5,5,5,1,2,2,2,2,1,1,1,1,2,1,1,2,2,2,2,1,1,6,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,1,6,1,6,2,2,1,1,1,6,6,5,6,1,1,1,1,1,1,2,2,2,2,3,3,3,2,1,2,2,2,2,2,2,1,1,1,2,1,1,1,1,2,5,5,5,5,5,5,1,1,1,1,1,1,1,1,2,2,1,2,2,0,0,0,0,0,0,0,0,0,0,0,2,1,2,1,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,5,5,1,2,2,2,1,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,5,5,5,5,6,6,6,6,1,1,1,1,1,2,2,1,2,3,5,5,5,2,2,2,2,1,1,1,1,1,1,1,1,2,2,1,1,1,6,6,6,1,6,1,1,1,1,1,1,1,2,1,1,1,2,1,1,1,1,1,1,1,1,2,1,5,5,5,2,1,1,1,1,1,2,1,1,1,2,3,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,2,1,2,2,0,0,0,0,0,0,0,0,0,0,0,1,1,1,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,1,2,2,2,2,2,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,5,5,5,5,5,6,6,6,1,1,1,1,1,2,2,2,1,5,5,5,5,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,1,1,2,5,5,5,5,1,2,2,2,2,1,1,1,1,1,1,2,1,1,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,5,5,5,1,5,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,0,0,0,0,0,0,0,0,0,0,7,7,1,2,1,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,5,5,1,2,2,2,2,2,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,2,2,5,5,5,5,5,6,1,1,1,1,1,1,1,2,2,1,5,5,5,2,2,2,2,1,1,2,1,1,2,1,1,1,1,1,1,1,1,1,1,1,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,1,1,1,2,1,1,1,1,1,1,2,1,1,2,2,2,2,2,2,1,1,1,1,2,2,2,1,1,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,0,0,0,0,0,0,0,0,0,0,7,1,1,1,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,2,2,2,5,5,5,5,2,2,2,2,2,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,5,5,2,1,5,5,5,1,6,1,1,1,1,1,1,2,2,2,5,5,5,2,2,2,2,2,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,6,6,6,2,1,1,2,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,1,2,2,5,1,1,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,2,2,0,0,0,0,0,0,0,0,0,0,7,7,1,1,1,2,2,2,2,2,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,2,2,2,5,5,5,5,5,2,2,2,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,5,5,5,5,1,5,5,5,6,6,6,1,1,1,1,1,1,2,2,5,5,5,5,2,2,2,2,2,2,2,1,2,2,1,1,1,1,1,1,2,2,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,2,1,1,1,1,1,2,5,5,5,2,2,2,1,1,1,2,5,5,5,1,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,2,1,1,0,0,0,0,0,0,0,0,0,0,7,2,2,2,2,2,2,2,2,2,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,5,5,5,5,5,2,5,5,1,6,1,1,1,1,1,1,1,1,2,5,5,5,5,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,6,1,1,1,1,1,1,1,1,2,2,1,1,1,1,1,2,2,2,5,5,5,5,5,5,5,1,1,1,1,1,1,2,2,1,1,1,2,5,5,5,5,5,2,1,2,2,2,2,5,5,5,1,1,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,2,0,0,0,0,0,0,0,0,0,0,7,2,2,2,2,1,2,2,2,2,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,2,2,5,5,5,5,5,2,2,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,5,5,5,5,5,2,1,1,1,6,1,1,1,1,1,1,1,1,1,1,5,5,5,2,1,2,2,6,2,1,2,2,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,1,1,1,1,2,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,2,1,1,5,5,5,5,5,5,1,1,2,2,1,1,5,5,5,1,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,2,0,0,0,0,0,0,0,0,0,7,2,2,2,2,2,2,2,2,2,2,2,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,6,5,5,5,5,2,2,2,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,5,5,5,5,5,5,1,5,6,6,6,1,1,1,1,1,1,1,1,1,1,5,2,2,1,1,6,6,6,1,2,1,1,1,1,1,1,2,1,1,1,1,1,4,4,1,1,1,1,1,1,1,1,2,2,1,1,1,1,1,1,1,5,5,1,1,1,1,5,5,5,1,1,1,2,1,1,1,1,1,1,5,5,5,5,5,2,1,1,1,2,1,5,5,5,5,1,5,5,5,5,5,5,1,5,1,1,1,1,1,1,1,1,2,1,1,1,2,0,0,0,0,0,0,0,0,0,7,2,1,1,2,3,2,2,2,2,2,2,2,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,6,6,6,6,5,5,2,2,2,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,5,5,5,5,5,5,5,5,6,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,1,1,1,1,1,1,1,2,1,4,4,4,4,4,4,4,1,1,1,1,1,1,1,2,2,2,2,5,1,5,5,5,5,5,1,1,1,1,1,5,1,1,1,1,2,1,1,1,1,1,5,5,5,5,5,2,2,2,2,2,2,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,0,0,0,0,0,0,0,0,0,7,2,1,1,3,3,3,2,2,2,2,2,2,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,6,2,6,6,6,6,5,2,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,5,2,5,5,5,5,6,6,6,5,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,2,2,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,2,2,1,1,1,1,5,5,5,5,5,5,2,2,2,2,1,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,2,0,0,0,0,0,0,0,0,0,7,2,1,1,3,3,3,2,2,2,2,2,2,2,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,6,6,6,5,6,6,6,2,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,1,1,2,2,1,1,1,5,6,6,5,5,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,2,2,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,5,5,5,2,2,5,2,2,2,2,2,2,1,5,1,5,5,5,5,5,5,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,0,0,0,0,0,0,0,0,0,7,2,2,1,3,3,3,3,2,2,2,2,2,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,1,2,2,1,1,1,1,6,6,6,6,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,1,6,6,6,6,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,2,2,2,1,2,2,2,2,2,2,5,5,5,1,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,0,0,0,0,0,0,0,0,0,7,7,2,2,3,3,3,3,3,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,5,1,1,1,2,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,2,2,2,2,1,1,1,6,6,6,6,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,6,6,6,6,6,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,5,5,5,5,2,2,2,1,1,2,2,5,5,5,5,5,5,5,5,5,2,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,0,0,0,0,0,0,0,0,0,7,7,2,2,3,3,3,3,3,2,2,2,2,2,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,2,6,2,6,6,6,5,5,2,2,1,1,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,1,1,1,1,1,1,6,6,6,6,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,1,5,5,5,5,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,5,5,5,5,5,2,2,1,1,1,2,5,5,5,5,5,5,5,5,8,8,8,8,2,5,2,2,1,1,1,1,1,1,1,1,1,1,2,1,1,2,2,0,0,0,0,0,0,0,0,0,7,7,1,1,3,3,3,3,3,3,2,2,2,2,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,2,5,5,5,5,2,2,7,2,1,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,2,2,1,1,1,1,1,1,1,1,1,5,5,2,1,1,2,5,5,5,5,5,5,5,2,1,1,1,1,5,5,5,5,5,5,5,8,8,8,8,8,8,2,5,5,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,0,0,0,0,0,0,0,7,1,1,1,1,3,3,3,3,3,2,2,2,2,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,2,2,7,7,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,2,2,1,1,1,1,1,6,1,1,1,1,1,1,2,2,2,1,1,5,1,1,1,1,5,5,4,4,5,4,1,6,6,6,6,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,2,2,2,2,1,1,1,1,1,5,5,5,5,2,2,1,5,5,5,5,5,5,1,2,1,1,1,5,5,5,5,5,5,5,8,8,8,8,8,8,8,8,5,5,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,0,0,0,0,0,0,7,1,1,1,3,3,3,3,3,5,2,2,2,2,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,5,2,2,2,2,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,2,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,5,5,5,5,2,5,5,5,5,5,5,5,2,6,6,6,2,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,2,2,1,2,2,2,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,2,2,1,1,5,5,5,5,5,5,5,1,8,8,8,8,8,8,8,8,5,5,1,1,1,1,1,1,1,1,1,2,1,1,2,2,2,2,2,7,7,7,0,0,0,0,7,1,1,1,1,3,3,3,5,5,5,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,7,7,1,1,1,1,1,1,1,1,2,2,2,2,2,1,1,1,1,2,2,2,2,1,1,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,5,5,5,5,5,5,2,5,5,5,5,5,2,2,2,6,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,5,5,5,5,5,5,5,5,5,1,1,2,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,1,1,1,5,1,5,5,5,5,5,5,5,8,8,8,8,8,8,8,8,8,5,5,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,7,7,7,0,7,7,7,1,1,1,1,5,5,3,5,5,5,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,1,1,1,1,2,2,2,2,2,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,6,6,1,1,1,1,1,1,2,2,2,2,5,5,5,5,5,5,5,2,5,5,5,5,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,2,1,1,1,1,1,2,2,1,1,5,5,5,1,1,5,5,5,5,2,2,1,1,1,1,1,5,1,5,5,5,5,2,5,2,2,2,1,5,5,5,5,5,5,5,5,5,8,8,8,8,8,8,8,8,8,8,5,5,1,1,1,1,1,1,1,1,1,2,1,1,1,2,2,2,2,2,1,1,1,7,7,7,7,1,1,1,5,5,5,5,5,5,5,2,2,2,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,2,2,2,2,2,2,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,6,6,6,6,6,6,1,1,2,2,2,2,2,5,5,5,5,5,5,2,3,5,5,5,5,2,2,2,2,2,2,2,2,2,1,1,1,1,2,2,1,1,1,1,1,1,2,2,1,1,1,1,2,2,1,2,2,5,5,5,5,2,1,1,1,1,1,1,1,5,5,5,1,2,2,1,1,1,1,5,5,5,5,5,5,5,5,5,8,8,8,8,8,8,8,8,8,8,5,5,1,1,1,1,1,1,1,1,2,2,1,1,1,2,2,2,2,2,1,1,1,0,1,1,1,1,1,2,5,5,5,3,2,5,3,3,2,2,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,6,6,6,6,6,6,6,1,2,2,2,2,2,5,5,5,5,5,2,3,5,5,5,5,5,3,3,2,2,2,2,2,2,2,2,1,1,1,1,2,1,1,1,1,1,2,1,1,2,1,1,1,2,2,2,2,5,5,5,5,5,1,1,1,1,1,1,1,2,5,5,5,2,2,2,1,1,1,1,5,5,5,5,5,5,5,5,5,8,8,8,8,8,8,8,8,8,8,5,5,1,1,1,1,1,1,1,2,2,2,2,1,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,5,5,5,5,3,5,5,5,3,3,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,6,6,6,6,6,6,6,6,2,2,2,2,2,2,5,5,5,5,5,5,5,5,5,5,3,3,3,3,1,2,2,2,2,2,2,1,1,1,1,2,1,1,1,1,1,2,1,1,2,1,1,1,1,2,2,2,1,5,5,5,1,1,1,1,1,1,1,1,1,1,5,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,8,8,8,8,8,8,8,8,8,8,5,5,1,1,1,1,1,1,1,2,2,2,2,1,1,1,2,2,2,1,1,1,1,1,1,2,2,2,1,5,5,5,3,3,5,5,5,3,3,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,1,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,6,6,6,6,6,1,1,6,6,6,2,2,2,2,1,2,2,5,5,5,5,5,5,5,3,2,3,3,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,2,1,1,1,2,2,2,1,1,1,1,2,1,2,1,5,5,5,1,1,1,1,2,1,1,1,1,1,1,1,1,1,2,1,1,5,5,5,5,5,5,5,5,2,5,8,8,8,8,8,8,8,8,8,8,8,5,5,1,1,1,1,1,1,1,2,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,2,2,2,2,5,5,3,3,3,5,3,3,2,2,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,2,2,2,2,2,2,2,2,2,2,2,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,6,6,6,6,1,1,6,6,6,6,2,2,2,1,1,1,1,2,1,5,5,5,2,2,2,2,2,2,2,2,2,2,2,2,2,1,2,1,1,2,1,1,1,2,2,1,1,2,1,1,2,1,1,1,1,1,1,1,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,5,5,5,1,1,1,1,5,5,8,8,8,8,8,8,8,8,8,8,8,5,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,3,3,5,5,5,5,3,2,2,5,1,2,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,1,1,1,1,2,2,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,1,1,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,6,1,2,1,1,1,6,6,2,1,2,1,1,1,1,1,1,1,1,5,2,1,2,2,1,1,1,2,2,2,2,2,2,2,1,2,1,1,2,1,1,2,1,2,1,2,1,2,1,2,1,5,1,1,1,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,2,2,2,1,1,1,1,1,1,5,5,8,8,8,8,8,8,8,8,8,8,8,5,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,2,1,1,1,1,1,2,2,1,1,3,3,3,5,5,5,5,5,5,5,5,5,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,7,7,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,1,1,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,2,2,2,1,1,1,2,2,2,2,1,1,6,6,6,6,6,6,6,1,1,2,2,1,1,1,1,1,2,2,2,2,2,2,2,1,1,2,1,1,2,1,1,1,2,2,2,2,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,5,1,1,1,1,1,2,1,5,5,8,8,8,8,8,8,8,8,8,8,8,1,5,1,1,1,1,1,2,1,1,5,5,2,2,2,2,1,2,1,2,1,1,1,2,2,1,1,1,3,3,3,5,5,5,5,5,5,5,5,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,7,7,1,1,1,1,1,2,2,1,1,1,1,1,5,1,1,1,1,1,1,2,2,2,1,1,2,2,2,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,2,2,2,2,1,1,1,1,1,2,1,1,6,6,6,6,6,6,6,6,6,1,1,2,1,1,1,1,1,1,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,2,2,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,1,1,1,1,1,1,5,1,8,8,8,8,8,8,8,8,8,8,1,5,5,1,1,1,1,1,1,1,5,5,5,5,2,2,2,2,2,2,2,2,1,2,1,1,1,1,1,1,1,1,1,2,2,5,5,5,5,5,5,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,1,1,1,1,1,1,2,1,1,1,1,5,5,5,5,1,1,1,1,2,2,2,2,1,1,2,2,2,2,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,1,1,2,2,2,2,2,2,2,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,5,1,1,5,5,5,1,1,1,1,2,2,5,5,8,8,8,8,8,8,8,8,8,8,8,5,5,5,2,2,1,1,1,1,1,5,5,5,5,1,1,2,1,1,1,2,2,1,2,1,1,1,2,2,1,1,1,1,1,1,2,2,5,5,5,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,7,1,1,1,1,1,1,1,1,5,1,1,5,5,5,5,1,1,1,2,2,2,2,2,1,1,1,2,2,2,2,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,2,1,1,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,2,1,1,2,2,2,2,2,1,2,2,2,2,2,2,2,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,1,5,5,5,2,2,2,2,2,2,5,5,8,8,8,8,8,8,8,8,8,8,1,5,5,1,1,1,1,1,1,1,1,1,5,5,5,5,1,1,1,1,1,2,2,2,2,1,1,1,2,2,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,1,1,2,2,2,1,1,1,1,1,5,5,2,2,2,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,2,1,1,2,2,1,1,2,2,2,2,2,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,2,2,2,2,2,5,2,5,8,8,8,8,8,8,8,8,8,8,1,5,1,1,1,2,1,1,1,2,1,1,5,5,5,5,5,1,1,1,1,2,2,2,1,1,1,1,1,1,2,1,1,2,1,1,2,1,1,1,2,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,2,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,1,2,1,2,2,2,1,1,1,1,5,5,5,5,2,2,2,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,2,1,1,1,1,1,2,2,2,1,1,1,1,2,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,2,2,2,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,2,2,1,2,5,5,5,8,8,8,8,8,8,8,8,8,1,5,5,1,2,1,1,2,1,1,2,5,5,5,5,5,5,5,1,1,2,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,1,1,2,2,1,2,2,1,1,1,2,5,5,5,2,2,2,2,2,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,2,2,2,1,1,1,1,1,2,1,1,1,1,2,2,1,1,4,1,1,1,1,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,2,2,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,2,2,2,2,2,1,1,1,1,1,5,5,5,5,5,5,5,5,2,2,2,2,5,5,2,8,8,8,8,8,8,8,8,8,1,5,2,1,2,2,1,2,1,1,5,5,5,5,5,5,5,5,1,1,2,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,1,1,1,2,2,2,2,2,1,1,5,5,5,5,5,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,2,2,2,1,2,1,2,2,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,2,5,5,5,5,5,2,5,5,2,5,2,2,1,1,1,1,1,1,2,2,2,2,5,1,1,1,5,1,1,5,5,5,5,5,5,5,2,2,2,2,2,2,5,5,8,8,8,8,8,8,8,8,8,5,5,1,1,2,2,1,2,2,2,5,5,5,5,5,5,5,1,2,1,1,1,2,2,2,2,1,1,2,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,0,1,1,1,1,1,2,2,2,2,5,5,5,5,5,5,1,1,1,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,5,5,5,5,5,5,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,2,5,5,5,1,5,5,5,1,1,5,1,1,5,5,2,2,2,2,2,2,1,2,5,1,8,8,8,8,8,8,8,8,5,1,1,1,1,1,2,2,2,5,5,5,5,5,1,1,1,2,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,2,2,1,2,2,2,2,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,1,1,1,1,6,5,2,2,2,2,5,5,5,5,1,1,1,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,2,1,2,2,1,1,1,1,1,1,1,1,4,4,4,4,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,5,5,2,5,5,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,5,5,5,5,5,5,5,1,1,1,1,1,1,1,2,2,2,2,2,1,1,2,2,5,5,8,8,8,8,8,8,8,2,5,1,1,2,1,1,1,1,1,5,5,5,5,1,1,1,2,2,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,2,2,2,1,2,2,2,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,2,1,1,6,6,6,5,1,1,5,5,5,5,3,3,1,1,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,2,2,2,1,1,1,1,1,4,4,1,4,4,4,4,4,1,2,2,2,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,5,5,5,5,2,2,2,2,1,2,2,2,2,2,2,2,2,1,5,5,1,5,1,5,5,5,5,5,5,1,1,1,1,2,2,1,1,2,2,2,2,2,2,2,2,2,2,5,5,2,8,8,8,8,8,5,5,1,1,1,1,1,1,1,1,5,5,5,1,1,1,1,2,1,1,1,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,2,2,2,2,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,1,2,2,1,6,6,6,5,2,3,5,5,5,3,3,3,3,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,2,2,2,1,1,1,1,1,1,4,4,4,4,4,4,4,4,1,1,1,1,1,2,2,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,5,5,5,5,1,1,2,2,1,1,1,1,1,2,2,1,2,2,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,2,1,1,2,1,1,1,2,2,2,2,2,2,2,2,1,5,5,8,8,5,5,5,5,1,1,1,1,2,1,1,1,1,5,1,1,2,1,1,2,1,1,1,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,1,1,1,1,1,2,1,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,1,1,2,2,2,2,6,6,6,6,5,3,5,5,5,3,3,3,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,2,2,2,2,1,1,1,1,4,4,4,4,4,4,4,4,4,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,5,5,5,5,1,1,1,2,1,1,1,1,1,1,1,1,2,2,2,2,5,5,5,5,1,1,5,1,5,5,5,5,5,5,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,1,1,5,5,5,5,5,5,1,1,1,1,2,2,1,1,1,1,1,1,1,2,1,1,2,1,1,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,1,1,1,1,1,1,1,1,1,2,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,2,2,2,6,6,6,6,6,3,5,5,5,3,3,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,2,2,1,1,1,1,1,1,4,4,4,1,4,4,4,1,1,1,1,2,2,1,1,1,1,1,1,1,1,1,1,1,5,2,1,1,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,2,2,5,1,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,2,2,2,2,2,2,2,2,1,1,1,1,1,1,5,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,2,2,2,1,1,1,1,1,1,1,2,0,0,0,0,0,0,0,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,2,2,6,6,6,6,6,6,5,5,5,3,5,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,2,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,2,1,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,2,2,2,2,2,2,2,1,1,1,2,1,1,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,2,1,0,0,0,0,0,0,2,1,1,1,1,1,1,1,1,1,4,4,2,1,1,1,1,1,1,1,6,6,6,6,6,5,5,5,5,5,5,5,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,1,1,1,1,2,1,1,1,1,1,1,1,1,2,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,1,5,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,1,1,1,1,1,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,2,0,0,0,0,0,7,1,1,1,1,1,1,1,1,4,4,4,4,2,1,1,1,1,1,2,6,6,6,6,5,5,5,5,5,5,5,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,1,1,1,2,2,1,1,1,1,1,1,1,2,2,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,1,1,5,1,1,1,1,1,2,2,2,2,5,2,2,2,2,2,2,2,1,1,1,1,1,1,5,5,5,5,1,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,7,7,1,1,1,1,1,1,1,1,1,4,4,2,1,1,1,1,2,2,1,5,6,5,5,5,5,5,5,5,5,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,1,1,1,1,2,1,1,1,1,1,1,2,2,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,1,1,1,1,1,1,1,1,1,1,2,2,2,5,5,5,2,2,2,2,2,2,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,0,0,7,0,1,1,1,1,1,1,1,1,4,4,4,4,1,1,1,1,1,2,2,5,6,5,1,5,5,5,5,5,5,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,1,1,1,1,2,2,1,1,1,1,1,2,2,2,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,5,5,5,5,5,5,2,2,2,2,2,2,2,1,2,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,4,4,1,1,1,1,1,2,1,1,1,1,1,1,1,2,1,1,1,1,1,2,2,1,1,7,1,1,1,1,1,1,1,1,1,4,4,4,4,4,1,1,1,1,2,2,6,6,6,5,5,5,5,5,5,5,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,4,4,4,4,4,4,4,4,1,1,1,1,2,2,2,1,1,1,1,2,2,2,5,5,5,5,1,5,1,5,1,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,2,2,2,2,2,1,1,1,5,5,5,5,5,5,1,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,1,1,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,2,7,7,7,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,1,1,2,1,6,6,6,6,5,5,5,5,2,5,5,1,1,2,2,2,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,4,2,2,4,4,4,1,1,1,1,1,1,2,2,1,1,1,1,2,2,2,1,5,5,1,5,5,5,5,5,5,5,5,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,5,5,5,5,5,5,5,5,2,2,1,1,1,1,1,5,5,5,5,5,1,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,2,1,7,7,0,7,7,7,2,1,1,1,1,1,1,1,1,4,4,4,4,4,1,2,2,6,6,6,6,5,5,5,5,5,5,5,5,1,1,1,2,2,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,1,1,1,1,1,1,1,5,1,5,1,5,5,1,1,1,1,1,2,2,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,3,3,5,5,5,5,2,2,2,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,2,7,7,0,0,0,0,7,7,1,1,1,1,1,1,1,1,4,4,4,4,4,4,1,2,6,6,6,5,5,5,5,5,5,5,5,5,1,1,2,2,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,2,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,1,1,2,1,1,1,1,1,1,1,1,1,1,1,2,2,5,5,5,3,5,5,5,5,2,2,2,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,0,0,0,0,0,0,7,1,1,1,1,1,1,1,1,4,4,4,4,4,1,1,1,2,6,2,2,5,5,5,5,5,5,5,2,1,2,2,2,2,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,2,1,1,1,2,2,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,5,5,5,5,5,5,2,2,2,2,2,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,0,0,0,0,0,0,7,7,1,1,1,1,1,1,1,4,4,4,1,1,2,2,1,6,6,6,3,5,5,5,5,5,1,2,5,2,2,2,1,2,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,1,1,1,2,2,1,1,1,1,1,1,1,1,1,1,2,2,2,5,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,2,2,5,5,5,5,5,2,2,2,2,2,5,5,5,5,5,5,5,1,5,5,1,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,0,0,0,0,0,0,0,7,1,1,1,1,1,1,1,4,4,4,1,1,1,2,2,1,6,2,5,5,5,5,3,3,1,5,5,5,2,1,2,2,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,5,5,5,2,2,1,2,2,2,1,1,2,1,2,1,1,1,1,1,1,2,1,5,5,5,3,2,2,2,2,2,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,0,0,0,0,0,0,0,2,1,1,1,1,1,1,4,4,4,4,4,1,1,1,1,1,6,5,5,5,5,5,3,3,2,2,5,2,2,2,2,2,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,1,1,1,1,1,1,1,1,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,5,5,5,2,2,2,2,2,2,1,1,2,2,1,1,1,1,1,1,1,2,3,3,3,3,3,2,2,2,1,1,1,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,2,2,0,0,0,0,0,0,1,1,1,1,1,1,2,1,4,4,4,1,1,1,1,1,6,6,6,5,5,5,5,3,3,3,5,5,5,2,2,2,2,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,5,5,1,1,1,1,1,1,1,1,1,1,1,1,5,1,5,5,5,5,1,5,5,5,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,1,1,1,1,1,1,1,1,1,2,2,2,5,5,5,5,5,2,2,2,2,1,2,2,1,1,1,1,6,1,1,1,2,3,3,3,3,2,2,2,2,2,2,1,1,1,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,2,2,1,2,1,2,2,0,0,0,0,0,0,1,1,1,1,1,1,2,2,2,2,2,1,1,1,1,1,1,6,1,5,5,5,5,3,3,3,2,5,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,5,5,5,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,1,1,1,1,1,1,1,2,5,2,2,2,5,5,5,5,5,2,2,2,2,2,2,1,1,1,6,6,6,1,1,1,2,3,3,3,2,2,2,2,2,1,1,1,1,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,2,1,2,0,0,0,0,0,0,2,2,1,1,1,1,1,2,2,2,2,1,2,1,1,1,6,6,6,5,5,5,5,3,3,3,5,5,5,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,5,5,5,5,1,5,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,5,5,5,2,2,5,2,5,5,2,2,2,2,2,1,2,1,1,1,1,6,6,6,6,1,1,2,3,2,2,2,2,2,2,1,1,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,4,4,4,4,4,4,4,4,1,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,2,1,1,1,2,2,2,2,2,2,2,2,2,1,1,1,1,6,5,5,5,5,5,3,3,3,5,5,5,1,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,5,5,5,5,5,5,5,5,2,2,2,2,2,2,2,1,1,1,1,1,1,1,6,6,6,6,1,2,2,2,2,2,2,2,2,5,5,5,5,5,5,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,6,6,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,2,1,2,1,2,2,1,2,2,2,2,2,2,2,2,1,6,6,6,5,2,5,5,5,3,5,5,5,5,1,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,5,5,5,5,5,5,5,1,1,1,1,1,1,5,1,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,2,5,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,6,1,2,6,2,2,2,2,2,2,5,5,5,5,5,1,1,2,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,6,6,6,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,1,0,0,0,0,0,0,1,1,1,1,1,1,1,2,2,2,2,2,2,2,1,1,1,6,5,5,5,5,5,5,5,5,5,5,1,2,2,2,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,5,5,5,5,5,5,5,1,1,1,1,1,5,5,5,1,5,5,5,5,5,5,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,2,5,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,2,2,2,2,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,1,4,4,6,4,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,5,5,5,5,5,5,5,5,1,1,1,1,1,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,5,5,5,2,5,5,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,6,5,2,6,2,1,2,5,1,1,1,6,1,2,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,4,1,1,4,4,4,6,6,6,4,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,7,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,1,1,1,1,1,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,5,5,5,5,5,5,5,1,1,1,1,1,5,5,5,5,5,5,5,5,5,6,6,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,1,1,1,1,1,5,5,5,5,1,1,5,5,5,5,5,2,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,2,5,5,5,6,6,6,2,2,1,1,1,6,6,6,2,2,1,1,1,2,5,5,1,1,1,2,1,1,1,1,1,1,5,1,1,1,1,4,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,7,7,1,0,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,5,5,5,5,5,5,3,3,1,1,1,1,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,5,5,1,1,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,5,5,5,1,1,1,1,5,5,5,5,5,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,2,2,5,2,2,6,2,2,2,1,1,2,6,6,6,2,1,1,1,1,5,5,5,5,1,1,2,1,1,1,1,5,5,5,5,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,1,2,1,7,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,5,5,3,3,3,3,3,1,1,1,1,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,5,5,5,5,5,5,5,2,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,2,2,2,2,2,1,1,1,1,1,1,5,1,1,1,1,1,1,2,5,5,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,2,2,2,2,1,2,6,6,6,6,6,6,1,1,1,5,5,5,5,5,5,1,2,2,1,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,2,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,1,2,1,7,1,1,1,1,1,1,2,2,1,1,1,1,1,1,1,1,1,1,1,2,2,3,3,3,3,3,3,3,3,1,1,1,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,2,5,5,5,5,5,2,2,2,1,2,2,1,1,1,1,1,1,1,1,6,6,6,6,6,6,1,1,1,1,1,2,1,1,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,2,1,1,1,2,2,1,1,1,1,1,1,1,1,2,2,5,5,5,2,2,2,2,2,6,6,6,6,6,6,6,1,1,1,1,5,2,5,5,5,5,5,2,5,5,5,5,5,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,5,1,1,1,1,5,5,2,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,1,1,1,2,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,2,2,3,3,3,3,3,3,2,2,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,2,2,5,5,5,5,2,2,2,2,2,2,2,1,1,1,1,1,1,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,1,1,1,2,2,2,2,1,1,1,2,1,1,1,2,2,2,5,5,5,2,3,2,2,2,6,6,6,6,6,6,1,1,1,1,2,2,2,2,5,5,5,5,5,5,5,5,1,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,2,2,2,1,2,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,7,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,3,3,2,2,2,2,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,1,5,1,6,2,2,2,2,1,1,1,1,1,1,1,1,1,6,6,6,1,6,1,1,1,1,1,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,2,2,1,1,1,1,2,2,2,2,1,5,5,5,5,3,3,3,3,2,2,2,2,2,6,2,1,1,1,1,2,2,2,1,2,5,5,5,5,5,5,5,1,1,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,2,2,1,1,1,2,1,1,1,1,2,2,2,2,2,2,2,2,2,1,1,1,1,7,7,7,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,1,1,1,1,6,6,6,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,1,2,2,2,1,1,1,2,2,2,2,1,3,5,5,5,5,3,3,3,3,2,2,2,2,2,2,1,2,1,1,1,1,1,1,2,2,1,2,5,5,5,5,5,5,5,1,5,5,5,5,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,2,2,1,1,1,1,1,1,2,1,1,2,2,2,2,2,2,2,1,1,1,1,1,1,7,1,0,1,1,1,1,2,2,1,2,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,1,1,1,6,6,6,6,6,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,2,2,2,2,1,3,3,5,5,5,5,2,3,2,2,2,1,1,2,2,1,1,1,1,1,1,1,2,2,2,2,2,1,1,1,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,2,2,1,1,1,2,2,1,1,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,7,0,0,0,7,1,1,2,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,1,2,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,1,1,1,6,6,1,6,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,2,2,2,2,2,2,3,3,3,5,5,5,2,2,1,1,1,2,2,1,1,1,1,1,1,1,1,1,2,2,1,2,2,1,1,1,1,5,5,5,5,5,5,5,5,1,2,2,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,2,1,1,2,2,3,3,3,3,2,2,2,1,1,1,1,1,1,7,0,0,0,7,7,1,1,2,2,2,1,5,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,1,6,6,6,6,6,1,1,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,3,5,5,5,5,1,1,1,1,2,1,1,1,1,1,1,1,2,2,2,1,1,2,2,2,1,1,1,1,1,1,5,1,5,5,5,1,1,2,2,2,2,1,1,2,2,1,1,2,1,1,1,1,1,1,1,2,2,2,1,1,3,3,3,3,3,3,3,2,2,2,1,1,1,2,1,7,0,0,0,7,7,1,1,1,1,2,5,5,5,1,1,1,1,1,1,1,1,1,1,1,2,2,1,2,2,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,1,6,6,6,6,6,5,1,1,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,2,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,6,1,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,2,2,2,2,2,5,5,1,1,2,1,1,2,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,2,2,1,1,1,1,2,1,1,1,1,1,1,2,2,1,1,3,3,3,3,3,3,3,3,3,2,2,1,1,1,1,7,7,0,0,0,7,7,1,1,1,1,2,5,5,5,5,1,1,1,1,1,1,1,1,1,1,2,2,1,1,2,2,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,6,6,6,6,6,5,5,5,1,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,2,1,1,1,1,2,2,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,2,2,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,1,1,2,2,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,2,1,3,3,3,3,3,2,3,3,2,2,2,2,1,1,1,1,0,0,0,0,7,7,1,1,1,1,1,2,5,5,5,5,1,1,1,1,1,1,1,1,1,2,2,1,1,1,1,1,1,2,2,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,1,6,6,6,6,1,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,1,2,2,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,1,1,1,2,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,2,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,2,5,5,3,2,2,2,2,2,2,2,2,2,2,1,1,1,1,2,0,0,0,7,7,1,1,1,1,1,5,2,5,5,5,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,6,6,1,1,1,5,5,1,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,2,2,1,1,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,2,2,2,2,2,2,2,2,2,2,1,1,1,1,2,2,2,1,7,1,1,1,1,5,5,5,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,2,2,1,1,1,1,1,1,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,6,1,1,1,1,6,1,1,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,2,2,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,2,2,2,2,2,1,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,2,2,1,1,1,1,1,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,6,2,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,2,2,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,2,1,1,2,2,2,1,5,5,5,5,3,2,2,2,2,2,1,2,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,2,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,2,1,1,1,1,1,1,4,1,1,1,1,1,1,6,6,6,6,1,1,1,1,6,6,6,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,1,2,2,2,2,1,1,1,1,1,1,2,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,1,1,1,2,1,1,1,2,1,2,1,1,1,2,5,5,3,3,3,2,2,2,2,1,1,1,2,1,2,2,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,6,1,6,1,1,1,1,1,1,1,1,2,2,1,1,1,1,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,2,2,2,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,2,2,1,1,1,1,1,4,4,4,1,1,1,1,1,1,6,6,1,1,1,1,1,1,6,2,1,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,2,2,2,1,1,1,1,1,1,1,1,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,1,2,2,1,1,2,2,1,1,2,2,2,5,5,5,5,3,2,2,2,2,2,2,2,2,1,2,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,6,6,6,6,6,1,1,1,1,1,1,1,2,1,1,1,1,1,2,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,2,2,1,5,5,5,5,5,5,1,1,1,1,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,2,1,1,1,1,1,1,2,2,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,5,5,5,5,1,1,1,1,1,2,1,2,1,1,1,1,1,1,2,2,1,1,1,2,1,1,1,2,1,2,2,2,2,1,3,5,5,5,5,5,2,2,2,2,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,6,6,6,6,1,1,5,1,1,1,1,1,2,1,1,1,1,1,1,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,2,1,1,1,5,5,5,5,1,1,1,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,4,4,4,4,1,1,1,1,1,1,1,2,1,1,5,2,2,2,2,2,1,6,6,6,6,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,5,5,5,5,5,5,5,1,2,1,1,1,2,1,1,1,1,1,2,2,1,1,1,2,2,2,1,1,1,1,1,2,2,1,1,5,3,5,5,5,5,5,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,6,6,6,5,1,5,5,5,1,1,1,1,1,1,1,1,1,2,1,1,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,1,1,1,1,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,5,5,5,5,5,5,5,5,2,1,1,1,1,1,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,2,1,1,1,2,1,1,1,1,2,1,1,1,1,1,2,2,2,2,2,1,1,1,2,2,1,5,5,5,3,5,5,5,5,5,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,1,5,6,6,1,5,5,5,5,1,1,1,1,1,1,1,1,1,2,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,5,5,5,1,1,5,5,5,5,1,1,1,1,2,2,1,1,1,1,1,1,1,1,2,2,2,2,2,2,1,1,1,1,1,1,5,5,5,5,5,3,5,5,5,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,1,6,6,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,1,1,1,1,1,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,5,5,5,1,5,5,5,5,5,2,1,1,1,1,1,2,1,1,2,1,1,1,1,1,2,2,2,2,2,1,1,1,1,1,1,1,5,5,5,5,5,5,2,5,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,2,1,1,6,6,5,5,5,5,5,1,1,1,1,1,1,1,2,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,1,1,1,1,1,1,5,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,2,1,1,1,1,1,1,1,5,5,5,2,5,5,5,5,5,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,2,2,1,6,6,6,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,1,1,6,1,4,4,1,4,1,1,1,1,1,1,4,4,4,4,1,1,1,1,1,1,1,1,2,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,2,1,1,1,2,2,2,2,2,1,1,2,1,1,1,1,1,1,1,1,1,5,2,2,5,5,5,5,5,5,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,2,2,1,1,6,6,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,1,6,6,6,4,4,4,4,4,1,1,1,4,4,4,4,4,1,1,1,1,1,2,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,2,1,1,1,2,2,1,2,2,2,2,2,2,1,1,1,1,1,1,5,5,5,2,2,5,5,5,5,5,2,2,2,2,2,2,1,1,1,1,1,1,1,2,1,1,1,1,1,5,5,1,2,2,1,1,6,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,1,6,6,6,4,6,1,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,1,2,2,1,5,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,5,1,5,1,1,1,1,1,5,5,2,1,3,3,5,5,2,2,2,2,2,2,2,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,2,2,1,1,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,1,1,4,6,6,6,6,6,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,1,1,5,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,5,5,5,1,1,2,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,2,2,2,5,5,5,5,5,5,1,1,1,5,5,5,3,3,3,2,2,2,2,2,2,2,2,2,1,1,2,1,1,2,2,1,1,1,1,1,2,2,1,1,2,2,1,1,5,5,5,5,1,5,5,5,1,1,1,1,1,1,1,1,1,1,1,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,4,6,6,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,1,1,1,6,6,6,6,6,6,6,1,4,4,4,4,4,4,6,1,1,6,6,1,1,1,1,1,1,1,1,1,1,2,5,5,1,5,5,5,5,1,5,5,5,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,5,1,1,1,2,1,1,1,1,5,5,1,2,2,2,1,2,1,1,1,1,1,1,1,5,1,5,5,5,5,1,5,5,5,5,3,3,3,2,2,2,2,2,2,2,2,2,2,1,2,2,2,2,2,1,1,1,1,1,1,2,2,1,2,1,1,1,5,5,5,5,1,1,5,5,1,1,1,2,1,1,1,1,1,1,1,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,4,6,6,6,6,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,1,1,1,1,6,6,6,6,6,6,6,1,4,4,4,1,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,1,1,5,5,5,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,5,5,5,5,2,2,1,1,1,1,1,1,1,1,1,1,2,2,2,5,5,5,5,5,5,5,5,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,1,2,2,1,1,1,1,1,1,1,2,2,1,1,1,1,5,5,5,1,1,1,5,5,5,1,1,1,1,1,1,1,5,1,1,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,4,4,6,6,6,6,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,1,1,1,1,6,2,6,6,6,6,1,6,1,4,1,1,1,6,6,6,6,6,6,6,6,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,1,1,1,1,1,1,1,1,1,1,5,5,5,2,2,2,1,1,1,1,1,1,1,1,1,2,2,2,1,5,5,5,5,1,5,3,3,3,3,2,2,2,2,2,2,2,2,2,1,2,7,7,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,2,1,1,1,1,5,1,1,1,1,1,1,1,5,5,5,1,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,6,4,4,6,6,1,1,1,1,1,1,1,1,1,5,5,1,1,5,1,1,1,1,6,6,6,6,6,6,6,6,6,6,0,6,6,1,6,6,6,1,1,1,6,6,6,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,1,1,1,1,1,1,2,2,2,1,5,5,5,2,2,1,1,1,1,1,1,1,1,1,2,2,2,1,1,5,5,1,1,2,3,3,3,3,3,2,2,2,2,2,2,2,2,1,2,7,7,1,2,1,1,2,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,1,1,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,6,6,6,4,6,6,6,1,1,1,1,1,1,4,1,1,1,1,1,1,1,1,1,1,6,6,6,1,6,6,1,1,6,6,6,6,6,6,6,6,6,1,1,1,6,6,6,1,1,2,2,1,1,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,1,1,1,1,1,1,1,2,2,2,1,1,5,5,2,2,2,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,3,3,3,3,2,2,2,2,2,2,2,2,1,2,7,7,7,2,2,2,2,2,1,1,1,4,4,4,1,1,1,4,4,6,6,6,1,1,1,1,1,1,1,5,1,1,5,5,5,1,1,1,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,6,6,6,4,4,6,6,6,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,6,6,6,6,1,1,6,1,1,1,6,6,6,6,1,1,1,2,1,2,1,1,1,1,1,1,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,1,5,1,1,1,1,1,1,1,1,1,2,2,1,1,1,5,5,5,2,2,2,1,1,1,1,1,2,1,1,2,1,1,1,1,1,1,1,1,2,3,3,3,3,2,2,2,2,2,2,2,1,1,1,7,7,7,1,1,2,2,2,1,1,4,4,4,4,4,1,4,4,4,6,6,6,6,1,1,1,1,1,5,5,5,5,5,5,5,1,2,2,2,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,4,6,6,6,6,6,6,6,6,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,6,1,1,1,1,1,1,1,1,1,6,6,1,1,1,1,1,1,2,2,1,1,1,1,1,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,2,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,5,5,5,1,1,1,1,1,1,1,1,2,2,2,1,1,1,5,1,2,2,2,2,1,1,1,1,1,1,1,1,2,2,1,1,1,1,1,1,2,3,3,3,3,2,2,2,2,2,2,2,1,1,2,7,7,7,1,2,1,1,2,1,1,4,4,4,4,4,4,1,4,4,4,6,6,6,1,1,5,5,5,5,5,5,5,5,5,5,5,2,2,2,0,0,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,4,4,6,6,6,6,6,6,6,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,1,5,1,1,1,1,1,1,1,1,1,1,2,2,1,1,1,1,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,3,3,2,2,2,2,2,2,2,2,1,1,2,7,7,7,7,1,1,1,2,1,1,1,4,4,4,4,4,4,4,4,4,1,6,6,6,5,5,5,5,5,5,5,5,5,5,5,5,2,2,2,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,4,4,6,6,6,6,6,6,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,1,1,1,1,5,2,1,2,5,5,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,1,2,2,7,7,7,2,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,1,1,6,6,6,6,5,5,5,5,1,5,5,5,5,5,5,1,1,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,4,6,6,6,4,6,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,6,1,1,1,6,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,2,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,1,1,2,7,7,2,1,1,1,1,1,1,1,1,1,4,4,4,4,4,1,1,1,1,1,6,6,6,6,1,1,1,1,1,5,5,5,5,2,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,4,6,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,2,1,1,1,1,1,1,1,1,1,1,2,2,1,1,1,1,1,2,2,0,2,1,1,1,1,1,1,1,1,1,1,1,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,1,6,6,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,1,1,1,1,1,1,2,2,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,1,1,2,7,7,2,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,5,5,5,6,1,6,6,5,1,1,5,5,5,2,2,1,1,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,1,1,1,2,2,2,1,2,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,1,2,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,1,1,1,1,2,7,2,1,1,1,1,1,1,1,1,1,4,4,4,4,1,1,1,1,1,5,5,5,5,6,6,6,6,5,1,1,5,5,5,2,1,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,4,4,1,4,4,4,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,1,1,1,2,2,2,1,1,1,1,2,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,1,5,5,6,6,6,6,5,6,6,6,1,1,1,6,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,1,2,1,2,2,2,1,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,5,1,5,5,5,5,5,6,6,6,5,1,1,5,5,5,5,2,1,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,1,4,1,1,1,1,1,1,1,5,5,5,1,1,1,1,1,1,1,3,3,3,3,2,2,5,2,2,2,1,1,1,5,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,1,1,1,1,1,6,1,5,5,5,6,6,6,1,6,6,6,1,1,1,1,1,1,1,5,5,5,5,5,5,5,1,2,2,1,2,2,1,1,2,2,2,1,1,1,1,2,1,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,2,1,5,5,5,5,5,5,1,5,5,6,5,1,1,1,1,5,5,2,2,1,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,5,5,5,5,5,1,1,1,1,1,1,3,3,3,3,3,5,5,5,2,2,2,2,5,5,5,2,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,1,1,1,1,1,1,1,5,5,5,5,6,1,6,6,6,6,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,1,5,5,2,1,2,2,1,2,1,1,1,1,5,5,2,2,5,5,5,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,1,1,2,5,5,5,5,5,5,5,5,5,5,2,2,2,1,1,1,1,2,2,1,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,1,1,1,1,5,5,5,5,5,5,5,1,1,1,1,2,1,3,3,3,3,5,5,5,2,5,2,5,5,5,5,2,2,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,1,1,5,1,1,1,1,1,5,5,5,1,6,6,6,6,6,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,2,2,2,2,2,2,1,1,5,5,5,5,5,5,5,5,5,5,1,5,1,1,2,1,1,1,1,1,1,1,1,1,2,1,4,4,4,1,1,1,5,5,5,5,5,5,5,5,5,1,1,2,2,2,1,1,1,1,1,1,1,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,5,5,5,5,5,5,5,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,1,1,5,5,5,5,1,1,1,5,5,5,5,5,5,6,6,6,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,1,5,5,5,5,5,1,2,2,2,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,4,4,4,1,4,4,4,1,1,1,1,1,1,1,1,5,5,5,1,2,5,2,1,1,1,1,1,1,5,5,5,5,5,5,5,5,3,5,2,2,2,2,2,2,1,1,2,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,5,5,5,5,1,1,5,5,5,5,5,5,5,6,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,2,2,1,1,1,5,5,5,5,2,2,2,1,1,1,2,5,5,5,5,5,2,2,5,2,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,4,1,1,1,1,1,2,5,1,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,4,4,1,1,4,1,1,1,1,1,1,1,1,1,1,5,1,1,2,2,1,1,1,1,1,1,5,5,5,5,5,5,5,3,3,2,1,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,1,1,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,2,2,5,5,5,5,2,2,1,1,1,1,5,5,1,2,2,2,1,1,1,2,2,2,5,5,2,2,5,2,2,2,5,5,5,1,1,1,1,1,1,1,1,1,2,2,2,2,2,1,1,2,2,1,1,5,5,5,5,5,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,6,6,6,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,3,3,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,1,1,1,1,1,1,5,5,5,5,5,5,5,5,1,1,1,1,1,2,2,1,5,5,5,2,2,1,1,1,1,1,1,1,1,2,1,1,1,1,2,2,2,2,2,2,5,5,5,1,2,2,5,1,1,1,1,1,1,2,1,1,1,2,2,1,2,2,1,1,1,2,1,1,1,5,5,5,5,1,1,1,2,2,2,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,6,6,6,6,6,6,1,1,1,1,6,6,1,1,1,1,1,1,1,1,1,1,5,1,5,5,5,5,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,5,5,5,5,5,5,1,1,1,1,1,1,2,2,1,5,5,5,2,2,2,1,1,1,1,1,1,1,2,1,2,1,1,1,2,2,2,2,2,2,5,2,2,5,5,5,5,1,1,1,1,1,1,1,6,1,1,1,1,1,1,1,1,1,1,5,1,1,1,5,5,1,1,1,1,2,2,2,1,1,2,2,1,1,1,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,4,1,1,6,6,6,6,6,6,6,6,1,1,6,6,6,1,1,1,1,1,1,1,1,2,2,1,1,5,5,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,5,5,5,5,1,1,1,1,1,1,1,2,2,2,1,1,5,2,2,2,2,2,2,1,2,1,1,1,1,2,2,1,1,1,2,2,2,2,2,2,2,2,5,5,5,5,1,1,1,1,1,1,1,6,6,6,1,1,1,1,2,1,1,2,5,5,5,1,1,1,1,1,1,1,1,2,2,2,1,1,2,2,1,1,1,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,1,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,2,2,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,1,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,4,4,4,5,5,5,5,1,1,1,1,1,1,1,1,2,2,1,1,2,2,2,2,2,2,2,1,1,1,1,1,1,2,1,1,1,1,2,2,2,2,2,2,2,2,2,5,5,2,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,5,5,5,5,1,1,1,1,1,1,2,1,1,2,1,1,1,1,1,1,1,1,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,6,1,1,1,6,6,6,1,1,1,1,6,6,6,6,6,6,1,1,1,1,2,2,1,2,2,2,1,1,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,1,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,5,5,1,1,1,1,1,1,1,2,2,1,2,1,1,2,2,2,2,1,2,2,1,1,1,1,1,1,2,1,1,1,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,5,5,5,5,1,1,1,1,1,6,6,2,1,1,1,1,1,1,1,1,1,1,1,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,6,6,6,1,1,6,6,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,1,2,2,1,1,2,2,1,2,2,2,2,2,2,2,2,2,2,1,1,5,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,2,2,2,1,1,2,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,6,6,6,1,1,2,2,2,5,5,5,5,5,5,1,1,6,6,6,6,6,6,2,6,6,1,1,2,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,1,1,1,1,1,1,2,2,6,1,1,1,1,1,1,1,1,1,2,2,1,2,2,2,2,2,2,2,5,5,2,2,2,1,1,1,5,5,5,1,1,5,1,1,1,1,1,1,1,1,4,4,4,1,1,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,1,1,1,1,1,1,6,1,1,1,1,2,2,2,2,2,2,1,2,2,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,2,1,1,6,6,2,2,1,1,2,2,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,2,2,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,5,5,5,5,1,1,1,1,5,5,5,5,1,5,5,5,1,1,1,1,1,1,1,4,4,4,1,1,1,1,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,1,5,5,1,1,1,1,1,1,1,1,4,4,4,4,1,1,1,1,1,1,6,6,6,1,1,1,1,1,5,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,2,1,1,2,5,5,5,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,2,1,2,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,6,6,1,1,1,1,1,1,1,1,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,5,5,5,2,1,1,1,1,1,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,5,5,5,5,1,1,2,2,1,1,1,2,4,4,1,1,1,1,1,1,1,6,6,6,1,1,1,5,5,5,5,2,2,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,2,5,5,5,1,1,5,1,5,5,5,5,5,5,5,1,6,1,1,2,1,2,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,5,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,2,1,1,1,1,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,5,5,5,5,2,2,5,1,1,1,2,1,1,1,1,1,1,1,1,1,1,6,6,6,6,1,5,5,5,5,5,5,2,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,2,1,1,6,1,1,6,1,1,5,5,5,5,2,2,1,1,1,1,1,1,5,5,4,4,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,5,5,5,5,1,1,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,5,5,5,2,5,5,5,1,1,2,1,1,1,1,1,1,1,1,1,6,6,6,6,6,5,5,5,5,5,5,5,2,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,2,2,1,1,1,1,6,6,6,1,1,5,5,5,5,1,1,1,1,1,1,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,5,5,5,5,1,1,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,1,5,5,5,5,5,1,1,1,2,1,1,1,1,1,1,6,1,1,1,6,1,1,6,5,5,5,5,5,5,2,2,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,1,5,5,5,5,1,1,2,1,1,1,1,4,4,4,4,4,4,1,1,1,2,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,1,5,5,5,1,1,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,1,1,5,5,5,5,1,1,1,1,2,2,1,1,1,1,6,6,6,1,1,1,1,1,5,5,5,5,5,5,2,2,2,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,1,1,5,5,1,1,2,1,1,1,1,1,1,4,4,4,4,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,1,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,4,4,4,1,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,5,5,2,1,2,1,1,1,1,1,1,1,1,6,6,1,1,1,1,1,1,1,5,1,1,5,1,2,2,2,1,1,1,1,2,2,2,1,1,1,1,1,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,2,2,2,5,5,5,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,1,5,5,5,5,5,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,2,2,1,1,1,1,1,1,2,1,1,1,1,2,2,1,2,6,6,6,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,2,2,2,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,2,2,2,2,2,2,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,5,5,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,1,5,5,5,5,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,2,2,2,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,2,1,1,1,1,1,1,1,1,2,2,2,1,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,2,2,1,2,2,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,1,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,1,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,2,2,2,1,1,1,1,1,1,2,1,1,1,1,1,2,2,1,6,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,2,2,2,2,2,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,2,2,1,2,2,2,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,2,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,1,1,1,5,1,1,1,1,1,1,1,1,1,4,4,4,4,1,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,2,2,2,1,1,2,1,2,2,2,2,2,1,2,1,2,2,2,2,2,1,1,1,1,1,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,2,2,2,2,2,2,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,1,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,2,2,2,2,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,2,2,1,2,2,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,2,2,2,2,1,2,2,2,2,2,2,2,1,1,1,1,1,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,2,2,2,2,2,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,1,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,2,2,1,1,1,2,1,1,1,1,2,2,1,1,1,1,1,1,1,1,1,1,2,1,1,2,1,1,1,1,1,1,1,1,2,2,2,2,1,1,2,2,2,2,2,1,2,2,2,2,2,2,2,1,1,1,1,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,2,2,2,2,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,];
}

function getTilePallet()
{
	return ["medit_sand_messy","grass_field_b","grass_field_dry","new_savanna_grass_b","medit_shrubs_golden","grass_mediterranean_dry_1024test","medit_grass_field_b","medit_grass_field_dry","medit_cliff_a",];
}
