/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.jena.sdb.core;

import org.apache.jena.sdb.SDB ;
import org.apache.jena.sdb.SDBException ;
import org.apache.jena.sparql.util.Symbol ;


public class SDBConstants
{
    // Not "Integer.MIN_VALUE" which is meaningful to MySQL.
    public static final int jdbcFetchSizeOff            = -1 ;

    public static Symbol allocSymbol(String shortName)
    { 
        if ( shortName.matches("^[a-zA-Z]*:") )
            throw new SDBException("Symbol short name begins URI scheme") ;
        return Symbol.create(SDB.symbolSpace+shortName) ;
    }
}
