/*
 * This file was automatically generated by EvoSuite
 * Fri Jan 12 14:22:14 GMT 2018
 */

package uk.ac.sanger.artemis;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import java.awt.datatransfer.Clipboard;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.Entry;
import uk.ac.sanger.artemis.Feature;
import uk.ac.sanger.artemis.FeatureSegment;
import uk.ac.sanger.artemis.FeatureSegmentVector;
import uk.ac.sanger.artemis.Selection;
import uk.ac.sanger.artemis.SimpleEntryGroup;
import uk.ac.sanger.artemis.io.FastaStreamSequence;
import uk.ac.sanger.artemis.sequence.Bases;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = true, useJEE = true) 
public class FeatureSegmentVector_ESTest extends FeatureSegmentVector_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      FeatureSegmentVector featureSegmentVector0 = new FeatureSegmentVector();
      featureSegmentVector0.addElementAtEnd((FeatureSegment) null);
      FeatureSegment featureSegment0 = featureSegmentVector0.elementAt(0);
      assertNull(featureSegment0);
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      FeatureSegmentVector featureSegmentVector0 = new FeatureSegmentVector();
      // Undeclared exception!
      try { 
        featureSegmentVector0.setElementAt((FeatureSegment) null, (-1));
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // no message in exception (getMessage() returned null)
         //
      }
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      FeatureSegmentVector featureSegmentVector0 = new FeatureSegmentVector();
      // Undeclared exception!
      try { 
        featureSegmentVector0.removeElementAt(3720);
        fail("Expecting exception: IndexOutOfBoundsException");
      
      } catch(IndexOutOfBoundsException e) {
         //
         // Index: 3720, Size: 0
         //
         verifyException("java.util.ArrayList", e);
      }
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      FeatureSegmentVector featureSegmentVector0 = new FeatureSegmentVector();
      // Undeclared exception!
      try { 
        featureSegmentVector0.insertElementAt((FeatureSegment) null, (byte) (-51));
        fail("Expecting exception: IndexOutOfBoundsException");
      
      } catch(IndexOutOfBoundsException e) {
         //
         // Index: -51, Size: 0
         //
         verifyException("java.util.ArrayList", e);
      }
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      Clipboard clipboard0 = new Clipboard("");
      Selection selection0 = new Selection(clipboard0);
      FeatureSegmentVector featureSegmentVector0 = selection0.getSelectedSegments();
      // Undeclared exception!
      try { 
        featureSegmentVector0.elementAt((-310));
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // no message in exception (getMessage() returned null)
         //
      }
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      Clipboard clipboard0 = new Clipboard(">Gi-#b#}z");
      Selection selection0 = new Selection(clipboard0);
      FeatureSegmentVector featureSegmentVector0 = selection0.getAllSegments();
      // Undeclared exception!
      try { 
        featureSegmentVector0.add((FeatureSegment) null);
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // internal error - adding a null object
         //
         verifyException("uk.ac.sanger.artemis.util.FastVector", e);
      }
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      FeatureSegmentVector featureSegmentVector0 = new FeatureSegmentVector();
      // Undeclared exception!
      try { 
        featureSegmentVector0.elementAt(0);
        fail("Expecting exception: IndexOutOfBoundsException");
      
      } catch(IndexOutOfBoundsException e) {
         //
         // Index: 0, Size: 0
         //
         verifyException("java.util.ArrayList", e);
      }
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      FeatureSegmentVector featureSegmentVector0 = new FeatureSegmentVector();
      int int0 = featureSegmentVector0.indexOf((FeatureSegment) null);
      assertEquals((-1), int0);
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      FeatureSegmentVector featureSegmentVector0 = new FeatureSegmentVector();
      int int0 = featureSegmentVector0.size();
      assertEquals(0, int0);
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      FeatureSegmentVector featureSegmentVector0 = new FeatureSegmentVector();
      Object object0 = featureSegmentVector0.clone();
      assertNotSame(object0, featureSegmentVector0);
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      Clipboard clipboard0 = new Clipboard((String) null);
      Selection selection0 = new Selection(clipboard0);
      FeatureSegmentVector featureSegmentVector0 = selection0.getAllSegments();
      // Undeclared exception!
      try { 
        featureSegmentVector0.removeElementAt((-2881));
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // no message in exception (getMessage() returned null)
         //
      }
  }

  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
      Clipboard clipboard0 = new Clipboard("EXTERNAL");
      Selection selection0 = new Selection(clipboard0);
      FeatureSegmentVector featureSegmentVector0 = selection0.getAllSegments();
      featureSegmentVector0.addElementAtEnd((FeatureSegment) null);
      FeatureSegment featureSegment0 = featureSegmentVector0.lastElement();
      assertNull(featureSegment0);
  }

  @Test(timeout = 4000)
  public void test12()  throws Throwable  {
      Clipboard clipboard0 = new Clipboard(">Gi-#b#}z");
      Selection selection0 = new Selection(clipboard0);
      FeatureSegmentVector featureSegmentVector0 = selection0.getAllSegments();
      featureSegmentVector0.removeAllElements();
  }

  @Test(timeout = 4000)
  public void test13()  throws Throwable  {
      FeatureSegmentVector featureSegmentVector0 = new FeatureSegmentVector();
      // Undeclared exception!
      try { 
        featureSegmentVector0.setElementAt((FeatureSegment) null, 0);
        fail("Expecting exception: IndexOutOfBoundsException");
      
      } catch(IndexOutOfBoundsException e) {
         //
         // Index: 0, Size: 0
         //
         verifyException("java.util.ArrayList", e);
      }
  }

  @Test(timeout = 4000)
  public void test14()  throws Throwable  {
      FeatureSegmentVector featureSegmentVector0 = new FeatureSegmentVector();
      boolean boolean0 = featureSegmentVector0.contains((FeatureSegment) null);
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test15()  throws Throwable  {
      Clipboard clipboard0 = new Clipboard("EXTERNAL");
      Selection selection0 = new Selection(clipboard0);
      FeatureSegmentVector featureSegmentVector0 = selection0.getAllSegments();
      // Undeclared exception!
      try { 
        featureSegmentVector0.lastElement();
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // no message in exception (getMessage() returned null)
         //
      }
  }

  @Test(timeout = 4000)
  public void test16()  throws Throwable  {
      FeatureSegmentVector featureSegmentVector0 = new FeatureSegmentVector();
      boolean boolean0 = featureSegmentVector0.removeElement((FeatureSegment) null);
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test17()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("~i%66SE!iO_1<&6B");
      Bases bases0 = new Bases(fastaStreamSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      Entry entry0 = simpleEntryGroup0.createEntry("A%mn@W");
      Feature feature0 = entry0.createFeature();
      FeatureSegmentVector featureSegmentVector0 = feature0.getSegments();
      featureSegmentVector0.lastElement();
  }

  @Test(timeout = 4000)
  public void test18()  throws Throwable  {
      FeatureSegmentVector featureSegmentVector0 = new FeatureSegmentVector();
      featureSegmentVector0.insertElementAt((FeatureSegment) null, 0);
      featureSegmentVector0.setElementAt((FeatureSegment) null, 0);
  }

  @Test(timeout = 4000)
  public void test19()  throws Throwable  {
      Clipboard clipboard0 = new Clipboard("EXTERNAL");
      Selection selection0 = new Selection(clipboard0);
      FeatureSegmentVector featureSegmentVector0 = selection0.getAllSegments();
      // Undeclared exception!
      try { 
        featureSegmentVector0.addElement((FeatureSegment) null);
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // internal error - adding a null object
         //
         verifyException("uk.ac.sanger.artemis.util.FastVector", e);
      }
  }

  @Test(timeout = 4000)
  public void test20()  throws Throwable  {
      FeatureSegmentVector featureSegmentVector0 = new FeatureSegmentVector();
      featureSegmentVector0.sortByPosition();
  }
}
