/*
 * This file was automatically generated by EvoSuite
 * Fri Jan 12 13:22:56 GMT 2018
 */

package uk.ac.sanger.artemis.components;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.Feature;
import uk.ac.sanger.artemis.SimpleEntryGroup;
import uk.ac.sanger.artemis.components.SelectionViewer;
import uk.ac.sanger.artemis.components.TransferAnnotationTool;
import uk.ac.sanger.artemis.components.genebuilder.ortholog.MatchPanel;
import uk.ac.sanger.artemis.io.MSPcrunchDocumentEntry;
import uk.ac.sanger.artemis.io.Qualifier;
import uk.ac.sanger.artemis.io.SimpleEntryInformation;
import uk.ac.sanger.artemis.util.StringVector;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = true, useJEE = true) 
public class TransferAnnotationTool_ESTest extends TransferAnnotationTool_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test0()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      SimpleEntryInformation simpleEntryInformation0 = new SimpleEntryInformation();
      MSPcrunchDocumentEntry mSPcrunchDocumentEntry0 = new MSPcrunchDocumentEntry(simpleEntryInformation0);
      MatchPanel matchPanel0 = new MatchPanel((Feature) null, mSPcrunchDocumentEntry0);
      TransferAnnotationTool transferAnnotationTool0 = null;
      try {
        transferAnnotationTool0 = new TransferAnnotationTool((Feature) null, simpleEntryGroup0, matchPanel0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.TransferAnnotationTool", e);
      }
  }

  @Test(timeout = 4000)
  public void test1()  throws Throwable  {
      StringVector stringVector0 = new StringVector("Failed to read full set of sequence IDs file ");
      Qualifier qualifier0 = new Qualifier(" N 1heMp$cUgPV", stringVector0);
      Qualifier qualifier1 = TransferAnnotationTool.getQualifierWithoutDuplicateValues(qualifier0, stringVector0);
      assertNull(qualifier1);
  }

  @Test(timeout = 4000)
  public void test2()  throws Throwable  {
      Qualifier qualifier0 = new Qualifier("GBFeature_key");
      StringVector stringVector0 = SelectionViewer.getBaseSummary("GBFeature_key");
      qualifier0.addValues(stringVector0);
      Qualifier qualifier1 = TransferAnnotationTool.getQualifierWithoutDuplicateValues(qualifier0, stringVector0);
      assertNotSame(qualifier1, qualifier0);
      assertNotNull(qualifier1);
  }

  @Test(timeout = 4000)
  public void test3()  throws Throwable  {
      Qualifier qualifier0 = new Qualifier(".VcTC$2lTB%a{S;aH", "FbZ*4Ml;8BV$T6^P");
      StringVector stringVector0 = new StringVector();
      Qualifier qualifier1 = TransferAnnotationTool.getQualifierWithoutDuplicateValues(qualifier0, stringVector0);
      assertSame(qualifier1, qualifier0);
  }

  @Test(timeout = 4000)
  public void test4()  throws Throwable  {
      Qualifier qualifier0 = new Qualifier("GBFeature_key");
      StringVector stringVector0 = SelectionViewer.getBaseSummary("GBFeature_key");
      // Undeclared exception!
      try { 
        TransferAnnotationTool.getQualifierWithoutDuplicateValues(qualifier0, stringVector0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.TransferAnnotationTool", e);
      }
  }

  @Test(timeout = 4000)
  public void test5()  throws Throwable  {
      Qualifier qualifier0 = new Qualifier("Add", (StringVector) null);
      Qualifier qualifier1 = TransferAnnotationTool.getQualifierWithoutDuplicateValues(qualifier0, (StringVector) null);
      assertSame(qualifier0, qualifier1);
  }

  @Test(timeout = 4000)
  public void test6()  throws Throwable  {
      boolean boolean0 = TransferAnnotationTool.isNonTransferable("transmembrane");
      assertTrue(boolean0);
  }

  @Test(timeout = 4000)
  public void test7()  throws Throwable  {
      boolean boolean0 = TransferAnnotationTool.isNonTransferable("GBFeature_key");
      assertFalse(boolean0);
  }
}
