/*
 * This file was automatically generated by EvoSuite
 * Fri Jan 12 16:33:24 GMT 2018
 */

package uk.ac.sanger.artemis.sequence;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import javax.swing.JLayeredPane;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.SimpleEntryGroup;
import uk.ac.sanger.artemis.SimpleGotoEventSource;
import uk.ac.sanger.artemis.io.EmblStreamSequence;
import uk.ac.sanger.artemis.io.FastaStreamSequence;
import uk.ac.sanger.artemis.io.GenbankStreamSequence;
import uk.ac.sanger.artemis.io.Location;
import uk.ac.sanger.artemis.io.PartialSequence;
import uk.ac.sanger.artemis.io.Range;
import uk.ac.sanger.artemis.sequence.AminoAcidSequence;
import uk.ac.sanger.artemis.sequence.Bases;
import uk.ac.sanger.artemis.sequence.Marker;
import uk.ac.sanger.artemis.sequence.MarkerRange;
import uk.ac.sanger.artemis.sequence.Strand;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = true, useJEE = true) 
public class MarkerRange_ESTest extends MarkerRange_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      char[] charArray0 = new char[19];
      Integer integer0 = JLayeredPane.POPUP_LAYER;
      PartialSequence partialSequence0 = new PartialSequence(charArray0, 461, 0, (Short) null, integer0);
      Bases bases0 = new Bases(partialSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      SimpleGotoEventSource simpleGotoEventSource0 = new SimpleGotoEventSource(simpleEntryGroup0);
      MarkerRange markerRange0 = simpleGotoEventSource0.gotoBase(2851);
      Marker marker0 = markerRange0.getRawEnd();
      MarkerRange markerRange1 = new MarkerRange(marker0);
      marker0.setRawPosition(461);
      MarkerRange markerRange2 = markerRange0.combineRanges(markerRange1, false);
      assertNotSame(markerRange1, markerRange2);
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      char[] charArray0 = new char[19];
      Integer integer0 = JLayeredPane.POPUP_LAYER;
      PartialSequence partialSequence0 = new PartialSequence(charArray0, 461, 0, (Short) null, integer0);
      Bases bases0 = new Bases(partialSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      SimpleGotoEventSource simpleGotoEventSource0 = new SimpleGotoEventSource(simpleEntryGroup0);
      MarkerRange markerRange0 = simpleGotoEventSource0.gotoBase(2851);
      Marker marker0 = markerRange0.getRawEnd();
      marker0.setRawPosition(461);
      boolean boolean0 = markerRange0.overlaps(markerRange0);
      assertTrue(boolean0);
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      char[] charArray0 = new char[5];
      Integer integer0 = JLayeredPane.DEFAULT_LAYER;
      PartialSequence partialSequence0 = new PartialSequence(charArray0, 'z', 0, (Short) null, integer0);
      Bases bases0 = new Bases(partialSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      SimpleGotoEventSource simpleGotoEventSource0 = new SimpleGotoEventSource(simpleEntryGroup0);
      MarkerRange markerRange0 = simpleGotoEventSource0.gotoBase(2820);
      Strand strand0 = markerRange0.getStrand();
      MarkerRange markerRange1 = new MarkerRange(strand0, 5, 1);
      int int0 = markerRange1.getCount();
      assertEquals(5, int0);
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      char[] charArray0 = new char[5];
      Integer integer0 = JLayeredPane.DEFAULT_LAYER;
      PartialSequence partialSequence0 = new PartialSequence(charArray0, 461, 0, (Short) null, integer0);
      Bases bases0 = new Bases(partialSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      SimpleGotoEventSource simpleGotoEventSource0 = new SimpleGotoEventSource(simpleEntryGroup0);
      MarkerRange markerRange0 = simpleGotoEventSource0.gotoBase(0);
      Range range0 = markerRange0.getRawRange();
      assertEquals(0, range0.getEnd());
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      char[] charArray0 = new char[5];
      Integer integer0 = JLayeredPane.DEFAULT_LAYER;
      PartialSequence partialSequence0 = new PartialSequence(charArray0, 461, 0, (Short) null, integer0);
      Bases bases0 = new Bases(partialSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      SimpleGotoEventSource simpleGotoEventSource0 = new SimpleGotoEventSource(simpleEntryGroup0);
      MarkerRange markerRange0 = simpleGotoEventSource0.gotoBase((-1153));
      Range range0 = markerRange0.getRawRange();
      assertEquals(1, range0.getCount());
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      char[] charArray0 = new char[5];
      Integer integer0 = JLayeredPane.DEFAULT_LAYER;
      PartialSequence partialSequence0 = new PartialSequence(charArray0, 461, 0, (Short) null, integer0);
      Bases bases0 = new Bases(partialSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      SimpleGotoEventSource simpleGotoEventSource0 = new SimpleGotoEventSource(simpleEntryGroup0);
      MarkerRange markerRange0 = simpleGotoEventSource0.gotoBase(0);
      Range range0 = markerRange0.getRange();
      assertEquals(1, range0.getCount());
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("hjisP&*P{shZ");
      Bases bases0 = new Bases(fastaStreamSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      SimpleGotoEventSource simpleGotoEventSource0 = new SimpleGotoEventSource(simpleEntryGroup0);
      MarkerRange markerRange0 = simpleGotoEventSource0.gotoBase(1);
      assertNotNull(markerRange0);
      
      Range range0 = markerRange0.getRange();
      assertEquals(1, range0.getCount());
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      MarkerRange markerRange0 = new MarkerRange((Marker) null);
      Marker marker0 = markerRange0.getEnd();
      assertNull(marker0);
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getTranslation("w8M2H^$9", true);
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("w8M2H^$9");
      Bases bases0 = new Bases(genbankStreamSequence0);
      MarkerRange markerRange0 = aminoAcidSequence0.findMatch(bases0, (Marker) null, true, true, false);
      // Undeclared exception!
      try { 
        markerRange0.overlaps((MarkerRange) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.MarkerRange", e);
      }
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      MarkerRange markerRange0 = new MarkerRange((Marker) null);
      // Undeclared exception!
      try { 
        markerRange0.isForwardMarker();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.MarkerRange", e);
      }
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      MarkerRange markerRange0 = new MarkerRange((Marker) null);
      // Undeclared exception!
      try { 
        markerRange0.getStrand();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.MarkerRange", e);
      }
  }

  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
      MarkerRange markerRange0 = new MarkerRange((Marker) null);
      // Undeclared exception!
      try { 
        markerRange0.getRawStart();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.MarkerRange", e);
      }
  }

  @Test(timeout = 4000)
  public void test12()  throws Throwable  {
      MarkerRange markerRange0 = new MarkerRange((Marker) null);
      // Undeclared exception!
      try { 
        markerRange0.getRawRange();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.MarkerRange", e);
      }
  }

  @Test(timeout = 4000)
  public void test13()  throws Throwable  {
      MarkerRange markerRange0 = new MarkerRange((Marker) null);
      // Undeclared exception!
      try { 
        markerRange0.getRawEnd();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.MarkerRange", e);
      }
  }

  @Test(timeout = 4000)
  public void test14()  throws Throwable  {
      MarkerRange markerRange0 = new MarkerRange((Marker) null);
      // Undeclared exception!
      try { 
        markerRange0.getRange();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.MarkerRange", e);
      }
  }

  @Test(timeout = 4000)
  public void test15()  throws Throwable  {
      MarkerRange markerRange0 = new MarkerRange((Marker) null);
      // Undeclared exception!
      try { 
        markerRange0.getCount();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.MarkerRange", e);
      }
  }

  @Test(timeout = 4000)
  public void test16()  throws Throwable  {
      MarkerRange markerRange0 = new MarkerRange((Marker) null);
      // Undeclared exception!
      try { 
        markerRange0.extendRange(markerRange0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.MarkerRange", e);
      }
  }

  @Test(timeout = 4000)
  public void test17()  throws Throwable  {
      MarkerRange markerRange0 = new MarkerRange((Marker) null);
      // Undeclared exception!
      try { 
        markerRange0.createLocation();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.MarkerRange", e);
      }
  }

  @Test(timeout = 4000)
  public void test18()  throws Throwable  {
      char[] charArray0 = new char[5];
      Integer integer0 = JLayeredPane.DEFAULT_LAYER;
      PartialSequence partialSequence0 = new PartialSequence(charArray0, 461, 0, (Short) null, integer0);
      Bases bases0 = new Bases(partialSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      SimpleGotoEventSource simpleGotoEventSource0 = new SimpleGotoEventSource(simpleEntryGroup0);
      MarkerRange markerRange0 = simpleGotoEventSource0.gotoBase(0);
      // Undeclared exception!
      try { 
        markerRange0.createLocation();
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // internal error - unexpected exception: org.evosuite.runtime.mock.java.lang.MockThrowable: location out of range: 0
         //
         verifyException("uk.ac.sanger.artemis.sequence.MarkerRange", e);
      }
  }

  @Test(timeout = 4000)
  public void test19()  throws Throwable  {
      MarkerRange markerRange0 = new MarkerRange((Marker) null);
      // Undeclared exception!
      try { 
        markerRange0.contains((MarkerRange) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.MarkerRange", e);
      }
  }

  @Test(timeout = 4000)
  public void test20()  throws Throwable  {
      char[] charArray0 = new char[19];
      Integer integer0 = JLayeredPane.POPUP_LAYER;
      PartialSequence partialSequence0 = new PartialSequence(charArray0, 461, 0, (Short) null, integer0);
      Bases bases0 = new Bases(partialSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      SimpleGotoEventSource simpleGotoEventSource0 = new SimpleGotoEventSource(simpleEntryGroup0);
      MarkerRange markerRange0 = simpleGotoEventSource0.gotoBase(2820);
      // Undeclared exception!
      try { 
        markerRange0.combineRanges((MarkerRange) null, false);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.MarkerRange", e);
      }
  }

  @Test(timeout = 4000)
  public void test21()  throws Throwable  {
      MarkerRange markerRange0 = null;
      try {
        markerRange0 = new MarkerRange((Strand) null, 0, 0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.MarkerRange", e);
      }
  }

  @Test(timeout = 4000)
  public void test22()  throws Throwable  {
      char[] charArray0 = new char[19];
      Integer integer0 = JLayeredPane.POPUP_LAYER;
      PartialSequence partialSequence0 = new PartialSequence(charArray0, 461, 0, (Short) null, integer0);
      Bases bases0 = new Bases(partialSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      SimpleGotoEventSource simpleGotoEventSource0 = new SimpleGotoEventSource(simpleEntryGroup0);
      MarkerRange markerRange0 = simpleGotoEventSource0.gotoBase(2851);
      MarkerRange markerRange1 = simpleGotoEventSource0.gotoBase((int) 'z');
      boolean boolean0 = markerRange1.contains(markerRange0);
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test23()  throws Throwable  {
      char[] charArray0 = new char[19];
      Integer integer0 = JLayeredPane.POPUP_LAYER;
      PartialSequence partialSequence0 = new PartialSequence(charArray0, 461, 0, (Short) null, integer0);
      Bases bases0 = new Bases(partialSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      SimpleGotoEventSource simpleGotoEventSource0 = new SimpleGotoEventSource(simpleEntryGroup0);
      MarkerRange markerRange0 = simpleGotoEventSource0.gotoBase(2851);
      boolean boolean0 = markerRange0.contains(markerRange0);
      assertTrue(boolean0);
  }

  @Test(timeout = 4000)
  public void test24()  throws Throwable  {
      char[] charArray0 = new char[5];
      Integer integer0 = JLayeredPane.DEFAULT_LAYER;
      PartialSequence partialSequence0 = new PartialSequence(charArray0, 461, 0, (Short) null, integer0);
      Bases bases0 = new Bases(partialSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      SimpleGotoEventSource simpleGotoEventSource0 = new SimpleGotoEventSource(simpleEntryGroup0);
      MarkerRange markerRange0 = simpleGotoEventSource0.gotoBase(2820);
      Strand strand0 = markerRange0.getStrand();
      MarkerRange markerRange1 = strand0.makeMarkerRangeFromPositions(86, 0);
      boolean boolean0 = markerRange0.contains(markerRange1);
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test25()  throws Throwable  {
      char[] charArray0 = new char[19];
      Integer integer0 = JLayeredPane.POPUP_LAYER;
      PartialSequence partialSequence0 = new PartialSequence(charArray0, 461, 0, (Short) null, integer0);
      Bases bases0 = new Bases(partialSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      SimpleGotoEventSource simpleGotoEventSource0 = new SimpleGotoEventSource(simpleEntryGroup0);
      MarkerRange markerRange0 = simpleGotoEventSource0.gotoBase(2851);
      MarkerRange markerRange1 = markerRange0.combineRanges(markerRange0, true);
      assertFalse(markerRange1.equals((Object)markerRange0));
  }

  @Test(timeout = 4000)
  public void test26()  throws Throwable  {
      char[] charArray0 = new char[5];
      Integer integer0 = JLayeredPane.DEFAULT_LAYER;
      PartialSequence partialSequence0 = new PartialSequence(charArray0, 461, 0, (Short) null, integer0);
      Bases bases0 = new Bases(partialSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      SimpleGotoEventSource simpleGotoEventSource0 = new SimpleGotoEventSource(simpleEntryGroup0);
      MarkerRange markerRange0 = simpleGotoEventSource0.gotoBase(2820);
      Strand strand0 = bases0.getReverseStrand();
      MarkerRange markerRange1 = strand0.makeMarkerRangeFromPositions(2, 2820);
      // Undeclared exception!
      try { 
        markerRange0.combineRanges(markerRange1, false);
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // internal error - strands do not match
         //
         verifyException("uk.ac.sanger.artemis.sequence.MarkerRange", e);
      }
  }

  @Test(timeout = 4000)
  public void test27()  throws Throwable  {
      char[] charArray0 = new char[5];
      Integer integer0 = JLayeredPane.DEFAULT_LAYER;
      PartialSequence partialSequence0 = new PartialSequence(charArray0, 'z', 0, (Short) null, integer0);
      Bases bases0 = new Bases(partialSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      SimpleGotoEventSource simpleGotoEventSource0 = new SimpleGotoEventSource(simpleEntryGroup0);
      MarkerRange markerRange0 = simpleGotoEventSource0.gotoBase(2820);
      Marker marker0 = markerRange0.getRawStart();
      assertEquals(0, Marker.LISTENER_PRIORITY);
  }

  @Test(timeout = 4000)
  public void test28()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("N3s)3$JE");
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence(fastaStreamSequence0);
      Bases bases0 = new Bases(emblStreamSequence0);
      Strand strand0 = bases0.getForwardStrand();
      MarkerRange markerRange0 = null;
      try {
        markerRange0 = new MarkerRange(strand0, 28, 49152);
        fail("Expecting exception: Exception");
      
      } catch(Throwable e) {
         //
         // position: 28
         //
         verifyException("uk.ac.sanger.artemis.sequence.MarkerInternal", e);
      }
  }

  @Test(timeout = 4000)
  public void test29()  throws Throwable  {
      char[] charArray0 = new char[21];
      Integer integer0 = JLayeredPane.DEFAULT_LAYER;
      PartialSequence partialSequence0 = new PartialSequence(charArray0, 461, 0, (Short) null, integer0);
      Bases bases0 = new Bases(partialSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      SimpleGotoEventSource simpleGotoEventSource0 = new SimpleGotoEventSource(simpleEntryGroup0);
      MarkerRange markerRange0 = simpleGotoEventSource0.gotoBase(2820);
      Marker marker0 = markerRange0.getStart();
      assertEquals(0, Marker.LISTENER_PRIORITY);
  }

  @Test(timeout = 4000)
  public void test30()  throws Throwable  {
      char[] charArray0 = new char[19];
      Integer integer0 = JLayeredPane.POPUP_LAYER;
      PartialSequence partialSequence0 = new PartialSequence(charArray0, 461, 0, (Short) null, integer0);
      Bases bases0 = new Bases(partialSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      SimpleGotoEventSource simpleGotoEventSource0 = new SimpleGotoEventSource(simpleEntryGroup0);
      MarkerRange markerRange0 = simpleGotoEventSource0.gotoBase(2851);
      Marker marker0 = markerRange0.getEnd();
      assertEquals(0, Marker.LISTENER_PRIORITY);
  }

  @Test(timeout = 4000)
  public void test31()  throws Throwable  {
      char[] charArray0 = new char[5];
      Integer integer0 = JLayeredPane.DEFAULT_LAYER;
      PartialSequence partialSequence0 = new PartialSequence(charArray0, 461, 0, (Short) null, integer0);
      Bases bases0 = new Bases(partialSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      SimpleGotoEventSource simpleGotoEventSource0 = new SimpleGotoEventSource(simpleEntryGroup0);
      MarkerRange markerRange0 = simpleGotoEventSource0.gotoBase(2820);
      Location location0 = markerRange0.createLocation();
      assertNotNull(location0);
  }

  @Test(timeout = 4000)
  public void test32()  throws Throwable  {
      char[] charArray0 = new char[5];
      Integer integer0 = JLayeredPane.DEFAULT_LAYER;
      PartialSequence partialSequence0 = new PartialSequence(charArray0, 461, 0, (Short) null, integer0);
      Bases bases0 = new Bases(partialSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      SimpleGotoEventSource simpleGotoEventSource0 = new SimpleGotoEventSource(simpleEntryGroup0);
      MarkerRange markerRange0 = simpleGotoEventSource0.gotoBase((-1153));
      Strand strand0 = markerRange0.getStrand();
      MarkerRange markerRange1 = new MarkerRange(strand0, 5, 1);
      MarkerRange markerRange2 = markerRange0.combineRanges(markerRange1, true);
      assertFalse(markerRange2.equals((Object)markerRange0));
  }

  @Test(timeout = 4000)
  public void test33()  throws Throwable  {
      char[] charArray0 = new char[5];
      Integer integer0 = JLayeredPane.DEFAULT_LAYER;
      PartialSequence partialSequence0 = new PartialSequence(charArray0, 461, 0, (Short) null, integer0);
      Bases bases0 = new Bases(partialSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      SimpleGotoEventSource simpleGotoEventSource0 = new SimpleGotoEventSource(simpleEntryGroup0);
      MarkerRange markerRange0 = simpleGotoEventSource0.gotoBase(2820);
      Strand strand0 = markerRange0.getStrand();
      MarkerRange markerRange1 = new MarkerRange(strand0, 5, 1);
      MarkerRange markerRange2 = markerRange0.combineRanges(markerRange1, true);
      assertFalse(markerRange2.equals((Object)markerRange1));
  }

  @Test(timeout = 4000)
  public void test34()  throws Throwable  {
      char[] charArray0 = new char[19];
      Integer integer0 = JLayeredPane.POPUP_LAYER;
      PartialSequence partialSequence0 = new PartialSequence(charArray0, 461, 0, (Short) null, integer0);
      Bases bases0 = new Bases(partialSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      SimpleGotoEventSource simpleGotoEventSource0 = new SimpleGotoEventSource(simpleEntryGroup0);
      MarkerRange markerRange0 = simpleGotoEventSource0.gotoBase(2851);
      Strand strand0 = new Strand(bases0, 21);
      MarkerRange markerRange1 = strand0.makeMarkerRangeFromPositions((-5), 2851);
      // Undeclared exception!
      try { 
        markerRange0.extendRange(markerRange1);
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // internal error - strands do not match
         //
         verifyException("uk.ac.sanger.artemis.sequence.MarkerRange", e);
      }
  }

  @Test(timeout = 4000)
  public void test35()  throws Throwable  {
      char[] charArray0 = new char[5];
      Integer integer0 = JLayeredPane.DEFAULT_LAYER;
      PartialSequence partialSequence0 = new PartialSequence(charArray0, 461, 0, (Short) null, integer0);
      Bases bases0 = new Bases(partialSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      SimpleGotoEventSource simpleGotoEventSource0 = new SimpleGotoEventSource(simpleEntryGroup0);
      MarkerRange markerRange0 = simpleGotoEventSource0.gotoBase(2820);
      MarkerRange markerRange1 = simpleGotoEventSource0.gotoBase(0);
      boolean boolean0 = markerRange0.overlaps(markerRange1);
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test36()  throws Throwable  {
      char[] charArray0 = new char[5];
      Integer integer0 = JLayeredPane.DEFAULT_LAYER;
      PartialSequence partialSequence0 = new PartialSequence(charArray0, 461, 0, (Short) null, integer0);
      Bases bases0 = new Bases(partialSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      SimpleGotoEventSource simpleGotoEventSource0 = new SimpleGotoEventSource(simpleEntryGroup0);
      MarkerRange markerRange0 = simpleGotoEventSource0.gotoBase(2820);
      Strand strand0 = markerRange0.getStrand();
      MarkerRange markerRange1 = new MarkerRange(strand0, 5, 1);
      boolean boolean0 = markerRange1.overlaps(markerRange0);
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test37()  throws Throwable  {
      char[] charArray0 = new char[19];
      Integer integer0 = JLayeredPane.POPUP_LAYER;
      PartialSequence partialSequence0 = new PartialSequence(charArray0, 461, 0, (Short) null, integer0);
      Bases bases0 = new Bases(partialSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      SimpleGotoEventSource simpleGotoEventSource0 = new SimpleGotoEventSource(simpleEntryGroup0);
      MarkerRange markerRange0 = simpleGotoEventSource0.gotoBase(2851);
      boolean boolean0 = markerRange0.overlaps(markerRange0);
      assertTrue(boolean0);
  }

  @Test(timeout = 4000)
  public void test38()  throws Throwable  {
      char[] charArray0 = new char[5];
      Integer integer0 = JLayeredPane.DEFAULT_LAYER;
      PartialSequence partialSequence0 = new PartialSequence(charArray0, 461, 0, (Short) null, integer0);
      Bases bases0 = new Bases(partialSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      SimpleGotoEventSource simpleGotoEventSource0 = new SimpleGotoEventSource(simpleEntryGroup0);
      MarkerRange markerRange0 = simpleGotoEventSource0.gotoBase(2820);
      Range range0 = markerRange0.getRawRange();
      assertEquals(1, range0.getCount());
  }

  @Test(timeout = 4000)
  public void test39()  throws Throwable  {
      char[] charArray0 = new char[19];
      Integer integer0 = JLayeredPane.DRAG_LAYER;
      PartialSequence partialSequence0 = new PartialSequence(charArray0, 461, 0, (Short) null, integer0);
      Bases bases0 = new Bases(partialSequence0);
      Strand strand0 = new Strand(bases0, 1);
      MarkerRange markerRange0 = strand0.makeMarkerRangeFromRawPositions((-1), 2);
      Range range0 = markerRange0.getRawRange();
      assertEquals(4, range0.getCount());
  }

  @Test(timeout = 4000)
  public void test40()  throws Throwable  {
      char[] charArray0 = new char[5];
      Integer integer0 = JLayeredPane.DEFAULT_LAYER;
      PartialSequence partialSequence0 = new PartialSequence(charArray0, 461, 0, (Short) null, integer0);
      Bases bases0 = new Bases(partialSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      SimpleGotoEventSource simpleGotoEventSource0 = new SimpleGotoEventSource(simpleEntryGroup0);
      MarkerRange markerRange0 = simpleGotoEventSource0.gotoBase(2820);
      Strand strand0 = markerRange0.getStrand();
      MarkerRange markerRange1 = new MarkerRange(strand0, 5, 1);
      Marker marker0 = markerRange1.getRawEnd();
      assertEquals(0, Marker.LISTENER_PRIORITY);
  }

  @Test(timeout = 4000)
  public void test41()  throws Throwable  {
      char[] charArray0 = new char[19];
      Integer integer0 = JLayeredPane.POPUP_LAYER;
      PartialSequence partialSequence0 = new PartialSequence(charArray0, 461, 0, (Short) null, integer0);
      Bases bases0 = new Bases(partialSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      SimpleGotoEventSource simpleGotoEventSource0 = new SimpleGotoEventSource(simpleEntryGroup0);
      MarkerRange markerRange0 = simpleGotoEventSource0.gotoBase(2851);
      Marker marker0 = markerRange0.getRawEnd();
      MarkerRange markerRange1 = new MarkerRange(marker0);
      MarkerRange markerRange2 = markerRange0.combineRanges(markerRange1, true);
      assertFalse(markerRange2.equals((Object)markerRange1));
  }

  @Test(timeout = 4000)
  public void test42()  throws Throwable  {
      char[] charArray0 = new char[19];
      Integer integer0 = JLayeredPane.POPUP_LAYER;
      PartialSequence partialSequence0 = new PartialSequence(charArray0, 461, 0, (Short) null, integer0);
      Bases bases0 = new Bases(partialSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      SimpleGotoEventSource simpleGotoEventSource0 = new SimpleGotoEventSource(simpleEntryGroup0);
      MarkerRange markerRange0 = simpleGotoEventSource0.gotoBase(2851);
      MarkerRange markerRange1 = markerRange0.extendRange(markerRange0);
      assertFalse(markerRange1.equals((Object)markerRange0));
  }

  @Test(timeout = 4000)
  public void test43()  throws Throwable  {
      char[] charArray0 = new char[19];
      Integer integer0 = JLayeredPane.POPUP_LAYER;
      PartialSequence partialSequence0 = new PartialSequence(charArray0, 461, 0, (Short) null, integer0);
      Bases bases0 = new Bases(partialSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      SimpleGotoEventSource simpleGotoEventSource0 = new SimpleGotoEventSource(simpleEntryGroup0);
      MarkerRange markerRange0 = simpleGotoEventSource0.gotoBase(2851);
      boolean boolean0 = markerRange0.isForwardMarker();
      assertTrue(boolean0);
  }

  @Test(timeout = 4000)
  public void test44()  throws Throwable  {
      char[] charArray0 = new char[5];
      Integer integer0 = JLayeredPane.DEFAULT_LAYER;
      PartialSequence partialSequence0 = new PartialSequence(charArray0, 461, 0, (Short) null, integer0);
      Bases bases0 = new Bases(partialSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      SimpleGotoEventSource simpleGotoEventSource0 = new SimpleGotoEventSource(simpleEntryGroup0);
      MarkerRange markerRange0 = simpleGotoEventSource0.gotoBase((-1153));
      Range range0 = markerRange0.getRange();
      assertEquals(1, range0.getCount());
  }
}
