/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jiapi.file.attribute;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import net.sf.jiapi.Configuration;
import net.sf.jiapi.file.ConstantPool;
import net.sf.jiapi.file.attribute.AnnotationDefaultAttribute;
import net.sf.jiapi.file.attribute.AnnotationsAttribute;
import net.sf.jiapi.file.attribute.BootstrapMethodsAttribute;
import net.sf.jiapi.file.attribute.CodeAttribute;
import net.sf.jiapi.file.attribute.ConstantValueAttribute;
import net.sf.jiapi.file.attribute.DeprecatedAttribute;
import net.sf.jiapi.file.attribute.EnclosingMethodAttribute;
import net.sf.jiapi.file.attribute.ExceptionsAttribute;
import net.sf.jiapi.file.attribute.InnerClassesAttribute;
import net.sf.jiapi.file.attribute.LineNumberTableAttribute;
import net.sf.jiapi.file.attribute.LocalVariableTableAttribute;
import net.sf.jiapi.file.attribute.LocalVariableTypeTableAttribute;
import net.sf.jiapi.file.attribute.ParameterAnnotationsAttribute;
import net.sf.jiapi.file.attribute.SignatureAttribute;
import net.sf.jiapi.file.attribute.SourceDebugExtension;
import net.sf.jiapi.file.attribute.SourceFileAttribute;
import net.sf.jiapi.file.attribute.StackMapTableAttribute;
import net.sf.jiapi.file.attribute.SyntheticAttribute;

public class Attribute {
    private short attribute_name_index;
    private byte[] bytes;
    protected ConstantPool cp;
    protected static transient Configuration config = new Configuration();

    protected Attribute(short nameIndex) {
        this.attribute_name_index = nameIndex;
        this.bytes = new byte[0];
    }

    protected Attribute(short nameIndex, int length, DataInputStream dis) throws IOException {
        this.attribute_name_index = nameIndex;
        this.bytes = new byte[length];
        for (int i = 0; i < length; ++i) {
            this.bytes[i] = dis.readByte();
        }
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public String getName() {
        return this.cp.getUtf8(this.attribute_name_index);
    }

    public short getAttributeNameIndex() {
        return this.attribute_name_index;
    }

    public void setConstantPool(ConstantPool cp) {
        this.cp = cp;
    }

    protected DataInputStream getDataInputStream() {
        return new DataInputStream(new ByteArrayInputStream(this.bytes));
    }

    public static Attribute readAttribute(ConstantPool constantPool, DataInputStream dis) throws IOException {
        short attribute_name_index = dis.readShort();
        int attribute_length = dis.readInt();
        ConstantPool.Utf8Info utf8 = (ConstantPool.Utf8Info)constantPool.get(attribute_name_index);
        String attrName = new String(utf8.getBytes());
        Attribute a = null;
        a = "ConstantValue".equals(attrName) ? new ConstantValueAttribute(attribute_name_index, dis) : ("Code".equals(attrName) ? new CodeAttribute(constantPool, attribute_name_index, attribute_length, dis) : ("StackMapTable".equals(attrName) ? new StackMapTableAttribute(constantPool, attribute_name_index, attribute_length, dis) : ("Exceptions".equals(attrName) ? new ExceptionsAttribute(constantPool, attribute_name_index, attribute_length, dis) : ("InnerClasses".equals(attrName) ? new InnerClassesAttribute(attribute_name_index, attribute_length, dis) : ("EnclosingMethod".equals(attrName) ? new EnclosingMethodAttribute(attribute_name_index, dis) : ("Synthetic".equals(attrName) ? new SyntheticAttribute(attribute_name_index, dis) : ("Signature".equals(attrName) ? new SignatureAttribute(attribute_name_index, dis) : ("SourceFile".equals(attrName) ? new SourceFileAttribute(attribute_name_index, dis) : ("SourceDebugExtension".equals(attrName) ? new SourceDebugExtension(attribute_name_index, attribute_length, dis) : ("LineNumberTable".equals(attrName) ? new LineNumberTableAttribute(attribute_name_index, attribute_length, dis) : ("LocalVariableTable".equals(attrName) ? new LocalVariableTableAttribute(attribute_name_index, attribute_length, dis) : ("LocalVariableTypeTable".equals(attrName) ? new LocalVariableTypeTableAttribute(attribute_name_index, attribute_length, dis) : ("Deprecated".equals(attrName) ? new DeprecatedAttribute(attribute_name_index, dis) : ("RuntimeVisibleAnnotations".equals(attrName) || "RuntimeInvisibleAnnotations".equals(attrName) ? new AnnotationsAttribute(constantPool, attribute_name_index, attribute_length, dis) : ("RuntimeVisibleParameterAnnotations".equals(attrName) || "RuntimeInvisibleParameterAnnotations".equals(attrName) ? new ParameterAnnotationsAttribute(constantPool, attribute_name_index, attribute_length, dis) : ("AnnotationDefault".equals(attrName) ? new AnnotationDefaultAttribute(constantPool, attribute_name_index, attribute_length, dis) : ("BootstrapMethods".equals(attrName) ? new BootstrapMethodsAttribute(constantPool, attribute_name_index, attribute_length, dis) : new Attribute(attribute_name_index, attribute_length, dis))))))))))))))))));
        a.setConstantPool(constantPool);
        return a;
    }

    public String toString() {
        return this.getName();
    }
}

