/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.signaturetest.model;

import com.sun.tdk.signaturetest.model.AnnotationItem;

public class AnnotationItemEx
extends AnnotationItem {
    public static final String ANNOTATION_EX_PREFIX = "annoEx";
    private int targetType;
    private int[] locations;
    private int parameterIndex;
    private int boundIndex;
    private int typeIndex;
    public static final int TARGET_METHOD_RECEIVER = 6;
    public static final int TARGET_METHOD_RETURN_TYPE_GENERIC_ARRAY = 11;
    public static final int TARGET_METHOD_PARAMETER_GENERIC_ARRAY = 13;
    public static final int TARGET_FIELD_GENERIC_ARRAY = 15;
    public static final int TARGET_CLASS_TYPE_PARAMETER_BOUND = 16;
    public static final int TARGET_CLASS_TYPE_PARAMETER_BOUND_GENERIC_ARRAY = 17;
    public static final int TARGET_METHOD_TYPE_PARAMETER_BOUND = 18;
    public static final int TARGET_METHOD_TYPE_PARAMETER_BOUND_GENERIC_ARRAY = 19;
    public static final int TARGET_CLASS_EXTENDS_IMPLEMENTS = 20;
    public static final int TARGET_CLASS_EXTENDS_IMPLEMENTS_GENERIC_ARRAY = 21;
    public static final int TARGET_EXCEPTION_TYPE_IN_THROWS = 22;
    public static final int TARGET_WILDCARD_BOUND = 28;
    public static final int TARGET_WILDCARD_BOUND_GENERIC_ARRAY = 29;
    public static final int TARGET_METHOD_TYPE_PARAMETER = 32;
    public static final int TARGET_CLASS_TYPE_PARAMETER = 34;
    public static final int TARGET_TYPECAST = 0;
    public static final int TARGET_TYPECAST_GENERIC_ARRAY = 1;
    public static final int TARGET_TYPE_TEST = 2;
    public static final int TARGET_TYPE_TEST_GENERIC_ARRAY = 3;
    public static final int TARGET_OBJECT_CREATION = 4;
    public static final int TARGET_OBJECT_CREATION_GENERIC_ARRAY = 5;
    public static final int TARGET_LOCAL_VARIABLE = 8;
    public static final int TARGET_LOCAL_VARIABLE_GENERIC_ARRAY = 9;
    public static final int TARGET_TYPE_ARGUMENT_IN_CONSTRUCTOR_CALL = 24;
    public static final int TARGET_TYPE_ARGUMENT_IN_CONSTRUCTOR_CALL_GENERIC_ARRAY = 25;
    public static final int TARGET_TYPE_ARGUMENT_IN_METHOD_CALL = 26;
    public static final int TARGET_TYPE_ARGUMENT_IN_METHOD_CALL_GENERIC_ARRAY = 27;
    public static final int TARGET_CLASS_LITERAL = 30;
    public static final int TARGET_CLASS_LITERAL_GENERIC_ARRAY = 31;
    public static final String ANN_TARGET_TYPE = "type";
    public static final String ANN_TYPE_IND = "typeIndex";
    public static final String ANN_BOUND_IND = "boundIndex";
    public static final String ANN_LOCATIONS = "locations";
    public static final String ANN_PARAM_IND = "parameterIndex";

    public AnnotationItemEx(int target, String name) {
        super(target, name);
    }

    public AnnotationItemEx() {
    }

    public int getTargetType() {
        return this.targetType;
    }

    public AnnotationItemEx setTargetType(int target_type) {
        this.targetType = target_type;
        return this;
    }

    public int[] getLocations() {
        return this.locations;
    }

    public AnnotationItemEx setLocations(int[] locations) {
        this.locations = locations;
        return this;
    }

    public int getParameterIndex() {
        return this.parameterIndex;
    }

    public AnnotationItemEx setParameterIndex(int parameterIndex) {
        this.parameterIndex = parameterIndex;
        return this;
    }

    public int getBoundIndex() {
        return this.boundIndex;
    }

    public AnnotationItemEx setBoundIndex(int boundIndex) {
        this.boundIndex = boundIndex;
        return this;
    }

    public int getTypeIndex() {
        return this.typeIndex;
    }

    public AnnotationItemEx setTypeIndex(int typeIndex) {
        this.typeIndex = typeIndex;
        return this;
    }

    protected String getSpecificData() {
        StringBuffer sb = new StringBuffer();
        this.addTargetType(sb);
        switch (this.targetType) {
            case 11: 
            case 15: {
                this.addLocations(sb);
                break;
            }
            case 13: {
                this.addParameterInd(sb);
                this.addLocations(sb);
                break;
            }
            case 16: 
            case 18: {
                this.addParameterInd(sb);
                this.addBoundInd(sb);
                break;
            }
            case 17: 
            case 19: {
                this.addParameterInd(sb);
                this.addBoundInd(sb);
                this.addLocations(sb);
                break;
            }
            case 20: 
            case 22: {
                this.addTypeInd(sb);
                break;
            }
            case 21: {
                this.addTypeInd(sb);
                this.addLocations(sb);
                break;
            }
            case 32: 
            case 34: {
                this.addParameterInd(sb);
            }
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append("]");
        return sb.toString();
    }

    private void addTargetType(StringBuffer sb) {
        sb.append("[type=" + this.intToHex(this.targetType) + ";");
    }

    private void addTypeInd(StringBuffer sb) {
        sb.append("typeIndex=" + this.typeIndex + ";");
    }

    private void addBoundInd(StringBuffer sb) {
        sb.append("boundIndex=" + this.boundIndex + ";");
    }

    private void addLocations(StringBuffer sb) {
        sb.append("locations=" + this.arrayToString(this.locations) + ";");
    }

    private void addParameterInd(StringBuffer sb) {
        sb.append("parameterIndex=" + this.parameterIndex + ";");
    }

    private String intToHex(int i) {
        String s = Integer.toHexString(i).toUpperCase();
        if (s.length() == 1) {
            s = "0" + s;
        }
        return "0x" + s;
    }

    private String arrayToString(int[] a) {
        if (a == null) {
            return "null";
        }
        int iMax = a.length - 1;
        if (iMax == -1) {
            return "[]";
        }
        StringBuffer b = new StringBuffer();
        b.append('[');
        int i = 0;
        while (true) {
            b.append(a[i]);
            if (i == iMax) {
                return b.append(']').toString();
            }
            b.append(",");
            ++i;
        }
    }

    protected String getPrefix() {
        return ANNOTATION_EX_PREFIX;
    }
}

