//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      Base/Util/ThreadInfo.h
//! @brief     Defines struct ThreadInfo.
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_BASE_UTIL_THREADINFO_H
#define BORNAGAIN_BASE_UTIL_THREADINFO_H

//! Information to run simulation with dedicated number of threads.

struct ThreadInfo {
    unsigned n_threads{0};
    unsigned n_batches{1};
    unsigned current_batch{0};
};

#endif // BORNAGAIN_BASE_UTIL_THREADINFO_H
