//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/Model/Device/MultiInstrumentNotifier.cpp
//! @brief     Implements class MultiInstrumentNotifier
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#include "GUI/Model/Device/MultiInstrumentNotifier.h"
#include "GUI/Model/Device/InstrumentItems.h"

MultiInstrumentNotifier::MultiInstrumentNotifier(InstrumentModel* instruments)
    : m_instruments(instruments)
{
}

InstrumentModel* MultiInstrumentNotifier::instrumentModel()
{
    return m_instruments;
}

void MultiInstrumentNotifier::removeInstrument(InstrumentItem* instrument)
{
    m_instruments->removeInstrument(instrument);
    emit instrumentAddedOrRemoved();
}

InstrumentItem* MultiInstrumentNotifier::addInstrumentItemCopy(const InstrumentItem* instrument,
                                                               const QString& name)
{
    InstrumentItem* copy = m_instruments->insertItemCopy(*instrument);
    copy->setInstrumentName(name);
    emit instrumentAddedOrRemoved();
    return copy;
}

void MultiInstrumentNotifier::setInstrumentName(InstrumentItem* instrument, const QString& name)
{
    if (instrument->instrumentName() != name) {
        instrument->setInstrumentName(name);
        emit instrumentNameChanged(instrument);
        emit instrumentChanged(instrument);
    }
}

void MultiInstrumentNotifier::updateInstrumentToRealDataItem(InstrumentItem* instrument,
                                                             const RealItem* realItem)
{
    instrument->updateToRealData(realItem);
    emit instrumentChanged(instrument);
}

void MultiInstrumentNotifier::notifyInstrumentChanged(InstrumentItem* instrument)
{
    emit instrumentChanged(instrument);
}
