//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/Model/Sample/LayerItem.h
//! @brief     Defines class LayerItem
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_MODEL_SAMPLE_LAYERITEM_H
#define BORNAGAIN_GUI_MODEL_SAMPLE_LAYERITEM_H

#include "Base/Types/OwningVector.h"
#include "GUI/Model/Descriptor/SelectionProperty.h"
#include "GUI/Model/Sample/Item3D.h"
#include "GUI/Model/Sample/ItemWithMaterial.h"
#include "GUI/Model/Sample/RoughnessItemCatalog.h"
#include "GUI/Model/Sample/RoughnessItems.h"
#include <QColor>

class BasicRoughnessItem;
class ParticleLayoutItem;
class ItemWithParticles;

class LayerItem : public virtual ItemWithMaterial, public virtual Item3D {
public:
    explicit LayerItem(const MaterialModel* materials);
    ~LayerItem();

    QString layerName() const { return m_name; }
    void setLayerName(const QString& n) { m_name = n; }

    QVector<ItemWithMaterial*> itemsWithMaterial();
    QVector<ItemWithParticles*> itemsWithParticles() const;

    DoubleProperty& thickness() { return m_thickness; }
    const DoubleProperty& thickness() const { return m_thickness; }
    void setThickness(double v) { m_thickness.setValue(v); }

    SelectionProperty<RoughnessItemCatalog>& roughnessSelection() { return m_roughness; }
    void setBasicRoughness();
    void clearRoughness();

    uint numSlices() const { return m_numSlices; }
    void setNumSlices(uint v) { m_numSlices = v; }

    QVector<ParticleLayoutItem*> layoutItems() const;
    ParticleLayoutItem* addLayoutItem();
    void removeLayoutItem(ParticleLayoutItem* layout);

    QColor color() const { return m_color; }
    void setColor(const QColor& c) { m_color = c; }

    bool isTopLayer() const { return m_isTopLayer; }
    void setIsTopLayer(bool b) { m_isTopLayer = b; }

    bool isBottomLayer() const { return m_isBottomLayer; }
    void setIsBottomLayer(bool b) { m_isBottomLayer = b; }

    void writeTo(QXmlStreamWriter* w) const;
    void readFrom(QXmlStreamReader* r);

    bool isExpandLayer() const { return m_expandLayer; }
    void setExpandLayer(bool b) { m_expandLayer = b; }

private:
    QString m_name;
    uint m_numSlices = 1;
    DoubleProperty m_thickness;
    QColor m_color;
    bool m_isTopLayer = false;
    bool m_isBottomLayer = false;
    OwningVector<ParticleLayoutItem> m_layouts;
    SelectionProperty<RoughnessItemCatalog> m_roughness;
    bool m_expandLayer = false;
};

#endif // BORNAGAIN_GUI_MODEL_SAMPLE_LAYERITEM_H
