//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/View/Common/DataPropertyWidget.h
//! @brief     Defines class DataPropertyWidget
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2022
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_VIEW_COMMON_DATAPROPERTYWIDGET_H
#define BORNAGAIN_GUI_VIEW_COMMON_DATAPROPERTYWIDGET_H

#include "GUI/View/Common/DataAccessWidget.h"

class QFormLayout;

//! Base class for IntensityDataPropertyWidget and SpecularDataPropertyWidget.

class DataPropertyWidget : public DataAccessWidget {
    Q_OBJECT
public:
    explicit DataPropertyWidget(QWidget* parent = nullptr);

    void setJobOrRealItem(QObject* job_or_real_Item) override;

signals:
    void axesRangeResetRequested();

protected:
    void updateItemCoords(DataItem* item);
    void updateUIValues();
    virtual void createPanelElements() = 0;

    InstrumentItem* instrumentItem();
    QStringList axesUnitsList();

    QFormLayout* m_mainLayout;
    QList<std::function<void()>> m_updaters;
};

#endif // BORNAGAIN_GUI_VIEW_COMMON_DATAPROPERTYWIDGET_H
