//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/View/Fit/ParameterTuningWidget.h
//! @brief     Defines class ParameterTuningWidget
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_VIEW_FIT_PARAMETERTUNINGWIDGET_H
#define BORNAGAIN_GUI_VIEW_FIT_PARAMETERTUNINGWIDGET_H

#include "GUI/View/Common/DataAccessWidget.h"

class JobModel;
class QItemSelectionModel;
class ParameterTuningDelegate;
class ParameterTuningModel;
class SliderSettingsWidget;
class QTreeView;
class CautionSign;
class ParameterItem;

//! Main widget for real time parameter tuning.
//! Contains a tree for parameter tuning and the model to provide drag-and-drop in FitActivityPanel.

class ParameterTuningWidget : public DataAccessWidget {
    Q_OBJECT

public:
    explicit ParameterTuningWidget(QWidget* parent = nullptr);

    void setJobOrRealItem(QObject* job_item) override;
    void setModel(QObject* jobModel);
    QItemSelectionModel* selectionModel();

    QVector<ParameterItem*> selectedParameterItems();

signals:
    void itemContextMenuRequest(const QPoint& point);

public slots:
    void onCurrentLinkChanged(ParameterItem* item);
    void onSliderRangeChanged(int value);
    void onLockZValueChanged(bool value);
    void restoreModelsOfCurrentJobItem();
    void makeSelected(ParameterItem* item);

protected:
    void contextMenuEvent(QContextMenuEvent*) override;

private slots:
    void updateParameterModel();
    void onCustomContextMenuRequested(const QPoint& point);

private:
    void updateDragAndDropSettings();
    void setTuningDelegateEnabled(bool enabled);
    void closeActiveEditors();
    void updateJobStatus();

    JobModel* m_jobModel;
    ParameterTuningModel* m_parameterTuningModel;
    SliderSettingsWidget* m_sliderSettingsWidget;
    QTreeView* m_treeView;
    ParameterTuningDelegate* m_delegate;
    CautionSign* m_cautionSign;
};

#endif // BORNAGAIN_GUI_VIEW_FIT_PARAMETERTUNINGWIDGET_H
