//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/View/Instrument/InstrumentLibraryEditor.h
//! @brief     Defines class InstrumentLibraryEditor
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_VIEW_INSTRUMENT_INSTRUMENTLIBRARYEDITOR_H
#define BORNAGAIN_GUI_VIEW_INSTRUMENT_INSTRUMENTLIBRARYEDITOR_H

#include "GUI/View/Instrument/InstrumentsTreeModel.h"
#include <QDialog>

class InstrumentItem;
class InstrumentLibrary;

namespace Ui {
class InstrumentLibraryEditor;
}

class InstrumentLibraryEditor : public QDialog {
    Q_OBJECT
public:
    InstrumentLibraryEditor(QWidget* parent, InstrumentLibrary* instrumentLibrary);
    ~InstrumentLibraryEditor() override;

    void setGisasEnabled(bool b);
    void setOffspecEnabled(bool b);
    void setSpecularEnabled(bool b);
    void setDepthprobeEnabled(bool b);

    //! Execute the dialog for choosing an instrument from the library.
    //! Returns nullptr if canceled
    InstrumentItem* execChoose();

    //! Execute the dialog to add an instrument to the library.
    void execAdd(const InstrumentItem& instrumentToAdd);

private:
    void onItemDoubleClickedForChoose(const QModelIndex& index);
    void onCurrentChangedForChoose();
    QList<QAction*> getOverlayActions(const QModelIndex& index, bool asHover);
    void createWidgetsForCurrentInstrument();

    void onInstrumentNameEdited(const QString& newName);
    void onInstrumentDescriptionEdited(const QString& t);
    void onInstrumentChangedByEditor();

    //! A model extension for InstrumentsTreeModel which
    //! * shows a "NEW" sign in the icon of a newly added instrument.
    //! * creates a HTML text for the Display role
    class TreeModel : public InstrumentsTreeModel {
    public:
        TreeModel(QObject* parent, InstrumentModel* model);

        //! Set the instrument which shall have a "NEW" sign in its icon
        void setNewInstrument(InstrumentItem* addedInstrument);

        QVariant data(const QModelIndex& index, int role) const override;

    private:
        InstrumentItem* m_newInstrument = nullptr;
    };

    InstrumentLibrary* m_instrumentLibrary;
    Ui::InstrumentLibraryEditor* m_ui;
    TreeModel* m_treeModel;
    InstrumentItem* m_chosenItem;
};

#endif // BORNAGAIN_GUI_VIEW_INSTRUMENT_INSTRUMENTLIBRARYEDITOR_H
