//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/View/Job/JobPropertiesWidget.h
//! @brief     Defines class JobPropertiesWidget
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_VIEW_JOB_JOBPROPERTIESWIDGET_H
#define BORNAGAIN_GUI_VIEW_JOB_JOBPROPERTIESWIDGET_H

#include <QSettings>
#include <QWidget>

class JobItem;
class JobPropertiesTableModel;
class QTabWidget;
class QTextEdit;
class QTreeView;

//! The JobPropertiesWidget class holds component editor for JobItem. Part of JobSelectorWidget,
//! resides at lower left corner of JobView.

class JobPropertiesWidget : public QWidget {
    Q_OBJECT
public:
    explicit JobPropertiesWidget(QWidget* parent = nullptr, Qt::WindowFlags f = Qt::WindowFlags());
    ~JobPropertiesWidget() override;
    void setJobItem(JobItem* jobItem);

private:
    void notifyJobPropertyChange();
    void applySettings();
    void saveSettings();

private slots:
    void onCommentsEdited();

private:
    QTabWidget* m_tabWidget;
    QTreeView* m_propertiesView;
    JobPropertiesTableModel* m_propertiesModel;
    QTextEdit* m_commentsEditor;
    JobItem* m_jobItem;
};

#endif // BORNAGAIN_GUI_VIEW_JOB_JOBPROPERTIESWIDGET_H
