//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/View/Main/ActionManager.h
//! @brief     Defines class ActionManager
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2021
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_VIEW_MAIN_ACTIONMANAGER_H
#define BORNAGAIN_GUI_VIEW_MAIN_ACTIONMANAGER_H

#include <QObject>

class QMenu;
class QAction;
class QMenuBar;
class MainWindow;
class QShortcut;

//! Class to handle MainWindow's menu and corresponding actions

class ActionManager : public QObject {
    Q_OBJECT
public:
    ActionManager(MainWindow* parent);

private slots:
    void onAboutToShowFileMenu();
    void onAboutToShowSettingsMenu();
    void onAboutToShowViewMenu();
    void onAboutApplication();
    void onCurrentViewChanged();

private:
    void updateActionEnabling();

private:
    MainWindow* m_mainWindow;

    QAction* m_newAction;
    QAction* m_openAction;
    QAction* m_saveAction;
    QAction* m_saveAsAction;
    QAction* m_closeProjectAction;
    QAction* m_exitAction;
    QAction* m_webdocAction;
    QAction* m_aboutAction;

    QMenuBar* m_menuBar;
    QMenu* m_fileMenu;
    QMenu* m_settingsMenu;
    QMenu* m_viewMenu;
    QMenu* m_recentProjectsMenu;
    QMenu* m_helpMenu;

    QShortcut* m_simulateShortcut;

    void createActions();
    void createMenus();
    void createGlobalShortcuts();
};

#endif // BORNAGAIN_GUI_VIEW_MAIN_ACTIONMANAGER_H
