//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/View/Mask/MaskViewFactory.cpp
//! @brief     Implements class MaskViewFactory
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#include "GUI/View/Mask/MaskViewFactory.h"
#include "GUI/Model/Data/MaskItems.h"
#include "GUI/Model/Data/ProjectionItems.h"
#include "GUI/View/Mask/EllipseView.h"
#include "GUI/View/Mask/LineViews.h"
#include "GUI/View/Mask/MaskAllView.h"
#include "GUI/View/Mask/MaskContainerView.h"
#include "GUI/View/Mask/PolygonPointView.h"
#include "GUI/View/Mask/PolygonView.h"
#include "GUI/View/Mask/RegionOfInterestView.h"

#include <boost/polymorphic_cast.hpp>

using boost::polymorphic_downcast;

IShape2DView* MaskViewFactory::createMaskView(MaskItemObject* item, ISceneAdaptor* adaptor)
{
    IShape2DView* result(nullptr);

    if (auto* mask = dynamic_cast<MaskContainerItem*>(item))
        result = new MaskContainerView(mask);

    else if (auto* mask = dynamic_cast<ProjectionContainerItem*>(item))
        result = new MaskContainerView(mask);

    else if (auto* mask = dynamic_cast<RectangleItem*>(item))
        result = new RectangleView(mask);

    else if (auto* mask = dynamic_cast<PolygonItem*>(item))
        result = new PolygonView(mask);

    else if (auto* mask = dynamic_cast<PolygonPointItem*>(item))
        result = new PolygonPointView(mask);

    else if (auto* mask = dynamic_cast<VerticalLineItem*>(item))
        result = new VerticalLineView(mask);

    else if (auto* mask = dynamic_cast<HorizontalLineItem*>(item))
        result = new HorizontalLineView(mask);

    else if (auto* mask = dynamic_cast<EllipseItem*>(item))
        result = new EllipseView(mask);

    else if (auto* mask = dynamic_cast<MaskAllItem*>(item))
        result = new MaskAllView(mask);

    else if (auto* mask = dynamic_cast<RegionOfInterestItem*>(item))
        result = new RegionOfInterestView(mask);

    else
        ASSERT(false);

    result->setSceneAdaptor(adaptor);

    return result;
}
