//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/View/PlotUtil/FontScalingEvent.h
//! @brief     Defines class FontScalingEvent
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_VIEW_PLOTUTIL_FONTSCALINGEVENT_H
#define BORNAGAIN_GUI_VIEW_PLOTUTIL_FONTSCALINGEVENT_H

#include <QFont>
#include <QMap>
#include <QObject>

class QEvent;
class ScientificPlot;

//! Provides event filter for ScientificPlot. Its goal is to make font size adjustments
//! on resize events.

class FontScalingEvent : public QObject {
    Q_OBJECT
public:
    explicit FontScalingEvent(ScientificPlot* plot, QWidget* parent);

private:
    bool eventFilter(QObject* obj, QEvent* event) override;

    void backupFonts();
    void restoreFonts();
    void scaleFonts(double factor);
    void setTickLabelFont(const QFont& font);

    ScientificPlot* m_plot;
    QMap<QString, QFont> m_fonts;
};

#endif // BORNAGAIN_GUI_VIEW_PLOTUTIL_FONTSCALINGEVENT_H
