//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/View/SampleDesigner/CompoundForm.h
//! @brief     Defines class CompoundForm
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2021
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_VIEW_SAMPLEDESIGNER_COMPOUNDFORM_H
#define BORNAGAIN_GUI_VIEW_SAMPLEDESIGNER_COMPOUNDFORM_H

#include <QFormLayout>
#include <QGroupBox>

class CompoundItem;
class ItemWithParticles;
class SampleEditorController;

//! Form for editing a particle composition
class CompoundForm : public QGroupBox {
    Q_OBJECT
public:
    CompoundForm(QWidget* parent, CompoundItem* compoundItem, SampleEditorController* ec,
                 bool allowRemove = true);
    ~CompoundForm();

    void enableStructureEditing(bool b);
    CompoundItem* compositionItem() const;
    void onParticleAdded(ItemWithParticles* item);
    void onAboutToRemoveParticle(ItemWithParticles* item);

private:
    QFormLayout* m_layout;
    CompoundItem* m_compositionItem;
    QAction* m_removeAction = nullptr;
    QAction* m_duplicateAction = nullptr;
    SampleEditorController* m_ec;
    QList<QWidget*> m_structureEditingWidgets;
};

#endif // BORNAGAIN_GUI_VIEW_SAMPLEDESIGNER_COMPOUNDFORM_H
