//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/View/SampleDesigner/LayerOrientedSampleEditor.h
//! @brief     Defines class LayerOrientedSampleEditor
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2021
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_VIEW_SAMPLEDESIGNER_LAYERORIENTEDSAMPLEEDITOR_H
#define BORNAGAIN_GUI_VIEW_SAMPLEDESIGNER_LAYERORIENTEDSAMPLEEDITOR_H

#include <QMap>
#include <QScrollArea>
#include <QToolBar>
#include <QWidget>

class Item3D;
class SampleForm;
class SampleItem;
class ProjectDocument;
class SampleEditorController;

//! Sample editor with layer oriented presentation of a sample
class LayerOrientedSampleEditor : public QWidget {
    Q_OBJECT
public:
    LayerOrientedSampleEditor(QWidget* parent, ProjectDocument* document);
    ~LayerOrientedSampleEditor() override;

    void setCurrentSample(SampleItem* sampleItem);

signals:
    void requestViewInRealspace(Item3D* itemToShow);
    void requestCreateNewSample();
    void aboutToRemoveItem(Item3D* item);
    void modified();

private:
    void updateActionEnabling();
    void onShowInlineEditButtonsToggled(bool checked);
    void onUnitActionToggled();

    void createLayerColors();

    //! Create empty widget with a button for sample creation
    QWidget* createEmptyWidget();

private:
    SampleForm* m_currentSampleWidget;
    QScrollArea* m_scrollArea;
    QToolBar* m_toolbar;
    QAction* m_undoAction; // dedicated to the current sample
    QAction* m_redoAction;
    QAction* m_showInlineEditButtonsAction;
    QAction* m_asAngstromAction;
    SampleItem* m_currentSample = nullptr;
    QMap<SampleItem*, SampleEditorController*> m_editControllers;
    ProjectDocument* m_document;
};


#endif // BORNAGAIN_GUI_VIEW_SAMPLEDESIGNER_LAYERORIENTEDSAMPLEEDITOR_H
