//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/View/Toplevel/PythonScriptWidget.h
//! @brief     Defines class PythonScriptWidget
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_VIEW_TOPLEVEL_PYTHONSCRIPTWIDGET_H
#define BORNAGAIN_GUI_VIEW_TOPLEVEL_PYTHONSCRIPTWIDGET_H

#include <QDialog>

class QTextEdit;
class CautionSign;
class SampleItem;
class InstrumentItem;
class SimulationOptionsItem;

//! The PythonScriptWidget displays a python script which represents full simulation.
//! Part of SimulationSetupWidget

class PythonScriptWidget : public QDialog {
    Q_OBJECT

public:
    PythonScriptWidget(QWidget* parent = nullptr);
    ~PythonScriptWidget() override;

    void generatePythonScript(const SampleItem& sampleItem, const InstrumentItem& instrumentItem,
                              const SimulationOptionsItem& optionItem,
                              const QString& outputDir = "");

private slots:
    void onExportToFileButton();

private:
    QTextEdit* m_textEdit;
    CautionSign* m_cautionSign;
    QString m_outputDir;
};

#endif // BORNAGAIN_GUI_VIEW_TOPLEVEL_PYTHONSCRIPTWIDGET_H
