//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      Sim/Contrib/DWBAContribution.h
//! @brief     Declares function dwbaContribution.
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifdef SWIG
#error no need to expose this header to Swig
#endif // SWIG
#ifndef BORNAGAIN_SIM_CONTRIB_DWBACONTRIBUTION_H
#define BORNAGAIN_SIM_CONTRIB_DWBACONTRIBUTION_H

class ReLayout;
class DiffuseElement;

namespace Compute {

//! Computes the diffuse reflection from the rough interfaces of a sample.
//! Used by DWBAComputation.

double dwbaContribution(const ReLayout& relayout, const DiffuseElement& ele);

} // namespace Compute

#endif // BORNAGAIN_SIM_CONTRIB_DWBACONTRIBUTION_H
