#include "BATesting.h"
#include "Device/Data/Datafield.h"
#include "Device/IO/IOFactory.h"
#include "Tests/GTestWrapper/google_test.h"

TEST(ReadSANSDRawTest, Read)
{
    const auto fname = BATesting::ExampleDataDir() + "/SANSDRaw.001";
    Datafield* data = IO::readData2D(fname);
    EXPECT_NE(data, nullptr);
    if (!data)
        return;
    EXPECT_EQ(data->rank(), 2);
    EXPECT_EQ(data->size(), 16384);
    EXPECT_EQ((*data)[128 * 70 + 62], 443);
}
