+++
title = "Sphere"
+++

### Sphere

A full sphere.

<img src="/img/draw/ff/3d/FullSphere.png" width="30%" >
<img src="/img/draw/ff/2d/Sphere_xy.svg" width="30%">
<img src="/img/draw/ff/2d/Sphere_xz.svg" width="30%">

#### Constructor

```python
Sphere(R)
```

Parameters:
- R, radius

#### Usage

As for any other [Form factor](/ref/sample/particle/ff).

#### Implementation

Class {{% ref-class "Sample/HardParticle" "Sphere" %}} inherits from the interface class
{{% ref-class "Sample/Particle" "IFormFactor" %}}.


Form factor is computed as

<!--$$ F(\mathbf{q})=\dfrac{4\pi}{q^3} \exp(iq_z R)\left[\sin(qR) - qR \cos(qR)\right] , $$-->
$$ F(\mathbf{q})=4\pi R^3 \exp(iq_z R) \dfrac{\sin(qR) - qR \cos(qR)}{(qR)^3} , $$
with the notation
$$ q := \sqrt{q_x^2 + q_y^2+ q_z^2}. $$

Volume [has been validated]({{% url-src %}}/Tests/Unit/Sample/FormFactorBasicTest.cpp)
against
$$ V=\dfrac{4\pi}{3} R^3. $$

#### Related shapes

More general:
- [Spheroid](/ref/sample/particle/ff/hard/spheroid), if ellipse in vertical cross section.
- [TruncatedSphere](/ref/sample/particle/ff/hard/truncatedsphere), if truncated from the top and/or the bottom.

#### Example

Scattering by uncorrelated spheres for horizontal incidence:

<img src="/img/auto/ff/Sphere.png" width="50%">
<img src="/img/auto/fq/Sphere.png" width="40%">

Generated by {{% ref-ex "ff/Sphere.py" %}},
{{% ref-ex "fq/Sphere.py" %}}.

#### History

This form factor is well known; it goes back to Lord Rayleigh.
In IsGISAXS, it has been implemented as form factor "Full sphere" [[manual](/lit/lazzari2006), Eq. 2.35; [Renaud 2009](/lit/renaud2009), Eq. 226]. In BornAgain, named "FullSphere" up to version 1.19.
