unit ButtonC;

//  Replacement Buttons as original buttons
//  do not work in QT5
//  Need to avoid using Bitblt SCRAND & SCRPAINT
//
//  Create a new button class, a double size ButtonC
//  12 pixel buttons too small on modern screens
//  PB Sep-21

interface

uses
    Classes, Controls, Graphics, ButtonBase, LCLExceptionStackTrace;

const
    bC2w = 24;  {Width of button C2}

type
    TButtonBaseC = class (TButtonBase)
    protected
        procedure SetupBounds (MySize : integer);

    public
        procedure MouseDown (Button: TMouseButton; Shift: TShiftState; x, y: integer); override;
    end;


    { Original size button C }
    TButtonC = class (TButtonBaseC)
    private
        const MySize = 12; { Square button }

    protected
        procedure SetGlyph;  override;

    public
        procedure CheckGlyph; override;

    published
        constructor Create (aOwner: TComponent); override;
    end;


    { Double size button C }
    TButtonC2 = class (TButtonBaseC)
    private
        const MySize = bC2w;
        var C2Graphic : TBitMap;

    protected
        procedure SetGlyph;     override;

    public
        procedure CheckGlyph;   override;
        destructor Destroy;     override;

    published
        constructor Create (aOwner: TComponent); override;
    end;


procedure Register;


implementation uses Directories, ScreenTools;

procedure Register;
begin
    RegisterComponents ('C-evo', [TButtonC]);
    RegisterComponents ('C-evo', [TButtonC2]);
end;



{================== ButtonBase C ==================}
procedure TButtonBaseC.SetUpBounds (MySize : integer);
begin
    SetBounds (0, 0, MySize, MySize);
    Glyph.Width  := MySize;
    Glyph.Height := MySize;
end;

procedure TButtonBaseC.MouseDown (Button: TMouseButton; Shift: TShiftState; x, y: integer);
begin
    Inherited;
    Down := Not Down; { use button as Toggle }

    if @DownChangedProc <> nil then
        DownChangedProc (self);
end;



{================== Button C ======================}
constructor TButtonC.Create (aOwner: TComponent);
begin
    inherited;
    SetUpBounds (mysize);
end;



procedure TButtonC.SetGlyph;
const Xg = 169; Yg = 159; {System.png offsets}
var XX, YY    : integer;
    Dest, Src : TRect;
begin
    XX    := Xg;
    YY    := Yg + ButtonIndex * (MySize+1);

    Dest  := Rect (0, 0, MySize, MySize);
    Src   := Rect (XX, YY, XX+MySize, YY+MySize);

    Glyph.Canvas.CopyRect (dest, GetGraphic.Canvas, src);
end;

procedure TButtonC.CheckGlyph;
begin
    if (ButtonIndex >= 0) and (GetGraphic <> nil) then
        SetGlyph;
end;



{================== Button C2 =====================}
constructor TButtonC2.Create (aOwner: TComponent);
begin
    inherited;

    SetUpBounds (MySize);
    C2Graphic := TBitMap.Create;
    LoadGraphicFile (C2Graphic, GetGraphicsDir + DirectorySeparator + 'ButtonsC2.png');
end;

destructor TButtonC2.Destroy;
begin
    C2graphic.free;
    inherited;
end;


procedure TButtonC2.SetGlyph;
var X,Y : integer;
    Dest, Src : TRect;
begin
    Y    := ButtonIndex    * (MySize+2);
    X    := Integer (Down) * (MySize+2);

    Dest := Rect (0, 0, MySize,   MySize);
    Src  := Rect (X, Y, MySize+X, MySize+Y);

    Glyph.Canvas.CopyRect (Dest, C2Graphic.Canvas, Src);
end;

procedure TButtonC2.CheckGlyph;
begin
    if (ButtonIndex >= 0) and (C2Graphic <> nil) then
        SetGlyph;
end;

end.
