{ -*- buffer-read-only: t -*-

  Copyright 2015-2022 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  public
    procedure CreateNode; override;
    class function ClassX3DType: string; override;

    strict private FFdVector: TMFVec3f;
    { Internal wrapper for property @link(Vector). This wrapper API may change, we advise to access simpler @link(Vector) instead. }
    public property FdVector: TMFVec3f read FFdVector;
    {  }
    procedure SetVector(const Value: array of TVector3); overload;
    {  }
    procedure SetVector(const Value: TVector3List); overload;

{$endif read_interface}

{$ifdef read_implementation}

{ TNormalNode ----------------------------------------------- }

procedure TNormalNode.SetVector(const Value: array of TVector3);
begin
  FdVector.Send(Value);
end;

procedure TNormalNode.SetVector(const Value: TVector3List);
begin
  FdVector.Send(Value);
end;

class function TNormalNode.ClassX3DType: String;
begin
  Result := 'Normal';
end;

procedure TNormalNode.CreateNode;
begin
  inherited;

  FFdVector := TMFVec3f.Create(Self, True, 'vector', []);
   FdVector.ChangeAlways := chNormal;
  AddField(FFdVector);
end;

{$endif read_implementation}
