{ -*- buffer-read-only: t -*-

  Copyright 2015-2022 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetFontStyle: TAbstractFontStyleNode;
    procedure SetFontStyle(const Value: TAbstractFontStyleNode);
    function GetMaxExtent: Single;
    procedure SetMaxExtent(const Value: Single);
    function GetMaxDisplayChars: Integer;
    procedure SetMaxDisplayChars(const Value: Integer);
  public
    procedure CreateNode; override;
    class function ClassX3DType: string; override;

    strict private FFdFontStyle: TSFNode;
    { Internal wrapper for property @link(FontStyle). This wrapper API may change, we advise to access simpler @link(FontStyle) instead. }
    public property FdFontStyle: TSFNode read FFdFontStyle;
    {  }
    property FontStyle: TAbstractFontStyleNode read GetFontStyle write SetFontStyle;

    strict private FFdLength: TMFFloat;
    { Internal wrapper for property @link(Length). This wrapper API may change, we advise to access simpler @link(Length) instead. }
    public property FdLength: TMFFloat read FFdLength;
    {  }
    procedure SetLength(const Value: array of Single); overload;
    {  }
    procedure SetLength(const Value: TSingleList); overload;

    strict private FFdMaxExtent: TSFFloat;
    { Internal wrapper for property @link(MaxExtent). This wrapper API may change, we advise to access simpler @link(MaxExtent) instead. }
    public property FdMaxExtent: TSFFloat read FFdMaxExtent;
    {  }
    property MaxExtent: Single read GetMaxExtent write SetMaxExtent;

    strict private FFdMaxDisplayChars: TSFInt32;
    { Internal wrapper for property @link(MaxDisplayChars). This wrapper API may change, we advise to access simpler @link(MaxDisplayChars) instead. }
    public property FdMaxDisplayChars: TSFInt32 read FFdMaxDisplayChars;
    {  }
    property MaxDisplayChars: Integer read GetMaxDisplayChars write SetMaxDisplayChars;

    strict private FFdString: TMFString;
    { Internal wrapper for property @link(Text). This wrapper API may change, we advise to access simpler @link(Text) instead. }
    public property FdString: TMFString read FFdString;
    {  }
    procedure SetText(const Value: array of string); overload;
    {  }
    procedure SetText(const Value: TCastleStringList); overload;

    strict private FEventLineBounds: TMFVec2fEvent;
    {  }
    public property EventLineBounds: TMFVec2fEvent read FEventLineBounds;

    strict private FEventOrigin: TSFVec3fEvent;
    {  }
    public property EventOrigin: TSFVec3fEvent read FEventOrigin;

    strict private FEventTextBounds: TSFVec2fEvent;
    {  }
    public property EventTextBounds: TSFVec2fEvent read FEventTextBounds;

    strict private FFdSolid: TSFBool;
    { Internal wrapper for property @link(Solid). This wrapper API may change, we advise to access simpler @link(Solid) instead. }
    public property FdSolid: TSFBool read FFdSolid;

    strict private FFdTexCoord: TSFNode;
    { Internal wrapper for property @link(TexCoord). This wrapper API may change, we advise to access simpler @link(TexCoord) instead. }
    public property FdTexCoord: TSFNode read FFdTexCoord;

{$endif read_interface}

{$ifdef read_implementation}

{ TTextNode ----------------------------------------------- }

function TTextNode.GetFontStyle: TAbstractFontStyleNode;
begin
  if FdFontStyle.Value is TAbstractFontStyleNode then
    Result := TAbstractFontStyleNode(FdFontStyle.Value)
  else
    Result := nil;
end;

procedure TTextNode.SetFontStyle(const Value: TAbstractFontStyleNode);
begin
  FdFontStyle.Send(Value);
end;

procedure TTextNode.SetLength(const Value: array of Single);
begin
  FdLength.Send(Value);
end;

procedure TTextNode.SetLength(const Value: TSingleList);
begin
  FdLength.Send(Value);
end;

function TTextNode.GetMaxExtent: Single;
begin
  Result := FdMaxExtent.Value;
end;

procedure TTextNode.SetMaxExtent(const Value: Single);
begin
  FdMaxExtent.Send(Value);
end;

function TTextNode.GetMaxDisplayChars: Integer;
begin
  Result := FdMaxDisplayChars.Value;
end;

procedure TTextNode.SetMaxDisplayChars(const Value: Integer);
begin
  FdMaxDisplayChars.Send(Value);
end;

procedure TTextNode.SetText(const Value: array of string);
begin
  FdString.Send(Value);
end;

procedure TTextNode.SetText(const Value: TCastleStringList);
begin
  FdString.Send(Value);
end;

class function TTextNode.ClassX3DType: String;
begin
  Result := 'Text';
end;

procedure TTextNode.CreateNode;
begin
  inherited;

  FFdFontStyle := TSFNode.Create(Self, True, 'fontStyle', [TAbstractFontStyleNode]);
   FdFontStyle.ChangeAlways := chGeometryFontChanged;
  AddField(FFdFontStyle);

  FFdLength := TMFFloat.Create(Self, True, 'length', []);
   FdLength.ChangeAlways := chGeometry;
  AddField(FFdLength);

  FFdMaxExtent := TSFFloat.Create(Self, True, 'maxExtent', 0.0);
   FdMaxExtent.ChangeAlways := chGeometry;
   FdMaxExtent.MustBeNonnegative := true;
  AddField(FFdMaxExtent);

  FFdMaxDisplayChars := TSFInt32.Create(Self, True, 'maxDisplayChars', -1);
   FdMaxDisplayChars.ChangeAlways := chGeometry;
  AddField(FFdMaxDisplayChars);

  FFdString := TMFString.Create(Self, True, 'string', []);
   FdString.ChangeAlways := chGeometry;
  AddField(FFdString);

  FEventLineBounds := TMFVec2fEvent.Create(Self, 'lineBounds', false);
  AddEvent(FEventLineBounds);

  FEventOrigin := TSFVec3fEvent.Create(Self, 'origin', false);
  AddEvent(FEventOrigin);

  FEventTextBounds := TSFVec2fEvent.Create(Self, 'textBounds', false);
  AddEvent(FEventTextBounds);

  FFdSolid := TSFBool.Create(Self, False, 'solid', false);
   FdSolid.ChangeAlways := chGeometry;
  AddField(FFdSolid);

  FFdTexCoord := TSFNode.Create(Self, True, 'texCoord', [TTextureCoordinateGeneratorNode, TProjectedTextureCoordinateNode, TMultiGeneratedTextureCoordinateNode]);
   FdTexCoord.ChangeAlways := chGeometry;
  AddField(FFdTexCoord);
end;

{$endif read_implementation}
