*** Settings ***
Documentation       Check Huawei WLC equipments in SNMP.

Resource            ${CURDIR}${/}..${/}..${/}..${/}..${/}resources/import.resource

Test Timeout        120s
Test Setup          Ctn Generic Suite Setup

*** Variables ***
${CMD}      ${CENTREON_PLUGINS} --plugin=network::huawei::wlc::snmp::plugin


*** Test Cases ***
ap-radio ${tc}
    [Tags]    network    snmp
    ${command}    Catenate
    ...    ${CMD}
    ...    --mode=ap-radio
    ...    --hostname=${HOSTNAME}
    ...    --snmp-version=${SNMPVERSION}
    ...    --snmp-port=${SNMPPORT}
    ...    --snmp-community=network/huawei/wlc/snmp/slim_huawei_wlc
    ...    --snmp-timeout=1
    ...    ${extra_options}
 
    Ctn Run Command And Check Result As Strings    ${command}    ${expected_result}

    Examples:        tc     extra_options                                                                                                                             expected_result    --
            ...      1      --filter-name='Anonymized 015'                                                                                                            OK: access point 'Anonymized 015' run state: up, radio package error rate: 0.00%, radio noise: -95 dBm, radio channel utilization rate: 13.00%, radio channel interference rate: 6.00%, radio channel receive rate: 0 b/s, radio channel send rate: 523000 b/s | 'Anonymized 015#ap.radio.packageerror.percentage'=0.00%;;;; 'Anonymized 015#ap.radio.noise.dbm'=-95dBm;;;; 'Anonymized 015#ap.radio.channel.utilization.percentage'=13.00%;;;; 'Anonymized 015#ap.radio.channel.interference.percentage'=6.00%;;;; 'Anonymized 015#ap.radio.receive.bitspersecond'=0b/s;;;; 'Anonymized 015#ap.radio.send.bitspersecond'=523000b/s;;;;
            ...      2      --filter-counters="" --filter-name='Anonymized 015'                                                                                       OK: access point 'Anonymized 015' run state: up, radio package error rate: 0.00%, radio noise: -95 dBm, radio channel utilization rate: 13.00%, radio channel interference rate: 6.00%, radio channel receive rate: 0 b/s, radio channel send rate: 523000 b/s | 'Anonymized 015#ap.radio.packageerror.percentage'=0.00%;;;; 'Anonymized 015#ap.radio.noise.dbm'=-95dBm;;;; 'Anonymized 015#ap.radio.channel.utilization.percentage'=13.00%;;;; 'Anonymized 015#ap.radio.channel.interference.percentage'=6.00%;;;; 'Anonymized 015#ap.radio.receive.bitspersecond'=0b/s;;;; 'Anonymized 015#ap.radio.send.bitspersecond'=523000b/s;;;;
            ...      3      --filter-name='Anonymized 015'                                                                                                            OK: access point 'Anonymized 015' run state: up, radio package error rate: 0.00%, radio noise: -95 dBm, radio channel utilization rate: 13.00%, radio channel interference rate: 6.00%, radio channel receive rate: 0 b/s, radio channel send rate: 523000 b/s | 'Anonymized 015#ap.radio.packageerror.percentage'=0.00%;;;; 'Anonymized 015#ap.radio.noise.dbm'=-95dBm;;;; 'Anonymized 015#ap.radio.channel.utilization.percentage'=13.00%;;;; 'Anonymized 015#ap.radio.channel.interference.percentage'=6.00%;;;; 'Anonymized 015#ap.radio.receive.bitspersecond'=0b/s;;;; 'Anonymized 015#ap.radio.send.bitspersecond'=523000b/s;;;;
            ...      4      --filter-address='' --filter-name='Anonymized 015'                                                                                        OK: access point 'Anonymized 015' run state: up, radio package error rate: 0.00%, radio noise: -95 dBm, radio channel utilization rate: 13.00%, radio channel interference rate: 6.00%, radio channel receive rate: 0 b/s, radio channel send rate: 523000 b/s | 'Anonymized 015#ap.radio.packageerror.percentage'=0.00%;;;; 'Anonymized 015#ap.radio.noise.dbm'=-95dBm;;;; 'Anonymized 015#ap.radio.channel.utilization.percentage'=13.00%;;;; 'Anonymized 015#ap.radio.channel.interference.percentage'=6.00%;;;; 'Anonymized 015#ap.radio.receive.bitspersecond'=0b/s;;;; 'Anonymized 015#ap.radio.send.bitspersecond'=523000b/s;;;;
            ...      5      --filter-group="" --filter-name='Anonymized 075'                                                                                          OK: access point 'Anonymized 075' run state: up, radio package error rate: 0.00%, radio noise: -95 dBm, radio channel utilization rate: 1.00%, radio channel interference rate: 0.00%, radio channel receive rate: 0 b/s, radio channel send rate: 0 b/s | 'Anonymized 075#ap.radio.packageerror.percentage'=0.00%;;;; 'Anonymized 075#ap.radio.noise.dbm'=-95dBm;;;; 'Anonymized 075#ap.radio.channel.utilization.percentage'=1.00%;;;; 'Anonymized 075#ap.radio.channel.interference.percentage'=0.00%;;;; 'Anonymized 075#ap.radio.receive.bitspersecond'=0b/s;;;; 'Anonymized 075#ap.radio.send.bitspersecond'=0b/s;;;;
            ...      6      --warning-status='\\\%{runstate}' --filter-name='Anonymized 030'                                                                          WARNING: access point 'Anonymized 030' run state: up | 'Anonymized 030#ap.radio.packageerror.percentage'=0.00%;;;; 'Anonymized 030#ap.radio.noise.dbm'=-94dBm;;;; 'Anonymized 030#ap.radio.channel.utilization.percentage'=14.00%;;;; 'Anonymized 030#ap.radio.channel.interference.percentage'=15.00%;;;; 'Anonymized 030#ap.radio.receive.bitspersecond'=0b/s;;;; 'Anonymized 030#ap.radio.send.bitspersecond'=0b/s;;;;
            ...      7      --critical-status='\\\%{runstate} ne "up"' --filter-name='Anonymized 010'                                                                 OK: access point 'Anonymized 010' run state: up, radio package error rate: 0.00%, radio noise: -95 dBm, radio channel utilization rate: 44.00%, radio channel interference rate: 2.00%, radio channel receive rate: 1813000 b/s, radio channel send rate: 38528000 b/s | 'Anonymized 010#ap.radio.packageerror.percentage'=0.00%;;;; 'Anonymized 010#ap.radio.noise.dbm'=-95dBm;;;; 'Anonymized 010#ap.radio.channel.utilization.percentage'=44.00%;;;; 'Anonymized 010#ap.radio.channel.interference.percentage'=2.00%;;;; 'Anonymized 010#ap.radio.receive.bitspersecond'=1813000b/s;;;; 'Anonymized 010#ap.radio.send.bitspersecond'=38528000b/s;;;;
            ...      8      --warning-package-error-rate=0 --critical-package-error-rate=100 --filter-name='Anonymized 010'                                           OK: access point 'Anonymized 010' run state: up, radio package error rate: 0.00%, radio noise: -95 dBm, radio channel utilization rate: 44.00%, radio channel interference rate: 2.00%, radio channel receive rate: 1813000 b/s, radio channel send rate: 38528000 b/s | 'Anonymized 010#ap.radio.packageerror.percentage'=0.00%;0:0;0:100;; 'Anonymized 010#ap.radio.noise.dbm'=-95dBm;;;; 'Anonymized 010#ap.radio.channel.utilization.percentage'=44.00%;;;; 'Anonymized 010#ap.radio.channel.interference.percentage'=2.00%;;;; 'Anonymized 010#ap.radio.receive.bitspersecond'=1813000b/s;;;; 'Anonymized 010#ap.radio.send.bitspersecond'=38528000b/s;;;;
            ...      9      --warning-noise=1 --critical-noise=2 --filter-name='Anonymized 010'                                                                       CRITICAL: access point 'Anonymized 010' radio noise: -95 dBm | 'Anonymized 010#ap.radio.packageerror.percentage'=0.00%;;;; 'Anonymized 010#ap.radio.noise.dbm'=-95dBm;0:1;0:2;; 'Anonymized 010#ap.radio.channel.utilization.percentage'=44.00%;;;; 'Anonymized 010#ap.radio.channel.interference.percentage'=2.00%;;;; 'Anonymized 010#ap.radio.receive.bitspersecond'=1813000b/s;;;; 'Anonymized 010#ap.radio.send.bitspersecond'=38528000b/s;;;;
            ...      10     --warning-channel-utilization-rate=0 --critical-channel-utilization-rate=10 --filter-name='Anonymized 000'                                WARNING: access point 'Anonymized 000' radio channel utilization rate: 2.00% | 'Anonymized 000#ap.radio.packageerror.percentage'=1.00%;;;; 'Anonymized 000#ap.radio.noise.dbm'=-95dBm;;;; 'Anonymized 000#ap.radio.channel.utilization.percentage'=2.00%;0:0;0:10;; 'Anonymized 000#ap.radio.channel.interference.percentage'=0.00%;;;; 'Anonymized 000#ap.radio.receive.bitspersecond'=5000b/s;;;; 'Anonymized 000#ap.radio.send.bitspersecond'=306000b/s;;;;
            ...      11     --warning-channel-interference-rate='10' --critical-channel-interference-rate='0' --filter-name='Anonymized 000'                          OK: access point 'Anonymized 000' run state: up, radio package error rate: 1.00%, radio noise: -95 dBm, radio channel utilization rate: 2.00%, radio channel interference rate: 0.00%, radio channel receive rate: 5000 b/s, radio channel send rate: 306000 b/s | 'Anonymized 000#ap.radio.packageerror.percentage'=1.00%;;;; 'Anonymized 000#ap.radio.noise.dbm'=-95dBm;;;; 'Anonymized 000#ap.radio.channel.utilization.percentage'=2.00%;;;; 'Anonymized 000#ap.radio.channel.interference.percentage'=0.00%;0:10;0:0;; 'Anonymized 000#ap.radio.receive.bitspersecond'=5000b/s;;;; 'Anonymized 000#ap.radio.send.bitspersecond'=306000b/s;;;;
            ...      12     --warning-receive-rate=0 --critical-receive-rate=0 --filter-name='Anonymized 001'                                                         CRITICAL: access point 'Anonymized 001' radio channel receive rate: 86000 b/s | 'Anonymized 001#ap.radio.packageerror.percentage'=0.00%;;;; 'Anonymized 001#ap.radio.noise.dbm'=-95dBm;;;; 'Anonymized 001#ap.radio.channel.utilization.percentage'=4.00%;;;; 'Anonymized 001#ap.radio.channel.interference.percentage'=0.00%;;;; 'Anonymized 001#ap.radio.receive.bitspersecond'=86000b/s;0:0;0:0;; 'Anonymized 001#ap.radio.send.bitspersecond'=1487000b/s;;;;
            ...      13     --warning-send-rate=0 --critical-send-rate=0 --filter-name='Anonymized 000'                                                               CRITICAL: access point 'Anonymized 000' radio channel send rate: 306000 b/s | 'Anonymized 000#ap.radio.packageerror.percentage'=1.00%;;;; 'Anonymized 000#ap.radio.noise.dbm'=-95dBm;;;; 'Anonymized 000#ap.radio.channel.utilization.percentage'=2.00%;;;; 'Anonymized 000#ap.radio.channel.interference.percentage'=0.00%;;;; 'Anonymized 000#ap.radio.receive.bitspersecond'=5000b/s;;;; 'Anonymized 000#ap.radio.send.bitspersecond'=306000b/s;0:0;0:0;;