
# Corporate CLAs

An archive of the signers of Corporate Contributor License Agreements (CCLA).
Approved employees of these companies were permitted to contribute to Chef
projects.

## From the Paper CLA Era (Prior to 2014-06-12)

Prior to June 2014, employees were approved by being listed on the schedule A of
the Corporate CLA.

| **Number:** | **Company:**                           | **Date:** |
|:------------|:---------------------------------------|:----------|
|  1          |  Opscode                               |           |
|  2          |  Engine Yard                           |  1/7/09   |
|  3          |  Wikia                                 |           |
|  4          |  Aptana                                |  2/12/09  |
|  5          |  CleanOffer                            |  3/2/09   |
|  6          |  37signals                             |  3/4/09   |
|  7          |  Nomitor                               |  3/9/09   |
|  8          |  We Go To 12                           |  4/30/09  |
|  9          |  Plus2 Pty                             |  5/8/09   |
|  10         |  Phusion                               |  6/22/09  |
|  11         |  Rightscale                            |  6/30/09  |
|  12         |  Rubaidh                               |  7/27/09  |
|  13         |  Peritor GmbH                          |  8/12/09  |
|  14         |  Heroku                                |  8/13/09  |
|  15         |  Internet Exchange                     |  9/22/09  |
|  16         |  Betfair                               |  9/30/09  |
|  17         |  Sojern                                |  11/2/09  |
|  18         |  Runa                                  |  12/20/09 |
|  19         |  MaxMedia                              |  1/11/10  |
|  20         |  Quantifind                            |  2/11/10  |
|  21         |  VMware                                |  2/11/10  |
|  22         |  Rackspace                             |  2/26/10  |
|  23         |  Leaway Enterprise                     |  3/16/10  |
|  24         |  Bueda                                 |  3/30/10  |
|  25         |  Divergent Logic                       |  5/3/10   |
|  26         |  Basho Technologies                    |  5/4/10   |
|  27         |  Seven Scale                           |  5/13/10  |
|  28         |  IglooNET                              |  5/21/10  |
|  29         |  Freistil Consulting                   |  5/25/10  |
|  30         |  Promet Solutions                      |  5/25/10  |
|  31         |  Mint Digital                          |  6/16/10  |
|  32         |  Picklive                              |  6/16/10  |
|  33         |  42 Lines                              |  6/27/10  |
|  34         |  Wildfire Interactiv                   |  7/9/10   |
|  35         |  Dynamic Network Services              |  7/21/10  |
|  36         |  PeerPong                              |  8/4/10   |
|  37         |  domainfactory GmbH                    |  8/16/10  |
|  38         |  Tecnh                                 |  8/17/10  |
|  39         |  9Summer                               |  9/9/10   |
|  40         |  Wixpress                              |  9/13/10  |
|  41         |  Blue Box Group                        |  9/29/10  |
|  42         |  FindsYou Limited                      |  10/6/10  |
|  43         |  Highgroove Studios                    |  10/25/10 |
|  44         |  ZeStuff                               |  10/28/10 |
|  45         |  Worlize                               |  10/28/10 |
|  46         |  Automated Labs                        |  11/3/10  |
|  47         |  Estately                              |  11/4/10  |
|  48         |  Kapoq                                 |  11/10/10 |
|  49         |  Openminds                             |  11/10/10 |
|  50         |  MobileCause                           |  11/10/10 |
|  51         |  Atalanta Systems                      |  11/14/10 |
|  52         |  Menue Americas                        |  11/17/10 |
|  53         |  Sociable Limited                      |  12/1/10  |
|  54         |  Nine Summer                           |  12/6/10  |
|  55         |  Neo Technology                        |  1/27/11  |
|  56         |  Moriz GmbH                            |  2/2/11   |
|  57         |  AegisCo                               |  2/14/11  |
|  58         |  SetJam                                |  2/15/11  |
|  59         |  Tippr                                 |  2/18/11  |
|  60         |  Ning                                  |  2/24/11  |
|  61         |  Workday                               |  3/12/11  |
|  62         |  7digital                              |  3/3/11   |
|  63         |  PagerDuty                             |  3/17/11  |
|  64         |  Gnowsis                               |  3/25/11  |
|  65         |  Unboxed Consulting                    |  4/1/11   |
|  66         |  CustomInk                             |  4/8/11   |
|  67         |  TalentBox                             |  4/25/11  |
|  68         |  Wavii                                 |  4/29/11  |
|  69         |  Datadog                               |  5/4/11   |
|  70         |  Viximo                                |  5/10/11  |
|  71         |  ZephirWorks                           |  5/11/11  |
|  72         |  Dell                                  |  5/12/11  |
|  73         |  Newsweek/Daily Beast Company          |  5/19/11  |
|  74         |  WordStream                            |  5/19/11  |
|  75         |  Flagbit                               |  6/14/11  |
|  76         |  Applications Online                   |  6/17/11  |
|  77         |  Versapay                              |  7/5/11   |
|  78         |  DigiTar                               |  7/19/11  |
|  79         |  DreamHost                             |  7/21/11  |
|  80         |  Edmunds.com                           |  7/22/11  |
|  81         |  Every Ware                            |  7/25/11  |
|  82         |  Ask.com                               |  8/1/11   |
|  83         |  bring.out doo Sarajevo                |  8/11/11  |
|  84         |  Kos Media                             |  8/15/11  |
|  85         |  reallyenglish.com                     |  8/15/11  |
|  86         |  Fewbytes                              |  8/18/11  |
|  87         |  Business Intelligence Associates      |  8/19/11  |
|  88         |  Tacit Knowledge                       |  8/22/11  |
|  89         |  Zenexity                              |  8/30/11  |
|  90         |  ClassDo                               |  8/30/11  |
|  91         |  Myplanet                              |  9/2/11   |
|  92         |  ihiji                                 |  9/16/11  |
|  93         |  "Port 80 Productions, LLC"            |  10/28/11 |
|  94         |  Green Alto                            |  11/2/11  |
|  95         |  "Heavy Water Software, Inc."          |  11/4/11  |
|  96         |  Wealthfront Inc.                      |  11/15/11 |
|  97         |  "Kickstarter, Inc."                   |  11/18/11 |
|  98         |  Webtrends Inc                         |  11/22/11 |
|  99         |  "Infochimps, Inc."                    |  11/28/11 |
|  100        |  "Cycle Computing, LLC"                |  11/29/11 |
|  101        |  "Ubalo, Inc"                          |  12/8/11  |
|  102        |  "SweetSpot Diabetes Care, Inc."       |  12/12/11 |
|  103        |  "RideCharge, Inc."                    |  12/15/11 |
|  104        |  "Riot Games, Inc."                    |  12/15/11 |
|  105        |  Fiksu                                 |  12/21/11 |
|  106        |  WhitePages Inc.                       |  1/3/12   |
|  107        |  "CX, Inc."                            |  1/12/12  |
|  108        |  Spoke Software                        |  1/15/12  |
|  109        |  Xforty Technologies                   |  1/25/12  |
|  110        |  "Democracy Works, Inc"                |  1/30/12  |
|  111        |  "Pure Lake Software, Inc."            |  2/10/12  |
|  112        |  Sveriges Television AB                |  2/14/12  |
|  113        |  Reaktor Innovations                   |  2/14/12  |
|  114        |  "Oxygen Cloud, Inc."                  |  2/14/12  |
|  115        |  Robojar Pty Ltd                       |  2/17/12  |
|  116        |  Green and Secure IT Limited           |  2/19/12  |
|  117        |  ModCloth                              |  2/23/12  |
|  118        |  Joyent                                |  2/29/12  |
|  119        |  "Wallrazor, Inc."                     |  3/4/12   |
|  120        |  "Cerner Innovation, Inc."             |  3/8/12   |
|  121        |  "Numenta, Inc."                       |  3/27/12  |
|  122        |  Kotiri Software Ltd.                  |  4/3/12   |
|  123        |  "The Frontside Software, Inc."        |  4/5/12   |
|  124        |  "Needle, Inc."                        |  4/5/12   |
|  125        |  "Gap, Inc."                           |  4/10/12  |
|  126        |  Youscribe                             |  4/11/12  |
|  127        |  Deutsche Telekom Laboratories         |  4/17/12  |
|  128        |  "Relevance, Inc."                     |  4/20/12  |
|  129        |  Truer Sound LLC                       |  4/20/12  |
|  130        |  Websym Technologies Private Ltd.      |  4/30/12  |
|  131        |  DreamBox Learning Inc                 |  5/3/12   |
|  132        |  Simple                                |  5/7/12   |
|  133        |  "Consumer Club, Inc"                  |  5/10/12  |
|  134        |  Onddo Labs                            |  5/18/12  |
|  135        |  CyberAgent Corp.                      |  5/22/12  |
|  136        |  SourceIndex IT-Services               |  6/7/12   |
|  137        |  "Scribd, Inc."                        |  6/15/12  |
|  138        |  Civolution BV                         |  6/18/12  |
|  139        |  Drillinginfo                          |  6/18/12  |
|  140        |  NaviNet                               |  6/20/12  |
|  141        |  "Voxel Dot Net, Inc"                  |  6/26/12  |
|  142        |  Asbury Theological Seminary           |  6/27/12  |
|  143        |  The Cloudscaling Group                |  6/27/12  |
|  144        |  "Creationline, Inc."                  |  6/27/12  |
|  145        |  "Action Verb, LLC"                    |  7/10/12  |
|  146        |  Iugu Servicos na Internet LTDA        |  7/11/12  |
|  147        |  OpeniT                                |  7/18/12  |
|  148        |  Cloudreach Limited                    |  7/24/12  |
|  149        |  Bonnier Corporation                   |  7/25/12  |
|  150        |  "OneHealth Solutions, Inc."           |  7/25/12  |
|  151        |  Hewlett-Packard                       |  7/26/12  |
|  152        |  Paydici Corp.                         |  7/26/12  |
|  153        |  "Novell, Inc."                        |  8/1/12   |
|  154        |  Schuberg Phillis B.V.                 |  8/3/12   |
|  155        |  RelatelIQ Inc.                        |  8/3/12   |
|  156        |  HomeMade Digital Ltd                  |  8/7/12   |
|  157        |  "PrimeRevenue, Inc"                   |  8/10/12  |
|  158        |  Calxeda                               |  8/14/12  |
|  159        |  Big Cartel LLC                        |  8/17/12  |
|  160        |  Atlassian                             |  8/27/12  |
|  161        |  One Connect Limited                   |  9/7/12   |
|  162        |  Sonian Inc                            |  9/8/12   |
|  163        |  The App Business                      |  9/19/12  |
|  164        |  "Pat Deegan, PhD & Associates, LLC"   |  9/26/12  |
|  165        |  OmniTI                                |  9/26/12  |
|  166        |  "Cloudant, Inc."                      |  10/5/12  |
|  167        |  ZestFinance                           |  10/8/12  |
|  168        |  Firebelly Design                      |  10/8/12  |
|  169        |  Nu Echo                               |  10/16/12 |
|  170        |  OpenConcept Consulting Inc.           |  10/18/12 |
|  171        |  Apptentive                            |  10/20/12 |
|  172        |  "Document Swarm, LLC"                 |  10/20/12 |
|  173        |  "Tilting @, LLC"                      |  10/29/12 |
|  174        |  "Sift Science, Inc"                   |  10/31/12 |
|  175        |  FluxSauce                             |  11/1/12  |
|  176        |  Rocket Internet GmbH                  |  11/2/12  |
|  177        |  Coding-Knight LTD                     |  11/6/12  |
|  178        |  Tapp                                  |  11/13/12 |
|  179        |  Taqtiqa LLC                           |  11/14/12 |
|  180        |  "Nordstrom, Inc"                      |  11/15/12 |
|  181        |  Daptiv Solutions LLC                  |  11/26/12 |
|  182        |  Lime Pepper Ltd                       |  11/28/12 |
|  183        |  "Straydog Software, Inc."             |  11/29/12 |
|  184        |  "Fidelity Technology Group, LLC"      |  12/6/12  |
|  185        |  "Angelweb, Unipessoal Lda."           |  12/14/12 |
|  186        |  bcs kommunikationslosungen            |  12/17/12 |
|  187        |  "North County Tech Center, LLC"       |  12/22/12 |
|  188        |  Emergent One                          |  1/9/13   |
|  189        |  Ninefold Pty Limited                  |  1/9/13   |
|  190        |  DecisionDesk                          |  1/13/13  |
|  191        |  Belly Inc                             |  1/15/13  |
|  192        |  cloudbau Gmbh                         |  1/18/13  |
|  193        |  ActBlue Technical Services            |  1/18/13  |
|  194        |  HiganWorks LLC                        |  1/22/13  |
|  195        |  Ontario Systems                       |  1/23/13  |
|  196        |  "Lytro, Inc."                         |  1/23/13  |
|  197        |  Grupa Allegro Sp. z o.o.              |  1/31/13  |
|  198        |  Workday Inc.                          |  2/5/13   |
|  199        |  "Atlas Digital, LLC"                  |  2/6/13   |
|  200        |  Intoximeters                          |  2/15/13  |
|  201        |  Airbnb                                |  2/17/13  |
|  202        |  Valtech AB                            |  2/20/13  |
|  203        |  AWeber Communications                 |  2/25/13  |
|  204        |  adesso mobile solutions GmbH          |  3/4/13   |
|  205        |  "Banno, LLC"                          |  3/5/13   |
|  206        |  AboutUs                               |  3/8/13   |
|  207        |  "Google, Inc"                         |  3/14/13  |
|  208        |  cloudControl GmbH                     |  3/21/13  |
|  209        |  Springest                             |  3/25/13  |
|  210        |  Criteo                                |  3/26/13  |
|  211        |  "Thinking Phone Networks, Inc."       |  4/8/13   |
|  212        |  Evolving Web Inc                      |  4/11/13  |
|  213        |  BinaryBabel OSS                       |  4/17/13  |
|  214        |  Tout Industries                       |  4/18/13  |
|  215        |  "Lookout, Inc."                       |  4/22/13  |
|  216        |  Recorded Future Inc                   |  4/23/13  |
|  217        |  Irrational Industries                 |  5/1/13   |
|  218        |  "Socrata, Inc"                        |  5/1/13   |
|  219        |  "Aspera, Inc"                         |  5/1/13   |
|  220        |  "Hadapt, Inc"                         |  5/3/13   |
|  221        |  Moncai                                |  5/7/13   |
|  222        |  IBM                                   |  5/14/13  |
|  223        |  Yahoo Inc.                            |  5/14/13  |
|  224        |  Texas A&M University College of Arch. |  5/20/13  |
|  225        |  MoPub                                 |  5/21/13  |
|  226        |  "Onelogin, Inc"                       |  5/24/13  |
|  227        |  Yola                                  |  5/28/13  |
|  228        |  CopperEgg                             |  5/28/13  |
|  229        |  "MeetMe, Inc"                         |  5/30/13  |
|  230        |  Boadree Innovations Kft.              |  6/17/13  |
|  231        |  "Bitium, inc"                         |  6/21/13  |
|  232        |  Heart of Sales LLC DBA Ace of Sales   |  7/4/13   |
|  233        |  NetSrv Consulting Ltd                 |  7/7/13   |
|  234        |  "AURIN Project"                       |  7/11/13  |
|  235        |  Onlife Health Inc                     |  7/17/13  |
|  236        |  Roblox Inc.                           |  7/17/13  |
|  237        |  "Taos Mountain, Inc"                  |  7/24/13  |
|  238        |  CoreMedia AG                          |  7/31/13  |
|  239        |  "PROS, Inc. a Delaware Corporation"   |  8/14/13  |
|  240        |  Identive Group                        |  8/21/13  |
|  241        |  University of Derby                   |  8/22/13  |
|  242        |  TeamSnap                              |  8/29/13  |
|  243        |  Social Ally Pty Ltd                   |  8/29/13  |
|  244        |  Ecodev Sarl                           |  9/9/13   |
|  245        |  kreuzwerker GmbH                      |  9/18/13  |
|  246        |  Central Desktop                       |  9/18/13  |
|  247        |  Siili Solutions                       |  9/19/13  |
|  248        |  Twiket LTD                            |  9/23/13  |
|  249        |  Cloudsoft                             |  9/25/13  |
|  250        |  MYOB NZ Limited                       |  9/26/13  |
|  251        |  Mollie B.V.                           |  9/30/13  |
|  252        |  Unbounce                              |  10/1/13  |
|  253        |  Shutl Ltd.                            |  10/2/13  |
|  254        |  Rapid7                                |  10/7/13  |
|  255        |  "Our Film Festival, Inc (dba Fandor)" |  10/7/13  |
|  256        |  "Ooyala, Inc."                        |  10/9/13  |
|  257        |  Squaremouth Inc                       |  10/10/13 |
|  258        |  Optiflows                             |  10/11/13 |
|  259        |  General Sensing LTD                   |  10/10/13 |
|  260        |  Deployable LTD                        |  10/22/13 |
|  261        |  Klarna                                |  10/23/13 |
|  262        |  "Nike, Inc."                          |  10/25/13 |
|  263        |  SoundCloud Ltd.                       |  11/5/13  |
|  264        |  Project Florida                       |  11/5/13  |
|  265        |  Intuit                                |  11/6/13  |
|  266        |  ComputeNext                           |  11/6/13  |
|  267        |  The Weather Companies                 |  11/8/13  |
|  268        |  PTC Inc                               |  11/13/13 |
|  269        |  RamTank Inc                           |  11/19/13 |
|  270        |  GoCardless                            |  11/24/13 |
|  271        |  ZANOX AG                              |  11/30/13 |
|  272        |  ARINC                                 |  12/3/13  |
|  273        |  Lockheed Martin Corporation           |  12/3/13  |
|  274        |  Brightcove                            |  12/16/13 |
|  275        |  "Sprint.ly, Inc"                      |  12/27/13 |
|  276        |  Cramer Development                    |  1/10/14  |
|  277        |  "BlackBerry, Inc."                    |  1/20/14  |
|  278        |  Cerner Innovation Inc                 |  2/6/14   |
|  279        |  Cerner Innovation Inc                 |  2/11/14  |
|  280        |  Engine Yard                           |  2/12/14  |
|  281        |  Crux Hosted Services                  |  2/18/14  |
|  282        |  Blue Spurs                            |  2/24/14  |
|  283        |  GitLab.com                            |  3/1/14   |
|  284        |  Yelp                                  |  3/7/14   |
|  285        |  Workday                               |  3/10/14  |
|  286        |  BMC Software Inc                      |  3/13/14  |
|  287        |  Itison                                |  3/14/14  |
|  288        |  "OnBeep, Inc."                        |  3/19/14  |
|  289        |  Level 11 Consulting                   |  3/19/14  |
|  290        |  Linaro Limited                        |  4/4/14   |
|  291        |  Spanlink Communications               |  4/17/14  |
|  292        |  "WESEEK, Inc"                         |  4/29/14  |
|  293        |  "Iniqa UK, Ltd"                       |  6/4/14   |
|  294        |  Jemstep                               |  6/13/14  |

## From the Supermarket CCLA Era (from 2014-06-12 to 2016-10-03)

Many organizations signed the CCLA again in Supermarket.

| Company:                                     | Date:      |
|:---------------------------------------------|:-----------|
| PayPal, Inc.                                 | 2014-06-12 |
| FullStack                                    | 2014-06-17 |
| OnBeep, Inc.                                 | 2014-06-17 |
| Orion Labs, Inc.                             | 2014-06-17 |
| Ngineered                                    | 2014-06-17 |
| Brightcove, Inc                              | 2014-06-19 |
| Belly, Inc.                                  | 2014-06-19 |
| OneHealth Solutions, Inc.                    | 2014-06-19 |
| EverTrue, Inc.                               | 2014-06-23 |
| Central Desktop                              | 2014-06-23 |
| HiganWorks LLC                               | 2014-06-26 |
| adesso mobile solutions GmbH                 | 2014-06-27 |
| Express42                                    | 2014-06-29 |
| Onddo Labs                                   | 2014-07-01 |
| Codaptive (Pty) Ltd                          | 2014-07-01 |
| Sean Porter Consulting                       | 2014-07-02 |
| Klarna AB                                    | 2014-07-03 |
| a Committee of Lunatics, LLC                 | 2014-07-03 |
| Moriz GmbH                                   | 2014-07-08 |
| TCN Inc                                      | 2014-07-09 |
| JetThoughts LLC                              | 2014-07-09 |
| Clodo                                        | 2014-07-10 |
| Openhood "Halter & Tron" S.E.N.C.            | 2014-07-10 |
| grincom                                      | 2014-07-10 |
| Facebook                                     | 2014-07-11 |
| Bluedog Operations                           | 2014-07-11 |
| Spanlink Communications                      | 2014-07-11 |
| Heartland Payment Systems                    | 2014-07-13 |
| Ooyala                                       | 2014-07-14 |
| Deveo                                        | 2014-07-14 |
| Schuberg Philis B.V.                         | 2014-07-14 |
| Engine Yard, Inc.                            | 2014-07-14 |
| FancyGuy Technologies                        | 2014-07-15 |
| Mojo Lingo LLC                               | 2014-07-15 |
| Bally Technologies                           | 2014-07-16 |
| Rackspace                                    | 2014-07-16 |
| Jemstep Inc.                                 | 2014-07-16 |
| Heavy Water                                  | 2014-07-16 |
| Rstudio, Inc.                                | 2014-07-17 |
| BlackBerry Ltd.                              | 2014-07-17 |
| ffuenf                                       | 2014-07-19 |
| Grantbow Consulting                          | 2014-07-22 |
| O'Reilly Media                               | 2014-07-23 |
| Revinate, Inc.                               | 2014-07-24 |
| PHutchins                                    | 2014-07-24 |
| AdREM Systems                                | 2014-07-24 |
| Deutsche Telekom HBS                         | 2014-07-24 |
| Ticketmaster                                 | 2014-07-26 |
| chewbacco                                    | 2014-07-28 |
| Ontario Systems                              | 2014-07-28 |
| CoreMedia AG                                 | 2014-07-29 |
| Democracy Works, Inc.                        | 2014-07-29 |
| EITA                                         | 2014-07-29 |
| GitLab B.V.                                  | 2014-07-30 |
| Bloomberg LP                                 | 2014-07-30 |
| MTA SZTAKI                                   | 2014-07-31 |
| Travis Warlick LLC                           | 2014-07-31 |
| Cerner Corporation                           | 2014-07-31 |
| Texas A&M University                         | 2014-08-01 |
| Granicus, Inc.                               | 2014-08-01 |
| Splunk Inc.                                  | 2014-08-05 |
| ThirdWave Insights LLC                       | 2014-08-05 |
| OurTownRentals.com                           | 2014-08-05 |
| Intoximeters, Inc                            | 2014-08-05 |
| Seges                                        | 2014-08-07 |
| Pixl8 Interactive Ltd                        | 2014-08-08 |
| Gazelle                                      | 2014-08-08 |
| Takipi                                       | 2014-08-12 |
| De Marque                                    | 2014-08-14 |
| Web Man d.o.o.                               | 2014-08-17 |
| Picabit                                      | 2014-08-26 |
| Widgit Software                              | 2014-08-26 |
| Bitcellar, Inc.                              | 2014-08-27 |
| Yelp Inc                                     | 2014-08-27 |
| TORCH GmbH                                   | 2014-08-28 |
| McKesson                                     | 2014-08-28 |
| pronetics                                    | 2014-09-01 |
| Numergy                                      | 2014-09-03 |
| EveryPay AS                                  | 2014-09-09 |
| Appriss, Inc.                                | 2014-09-09 |
| Claude Tech                                  | 2014-09-10 |
| Omise.co                                     | 2014-09-11 |
| Criteo S.A.                                  | 2014-09-11 |
| TelVue Corporation                           | 2014-09-11 |
| Expedia                                      | 2014-09-15 |
| EBSCO                                        | 2014-09-22 |
| SAP                                          | 2014-09-26 |
| inGenerator Ltd                              | 2014-09-29 |
| WWWH LLC                                     | 2014-09-30 |
| RapidWorkspace                               | 2014-10-04 |
| Monomono                                     | 2014-10-08 |
| Nordstrom                                    | 2014-10-10 |
| InfoLens, Inc.                               | 2014-10-13 |
| Webhippie                                    | 2014-10-13 |
| IBM                                          | 2014-10-13 |
| Xhost Australia                              | 2014-10-14 |
| Simulmedia, Inc                              | 2014-10-14 |
| Mypaulie                                     | 2014-10-15 |
| SUSE LINUX Products GmbH                     | 2014-10-15 |
| Yahoo                                        | 2014-10-17 |
| Juniper Networks, Inc.                       | 2014-10-19 |
| Bulletproof Networks                         | 2014-10-20 |
| fd                                           | 2014-10-20 |
| Norman Joyner                                | 2014-10-21 |
| TJSoftworks                                  | 2014-10-21 |
| Sneacho                                      | 2014-10-22 |
| Ecodev                                       | 2014-10-30 |
| Stack-up                                     | 2014-11-02 |
| Scalingo                                     | 2014-11-03 |
| Covario                                      | 2014-11-12 |
| Xpanxion                                     | 2014-11-12 |
| Schrodinger, Inc.                            | 2014-11-14 |
| SK Planet                                    | 2014-11-18 |
| jubianchi                                    | 2014-11-18 |
| Médiamétrie                                  | 2014-11-19 |
| Terra Firma Engineering, LLC                 | 2014-11-19 |
| Pantheon                                     | 2014-11-20 |
| Clogeny Technologies                         | 2014-11-21 |
| DigiTar Inc.                                 | 2014-11-22 |
| Second Mind                                  | 2014-11-25 |
| Localytics                                   | 2014-11-25 |
| Anerhan                                      | 2014-12-05 |
| Treasure Data, Inc.                          | 2014-12-06 |
| Yakara Ltd                                   | 2014-12-09 |
| CirrusMio                                    | 2014-12-10 |
| phutchins.com                                | 2014-12-12 |
| removeme                                     | 2014-12-15 |
| Sumo Logic                                   | 2014-12-18 |
| Conjur Inc                                   | 2014-12-31 |
| PMSIpilot                                    | 2015-01-05 |
| INSANEWORKS,LLC                              | 2015-01-06 |
| Mad13 Entertainment                          | 2015-01-06 |
| Tautt                                        | 2015-01-10 |
| AddThis                                      | 2015-01-12 |
| DreamBox Learning, Inc.                      | 2015-01-14 |
| Intel                                        | 2015-01-15 |
| OptiShot Golf                                | 2015-01-16 |
| RightScale                                   | 2015-01-16 |
| Yahoo Japan                                  | 2015-01-19 |
| My company                                   | 2015-01-19 |
| OSC Technologies, LLC                        | 2015-01-21 |
| Aniessh Sethh                                | 2015-01-28 |
| Motorcycle Industry Council                  | 2015-01-30 |
| Icinga                                       | 2015-02-02 |
| pseudomuto                                   | 2015-02-03 |
| CloudOps Inc.                                | 2015-02-07 |
| Magemaven                                    | 2015-02-09 |
| eVision Industry Software                    | 2015-02-09 |
| AIRFRANCE / KLM                              | 2015-02-12 |
| Elyxor, Inc                                  | 2015-02-17 |
| Coderico                                     | 2015-02-19 |
| PagerDuty                                    | 2015-02-23 |
| Stratalux                                    | 2015-02-25 |
| Barricade Security Systems, Ltd.             | 2015-02-25 |
| TpT                                          | 2015-02-27 |
| RevelOps Inc                                 | 2015-03-04 |
| Standard Edge                                | 2015-03-04 |
| Qwinix Technologies                          | 2015-03-05 |
| CREATIONLINE,INC.                            | 2015-03-09 |
| Google, Inc.                                 | 2015-03-09 |
| yetu AG                                      | 2015-03-10 |
| Target                                       | 2015-03-11 |
| Cisco Systems                                | 2015-03-16 |
| sshilarnav                                   | 2015-03-16 |
| Vista Higher Learning, Inc.                  | 2015-03-19 |
| Dynamic Network Services Inc.                | 2015-03-19 |
| Cars.com                                     | 2015-03-20 |
| left-left-lemma Oy                           | 2015-03-22 |
| Carbonite                                    | 2015-03-23 |
| Sum Labs, Inc                                | 2015-03-24 |
| Batch.com                                    | 2015-03-24 |
| Mindera                                      | 2015-03-30 |
| ClouDesire                                   | 2015-03-31 |
| Mudbug Media                                 | 2015-04-02 |
| Oregon State University Open Source Lab      | 2015-04-03 |
| SPINEN                                       | 2015-04-08 |
| Needle, Inc.                                 | 2015-04-10 |
| Calastone Ltd                                | 2015-04-15 |
| Pixid Design                                 | 2015-04-17 |
| Devloft Solutions, Inc.                      | 2015-04-27 |
| Mingalar SAS                                 | 2015-04-28 |
| Latta Partners                               | 2015-04-30 |
| HPE                                          | 2015-05-01 |
| acquantia.me                                 | 2015-05-01 |
| ViaSat, Inc.                                 | 2015-05-04 |
| Light Side                                   | 2015-05-05 |
| Ingenium Group, LTD                          | 2015-05-11 |
| Linux-Help.org                               | 2015-05-13 |
| Alert Logic, Inc.                            | 2015-05-22 |
| Resivaa Technologies Pvt LTD                 | 2015-05-22 |
| Gap Inc                                      | 2015-05-22 |
| PayByPhone Technologies                      | 2015-05-25 |
| University of Derby                          | 2015-05-27 |
| Blue Spurs                                   | 2015-06-02 |
| Citrix Systems, Inc.                         | 2015-06-02 |
| hevnly                                       | 2015-06-10 |
| Cvent                                        | 2015-06-10 |
| Jonathan Serafini                            | 2015-06-16 |
| ExecOnline                                   | 2015-06-18 |
| NCR                                          | 2015-06-18 |
| ServeBox SAS                                 | 2015-06-19 |
| neowiz games                                 | 2015-06-22 |
| newsdict                                     | 2015-06-25 |
| Loom Technology                              | 2015-06-30 |
| Spanning Cloud Apps                          | 2015-06-30 |
| DualSpark                                    | 2015-07-01 |
| MariaDB USA                                  | 2015-07-07 |
| Shopify Inc                                  | 2015-07-08 |
| Yola                                         | 2015-07-09 |
| Divergent Logic                              | 2015-07-11 |
| Roboheart, Inc.                              | 2015-07-14 |
| Scoutapp                                     | 2015-07-20 |
| Continuous S.A.                              | 2015-07-20 |
| Room 118 Solutions, Inc.                     | 2015-07-21 |
| Devialab                                     | 2015-07-28 |
| Asana                                        | 2015-07-29 |
| CSAA IG                                      | 2015-08-05 |
| Ed Powell                                    | 2015-08-06 |
| Expedia Affiliate Network                    | 2015-08-07 |
| Tacit Knowledge                              | 2015-08-11 |
| Layer7 Cache                                 | 2015-08-13 |
| The Buckle, Inc                              | 2015-08-13 |
| Serveraptor                                  | 2015-08-27 |
| Imagination Technologies Ltd.                | 2015-08-27 |
| Ecosia GmbH                                  | 2015-08-28 |
| Aeode                                        | 2015-08-31 |
| Forever Oceans Corporation                   | 2015-09-01 |
| Flugel.it                                    | 2015-09-04 |
| TechM                                        | 2015-09-08 |
| Diego                                        | 2015-09-08 |
| Tarak Blah                                   | 2015-09-10 |
| CustomInk                                    | 2015-09-15 |
| LightSpeed Retail                            | 2015-09-20 |
| Humance AG                                   | 2015-09-21 |
| Crossroads Foundation Limited                | 2015-09-29 |
| Cyber Dev Team                               | 2015-10-02 |
| FCL                                          | 2015-10-02 |
| Marchex, Inc.                                | 2015-10-06 |
| S4M                                          | 2015-10-07 |
| PhishMe                                      | 2015-10-13 |
| Travis CI GmbH                               | 2015-10-17 |
| mikeroySoft                                  | 2015-10-23 |
| NDP, LLC                                     | 2015-10-30 |
| None                                         | 2015-11-02 |
| Lodestone Technologies, LLC                  | 2015-11-04 |
| LimePoint Pty Ltd                            | 2015-11-05 |
| echohack                                     | 2015-11-12 |
| AIB                                          | 2015-11-16 |
| NativeX Holdings LLC                         | 2015-11-17 |
| Cloudrifles                                  | 2015-11-20 |
| Secureworks                                  | 2015-11-20 |
| Taufek                                       | 2015-11-22 |
| BuyerQuest, Inc.                             | 2015-11-25 |
| The Weather Companies                        | 2015-12-03 |
| Monsenso                                     | 2015-12-07 |
| Formatron                                    | 2015-12-10 |
| Fidelity Investments                         | 2015-12-10 |
| DataCite                                     | 2015-12-14 |
| Parallels                                    | 2015-12-17 |
| Wavefront, Inc.                              | 2015-12-30 |
| Trust1Team                                   | 2016-01-01 |
| Nulogy Corporation                           | 2016-01-07 |
| Salmon                                       | 2016-01-08 |
| Flexiant                                     | 2016-01-12 |
| COSProfessionals, LLC                        | 2016-01-14 |
| Bellacross Technologies, LLC                 | 2016-01-18 |
| Relenz                                       | 2016-01-18 |
| REĀN Cloud Solutions LLC                     | 2016-01-18 |
| LyraPhase                                    | 2016-01-18 |
| Tikal Knowledge, SAP                         | 2016-01-19 |
| CloudPassage                                 | 2016-01-20 |
| Topota                                       | 2016-01-21 |
| Sebastian Trebitz - ICT Consultancy Services | 2016-01-21 |
| AOL                                          | 2016-01-22 |
| Dennis Vink                                  | 2016-01-22 |
| Datadog Inc.                                 | 2016-01-26 |
| Jason Barnett                                | 2016-02-02 |
| Built by Robots                              | 2016-02-02 |
| 7digital                                     | 2016-02-05 |
| NewVoiceMedia Ltd                            | 2016-02-05 |
| dkd Internet Service GmbH                    | 2016-02-08 |
| Dylan Ledbetter                              | 2016-02-09 |
| Mikroways                                    | 2016-02-13 |
| Grassmuck.co                                 | 2016-02-13 |
| Postmodern Solutions                         | 2016-02-14 |
| Rally Health                                 | 2016-02-19 |
| PolicyStat LLC                               | 2016-02-19 |
| Pivotal Labs                                 | 2016-02-22 |
| Code.org                                     | 2016-02-23 |
| Underground Media Group                      | 2016-02-23 |
| Rakuten Inc.                                 | 2016-02-26 |
| ENC4U                                        | 2016-03-01 |
| Mediarithmics                                | 2016-03-07 |
| Planalytics                                  | 2016-03-11 |
| IT Projections Limited                       | 2016-03-14 |
| ShoreTel Inc.                                | 2016-03-17 |
| Apparently                                   | 2016-03-18 |
| TraSec GmbH                                  | 2016-03-21 |
| B1 Systems GmbH                              | 2016-03-22 |
| Beyah Solutions, LLC                         | 2016-03-24 |
| Inetsys SL                                   | 2016-03-30 |
| Instabug                                     | 2016-04-07 |
| Anaplan                                      | 2016-04-25 |
| ForeFlight LLC                               | 2016-04-25 |
| Hydra Technologies, Inc                      | 2016-04-28 |
| Gengo                                        | 2016-05-11 |
| Crifkin Amalgamated LLC                      | 2016-05-11 |
| Crifkin Amalgamated LLC                      | 2016-05-11 |
| Vision Critical                              | 2016-05-16 |
| iJet Technologies                            | 2016-05-17 |
| SendGrid, Inc.                               | 2016-05-18 |
| Mulesoft                                     | 2016-05-29 |
| Shopify                                      | 2016-06-13 |
| The Regents of the University of Colorado    | 2016-06-28 |
| Tampere University of Technology             | 2016-07-01 |
| Altiscale                                    | 2016-07-01 |
| Atlas Digital                                | 2016-07-05 |
| Fastly                                       | 2016-07-12 |
| cloud.ee OÜ                                  | 2016-07-26 |
| Hostelworld                                  | 2016-07-28 |
| Wazuh                                        | 2016-07-28 |
| Arista Networks                              | 2016-08-10 |
| Totem Power, Inc.                            | 2016-08-13 |
| Piratenpartei Deutschland                    | 2016-08-20 |
| Testfabrik AG                                | 2016-09-01 |
| B7Interactive, LLC                           | 2016-09-06 |
| PolyHat                                      | 2016-09-07 |
| Aaron's, Inc.                                | 2016-09-07 |
| SWB company                                  | 2016-09-09 |
| Nclouds Inc.                                 | 2016-09-12 |
| DataMetis                                    | 2016-09-12 |
| nclouds                                      | 2016-09-13 |
| Personnal                                    | 2016-09-15 |
| Soltius NZ                                   | 2016-09-16 |
| Primar Group                                 | 2016-09-26 |
| Gannett                                      | 2016-09-26 |
| etracker GmbH                                | 2016-09-27 |
| Freelance                                    | 2016-09-28 |

# Allowed Contributors 2009 - 2016-10-93

The list of allowed contributors from 2009 through 3 October, 2016 prior to Chef
projects [moving to a Developer Certificate of Origin
process](https://blog.chef.io/2016/09/19/introducing-developer-certificate-of-origin/).
See [CONTRIBUTING](https://github.com/chef/chef/blob/master/CONTRIBUTING.md) for
how to contribute to Chef today.

Persons listed as associated with a company may also be individual contributors
as well.

1.  Adam Jacob 	 Opscode 	
1.  Andy Delcambre 	 Engineyard 	1/7/09
1.  Arjuna Christensen 	 	1/7/09
1.  Artur Bergman 	 Wikia 	
1.  Benjamin Black 	 Opscode 	1/10/09 	
1.  Bryan McLellan 	 	1/7/09 	
1.  Dan Walters 	 	3/7/09
1.  Edward Muller 	 Engineyard 	1/28/09
1.  Ezra Zygmuntowicz 	 Engineyard 	1/7/09
1.  Jason Cook 	 Wikia 	
1.  Joe Williams 	 	1/17/09
1.  Kris Rasmussen 	 Aptana 	2/12/09
1.  Lee Jensen 	 Engineyard 	1/24/09
1.  Nick Sullivan 	 Wikia 	
1.  Paul Nasrat 	 	1/19/09
1.  Pawel Rein 	 Wikia 	
1.  Przemek Malkowski 	 Wikia 	
1.  Sean Cribbs 	 	2/5/09
1.  Steve Berryman 	 	1/20/09
1.  Steven Parkes 	 Aptana 	2/12/09
1.  Thom May 	 	1/21/09
1.  Tim Dysinger 	 	1/28/09
1.  Michael Hale 	 	2/16/09
1.  Mathieu Sauve-Frankel 	 	2/22/09
1.  Matthew Landauer 	 	2/25/09
1.  John Hampton 	 CleanOffer 	3/2/09
1.  Nadeem Bitar 	 CleanOffer 	3/2/09
1.  James Gartrell 	 	2/6/09
1.  Joshua Sierles 	 37signals 	3/4/09
1.  Mark Imbriaco 	 37signals 	3/4/09
1.  Stephen Haynes 	 Nomitor 	3/9/09
1.  Yun Huang Yong 	 Nomitor 	3/9/09
1.  David Lee 	 	3/9/09
1.  Matthew Kent 	 	3/24/09
1.  Dave Myron 	 	4/3/09
1.  Miguel Cabeça 	 	8/4/09
1.  Jason Jackson 	 	4/9/09
1.  Caleb Tennis 	 	4/10/09
1.  Michael Lim 	 	4/14/09
1.  David Balatero 	 	4/28/09
1.  David Grandinetti 	 We Go To 12 	4/30/09
1.  Lachlan Cox 	 Plus2 Pty 	5/8/09
1.  Scott Likens 	 	4/30/09
1.  Andrew Willis 	 	5/25/09
1.  Hongli Lai 	 Phusion 	6/22/09
1.  Ninh Bui 	 Phusion 	6/22/09
1.  Edmund Haselwanter	cloudbau Gmbh	6/25/09
1.  Raphael Simon 	 RightScale 	6/30/09
1.  Tony Spataro 	 RightScale 	6/30/09
1.  Stéphane Crivisier 	 	6/30/09
1.  Matthew Todd 	 Highgroove Studios 	7/1/09
1.  Grant Zanetti 	 	2/1/09
1.  Peter Woodman 	 	6/22/09
1.  Daniel DeLeo 	 	7/10/09
1.  Jeppe Madsen 	 	9/13/09
1.  Cary Penniman 	 RightScale 	7/20/09
1.  J. Chris Anderson 	 	8/7/09
1.  Graeme Mathieson 	 Rubaidh 	8/10/09
1.  Mark Connell 	 Rubaidh 	8/10/09
1.  Jonathan Weiss 	 Peritor GmbH 	8/12/09
1.  Mathias Meyer 	 Peritor GmbH 	8/12/09
1.  Pedro Belo 	 Heroku 	8/13/09
1.  Ricardo Chimal Jr. 	 Heroku 	8/13/09
1.  Adam Wiggins 	 Heroku 	8/13/09
1.  Ryan Tomayko 	 Heroku 	8/13/09
1.  Blake Mizerany 	 Heroku 	8/13/09
1.  Diego Algorta 	 	
1.  Kevin Hunt 	 	8/14/09 	
1.  Sidney Burks 	 	8/20/09 	
1.  Joe Van Dyk 	 	9/1/09 	
1.  Sig Lange 	 	9/1/09 	
1.  Alexander van Zoest 	 	9/1/09 	
1.  Nathan Mueller 	 	9/7/09 	
1.  Roman Heinrich 	 	9/11/09 	
1.  Gábor Vészi 	 	9/20/09 	
1.  Kenneth Kalmer 	 Internet Exchange 	9/22/09 	
1.  Luca Greco 	 	9/22/09 	
1.  Charles Cook 	 Betfair 	9/30/09 	
1.  Mario Giammarco 	 	10/6/09 	
1.  Matthew King 	 	10/14/09 	
1.  James Golick 	 	10/27/09 	
1.  Jörn Berrisch 	 	10/28/09 	
1.  Peter Crossley 	 	10/30/09 	
1.  Eric Hankins 	 Sojern 	11/2/09 	
1.  David McRae 	 Sojern 	11/2/09 	
1.  Dan Fitch 	 Sojern 	11/2/09 	
1.  Ian Meyer 	 	11/8/09 	
1.  John Alberts 	 	11/9/09 	
1.  Lee Marlow 	 	11/11/09 	
1.  Tollef Fog Heen 	 	11/12/09 	
1.  Cuong Chi Nghiem 	 	11/13/09 	
1.  Gordon Thiesfeld 	 	11/18/09 	
1.  Dreamcat4 	 	11/21/09 	
1.  Guy Bolton King 	 	12/3/09 	
1.  Robert Berger 	 Runa 	12/20/09 	
1.  Siva Jagadeesan 	 Runa 	12/20/09 	
1.  Ivan Pirlik 	 	12/22/09 	
1.  David Abdemoulaie 	 	12/23/09 	
1.  Alex Soto 	 	12/29/09 	
1.  Bryan Helmkamp 	 	12/30/09 	
1.  Jesse Nelson 	 	1/6/10 	
1.  Seth Chisamore 	 Opscode 	1/11/10 	
1.  Alfredo Deza 	 MaxMedia 	1/11/10 	
1.  N. Alan Johnson Jr. 	 	1/15/10 	
1.  Pavel Valodzka 	 	2/8/10 	
1.  Kyle Maxwell 	 Quantifind 	2/11/10 	
1.  Doug MacEachern 	 VMware 	2/11/10 	
1.  Jan Zimmek 	 	2/14/10 	
1.  Dan Prince 	 Rackspace 	2/26/10 	
1.  Gabe Westmaas 	 Rackspace 	2/26/10 	
1.  Tim Harper 	 	3/8/10 	
1.  Renaud Chaput 	 	3/10/10 	
1.  Daniel Peterson 	 	3/11/10 	
1.  Amit Cohen 	 Leaway Enterprise 	3/16/10 	
1.  Avishai Ish-Shalom 	 Leaway Enterprise 	3/16/10 	
1.  Or Cohen 	 Leaway Enterprise 	3/16/10 	
1.  Jon Swope 	 	3/19/10 	
1.  Jonathan Tron 	 	3/19/10 	
1.  Christopher Peplin 	 Bueda 	3/30/10 	
1.  Trotter Cashion 	 	4/3/10 	
1.  Benjamin Standefer 	 	4/6/10 	
1.  P. Barrett Little 	 	4/7/10 	
1.  John Nixon 	 	4/13/10 	
1.  Bruce Krysiak 	 	4/13/10 	
1.  Akzhan Abdulin 	 	4/14/10 	
1.  Grant Rodgers 	 	4/17/10 	
1.  Wesley Beary 	 	4/22/10 	
1.  Farzad Farid 	 	4/23/10 	
1.  Olivier Raginel 	 	4/26/10 	
1.  Jacques Crocker 	 	5/3/10 	
1.  Pierre Baillet 	 	5/3/10 	
1.  Joel Merrick 	 	5/3/10 	
1.  James Sanders 	 	5/3/10 	
1.  John Goulah 	 	5/3/10 	
1.  Toomas Pelberg 	 	5/3/10 	
1.  Ceaser Larry 	 Divergent Logic 	5/3/10 	
1.  Justin Sheehy 	 Basho Technologies 	5/4/10 	
1.  Andrew Gross 	 Basho Technologies 	5/4/10 	
1.  Bryan Fink 	 Basho Technologies 	5/4/10 	
1.  Ben Mabey 	 	5/5/10 	
1.  Christopher Durtschi 	 Divergent Logic 	5/7/10 	
1.  Kevin Carter 	 Divergent Logic 	5/7/10 	
1.  Saimon Moore 	 	5/13/10 	
1.  Troy Davis 	 Seven Scale 	5/13/10 	 	
1.  Eric Lindvall 	 Seven Scale 	5/13/10 	
1.  Alexey Ivanov		5/14/10 	
1.  Pritesh Mehta 	 	5/19/10 	
1.  Ondrej Kudlik 	 IglooNET 	5/21/10 	
1.  Marek Hulan 	 IglooNET 	5/21/10 	
1.  Chad Woolley 	 	5/22/10 	
1.  Jochen Lillich 	 Freistil Consulting 	5/25/10 	
1.  Marius Ducea 	 Promet Solutions 	5/25/10 	
1.  Eric Butler 	 	5/26/10 	
1.  Sahil Cooner 	 	6/6/10 	
1.  Richard Nicholas 	 Betfair 	6/9/10 	
1.  Dan Slimmon 	 	6/10/10 	
1.  Craig Webster 	 Picklive 	6/16/10 	
1.  Dean Strelau 	 Mint Digital 	6/17/10 	
1.  Kurt Yoder 	 	6/25/10 	
1.  Jim Browne 	 42 Lines 	6/27/10 	
1.  Andrey Sibiryov 	 	7/7/10 	
1.  Anthony Newman 	 Betfair 	7/8/10 	
1.  Thomas Hoover 	 	7/8/10 	
1.  Dylan Egan 	 Wildfire Interactive 	7/9/10 	
1.  Michael Carruthers 	 Wildfire Interactive 	7/11/10 	
1.  Jon Seaberg 	 RightScale 	7/20/10 	
1.  Sean O'Meara 	 	7/20/10 	
1.  Cory von Wallenstein 	 Dynamic Network Services 	7/21/10 	
1.  Michael Leinartas 	 	7/22/10 	
1.  Thomas Bishop 	 	7/23/10 	
1.  Jon Wood 	 	7/29/10 	
1.  Dmitry Vyal 	 	8/4/10 	
1.  Gilles Devaux 	 PeerPong 	8/4/10 	
1.  Chris Pepper 	 	8/5/10 	
1.  Dennis Klein 	 	8/6/10 	
1.  Warwick Poole 	 	8/12/10 	
1.  Ken Ming Ong 	 	8/15/10 	
1.  Ash Berlin 	 	8/16/10 	
1.  Jochen Tuchbreiter 	 domainfactory GmbH 	8/16/10 	
1.  Mat Ellis 	 Tecnh 	8/17/10 	
1.  Michael MacDonald 	 	8/17/10 	
1.  Jorge Luiz deBrito Falcão 	 	8/18/10 	
1.  Jamie Winsor 	 	8/19/10 	
1.  Darrin Eden 	 	8/19/10 	
1.  Jonathan Smith 	 	8/19/10 	
1.  Andrew Fulcher 	 	8/23/10 	
1.  Matthias Marschall 	 	8/25/10 	
1.  Peter Struijk 	 	8/25/10 	
1.  Robert Anthony Postill 	 	8/28/10 	
1.  Joshua Timberman 	 Opscode 	9/6/10 	
1.  Benjamin Rockwood 	 	9/6/10 	
1.  Douglas Knight 	 	9/9/10 	
1.  Andrew Cole 	 9Summer 	9/9/10 	
1.  Dimitri Krassovski 	 Wixpress 	9/13/10 	
1.  Gregory Man 	 Wixpress 	9/13/10 	
1.  Allan Feid 	 	9/17/10 	
1.  Ringo De Smet 	 	9/26/10 	
1.  Tomasz Napierala 	 	9/27/10 	
1.  Jesse Proudman 	 Blue Box Group 	9/29/10 	
1.  Ian Parades 	 Blue Box Group 	9/29/10 	
1.  Lee Huffman 	 Blue Box Group 	9/29/10 	
1.  Christopher Horton 	 	10/1/10 	
1.  Jude Sutton 	 FindsYou Limited 	10/6/10 	
1.  James Le Cuirot 	 FindsYou Limited 	10/6/10 	
1.  Richard Pelavin 	 	10/7/10 	
1.  Blake Irvin 	ModCloth	10/8/10 	
1.  Jim Van Fleet 	 	10/14/10 	
1.  Laurent Désarmes 	 	10/14/10 	
1.  Jay T. McCanta 	 	10/15/10 	
1.  Eric G. Wolfe 	 	10/20/10 	
1.  Sami Haahtinen 	 	10/21/10 	
1.  Chris Kelly 	 Highgroove Studios 	10/25/10 	
1.  Gerald L. Hevener Jr. 	 	10/25/10 	
1.  Charles Quinn 	 Highgroove Studios 	10/25/10 	
1.  Jonathan Wallace 	 Highgroove Studios 	10/25/10 	
1.  Jason Ardell 	 	10/26/10 	
1.  Sean Carey 	 	10/27/10 	
1.  Pierre-Luc Brunet 	 ZeStuff 	10/28/10 	
1.  Sean Walbran 	 	10/28/10 	
1.  Brian McKelvey 	 Worlize 	10/28/10 	
1.  Jeffrey Hulten 	 Automated Labs 	11/3/10 	
1.  Doug Cole 	 Estately 	11/4/10 	
1.  Ben Bleything 	 Estately 	11/4/10 	
1.  Sebastian Boehm 	 	11/6/10 	
1.  Ches Martin 	 	11/8/10 	
1.  Eric C. Herot 	 	11/8/10 	
1.  Oliver Hankeln 	 	11/10/10 	
1.  David Nolan 	 Kapoq 	11/10/10 	
1.  Frank Louwers 	 Openminds 	11/10/10 	
1.  Bernard Grymonpon 	 Openminds 	11/10/10 	
1.  Bram Gillemon 	 Openminds 	11/10/10 	
1.  Paul Cortens 	 MobileCause 	11/10/10 	
1.  Austin Schneider 	 MobileCause 	11/10/10 	
1.  Kevin Ahrens 	 	11/13/10 	
1.  Stephen Nelson-Smith 	 Atalanta Systems 	11/14/10 	
1.  Caleb Groom 	 	11/16/10 	
1.  Michael Ivey 		11/17/10 	
1.  Wojciech Wnetrzak 	 	11/20/10 	
1.  Dmitriy Tkachenko 	 	11/22/10 	
1.  Filip Tepper 	 	11/24/10 	
1.  Denis Barushev 	 	11/27/10 	
1.  Pedro F. <<pancho>> Horrillo Guerra	 	11/28/10 	
1.  James Harton 	 Sociable Limited 	12/1/10 	
1.  Noah Kantrowitz 	 	12/4/10 	
1.  Anthony Burton 	 	12/4/10 	
1.  David Esposito 	 Nine Summer 	12/6/10 	
1.  Mike Lecza 	 Nine Summer 	12/6/10 	
1.  Andrew Cole 	 Nine Summer 	12/6/10 	
1.  Michael Winser 	 Nine Summer 	12/6/10 	
1.  Cory Burke 	 Nine Summer 	12/6/10 	
1.  Charles Duffy 	 Tippr 	12/7/10 	
1.  John Vincent 	 	12/10/10 	
1.  Dustin Currie 	 	12/14/10 	
1.  Mark Sonnabaum 	 	12/14/10 	
1.  Elliot Murphy 	 	12/22/10 	
1.  Laradji Nacer 	 	12/30/10 	
1.  Todd Nine 	 	1/3/11 	
1.  Elijah Wright 	 	1/5/11 	
1.  Anshul Khandelwal 	 	1/13/11 	
1.  Michael Carruthers 	 	1/16/11 	
1.  Vishvananda Ishaya 	 	1/17/11 	
1.  Scott Frazer 	 	1/17/11 	
1.  Eric Hodel 	 	1/21/11 	
1.  Eric Heydrick 	 	1/25/11 	
1.  Andreas Kollegger 	 Neo Technology 	1/27/11 	
1.  Steve Lum 	 	1/31/11 	
1.  Anthony Goddard 	 	2/1/11 	
1.  Roland Moriz 	 Moriz GmbH 	2/2/11 	
1.  Emil Sit 	 Hadapt 	2/2/11 	
1.  Ranjib Dey 	 	2/3/11 	
1.  Ryan Davis 	 	2/8/11 	
1.  Eric Coleman 	 	2/8/11 	
1.  James Casey 	 	2/9/11 	
1.  Maciej Pasternacki 	 	2/9/11 	
1.  Grzegorz Marszalek 	 	2/11/11 	
1.  James Sulinski 	 AegisCo 	2/14/11 	
1.  Erik Sabowski 	 AegisCo 	2/14/11 	
1.  Maciej Pasternacki 	 SetJam 	2/15/11 	
1.  Steven Dossett 	 Ning 	2/17/11 	
1.  Dane Knecht 	 Tippr 	2/18/11 	
1.  Mark Imbriaco 	 Heroku 	2/28/11 	
1.  Jonathan Matthews	7digital	3/3/11 	
1.  Patrick Collins 	 	3/7/11 	
1.  Jim Hopp 	 Workday 	3/12/11 	
1.  Ken Dove 	 Workday 	3/12/11 	
1.  Philip Reynolds 	 Workday 	3/12/11 	
1.  Victor Zakharyev 	 Workday 	3/12/11 	
1.  Greg Fuller 	 Workday 	3/12/11 	
1.  Michael Callahan 	 Workday 	3/15/11 	
1.  Don Norton 	 Workday 	3/15/11 	
1.  Joe Nuspl 	 Workday 	3/15/11 	
1.  Dan Thom 	 Workday 	3/15/11 	
1.  Rick Cooper 	 Workday 	3/15/11 	
1.  Patrick Debois 	 	3/14/11 	
1.  Michael Guterl 	 	3/15/11 	
1.  Andrew Miklas 	 PagerDuty 	3/17/11 	
1.  Tristan Sloughter 	 	3/22/11 	
1.  Jonathon Ramsey 	 	3/23/11 	
1.  Jesai Langenbach 	 	3/24/11 	
1.  Maciej Pasternacki 	 Gnowsis 	3/25/11 	
1.  Omri Cohen 	 	3/28/11 	
1.  Joseph Sokol-Margolis 	 	3/31/11 	
1.  Alex Tomlins 	 Unboxed Consulting 	4/1/11 	
1.  Holger Just 	 	4/5/11 	
1.  Jake Vanderdray 	 CustomInk 	4/8/11 	
1.  Nathen Harvey 	 CustomInk 	4/8/11 	
1.  Padraig O'Sullivan 	 	4/8/11 	
1.  Christian Trabold 	 	4/16/11 	
1.  KC Braunschweig 	Edmunds.com	4/19/11 	
1.  Josh Pasqualetto 	 	4/21/11 	
1.  Christopher C. Johnson 	 	4/21/11 	
1.  Christian Paredes 	 	4/22/11 	
1.  Viral Shah 	 	4/24/11 	
1.  Bradley Fritz 	 	4/24/11 	
1.  Nat Lownes 	 	4/25/11 	
1.  Jonathan Tron 	 TalentBox 	4/25/11 	
1.  Joseph Halter 	 TalentBox 	4/25/11 	
1.  Wilson Felipe Nunes Fernandes Pereira		4/27/11 	
1.  Michael Grubb		4/27/11 	
1.  Brandon Konkle		4/28/11 	
1.  Matt Griffin		4/28/11 	
1.  Anh K. Huynh		4/28/11 	
1.  Erik Frey	Wavii	4/29/11 	
1.  Spike Gronim	Wavii	4/29/11 	
1.  Ian MacLeod	Wavii	4/29/11 	
1.  Guido Bartolucci	Wavii	4/29/11 	
1.  Fletcher Nichol		5/3/11 	
1.  James Kane	7digital	5/4/11 	
1.  Paul Richards	7digital	5/4/11 	
1.  Alexis Le-Quoc	Datadog	5/4/11 	
1.  Matthew Singleton	Datadog	5/4/11 	
1.  Carlo Cabanilla	Datadog	5/4/11 	
1.  Olivier Pomel	Datadog	5/4/11 	
1.  Fabrice Ollivier	Datadog	5/4/11 	
1.  Matt Griffin	Viximo	5/10/11 	
1.  Chris Chiodo	Viximo	5/10/11 	
1.  Adam Bell	Viximo	5/10/11 	
1.  Sergio Rubio		5/10/11 	
1.  Elmer Rivera		5/10/11 	
1.  Andrea Campi	ZephirWorks	5/11/11 	
1.  Andrea Carlo Granata	ZephirWorks	5/11/11 	
1.  Marco Pierleoni	ZephirWorks	5/11/11 	
1.  Pietro Giorgianni	ZephirWorks	5/11/11 	
1.  Jesse Newland		5/11/11 	
1.  Greg Swallow		5/12/11 	
1.  Scott Jensen	Dell	5/12/11 	
1.  Greg Althaus	Dell	5/12/11 	
1.  Andi Abes	Dell	5/12/11 	
1.  Rob Hirschfeld	Dell	5/12/11 	
1.  Paul Webster	Dell	5/12/11 	
1.  Mitchell Hashimoto		5/12/11 	
1.  Jamie van Dyke		5/17/11 	
1.  Vladimir Kozhukalov		5/18/11 	
1.  Nathan Butler	Newsweek/Daily Beast Company	5/19/11 	
1.  Ken Garland	Newsweek/Daily Beast Company	5/19/11 	
1.  Michael Yankovski	WordStream	5/19/11 	
1.  Augusto Becciu		5/19/11 	
1.  Greg Albrecht		5/19/11 	
1.  Eric James Buth		5/24/11 	
1.  Dan Porter		5/24/11 	
1.  Adrian Silva	Atalanta Systems	5/25/11 	
1.  Spike Morelli	Atalanta Systems	5/25/11 	
1.  Paul Nicholson		5/27/11 	
1.  Mandi Walls		5/27/11 	
1.  Carl Perry	DreamHost	5/29/11 	
1.  Greg Thornton		5/30/11 	
1.  Joseph Heck		6/1/11 	
1.  Charles Ray Johnson, Jr.		6/2/11 	
1.  Joseph Anthony Pasquale Holsten		6/5/11 	
1.  John Donagher		6/6/11 	
1.  David Fuhr	Flagbit 	6/14/11 	
1.  Jörg Weller	Flagbit	6/14/11 	
1.  Marcel Cary		6/15/11 	
1.  Yedidya "Jay" Feldblum	Applications Online	6/17/11 	
1.  Michael Contento		6/20/11 	
1.  Yogesh Pathade		6/22/11 	
1.  Gavin Sandie		6/25/11 	
1.  Bryan Horstmann-Allen		6/28/11 	
1.  Glenn Pratt		7/5/11 	
1.  Andrew Narkewicz	Versapay	7/5/11 	
1.  Zachary Tomas Stevens		7/11/11 	
1.  Richard Gould		7/11/11 	
1.  Philip Cohen		7/15/11 	
1.  Christopher Michael McClimans		7/18/11 	
1.  Jason J.W. Williams		7/19/11 	
1.  Nuo Yan		7/21/11 	
1.  Jaroslaw Śmiejczak		7/25/11 	
1.  Dimitri Aivaliotis	Every Ware	7/25/11 	
1.  Eric Rochester		7/27/11 	
1.  Alex North-Keys	Tippr	7/29/11 	
1.  Adam Knight	Tippr	7/29/11 	
1.  Eugene Wood	Ask.com	8/1/11 	
1.  Aron Bartling	Ask.com	8/1/11 	
1.  Jack Francis	Ask.com	8/1/11 	
1.  Richard Marshall	Ask.com	8/1/11 	
1.  Mikola Kucharski	Ask.com	8/1/11 	
1.  Rory Mitchell	Ask.com	8/3/11 	
1.  Oskar Stolc	Ask.com	8/3/11 	
1.  Jack (John) Roehrig	Ask.com	8/3/11 	
1.  Paul Stahlke	Ask.com	8/3/11 	
1.  Jorge Mazzei	Ask.com	8/3/11 	
1.  Pakojo Samm	Ask.com	8/3/11 	
1.  David Smith	Ask.com	8/3/11 	
1.  Mike Adolphs		8/5/11 	
1.  Ernad Husremović	bring.out doo Sarajevo	8/11/11 	
1.  Jasmin Beganović	bring.out doo Sarajevo	8/11/11 	
1.  Saša Vranić	bring.out doo Sarajevo	8/11/11 	
1.  Šator Emir	bring.out doo Sarajevo	8/11/11 	
1.  Jeremy Bingham	Kos Media	8/15/11 	
1.  Michael Taras	Kos Media	8/15/11 	
1.  Tomoyuki Sakurai	reallyenglish.com	8/15/11 	
1.  Mitsuru Yoshida	reallyenglish.com	8/15/11 	
1.  Avishai Ish-Shalom	Fewbytes	8/18/11 	
1.  Or Cohen	Fewbytes	8/18/11 	
1.  Domenico Delle Side		8/19/11 	
1.  Paul Morton	Business Intelligence Associates	8/19/11 	
1.  Phil Austin	Business Intelligence Associates	8/19/11 	
1.  Andrian Jardan		8/22/11 	
1.  Vladimir Girnet	Tacit Knowledge	8/22/11 	
1.  Scott Askew	Tacit Knowledge	8/22/11 	
1.  Emmett Finneran		8/26/11 	
1.  Arthur Gautier	Zenexity	8/30/11 	
1.  Edward Middleton	ClassDo	8/30/11 	
1.  Michael Pearson		8/31/11 	
1.  Nikolay Sturm		9/1/11 	
1.  Nathan Lloyd Smith		9/1/11 	
1.  Patrick Connolly	Myplanet	9/2/11 	
1.  Yashar Rassoulli	Myplanet	9/2/11 	
1.  James Walker	Myplanet	9/2/11 	
1.  Chris Read		9/6/11 	
1.  Prashant Srivastava		9/7/11 	
1.  Brad Knowles	ihiji	9/16/11 	
1.  Stuart Rench	ihiji	9/16/11 	
1.  Michael Maniscalco	ihiji	9/16/11 	
1.  Brian Cunnie		9/19/11 	
1.  Joseph F. Reynolds		9/20/11 	
1.  Gabriel McArthur		9/21/11 	
1.  David Keith Hudgins		9/21/11 	
1.  Paul MacDougall		9/23/11 	
1.  Bulat Shakirzyanov		9/23/11 	
1.  Jorge Eduardo Espada		9/28/11 	
1.  Eric Dennis		9/28/11 	
1.  Stuart Glenn		9/29/11 	
1.  Bryan Wilson Berry		10/4/11 	
1.  Christopher Sturm		10/5/11 	
1.  John Sumsion		10/12/11 	
1.  Steven Phung		10/13/11 	
1.  Claudio Cesar Sanchez Tejeda		10/14/11 	
1.  Igor Afonov		10/26/11 	
1.  Dan Buettner	Port 80 Production, LLC	10/28/11 	
1.  Robby Grossman		10/31/11 	
1.  Alan Harper		11/1/11 	
1.  Juanje Ojeda		11/1/11 	
1.  Stephane Jourdan	Green Alto	11/2/11 	
1.  Gregory Karekinian	Green Alto	11/2/11 	
1.  Samuel Maftoul	Green Alto	11/2/11 	
1.  Darrin Eden	Heavy Water Software, Inc.	11/4/11 	
1.  Sean Escriva	Heavy Water Software, Inc.	11/4/11 	
1.  Jake Davis	Heavy Water Software, Inc.	11/4/11 	
1.  AJ Christensen	Heavy Water Software, Inc.	11/4/11 	
1.  Michael Weinberg	Heavy Water Software, Inc.	11/4/11 	
1.  Aaron Baer	Heavy Water Software, Inc.	11/4/11 	
1.  Matthew Kanwisher		11/8/11 	
1.  Joshua McKenty		11/9/11 	
1.  Iulian-Corneliu Costan		11/11/11 	
1.  Daniel Oliver		11/14/11 	
1.  Adam Garside		11/15/11 	
1.  Ian Wolfcat Atha	Wealthfront Inc.	11/15/11 	
1.  John Hitchings	Wealthfront Inc.	11/15/11 	
1.  David Fortunato	Wealthfront Inc.	11/15/11 	
1.  Julien Wetterwald	Wealthfront Inc.	11/15/11 	
1.  Kevin Peterson	Wealthfront Inc.	11/15/11 	
1.  Maksim Horbul		11/16/11 	
1.  Roberto Gaiser		11/16/11 	
1.  Robert Di Marco		11/17/11 	
1.  Victor Lowther	Dell	11/17/11 	
1.  Jerry Chen		11/18/11 	
1.  Murali Raju		11/18/11 	
1.  Benjamin Smith		11/18/11 	
1.  Aaron Suggs	Kickstarter, Inc.	11/18/11 	
1.  Lance Ivy	Kickstarter, Inc.	11/18/11 	
1.  Cedric Howe	Kickstarter, Inc.	11/18/11 	
1.  Tieg Zaharia	Kickstarter, Inc.	11/18/11 	
1.  Teemu Matilainen	Reaktor Innovations	11/22/11 	
1.  Dave Solbes	Webtrends Inc	11/22/11 	
1.  Grant Hutchins		11/25/11 	
1.  Eric Saxby	ModCloth	11/27/11 	
1.  Gabriel Evans		11/27/11 	
1.  Tim Smith	Webtrends Inc	11/28/11 	
1.  Nathaniel Eliot	Infochimps, Inc	11/28/11 	
1.  Adam Seever	Infochimps, Inc	11/28/11 	
1.  Travis Dempsey	Infochimps, Inc	11/28/11 	
1.  Dhruv Bansal	Infochimps, Inc	11/28/11 	
1.  Andrew Kaczorek	Cycle Computing, LLC	11/29/11 	
1.  Chris Chalfant	Cycle Computing, LLC	11/29/11 	
1.  Dan Harris	Cycle Computing, LLC	11/29/11 	
1.  Ian Alderman	Cycle Computing, LLC	11/29/11 	
1.  Stephen Balukoff		11/30/11 	
1.  Kendrick Martin	Webtrends Inc	12/1/11 	
1.  Adnan Wahab		12/3/11 	
1.  Alex Howells		12/4/11 	
1.  Cameron Johnston	Needle, Inc.	12/5/11 	
1.  Justin Huff		12/8/11 	
1.  Ian Downes	Ubalo, Inc	12/8/11 	
1.  Erik Hollensbe		12/9/11 	
1.  Karel Minarik		12/11/11 	
1.  Adam Greene	SweetSpot Diabetes Care, Inc.	12/12/11 	
1.  Justin Schumacher	SweetSpot Diabetes Care, Inc.	12/12/11 	
1.  Dan Root	SweetSpot Diabetes Care, Inc.	12/12/11 	
1.  Paul Dowman		12/12/11 	
1.  Andrew Le		12/12/11 	
1.  Paul Welch		12/13/11 	
1.  Harlan Barnes		12/13/11 	
1.  Philip Kates	Rackspace US, Inc	12/13/11 	
1.  Brandon Philips	Rackspace US, Inc	12/13/11 	
1.  Paul Querna	Rackspace US, Inc	12/13/11 	
1.  Arthur Pirogovski		12/13/11 	
1.  John Scott Sanders, Jr	RideCharge, Inc	12/15/11 	
1.  Jamie Winsor	Riot Games	12/15/11 	
1.  Josiah Kiehl	Riot Games	12/15/11 	
1.  Jesse Howarth	Riot Games	12/15/11 	
1.  Michael Matsuuara	Riot Games	12/15/11 	
1.  Cliff Dickerson	Riot Games	12/15/11 	
1.  Philip Gollucci	RideCharge, Inc	12/15/11 	
1.  Radim Marek		12/17/11 	
1.  Hugo Fichter		12/19/11 	
1.  Chris Christensen		12/20/11 	
1.  Chet Luther		12/20/11 	
1.  Mark Luntzel		12/20/11 	
1.  Kevin Karwaski	Fiksu	12/21/11 	
1.  David Calavera		12/22/11 	
1.  Michael Stillwell		12/23/11 	
1.  Aaron Bull Schaefer		12/28/11 	
1.  Max Rabin		1/3/12 	
1.  Michael Bradshaw	WhitePages Inc.	1/3/12 	
1.  Michael Cook	WhitePages Inc.	1/3/12 	
1.  Jack Foy	WhitePages Inc.	1/3/12 	
1.  Devin Ben-Hur	WhitePages Inc.	1/3/12 	
1.  Jeff Bellegarde	WhitePages Inc.	1/3/12 	
1.  John Dyer		1/4/12 	
1.  Sam Marx		1/5/12 	
1.  Praveen Arimbrathodiyil		1/6/12 	
1.  Joshua Buysse		1/6/12 	
1.  Dale Hui		1/6/12 	
1.  Jesse Campbell		1/8/12 	
1.  Roberto Carlos Morano		1/9/12 	
1.  Miah Johnson	Scribd, Inc. 	1/10/12 	
1.  Ian Delahorne		1/12/12 	
1.  Mike Javorski	Spoke Software	1/15/12 	
1.  Michael A. Fiedler		1/16/12 	
1.  Luis Bosque		1/16/12 	
1.  Qiming He		1/18/12 	
1.  Hector Castro		1/19/12 	
1.  Wade Warren	Wikia	1/23/12 	
1.  Geoff Papilion	Wikia	1/23/12 	
1.  Justin Ryan	Wikia	1/23/12 	
1.  David King	Xforty Technologies	1/25/12 	
1.  Christian Pearce	Xforty Technologies	1/25/12 	
1.  Andrew Libby	Xforty Technologies	1/25/12 	
1.  Joshua Hou		1/27/12 	
1.  Alice Kaerast		1/28/12 	
1.  Brett Hoerner		1/28/12 	
1.  Jon-Erik Schneiderhan		1/30/12 	
1.  Wes Morgan	Democracy Works, Inc	1/30/12 	
1.  Ernie Brodeur		1/31/12 	
1.  Stephen Figgins		1/31/12 	
1.  Tal Rotbart		2/1/12 	
1.  Benjamin Lindsey		2/1/12 	
1.  Markus Schirp		2/1/12 	
1.  Tryn Mirell		2/2/12 	
1.  Hari Krishna Dara		2/7/12 	
1.  Andrew Grangaard		2/8/12 	
1.  Adam Mielke		2/8/12 	
1.  Andrew Allan		2/9/12 	
1.  Antonio Soares de Azevedo Terceiro		2/9/12 	
1.  Istvan Szukacs		2/9/12 	
1.  Brian Parker	Pure Lake Software, Inc.	2/10/12 	
1.  Sean Porter		2/10/12 	
1.  William Carroll		2/12/12 	
1.  Paul Diaconescu	Sveriges Television AB	2/14/12 	
1.  Jonas Eklof	Sveriges Television AB	2/14/12 	
1.  Per Bjorn	Sveriges Television AB	2/14/12 	
1.  Frank Hoffsumer	Sveriges Television AB	2/14/12 	
1.  Samppa Kytomaki	Reaktor Innovations	2/14/12 	
1.  Zuhaib Siddique	Atlassian	2/14/12 	
1.  Andrew Robson	Oxygen Cloud, Inc.	2/14/12 	
1.  Aaron Follette	Oxygen Cloud, Inc.	2/14/12 	
1.  Erik Bakker		2/16/12 	
1.  David Golden		2/16/12 	
1.  Jacques Chester	Robojar Pty Ltd	2/17/12 	
1.  Nicholas VINOT		2/18/12 	
1.  Matthew MacDonald-Wallace		2/19/12 	
1.  Andrew Gross		2/20/12 	
1.  Andrew Fecheyr Lippins		2/21/12 	
1.  Shoaib Kamil		2/21/12 	
1.  Martin Vidner		2/23/12 	
1.  Jake Ritorto	ModCloth	2/23/12 	
1.  Seth Kingry	ModCloth	2/23/12 	
1.  Manuel Gutierrez	ModCloth	2/23/12 	
1.  Graham McMillan	World Wide Web Hosting, LLC	2/24/12 	
1.  Nicholas Stielau		2/24/12 	
1.  McClain Looney		2/24/12 	
1.  Jim Meyer		2/29/12 	
1.  Trevor Orsztynowicz	Joyent	2/29/12 	
1.  Kevin Chang	Joyent	2/29/12 	
1.  Geoffery Nix	ModCloth	3/1/12 	
1.  Roberto Sanchez	ModCloth	3/1/12 	
1.  Dan Buch	ModCloth	3/1/12 	
1.  Ziad Sawalha	Rackspace	3/2/12 	
1.  Benedikt Böhm		3/4/12 	
1.  Steven Ivy	Wallrazer, Inc.	3/4/12 	
1.  Krzysztof Wilczynski		3/5/12 	
1.  Elson Orlando Rodriguez		3/5/12 	
1.  Michael Schubert		3/5/12 	
1.  Douglas Thrift	Rightscale	3/5/12 	
1.  Andrew Benz		3/6/12 	
1.  Yann Robin	Youscribe	3/6/12 	
1.  Javier Frias		3/6/12 	
1.  Josh Miller	Edmunds.com	3/6/12 	
1.  Moritz Winter		3/6/12 	
1.  Aaron Blythe	Cerner Innovation, Inc.	3/8/12 	
1.  Kevin Shekleton	Cerner Innovation, Inc.	3/8/12 	
1.  Josh Murphy	Cerner Innovation, Inc.	3/8/12 	
1.  Bryan Baugher	Cerner Innovation, Inc.	3/8/12 	
1.  Sachin Sagar Ra		3/8/12 	
1.  Tarik Jabri		3/8/12 	
1.  Michael W. Myers		3/10/12 	
1.  Marcus Cobden		3/11/12 	
1.  Coimbatore Sankarraman Shyam Sundar		3/12/13 	
1.  Chris Roberts	Heavy Water Software, Inc.	3/13/12 	
1.  Justin Mazzi	World Wide Web Hosting, LLC	3/13/12 	
1.  Joshua Priddle	World Wide Web Hosting, LLC	3/13/12 	
1.  Paul Stengel	World Wide Web Hosting, LLC	3/13/12 	
1.  Vince Stratful	World Wide Web Hosting, LLC	3/13/12 	
1.  Artem Veremey		3/13/12 	
1.  Jon Cowie		3/15/12 	
1.  Philip Kromer	Infochimps, Inc	3/17/12 	
1.  Ben Dean		3/18/12 	
1.  Zachary Cook		3/19/12 	
1.  Welby McRoberts		3/20/12 	
1.  Ian Coffey	Voxel Dot Net, Inc	3/20/12 	
1.  David Amian Valle		3/21/12 	
1.  Lewis J. Goettner, III		3/21/12 	
1.  Bernardo Gomez Palacio 		3/23/12 	
1.  Chris Gaffney 		3/23/12 	
1.  Igor Kurochkin		3/24/12 	
1.  Oleksiy Kovyrin 		3/24/12 	
1.  Jordan Dea-Mattson	Numenta, Inc.	3/26/12 	
1.  Cody Ebberson	Numenta, Inc.	3/27/12 	
1.  Martin Hasan Bramwell		3/28/12 	
1.  Mohammed Siddick		3/28/12 	
1.  Ira Abramaov	Fewbytes	3/29/12 	
1.  Paul McCallick		3/29/12 	
1.  Jon-Paul Sullivan	Hewlett-Packard	3/30/12 	
1.  Sascha Bates		3/30/12 	
1.  Julian Cardona	Edmunds.com	4/2/12 	
1.  David Hudson	Edmunds.com	4/2/12 	
1.  Andrew Crump	Kotiri Software Ltd.	4/3/12 	
1.  Zach Dunn		4/5/12 	
1.  Logan Lowell	The Frontside Software, Inc.	4/5/12 	
1.  Charles Lowell	The Frontside Software, Inc.	4/5/12 	
1.  Chris Buben		4/5/12 	
1.  Joseph Brian Passavanti		4/5/12 	
1.  Denis Barishev		4/6/12 	
1.  Jonas Courteau		4/6/12 	
1.  Eric Hankins		4/10/12 	
1.  Chris Buben	Gap, Inc.	4/10/12 	
1.  Oliver Fross	Gap, Inc.	4/10/12 	
1.  Jeffery Padgett	Gap, Inc.	4/10/12 	
1.  Philip Vieira		4/10/12 	
1.  Guilhem Lettron	Youscribe	4/11/12 	
1.  Sebastien Balant	Youscribe	4/11/12 	
1.  Robert E. Lewis		4/13/12 	
1.  David Joos		4/16/12 	
1.  Umang Chouhan		4/16/12 	
1.  Sören Blom	Deutsche Telekom Laboratories	4/17/12 	
1.  Alex Redington	Relevance, Inc.	4/20/12 	
1.  Gabriel Horner	Relevance, Inc.	4/20/12 	
1.  Lake Denman	Relevance, Inc.	4/20/12 	
1.  Larry Karnowski	Relevance, Inc./Truer Sound LLC	4/20/12 	
1.  Sam Umbach	Relevance, Inc./Truer Sound LLC	4/20/12 	
1.  Jeremiah Snapp	Asbury Theological Seminary	4/20/12 	
1.  Brian Bianco		4/20/12 	
1.  Brandon Martin		4/21/12 	
1.  Alexander Gordeev		4/24/12 	
1.  Joe Miller		4/25/12 	
1.  Nick Peirson		4/27/12 	
1.  Marc Morata Fite		4/27/12 	
1.  Seth Thomas		4/27/12 	
1.  Chris Griego		4/28/12 	
1.  Dmytro Ilchenko		4/30/12 	
1.  Morgan Nelson		4/30/12 	
1.  Chirag Jog	Websym Technologies Private Ltd.	4/30/12 	
1.  Kalpak Shah	Websym Technologies Private Ltd.	4/30/12 	
1.  Mohit Sethi	Websym Technologies Private Ltd.	4/30/12 	
1.  Kyle VanderBeek		5/2/12 	
1.  TANABE Ken-ichi		5/2/12 	
1.  Brandon Adams	DreamBox Learning, Inc.	5/3/12 	
1.  Hui Hu		5/5/12 	
1.  Will Maier	Simple	5/7/12 	
1.  Chris Brentano	Simple	5/7/12 	
1.  Cosmin Stejerean	Simple	5/7/12 	
1.  Brian Merritt	Simple	5/7/12 	
1.  Pascal Deschenes		5/8/12 	
1.  Michael Glenn		5/8/12 	
1.  Dan Crosta		5/9/12 	
1.  Daniel Condomitti		5/9/12 	
1.  Matthew Butcher		5/10/12 	
1.  Ben Poweski	Consumer Club, Inc.	5/10/12 	
1.  Chris Griego	Consumer Club, Inc.	5/10/12 	
1.  Jim Hughes	Consumer Club, Inc.	5/10/12 	
1.  Morgan Nelson	Consumer Club, Inc.	5/10/12 	
1.  Kristina Rodgers	Consumer Club, Inc.	5/10/12 	
1.  Derek Schultz		5/11/12 	
1.  Anay Nayak		5/15/12 	
1.  Patrick Ting		5/17/12 	
1.  Xabier de Zuazo Oteiza	Onddo Labs	5/18/12 	
1.  Raul Rodriguez Munoz	Onddo Labs	5/18/12 	
1.  Ramez Mourad		5/21/12 	
1.  Jonathan Manton		5/22/12 	
1.  Philipp Wollermann	CyberAgent Corp.	5/22/12 	
1.  Koji Hasebe	CyberAgent Corp.	5/22/12 	
1.  Jean-Daniel Bussy	CyberAgent Corp.	5/22/12 	
1.  Yoshihisa Sakamoto	CyberAgent Corp.	5/22/12 	
1.  Kohei Maeda	CyberAgent Corp.	5/22/12 	
1.  Eric Edgar		5/23/12 	
1.  Rodolphe Blancho		5/23/12 	
1.  Kevin Nuckolls		5/24/12 	
1.  Michael Nygard	Relevance, Inc.	5/29/12 	
1.  Martin Fenner		5/30/12 	
1.  Lukasz Kaniowski		5/31/12 	
1.  Brian Flad		5/31/12 	
1.  Justin Witrick	Rackspace	6/1/12 	
1.  Nickalaus Willever		6/1/12 	
1.  Harold "Waldo" Grunenwald III		6/4/12 	
1.  Bjorn Albers		6/4/12 	
1.  Timothy Martin Potter		6/5/12 	
1.  Greg Fitzgerald		6/6/12 	
1.  Sebastian Wendel	SourceIndex IT-Services	6/7/12 	
1.  Leif Madsen		6/7/12 	
1.  Jonathan del Strother		6/7/12 	
1.  Bernd Roth		6/8/12 	
1.  Madhurranjan Mohaan		6/11/12 	
1.  Seth Vargo		6/11/12 	
1.  Gregory Jones		6/12/12 	
1.  Joshua Brand		6/15/12 	
1.  David Stainton	Scribd, Inc.	6/15/12 	
1.  Sriram Devadas		6/17/12 	
1.  Christopher Webber		6/17/12 	
1.  Raf Geens	Civolution BV	6/18/12 	
1.  Greg Symons	Drillinginfo	6/18/12 	
1.  Clark Archer	Drillinginfo	6/18/12 	
1.  David Eddy		6/18/12 	
1.  Jonathan Hartman	Rackspace	6/21/12 	
1.  Boyd Edward Hemphill		6/21/12 	
1.  Martha Greenberg		6/24/12 	
1.  Paul Meserve		6/25/12 	
1.  Michael H. Oshita		6/25/12 	
1.  James W. Brinkerhoff	Voxel Dot Net, Inc	6/26/12 	
1.  Evan Vetere	Voxel Dot Net, Inc	6/26/12 	
1.  Kris Beevers	Voxel Dot Net, Inc	6/26/12 	
1.  Patrick Dowell	Voxel Dot Net, Inc	6/26/12 	
1.  Zachary Voase		6/26/12 	
1.  Paul Guth	The Cloudscaling Group, Inc.	6/27/12 	
1.  Rodolphe Pineau	The Cloudscaling Group, Inc.	6/27/12 	
1.  Jeremy Deininger	The Cloudscaling Group, Inc.	6/27/12 	
1.  Blake Barnett	The Cloudscaling Group, Inc.	6/27/12 	
1.  HIGUCHI Daisuke	Creationline, Inc.	6/27/12 	
1.  Jey Hotta	Creationline, Inc.	6/27/12 	
1.  Kent R. Spillner		7/6/12 	
1.  Brian Dols		7/6/12 	
1.  Frank Rosquin		7/10/12 	
1.  Bill Moritz		7/10/12 	
1.  Alfred Rossi	Action Verb, LLC	7/10/12 	
1.  Patrick Ribeiro Negri	lugu Seervicos na Internet LTDA	7/11/12 	
1.  Marcelo Paez	lugu Seervicos na Internet LTDA	7/11/12 	
1.  Alexandre Paez	lugu Seervicos na Internet LTDA	7/11/12 	
1.  Wong Liang Zan		7/11/12 	
1.  Matthew Andersen		7/12/12 	
1.  Jacob Atzen		7/13/12 	
1.  Chris Parsons		7/13/12 	
1.  Timothy Jones		7/14/12 	
1.  Ameya Prakash Gangamwar		7/15/12 	
1.  Adrien Brault		7/16/12 	
1.  Michael T. Halligan		7/17/12 	
1.  Andreas Boehrnsen	OpeniT	7/18/12 	
1.  Jay Levitt		7/20/12 	
1.  Jose Luis Fernandez Perez		7/21/12 	
1.  Aaron J. Peterson		7/22/12 	
1.  Jim Croft	Cloudreach Limited	7/24/12 	
1.  Richard Bowden	Cloudreach Limited	7/24/12 	
1.  Joe Geldart	Cloudreach Limited	7/24/12 	
1.  Bryce Lynn	Tacit Knowledge	7/24/12 	
1.  Brian Smith	Bonnier Corporation	7/25/12 	
1.  Michael Linde	Bonnier Corporation	7/25/12 	
1.  Peter Lauda	Bonnier Corporation	7/25/12 	
1.  Rakesh Patel	OneHealth Solutions, Inc.	7/25/12 	
1.  Jay Perry		7/26/12 	
1.  Mark Roddy		7/26/12 	
1.  Andrew Regan		7/26/12 	
1.  Takeshi Kondo		7/26/12 	
1.  Paul Rossman		7/26/12 	
1.  Bryan Stearns	Paydici Corp.	7/26/12 	
1.  Jim Harvey	Paydici Corp.	7/26/12 	
1.  Bill Burcham	Paydici Corp.	7/26/12 	
1.  Steve Rude		7/26/12 	
1.  Richard Clamp		7/29/12 	
1.  Christopher Kelly		7/30/12 	
1.  Deepak Kannan		7/30/12 	
1.  Roy Liu		7/31/12 	
1.  Artiom Lunev		7/31/12 	
1.  Anna Marseille D. Gabutero		7/31/12 	
1.  Lucas Jandrew	Riot Games	8/1/12 	
1.  Dafydd Crosby		8/1/12 	
1.  Christoph Thiel	Novell, Inc.	8/1/12 	
1.  Ralf Haferkamp	Novell, Inc.	8/1/12 	
1.  Adam Spiers	Novell, Inc.	8/1/12 	
1.  Tim Serong	Novell, Inc.	8/1/12 	
1.  Sascha Peilicke	Novell, Inc.	8/1/12 	
1.  Bernhard Wiedemann	Novell, Inc.	8/1/12 	
1.  Ionuts Artarisi	Novell, Inc.	8/1/12 	
1.  Vincent Untz	Novell, Inc.	8/1/12 	
1.  Martin Vidner	Novell, Inc.	8/1/12 	
1.  J. Daniel Schmidt	Novell, Inc.	8/1/12 	
1.  Stefan Fent	Novell, Inc.	8/1/12 	
1.  Danny Kukawka	Novell, Inc.	8/1/12 	
1.  Michal Vyskocil	Novell, Inc.	8/1/12 	
1.  Kristian Vlaardingerbroek	Schuberg Philis B.V.	8/3/12 	
1.  Jon Gretarsson	RelatelIQ Inc.	8/3/12 	
1.  Danial Pearce		8/5/12 	
1.  Stathis Touloumis		8/5/12 	
1.  Matthew Scott Moyer		8/7/12 	
1.  Benedict Steele		8/7/12 	
1.  James Tan	Novell, Inc.	8/7/12 	
1.  John Kip Larsen		8/8/12 	
1.  Chris Buryta		8/9/12 	
1.  Sahil Muthoo		8/10/12 	
1.  Kyle Goodwin	PrimeRevenue, Inc	8/10/12 	
1.  Ben Rosenblum	PrimeRevenue, Inc	8/10/12 	
1.  Aaron Kalin		8/10/12 	
1.  John Dewey		8/11/12 	
1.  Abel Lopez		8/13/12 	
1.  Lyndon Washington		8/14/12 	
1.  Ripal Nathuji	Calxeda	8/14/12 	
1.  Gardner Bickford		8/15/12 	
1.  Nick Heppner		8/16/12 	
1.  Jeffrey Dutton		8/16/12 	
1.  Taklon Wu		8/17/12 	
1.  Craig Tracey		8/17/12 	
1.  Lee Jensen	Big Cartel LLC	8/17/12 	
1.  Chris Cameron	Big Cartel LLC	8/17/12 	
1.  Kelley Reynolds	Big Cartel LLC	8/17/12 	
1.  Michael Wallman		8/17/12 	
1.  Edward Sargisson		8/19/12 	
1.  Winfield Peterson		8/20/12 	
1.  Mathew Davies		8/21/12 	
1.  Justin Shepherd	Rackspace	8/21/12 	
1.  Jason Cannavale	Rackspace	8/21/12 	
1.  Ron Pedde	Rackspace	8/21/12 	
1.  Joseph Breu	Rackspace	8/21/12 	
1.  William Kelly	Rackspace	8/21/12 	
1.  Darren Birkett	Rackspace	8/21/12 	
1.  Evan Callicoat	Rackspace	8/21/12 	
1.  Andrew Ferk		8/23/12 	
1.  Shaun Hope		8/23/12 	
1.  Matt Kynaston		8/24/12 	
1.  Ben Marini		8/25/12 	
1.  Garret Heaton	Atlassian	8/27/12 	
1.  Julian Dunn		8/27/12 	
1.  Jordan Evans		8/28/12 	
1.  Andrew Laski		8/31/12 	
1.  Mat Schaffer		8/31/12 	
1.  Elliot Pahl		9/3/12 	
1.  Richard Shade	Rightscale	9/5/12 	
1.  Dmytro Kovalov		9/5/12 	
1.  Shishir Das		9/6/12 	
1.  Kimball Johnson	One Connect Limited	9/7/12 	
1.  Roy Crombleholme	One Connect Limited	9/7/12 	
1.  Martin Foster	One Connect Limited	9/7/12 	
1.  Alex Klepa		9/7/12 	
1.  Brendan Hay		9/7/12 	
1.  Paul Graydon		9/7/12 	
1.  Steve Layland		9/7/12 	
1.  Thomas Dudziak		9/7/12 	
1.  Felix Sheng		9/8/12 	
1.  Sean Porter	Sonian Inc	9/8/12 	
1.  Josh Pasqualetto	Sonian Inc	9/8/12 	
1.  TJ Vanderpoel	Sonian Inc	9/8/12 	
1.  Justin Kolberg	Sonian Inc	9/8/12 	
1.  Decklin Foster	Sonian Inc	9/8/12 	
1.  Randall Morse		9/10/12 	
1.  Pete Cheslock	Dyn	9/10/12 	
1.  Max Stepanov		9/11/12 	
1.  Sean Gallagher		9/11/12 	
1.  Autif Khan		9/11/12 	
1.  Jacques Marneweck		9/12/12 	
1.  William Herry		9/16/12 	
1.  Pawel Kozlowski		9/16/12 	
1.  Lawrence Gilbert		9/18/12 	
1.  Bob Walker		9/18/12 	
1.  Nathan Schimke		9/18/12 	
1.  Graham Christensen		9/19/12 	
1.  Alessandro Dal Grande	The App Business	9/19/12 	
1.  Saager Suhas Mhatre		9/23/12 	
1.  Charles J Blaine		9/23/12 	
1.  Andres de Barbara		9/23/12 	
1.  Adam Vinsh		9/25/12 	
1.  Elliot Murphy	Pat Deegan, PhD & Associates, LLC	9/26/12 	
1.  John Nishinaga	Pat Deegan, PhD & Associates, LLC	9/26/12 	
1.  Farley Knight	Pat Deegan, PhD & Associates, LLC	9/26/12 	
1.  Jon Sime	OmniTI	9/26/12 	
1.  Clinton Wolfe	OmniTI	9/26/12 	
1.  Theo Schlossnagle	OmniTI	9/26/12 	
1.  Robert Treat	OmniTI	9/26/12 	
1.  Adam DePue		9/26/12 	
1.  Martin Contento		9/27/12 	
1.  Milos Gajdos		9/27/12 	
1.  Brad Gignac	Rackspace	9/28/12 	
1.  Robert Allen		9/30/12 	
1.  Chia-liang Kao		10/1/12 	
1.  Ketan Padegaonkar		10/2/12 	
1.  Antti Puranen	Reaktor Innovations	10/5/12 	
1.  Stephen Crawley		10/7/12 	
1.  Brad Bennet	ZestFinance	10/8/12 	
1.  Alexander Tamoykin	ZestFinance	10/8/12 	
1.  Lloyd Philbrook	Firebelly Design	10/8/12 	
1.  Nate Beaty	Firebelly Design	10/8/12 	
1.  John Skopis		10/8/12 	
1.  Susan Potter		10/8/12 	
1.  Jatinder Giri		10/10/12 	
1.  Joan Touzet	Cloudant, Inc.	10/11/12 	
1.  Kyle Allan	Riot Games	10/11/12 	
1.  Jay Pipes		10/12/12 	
1.  John Austin Page		10/15/12 	
1.  Chuck Ha		10/15/12 	
1.  David Dvorak	Webtrends	10/15/12 	
1.  Dipen Lad		10/15/12 	
1.  Pascal Deschenes	Nu Echo	10/16/12 	
1.  Matthieu Vachon	Nu Echo	10/16/12 	
1.  Raymond Menard	Nu Echo	10/16/12 	
1.  Jean-Francois Alix	Nu Echo	10/16/12 	
1.  Mariano Cortesi		10/16/12 	
1.  Alexander Phan		10/16/12 	
1.  Jeff Siegel		10/16/12 	
1.  William Milton		10/17/12 	
1.  Mark Pimentel		10/18/12 	
1.  Mike Gifford	OpenConcept	10/18/12 	
1.  Mike Mallett	OpenConcept	10/18/12 	
1.  Brian Loomis		10/20/12 	
1.  Michael Saffitz	Apptentive	10/20/12 	
1.  Andrew Wooster	Apptentive	10/20/12 	
1.  Sky Kelsey	Apptentive	10/20/12 	
1.  Benjamin Michael Atkin	Document Swarm, LLC	10/20/12 	
1.  Andreas Gerauer		10/22/12 	
1.  Steven Deaton		10/22/12 	
1.  Cassiano Bertol Leal		10/23/12 	
1.  Matt Towers		10/23/12 	
1.  Mark Ayers		10/23/12 	
1.  Anthony Leto		10/23/12 	
1.  Marc Soda		10/24/12 	
1.  Jerome D Harrington, II		10/24/12 	
1.  Russell Stewart Egan		10/24/12 	
1.  Paul Thomas		10/24/12 	
1.  Chris Lundquist		10/24/12 	
1.  Anton Orel		10/25/12 	
1.  Marius Sturm		10/25/12 	
1.  Dimitri David Boelaert-Roche		10/25/12 	
1.  Matthew Serafin Horan		10/25/12 	
1.  Vojtech Hyza		10/25/12 	
1.  Steve Houser		10/26/12 	
1.  Dmitry Zamaruev		10/29/12 	
1.  James Hu		10/29/12 	
1.  Laust Rud Jacobsen		10/29/12 	
1.  Zo Obradovic		10/29/12 	
1.  Dale Kiefling		10/29/12 	
1.  Todd Fleisher		10/29/12 	
1.  Karl Freeman		10/30/12 	
1.  Johannes Becker		10/30/12 	
1.  Fred Sadaghiani	Sift Science, Inc.	10/31/12 	
1.  Jeff Thompson		10/31/12 	
1.  Stanislav Bogatyrev		10/31/12 	
1.  Jonathan Peck	FluxSauce	11/1/12 	
1.  Jeffrey Borg		11/1/12 	
1.  Guido Serra	Rocket Internet GmbH	11/2/12 	
1.  Sebastian Grewe		11/3/12 	
1.  Chaoran Xie		11/3/12 	
1.  Julien Duponchelle		11/4/12 	
1.  Trae Robrock		11/5/12 	
1.  Nikita Borzykh		11/6/12 	
1.  Ilya Sher		11/6/12 	
1.  Michael Fischer		11/6/12 	
1.  Nathan Baxter		11/6/12 	
1.  Simon Belluzzo		11/6/12 	
1.  Ben Hartshorne		11/9/12 	
1.  Matt Whiteley	Engine Yard	11/9/12 	
1.  Raul Naveiras		11/13/12 	
1.  Eugene Wood		11/13/12 	
1.  Javier Perez-Griffo	Tapp	11/13/12 	
1.  Dang Nguyen		11/13/12 	
1.  Pablo Banos	Tapp	11/13/12 	
1.  Christian Hofer	Tapp	11/13/12 	
1.  Matthew Rogers		11/13/12 	
1.  Stephen Lauck		11/13/12 	
1.  Mark Van de Vyver	Taqtiqa LLC	11/14/12 	
1.  Thomas Carroll		11/14/12 	
1.  Jon DeCamp	Nordstrom, Inc	11/15/12 	
1.  Doug Ireton	Nordstrom, Inc	11/15/12 	
1.  Kevin Moser	Nordstrom, Inc	11/15/12 	
1.  Justin Schumacher	Nordstrom, Inc	11/15/12 	
1.  Rob Cummings	Nordstrom, Inc	11/15/12 	
1.  Brandon Burton		11/20/12 	
1.  Christopher Ferry		11/20/12 	
1.  Michael Hood		11/22/12 	
1.  Gavin Montague		11/23/12 	
1.  Michal Lomnicki		11/24/12 	
1.  Doc Walker		11/24/12 	
1.  Nicolas Szalay		11/26/12 	
1.  Terry Carr		11/26/12 	
1.  Michael Myers	Daptiv Solutions LLC	11/26/12 	
1.  Shawn Neal	Daptiv Solutions LLC	11/26/12 	
1.  Chris Bobo	Daptiv Solutions LLC	11/26/12 	
1.  Ian Gantt	Daptiv Solutions LLC	11/26/12 	
1.  Alan Gray	Daptiv Solutions LLC	11/26/12 	
1.  Kishore Kumar S		11/26/12 	
1.  Vincent Leraitre		11/27/12 	
1.  Samuel Gerstein		11/27/12 	
1.  John T Skarbek		11/27/12 	
1.  Paul A Jungwirth		11/28/12 	
1.  Thomas Hodder	Lime Pepper Ltd	11/28/12 	
1.  Warren Vosper	Straydog Software, Inc.	11/29/12 	
1.  Joshua Reedy		11/30/12 	
1.  Mehmet Ali Akmanalp		11/30/12 	
1.  Panagiotis Papadomitsos		11/30/12 	
1.  Allan Espinosa		11/30/12 	
1.  Brian Pitts		12/1/12 	
1.  Elliot Kendall		12/3/12 	
1.  Nathan Mische		12/3/12 	
1.  Matthew Turney		12/3/12 	
1.  Jay Flowers		12/4/12 	
1.  Loic Antoine-Gombeaud		12/5/12 	
1.  Joe Rodriguez		12/5/12 	
1.  Kyle Scarmardo	Fidelity Technology Group, LLC	12/6/12 	
1.  Jon Lenzer	Fidelity Technology Group, LLC	12/6/12 	
1.  Chaoran Xie	Fidelity Technology Group, LLC	12/6/12 	
1.  Shalon Wood	Fidelity Technology Group, LLC	12/6/12 	
1.  David Crane		12/6/12 	
1.  Takumi IINO		12/9/12 	
1.  Tolleiv Nietsch		12/9/12 	
1.  Benoit Caron		12/9/12 	
1.  Mathieu Martin		12/10/12 	
1.  Yung Giang		12/11/12 	
1.  Fabian Ruff		12/11/12 	
1.  Takeshi KOMIYA		12/11/12 	
1.  Rafael Fonseca		12/12/12 	
1.  Justin Campbell		12/12/12 	
1.  Andrey Subbota		12/13/12 	
1.  Jacob Ritorto		12/13/12 	
1.  Pierre Ozoux		12/14/12 	
1.  Shoaib Mushtaq		12/16/12 	
1.  Arnold Krille	bcs kommunikationslosungen	12/17/12 	
1.  Rainer Dietz	bcs kommunikationslosungen	12/17/12 	
1.  Paul Diaconescu		12/17/12 	
1.  Jake Davis	Simple	12/17/12 	
1.  Mike Ehlert	Simple	12/17/12 	
1.  Kevin Bringard		12/19/12 	
1.  David Whittington		12/20/12 	
1.  Raphael Valyi		12/20/12 	
1.  Michael Klapper		12/23/12 	
1.  Eli Klein		12/24/12 	
1.  Andrew Lawrence Burns		12/26/12 	
1.  Kevin Keane	North County Tech Center, LLC	12/26/12 	
1.  David Petzel		12/28/12 	
1.  Thomas Robison		12/28/12 	
1.  Keenan Brock		12/28/12 	
1.  Stefan Borsje		12/29/12 	
1.  Jon Galentine		12/29/12 	
1.  Kiesia Croucher		12/31/12 	
1.  Deeba Siddiqi		1/2/13 	
1.  Steven De Coeyer		1/2/13 	
1.  Yoni Yalovitsky	Fewbytes	1/2/13 	
1.  Alex Kiernan		1/3/13 	
1.  Gilles Cornu		1/4/13 	
1.  Gavin Mogan		1/4/13 	
1.  Steven Lehrburger		1/4/13 	
1.  Jordi Llonch		1/6/13 	
1.  Nicolas Rycar		1/7/13 	
1.  Andrew McCloud		1/7/13 	
1.  Gregoire Seux	Criteo	1/8/13 	
1.  Brian Scott	Emergent One	1/9/13 	
1.  Mike Taczak	Emergent One	1/9/13 	
1.  Javier Segura Martinez		1/9/13 	
1.  Warren Bain	Ninefold Pty Limited	1/9/13 	
1.  Shaun Domingo	Ninefold Pty Limited	1/9/13 	
1.  Toby Hede	Ninefold Pty Limited	1/9/13 	
1.  Paul Handly	DecisionDesk	1/13/13 	
1.  Eric Neuman	DecisionDesk	1/13/13 	
1.  Will Olbrys	DecisionDesk	1/13/13 	
1.  Thomas Bouve		1/14/13 	
1.  Kevin Reedy	Belly Inc	1/15/13 	
1.  Craig Ulliott	Belly Inc	1/15/13 	
1.  Jay OConnor	Belly Inc	1/15/13 	
1.  Courtenay Gasking		1/16/13 	
1.  James Dabbs		1/16/13 	
1.  Jerry Cattell		1/16/13 	
1.  Jon Webb		1/17/13 	
1.  Hendrik Volkmer	cloudbau Gmbh	1/18/13 	
1.  Thomas Kadauke	cloudbau Gmbh	1/18/13 	
1.  Martin Bosner	cloudbau Gmbh	1/18/13 	
1.  Christopher Laco		1/18/13 	
1.  Haggai Philip Zagury		1/19/13 	
1.  Eric Sigler		1/20/13 	
1.  Yves Vogl		1/21/13 	
1.  Yukihiko Sawanobori	HiganWorks LLC	1/21/13 	
1.  Seth Larson		1/21/13 	
1.  Ben Langeld		1/21/13 	
1.  Dan Midwood		1/22/13 	
1.  Peter Pouliot		1/22/13 	
1.  Alexander Bondarev		1/23/13 	
1.  Ben Dean	Ontario Systems	1/23/13 	
1.  Keith Shook	Ontario Systems	1/23/13 	
1.  Lucas Heinlen	Ontario Systems	1/23/13 	
1.  Kyle Michel	Ontario Systems	1/23/13 	
1.  Brice Oliver	Ontario Systems	1/23/13 	
1.  David Rogers	Lytro, Inc.	1/23/13 	
1.  Alvin Lai	Lytro, Inc.	1/23/13 	
1.  Anuj Biyani	Lytro, Inc.	1/23/13 	
1.  Tiffany Russo	Lytro, Inc.	1/23/13 	
1.  Craig Brunner	Lytro, Inc.	1/23/13 	
1.  Mugur Marculescu	Lytro, Inc.	1/23/13 	
1.  Tom Hanley	Lytro, Inc.	1/23/13 	
1.  Thomas Massmann		1/25/13 	
1.  Ankit Shah		1/25/13 	
1.  Josh Mahowald		1/25/13 	
1.  Christopher Bandy		1/25/13 	
1.  Mal Graty		1/27/13 	
1.  Vaidas Jablonskis		1/27/13 	
1.  Simon McCartney		1/28/13 	
1.  Jake Davis		1/29/13 	
1.  Sean Kilgore		1/29/13 	
1.  Scott Lampert		1/29/13 	
1.  Michael Frick		1/29/13 	
1.  Kevin Duane		1/30/13 	
1.  Ryan Geyer		1/30/13 	
1.  George Hafiz		1/30/13 	
1.  Eric Pardee	Atlas Digital, LLC	1/30/13 	
1.  Jaroslaw Zmudzinski	Grupa Allegro Sp. z o.o.	1/31/13 	
1.  Alexey Polovinkin		2/1/13 	
1.  Malte Swart		2/2/13 	
1.  Jon Burgess		2/3/13 	
1.  Daniel Hahn		2/4/13 	
1.  Maxime Brugidou	Criteo	2/4/13 	
1.  Gareth David Rushgrove		2/4/13 	
1.  Michael Conigliaro		2/4/13 	
1.  James Kessler		2/4/13 	
1.  Lukasz Jagiello		2/4/13 	
1.  Mischa Taylor		2/4/13 	
1.  Mervyn Hammer	Workday Inc.	2/5/13 	
1.  David Radcliffe		2/5/13 	
1.  Alexander Titov		2/5/13 	
1.  Buntaro OKADA		2/5/13 	
1.  Alexey Kalinin		2/5/13 	
1.  Adam Cownoble		2/6/13 	
1.  Josh Behrends	Webtrends	2/6/13 	
1.  Mark Shlimovich		2/6/13 	
1.  Jahn Bertsch		2/7/13 	
1.  Sergio Rodriguez		2/7/13 	
1.  Timur Batyrshin		2/8/13 	
1.  Samuel Cooper		2/8/13 	
1.  Ignacy Kasperowicz		2/8/13 	
1.  Ranjib Dey		2/8/13 	
1.  Kirill Kouznetsov		2/8/13 	
1.  Jordan Hagan		2/8/13 	
1.  Alexander Coles		2/9/13 	
1.  Michael Grosser		2/10/13 	
1.  Michael Goetz		2/11/13 	
1.  Patrick Humpal		2/11/13 	
1.  Nate Smith		2/13/13 	
1.  Martin Eigenbrodt		2/13/13 	
1.  Russell Cloran		2/13/13 	
1.  John Gabriel McArthur		2/13/13 	
1.  Jessica Bourne		2/13/13 	
1.  Darren Haken		2/14/13 	
1.  Rick Polk		2/14/13 	
1.  Eric Berg		2/14/13 	
1.  Andrew Williams	Intoximeters	2/15/13 	
1.  Matthew Follett	Intoximeters	2/15/13 	
1.  Brendan O'Donnell		2/16/13 	
1.  Igor Serebryany	Airbnb	2/17/13 	
1.  Lukas Reinfurt		2/17/13 	
1.  Adam Gross		2/17/13 	
1.  Giorgio Valoti		2/19/13 	
1.  Nathan Beyer	Cerner Corporation	2/19/13 	
1.  Patrik Stenmark	Valtech AB	2/20/13 	
1.  Evgeny Zislis		2/20/13 	
1.  Luyi Wang		2/20/13 	
1.  Jason Schadel	AWeber Communications	2/20/13 	
1.  David Kinzer		2/22/13 	
1.  Achim Rosenhagen		2/23/13 	
1.  Doug Cole		2/23/13 	
1.  Matthew Wright		2/25/13 	
1.  Jasper Lievisse Adriaanse		2/25/13 	
1.  Julien Vehent	AWeber Communications	2/25/13 	
1.  Ryan Steele	AWeber Communications	2/25/13 	
1.  Brian K. Jones	AWeber Communications	2/25/13 	
1.  Benjamin Krein	AWeber Communications	2/25/13 	
1.  Cliff Erson		2/26/13 	
1.  Booker Bense		2/27/13 	
1.  Charity Majors		2/27/13 	
1.  Jared Russell		2/27/13 	
1.  Iiro Uusitalo		2/27/13 	
1.  Ryan Walker	Rackspace	2/28/13 	
1.  Todd Bushnell		2/28/13 	
1.  BK Box		2/28/13 	
1.  Scott Stout		3/1/13 	
1.  Steffen Gebert		3/3/13 	
1.  John Cheng		3/3/13 	
1.  Jeremy Olliver		3/3/13 	
1.  Alexander Papaspyrou	adesso mobile solutions GmbH	3/4/13 	
1.  Stoyan Stoyanov	adesso mobile solutions GmbH	3/4/13 	
1.  Andreas Thielen	adesso mobile solutions GmbH	3/4/13 	
1.  Yves Vogl	adesso mobile solutions GmbH	3/4/13 	
1.  Brett Richardson		3/5/13 	
1.  Kevin Nuckolls	Banno, LLC	3/5/13 	
1.  Nic Grayson	Banno, LLC	3/5/13 	
1.  Luke Amdor	Banno, LLC	3/5/13 	
1.  Danny Lockard	Banno, LLC	3/5/13 	
1.  Thomas Wallace		3/5/13 	
1.  Ptah Dunbar		3/6/13 	
1.  Jonathan Asghar		3/6/13 	
1.  Brandon Sanders	AboutUs	3/7/13 	
1.  Aaron Brown		3/7/13 	
1.  Paul Oliver		3/7/13 	
1.  Alan Willis	Riot Games	3/7/13 	
1.  Dimitrios Verraros		3/8/13 	
1.  Arangamanikkannan Manickam		3/8/13 	
1.  David Bresnick		3/8/13 	
1.  Brett Weaver		3/8/13 	
1.  Drew Flower		3/8/13 	
1.  Charles Gregory Willis		3/8/13 	
1.  Owain Perry		3/9/13 	
1.  Alexander Sakharchuk		3/9/13 	
1.  Ameir Abdeldayem		3/9/13 	
1.  Robert Choi		3/10/13 	
1.  Gemini Agalo-os		3/10/13 	
1.  Alexander Galato		3/11/13 	
1.  Gabriel Klein		3/11/13 	
1.  Eric Richardson		3/12/13 	
1.  Steven Barre		3/13/13 	
1.  Paul Rossman	Google, Inc	3/14/13 	
1.  Riccardo Carlesso	Google, Inc	3/14/13 	
1.  Benson Kalahar	Google, Inc	3/14/13 	
1.  Rick Wright	Google, Inc	3/14/13 	
1.  Eric Johnson	Google, Inc	3/14/13 	
1.  Aaron Rice		3/15/13 	
1.  Radoslaw Gruchalski		3/15/13 	
1.  Matt Gleeson	Atlassian	3/18/13 	
1.  Will DeHaan	Atlassian	3/18/13 	
1.  Gabor Nagy		3/18/13 	
1.  Bryan Stearns		3/18/13 	
1.  Jose Diaz-Gonzalez		3/19/13 	
1.  Jean-Francois Theroux		3/19/13 	
1.  Christopher Stolfi		3/19/13 	
1.  Darrell Nash		3/19/13 	
1.  Sean Kane		3/20/13 	
1.  Patrick Leckey		3/20/13 	
1.  Michael Rose		3/20/13 	
1.  Pitr Vernigorov		3/20/13 	
1.  Capen Brinkley		3/20/13 	
1.  Tima Maslyuchenko		3/21/13 	
1.  Yvo van Doorn		3/21/13 	
1.  Tobias Wilken	cloudControl GmbH	3/21/13 	
1.  Mateusz Korszun	cloudControl GmbH	3/21/13 	
1.  Eric Chaves		3/21/13 	
1.  Peter Donald		3/21/13 	
1.  Remon Oldenbeuving		3/22/13 	
1.  Philip Cristiano		3/22/13 	
1.  Chris Streeter		3/24/13 	
1.  Kenneth Vetergaard		3/25/13 	
1.  Gert Kremer		3/25/13 	
1.  Peter de Rujiter	Springest	3/25/13 	
1.  Maarten Hoogendoorn	Springest	3/25/13 	
1.  Daniel Ryan		3/25/13 	
1.  Matthieu Launay	Criteo	3/26/13 	
1.  Jean-Baptiste Note	Criteo	3/26/13 	
1.  Daniel Koepke		3/26/13 	
1.  Neil Schelly	Dyn, Inc.	3/26/13 	
1.  David Miller	Dyn, Inc.	3/26/13 	
1.  Bill Young	Dyn, Inc.	3/26/13 	
1.  Phillip Goldenburg		3/27/13 	
1.  Faiz Kazi		3/31/13 	
1.  James Tucker	Google, Inc	4/1/13 	
1.  Marco Delaurenti	Google, Inc	4/1/13 	
1.  Sebastien Roccaserra		4/4/13 	
1.  Chendil Kumar Manoharan		4/4/13 	
1.  Jeremy Mauro	Criteo	4/5/13 	
1.  Joshua Levine		4/5/13 	
1.  Harley Alaniz	Lookout, Inc.	4/6/13 	
1.  Hiroaki Nakamura		4/8/13 	
1.  Leif Madsen	Thinking Phone Networks, Inc.	4/8/13 	
1.  Chris Sibbitt	Thinking Phone Networks, Inc.	4/8/13 	
1.  Christian Brideau	Thinking Phone Networks, Inc.	4/8/13 	
1.  Travis Hein	Thinking Phone Networks, Inc.	4/8/13 	
1.  Ming Chan		4/8/13 	
1.  Jamie Alessio		4/9/13 	
1.  Daichi Kamemoto		4/10/13 	
1.  David Groulx		4/10/13 	
1.  TAKEUCHI Go		4/11/13 	
1.  Alex Dergachev	Evolving Web Inc	4/11/13 	
1.  Suzanne Kennedy	Evolving Web Inc	4/11/13 	
1.  Sander Botman		4/15/13 	
1.  Julio Arias		4/15/13 	
1.  Alexander Wenzowski		4/16/13 	
1.  Pete Bristow		4/16/13 	
1.  Thorsten Klein		4/16/13 	
1.  Qingkun Liu		4/17/13 	
1.  Jonathan Cobb	Tout Industries	4/18/13 	
1.  Matt Lanier	Tout Industries	4/18/13 	
1.  Felix Roeser	Tout Industries	4/18/13 	
1.  Tom Hallett	Tout Industries	4/18/13 	
1.  Sam Gipe	Tout Industries	4/18/13 	
1.  Brandon Turner		4/20/13 	
1.  Mathias Lafeldt		4/20/13 	
1.  Matt Bower		4/21/13 	
1.  Zachary Patten	Lookout, Inc.	4/22/13 	
1.  Jim Hopp	Lookout, Inc.	4/22/13 	
1.  Zsolt Dollenstein		4/23/13 	
1.  Andrew Hollingsworth		4/24/13 	
1.  Benjamin Krueger		4/24/13 	
1.  Matt Thompson	Rackspace	4/25/13 	
1.  Hugh Saunders	Rackspace	4/25/13 	
1.  Harry Harrington	Rackspace	4/25/13 	
1.  Andy McCrae	Rackspace	4/25/13 	
1.  Chris Laco	Rackspace	4/25/13 	
1.  Bett Campbell	Rackspace	4/25/13 	
1.  Zack Feldstein	Rackspace	4/25/13 	
1.  Drew Rothstein		4/26/13 	
1.  Gaetano Santonastaso		4/26/13 	
1.  Tom Molin		4/26/13 	
1.  James Thompson		4/26/13 	
1.  Adam Stegman		4/26/13 	
1.  Robert Rehberg		4/26/13 	
1.  Amy Marco		4/27/13 	
1.  Chris Fordham		4/28/13 	
1.  Paolo Negri		4/29/13 	
1.  Jeremy Katz		4/29/13 	
1.  Troy Ready		4/30/13 	
1.  Jameson Lee		4/30/13 	
1.  Mehdi Lahmam		5/1/13 	
1.  Chandrashekar Seenappa		5/1/13 	
1.  Sander van Harmelen	Schuberg Philis 	5/1/13 	
1.  Matthew Hooker	Simple	5/1/13 	
1.  Robert Roose		5/1/13 	
1.  Peter Jihoon Kim	Irrational Industries	5/1/13 	
1.  Daniel Dao Quang Ming	Irrational Industries	5/1/13 	
1.  Arun K Thampi	Irrational Industries	5/1/13 	
1.  Paul Paradise	Socrata, Inc	5/1/13 	
1.  Chris Armstrong	Socrata, Inc	5/1/13 	
1.  David Chadwick Gibbons		5/1/13 	
1.  Chulki Lee	Aspera, Inc	5/1/13 	
1.  Christopher Markle	Aspera, Inc	5/1/13 	
1.  Jason Rutherford		5/1/13 	
1.  Peter Norton		5/2/13 	
1.  Walter Dal Mut		5/2/13 	
1.  Eric Sorenson		5/2/13 	
1.  Derrick Bryant		5/3/13 	
1.  Avrohom Katz		5/3/13 	
1.  Robert Postill		5/3/13 	
1.  Gabe Mulley	Hadapt, Inc	5/3/13 	
1.  Daniel Schauenberg		5/4/13 	
1.  James Turnbull		5/6/13 	
1.  Seren Thompson		5/7/13 	
1.  Solvi Pall Asgeirsson		5/7/13 	
1.  Dale Ragan	Moncai	5/7/13 	
1.  Eric Blevins	Moncai	5/7/13 	
1.  Kevin Landreth		5/8/13 	
1.  Ka-Wing Tam		5/10/13 	
1.  John Bellone Jr.		5/10/13 	
1.  Paolo Agostinetto		5/11/13 	
1.  Robert Coleman		5/11/13 	
1.  Ahmad Jemai		5/13/13 	
1.  Manuel Ryan		5/13/13 	
1.  Ben Somers		5/13/13 	
1.  Nate Fox		5/13/13 	
1.  Simon Coffey		5/14/13 	
1.  Andrea Bernardo Ciddio		5/14/13 	
1.  Maxim Doucet		5/14/13 	
1.  Martin Klein		5/14/13 	
1.  Jeremiah Wuenschel	Yahoo Inc.	5/14/13 	
1.  Deven Panchal	Yahoo Inc.	5/14/13 	
1.  Jeff Parrish	Yahoo Inc.	5/14/13 	
1.  Venkat Venkataraju	Yahoo Inc.	5/14/13 	
1.  Chris Wing	Yahoo Inc.	5/14/13 	
1.  Ittai Shadmon	Yahoo Inc.	5/14/13 	
1.  Itsik Figenblat	Yahoo Inc.	5/14/13 	
1.  Matthew Mencel		5/14/13 	
1.  Olaf Heydorn		5/16/13 	
1.  Bryan Stenson		5/16/13 	
1.  Holger Protzek		5/16/13 	
1.  Nilesh Bairagi		5/16/13 	
1.  Matt Clark		5/16/13 	
1.  Jan Nikolai Trzeszkowski		5/17/13 	
1.  Bernhard K. Weisshuhn		5/17/13 	
1.  Chris Reid		5/17/13 	
1.  Morgan Blackthorne		5/20/13 	
1.  Ken Miles		5/20/13 	
1.  James "Jim" Rosser, IV	Texas A&M University College of Architecture	5/20/13 	
1.  Derek Groh	Texas A&M University College of Architecture	5/20/13 	
1.  Benjamin Liles	Texas A&M University College of Architecture	5/20/13 	
1.  Kyle Morgan	Rackspace 	5/20/13 	
1.  Wilfred Hughes		5/21/13 	
1.  Jeff Anderson		5/21/13 	
1.  Brian Hatfield		5/21/13 	
1.  Guillermo Carrasco Hernandez		5/21/13 	
1.  James Sulinksi	MoPub	5/21/13 	
1.  Haydn Dufrene	MoPub	5/21/13 	
1.  Rob McQueen	MoPub	5/21/13 	
1.  Chris Snook	MoPub	5/21/13 	
1.  Christophe Arguel		5/22/13 	
1.  Sean Nolen		5/22/13 	
1.  Chetan Sarva		5/24/13 	
1.  Justin Ryan	Onelogin, Inc	5/24/13 	
1.  Stephen Touset	Onelogin, Inc	5/24/13 	
1.  Marcelo Serpa	Onelogin, Inc	5/24/13 	
1.  Nelson Enzo	Onelogin, Inc	5/24/13 	
1.  Elan Ruusamäe		5/24/13 	
1.  Marco Betti		5/26/13 	
1.  Jonathan Hitchcock	Yola	5/27/13 	
1.  Stefano Rivera	Yola	5/27/13 	
1.  Adrian Moisey	Yola	5/28/13 	
1.  Doug Beck	Yola	5/28/13 	
1.  John Tran		5/28/13 	
1.  Jesse Ahrens	CopperEgg	5/28/13 	
1.  Ross Dickey	CopperEgg	5/28/13 	
1.  Scott Johnson	CopperEgg	5/28/13 	
1.  Eric Anderson	CopperEgg	5/28/13 	
1.  Benjamin Bytheway		5/28/13 	
1.  Tehmasp Chaudhri		5/28/13 	
1.  Russell Teabeault		5/28/13 	
1.  Tim Ray		5/29/13 	
1.  Gavin Roy	MeetMe, Inc	5/30/13 	
1.  Peter Eisentraut	MeetMe, Inc	5/30/13 	
1.  Jennifer Fountain	MeetMe, Inc	5/30/13 	
1.  Kenny Furguson	MeetMe, Inc	5/30/13 	
1.  Michael Glaesemann	MeetMe, Inc	5/30/13 	
1.  Edward Robinson		6/1/13 	
1.  Baldur Gudbjornsson		6/1/13 	
1.  Jeffrey Jones		6/1/13 	
1.  Louis-Philippe Perron		6/5/13 	
1.  Victor Sollerhed		6/5/13 	
1.  Alvin Yik-ning Liang		6/5/13 	
1.  Cassiano Morgado de Aquino		6/5/13 	
1.  Brett Graves		6/6/13 	
1.  Mattew Collinge		6/6/13 	
1.  Nick Silkey	Rackspace	6/6/13 	
1.  Chris Stephan		6/6/13 	
1.  Peter Fern		6/6/13 	
1.  Kevin Bridges		6/6/13 	
1.  Peter Halliday		6/7/13 	
1.  Felix Bunemann		6/9/13 	
1.  Nanuk Krinner		6/10/13 	
1.  Robert Dyer		6/10/13 	
1.  Anthony Scalisi		6/11/13 	
1.  Ryan Hass		6/11/13 	
1.  Brad Beam		6/12/13 	
1.  Ean Rollings		6/13/13 	
1.  Ken Robertson		6/13/13 	
1.  Tony Chong		6/13/13 	
1.  Oliver Nicolaas Ponder		6/14/13 	
1.  Mikhail Kolesnik		6/16/13 	
1.  Sergey Khaladzinksi		6/16/13 	
1.  Tucker DeWitt		6/16/13 	
1.  Thomas Meeus		6/17/13 	
1.  Lin Lin		6/17/13 	
1.  Omar Vargas		6/17/13 	
1.  Domonkos Tomcsanyi	Boadree Innovations Kft.	6/17/13 	
1.  Prashant Nadarajan		6/18/13 	
1.  Eohyung Lee		6/18/13 	
1.  David Albrecht		6/18/13 	
1.  Nicholas Downs		6/19/13 	
1.  Mike Devine		6/19/13 	
1.  Thomas Cate	Rackspace 	6/18/13 	
1.  Ryan Richard	Rackspace 	6/18/13 	
1.  Matthew Thode	Rackspace	6/18/13 	
1.  Chris Aumann		6/20/13 	
1.  Eric Wunderlin		6/21/13 	
1.  Georgi Markov		6/21/13 	
1.  Sjoerd Mulder		6/21/13 	
1.  Benjamin Knauss		6/21/13 	
1.  Erik Gustavson	Bitium, Inc	6/21/13 	
1.  Prashant Nadarajan	Bitium, Inc	6/21/13 	
1.  Walter Schiessberg		6/24/13 	
1.  Vasily Mikhaylichenko 		6/24/13 	
1.  William Anthony Rhodes Jr		6/24/13 	
1.  Adam Wayne		6/24/13 	
1.  Max Manders 	Cloudreach	6/24/13 	
1.  Justin Stallard		6/25/13 	
1.  Nelson Chen		6/26/13 	
1.  Eric Sproul	OmniTI	6/19/13 	
1.  Andrew Macgregor 		6/27/13 	
1.  Jeffrey Damick		6/26/13 	
1.  Daniel Williams		6/27/13 	
1.  Bruce Li		6/27/13 	
1.  Satoshi Akama		6/28/13 	
1.  Dave Stern		6/28/13 	
1.  David Andrew		6/28/13 	
1.  Anthony Burns		6/29/13 	
1.  Michael Ballantyne		6/28/13 	
1.  Ewan McDougall		7/1/13 	
1.  Matt Patterson		7/1/13 	
1.  Ivan Puzyrevskiy		7/2/13 	
1.  Stefano Tortarolo		7/3/13 	
1.  Christopher MacNaughton		7/3/13 	
1.  Skye Book		7/3/13 	
1.  Mark Butcher		7/4/13 	
1.  Nick Morgan 	Heart of Sales LLC DBA Ace of Sales 	7/4/13 	
1.  Ryan Schlesinger	Heart of Sales LLC DBA Ace of Sales 	7/4/13 	
1.  Kevin Patrick Pullin II		7/5/13 	
1.  Colin Woodcock	NetSrv Consulting Ltd	7/7/13 	
1.  Joshua Tobin		7/8/13 	
1.  James Cuzella		7/8/13 	
1.  Michael John Huot Jr.		7/9/13 	
1.  William Albenzi		7/9/13 	
1.  Matas Veitas		7/10/13 	
1.  NagaLakshmi N		7/10/13 	
1.  Evan Michael Kinney		7/11/13 	
1.  Adam Lane		7/11/13 	
1.  Rafael Colton		7/11/13 	
1.  Julien Phalip		7/11/13 	
1.  Matthew Savage		7/11/13 	
1.  Koseki Kengo		7/11/13 	
1.  Gregory Palmier		7/12/13 	
1.  Alain O'Dea		7/12/13 	
1.  Peter Hoellig	PROS, Inc. a Delaware Corporation	7/12/13 	
1.  Vladimir Skubriev		7/12/13 	
1.  Ryan Stephens 	AURIN Project -Faculty of Architecture, Building and Planning 	7/12/13 	
1.  Martin Tomko 	AURIN Project -Faculty of Architecture, Building and Planning 	7/12/13 	
1.  Christopher Bayliss 	AURIN Project -Faculty of Architecture, Building and Planning 	7/12/13 	
1.  Peter Ellingsen 	AURIN Project -Faculty of Architecture, Building and Planning 	7/12/13 	
1.  Chris Pettit 	AURIN Project -Faculty of Architecture, Building and Planning 	7/12/13 	
1.  Jörg Thalheim		7/12/13 	
1.  Zac Hallett		7/12/13 	
1.  Emanuele Zattin		7/11/13 	
1.  Daniel Steen		7/12/13 	
1.  Ronnie Taylor		7/13/13 	
1.  Danny Guinther		7/14/13 	
1.  Michael Vitale		7/16/13 	
1.  Nicholas Ethier		7/16/13 	
1.  Steve Poe	Onlife Health Inc 	7/17/13 	
1.  Craig Menning		7/17/13 	
1.  Antoni Baranski	Roblox Inc.	7/17/13 	
1.  John Landahl		7/18/13 	
1.  Rudy Grigar		7/19/13 	
1.  Katsuma Ito		7/19/13 	
1.  Andrew Wyatt	Onlife Health Inc	7/19/13 	
1.  Naoki AINOYA		7/21/13 	
1.  David Giesberg		7/21/13 	
1.  Luke Hoschke		7/21/13 	
1.  Myles Steinhauser		7/22/13 	
1.  Kyle Rames	Rackspace	7/23/13 	
1.  Chris Snell	Rackspace	7/23/13 	
1.  Jason Roelofs		7/23/13 	
1.  Hugo Trippaers		7/24/13 	
1.  Mark Friedgan		7/24/13 	
1.  Matthew Hopkins		7/24/13 	
1.  Eddie Zaneski		7/24/13 	
1.  Maxwell Robett Dietz		7/24/13 	
1.  Simon Robson		7/25/13 	
1.  Dan Bachelder		7/26/13 	
1.  Matthew Farmer		7/26/13 	
1.  Thomas Neal Cravey		7/26/13 	
1.  Ross Timson		7/29/13 	
1.  Donald Stufft		7/28/13 	
1.  Gilles Cornu		7/28/13 	
1.  Kenichi Saita		7/28/13 	
1.  Ivan Tanev		7/27/13 	
1.  Chris Gallimore		7/26/13 	
1.  Sonny Garcia		7/26/13 	
1.  Alexis Midon		7/26/13 	
1.  Brandon Henry		7/29/13 	
1.  Jordan Wesolowski		7/29/13 	
1.  Christopher Brinley		7/29/13 	
1.  Nimesh Subramanian	Cerner	7/29/13 	
1.  Eric Hartmann		7/29/13 	
1.  Kevin Rochford		7/30/13 	
1.  Jon San Miguel		7/30/13 	
1.  Tommy Fotak		7/31/13 	
1.  Nicholas Hatch		8/1/13 	
1.  Raf Geens		8/6/13 	
1.  Thomas Bell		8/6/13 	
1.  Braden Wright		8/6/13 	
1.  Johnny Tan		8/6/13 	
1.  Yvonne Beumer	Cloudreach	8/12/13 	
1.  Ben House		8/9/13 	
1.  Joe Fitzgerald		8/12/13 	
1.  Peter Hessler		8/13/13 	
1.  Nicholas Russell		8/13/13 	
1.  Brian Golf		8/13/13 	
1.  Adam Kunk		8/13/13 	
1.  Sandy Vanderbleek		8/13/13 	
1.  Lance French		8/13/13 	
1.  Jeff Hagadom		8/14/13 	
1.  George Miranda		8/16/13 	
1.  Evan Gilman		8/19/13 	
1.  Nenad Petronijevic		8/19/13 	
1.  Daniel Spilker 	CoreMedia AG	7/31/13 	 	
1.  Felix Simmendinger	CoreMedia AG	7/31/13 	
1.  Eike Thienemann-Dehde	CoreMedia AG	7/31/13 	 	
1.  Christopher Hass	CoreMedia AG	7/31/13 	
1.  Daniel Zabel	CoreMedia AG	7/31/13 	
1.  Ryan Munson	Taos Mountain, Inc.	7/31/13 	
1.  Tim Fischbach		8/20/13 	
1.  Chance Zibolski		8/20/13 	
1.  Kazuki Akamine		8/20/13 	
1.  David Wittman		8/20/13 	
1.  Brian Whipple	PROS, Inc. a Delaware Corporation	8/14/13 	
1.  Michael Jensen	PROS, Inc. a Delaware Corporation	8/14/13 	
1.  Asanka Samaraweera	PROS, Inc. a Delaware Corporation	8/14/13 	
1.  Christian Vozar	Belly Inc	8/20/13 	
1.  Darby Frey	Belly Inc	8/20/13 	
1.  Matthew Herscovitch	Identive Group	8/20/13 	
1.  Mark Butcher	Identive Group	8/20/13 	
1.  Luke Bradbury	University of Derby	8/28/13 	
1.  Dan Webb	University of Derby	8/28/13 	
1.  Alastair Firth		8/23/13 	
1.  Jesse Adams		8/28/13 	
1.  Matt Alexander		8/28/13 	
1.  Jason Vanderhoof		8/26/13 	
1.  Lianping Chen		8/26/13 	
1.  Christoph Bunte		8/26/13 	
1.  Yvonne Lam		8/28/13 	
1.  Mark Cornick	TeamSnap	8/29/13 	
1.  Justin Clarke	Social Ally Pty Ltd	8/29/13 	
1.  H Wade Minter	TeamSnap	8/29/13 	
1.  Kyle Ries	TeamSnap	8/29/13 	
1.  Phillip Hutchins		8/30/13 	
1.  Artem Kornienko		8/30/13 	
1.  Ulf Mansson	Recorded Future	9/2/13 	
1.  Sam Crang		8/31/13 	
1.  Jorge Acosta Goszczynski		9/3/13 	
1.  Lysenko Kostiantyn		9/4/13 	
1.  Phil Sturgeon		9/4/13 	
1.  Kamil Bednarz		9/4/13 	
1.  Travis Petticrew		9/4/13 	
1.  Peter Walz		8/29/13 	
1.  Jeffrey Utter		9/4/13 	
1.  Martin Cozzi		9/4/13 	
1.  Andrew Thompson		9/4/13 	
1.  Thomas von Schwerdtner		9/4/13 	
1.  William Dierkes		9/4/13 	
1.  Robin Ricard		9/5/13 	
1.  Ben Longden		9/5/13 	
1.  Alex Denvir	Protec Innovations Ltd.	9/5/13 	
1.  Martin Meredith	Protec Innovations Ltd.	9/5/13 	
1.  Phil Thompson	Protec Innovations Ltd.	9/5/13 	
1.  Alejandro Blanco		9/5/13 	
1.  Adrian Moisey		9/5/13 	
1.  Alex Zorin		9/5/13 	
1.  Robert Schulze		9/5/13 	
1.  Wei Liang		9/5/13 	
1.  Jon Torresdal		9/5/13 	
1.  Sergii Golovatiuk		9/6/13 	
1.  Mark O'Keefe		9/6/13 	
1.  Brint O'Heam		9/6/13 	
1.  Jim Myhrberg		9/7/13 	
1.  James FitzGibbon		9/8/13 	
1.  Isbaran Akcayir		9/9/13 	
1.  Sylvain Tisso	Ecodev Sarl	9/9/13 	
1.  Fabien Udriot	Ecodev Sarl	9/9/13 	
1.  Adrien Crivelli	Ecodev Sarl	9/9/13 	
1.  Yoshanda Shin		9/10/13 	
1.  Christo De Lange		9/10/13 	
1.  Arthur Freyman		9/10/13 	
1.  Martin Walton		9/10/13 	
1.  Matthew Brennan		9/10/13 	
1.  Luis Ricardo Malheiros		9/11/13 	
1.  Amir Kadivar		9/11/13 	
1.  Davanum Srinivas		9/12/13 	
1.  Jesse Pretorius		9/12/13 	
1.  Denis Corol		9/12/13 	
1.  Yevgen Kovalienia		9/12/13 	
1.  Ben Hines		9/13/13 	
1.  Muneyuki Noguchi		9/14/13 	
1.  Myers Carpenter		9/16/13 	
1.  Mathieu Allaire		9/16/13 	
1.  Michael Stucki		9/17/13 	
1.  Kevin Webster		9/17/13 	
1.  Conor McDermottroe		9/17/13 	
1.  Naoya Nakazawa		9/17/13 	
1.  Mark Gibbons	Nordstrom	9/17/13 	
1.  Matthew Moore		9/17/13 	
1.  Ingo Kampe	kreuzwerker GmbH	9/18/13 	
1.  Robert Conrad	kreuzwerker GmbH	9/18/13 	
1.  Daniel Meisen	kreuzwerker GmbH	9/18/13 	
1.  Alexander Dall	kreuzwerker GmbH	9/18/13 	
1.  Jan Nabbefeld	kreuzwerker GmbH	9/18/13 	
1.  Joern Barthel	kreuzwerker GmbH	9/18/13 	
1.  Harvey Bandana	Nordstrom	9/18/13 	
1.  Ben Holley		9/18/13 	
1.  Yuji Takaesu		9/18/13 	
1.  Colin Burn-Murdoch		9/20/13 	
1.  Andrius Marcinkevicius		9/20/13 	
1.  Alan Bryan	Central Desktop	9/18/13 	
1.  Craig Lewis	Central Desktop	9/18/13 	
1.  Saku Laitinen	Siili Solutions	9/19/13 	
1.  Denis Barishev	Twiket LTD	9/23/13 	
1.  Sam Orlov	Twiket LTD	9/23/13 	
1.  Jarek Gawor	IBM	9/23/13 	
1.  Anthony Elder	IBM	9/23/13 	
1.  Michael C Thompson	IBM	9/23/13 	
1.  Jeremy Hughes	IBM	9/23/13 	
1.  Igor Rodionov		9/23/13 	
1.  Gabor Garami		9/24/13 	
1.  Iulia Banghea		9/24/13 	
1.  Paul Dunnavant		9/24/13 	
1.  Alex Heneveld	Cloudsoft Corp.	9/25/13 	
1.  Jordi Massaguer Pla		9/25/13 	
1.  Richard Downer	Cloudsoft Corp.	9/25/13 	
1.  Roger Hu		9/25/13 	
1.  Dominic St-Jacques		9/25/13 	
1.  Mahmoud Abdelkader		9/26/13 	
1.  Takahiro Himura		9/26/13 	
1.  Aled Sage	Cloudsoft Corp.	9/25/13 	
1.  Andrew Kennedy	Cloudsoft Corp.	9/25/13 	
1.  Sam Corbett	Cloudsoft Corp.	9/25/13 	
1.  Trevor Leybourne	MYOB NZ Limited	9/26/13 	
1.  Greg Zapp	MYOB NZ Limited	9/26/13 	
1.  Bo Ma	MYOB NZ Limited	9/26/13 	
1.  Dmitry Lavrinenko		9/27/13 	
1.  Vitaly Shishlyannikov		9/27/13 	
1.  Jonathan Mickle		9/27/13 	
1.  Scott Hain Jr		9/27/13 	
1.  Ethan Fremen		9/29/13 	
1.  Daniel O'Conner		9/29/13 	
1.  Bill Wiens		9/30/13 	
1.  Jeroen Grusebroek	Mollie B.V.	9/30/13 	
1.  Morton Jonuschat		9/30/13 	
1.  Bentrand Paquet		10/1/13 	
1.  Christoph Hartmann		10/1/13 	
1.  Okezie Eze		10/1/13 	
1.  Christopher Dwan		10/1/13 	
1.  Carl Schmidt	Unbounce	10/1/13 	
1.  Aaron Oman	Unbounce	10/1/13 	
1.  Chris Spicer	Unbounce	10/1/13 	
1.  Jimmy Zheng	Unbounce	10/1/13 	
1.  Josh Blancett		10/1/13 	
1.  Stephen Romney	Shutl Ltd. 	10/2/13 	
1.  James Wilford	Shutl Ltd. 	10/2/13 	
1.  Sam Phillips	Shutl Ltd. 	10/2/13 	
1.  Yomi Colledge	Shutl Ltd. 	10/2/13 	
1.  Marco Nenciarini		10/2/13 	
1.  Jake Herbst		10/2/13 	
1.  Kawahara Masashi		10/2/13 	
1.  Ilan Rabinovitch	Ooyala, Inc.	10/3/13 	
1.  Garry Polley		10/3/13 	
1.  Akshay Karle		10/3/13 	
1.  Pascal Gelinas	Nu Echo	10/3/13 	
1.  Salim Semaoune		10/3/13 	
1.  August Schwer		10/4/13 	
1.  Sam Adams		10/7/13 	
1.  Niels Kristensen		10/7/13 	
1.  Aliaksei Kliuchnikau		10/7/13 	
1.  Theofilos Papapanagiotou		10/7/13 	
1.  Mike Rossetti	Our Film Festival (dba Fandor)	10/7/13 	
1.  Victor Lin		10/8/13 	
1.  Tyler Kellen		10/8/13 	
1.  Baba Buehler		10/8/13 	
1.  Matt Clifton		10/8/13 	
1.  Daniel Babel	Ooyala, Inc.	10/9/13 	
1.  Jurgen Philippaerts	Ooyala, Inc.	10/9/13 	
1.  Josh Toft	Ooyala, Inc.	10/9/13 	
1.  Tobias Maier	BauCloud GmbH	10/9/13 	
1.  Ryota Arai		10/9/13 	
1.  Kyle Kelley		10/10/13 	
1.  Jaroslav Barton		10/10/13 	
1.  Sam Pointer		10/10/13 	
1.  Sebastian Guevara		10/10/13 	
1.  Paul Welch	Squaremouth Inc	10/10/13 	
1.  Peter Georgantas		10/10/13 	
1.  Karla Jacobsen		10/10/13 	
1.  Ryan S Brown		10/10/13 	
1.  Richard Manyanza		10/11/13 	
1.  Guilhem Lettron	Optiflows	10/11/13 	
1.  Ludovic Havel	Optiflows	10/11/13 	
1.  Jean Rouge		10/11/13 	
1.  Devon Jones		10/11/13 	
1.  Matthew Kasa		10/11/13 	
1.  James Moorhouse		10/12/13 	
1.  Christopher Grim		10/12/13 	
1.  Ryan Frantz		10/14/13 	
1.  Shrikant Patnaik	General Sensing LTD	10/10/13 	
1.  Aaron Valade	General Sensing LTD	10/10/13 	
1.  Chris Jerdonek		10/13/13 	
1.  EJ Ciramella	Rapid7	10/14/13 	
1.  Brandon Turner	Rapid7	10/14/13 	
1.  Chris Smtih	Rapid7	10/14/13 	
1.  Ben Tomasini		10/14/13 	
1.  Evan Todd		10/15/13 	
1.  Alex Shadrin		10/15/13 	
1.  Mart Karu		10/15/13 	
1.  Russell Cardullo		10/15/13 	
1.  John Tran		10/15/13 	
1.  Alex Koch		10/15/13 	
1.  Jonathan Regeimbal		10/15/13 	
1.  James Walker		10/16/13 	
1.  Justin Dugger		10/16/13 	
1.  Dustin Collins		10/16/13 	
1.  Matthew Boedicker		10/17/13 	
1.  John Deatherage		10/17/13 	
1.  Aaron Jensen		10/17/13 	
1.  Olksandr Slynko		10/17/13 	
1.  Emanuele Rocca		10/18/13 	
1.  Antonio Fernandez Vara		10/18/13 	
1.  Mickhail Zholobov		10/18/13 	
1.  Daniel Wallace	Rackspace	10/18/13 	
1.  Christian Fischer		10/18/13 	
1.  Silviu Dicu		10/18/13 	
1.  William Pietri		10/19/13 	
1.  Daniel Tracy		10/21/13 	
1.  Ashish Shinde		10/22/13 	
1.  Mathew Hoyle	Deployable LTD	10/22/13 	
1.  Leonardo Leite	 	10/22/13 	
1.  Michael Dore		10/22/13 	
1.  Hannes Van De Vreken		10/22/13 	
1.  Mevan Samaratunga		10/22/13 	
1.  Adam Enger		10/22/13 	
1.  Peter Jönsson	Klarna	10/23/13 	
1.  Carl Loa Odin	Klarna	10/23/13 	
1.  Olle Lundberg	Klarna	10/23/13 	
1.  Pat Downey		10/24/13 	
1.  Max Lincoln		10/24/13 	
1.  Pavel Brylov		10/24/13 	
1.  Sam Clements		10/25/13 	
1.  Gabriel Mazetto		10/25/13 	
1.  Cory Gunterman	Nike, Inc.	10/25/13 	
1.  Justin Redd	Nike, Inc.	10/25/13 	
1.  Dave Palomino	Nike, Inc.	10/25/13 	
1.  Tom Luce	Nike, Inc.	10/25/13 	
1.  Shawn Turpin	Nike, Inc.	10/25/13 	
1.  Ed Tretyakov		10/27/13 	
1.  Frank Breedijk	Schuberg Phillis B.V.	10/28/13 	
1.  Henry Finucane		10/30/13 	
1.  Thomas de Grenier de Latour		10/30/13 	
1.  Andrey Chernih		10/30/13 	
1.  Matt Wormley		10/30/13 	
1.  Maciej Galkiewicz		10/31/13 	
1.  Makiko Nomura		11/1/13 	
1.  Cheah Chu Yeow	Irrational Industries, Inc.	11/1/13 	
1.  Christian Paredes	Irrational Industries, Inc.	11/1/13 	
1.  Rafael Kolless		11/2/13 	
1.  Zsolt Takacs		11/2/13 	
1.  Tobias Schmidt	SoundCloud Ltd.	11/5/13 	
1.  Frederick Jaeckel	SoundCloud Ltd.	11/5/13 	
1.  Matthias Rampke	SoundCloud Ltd.	11/5/13 	
1.  Daman Yang	SoundCloud Ltd.	11/5/13 	
1.  Ben Kochie	SoundCloud Ltd.	11/5/13 	
1.  Alexander Grosse	SoundCloud Ltd.	11/5/13 	
1.  Allan Beaufour	Project Florida	11/5/13 	
1.  Jow Crobak	Project Florida	11/5/13 	
1.  Derek Groh		11/5/13 	
1.  David Shawley		11/5/13 	
1.  Jason Faulkner		11/5/13 	
1.  Cheryl Ainoa	Intuit	11/6/13 	
1.  Thomas Bishop	Intuit	11/6/13 	
1.  Jeffrey Mendoza		11/6/13 	
1.  Munirathnam Srikanth	ComputeNext	11/6/13 	
1.  Sergio Patino		11/6/13 	
1.  Andrew Caldwell		11/6/13 	
1.  Alex Derzhi		11/7/13 	
1.  Olivier Biesmans		11/7/13 	
1.  Gabriel Rosendorf	The Weather Companies	11/8/13 	
1.  Nathaniel Eliot		11/9/13 	
1.  Thibaut Notteboom		11/10/13 	
1.  Walter Huf		11/11/13 	
1.  David Larken Nolen		11/11/13 	
1.  Makana Greenwell		11/12/13 	
1.  Mathew Hartley		11/12/13 	
1.  Julie Rice	PTC Inc	11/13/13 	
1.  Matt Welch	PTC Inc	11/13/13 	
1.  Jonathan Bass	PTC Inc	11/13/13 	
1.  Joe Rocklin		11/14/13 	
1.  Zaininnari		11/14/13 	
1.  Jean Mertz		11/18/13 	
1.  Gleb Borisov		11/19/13 	
1.  Curtis Stewart		11/19/13 	
1.  Jim Park	RamTank Inc	11/19/13 	
1.  Pierre Ynard	Criteo	11/19/13 	
1.  Sergey Balbeko		11/20/13 	
1.  Igor Serko		11/20/13 	
1.  Jason Giedymin		11/20/13 	
1.  Luca Pradovera		11/20/13 	
1.  Jason Giedymin		11/20/13 	
1.  Shaun Rowe		11/21/13 	
1.  Chad Cloes	Intuit	11/21/13 	
1.  Rick Mendes	Intuit	11/21/13 	
1.  Grant Hoffman	Intuit	11/21/13 	
1.  Capen Brinkley	Intuit	11/21/13 	
1.  Kevin Young	Intuit	11/21/13 	
1.  Walter Askew IV		11/22/13 	
1.  Spencer Smith		11/23/13 	
1.  Spencer Smith		11/23/13 	
1.  Connor Goodwolf		11/23/13 	
1.  Seiji Komatsu		11/24/13 	
1.  Steve Domin	GoCardless	11/24/13 	
1.  Milos Gajdos	GoCardless	11/24/13 	
1.  Harry Marr	GoCardless	11/24/13 	
1.  Komatsu Seiji		11/25/13 	
1.  Gokulnath Manakkattil		11/26/13 	
1.  Joel Moss		11/27/13 	
1.  Drew J. Sonne		11/30/13 	
1.  Sascha Mollering	ZANOX AG	11/30/13 	
1.  Boris Komraz		12/1/13 	
1.  Mark O'Connor		12/1/13 	
1.  Ivan Larionov		12/2/13 	
1.  Pierre Carrier		12/2/13 	
1.  Joe A. Kemp	ARINC	12/3/13 	
1.  Douglas Mendizabal		12/3/13 	
1.  Tejay Cardon	Lockheed Martin Corporation	12/3/13 	
1.  David Deal	Lockheed Martin Corporation	12/3/13 	
1.  Jason Loveland	Lockheed Martin Corporation	12/3/13 	
1.  Friedrich Clausen		12/4/13 	
1.  Paul Kehrer		12/4/13 	
1.  Stephan Renatus		12/5/13 	
1.  Abhijit Hiremagalur		12/5/13 	
1.  Wojciech Oledzki		12/5/13 	
1.  Johannes Plunien		12/7/13 	
1.  Benjamin Demaree		12/8/13 	
1.  Friedel Ziegelmayer		12/13/13 	
1.  Jason Vervlied		12/13/13 	
1.  Fabian Lee		12/15/13 	
1.  Tino Breddin		12/16/13 	
1.  Cameron Cope	Brightcove	12/16/13 	
1.  Jason Perry	Brightcove	12/16/13 	
1.  Eric Moakley	Brightcove	12/16/13 	
1.  Joshua Spiewak	Brightcove	12/16/13 	
1.  John Schectman	Brightcove	12/16/13 	
1.  Keegan Holley		12/16/13 	
1.  James La Spada		12/17/13 	
1.  Jesué Sousa Cunha Junior		12/17/13 	
1.  Dan Rathbone		12/17/13 	
1.  Jay Geeseman		12/19/13 	
1.  David Bernick		12/20/13 	
1.  Primož Verdnik		12/20/13 	
1.  Yavor Nikolov		12/26/13 	
1.  Joseph C. Stump	Sprint.ly, Inc	12/27/13 	
1.  Justin T. Abrahms	Sprint.ly, Inc	12/27/13 	
1.  Theodore Chuong Nordsieck		12/29/13 	
1.  Thomas Noonan II		12/30/13 	
1.  Coman Ioan Andrei		12/30/13 	
1.  Steven Geerts	Schuberg Phillis B.V.	1/2/14 	
1.  Scott Russell		1/3/14 	
1.  Lothar Wieske		1/3/14 	
1.  Paul Czarkowski		1/3/14 	
1.  Ramil Lim		1/3/14 	
1.  Jeff Byrnes		1/3/14 	
1.  Christopher James Saylor		1/4/14 	
1.  Gary Cao		1/6/14 	
1.  Christopher William Pernicano		1/6/14 	
1.  Emmanuel Idi		1/6/14 	
1.  Reid Beels		1/7/14 	
1.  Anthony LoBono		1/8/14 	
1.  Barthélemy Vessemont		1/10/14 	
1.  Michael Holtzman		1/10/14 	
1.  Tristan O'Neil	Cramer Development	1/10/14 	
1.  Brian Cobb	Cramer Development	1/10/14 	
1.  Brett Chalupa	Cramer Development	1/10/14 	
1.  Dan Volkens	Cramer Development	1/10/14 	
1.  Ryan Keairns	Cramer Development	1/10/14 	
1.  Nikhil Benesch		1/12/14 	
1.  Christian Höltje		1/13/14 	
1.  Alexander C Corvin		1/17/14 	
1.  Samuel Chambers		1/18/14 	
1.  Cheah Chu Yeow		1/18/14 	
1.  Kazuki Saito		1/18/14 	
1.  Pete Richards		1/19/14 	
1.  Jimmy McCrory		1/19/14 	
1.  Olivier Dolbeau		1/20/14 	
1.  Andrew Brown	BlackBerry, Inc.	1/20/14 	
1.  Phil Oliva	BlackBerry, Inc.	1/20/14 	
1.  Dave Urschatz	BlackBerry, Inc.	1/20/14 	
1.  Ishtiaq Ahmed		1/25/14 	
1.  Caleb Land		1/26/14 	
1.  Charles B Johnson		1/26/14 	
1.  Diego Rodriguez		1/27/14 	
1.  Nitin Mohan		1/27/14 	
1.  Szymon Szypulski		1/29/14 	
1.  Jaime Gil de Sagredo		1/29/14 	
1.  Jose Luis Ferrer Riera		1/29/14 	
1.  Yury Velikanau		1/29/14 	
1.  Jeroen Jacobs		1/30/14 	
1.  W. Hart Hoover	Rackspace	2/3/14 	
1.  Jerry Richardson	Disruptive Ventures, Inc	2/4/14 	
1.  Brian Dwyer		2/4/14 	
1.  Aaron O'Mullan	FriendCode, Inc	2/5/14 	
1.  Jean-Baptiste Dalido		2/6/14 	
1.  Juri Timoshin		2/6/14 	
1.  Pascal Laporte		2/6/14 	
1.  Steven Cummings	Cerner Innovation Inc	2/6/14 	
1.  Pascal Laporte		2/6/14 	
1.  Mick Brooks		2/7/14 	
1.  Aurélien Noce		2/7/14 	
1.  Charlie Huggard	Cerner Innovation Inc	2/11/14 	
1.  Matthias Arnason	Engine Yard	2/12/14 	
1.  Bryan Taylor		2/12/14 	
1.  Michael Dillion		2/17/14 	
1.  Seth Kingry		2/18/14 	
1.  Wesley David DeCesare	Crux Hosted Services	2/18/14 	
1.  Kent Shultz		2/18/14 	
1.  Adam Durana		2/21/14 	
1.  Jacob McCann		2/21/14 	
1.  Andriy Tyurnikov		2/21/14 	
1.  Anton Koldaev		2/21/14 	
1.  Matthew Rathbone		2/21/14 	
1.  Egor Medvedev		2/23/14 	
1.  Eric Tucker	Blue Spurs	2/24/14 	
1.  Tomas Gutierrez		2/24/14 	
1.  Jordan Burke		2/25/14 	
1.  Zvi Effron		2/25/14 	
1.  Pranay Manwatkar		2/26/14 	
1.  Kaspars Mickevics		2/26/14 	
1.  Roman Gorodeckij		2/27/14 	
1.  Matthew Baxa		2/27/14 	
1.  Maxime Caumartin		2/27/14 	
1.  Brandon Raabe		2/28/14 	
1.  Alan Grosskurth		2/28/14 	
1.  Nathan Milford		2/28/14 	
1.  Jacob Vosmaer	GitLab.com	3/1/14 	
1.  Job van der Voort	GitLab.com	3/1/14 	
1.  Marin Jankovski	GitLab.com	3/1/14 	
1.  Martin Glaß		3/1/14 	
1.  Sergey Sergeev		3/1/14 	
1.  Marshall Ian Farmer		3/2/14 	
1.  Markus Schabel		3/3/14 	
1.  Torben Knerr		3/4/14 	
1.  Pavel Sadikov		3/5/14 	
1.  David King		3/7/14 	
1.  Charles Guenther	Yelp	3/7/14 	
1.  Kris Wehner	Yelp	3/7/14 	
1.  Brian Fletcher	Workday	3/10/14 	
1.  Brad Pokorny	IBM	3/10/14 	
1.  John Warren	IBM	3/10/14 	
1.  Lance Bragstad	IBM	3/10/14 	
1.  Luis Garcia	IBM	3/10/14 	
1.  Mark Vanderwiel	IBM	3/10/14 	
1.  Mathew Odden	IBM	3/10/14 	
1.  Andrew Coulton		3/11/14 	
1.  Andrew Ordiales		3/11/14 	
1.  Will Hattingh		3/12/14 	
1.  Eohyung Lee		3/13/14 	
1.  Matthew Zito	BMC Software Inc	3/13/14 	
1.  Nick Galbreath		3/13/14 	
1.  Thomas Duckering		3/14/14 	
1.  Stanley Halka		3/14/14 	
1.  Michael Morris		3/14/14 	
1.  Gavin Montague	itison	3/14/14 	
1.  John Daniels	itison	3/14/14 	
1.  Matthias Endler		3/17/14 	
1.  Greg Albrecht	OnBeep, Inc.	3/19/14 	
1.  Andy Issacson	OnBeep, Inc.	3/19/14 	
1.  Ben Graver	OnBeep, Inc.	3/19/14 	
1.  Jim Qin	OnBeep, Inc.	3/19/14 	
1.  Carlos Vinueza	OnBeep, Inc.	3/19/14 	
1.  Benson Miller	Level 11 Consulting	3/19/14 	
1.  Nik Ormseth	Level 11 Consulting	3/19/14 	
1.  James Francis	Level 11 Consulting	3/19/14 	
1.  Kevin Rivers	Level 11 Consulting	3/19/14 	
1.  Michael Dellanoce		3/20/14 	
1.  Joey Line		3/21/14 	
1.  Nick Lopez		3/22/14 	
1.  Jason Byck		3/23/14 	
1.  Ian Neubert		3/25/14 	
1.  Brandon Taylor Groves		3/25/14 	
1.  Sean Walberg		3/25/14 	
1.  Matthijs Wijers		3/26/14 	
1.  Tensibai Zhaoying		3/26/14 	
1.  Michael Chletso		3/27/14 	
1.  Joseph Korkames		3/27/14 	
1.  Matthew Juszczak		3/27/14 	
1.  Hongbin Lu		3/27/14 	
1.  Ryan Lewon		3/28/14 	
1.  Tiru Srikantha		3/29/14 	
1.  Calvin Worsnup		3/31/14 	
1.  Andres More		4/1/14 	
1.  Joe Richards		4/1/14 	
1.  Mikael Henriksson		4/2/14 	
1.  Benjamin Dalton LeMasurier		4/2/14 	
1.  Dirk Moermans		4/3/14 	
1.  Pavel Yudin		4/4/14 	
1.  Ed Neville	Linaro Limited	4/4/14 	
1.  Andrew McDermott	Linaro Limited	4/4/14 	
1.  Ron Nandy	Linaro Limited	4/4/14 	
1.  Florian Holzhauer		4/4/14 	
1.  Joshua Yotty		4/4/14 	
1.  Narendra V Dharmavarapu		4/4/14 	
1.  Brian Wilson Leake		4/6/14 	
1.  John Northrup		4/7/14 	
1.  Yoichi Isozaki		4/7/14 	
1.  Jordan Evans		4/8/14 	
1.  Oliver Kohl		4/9/14 	
1.  Craig Monson		4/10/14 	
1.  Rob Brown		4/10/14 	
1.  Alexander Myasnikov		4/11/14 	
1.  Matthew Hodgkins		4/12/14 	
1.  Aaron Quint		4/12/14 	
1.  Jaewoo Kim		4/17/14 	
1.  Vasiliy Tolstov		4/17/14 	
1.  Ryan Moe		4/18/14 	
1.  G. Panula		4/21/14 	
1.  Chris Antenesse		4/21/14 	
1.  Lloyd Chan		4/22/14 	
1.  Satoshi Tanaka		4/22/14 	
1.  Tim Heckman		4/24/14 	
1.  Trevor Lauder		4/25/14 	
1.  Nathan Haneysmith	Nordstrom	4/25/14 	
1.  Aaron Lane		4/26/14 	
1.  Bao Nguyen		4/27/14 	
1.  Salvatore Poliandro III		4/28/14 	
1.  Eric Zhoe		4/29/14 	
1.  Alex Kahn		4/29/14 	
1.  Brendan Murtagh		4/29/14 	
1.  Tyler Cipriani		4/29/14 	
1.  Syunsuke Komma	WESEEK	4/29/14 	
1.  Yuki Takei	WESEEK	4/29/14 	
1.  Trevor Bramwell		5/1/14 	
1.  Robert Tarrall		5/1/14 	
1.  Josh Reichardt		5/1/14 	
1.  Trevor Lauder	Intuit	5/1/14 	
1.  Jake Plimack		5/2/14 	
1.  Brian D Clark		5/3/14 	
1.  Roman Chukh		5/4/14 	
1.  Nick Montgomery		5/4/14 	
1.  Patrick Moore		5/5/14 	
1.  Edmund Dipple		5/6/14 	
1.  Kyle Boorky		5/6/14 	
1.  Olivier Larivain		5/6/14 	
1.  Aaron Valade		5/7/14 	
1.  Jonathan Serafini		5/7/14 	
1.  Jason Nelson	Rackspace	5/8/14 	
1.  Alexander Meng		5/8/14 	
1.  Kyle McGovern	Cerner Innovation Inc	5/8/14 	
1.  Jesse Washburn		5/8/14 	
1.  Ian Blenke		5/9/14 	
1.  Jochen Seeber		5/9/14 	
1.  Florin Stan		5/9/14 	
1.  Bearnard Hibbins		5/12/14 	
1.  Amruta Krishna	Cerner Innovation Inc	5/13/14 	
1.  Daniel Zautner		5/13/14 	
1.  Andrew DuFour		5/13/14 	
1.  David Gil Oliva		5/19/14 	
1.  Emmanuel Sciara		5/20/14 	
1.  Francois Visconte		5/21/14 	
1.  Cyril Scetbon		5/21/14 	
1.  Doug Wilson	CustomInk	4/4/14 	
1.  Meherez Alachheb		5/22/14 	
1.  Ash Wilson	Rackspace	5/22/14 	
1.  Alexey Velikiy		5/21/14 	
1.  Anand Suresh		5/24/14 	
1.  Christoph Krämer		5/26/14 	
1.  Marcus Nilsson		5/27/14 	
1.  Eric Black		5/27/14 	
1.  Michiel Sikkes		5/29/14 	
1.  Miguel Landaeta		5/29/14 	
1.  Claude Ballew Jr		5/29/14 	
1.  Carlos Macasaet		5/29/14 	
1.  Steve Jansen		6/3/14 	
1.  Jake Champlin		6/4/14 	
1.  Alistair Stead	Iniqa UK, Ltd	6/4/14 	
1.  Fahd Sultan		6/4/14 	
1.  Martin Smith III	Rackspace	6/4/14 	
1.  Klaas Jan Wierenga		6/5/14 	
1.  Michael Bumann		6/6/14 	
1.  Grant Hudgens		6/6/14 	
1.  Rob Redpath	World Wide Web Hosting, LLC	6/6/14 	
1.  Benjamin Ahrens		6/9/14 	
1.  Alessio Franceschelli		6/10/14 	
1.  Joseph Bowman		6/11/14 	
1.  William Cody Crawford		6/11/14 	
1.  Ryan Trauntvein		6/12/14 	
1.  Adam Lavin		6/14/14 	
1.  Brett Cave	Jemstep	6/13/14 	
1.  Matt Wrock		6/16/14 	
1.  William Clark		6/17/14 	
1.  Karsten McMinn		6/17/14 	
1.  Alexander Simonov		6/17/14 	
1.  James Coleman		6/18/14 	
1.  Charles Ruhl		6/18/14 	
1.  Pushkar Subhash Raste		6/19/14 	
1.  John Coleman		6/20/14 	
1.  Joshua Rutherford		6/20/14 	
1.  Elijah Buck		6/21/14 	
1.  Nikalai Stakanov		6/22/14 	
1.  Blair Hamilton		6/22/14 	
1.  Jeffrey Goldschrafe		6/24/14 	
1.  Vijay Bheemineni		6/25/14 	
1.  Joshua Benjamin		6/25/14 	
1.  Stafford Brunk		6/25/14 	
1.  Sumit Gupta		6/26/14 	 	
1.  Jan Mara		6/27/14
1. Christopher Webber Chef Software, Inc. 2008-03-05
1. Douglas Knight  2010-09-09
1. Alma Chao Facebook 2012-05-08
1. Pim Berger Schuberg Philis B.V. 2012-08-02
1. Melanie Howe Ontario Systems 2013-01-23
1. Michael Curry IBM 2013-05-14
1. Sean Knapp Ooyala, Inc 2013-10-09
1. Franklin Webber  2014-06-12
1. Sean OMeara  2014-06-12
1. Mike Splain  2014-06-12
1. Joshua Timberman  2014-06-12
1. Mike Splain PayPal, Inc. 2014-06-12
1. Franklin Webber  2014-06-12
1. Christopher Webber  2014-06-13
1. Nathen  Harvey  2014-06-13
1. Julian Dunn  2014-06-13
1. Seth Vargo  2014-06-13
1. James Scott  2014-06-13
1. James Scott  2014-06-13
1. Steven Danna  2014-06-13
1. Paul Mooring  2014-06-13
1. Tristan O'Neil  2014-06-13
1. Brian Cobb  2014-06-13
1. Soo Choi  2014-06-13
1. Soo Choi  2014-06-13
1. Josh Brand  2014-06-13
1. Mike Biang  2014-06-13
1. Larry Eichenbaum  2014-06-13
1. Josh Black  2014-06-16
1. Peter Fern  2014-06-16
1. Brian Flad  2014-06-17
1. James Walker  2014-06-17
1. Karl Shrubb  2014-06-17
1. Jonathan Asghar  2014-06-17
1. Brett Chalupa FullStack 2014-06-17
1. Greg Albrecht OnBeep, Inc. 2014-06-17
1. Richard Harvey Ngineered 2014-06-17
1. Brett Chalupa  2014-06-17
1. Mike Fiedler  2014-06-17
1. Jonathan Asghar  2014-06-17
1. Yves Laroche  2014-06-17
1. Greg Albrecht  2014-06-17
1. Darron Froese  2014-06-17
1. Darron Froese  2014-06-17
1. Jorge Espada  2014-06-17
1. Richard Harvey  2014-06-17
1. Jorge Espada  2014-06-17
1. Jonathan Hartman  2014-06-17
1. Allan Espinosa  2014-06-18
1. Troy Ready  2014-06-18
1. Jeremy Olliver  2014-06-18
1. Arjuna Christensen  2014-06-18
1. Jameson Lee  2014-06-18
1. Jameson Lee  2014-06-18
1. Gavin Reynolds  2014-06-18
1. Fletcher Nichol  2014-06-18
1. Pete Cheslock  2014-06-18
1. Pete Cheslock  2014-06-18
1. Michael Ivey  2014-06-18
1. Matt Ray  2014-06-18
1. Seth Chisamore  2014-06-18
1. Alex Vinyar  2014-06-18
1. Christian Vozar  2014-06-19
1. Christian Vozar Belly, Inc. 2014-06-19
1. David Radcliffe  2014-06-19
1. Sander van Zoest OneHealth Solutions, Inc. 2014-06-19
1. Brint O'Hearn  2014-06-19
1. Sander van Zoest  2014-06-19
1. Jay Perry Brightcove 2014-06-19
1. Jon Cowie  2014-06-19
1. Jake Champlin  2014-06-19
1. Karl Shrubb  2014-06-19
1. Panagiotis Papadomitsos  2014-06-20
1. Curtis Stewart  2014-06-20
1. Chaz Ruhl  2014-06-21
1. Chaz Ruhl  2014-06-21
1. Jesse Nelson  2014-06-22
1. Kristian Vlaardingerbroek  2014-06-22
1. Daniel Searles  2014-06-23
1. Serdar Sutay  2014-06-23
1. Jeff Byrnes  2014-06-23
1. Eric Herot  2014-06-23
1. William Young  2014-06-23
1. William Young  2014-06-23
1. Cassiano Leal  2014-06-23
1. Joseph Nuspl  2014-06-23
1. Joseph Nuspl  2014-06-23
1. Daniel Searles  2014-06-23
1. Ryan Hass  2014-06-23
1. Eric Herot EverTrue, Inc. 2014-06-23
1. Craig Lewis Central Desktop 2014-06-23
1. James Le Cuirot  2014-06-24
1. Ian Meyer  2014-06-24
1. Paul MacDougall  2014-06-24
1. Jeff Blaine  2014-06-24
1. John Martin  2014-06-24
1. Matt Mencel  2014-06-24
1. Mike Thibodeau  2014-06-24
1. Phong Ha  2014-06-24
1. Michael de Man  2014-06-24
1. Larry Zarou  2014-06-24
1. John Martin  2014-06-24
1. Kishore Kumar  2014-06-24
1. James Rosser  2014-06-24
1. Mathieu Sauve-Frankel  2014-06-24
1. Mathieu Sauve-Frankel  2014-06-24
1. Scott Likens  2014-06-24
1. Scott Likens  2014-06-24
1. Tensibai Zahoying  2014-06-24
1. Tensibai Zahoying  2014-06-24
1. Brian Clark  2014-06-24
1. Jordan Evans  2014-06-25
1. Brian Scott  2014-06-25
1. Stafford Brunk  2014-06-25
1. Hugo Lopes Tavares  2014-06-25
1. Ivan Larionov  2014-06-25
1. Harlan Barnes  2014-06-26
1. Jan Klare  2014-06-26
1. Yukihiko Sawanobori HiganWorks LLC 2014-06-26
1. Jessica Mink  2014-06-26
1. Thomas Robison  2014-06-26
1. Andreas Thielen adesso mobile solutions GmbH 2014-06-27
1. Alban  Diguer  2014-06-27
1. Andreas Thielen  2014-06-27
1. Hugo Trippaers  2014-06-27
1. Torben Knerr  2014-06-27
1. Kirill Shirinkin  2014-06-28
1. Hendrik Schaeidt  2014-06-28
1. Nikita Borzykh Express 42 2014-06-29
1. Alex Zepeda  2014-06-29
1. Mohit Sethi  2014-06-30
1. Florian Holzhauer  2014-06-30
1. Jesse Hu  2014-06-30
1. Richard Banks  2014-07-01
1. Richard Banks Codaptive (Pty) Ltd 2014-07-01
1. Teemu Matilainen  2014-07-01
1. Steffen Gebert  2014-07-01
1. Xabier de Zuazo Onddo Labs 2014-07-01
1. Vijay Bheemineni  2014-07-01
1. Richard Banks  2014-07-01
1. Sean Porter  2014-07-02
1. Michael Heijmans  2014-07-02
1. Patrick Collins  2014-07-02
1. Sean Porter Sean Porter Consulting 2014-07-02
1. BK Box  2014-07-02
1. Sean Walberg  2014-07-02
1. Erkan Yilmaz  2014-07-02
1. Jesse Davis  2014-07-02
1. Florin Stan  2014-07-03
1. Olle Lundberg Klarna 2014-07-03
1. Tim Dysinger  2014-07-03
1. Elan Ruusamäe  2014-07-03
1. Tristan Keen  2014-07-03
1. Olle Lundberg  2014-07-03
1. Simeon Willbanks  2014-07-03
1. Ryan Cragun  2014-07-03
1. Ranjib Dey  2014-07-03
1. Brian Dwyer  2014-07-03
1. Christopher Read  2014-07-03
1. Jerry Jackson a Committee of Lunatics, LLC 2014-07-03
1. David Petzel  2014-07-04
1. Per Hasselström  2014-07-04
1. Timothy Smith  2014-07-06
1. Evan Sosenko  2014-07-06
1. Mike Morris  2014-07-07
1. Paul Welch  2014-07-07
1. Andrei Neculau  2014-07-07
1. Scott Ford  2014-07-07
1. Tyler Fitch  2014-07-07
1. Zachary Stevens  2014-07-07
1. Nacer Laradji  2014-07-07
1. Jeffrey Carapetyan  2014-07-07
1. Joshua Zitting  2014-07-07
1. Jonathan Serafini  2014-07-07
1. Mark Ayers  2014-07-08
1. Justin Campbell  2014-07-08
1. Roland Moriz Moriz GmbH 2014-07-08
1. Mischa Taylor  2014-07-08
1. Hannes Van De Vreken  2014-07-08
1. Roland Moriz  2014-07-08
1. Daniel  Webb  2014-07-08
1. Luke Bradbury  2014-07-08
1. Eric Wolfe  2014-07-08
1. Peter Jönsson  2014-07-08
1. Paul Czarkowski  2014-07-08
1. Tucker DeWitt  2014-07-09
1. Marcin Sawicki  2014-07-09
1. Stanislav Bogatyrev  2014-07-09
1. Chris Aumann  2014-07-09
1. Ramya Kailas  2014-07-09
1. Peter Fox  2014-07-09
1. Giovanni Toraldo  2014-07-09
1. Elijah Buck  2014-07-09
1. Dinu Arateanu  2014-07-09
1. Christian Höltje  2014-07-09
1. Roman Chukh  2014-07-09
1. Jared Everett  2014-07-09
1. George Miranda  2014-07-09
1. Michael Nikitochkin  2014-07-09
1. Lloyd Chan  2014-07-09
1. Florin Stan TCN Inc 2014-07-09
1. Michael Nikitochkin JetThoughts LLC 2014-07-09
1. John Alberts  2014-07-10
1. Jonathan Tron  2014-07-10
1. Ron Cuirle  2014-07-10
1. Christopher Grinnan grincom 2014-07-10
1. Christopher Grinnan  2014-07-10
1. Greg Hellings  2014-07-10
1. Jonathan Tron Openhood "Halter & Tron" S.E.N.C. 2014-07-10
1. Egor Medvedev  2014-07-10
1. Ishtiaq Ahmed  2014-07-10
1. Egor Medvedev Clodo 2014-07-10
1. Leo Gallucci  2014-07-11
1. Tobias Johnson  2014-07-11
1. Andrey Linko  2014-07-11
1. Michael Bumann  2014-07-11
1. Sam Kottler  2014-07-11
1. Joseph Stump  2014-07-11
1. Fernando Honig  2014-07-11
1. Emmanuel Sciara  2014-07-11
1. Federico Gimenez Nieto  2014-07-11
1. Ryan Trauntvein  2014-07-11
1. Melinda Moran  2014-07-11
1. Wayne Huang  2014-07-11
1. Daniel Sweeting  2014-07-11
1. Federico Gimenez  2014-07-11
1. Aneel Nazareth  2014-07-11
1. Wilson Felipe Pereira  2014-07-11
1. Christoph Krämer  2014-07-11
1. Matt Wormley  2014-07-11
1. John Bellone  2014-07-11
1. Stephen Figgins  2014-07-11
1. Kent Spillner  2014-07-11
1. Aaron Baer  2014-07-11
1. Cameron Johnston  2014-07-11
1. Clayton Barber  2014-07-11
1. David Schlenk Spanlink Communications 2014-07-11
1. John Bellone Bloomberg Finance L.P. 2014-07-11
1. John Bellone Bluedog Operations 2014-07-11
1. Drew Rothstein  2014-07-11
1. Nick Downs  2014-07-11
1. Phil Kates  2014-07-12
1. Marc Climent  2014-07-12
1. Gregor Zurowski  2014-07-12
1. Masatoshi Iwasaki  2014-07-12
1. Kristian Van Der Vliet  2014-07-12
1. Martin Walton  2014-07-12
1. Christophe Arguel  2014-07-12
1. Michael de Bruin  2014-07-12
1. Tomohito Kanno  2014-07-12
1. Christopher Laco  2014-07-12
1. Angelo Olivera  2014-07-12
1. Joel Moss  2014-07-12
1. Nolan Davidson  2014-07-12
1. Ian Delahorne  2014-07-12
1. Joseph Holsten  2014-07-12
1. Vsevolod Polyakov  2014-07-12
1. Anthony Scalisi  2014-07-12
1. Alexander Simonov  2014-07-12
1. Jean-Francois Theroux  2014-07-12
1. Andrea Granata  2014-07-12
1. Jordan Wesolowski  2014-07-12
1. Andy Thompson  2014-07-12
1. Philip Hutchins  2014-07-12
1. Phil Cohen  2014-07-12
1. jason walker  2014-07-12
1. Drew Sonne  2014-07-12
1. Ben Tisdall  2014-07-13
1. Venkat Naidu  2014-07-13
1. Kyle Boorky  2014-07-13
1. 莫 測  2014-07-13
1. Martin Smith  2014-07-13
1. Maciej Nowak  2014-07-13
1. Sean Fleming  2014-07-13
1. Kristofer  Sommestad  2014-07-13
1. Josh Blancett  2014-07-13
1. fang duan  2014-07-13
1. Oleksandr Slynko  2014-07-13
1. Jose Luis Salas  2014-07-13
1. Barrie Bremner  2014-07-13
1. Jonty Wareing  2014-07-13
1. Venkat Naidu Heartland Payment Systems 2014-07-13
1. Steve Carman  2014-07-14
1. Matt Whiteley Engine Yard, Inc. 2014-07-14
1. Ilan Rabinovitch  2014-07-14
1. Marcus Morris  2014-07-14
1. Ilmari Kontulainen Deveo 2014-07-14
1. Jason Vanderhoof  2014-07-14
1. Gert Kremer  2014-07-14
1. Jake Plimack  2014-07-14
1. Vincent Kenney  2014-07-14
1. Sam Dunne  2014-07-14
1. Alexander Meng  2014-07-14
1. James Herdman  2014-07-14
1. Ahmed Ibrahim  2014-07-14
1. Thomas Meeus  2014-07-14
1. NagaLakshmi N  2014-07-14
1. Bao Nguyen Ooyala 2014-07-14
1. Adrian Moisey  2014-07-14
1. Reid Beels  2014-07-14
1. Satoshi Tanaka  2014-07-14
1. Rodolfo Castellanos  2014-07-15
1. Ben Klang Mojo Lingo LLC 2014-07-15
1. Matt Wrock  2014-07-15
1. Steve Buzonas FancyGuy Technologies 2014-07-15
1. Ralf Haferkamp  2014-07-15
1. James Pic  2014-07-15
1. Ben Longden  2014-07-15
1. Chris Fortier  2014-07-15
1. Steve Buzonas  2014-07-15
1. Robby Dyer  2014-07-15
1. Greg Fitzgerald  2014-07-15
1. Brian Dupras  2014-07-15
1. Christian Fischer  2014-07-15
1. Nathan Huff  2014-07-15
1. Ben Langfeld  2014-07-15
1. Brian Stajkowski  2014-07-15
1. Sean Escriva Heavy Water Operations 2014-07-16
1. Brian Stajkowski Bally Technologies 2014-07-16
1. Darren Birkett Rackspace 2014-07-16
1. Blake Irvin  2014-07-16
1. Aaron Kalin  2014-07-16
1. Olivier Brisse  2014-07-16
1. Sean Escriva Caleb Hailey 2014-07-16
1. Justin Shepherd Rackspace 2014-07-16
1. Andrew Goktepe  2014-07-16
1. Oleg Rekutin  2014-07-16
1. Vic Iglesias  2014-07-16
1. Adam Leff  2014-07-16
1. Brett Cavé Jemstep Inc. 2014-07-16
1. Max Lincoln  2014-07-17
1. Anthony Goddard  2014-07-17
1. Kane Rogers  2014-07-17
1. Matthieu Ouellette-Vachon  2014-07-17
1. Andrew Brown BlackBerry Ltd. 2014-07-17
1. Alastair Firth  2014-07-17
1. James Cuzella  2014-07-17
1. Kenneth Vestergaard  2014-07-17
1. Fred Clausen  2014-07-17
1. Sameer Arora  2014-07-17
1. Haggai Zagury  2014-07-17
1. John Barney  2014-07-17
1. Chad Barraford  2014-07-17
1. David Barbarisi  2014-07-17
1. Bill Findley  2014-07-17
1. Chad Barraford RStudio, Inc. 2014-07-17
1. Dustin Collins  2014-07-18
1. Bernie Durfee  2014-07-18
1. Cam Cope  2014-07-18
1. Jean Rouge  2014-07-18
1. Guilhem Lettron  2014-07-18
1. Achim Rosenhagen ffuenf 2014-07-19
1. Jeremy Murray  2014-07-19
1. Achim Rosenhagen  2014-07-19
1. Yusuke  Murata  2014-07-20
1. Jose Luis Ferrer Riera  2014-07-20
1. Pavel Yudin  2014-07-20
1. Bryan Stenson  2014-07-21
1. Lyndon Washington  2014-07-21
1. Alexandre Garnier  2014-07-21
1. Sten Spans  2014-07-21
1. Tim Rha  2014-07-21
1. Grant Heffernan  2014-07-21
1. Derek Groh  2014-07-21
1. Justin Reagor  2014-07-21
1. Nathaniel Eliot  2014-07-21
1. Grant Bowman  2014-07-22
1. Justin Schuhmann  2014-07-22
1. David Kinzer  2014-07-22
1. Grant Bowman Grantbow Consulting 2014-07-22
1. Anshul Sharma  2014-07-22
1. Matthew Riddle  2014-07-22
1. Amruta Krishna Ravavarapu  2014-07-22
1. Thomas Berger  2014-07-23
1. Graham Weldon  2014-07-23
1. Olivier Dolbeau  2014-07-23
1. Ryan Uber  2014-07-23
1. Peter Burkholder  2014-07-23
1. Rune Madsen  2014-07-23
1. Nick Gerakines  2014-07-23
1. Isaac Mungai  2014-07-23
1. Gabor Nagy  2014-07-23
1. Matt Clifton  2014-07-23
1. Rune Madsen O'Reilly Media 2014-07-23
1. Patrick Birt AdRem Systems Corporation 2014-07-24
1. Jeroen Jacobs  2014-07-24
1. Ram Akuka  2014-07-24
1. Jason Rust  2014-07-24
1. Philip Hutchins PHutchins 2014-07-24
1. Wayne Huang Revinate, Inc. 2014-07-24
1. Ram Akuka Deutsche Telekom HBS 2014-07-24
1. Steven Murawski  2014-07-25
1. Alex Brehm  2014-07-25
1. Shawn Edwards Bloomberg LP 2014-07-25
1. Eugene Alekseev  2014-07-25
1. Nicolas DUPEUX  2014-07-25
1. Heath Snow  2014-07-25
1. Alex Brehm  2014-07-25
1. Scott Lavender  2014-07-25
1. Paul McCallick  2014-07-25
1. Dimitri Aivaliotis  2014-07-26
1. Kraig Amador  2014-07-26
1. Kraig Amador Ticketmaster 2014-07-26
1. James FitzGibbon  2014-07-27
1. Andrew DuFour  2014-07-27
1. Adrian Petrescu  2014-07-28
1. Tyler Bird Engine Yard 2014-07-28
1. Thomas Petchel  2014-07-28
1. Tyler Bird  2014-07-28
1. Dmitry Tsoy  2014-07-28
1. Mikhail Zholobov  2014-07-28
1. Dmitry Tsoy chewbacco 2014-07-28
1. Braulio Bhavamitra  2014-07-29
1. Daniel Spilker CoreMedia AG 2014-07-29
1. Eric Helgeson  2014-07-29
1. Wes Morgan Democracy Works, Inc. 2014-07-29
1. Bráulio Bhavamitra EITA 2014-07-29
1. Alexey Mochkin  2014-07-29
1. Jesse Adams  2014-07-29
1. Djuri Baars  2014-07-29
1. Wes Morgan  2014-07-29
1. Alex Shkurko  2014-07-30
1. Sytse Sijbrandij GitLab B.V. 2014-07-30
1. James Hebden  2014-07-30
1. Yukio Goto  2014-07-30
1. Matt Thomson  2014-07-30
1. Andy Fraley  2014-07-30
1. Nathan Williams  2014-07-30
1. Michael Fischer  2014-07-30
1. Sean Clemmer  2014-07-30
1. Brian Celenza  2014-07-31
1. Sándor Ács MTA SZTAKI 2014-07-31
1. Joe Rocklin  2014-07-31
1. Arthur Huggard Cerner Corporation 2014-07-31
1. Victor Lowther  2014-07-31
1. Yoway Buorn  2014-07-31
1. Travis Warlick  2014-07-31
1. Nathan Cerny  2014-07-31
1. Travis Warlick Travis Warlick LLC 2014-07-31
1. Andrew Bennett  2014-07-31
1. Matt Kasa  2014-08-01
1. Mark Luntzel  2014-08-01
1. Matt Kasa Granicus, Inc. 2014-08-01
1. Derek Groh Texas A&M University 2014-08-01
1. Raul Rangel  2014-08-01
1. Sean Fisk  2014-08-01
1. Nick Shemonsky  2014-08-01
1. Jeremiah Snapp  2014-08-01
1. Aaron Lane  2014-08-02
1. Pieter Lazzaro  2014-08-03
1. Aubrey Holland  2014-08-03
1. Daniel O'Connor  2014-08-03
1. Boris Komraz  2014-08-04
1. H. "Waldo" Grunenwald  2014-08-04
1. Peter Donald  2014-08-04
1. Panagiotis Papadomitsos Splunk Inc. 2014-08-05
1. Evan Sosenko OurTownRentals.com 2014-08-05
1. Andrew Williams Intoximeters, Inc 2014-08-05
1. Hart Hoover  2014-08-05
1. Mike Tyler  2014-08-05
1. Jennifer Davis  2014-08-05
1. Andrew Williams  2014-08-05
1. Christine Draper ThirdWave Insights LLC 2014-08-05
1. Sam Marx  2014-08-05
1. Jay Mundrawala  2014-08-06
1. Daryl Robbins  2014-08-06
1. Pierre Rambaud  2014-08-06
1. Maciej Majewski  2014-08-06
1. Patrick Wright  2014-08-06
1. Bill Warner  2014-08-06
1. John Ewart  2014-08-07
1. Gabriel Mazetto  2014-08-07
1. Ladislav Gazo Seges 2014-08-07
1. Ricardo Signes  2014-08-07
1. Christoph Mertz  2014-08-07
1. Davide Cavarretta  2014-08-07
1. Dominic Watson  2014-08-08
1. Bradley Wangia  2014-08-08
1. Dominic Watson Pixl8 Interactive Ltd 2014-08-08
1. Russell Parks  2014-08-08
1. Jason Vanderhoof Gazelle 2014-08-08
1. Kazuki Saito  2014-08-09
1. David Severski  2014-08-09
1. Robert Northard  2014-08-09
1. Virender Khatri  2014-08-09
1. Aaron Wagoner  2014-08-10
1. Eisuke Kuwahata  2014-08-11
1. Oh Young Jooung  2014-08-11
1. Alan Willis  2014-08-11
1. Baptiste Courtois  2014-08-11
1. Matthew Thode Rackspace Hosting, Inc. 2014-08-11
1. Egor Medvedev  2014-08-11
1. Matthew Thode  2014-08-11
1. Joshua Kwan  2014-08-11
1. lance lance.zhou  2014-08-11
1. Paul Thomas  2014-08-11
1. Mike Dillion  2014-08-12
1. Ringo De Smet  2014-08-12
1. Grzegorz Kołodziejczyk  2014-08-12
1. Paul Turner  2014-08-12
1. Chen Harel Takipi 2014-08-12
1. Chen Harel  2014-08-12
1. Thom May  2014-08-13
1. Rick Saenz  2014-08-13
1. Brendan O'Donnell  2014-08-13
1. Jamie Winsor  2014-08-13
1. Greg Palmier  2014-08-13
1. Patrick Moore  2014-08-13
1. Roman Kulayev  2014-08-13
1. Brian DeFeyter  2014-08-13
1. Brandon Burton  2014-08-14
1. Jon San Miguel  2014-08-14
1. Chase Bolt  2014-08-14
1. Jean Mertz  2014-08-14
1. David O Neill  2014-08-14
1. Joel Smith  2014-08-14
1. Capen Brinkley  2014-08-14
1. Kevin Lamontagne De Marque 2014-08-14
1. Andre Elizondo  2014-08-15
1. Mathias Lafeldt  2014-08-15
1. Miguel Ferreira  2014-08-15
1. Michael Mior  2014-08-15
1. Stan Chan  2014-08-15
1. Koji Tanaka  2014-08-16
1. Lennart Brinkmann  2014-08-16
1. Mario Baricevic Web Man d.o.o. 2014-08-17
1. Tom Robison  2014-08-17
1. Mario Baricevic  2014-08-17
1. Barthelemy Vessemont  2014-08-18
1. Heavy Water Operations Heavy Water Operations, LLC. 2014-08-18
1. Heavy Water Operations  2014-08-18
1. Dave Eddy  2014-08-18
1. Malte Swart  2014-08-18
1. Giorgos Saslis  2014-08-18
1. Brian Bianco  2014-08-19
1. Thomas Massmann  2014-08-19
1. Thomas Massmann  2014-08-19
1. Noah Kantrowitz  2014-08-19
1. Darshana Runwal Cerner Corporation 2014-08-19
1. Stephen Sugden  2014-08-20
1. Ben Snape  2014-08-20
1. John Coleman  2014-08-21
1. Miles Miller  2014-08-21
1. Martin Forssen  2014-08-21
1. Serhii Balbieko  2014-08-21
1. Matt Barlow Rackspace 2014-08-22
1. Dmitry Ryobryshkin  2014-08-22
1. Peter Abbott  2014-08-24
1. Cory Stephenson  2014-08-24
1. Christopher Jerdonek  2014-08-25
1. Nicolas Blanc  2014-08-26
1. Jonathan Mickle  2014-08-26
1. Simon Detheridge Widgit Software 2014-08-26
1. Dieter Blomme  2014-08-26
1. Seth Thomas  2014-08-26
1. david karapetyan  2014-08-26
1. Pete Crossley  2014-08-26
1. Justin Locsei  2014-08-26
1. Moshe Zvi  2014-08-26
1. Ben Hartshorne  2014-08-26
1. Dieter Blomme Picabit 2014-08-26
1. Fabio Napoleoni  2014-08-27
1. Charles Guenther Yelp Inc 2014-08-27
1. Brian Cottingham  2014-08-27
1. Sho Sawada Bitcellar, Inc. 2014-08-27
1. Steve Jansen  2014-08-27
1. Maurice Kherlakian  2014-08-27
1. Peter Halliday  2014-08-27
1. Amruta Krishna Ravavarapu  2014-08-27
1. Craig Lewis  2014-08-27
1. Rory Savage  2014-08-28
1. Dave Molinari McKesson 2014-08-28
1. Dave Molinari  2014-08-28
1. Lennart Koopmann TORCH GmbH 2014-08-28
1. Romain Cambien  2014-08-29
1. Quentin Madec  2014-08-29
1. Mevan Samaratunga  2014-08-29
1. Sebastián Otaegui  2014-08-30
1. Jose Ortiz  2014-08-31
1. Doc Walker  2014-08-31
1. Mitja Kleider  2014-08-31
1. D flatterlight  2014-08-31
1. Scott Bonds  2014-09-01
1. Eugenio Marzo pronetics 2014-09-01
1. Eugenio Marzo  2014-09-01
1. David Aronsohn  2014-09-02
1. Suleyman Kutlu  2014-09-02
1. Petar Koraca  2014-09-02
1. Mark deVilliers  2014-09-03
1. Patrick Debus-Pesquet Numergy 2014-09-03
1. David Workman  2014-09-03
1. Tom Alexandrowicz  2014-09-03
1. Scott Severtson  2014-09-03
1. Brian Begy  2014-09-04
1. Jay Zhu  2014-09-04
1. David Chauviere  2014-09-04
1. Jason Kulatunga  2014-09-04
1. Yvo Vandoorn  2014-09-05
1. Ben Scott  2014-09-05
1. Christoph Maser  2014-09-05
1. Lucas Mariani  2014-09-07
1. Stanisław Tuszyński  2014-09-08
1. Brandon Raabe  2014-09-08
1. Chris Richard  2014-09-09
1. Nick Dobson  2014-09-09
1. Nick Dobson  2014-09-09
1. Kieren Hynd  2014-09-09
1. Christopher McClimans  2014-09-09
1. Scott Marshall  2014-09-09
1. Tim George EveryPay AS 2014-09-09
1. Eric Pullen Appriss, Inc. 2014-09-09
1. Jeffrey Baird  2014-09-10
1. Guillaume Turri  2014-09-10
1. Daniel Perez  2014-09-10
1. Nathaniel Hoag  2014-09-10
1. Daniel Perez Claude Tech 2014-09-10
1. Brandon Robinson  2014-09-10
1. Tom Scott TelVue Corporation 2014-09-11
1. Frederico Araujo Omise.co 2014-09-11
1. Frederico Araujo  2014-09-11
1. Mars Ma  2014-09-11
1. Nabeel Shahzad  2014-09-11
1. Tom Scott  2014-09-11
1. Romain Niccoli Criteo S.A. 2014-09-11
1. Paul Ruiz  2014-09-11
1. Alexander Myasnikov  2014-09-12
1. Mark Luntzel  2014-09-12
1. Taylor Ludwig  2014-09-13
1. Todd Pigram  2014-09-13
1. Nickolas Montgomery  2014-09-13
1. Eric Shamow  2014-09-13
1. Aaron Wartner  2014-09-14
1. Tomokazu Takada  2014-09-14
1. Karl Shrubb Expedia, Inc. 2014-09-15
1. Felix Wong  2014-09-15
1. Robert Berger  2014-09-16
1. George Secillano  2014-09-16
1. Johannes Plunien  2014-09-16
1. Drew Oliner  2014-09-16
1. Eric Heydrick  2014-09-17
1. Jared Szechy  2014-09-17
1. Petr Michalec  2014-09-17
1. Benjamin Marsteau  2014-09-17
1. James Bence  2014-09-17
1. Stephan Linz  2014-09-19
1. Endre Hirling  2014-09-19
1. Paul Krohn  2014-09-19
1. shaun mouton  2014-09-22
1. Mike Tavares EBSCO 2014-09-22
1. Raul Naveiras  2014-09-22
1. Neven Burica  2014-09-22
1. Antonio Peña  2014-09-22
1. Olivier Bazoud  2014-09-23
1. G Arends  2014-09-23
1. Eric Saxby  2014-09-23
1. Greg Osuri  2014-09-23
1. Andrew Gale  2014-09-23
1. William Watson  2014-09-24
1. Jeremy Shipman  2014-09-24
1. Pavel Danelian  2014-09-25
1. Ryan Bowlby  2014-09-25
1. Rob Chekaluk  2014-09-25
1. Jonas Kongslund  2014-09-25
1. Baptiste Courtois Criteo 2014-09-25
1. George Secillano SAP 2014-09-26
1. Greg Poirier  2014-09-26
1. Muthukumar Jayaraman  2014-09-26
1. Garett Shulman  2014-09-26
1. George Secillano  2014-09-26
1. Jonas Kongslund  2014-09-27
1. James Hu  2014-09-27
1. Shobhit Srivastava  2014-09-28
1. Alex Glover  2014-09-29
1. Trevor North  2014-09-29
1. Christopher Gunther  2014-09-29
1. Matias De Carli  2014-09-29
1. Andrew Coulton inGenerator Ltd 2014-09-29
1. Paul Dunnavant  2014-09-29
1. Deni Chekirda  2014-09-30
1. Justin Mazzi WWWH LLC 2014-09-30
1. Karol Szuster  2014-09-30
1. Ho-Sheng Hsiao  2014-09-30
1. Dennis Hoer  2014-09-30
1. Denis Chekirda  2014-09-30
1. Christian Kaspar  2014-10-01
1. Léo Unbekandt  2014-10-01
1. Mal Graty  2014-10-01
1. Simas Čepaitis  2014-10-02
1. Daniel Hagerty  2014-10-02
1. Michael Burns  2014-10-02
1. Nellie Shamrell-Harrington  2014-10-03
1. Ryan Larson  2014-10-03
1. Greg Palmier RapidWorkspace 2014-10-04
1. Alex Pop  2014-10-04
1. Justin Witrick  2014-10-06
1. Oleg Levy  2014-10-06
1. Krzysztof Szarek  2014-10-06
1. Peter Niederlag  2014-10-06
1. Justin Witrick Rackspace 2014-10-06
1. Joe Bergantine  2014-10-07
1. Nicolas DUPEUX  2014-10-07
1. Aurélien Léger  2014-10-07
1. Benjamin Carpenter  2014-10-08
1. Jun Nishikawa Monomono 2014-10-08
1. Shinya Furuwata  2014-10-08
1. Roger North-Row  2014-10-08
1. Chris Fordham  2014-10-08
1. Jonathan Hall  2014-10-09
1. Nawaid Shamim  2014-10-09
1. Richard Manyanza  2014-10-09
1. Bernhard Weisshuhn  2014-10-09
1. Doug Ireton Nordstrom, Inc. 2014-10-10
1. Nowell Strite  2014-10-10
1. Mathew Kamkar  2014-10-10
1. Ryan Hass  2014-10-10
1. Lemuel Formacil  2014-10-10
1. Christopher Luciano  2014-10-12
1. Takahiro Horikawa InfoLens, Inc. 2014-10-13
1. John Brodie  2014-10-13
1. Fernando Monserrat  2014-10-13
1. Takahiro Horikawa  2014-10-13
1. Thomas Boerger Webhippie 2014-10-13
1. Takahiro Horikawa InfoLens, Inc. 2014-10-13
1. Thomas Boerger  2014-10-13
1. Tsukasa Sato  2014-10-13
1. Isa Farnik  2014-10-14
1. Fahd Sultan  2014-10-14
1. Chris Fordham Xhost Australia 2014-10-14
1. Fahd Sultan Simulmedia, Inc 2014-10-14
1. Chris Fordham  2014-10-14
1. Shinya Furuwata  2014-10-15
1. Paul Dunnavant Mypaulie 2014-10-15
1. Ciaran Farrell SUSE LINUX Products GmbH 2014-10-15
1. Nicolas Szalay  2014-10-15
1. masaki yamada  2014-10-15
1. Shinya Furuwata None 2014-10-15
1. Peter West  2014-10-15
1. Shinya Furuwata  2014-10-15
1. Maciej Pasternacki  2014-10-16
1. Krzysztof Wilczynski  2014-10-16
1. Shinya Furuwata  2014-10-16
1. Anne Moroney  2014-10-16
1. Marc Paradise  2014-10-16
1. Colby Olson  2014-10-16
1. Shawn Weitzel  2014-10-16
1. Don  Becker  2014-10-17
1. Jordan  Dea-Mattson Yahoo 2014-10-17
1. Michael Schmidt  2014-10-17
1. Matt Greensmith  2014-10-17
1. John Schwinghammer  2014-10-17
1. Jeff Goldschrafe  2014-10-18
1. John Deatherage Juniper Networks, Inc. 2014-10-19
1. Miguel Landaeta  2014-10-19
1. John Deatherage  2014-10-19
1. Kevin Lee  2014-10-20
1. Jonathan Whitaker  2014-10-20
1. Brian Stajkowski Bulletproof Networks 2014-10-20
1. Brian Stajkowski  2014-10-20
1. a a fd 2014-10-20
1. a a  2014-10-20
1. Mandeep Bal  2014-10-21
1. Mandeep Bal  2014-10-21
1. Norman Joyner Norman Joyner 2014-10-21
1. Norman Joyner  2014-10-21
1. Don L.  2014-10-21
1. Jesus Gutierrez  2014-10-21
1. Jesus Gutierrez  2014-10-21
1. Misha Soliterman  2014-10-21
1. Terry Fundak TJSoftworks 2014-10-21
1. Terry Fundak  2014-10-21
1. Prakash Palanisamy  2014-10-22
1. Gavin Sandie Sneacho 2014-10-22
1. Kevin Burnett  2014-10-22
1. Ben Wright  2014-10-22
1. Jan Mara  2014-10-22
1. Sean Clemmer  2014-10-22
1. Eugene Narciso  2014-10-23
1. TADOKORO Saneyuki  2014-10-23
1. Arne Sund  2014-10-24
1. Dennis Konert  2014-10-24
1. Alexander Merkulov  2014-10-24
1. Mikael Henriksson  2014-10-24
1. Clark Everetts  2014-10-25
1. Christopher Coffey  2014-10-26
1. Zhang zlcolin  2014-10-26
1. Dan Fruehauf  2014-10-26
1. cybermerc industries  2014-10-26
1. Christoph Hartmann  2014-10-26
1. Anuj Biyani  2014-10-28
1. Chris Lundquist  2014-10-28
1. Alex Falkowski  2014-10-28
1. Lopaka Delp  2014-10-28
1. Fabian Ruff  2014-10-29
1. Javier Rodríguez  2014-10-29
1. Justin Kolberg  2014-10-29
1. Sean Cribbs  2014-10-29
1. JD Isaacks  2014-10-29
1. Dennis Klein  2014-10-29
1. Tyler Cloke  2014-10-29
1. Sylvain Tissot Ecodev 2014-10-30
1. Jason  Perry Brightcove, Inc 2014-10-30
1. Deepak Sihag  2014-10-30
1. Eric Feldhusen  2014-10-30
1. Dustin Van Buskirk  2014-10-30
1. Cloudrifles Chotiwattanapol  2014-10-30
1. Deepak Sihag NA 2014-10-30
1. Vincent Van Driessche  2014-10-31
1. Nicholas Thompson  2014-10-31
1. Steven De Coeyer  2014-11-02
1. Steven De Coeyer Stack-up 2014-11-02
1. Leo Unbekandt Scalingo 2014-11-03
1. Amir Kadivar  2014-11-03
1. Peter Kringle  2014-11-03
1. Jeremiah Dabney  2014-11-04
1. Dave Parfitt  2014-11-04
1. Gary McLean Hall  2014-11-04
1. Mark Anderson  2014-11-05
1. Andreas Rayo Kniep  2014-11-05
1. Christian Rodriguez  2014-11-05
1. Noam Ben Ari  2014-11-05
1. Mark Pimentel  2014-11-05
1. Damian Gerow  2014-11-06
1. Carlos Diaz  2014-11-10
1. Michael Burns  2014-11-11
1. Prajakta Purohit  2014-11-11
1. Lance Andersen  2014-11-11
1. Brent Walker  2014-11-11
1. Vasiliy Tolstov  2014-11-11
1. Ravi Bhure  2014-11-12
1. Rahul Janghel Xpanxion 2014-11-12
1. Carlos Diaz Covario 2014-11-12
1. Norberto Lopes  2014-11-12
1. Hiroki Mizuma  2014-11-12
1. Jun Heider  2014-11-12
1. Rahul Janghel  2014-11-12
1. Biju Nair  2014-11-13
1. Paolo Sechi  2014-11-13
1. Daniel Barker  2014-11-13
1. John Dewey  2014-11-13
1. Joshua Kwan Schrodinger, Inc. 2014-11-14
1. Krzysztof Krzyżaniak  2014-11-14
1. Eric Swenson  2014-11-14
1. Pradeep Mishra  2014-11-15
1. Aditya Bhardwaj  2014-11-15
1. Sam Martin  2014-11-15
1. Ranjib Dey  2014-11-15
1. Steve Clark  2014-11-16
1. Alexander De Leon  2014-11-16
1. Edmund Dipple  2014-11-17
1. Emanuel Evans  2014-11-17
1. Thomas Guinther  2014-11-17
1. Sean Nolen  2014-11-17
1. Sarah Kowalik  2014-11-17
1. Kei Hirata  2014-11-17
1. Yulian Kuncheff  2014-11-18
1. Jihyung Song SK Planet 2014-11-18
1. Lucy Wyman  2014-11-18
1. Jason Potkanski  2014-11-18
1. Julien Bianchi  2014-11-18
1. Jihyung Song  2014-11-18
1. Jeremy Miller Heartland Payment Systems 2014-11-18
1. Julien Bianchi jubianchi.fr 2014-11-18
1. Eric Citaire  2014-11-19
1. Joseph Ryan  2014-11-19
1. Eric Citaire Médiamétrie 2014-11-19
1. Lane Maxwell Terra Firma Engineering, LLC 2014-11-19
1. David Strauss Pantheon Systems, Inc. 2014-11-20
1. David Strauss  2014-11-20
1. Brian Felton  2014-11-21
1. Chirag Jog Clogeny Technologies 2014-11-21
1. Daniel Dreier  2014-11-21
1. Andres Franco  2014-11-21
1. Jason Williams DigiTar Inc. 2014-11-22
1. Jason Williams  2014-11-22
1. adam enger  2014-11-23
1. william pink  2014-11-24
1. Anduin Withers  2014-11-24
1. Maciej Strzelecki  2014-11-24
1. Geoffrey Tran  2014-11-24
1. Michael Gilliland  2014-11-24
1. Jacob McCann  2014-11-24
1. Grant Ridder  2014-11-25
1. Eric Greer Second Mind 2014-11-25
1. Eric Greer  2014-11-25
1. Mohit Dilawari Localytics 2014-11-25
1. Pablo Gutiérrez del Castillo  2014-11-25
1. Tarak Blah  2014-11-25
1. Tigran Kavanosyan  2014-11-25
1. Willington Vega  2014-11-26
1. Timur Batyrshin  2014-11-26
1. Moshe Katz  2014-11-26
1. shuo zhang  2014-11-27
1. l r  2014-11-29
1. Luca Rovinetti  2014-11-29
1. Yuu Yamashita  2014-11-29
1. Scott Kinney  2014-12-02
1. Benjamin Pillet  2014-12-02
1. Peter Adkins  2014-12-03
1. Roy Ratcliffe  2014-12-03
1. Nitzan Raz  2014-12-04
1. Lee Skillen  2014-12-04
1. Dmitriy Bielorusov  2014-12-05
1. Dmitriy Bielorusov Anerhan 2014-12-05
1. Jamie Alessio  2014-12-06
1. Kazuki Ota Treasure Data, Inc. 2014-12-06
1. Sander van Zoest  2014-12-07
1. Nikolay Murga  2014-12-08
1. Jason Schadel  2014-12-08
1. Brian Cajes  2014-12-08
1. James Lovelace Yakara Ltd 2014-12-09
1. Anjaneya Raju  2014-12-09
1. sofer Athlan-Guyot  2014-12-09
1. Cesare Bellini Yakara Ltd 2014-12-09
1. R Southard CirrusMio 2014-12-10
1. Christopher Coffey  2014-12-11
1. Blair Hamilton  2014-12-12
1. Steve Nolen  2014-12-13
1. Szabolcs Zajdo  2014-12-13
1. Martha Greenberg  2014-12-14
1. denny dennyzhang  2014-12-14
1. Connor Beckett  2014-12-15
1. Grégoire Seux Criteo 2014-12-15
1. Manea Eugen  2014-12-15
1. Andrew Fleener  2014-12-16
1. Nico Kadel-Garcia  2014-12-16
1. Dmitri Toubelis  2014-12-16
1. Michael Lewis  2014-12-17
1. Yoway Buorn Sumo Logic 2014-12-18
1. Roberto Moutinho  2014-12-19
1. John Collier  2014-12-23
1. Tom Parker  2014-12-25
1. Sergiu Ionescu  2014-12-27
1. Jaroslav Gorjatsev  2014-12-28
1. Tatyana Arenburg  2014-12-29
1. Dustin Collins Conjur 2014-12-31
1. Dustin Collins  2014-12-31
1. Trevor Bramwell  2014-12-31
1. Nathaniel Michael  2015-01-02
1. Andrew Christianson  2015-01-02
1. Evangelos Pappas  2015-01-02
1. Michael Mittelstadt  2015-01-02
1. Lance Albertson  2015-01-04
1. Jesse Hauf  2015-01-05
1. PORTE Loïc PMSIpilot 2015-01-05
1. Timothy Quinn Mad13 Entertainment 2015-01-06
1. Rasmus Praestholm  2015-01-06
1. Kota Shiratsuka INSANEWORKS,LLC 2015-01-06
1. Edmund Haselwanter  2015-01-06
1. Timothy Quinn  2015-01-06
1. Alfonso Bocanegra de Luis  2015-01-07
1. Yusuke Tanaka  2015-01-08
1. Naotoshi Seo  2015-01-09
1. Shinichi Morita  2015-01-09
1. Adam Renberg  2015-01-09
1. Diego Plentz  2015-01-10
1. Diego Plentz Tautt 2015-01-10
1. Jeffrey Hutchison  2015-01-11
1. Jason Brody-Stewart-Stroeh  2015-01-11
1. Chris Burroughs AddThis 2015-01-12
1. Gerald Hevener  2015-01-14
1. Chris Pernicano  2015-01-14
1. Ben Vidulich  2015-01-14
1. Brandon O'Connor  2015-01-14
1. Brandon O'Connor DreamBox Learning, Inc. 2015-01-14
1. Uchit Vyas  2015-01-15
1. David O Neill Intel 2015-01-15
1. Tim Nicholas  2015-01-15
1. IT Adminstrator OptiShot Golf 2015-01-16
1. Richard Henning  2015-01-16
1. Thomas Orozco  2015-01-16
1. IT Adminstrator  2015-01-16
1. Tim Miller RightScale 2015-01-16
1. Kai Sasaki  2015-01-18
1. Richard Nixon  2015-01-18
1. Nick Silkey  2015-01-19
1. Daniel Givens  2015-01-19
1. Kai Sasaki Yahoo Japan 2015-01-19
1. Ovais Tariq  2015-01-19
1. Ivan Suftin  2015-01-19
1. Zachary Pallin  2015-01-19
1. Matt Vollrath  2015-01-20
1. I-Ming Chen  2015-01-20
1. denny dennyzhang001  2015-01-21
1. Barry Allard  2015-01-21
1. William Albenzi  2015-01-21
1. denny dennyzhang OSC Technologies, LLC 2015-01-21
1. Ning Hin Lincoln Lee  2015-01-22
1. Phil Schuler  2015-01-23
1. Bill Moritz  2015-01-23
1. Van Thoai Nguyen  2015-01-23
1. Weihang Jian  2015-01-23
1. Florian Breisch  2015-01-24
1. Romain Vrignaud  2015-01-24
1. Michael Proctor-Smith  2015-01-25
1. Yi Ming Yin  2015-01-26
1. Aniessh Sethh Aniessh Sethh 2015-01-28
1. Mark jonson  2015-01-28
1. Aniessh Sethh  2015-01-28
1. Jonathan Bogaty  2015-01-30
1. Neven Burica Motorcycle Industry Council 2015-01-30
1. Andrew Kerr  2015-01-31
1. Dan Herman  2015-01-31
1. Aaron Lane  2015-02-02
1. Helgi Thorbjoernsson Engine Yard, Inc. 2015-02-02
1. Icinga Team Icinga 2015-02-02
1. Icinga Team  2015-02-02
1. William Salt  2015-02-02
1. Stuart Preston  2015-02-02
1. David Muto  2015-02-02
1. Evan Gilman  2015-02-03
1. Chris Kacerguis  2015-02-03
1. David Muto pseudomuto 2015-02-03
1. Joris van Lieshout  2015-02-04
1. Matt Whiteley  2015-02-04
1. Antoni Baranski  2015-02-04
1. Igor Shpakov  2015-02-04
1. Michael Glenney  2015-02-05
1. Claudiu SONEL  2015-02-05
1. Pierre-Luc Dion CloudOps Inc. 2015-02-07
1. Sam Martin N/A 2015-02-07
1. Ricardo Lupo  2015-02-07
1. Pierre-Luc Dion  2015-02-07
1. Christopher Lambacher  2015-02-08
1. Sergey Storchay Magemaven 2015-02-09
1. Erik van Brakel eVision Industry Software 2015-02-09
1. Sergey Storchay PE 2015-02-09
1. Sergey Storchay  2015-02-09
1. Richard Grasshoff  2015-02-10
1. Claudio Sanchez Tejeda  2015-02-10
1. Cyril Scetbon  2015-02-11
1. takaaki furukawa  2015-02-11
1. Martijn van der Kleijn AIRFRANCE / KLM 2015-02-12
1. Stefan Staudenmeyer  2015-02-12
1. Seb Patane  2015-02-13
1. Andy Glick  2015-02-13
1. Dale Hui  2015-02-13
1. Surya Avirneni  2015-02-14
1. Zi Kang Gan  2015-02-17
1. Pete Buletza Elyxor, Inc 2015-02-17
1. Cedric Lamalle  2015-02-17
1. Adolfo Pérez Álvarez  2015-02-17
1. Scott Smith  2015-02-17
1. Matt Williams  2015-02-18
1. Nickolay Kovalev  2015-02-19
1. Nickolay Kovalev  2015-02-19
1. FedeX FedeX  2015-02-19
1. Nickolay Kovalev Coderico 2015-02-19
1. Nickolay Kovalev Coderico 2015-02-19
1. kay tani-olu  2015-02-20
1. Hemal Varambhia  2015-02-20
1. Christopher Auston  2015-02-20
1. Anthony Miller  2015-02-20
1. Denis Barishev  2015-02-20
1. kourosh parsa  2015-02-20
1. Tatsuya Suzuki  2015-02-21
1. Federico Castagnini  2015-02-21
1. Jacob Minshall  2015-02-22
1. Ranjib Dey PagerDuty 2015-02-23
1. Drew Rapenchuk AdREM Systems 2015-02-24
1. Drew Rapenchuk  2015-02-24
1. Mike Juarez  2015-02-24
1. Gavin Sandie  2015-02-24
1. Ross Duggan Barricade Security Systems, Ltd. 2015-02-25
1. Jeremy Przygode Stratalux, Inc. 2015-02-25
1. Jeremy Przygode  2015-02-25
1. Matt Eldridge  2015-02-25
1. Alexander Dupuy  2015-02-26
1. Zia Rahman  2015-02-26
1. Sky  Eyes  2015-02-27
1. Julian Tabel  2015-02-27
1. Vandad Chaharlengi  2015-02-27
1. Sky Eyes TpT 2015-02-27
1. Nellie Shamrell-Harrington Chef 2015-02-27
1. Drew Blessing  2015-02-28
1. Sunggun Yu  2015-02-28
1. Christopher Zeeb  2015-03-01
1. Michael Belt  2015-03-03
1. Matthew Clifton Standard Edge 2015-03-04
1. Rilindo Foster  2015-03-04
1. Rudger Gravestein  2015-03-04
1. Joe Heung  2015-03-04
1. Ray Rodriguez  2015-03-04
1. Surya Avirneni  2015-03-04
1. Chris Gianelloni  2015-03-04
1. Kyleen MacGugan  2015-03-04
1. Joe Heung RevelOps Inc 2015-03-04
1. Jean-Francois Bibeau  2015-03-05
1. sai kiran skmothe Qwinix Technologies 2015-03-05
1. Dennis Pattmann  2015-03-05
1. Brian Smith  2015-03-05
1. Josh Bradley  2015-03-05
1. Ganesh Ramnarine  2015-03-05
1. Martín Buceta  2015-03-06
1. Nick Willever  2015-03-06
1. Henrique Zambon  2015-03-06
1. Bradley Steinfeld  2015-03-06
1. Zhong YU Wu  2015-03-06
1. Leons Petrazickis  2015-03-06
1. Nilesh Londhe  2015-03-07
1. Brian Goad  2015-03-07
1. David Brown  2015-03-08
1. Pavlo Dotsulenko  2015-03-08
1. Max Sills Google, Inc. 2015-03-09
1. Eiki Kanai  2015-03-09
1. Maurizio PIllitu  2015-03-09
1. Isao SHIMIZU  2015-03-09
1. Holger Just  2015-03-09
1. Daniel Paulus  2015-03-09
1. Jason Musits  2015-03-09
1. Nicholas Slowes  2015-03-09
1. Kirt Fitzpatrick  2015-03-09
1. Ann Brady  2015-03-09
1. Daisuke HIGUCHI CREATIONLINE,INC. 2015-03-09
1. Josh Dolitsky  2015-03-10
1. HIROSE Masaaki  2015-03-10
1. Blake Irvin yetu AG 2015-03-10
1. Alex Derzhi  2015-03-10
1. Simon Kaluza  2015-03-10
1. General Counsel Dynamic Network Services Inc. 2015-03-11
1. Pawan Verma Target Corporation 2015-03-11
1. Sean Chon  2015-03-12
1. Kirt Fitzpatrick  2015-03-12
1. Michael Hedgpeth  2015-03-12
1. Kim Dowling  2015-03-12
1. Steve Lowe  2015-03-12
1. Wenjun Huang  2015-03-13
1. Benjamin Staffin  2015-03-13
1. Jonathan Chapman  2015-03-13
1. Jerrel Blankenship  2015-03-13
1. William Drew  2015-03-13
1. Andy Smith  2015-03-14
1. Dave Parfitt  2015-03-15
1. Shashi Shilarnav  2015-03-16
1. Jose Palafox Cisco 2015-03-16
1. Rob Pierucci  2015-03-16
1. Shashi Shilarnav sshilarnav 2015-03-16
1. Enrico Stahn  2015-03-17
1. Benoit Plessis  2015-03-18
1. sai kiran Mothe Qwinix Technologies 2015-03-18
1. Tim Sogard  2015-03-18
1. Rocky Olsen  2015-03-19
1. Gene Wood  2015-03-19
1. Kevin Van Wilder  2015-03-19
1. Ryan Lee  2015-03-19
1. Federico Castagnini Self 2015-03-19
1. Adam Alboyadjian Vista Higher Learning, Inc. 2015-03-19
1. Kaustubh Deorukhkar  2015-03-20
1. Stephen Wright  2015-03-20
1. Stephen Wright Cars.com 2015-03-20
1. Ross McKinley  2015-03-20
1. Alain Al  2015-03-21
1. Zackery Nunez  2015-03-21
1. Dominique Poulain left-left-lemma Oy 2015-03-22
1. Megan Oliver Carbonite 2015-03-23
1. Gary Waters  2015-03-23
1. Mike Tougeron  2015-03-24
1. Allan Beaufour Sum Labs, Inc 2015-03-24
1. Thomas Hughes  2015-03-24
1. Lloyd Dewolf  2015-03-24
1. Jean-Baptiste Dalido Batch.com 2015-03-24
1. Jean-Baptiste Dalido  2015-03-24
1. Guillaume Plessis  2015-03-24
1. Ilan Rabinovitch  2015-03-25
1. Slava Kardakov  2015-03-26
1. Bailey Belvis  2015-03-26
1. Slava Roussakov  2015-03-26
1. Jacob Ingram  2015-03-26
1. Lingfu Zhang  2015-03-27
1. William Jimenez  2015-03-27
1. Anju Tiwari  2015-03-27
1. Yusuke Goto  2015-03-28
1. Maksim Chizhov  2015-03-28
1. Miguel Fonseca Mindera 2015-03-30
1. Dmytro Ilchenko  2015-03-30
1. Dmytro Ilchenko  2015-03-30
1. Miguel Fonseca  2015-03-30
1. Szymon Szypulski  2015-03-30
1. Aaron Walker  2015-03-31
1. Shai Rosenfeld  2015-03-31
1. Pedro Carriço  2015-03-31
1. Pedro Carriço  2015-03-31
1. Manuel Mazzuola  2015-03-31
1. Matt Stanford  2015-03-31
1. Igor Kanyuka  2015-03-31
1. Rebekah Cha  2015-03-31
1. Manuel Mazzuola ClouDesire SRL 2015-03-31
1. vipul sharma self 2015-04-01
1. Gerrit Tamboer  2015-04-01
1. Rebekah Cha  2015-04-01
1. Ian Kronquist  2015-04-02
1. Tony ptQa  2015-04-02
1. Topher Cullen  2015-04-02
1. Michael Misshore  2015-04-02
1. Yanick Duchesne  2015-04-02
1. Volodymyr Babchynskyy  2015-04-02
1. Michael Misshore Mudbug Media 2015-04-02
1. Chris Chambers  2015-04-02
1. William Fisher  2015-04-03
1. Daniel Steen  2015-04-03
1. Lance Albertson Oregon State University Open Source Lab 2015-04-03
1. Chris Hammer  2015-04-04
1. Brian Hays  2015-04-04
1. Yoshiyuki Kinjo  2015-04-05
1. Samuel Cassiba  2015-04-05
1. Luke Reimer  2015-04-06
1. Jeffrey Borcean  2015-04-06
1. Kirill Kouznetsov  2015-04-06
1. Timothy Heckman  2015-04-07
1. Kristian Järvenpää  2015-04-07
1. Christopher Potts  2015-04-07
1. Jimmy Puckett SPINEN 2015-04-08
1. Hrusikesh Panda  2015-04-08
1. Francis Nicholas  2015-04-08
1. Jimmy Puckett  2015-04-08
1. Jerrel Blankenship  2015-04-08
1. Florent Vilmart  2015-04-08
1. Damian Pantano  2015-04-08
1. Anthony Burns  2015-04-09
1. Yves Blusseau  2015-04-10
1. David Thornton Needle, Inc.  2015-04-10
1. Vincent Theron  2015-04-10
1. David Thornton  2015-04-10
1. Tony Pitale  2015-04-11
1. Claudiu Vădean  2015-04-11
1. David Joos  2015-04-11
1. WonGoo Lee  2015-04-12
1. Jeff LaPlante  2015-04-12
1. Sonny Garcia  2015-04-13
1. John Mickey  2015-04-13
1. Anthony Acquanita  2015-04-13
1. Matt Jones  2015-04-13
1. Simonas Kareiva  2015-04-14
1. Shane Auckland  2015-04-15
1. Jolyon Griffiths Calastone Ltd 2015-04-15
1. Derek Rosenzweig  2015-04-15
1. Andy Theuninck  2015-04-15
1. Artur Melo  2015-04-15
1. Kieren Evans  2015-04-15
1. Rodrigo Avila  2015-04-16
1. Brendan Germain  2015-04-16
1. YOSUKE INOUE  2015-04-17
1. Peter Gallagher  2015-04-17
1. Andrew Bennett Pixid Design 2015-04-17
1. Travis Davis  2015-04-17
1. Richard Abdill  2015-04-21
1. Tom Dooner  2015-04-22
1. Thomas Geirhovd  2015-04-23
1. Chris Van Heuveln  2015-04-23
1. Daniel Bjorge  2015-04-23
1. Trevor Hess  2015-04-23
1. Charles Wimmer  2015-04-23
1. Naoya Yoshizawa  2015-04-24
1. Roman Vakulchik  2015-04-24
1. Kavita Sachdeva  2015-04-24
1. Tomasz Sętkowski  2015-04-24
1. Trent Petersen  2015-04-24
1. Alex Naumchenko Devloft Solutions Inc. 2015-04-27
1. Alex Naumchenko  2015-04-27
1. Johnathan Kupferer  2015-04-27
1. Julien Pervillé Mingalar SAS 2015-04-28
1. Craig keyrage  2015-04-28
1. Remi Hakim  2015-04-28
1. Rachel Adler  2015-04-28
1. Joel Handwell  2015-04-28
1. Barthelemy Vessemont  2015-04-28
1. Andrey Rotchev  2015-04-29
1. James Denman  2015-04-29
1. Robert Castelle  2015-04-29
1. James Denman Latta Partners 2015-04-30
1. John Smyth  2015-04-30
1. Rex Cerbas  2015-04-30
1. Greg Karékinian  2015-04-30
1. James Denman  2015-04-30
1. Richard Guin  2015-04-30
1. James Denman  2015-04-30
1. Scott Saad  2015-04-30
1. Giovanni Toraldo ClouDesire 2015-04-30
1. John Frykland  2015-05-01
1. Seth Chisamore CHEF 2015-05-01
1. Kristin Triolo Hewlett-Packard 2015-05-01
1. Eiki Kanai  2015-05-01
1. Pascale-Andrée Audet  2015-05-01
1. Anthony Acquanita acquantia.me 2015-05-01
1. Dhawal Patel Nordstrom 2015-05-01
1. Dian Hansen Hewlett-Packard 2015-05-01
1. Radu Munteanu  2015-05-03
1. Stephan Kemper ViaSat, Inc. 2015-05-04
1. Alex Dunn  2015-05-04
1. Jonathan Lassoff  2015-05-04
1. Nikolay Kuzin Light Side 2015-05-05
1. Michael Burns  2015-05-05
1. Michael Burns  2015-05-05
1. Nikolay Kuzin  2015-05-05
1. Cheng-Dae Choe  2015-05-07
1. Eric Rutherford  2015-05-07
1. Daniel Condomitti  2015-05-07
1. John Lemp  2015-05-07
1. Joshua Glass Chef 2015-05-08
1. Marcus Nilsson  2015-05-08
1. Stefan Novak  2015-05-08
1. James Johnson  2015-05-09
1. Philipp Hellmich  2015-05-10
1. Phillip Roberts  2015-05-11
1. Fraser Scott  2015-05-11
1. Phillip Roberts Ingenium Group, LTD 2015-05-11
1. Simao Mata  2015-05-12
1. Derek Belrose  2015-05-12
1. Tobin Quadros  2015-05-12
1. Tobin Quadros  2015-05-12
1. Daniel Ben-Zvi  2015-05-12
1. Kavita Sachdeva self 2015-05-12
1. Jo Rhett  2015-05-12
1. Gabriel Rosendorf  2015-05-12
1. Biswajit Das  2015-05-12
1. Eric Renfro Linux-Help.org 2015-05-13
1. Eric Renfro  2015-05-13
1. Mark Keisler  2015-05-13
1. joe miller  2015-05-13
1. Dan Baggott  2015-05-14
1. John Maguire  2015-05-14
1. Alaa Qutaish  2015-05-14
1. Taylor Price  2015-05-14
1. Justin Seubert  2015-05-18
1. Jeremy Fleischman  2015-05-18
1. Vianney Foucault  2015-05-19
1. Leonardo Lima  2015-05-20
1. Richard Barkley  2015-05-20
1. ChangZhuo Chen  2015-05-21
1. Yoshi Spendiff  2015-05-21
1. Davida Marion  2015-05-21
1. Vladimir Skubriev  2015-05-21
1. Kouhei Sutou  2015-05-21
1. Eric Reeves Alert Logic, Inc. 2015-05-22
1. Jeff Arcuri Gap Inc 2015-05-22
1. Vianney Foucault  2015-05-22
1. spencer owen  2015-05-22
1. Rushin Panchal Resivaa Technologies Pvt LTD 2015-05-22
1. John Norden Alert Logic 2015-05-23
1. Franklin Hanson  2015-05-23
1. Chris Marchesi PayByPhone Technologies 2015-05-25
1. Michael Michael  2015-05-26
1. Brad Ison  2015-05-26
1. Richard Lock University of Derby 2015-05-27
1. Richard Lock  2015-05-27
1. take ookubo  2015-05-27
1. David Macpherson  2015-05-28
1. Dave Parfitt  2015-05-28
1. Greg Durham Chef 2015-05-28
1. Karen Bruner  2015-05-29
1. Scott McGillivray  2015-05-29
1. Mikhail Priver  2015-05-29
1. Tim Terhorst  2015-05-31
1. Olivier Lemasle  2015-05-31
1. Edward Bartholomew  2015-05-31
1. Larry Wright  2015-06-01
1. Jacob Bell  2015-06-01
1. Yeung Siu Citrix Systems, Inc. 2015-06-02
1. Eric Tucker Blue Spurs 2015-06-02
1. Aiman Alsari  2015-06-03
1. Eduardas Jarusevicius  2015-06-03
1. PaiCheng Tao  2015-06-03
1. Martin Chlumsky  2015-06-04
1. Jonathan Amiez  2015-06-04
1. Zach Malone  2015-06-05
1. Ishu Gupta  2015-06-05
1. Christopher Dickey  2015-06-05
1. pingdecopong pingdecopong  2015-06-05
1. Michael O'Connor  2015-06-07
1. Anirban Saha  2015-06-07
1. Brent Montague  2015-06-08
1. Jacob Royal  2015-06-08
1. Craig Bookwalter  2015-06-08
1. Anton Koldaev  2015-06-08
1. Miroslav Svoboda  2015-06-08
1. Adam Paxton  2015-06-08
1. Kaushik Chandrashekar  2015-06-09
1. Dan Varga  2015-06-09
1. Matt Wormley Myself 2015-06-09
1. Chris Knight hevnly 2015-06-10
1. Ramez Mourad Cvent 2015-06-10
1. Chris Knight  2015-06-10
1. Etienne Lafarge  2015-06-10
1. Chris Knight  2015-06-10
1. Nick Hudacin  2015-06-10
1. Ganesh Nalawade  2015-06-11
1. Simar Kalra  2015-06-11
1. Benjamin Pellittieri  2015-06-12
1. Patrick Connolly  2015-06-12
1. Torsten Schmits  2015-06-12
1. Lance Powell  2015-06-13
1. Antonio Terceiro  2015-06-14
1. Uldis Sturms  2015-06-14
1. John Kerry  2015-06-14
1. Paul Brown  2015-06-15
1. Matt Kantor  2015-06-15
1. Benjie Godfrey  2015-06-15
1. Adam Kerr  2015-06-16
1. Jonathan Serafini Jonathan Serafini 2015-06-16
1. Michael Villis  2015-06-16
1. Adam Linkous  2015-06-17
1. Michael Wheeler  2015-06-17
1. David Bernick  2015-06-18
1. Ilya Katz  2015-06-18
1. Matthew Johnson  2015-06-18
1. Ilya Katz ExecOnline 2015-06-18
1. Maximilian Fischer  2015-06-18
1. Michael Hedgpeth NCR 2015-06-18
1. Jean-Francois Mathiot ServeBox SAS 2015-06-19
1. Abhijit Hiremagalur   2015-06-19
1. Sebastian Boehm  2015-06-22
1. dongha kim neowiz games 2015-06-22
1. Christopher Chow  2015-06-22
1. Matthew Campbell  2015-06-22
1. Adam DePue  2015-06-23
1. Nick Ramirez  2015-06-23
1. Mark Cornick  2015-06-23
1. Ryan Lewon  2015-06-23
1. Daniel Piessens  2015-06-24
1. Bernhard Ott  2015-06-24
1. Maxime FOUILLEUL  2015-06-24
1. Wesley Schwengle  2015-06-24
1. Jeff Wood  2015-06-24
1. yusuke abe newsdict 2015-06-25
1. Igor Kurochkin Express42 2015-06-25
1. Emmanuel Iturbide  2015-06-25
1. Kevin Kennedy  2015-06-25
1. Igor Kurochkin  2015-06-25
1. yusuke abe  2015-06-25
1. Emmanuel Iturbide SAP 2015-06-25
1. Jean Baptiste Favre  2015-06-26
1. Peer Allan  2015-06-26
1. Mat Davies  2015-06-26
1. Kevin Dickerson  2015-06-30
1. Kevin Dickerson Loom Technology 2015-06-30
1. Nirmal Jonnalagedda Spanning Cloud Apps 2015-06-30
1. jay hendren  2015-06-30
1. Nirmal Jonnalagedda  2015-06-30
1. Matt Darby  2015-06-30
1. John Ramos DualSpark 2015-07-01
1. Andy Paroff  2015-07-02
1. Pavlos Ratis  2015-07-02
1. Quentin de Metz  2015-07-02
1. Nobuhiro Nikushi  2015-07-03
1. Andrei Ivanov  2015-07-03
1. Pavel Bobov  2015-07-05
1. Michael Klishin  2015-07-06
1. Roger Levy MariaDB USA 2015-07-07
1. Antoni Baranski  2015-07-08
1. Dale Neufeld Shopify Inc 2015-07-08
1. Sarath kumar  2015-07-08
1. Russell Whitaker  2015-07-08
1. Marek Dwulit  2015-07-09
1. Michael Thomas  2015-07-09
1. Christopher Bourez  2015-07-09
1. David Bresson  2015-07-09
1. Stefano Rivera Yola 2015-07-09
1. Wolf Noble  2015-07-10
1. Hector Castro  2015-07-10
1. Robert Rehberg  2015-07-10
1. Chitrang Jain  2015-07-10
1. Aeri Iamsirithaworn  2015-07-10
1. Ceaser Larry Divergent Logic 2015-07-11
1. Ceaser Larry  2015-07-11
1. Pieter Vogelaar  2015-07-12
1. Eric Internicola  2015-07-12
1. DalHo Park  2015-07-12
1. Jacob Rosenberg  2015-07-12
1. Kamesh Sampath  2015-07-13
1. Lachlan Munro  2015-07-13
1. James Hu Roboheart, Inc. 2015-07-14
1. Andreas Lappe  2015-07-14
1. Nuo Yan  2015-07-14
1. Ben Barnett  2015-07-14
1. Marek Dwulit  2015-07-15
1. Jeff Dawes  2015-07-15
1. Sriram Rajan  2015-07-15
1. Josh Schneider  2015-07-15
1. Katherine Rossiter  2015-07-16
1. Dan Stark  2015-07-17
1. Ben Dang  2015-07-18
1. Michal Knapik  2015-07-18
1. Anthony Moore  2015-07-19
1. Patrick Freeman  2015-07-19
1. Jimmy McCrory  2015-07-19
1. Derek Haynes Scoutapp 2015-07-20
1. Oswald De Riemaecker Continuous S.A. 2015-07-20
1. Nuno Pereira  2015-07-20
1. Martin Samuel  2015-07-20
1. Jorge Quilcate  2015-07-20
1. Shahul Hameed  Khajamohideen  2015-07-20
1. Jim Ryan Room 118 Solutions, Inc. 2015-07-21
1. Jim Ryan  2015-07-21
1. Adam Balali  2015-07-23
1. Francesco Stradiotti  2015-07-23
1. Eddy Boscolo  2015-07-24
1. Mohit Gupta  2015-07-24
1. Justin Ryan  2015-07-24
1. Patrick Schnetger  2015-07-27
1. Benoît Créau  2015-07-27
1. Marshall Levin  2015-07-27
1. Alexander De Leon Devialab 2015-07-28
1. Charles Lynch  2015-07-28
1. Alexander De Leon  2015-07-28
1. Heather Mickman Target Corporation 2015-07-29
1. Marco Gallotta Asana 2015-07-29
1. Washington Botelho  2015-07-29
1. Salim Alam Chef Inc. 2015-07-29
1. Alvaro Morales  2015-07-29
1. J.R. Mash  2015-07-30
1. Jason Barnett  2015-07-30
1. Michael Kelley  2015-07-30
1. Jacob Dearing  2015-08-01
1. Lennart Weijl  2015-08-01
1. Giovanni Del Valle  2015-08-01
1. Tommy Odom  2015-08-02
1. Dale Cook  2015-08-04
1. Zack Zondlo  2015-08-04
1. Vincent VAN HOLLEBEKE  2015-08-04
1. Vincent Stammegna CSAA IG 2015-08-05
1. Vincent Stammegna  2015-08-05
1. Ed Powell Digital River 2015-08-06
1. matthew patton  2015-08-06
1. Ed Powell  2015-08-06
1. Ed Powell Ed Powell 2015-08-06
1. Sean Hardy Expedia Affiliate Network 2015-08-07
1. Amulya Sharma  2015-08-09
1. Luc Francesca  2015-08-09
1. ABE Satoru  2015-08-10
1. Francois-Joseph GRIMAULT  2015-08-10
1. Renan Vicente Gomes da Silva  2015-08-11
1. Alex Dunn Tacit Knowledge 2015-08-11
1. Steven Swor  2015-08-11
1. Ron Russell  2015-08-12
1. Alain Chiasson  2015-08-12
1. Gabor Szelcsanyi Layer7 Cache 2015-08-13
1. Felipe Bessa Coelho  2015-08-13
1. Kurt Langrud The Buckle, Inc 2015-08-13
1. Gabor Szelcsanyi  2015-08-13
1. Leandro Di Tommaso  2015-08-13
1. Sergey Tuchkin  2015-08-17
1. David Giesberg  2015-08-17
1. Francis Nicholas Expedia 2015-08-18
1. Rafael Fonseca  2015-08-18
1. Scott Gorsuch  2015-08-18
1. Dmitry Grigorenko  2015-08-18
1. Federico Castagnini  2015-08-19
1. Peter Mooshammer  2015-08-19
1. Ian Duffy  2015-08-19
1. David Echols  2015-08-19
1. James Augustine  2015-08-20
1. Juan Manuel Rodulfo Salcedo  2015-08-20
1. Sarah Michaelson  2015-08-20
1. St. Isidore Seville  2015-08-21
1. Matthieu Roisil  2015-08-21
1. Benjamin Jansen  2015-08-21
1. Chris Jones  2015-08-22
1. Tarun Jangra  2015-08-22
1. Thibaut Notteboom  2015-08-24
1. Alain Dejoux  2015-08-24
1. Carl Perry  2015-08-24
1. Andrés F Vargas  2015-08-24
1. Mark Matten  2015-08-24
1. Mihai Petracovici  2015-08-25
1. Simon Thompson Imagination Technologies Ltd. 2015-08-27
1. Mateusz Kwiatkowski Serveraptor 2015-08-27
1. Jeff Zohrab  2015-08-28
1. Gregory McCue Ecosia GmbH 2015-08-28
1. Jeff Zohrab  2015-08-31
1. Alex Howells Aeode 2015-08-31
1. Alex Howells  2015-08-31
1. Mathew Goldsborough Forever Oceans Corporation 2015-09-01
1. Mathew Goldsborough  2015-09-01
1. james dupont  2015-09-03
1. Damian Pantano  2015-09-03
1. Anton Yushkov Flugel.it 2015-09-04
1. Marky Jackson  2015-09-04
1. Shawn Neal  2015-09-05
1. Leo Popov  2015-09-07
1. Diego Felix de Almeida  2015-09-08
1. Diego Felix de Almeida Diego 2015-09-08
1. Ruchi Goyal  2015-09-08
1. Vassilis Rizopoulos  2015-09-08
1. Sarath kumar TechM 2015-09-08
1. Sergey Permyakov  2015-09-09
1. Tarak Blah Tarak Blah 2015-09-10
1. Thorsten Kahler  2015-09-10
1. Jonathan Hutchins  2015-09-10
1. Stanislav Voroniy  2015-09-10
1. Justin Early  2015-09-11
1. Justin Early Alert Logic 2015-09-11
1. Daniel Wendorf  2015-09-13
1. Tony Flint  2015-09-14
1. Salvatore Poliandro  2015-09-15
1. Mikhail Zholobov  2015-09-15
1. Vandad Chaharlengi CustomInk 2015-09-15
1. Jason Boeshart  2015-09-15
1. Morgan Nelson  2015-09-17
1. David Chaiken  2015-09-18
1. Roger Delph  2015-09-19
1. Florent Flament  2015-09-20
1. Elad Dolev  2015-09-20
1. Nate Schmoll  2015-09-20
1. Matt Jones  2015-09-21
1. Soeren Unruh Humance AG 2015-09-21
1. Mikko Caldara  2015-09-21
1. Nathan Sullivan  2015-09-21
1. Joshua Hudson  2015-09-21
1. Kevin MA  2015-09-22
1. MA Goacid  2015-09-22
1. Karsten Richter  2015-09-22
1. Jose Olcese  2015-09-22
1. Greg Swallow  2015-09-23
1. Paul McCarthy  2015-09-23
1. Jordan Tardif  2015-09-23
1. Mikhail Bautin  2015-09-24
1. Andrew Mulholland  2015-09-24
1. Michael Pereira  2015-09-25
1. J. Lieberthal  2015-09-26
1. Jonathan Serafini  2015-09-26
1. Edmund Rhudy  2015-09-26
1. Adam Edwards  2015-09-26
1. Makoto Terada  2015-09-26
1. Glen Mailer  2015-09-28
1. Francisco Alcantara  2015-09-28
1. Joshua Burt  2015-09-28
1. Thomas Pike Crossroads Foundation Limited 2015-09-29
1. Robert Kidd  2015-09-29
1. Thomas Pike  2015-09-29
1. Hugo Sato  2015-09-29
1. Michael Nairn  2015-09-30
1. Greg Albrecht Orion Labs, Inc. 2015-09-30
1. david raistrick  2015-09-30
1. Brett Gailey  2015-10-01
1. David Kinzer  2015-10-02
1. Ketan Padegaonkar  2015-10-02
1. Derek Ditch Cyber Dev Team 2015-10-02
1. Derek Ditch  2015-10-02
1. Thiago Dias de Francisco  2015-10-02
1. Andrew Jones  2015-10-02
1. Thiago Francisco FCL 2015-10-02
1. Paul Welch  2015-10-05
1. Andrey Scopenco  2015-10-05
1. Adam Wilbraham  2015-10-06
1. Patrick Wright Chef 2015-10-06
1. Tony Flint Marchex, Inc. 2015-10-06
1. Samuel Bernard S4M 2015-10-07
1. Jeff Harvey-Smith  2015-10-07
1. Bill St. Clair  2015-10-07
1. G.J. Moed  2015-10-07
1. Patrick McMorran  2015-10-07
1. Jeremy Maziarz  2015-10-08
1. Pete Navarra  2015-10-09
1. Peter Abbott Myself 2015-10-10
1. Henry Finucane  2015-10-11
1. Michael Leyshon  2015-10-12
1. Cameron Walker  2015-10-12
1. Tyler Ball  2015-10-12
1. Jos Backus  2015-10-13
1. Nolan Davidson PhishMe 2015-10-13
1. Joshua Timberman  2015-10-13
1. Anthony Robinson  2015-10-13
1. Ronald Chmara  2015-10-14
1. Mike Morraye  2015-10-14
1. Yossi Gottlieb  2015-10-14
1. Wade Peacock  2015-10-15
1. Dayne Broderson  2015-10-16
1. Kyle Burckhard  2015-10-16
1. Eugene Bolshakov  2015-10-16
1. Arnoud Vermeer  2015-10-16
1. Vito Laurenza  2015-10-16
1. Dan Buch  2015-10-17
1. Clinton Wolfe  2015-10-17
1. Dan Buch Travis CI GmbH 2015-10-17
1. Mike Simons Hewlett Packard Enterprise 2015-10-19
1. Andy Cui  2015-10-19
1. Ryan Frantz  2015-10-19
1. Rocky Olsen  2015-10-20
1. Ken Gotoh  2015-10-21
1. Erik Rogneby  2015-10-21
1. Michael Roy  2015-10-23
1. Jason Harley  2015-10-23
1. Ryan Gerstenkorn  2015-10-23
1. Michael Roy mikeroySoft 2015-10-23
1. Jude Job  2015-10-23
1. Olivier Dolbeau  2015-10-26
1. Dmitry Batiievskyi  2015-10-26
1. Eric Guinois  2015-10-27
1. Jason McIntosh  2015-10-27
1. Jon A  2015-10-27
1. Rami Abdulhussein  2015-10-27
1. Hleb Valoshka  2015-10-27
1. Michael Miko  2015-10-28
1. James Flemer NDP, LLC 2015-10-28
1. Jaycee Bernardino  2015-10-28
1. James Flemer  2015-10-28
1. jez wain  2015-10-28
1. Priyal Jain  2015-10-28
1. Alex Vinyar chef 2015-10-29
1. Vipin V Gopal  2015-10-29
1. Bryant Lippert  2015-10-29
1. John Mickey  2015-10-30
1. John Manero  2015-10-30
1. Arnold Visser None 2015-11-02
1. Arnold Visser  2015-11-02
1. Jens Segers  2015-11-03
1. David Tagarro  2015-11-03
1. Emmanuel Guérin  2015-11-03
1. alex vinyar chef 2015-11-04
1. Adam Sulik  2015-11-04
1. Saibal Dey  2015-11-04
1. Rui Covelo  2015-11-04
1. Robert Perry Lodestone Technologies, LLC 2015-11-04
1. Kyle West  2015-11-04
1. Taliesin Sisson  2015-11-05
1. Goran Stankovski LimePoint Pty Ltd 2015-11-05
1. Bryan Crossland  2015-11-07
1. Phil Ruffwind  2015-11-08
1. Sam Rudge  2015-11-08
1. Evan Tschuy  2015-11-11
1. Timothy Schroeder  2015-11-11
1. Louis GOUNOT  2015-11-11
1. James Pruetting  2015-11-11
1. David Echols  2015-11-12
1. Tom Wilson  2015-11-12
1. echohack . echohack 2015-11-12
1. Chris Jones Bloomberg 2015-11-14
1. Roger Micone  2015-11-14
1. Sasha Gerrand  2015-11-15
1. Chris Marchesi  2015-11-15
1. Heinz Gies  2015-11-16
1. Sam Dunne AIB 2015-11-16
1. Mario Harvey  2015-11-16
1. Michael Miko  2015-11-17
1. Corey Hemminger NativeX Holdings LLC 2015-11-17
1. Gary Bright  2015-11-17
1. Michael Miko  2015-11-17
1. Chris Campbell  2015-11-17
1. Corey Hemminger  2015-11-17
1. Derek Bromenshenkel  2015-11-17
1. Phil Smith  2015-11-17
1. William Rowe  2015-11-17
1. Simon Gate  2015-11-18
1. David Meekin  2015-11-18
1. Justin Seubert  2015-11-19
1. Robert Moody  2015-11-19
1. cristiano balducci  2015-11-19
1. Piyatad Chotiwattanapol Cloudrifles 2015-11-20
1. Alain De Carolis  2015-11-20
1. Luke Young  2015-11-20
1. Piyatad Chotiwattanapol  2015-11-20
1. Piyatad Chotiwattanapol  2015-11-20
1. Cloudrifles Chotiwattanapol  2015-11-20
1. Rocky Olsen Dell SecureWorks 2015-11-20
1. Taufek Johar  2015-11-22
1. Taufek Johar Taufek 2015-11-22
1. Justin Ellison  2015-11-23
1. Edward Bosher  2015-11-24
1. Jose Ventura  2015-11-24
1. Jennifer Brown  2015-11-24
1. William Drew  2015-11-25
1. Danny Roberts  2015-11-25
1. Guillaume Jacquet  2015-11-25
1. Justin Spies BuyerQuest, Inc. 2015-11-25
1. Justin Spies  2015-11-25
1. John Dewey Cisco Systems 2015-11-28
1. Kamil Forys  2015-11-30
1. Federico Bucchi  2015-11-30
1. Yuu Yamashita  2015-12-01
1. Jesse Lee  2015-12-01
1. Steve Marshall  2015-12-02
1. Artem Sidorenko  2015-12-02
1. Gregory Symons  2015-12-02
1. Nerijus Bendziunas  2015-12-03
1. Jason Summerour The Weather Companies 2015-12-03
1. Robert Tarrall  2015-12-04
1. Chad Brown  2015-12-04
1. Richard Morrisey  2015-12-04
1. Mat Schaffer  2015-12-05
1. Jeff Powell  2015-12-07
1. Eiki Kanai  2015-12-07
1. Alexei Smirnov  2015-12-07
1. Simon Bang Terkildsen Monsenso 2015-12-07
1. Simon Terkildsen Monsenso 2015-12-07
1. Simon Terkildsen  2015-12-07
1. Ryan Chipman  2015-12-08
1. Julian Tabel  2015-12-08
1. Tim B  2015-12-08
1. James Legg  2015-12-09
1. Stephan Linz  2015-12-10
1. Peter Halliday Formatron 2015-12-10
1. Peter Halliday  2015-12-10
1. Paul Bernard Fidelity Investments 2015-12-10
1. Xavier Krantz  2015-12-10
1. Adam Phillabaum  2015-12-11
1. Fabricio Correa Duarte  2015-12-12
1. Wojciech Sciesinski  2015-12-14
1. Martin Fenner DataCite 2015-12-14
1. Michal Taborsky  2015-12-14
1. sadfsafsda thomas  2015-12-15
1. Justin Nauman  2015-12-15
1. Stephan Renatus  2015-12-16
1. Sean Walberg  2015-12-17
1. didier Belot  2015-12-17
1. Mikhail Zholobov Parallels 2015-12-17
1. Andrei Skopenko Parallels 2015-12-17
1. Ioannis Christodoulou  2015-12-17
1. Mikhail Zholobov  2015-12-17
1. Phil Grayson  2015-12-18
1. Robert Ulejczyk  2015-12-18
1. Benoît Créau  2015-12-18
1. Emir Ibrahimbegovic  2015-12-19
1. Robert Vežnaver  2015-12-20
1. Cash Weaver  2015-12-21
1. Stefan Hojer  2015-12-21
1. Robert Kidd  2015-12-22
1. Ryan Hitchcock  2015-12-22
1. Thomas Cate  2015-12-22
1. Bakh Inamov  2015-12-24
1. Ian Henry  2015-12-24
1. Karl Norby  2015-12-30
1. Kevin Park Wavefront, Inc. 2015-12-30
1. Matteo Giaccone  2015-12-30
1. Scott Weldon  2015-12-30
1. Steven Smith  2015-12-31
1. Charlie Andrews  2016-01-01
1. Michallis Pashidis Trust1Team 2016-01-01
1. Greg Nilchee  2016-01-04
1. Jose Mora  2016-01-04
1. Durant Damien  2016-01-05
1. Wojciech Guszpit  2016-01-05
1. Matthieu Mota  2016-01-05
1. Jeffrey Hulten  2016-01-05
1. Viktor LOOSZ  2016-01-06
1. Ben Dang Yahoo 2016-01-07
1. Ian Penney Nulogy Corporation 2016-01-07
1. Joe Armstrong  2016-01-07
1. Andrei Krasnitski  2016-01-08
1. Levi Smith  2016-01-08
1. James Reichley  2016-01-08
1. Aiman Alsari Salmon 2016-01-08
1. Brian Menges  2016-01-08
1. Jun Sakata  2016-01-08
1. Robert Szebtmihalyi  2016-01-08
1. Sebastian Cruz  2016-01-09
1. Brian Walker  2016-01-10
1. Mercado pmercado  2016-01-10
1. Gaurish Sharma  2016-01-10
1. Julien Berard  2016-01-11
1. John Bartko  2016-01-11
1. Javi Perez-Griffo  2016-01-12
1. Alex Bligh Flexiant Ltd 2016-01-12
1. Mercado pmercado Flexiant 2016-01-12
1. Alexey Melezhik  2016-01-12
1. Joe McIlvain  2016-01-13
1. Ross Kusler  2016-01-13
1. Jeffrey James  2016-01-14
1. Daniel Rich  2016-01-14
1. Jeffrey James COSProfessionals, LLC 2016-01-14
1. Kevin Bonner  2016-01-15
1. Andrew Burns  2016-01-15
1. René Martín Rodríguez  2016-01-16
1. Philip Watts  2016-01-18
1. Philip Watts REĀN Cloud Solutions LLC 2016-01-18
1. Fabricio Correa Duarte Bellacross Technologies, LLC 2016-01-18
1. Thomas Vincent  2016-01-18
1. Thomas Vincent Relenz 2016-01-18
1. Shaun Martin  2016-01-18
1. James Cuzella LyraPhase 2016-01-18
1. James Cuzella ReturnPath 2016-01-18
1. Riley Spicer  2016-01-19
1. Haggai Zagury Tikal Knowledge, SAP 2016-01-19
1. Enrico Stahn  2016-01-19
1. Ash Wilson CloudPassage 2016-01-20
1. Ben Bradshaw  2016-01-20
1. Nayan Hajratwala  2016-01-20
1. Sebastian Trebitz  2016-01-21
1. James Quinn  2016-01-21
1. Jose Luis Salas Topota 2016-01-21
1. joe miller Pantheon 2016-01-21
1. Sebastian Trebitz Sebastian Trebitz - ICT Consultancy Services 2016-01-21
1. Jade Chu AOL 2016-01-22
1. Dennis Vink  2016-01-22
1. Christopher Nielsen  2016-01-22
1. Dennis Vink Dennis Vink 2016-01-22
1. Hiroki Ohtsuka  2016-01-23
1. Eric Robitaille  2016-01-23
1. Jason Capriotti  2016-01-25
1. Artur Sitarski  2016-01-26
1. Darron Froese Datadog Inc. 2016-01-26
1. Steven Haddox  2016-01-26
1. Vipin Thomas  2016-01-27
1. Alexander Wagner  2016-01-27
1. Andrew Miller  2016-01-28
1. Drew Rapenchuk  2016-01-29
1. Drew Rapenchuk Bloomberg LP 2016-01-29
1. Sean Rettig  2016-01-29
1. Sumit Murari  2016-02-01
1. Jason Barnett NA 2016-02-02
1. Dave Rodecap  2016-02-02
1. James Pruetting Built by Robots 2016-02-02
1. Daniel Reznicek  2016-02-02
1. Yusuke Hagihara  2016-02-02
1. Joey Bates  2016-02-03
1. Chris Hayes  2016-02-03
1. Jarrett Hawrylak  2016-02-03
1. Demitri Swan  2016-02-04
1. Keith Swett  2016-02-04
1. Felix Yan  2016-02-04
1. RJ Martins  2016-02-04
1. Ashley Unitt NewVoiceMedia Ltd 2016-02-05
1. Craig Menning  2016-02-05
1. John Nye 7digital 2016-02-05
1. Geoffrey Rucker  2016-02-06
1. Abdelkrim Dib  2016-02-06
1. Christoffer Reijer  2016-02-07
1. Michael Skrynski dkd Internet Service GmbH 2016-02-08
1. David Newman  2016-02-08
1. John Northrup  2016-02-08
1. Dylan Ledbetter Dylan Ledbetter 2016-02-09
1. Richard Lee  2016-02-09
1. Maksim Horbul  2016-02-09
1. David Marshall  2016-02-09
1. Dylan Ledbetter  2016-02-09
1. Luuk van den Broek  2016-02-10
1. Luuk van den Broek  2016-02-10
1. Sergey Bahchissaraitsev  2016-02-11
1. Brad Parks  2016-02-11
1. Aoi Kadoya  2016-02-12
1. Bryan Gay  2016-02-12
1. Christopher Soyars  2016-02-12
1. Leandro Di Tommaso Mikroways 2016-02-13
1. Ricky Grassmuck  2016-02-13
1. Ricky Grassmuck Grassmuck.co 2016-02-13
1. Chris Allen  2016-02-14
1. Chris Allen Postmodern Solutions 2016-02-14
1. Luis Sagastume  2016-02-14
1. Andrii Melnyk  2016-02-16
1. Brad Parks  2016-02-16
1. Dang Nguyen  2016-02-16
1. Christian Willman  2016-02-16
1. Joshua Smith  2016-02-17
1. Owen Tuz  2016-02-18
1. A Moto Ohno!  2016-02-19
1. A Moto Ohno! Rally Health 2016-02-19
1. Wes Winham PolicyStat LLC 2016-02-19
1. Nic Waller  2016-02-19
1. Robert Scott-Buccluech  2016-02-19
1. Satish Puranam  2016-02-21
1. Ron Herardian  2016-02-21
1. Joel Freedman Pivotal Labs 2016-02-22
1. Gary Bright  2016-02-23
1. Paul Mitchell  2016-02-23
1. Will Jordan Code.org 2016-02-23
1. James Coppens Underground Media Group 2016-02-23
1. Thomas Robinson-Gore  2016-02-24
1. Bradley Corner  2016-02-25
1. Christophe Courtaut  2016-02-26
1. Rex Cerbas  2016-02-26
1. Juan Castillo Cano  2016-02-26
1. Jared Kauppila  2016-02-29
1. William Burton  2016-03-01
1. William Burton ENC4U 2016-03-01
1. Josh Beauregard  2016-03-01
1. Michael D'Auria  2016-03-01
1. Elijah Wright  2016-03-01
1. Anna Tikhonova  2016-03-02
1. James Bunch  2016-03-05
1. Harish Hareendra Babu  2016-03-07
1. mohanbabu balasubramaniam  2016-03-07
1. David Duponchel Mediarithmics 2016-03-07
1. Shane Ramey  2016-03-07
1. Zach Morgan Secureworks 2016-03-08
1. Victoria Jeffrey  2016-03-09
1. Jesse Cotton  2016-03-09
1. Christopher Gerber  2016-03-10
1. Pradeep Chhetri  2016-03-10
1. Dylan-Daniel Page  2016-03-10
1. Dmytro Slupytskyi  2016-03-10
1. Michael Weinberg Heavy Water Operations 2016-03-10
1. Steve Carman Planalytics 2016-03-11
1. Steve Carman  2016-03-11
1. Jonathan Serafini LightSpeed Retail 2016-03-13
1. Andrew Cornies  2016-03-13
1. Joshua Burt  2016-03-13
1. Dmytro Slupytskyi  2016-03-14
1. Julian Tabel  2016-03-14
1. Sergio Rua IT Projections Limited 2016-03-14
1. Sergio Rua  2016-03-14
1. Phil Spencer n/a 2016-03-15
1. Ben Abrams  2016-03-15
1. Dylan Canfield  2016-03-15
1. Nick Pjetrovic  2016-03-15
1. Phil Spencer  2016-03-15
1. Matt Kulka  2016-03-15
1. Ben Kochie  2016-03-16
1. Aaron Lippold  2016-03-16
1. Andy Brezinsky ShoreTel Inc. 2016-03-17
1. Michael Miko Apparently 2016-03-18
1. Marat Vyshegorodtsev  2016-03-18
1. Harald Krämer  2016-03-18
1. Marat Vyshegorodtsev  2016-03-19
1. Julian Tabel  2016-03-21
1. Christian Tramnitz TraSec GmbH 2016-03-21
1. Eike Waldt B1 Systems GmbH 2016-03-22
1. Thorsten Klein  2016-03-22
1. Andrew Stoltz  2016-03-22
1. Justin Schuhmann  2016-03-22
1. Duc Ha  2016-03-22
1. Jonathan Sokolowski  2016-03-22
1. Sean Coyne  2016-03-23
1. Antonio Beyah Beyah Solutions, LLC 2016-03-24
1. Graeme Fawcett  2016-03-24
1. Trey Tomlinson  2016-03-24
1. Onno van der Straaten  2016-03-25
1. Joshua Bussdieker  2016-03-26
1. Jean-Pierre Matsumoto  2016-03-29
1. Nicholas Waller  2016-03-29
1. Denny Pruitt  2016-03-29
1. Darryl Bresland  2016-03-30
1. Claus Beerta  2016-03-30
1. Vincenzo Rivello  2016-03-30
1. Pablo Banderas Inetsys SL 2016-03-30
1. Brandon Sharitt  2016-03-31
1. Eric Hartmann  2016-03-31
1. Steve Collins  2016-03-31
1. Greg Ziskind  2016-03-31
1. Cristiano Balducci  2016-03-31
1. Travis Thompson  2016-03-31
1. Martin Arndt  2016-03-31
1. Matthew Endsley  2016-04-01
1. Federico Gimenez  2016-04-01
1. Alex Pop  2016-04-01
1. Michael Fyffe  2016-04-01
1. Austin Heiman  2016-04-01
1. Tamas Szasz  2016-04-03
1. Jason Morgan  2016-04-04
1. Chris Trott  2016-04-05
1. Riley Shott  2016-04-06
1. Robert Ottaway  2016-04-06
1. Danny Webb  2016-04-06
1. Alexander Zubkov  2016-04-07
1. Maxwillian Miorim  2016-04-07
1. Alert Logic Inc.  2016-04-07
1. Mohammad AbuShady  2016-04-07
1. Mohammad AbuShady Instabug 2016-04-07
1. Ash Wilson  2016-04-07
1. Joe Sørensen  2016-04-07
1. Benny Chandra  2016-04-10
1. Brett Langdon  2016-04-10
1. Andrew Turner  2016-04-10
1. Stéphane Crivisier  2016-04-11
1. Adam Westhusing  2016-04-12
1. MARK AMERY  2016-04-12
1. Eric Olsen  2016-04-12
1. Cameron Straka  2016-04-13
1. Shuji Yamada  2016-04-14
1. Anirudh Gupta HPE 2016-04-14
1. Jack Naglieri  2016-04-16
1. Fabien Delpierre  2016-04-17
1. Florian Philippon S4M 2016-04-18
1. Michael Reeves  2016-04-18
1. Florian Philippon  2016-04-18
1. Logan McDonald  2016-04-18
1. Ferenc Kovács  2016-04-19
1. William Ruddock  2016-04-20
1. Anirudh Gupta  2016-04-21
1. Justin Dossey  2016-04-21
1. Daniel Jimenez ForeFlight LLC 2016-04-25
1. 3rd Felipe De Siqueira  2016-04-25
1. 3rd Felipe De Siqueira Anaplan 2016-04-25
1. Wilfried JEANNIARD  2016-04-26
1. Jeremiah Njoroge  2016-04-26
1. Tristan Morgan  2016-04-26
1. Hervé Commowick  2016-04-26
1. David Sieciński  2016-04-26
1. David Felix  2016-04-27
1. Travis Johnson  2016-04-27
1. Christopher Campo  2016-04-27
1. Frédéric Nowak Hydra Technologies, Inc 2016-04-28
1. Alan Thatcher  2016-04-28
1. Frédéric Nowak  2016-04-28
1. Frédéric Nowak  2016-04-28
1. Bastian Roden  2016-04-28
1. Seth Larson  2016-04-29
1. John Snow  2016-04-29
1. Tyler Vann-Campbell  2016-05-01
1. Carl Johnston  2016-05-02
1. Ben Weissmann  2016-05-02
1. Ankit Shah  2016-05-03
1. Grant Shively  2016-05-03
1. Apollo Catlin  2016-05-04
1. Chad Williamson  2016-05-04
1. Daniel Barrell  2016-05-05
1. Marcos Wright-Kuhns  2016-05-06
1. Chris Sullivan  2016-05-08
1. Ameir Abdeldayem  2016-05-08
1. Chris Sullivan  2016-05-09
1. Andrew Marwood  2016-05-09
1. Tejay Cardon  2016-05-10
1. Bryan Stone  2016-05-10
1. Rhea Ghosh  2016-05-10
1. Craig McEldowney Crifkin Amalgamated LLC 2016-05-11
1. Yuki Sonoda Gengo 2016-05-11
1. Ted Wang  2016-05-11
1. Craig McEldowney  2016-05-11
1. Taylor Benson  2016-05-11
1. Uwe Stuehler  2016-05-12
1. Joe Miller  2016-05-12
1. Franklin Webber  2016-05-13
1. Steohen Purr  2016-05-13
1. Jirka Fajfr  2016-05-16
1. Ming Xie  2016-05-16
1. Riley Shott Vision Critical 2016-05-16
1. Julia Tkachova  2016-05-17
1. Prashant Sharma  2016-05-17
1. Samuel Darwin  2016-05-17
1. Prajakta Purohit Chef 2016-05-17
1. Jessica Rosch iJet Technologies 2016-05-17
1. Michael Tognetti SendGrid, Inc. 2016-05-18
1. Christoph Blecker  2016-05-18
1. Stephen Breyer-Menke  2016-05-18
1. Reed McCartney  2016-05-20
1. Shane da Silva  2016-05-21
1. Administrator System  2016-05-21
1. Harley Alaniz  2016-05-22
1. Christopher Rigor  2016-05-24
1. Donald Guy  2016-05-25
1. Ajay Chand  2016-05-25
1. Timothy Cyrus  2016-05-26
1. JD Goins  2016-05-26
1. Jameson Goins  2016-05-26
1. Lajos Veres  2016-05-26
1. Justyn Shull  2016-05-27
1. MIURA Toru  2016-05-28
1. Adib Saad  2016-05-28
1. Uri Sarid Mulesoft 2016-05-29
1. Milad Rastian  2016-05-31
1. Denys Slipetskyy  2016-05-31
1. Trevor Lauder  2016-06-01
1. Ryan Punt  2016-06-01
1. Evan Machnic  2016-06-02
1. Leonid Ishimnikov  2016-06-03
1. Andrew Cooper  2016-06-03
1. Jose Ruiz  2016-06-03
1. Chris Morris  2016-06-04
1. Michael Vershinin  2016-06-04
1. Michael Vershinin SAP 2016-06-04
1. Winston Durand  2016-06-05
1. Bob Bob  2016-06-05
1. Mathieu Allaire  2016-06-05
1. pankaj khali  2016-06-06
1. Natacha Springer  2016-06-07
1. David Aronsohn  2016-06-07
1. Jason Clark  2016-06-08
1. Alexander Harder  2016-06-08
1. Timothy Bassett  2016-06-08
1. Annie Hedgpeth  2016-06-08
1. Emil Sit  2016-06-08
1. Alex Romanov  2016-06-09
1. Sebastian Geidies  2016-06-09
1. Todd Bushnell  2016-06-09
1. Nate Flood  2016-06-10
1. Eugene Slesarchuk  2016-06-10
1. Arnaldo Garat  2016-06-10
1. Matthew Walter  2016-06-12
1. Vlad Gorodetsky  2016-06-13
1. Ash Alam  2016-06-13
1. Vlad Gorodetsky Shopify 2016-06-13
1. Joseph Sokol-Margolis  2016-06-15
1. Jerry Aldrich Chef Software 2016-06-15
1. Jerry Aldrich  2016-06-15
1. Austin Vecchio  2016-06-17
1. Stephen Sadowski  2016-06-17
1. Cobus Bernard  2016-06-20
1. Rex Cerbas Rakuten Inc. 2016-06-21
1. Andy Allan  2016-06-21
1. Michael Gutteridge  2016-06-22
1. Michael Smith  2016-06-22
1. Michael Smith None 2016-06-22
1. Yuki Sonoda Gengo 2016-06-24
1. Jonathon Marshall  2016-06-24
1. Mike Sgarbossa  2016-06-25
1. Ryan Conrad  2016-06-25
1. Mark Bell  2016-06-28
1. Brynmor Rees The Regents of the University of Colorado 2016-06-28
1. Hugo Cisneiros  2016-06-28
1. Azat Khadiev  2016-06-29
1. Rob Reynolds  2016-06-29
1. Abhishek Kumar  2016-06-30
1. Travis Thompson Altiscale 2016-07-01
1. Jussi-Pekka Pispa Tampere University of Technology 2016-07-01
1. Henry Muru Paenga  2016-07-01
1. Alexander Dvorkovyy  2016-07-02
1. Pavel Jeloudovski  2016-07-03
1. Kyle Sexton  2016-07-05
1. Timothy  Kachler Atlas Digital 2016-07-05
1. Patrick Münch  2016-07-05
1. Stanley Hu  2016-07-06
1. Juan Cruz  2016-07-06
1. Jon Sime  2016-07-06
1. Erin Kolp  2016-07-07
1. Radoslaw Jaros  2016-07-07
1. Genadii Kruglenko  2016-07-08
1. Joseph Yaworski  2016-07-08
1. Randy Rue  2016-07-08
1. Jennifer Taylor  2016-07-09
1. max maxn  2016-07-09
1. Hank Ehly  2016-07-10
1. Jason McNew  2016-07-11
1. Luuk van den Broek  2016-07-11
1. Asher Yanich  2016-07-12
1. Asher Yanich Fastly 2016-07-12
1. Elkin Sierra  2016-07-12
1. Scott Nelson Windels  2016-07-13
1. Anton Markelov  2016-07-14
1. chris evett  2016-07-16
1. Kierran McPherson  2016-07-16
1. sathish mr  2016-07-18
1. Ryan LeViseur  2016-07-19
1. Andrew M. Kirschke  2016-07-19
1. Alexis Sellier  2016-07-21
1. Alex Trull  2016-07-21
1. Alex Trull  2016-07-22
1. Michael Weinberg  2016-07-25
1. Mathias Söderberg  2016-07-25
1. Ofir Petrushka  2016-07-25
1. Kevin Reedy  2016-07-26
1. Rein Remmel cloud.ee OÜ 2016-07-26
1. Jakub Jarosz  2016-07-26
1. James Krewson DreamBox Learning, Inc. 2016-07-27
1. Rein Remmel  2016-07-27
1. Matthew Odille  2016-07-28
1. Marcin Skurski  2016-07-28
1. Marcin Skurski Hostelworld 2016-07-28
1. Jose Luis Wazuh 2016-07-28
1. Oleksii Talamanov  2016-07-29
1. Robert Ressl  2016-07-31
1. David Aronsohn  2016-08-02
1. David Aronsohn  2016-08-02
1. Robert Jerzak  2016-08-02
1. Paulo Tada  2016-08-02
1. Martin Matatko  2016-08-03
1. Hugh Brown  2016-08-03
1. Achim Heger  2016-08-03
1. David McGrath  2016-08-05
1. Darwin Wu  2016-08-08
1. Gabor Boros  2016-08-08
1. David Pell  2016-08-08
1. Jere Julian Arista Networks 2016-08-10
1. Michael Schlies  2016-08-10
1. Libert Schmidt  2016-08-12
1. Rob Marano Totem Power, Inc. 2016-08-13
1. Rob Marano  2016-08-13
1. Anna Tikhonova  2016-08-15
1. Erik Gomez  2016-08-15
1. Evan Borgstrom  2016-08-15
1. Don Don  2016-08-16
1. Petre Ghita  2016-08-16
1. Jeff Mathe  2016-08-16
1. Josh McCleery  2016-08-16
1. Catalin Balan  2016-08-17
1. Sebastian Boschert  2016-08-17
1. Gemini Agaloos  2016-08-18
1. Georgi Lambov  2016-08-19
1. Baurzhan Konurbayev  2016-08-19
1. Thomas Berger Piratenpartei Deutschland 2016-08-20
1. Pavel Forkert  2016-08-20
1. Bipin Bachhao  2016-08-20
1. Janith Perera  2016-08-23
1. Artur Smolarek  2016-08-23
1. Joshua Wester  2016-08-24
1. Austin Simmons  2016-08-25
1. Nick Shemonsky  2016-08-25
1. Michał Sochoń  2016-08-25
1. Sathyajith Bhat  2016-08-26
1. Wesley Staples  2016-08-26
1. Mikhail kvokka  2016-08-27
1. Thajudheen Rajak  2016-08-28
1. Paul Maddocks  2016-08-28
1. Wisen Tanasa  2016-08-28
1. John Kerry  2016-08-29
1. Cem Guresci  2016-08-29
1. Juan Martinez  2016-08-30
1. Mohammad Sedighi  2016-08-30
1. Thiago Vinhas  2016-08-30
1. John Dewey  2016-08-30
1. John Harrison  2016-09-01
1. Jose Asuncion  2016-09-01
1. Valentin Dallmeier Testfabrik AG 2016-09-01
1. Greg Hellings B7Interactive, LLC 2016-09-06
1. Brian Bohanon Aaron's, Inc. 2016-09-07
1. Jeremy Miller  2016-09-07
1. Martin Mosegaard Amdisen  2016-09-07
1. Jeremy Miller PolyHat 2016-09-07
1. Joseph Block  2016-09-08
1. Stefan Wessels Beljaars Schuberg Philis 2016-09-09
1. Ben Dang  2016-09-09
1. Stefan Wessels Beljaars  2016-09-12
1. Steve Johnson  2016-09-12
1. Sudhanshu Thakur  2016-09-12
1. Ananda Babu  2016-09-12
1. enrico b  2016-09-12
1. enrico b  2016-09-12
1. Sudhanshu Thakur DataMetis 2016-09-12
1. Ananda Babu Nclouds Inc. 2016-09-12
1. Jeff Taylor  2016-09-13
1. JT Giri nclouds 2016-09-13
1. Jacob Wilkins  2016-09-13
1. Marques Johansson  2016-09-14
1. Stefan Wessels Beljaars SWB company 2016-09-14
1. Jordi Molina  2016-09-14
1. Michal Gebauer  2016-09-14
1. Joris van Lieshout  2016-09-14
1. Jean-Bernard Damiano Personnal 2016-09-15
1. Jean-Bernard Damiano  2016-09-15
1. Andrei Nakagawa Soltius NZ 2016-09-16
1. Jake Gage  2016-09-18
1. Karol Drazek  2016-09-19
1. Jye Lee  2016-09-19
1. Margaret Walker Chef Software, Inc 2016-09-20
1. Brian Bohanon  2016-09-20
1. Margaret Walker  2016-09-20
1. Roberto Mardeni  2016-09-21
1. Oleksii Vlasov  2016-09-21
1. Takuya Seki  2016-09-21
1. Brittany Smith  2016-09-24
1. Darren Campbell Primar Group 2016-09-26
1. Kevin Reedy  2016-09-26
1. Brian Lieberman  2016-09-26
1. Brian Lieberman Gannett 2016-09-26
1. Olaf Brandt etracker GmbH 2016-09-27
1. Chris Gerke  2016-09-28
1. Alex Pop  2016-09-28
1. Jean-Pierre Matsumoto Freelance 2016-09-28
1. Marc Arndt  2016-10-03
1. Nenad P  2016-10-03
1. Andrew Heller  2016-10-03
