// Copyright (c) 2011 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is meant for analyzing the code generated by the CHECK
// macros in a small executable file that's easy to disassemble.

#include "base/logging.h"

// An official build shouldn't generate code to print out messages for
// the CHECK* macros, nor should it have the strings in the
// executable.

void DoCheck(bool b) {
  CHECK(b) << "DoCheck " << b;
}

void DoCheckEq(int x, int y) {
  CHECK_EQ(x, y);
}

int main(int argc, const char* argv[]) {
  DoCheck(argc > 1);
  DoCheckEq(argc, 1);
}
